/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");


var aLots = new Arbre("Facturation/Tracabilite/list-numLot.tmpl", "listeLots");
var aSeries = new Arbre("Facturation/Tracabilite/list-numSerie.tmpl", "listeSeries");
var aDepotsLot = new Arbre("Facturation/Tracabilite/list-stockNumLot.tmpl", "listeDepotsLot");
var qListNL = new QueryHttp("Facturation/Tracabilite/getDataListNL.tmpl");
var qListNS = new QueryHttp("Facturation/Tracabilite/getDataListNS.tmpl");

var pageCouranteNL;
var nbPagesNL;

var pageCouranteNS;
var nbPagesNS;

var currentLotId = "";
var currentSerieId = "";



function init() {
  try {

		var config = getConfig();

		if (!config.isActSuiviSerie()) {
			document.getElementById("boxSeries").collapsed = true;
			document.getElementById("lblNumSerie").collapsed = true;
			document.getElementById("numSerie").collapsed = true;
			document.getElementById("bloqueSerie").collapsed = true;

			if (!config.isActSerieDLC()) {
				document.getElementById("colDatePeremptionNS").collapsed = true;
				document.getElementById("colDatePeremptionNS").setAttribute("ignoreincolumnpicker", true);
				document.getElementById("rowDatePeremptionNS").collapsed = true;
			}
		}

		if (!config.isActSuiviLot()) {
			document.getElementById("boxLots").collapsed = true;
			document.getElementById("lblNumLot").collapsed = true;
			document.getElementById("numLot").collapsed = true;
			document.getElementById("bloqueLot").collapsed = true;
			document.getElementById("rowNumeroLotNS").collapsed = true;
			document.getElementById("rowDatePeremptionLotNS").collapsed = true;

			document.getElementById("colNumeroLotNS").collapsed = true;
			document.getElementById("colNumeroLotNS").setAttribute("ignoreincolumnpicker", true);
			document.getElementById("colDatePeremptionLotNS").collapsed = true;
			document.getElementById("colDatePeremptionLotNS").setAttribute("ignoreincolumnpicker", true);
		}

	  document.getElementById('bRetourTracabilite').collapsed = true;

		var aLocalisation = new Arbre("ComboListe/combo-depotsStock.tmpl", "localisation");
	  aLocalisation.initTree();

	} catch (e) {
		recup_erreur(e);
  }
}


function rechercherClient() {
	try {

		var url = "chrome://opensi/content/facturation/user/clients/popup-rechercheClient.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', retourRechercherClient);

	} catch (e) {
		recup_erreur(e);
	}
}


function retourRechercherClient(numClient, clientId) {
	try {

		document.getElementById("numClient").value = numClient;

	} catch (e) {
		recup_erreur(e);
	}
}


function rechercherArticle() {
	try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', retourRechercherArticle);

	} catch (e) {
		recup_erreur(e);
	}
}


function retourRechercherArticle(reference, articleId) {
	try {

		document.getElementById("refArticle").value = reference;

	} catch (e) {
		recup_erreur(e);
	}
}


function rechercherFournisseur() {
	try {

		var url = "chrome://opensi/content/facturation/user/fournisseurs/popup-rechercheFournisseur.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', retourRechercherFournisseur);

	} catch (e) {
		recup_erreur(e);
	}
}


function retourRechercherFournisseur(numFournisseur, fournisseurId) {
	try {

		document.getElementById("numFournisseur").value = numFournisseur;

	} catch (e) {
		recup_erreur(e);
	}
}


function retourMenuTracabilite() {
	try {

		document.getElementById('pdf').setAttribute("src", "");
		document.getElementById('bRetourTracabilite').collapsed = true;
		document.getElementById('deckPDF').selectedIndex = 0;

	} catch (e) {
		recup_erreur(e);
	}
}


function retourMenuPrincipal() {
  try {

    window.location = "chrome://opensi/content/facturation/user/menu_principal.xul";

	} catch (e) {
		recup_erreur(e);
  }
}


function listerTout() {
	try {

		var ok = listerLots();
		if (ok) {
			listerSeries();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnCritere(ev) {
	try {

		if (ev.keyCode==13) {
			listerTout();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function initCriteres() {
	try {

		document.getElementById("numLot").value = "";
		document.getElementById("numClient").value = "";
		document.getElementById("datePeremptionDebut").value = "";
		document.getElementById("datePeremptionFin").value = "";
		document.getElementById("bloqueLot").checked = false;
		document.getElementById("numSerie").value = "";
		document.getElementById("numFournisseur").value = "";
		document.getElementById("nbMois").value = "";
		document.getElementById("bloqueSerie").checked = false;
		document.getElementById("refArticle").value = "";
		document.getElementById("localisation").value = "";

		listerLots();
		listerSeries();

	} catch (e) {
		recup_erreur(e);
	}
}



// NUMEROS DE LOT


function listerLots() {
	try {

		var ok = false;

		var numero = document.getElementById("numLot").value;
		var numClient = document.getElementById("numClient").value;
		var datePeremptionDebut = document.getElementById("datePeremptionDebut").value;
		var datePeremptionFin = document.getElementById("datePeremptionFin").value;
		var bloque = document.getElementById("bloqueLot").checked;
		var numFournisseur = document.getElementById("numFournisseur").value;
		var refArticle = document.getElementById("refArticle").value;
		var nbMois = document.getElementById("nbMois").value;
		var localisation = document.getElementById("localisation").value;
		var nbLignesParPage = document.getElementById('nbLignesParPageNL').value;

		if (!isEmpty(datePeremptionDebut) && !isDate(datePeremptionDebut)) { showWarning("Date de d\u00E9but incorrecte"); }
		else if (!isEmpty(datePeremptionFin) && !isDate(datePeremptionFin)) { showWarning("Date de fin incorrecte"); }
		else if (!isEmpty(datePeremptionDebut) && !isEmpty(datePeremptionFin) && !isDateInterval(datePeremptionDebut, datePeremptionFin)) { showWarning("Plage de dates incorrecte"); }
		else if (!isEmpty(nbMois) && !isPositiveInteger(nbMois)) { showWarning("Nombre de mois incorrect"); }
		else {

			ok = true;

			pageCouranteNL = 1;
			nbPagesNL = 1;
			document.getElementById('pageDebNL').value = 1;
			document.getElementById('pageFinNL').value = 1;
			document.getElementById('bPrecNL').disabled = true;
			document.getElementById('bSuivNL').disabled = true;

			document.getElementById('listeLots').disabled = true;
			document.getElementById("bEditionLotCSV").disabled = true;
			document.getElementById("bEtatStocksLotCSV").disabled = true;
			aLots.deleteTree();

			qListNL.setParam("Numero", numero);
			qListNL.setParam("Num_Client", numClient);
			qListNL.setParam("Date_Peremption_Debut", datePeremptionDebut);
			qListNL.setParam("Date_Peremption_Fin", datePeremptionFin);
			qListNL.setParam("Bloque", bloque);
			qListNL.setParam("Num_Fournisseur", numFournisseur);
			qListNL.setParam("Ref_Article", refArticle);
			qListNL.setParam("Nb_Mois", nbMois);
			qListNL.setParam("Localisation", localisation);
			qListNL.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
			qListNL.setParam("Current_Page", pageCouranteNL);

			var result = qListNL.execute();

			var contenu = result.responseXML.documentElement;

			document.getElementById('nbResultatsNL').value = contenu.getAttribute("Nb_Resultats");
			nbPagesNL = contenu.getAttribute("Nb_Pages");
			var listLotId = contenu.getAttribute("List_Lot_Id");

			aLots.setParam("List_Lot_Id", listLotId);
			aLots.initTree(initPaginationNL);
		}

		return ok;

	} catch (e) {
		recup_erreur(e);
	}
}


function initPaginationNL() {
	try {

		document.getElementById('pageDebNL').value = pageCouranteNL;
		document.getElementById('pageFinNL').value = (nbPagesNL>0?nbPagesNL:1);
		document.getElementById('bPrecNL').disabled = (pageCouranteNL==1);
		document.getElementById('bSuivNL').disabled = (pageCouranteNL>=nbPagesNL); // peut se produire si nbPagesNL=0

		afterMajPaginationNL();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPagePrecNL() {
	try {

		pageCouranteNL--;
		majPaginationNL();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPageSuivNL() {
	try {

		pageCouranteNL++;
		majPaginationNL();

	} catch (e) {
		recup_erreur(e);
	}
}


function majPaginationNL() {
	try {

		document.getElementById('pageDebNL').value = pageCouranteNL;
		document.getElementById('bPrecNL').disabled = (pageCouranteNL==1);
		document.getElementById('bSuivNL').disabled = (pageCouranteNL==nbPagesNL);

		document.getElementById('listeLots').disabled = true;
		document.getElementById("bEditionLotCSV").disabled = true;
		document.getElementById("bEtatStocksLotCSV").disabled = true;

		qListNL.setParam("Current_Page", pageCouranteNL);
		var result = qListNL.execute();
		var listLotId = result.responseXML.documentElement.getAttribute("List_Lot_Id");

		aLots.setParam("List_Lot_Id", listLotId);
		aLots.initTree(afterMajPaginationNL);

	} catch (e) {
		recup_erreur(e);
	}
}


function afterMajPaginationNL() {
	try {

		document.getElementById('listeLots').disabled = false;
		document.getElementById("bEditionLotCSV").disabled = (aLots.nbLignes()==0);
		document.getElementById("bEtatStocksLotCSV").disabled = (aLots.nbLignes()==0);

	} catch (e) {
		recup_erreur(e);
	}
}


function selectOnListeLots() {
	try {

		if (aLots.isSelected()) {
			currentLotId = aLots.getSelectedCellText('LotId');
			chargerNumLot();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function chargerNumLot() {
	try {

		aDepotsLot.setParam("Lot_Id", currentLotId);
		aDepotsLot.initTree();

		var qLoad = new QueryHttp("Facturation/Tracabilite/loadNumLot.tmpl");
		qLoad.setParam("Lot_Id", currentLotId);
		var result = qLoad.execute();

		var contenu = result.responseXML.documentElement;

		document.getElementById("numeroLotNL").value = contenu.getAttribute("Numero");
		document.getElementById("datePeremptionNL").value = contenu.getAttribute("Date_Peremption");
		document.getElementById("referenceNL").value = contenu.getAttribute("Reference");
		document.getElementById("quantiteClientNL").value = contenu.getAttribute("Qte_Client");
		document.getElementById("quantiteFournisseurNL").value = contenu.getAttribute("Qte_Fournisseur");
		document.getElementById("quantiteStockNL").value = contenu.getAttribute("Qte_Stock");
		document.getElementById("lastReceptionNL").value = contenu.getAttribute("Date_Reception");
		document.getElementById("lastLivraisonNL").value = contenu.getAttribute("Date_Livraison");
		document.getElementById("lastRetClientNL").value = contenu.getAttribute("Date_Retour_Client");
		document.getElementById("lastRetFournisseurNL").value = contenu.getAttribute("Date_Retour_Fournisseur");

		document.getElementById("bClientsLotCSV").disabled = parseFloat(contenu.getAttribute("Qte_Client"))<=0;
		document.getElementById("bSuiviLotCSV").disabled = false;
		document.getElementById("bSuiviLotPDF").disabled = false;

		if (contenu.getAttribute("Bloque")=="true") {
			document.getElementById("imgBlocageLot").setAttribute("src","chrome://opensi/content/design/cadenas.png");
			document.getElementById("bComBlocageLot").collapsed = false;
			document.getElementById("bBlocageLot").collapsed = true;
			document.getElementById("bDeblocageLot").collapsed = false;
		}
		else {
			document.getElementById("imgBlocageLot").removeAttribute("src");
			document.getElementById("bComBlocageLot").collapsed = true;
			document.getElementById("bBlocageLot").collapsed = false;
			document.getElementById("bDeblocageLot").collapsed = true;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ouvrirCommentairesBlocageLot() {
	try {

		var url = "chrome://opensi/content/facturation/user/tracabilite_articles/popup-commentairesBlocageLot.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', currentLotId);

	} catch (e) {
		recup_erreur(e);
	}
}


function bloquerNumLot() {
	try {

		var numero = document.getElementById('numeroLotNL').value;

		if (window.confirm("Confirmez-vous le blocage du n\u00B0 de lot "+ numero +" ?")) {
			var qLock = new QueryHttp("Facturation/Tracabilite/lockNumLot.tmpl");
			qLock.setParam("Lot_Id", currentLotId);
			var result = qLock.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				ouvrirCommentairesBlocageLot();
				document.getElementById("imgBlocageLot").setAttribute("src","chrome://opensi/content/design/cadenas.png");
				document.getElementById("bComBlocageLot").collapsed = false;
				document.getElementById("bBlocageLot").collapsed = true;
				document.getElementById("bDeblocageLot").collapsed = false;
			}

			listerTout();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function debloquerNumLot() {
	try {

		var numero = document.getElementById('numeroLotNL').value;

		if (window.confirm("Confirmez-vous le d\u00E9blocage du n\u00B0 de lot "+ numero +" ?")) {
			var qLock = new QueryHttp("Facturation/Tracabilite/unlockNumLot.tmpl");
			qLock.setParam("Lot_Id", currentLotId);
			var result = qLock.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				document.getElementById("imgBlocageLot").removeAttribute("src");
				document.getElementById("bComBlocageLot").collapsed = true;
				document.getElementById("bBlocageLot").collapsed = false;
				document.getElementById("bDeblocageLot").collapsed = true;
			}

			listerTout();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function editionLotCSV() {
	try {

		var numero = document.getElementById("numLot").value;
		var numClient = document.getElementById("numClient").value;
		var datePeremptionDebut = document.getElementById("datePeremptionDebut").value;
		var datePeremptionFin = document.getElementById("datePeremptionFin").value;
		var bloque = document.getElementById("bloqueLot").checked;
		var numFournisseur = document.getElementById("numFournisseur").value;
		var refArticle = document.getElementById("refArticle").value;
		var nbMois = document.getElementById("nbMois").value;
		var localisation = document.getElementById("localisation").value;

		if (!isEmpty(datePeremptionDebut) && !isDate(datePeremptionDebut)) { showWarning("Date de d\u00E9but incorrecte"); }
		else if (!isEmpty(datePeremptionFin) && !isDate(datePeremptionFin)) { showWarning("Date de fin incorrecte"); }
		else if (!isEmpty(datePeremptionDebut) && !isEmpty(datePeremptionFin) && !isDateInterval(datePeremptionDebut, datePeremptionFin)) { showWarning("Plage de dates incorrecte"); }
		else if (!isEmpty(nbMois) && !isPositiveInteger(nbMois)) { showWarning("Nombre de mois incorrect"); }
		else {
			var qEditCSV = new QueryHttp("Facturation/Tracabilite/csvNumLot.tmpl");

			qEditCSV.setParam("Numero", numero);
			qEditCSV.setParam("Num_Client", numClient);
			qEditCSV.setParam("Date_Peremption_Debut", datePeremptionDebut);
			qEditCSV.setParam("Date_Peremption_Fin", datePeremptionFin);
			qEditCSV.setParam("Bloque", bloque);
			qEditCSV.setParam("Num_Fournisseur", numFournisseur);
			qEditCSV.setParam("Ref_Article", refArticle);
			qEditCSV.setParam("Nb_Mois", nbMois);
			qEditCSV.setParam("Localisation", localisation);

			var result = qEditCSV.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');
				var file = fileChooser("save", fichier);
				if (file!=null) {
					downloadFile(getDirBuffer()+ fichier, file);
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function editionEtatStocksLotCSV() {
	try {

		var numero = document.getElementById("numLot").value;
		var numClient = document.getElementById("numClient").value;
		var datePeremptionDebut = document.getElementById("datePeremptionDebut").value;
		var datePeremptionFin = document.getElementById("datePeremptionFin").value;
		var bloque = document.getElementById("bloqueLot").checked;
		var numFournisseur = document.getElementById("numFournisseur").value;
		var refArticle = document.getElementById("refArticle").value;
		var nbMois = document.getElementById("nbMois").value;
		var localisation = document.getElementById("localisation").value;

		if (!isEmpty(datePeremptionDebut) && !isDate(datePeremptionDebut)) { showWarning("Date de d\u00E9but incorrecte"); }
		else if (!isEmpty(datePeremptionFin) && !isDate(datePeremptionFin)) { showWarning("Date de fin incorrecte"); }
		else if (!isEmpty(datePeremptionDebut) && !isEmpty(datePeremptionFin) && !isDateInterval(datePeremptionDebut, datePeremptionFin)) { showWarning("Plage de dates incorrecte"); }
		else if (!isEmpty(nbMois) && !isPositiveInteger(nbMois)) { showWarning("Nombre de mois incorrect"); }
		else {
			var qEditCSV = new QueryHttp("Facturation/Tracabilite/csvEtatStocksLot.tmpl");

			qEditCSV.setParam("Numero", numero);
			qEditCSV.setParam("Num_Client", numClient);
			qEditCSV.setParam("Date_Peremption_Debut", datePeremptionDebut);
			qEditCSV.setParam("Date_Peremption_Fin", datePeremptionFin);
			qEditCSV.setParam("Bloque", bloque);
			qEditCSV.setParam("Num_Fournisseur", numFournisseur);
			qEditCSV.setParam("Ref_Article", refArticle);
			qEditCSV.setParam("Nb_Mois", nbMois);
			qEditCSV.setParam("Localisation", localisation);

			var result = qEditCSV.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');
				var file = fileChooser("save", fichier);
				if (file!=null) {
					downloadFile(getDirBuffer()+ fichier, file);
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function editionEcartsStocksLotCSV() {
	try {

		var qEditCSV = new QueryHttp("Facturation/Tracabilite/csvEcartsStocksLot.tmpl");

		var result = qEditCSV.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');
			var file = fileChooser("save", fichier);
			if (file!=null) {
				downloadFile(getDirBuffer()+ fichier, file);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function editionClientsLotCSV() {
	try {

		var qEditCSV = new QueryHttp("Facturation/Tracabilite/csvClientsLot.tmpl");
		qEditCSV.setParam("Lot_Id", currentLotId);
		var result = qEditCSV.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');
			var file = fileChooser("save", fichier);
			if (file!=null) {
				downloadFile(getDirBuffer()+ fichier, file);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function editionSuiviLotCSV() {
	try {

		var qEditCSV = new QueryHttp("Facturation/Tracabilite/csvSuiviLot.tmpl");
		qEditCSV.setParam("Lot_Id", currentLotId);
		var result = qEditCSV.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');
			var file = fileChooser("save", fichier);
			if (file!=null) {
				downloadFile(getDirBuffer()+ fichier, file);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function editionSuiviLotPDF() {
	try {

		var qEditPDF = new QueryHttp("Facturation/Tracabilite/pdfSuiviLot.tmpl");
		qEditPDF.setParam("Lot_Id", currentLotId);
		var result = qEditPDF.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			document.getElementById('deckPDF').selectedIndex = 1;
			document.getElementById('bRetourTracabilite').collapsed = false;

			var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
			document.getElementById('pdf').setAttribute("src", page);
		}

	} catch (e) {
		recup_erreur(e);
	}
}



// NUMEROS DE SERIE


function listerSeries() {
	try {

		var numero = document.getElementById("numSerie").value;
		var numLot = document.getElementById("numLot").value;
		var numClient = document.getElementById("numClient").value;
		var datePeremptionDebut = document.getElementById("datePeremptionDebut").value;
		var datePeremptionFin = document.getElementById("datePeremptionFin").value;
		var bloque = document.getElementById("bloqueSerie").checked;
		var numFournisseur = document.getElementById("numFournisseur").value;
		var refArticle = document.getElementById("refArticle").value;
		var nbMois = document.getElementById("nbMois").value;
		var localisation = document.getElementById("localisation").value;
		var nbLignesParPage = document.getElementById('nbLignesParPageNS').value;

		if (!isEmpty(datePeremptionDebut) && !isDate(datePeremptionDebut)) { showWarning("Date de d\u00E9but incorrecte"); }
		else if (!isEmpty(datePeremptionFin) && !isDate(datePeremptionFin)) { showWarning("Date de fin incorrecte"); }
		else if (!isEmpty(datePeremptionDebut) && !isEmpty(datePeremptionFin) && !isDateInterval(datePeremptionDebut, datePeremptionFin)) { showWarning("Plage de dates incorrecte"); }
		else if (!isEmpty(nbMois) && !isPositiveInteger(nbMois)) { showWarning("Nombre de mois incorrect"); }
		else {

			pageCouranteNS = 1;
			nbPagesNS = 1;
			document.getElementById('pageDebNS').value = 1;
			document.getElementById('pageFinNS').value = 1;
			document.getElementById('bPrecNS').disabled = true;
			document.getElementById('bSuivNS').disabled = true;

			document.getElementById('listeSeries').disabled = true;
			document.getElementById("bEditionSerieCSV").disabled = true;
			document.getElementById("bEtatStocksSerieCSV").disabled = true;
			aSeries.deleteTree();

			qListNS.setParam("Numero", numero);
			qListNS.setParam("Num_Lot", numLot);
			qListNS.setParam("Num_Client", numClient);
			qListNS.setParam("Date_Peremption_Debut", datePeremptionDebut);
			qListNS.setParam("Date_Peremption_Fin", datePeremptionFin);
			qListNS.setParam("Bloque", bloque);
			qListNS.setParam("Num_Fournisseur", numFournisseur);
			qListNS.setParam("Ref_Article", refArticle);
			qListNS.setParam("Nb_Mois", nbMois);
			qListNS.setParam("Localisation", localisation);
			qListNS.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
			qListNS.setParam("Current_Page", pageCouranteNS);

			var result = qListNS.execute();

			var contenu = result.responseXML.documentElement;

			document.getElementById('nbResultatsNS').value = contenu.getAttribute("Nb_Resultats");
			nbPagesNS = contenu.getAttribute("Nb_Pages");
			var listSerieId = contenu.getAttribute("List_Serie_Id");

			aSeries.setParam("List_Serie_Id", listSerieId);
			aSeries.initTree(initPaginationNS);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function initPaginationNS() {
	try {

		document.getElementById('pageDebNS').value = pageCouranteNS;
		document.getElementById('pageFinNS').value = (nbPagesNS>0?nbPagesNS:1);
		document.getElementById('bPrecNS').disabled = (pageCouranteNS==1);
		document.getElementById('bSuivNS').disabled = (pageCouranteNS>=nbPagesNS); // peut se produire si nbPagesNS=0

		afterMajPaginationNS();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPagePrecNS() {
	try {

		pageCouranteNS--;
		majPaginationNS();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPageSuivNS() {
	try {

		pageCouranteNS++;
		majPaginationNS();

	} catch (e) {
		recup_erreur(e);
	}
}


function majPaginationNS() {
	try {

		document.getElementById('pageDebNS').value = pageCouranteNS;
		document.getElementById('bPrecNS').disabled = (pageCouranteNS==1);
		document.getElementById('bSuivNS').disabled = (pageCouranteNS==nbPagesNS);

		document.getElementById('listeSeries').disabled = true;
		document.getElementById("bEditionSerieCSV").disabled = true;
		document.getElementById("bEtatStocksSerieCSV").disabled = true;

		qListNS.setParam("Current_Page", pageCouranteNS);
		var result = qListNS.execute();
		var listSerieId = result.responseXML.documentElement.getAttribute("List_Serie_Id");

		aSeries.setParam("List_Serie_Id", listSerieId);
		aSeries.initTree(afterMajPaginationNS);

	} catch (e) {
		recup_erreur(e);
	}
}


function afterMajPaginationNS() {
	try {

		document.getElementById('listeSeries').disabled = false;
		document.getElementById("bEditionSerieCSV").disabled = (aSeries.nbLignes()==0);
		document.getElementById("bEtatStocksSerieCSV").disabled = (aSeries.nbLignes()==0);

	} catch (e) {
		recup_erreur(e);
	}
}


function selectOnListeSeries() {
	try {

		if (aSeries.isSelected()) {
			currentSerieId = aSeries.getSelectedCellText('SerieId');
			chargerNumSerie();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function chargerNumSerie() {
	try {

		var qLoad = new QueryHttp("Facturation/Tracabilite/loadNumSerie.tmpl");
		qLoad.setParam("Serie_Id", currentSerieId);
		var result = qLoad.execute();

		var contenu = result.responseXML.documentElement;

		document.getElementById("numeroSerieNS").value = contenu.getAttribute("Numero");
		document.getElementById("referenceNS").value = contenu.getAttribute("Reference");
		document.getElementById("numeroLotNS").value = contenu.getAttribute("Num_Lot");
		document.getElementById("datePeremptionNS").value = contenu.getAttribute("Date_Peremption_NS");
		document.getElementById("datePeremptionLotNS").value = contenu.getAttribute("Date_Peremption_NL");
		document.getElementById("lastReceptionNS").value = contenu.getAttribute("Date_Reception");
		document.getElementById("lastLivraisonNS").value = contenu.getAttribute("Date_Livraison");
		document.getElementById("lastRetClientNS").value = contenu.getAttribute("Date_Retour_Client");
		document.getElementById("lastRetFournisseurNS").value = contenu.getAttribute("Date_Retour_Fournisseur");		
		document.getElementById("serieContenantNS").value = contenu.getAttribute("Serie_Contenant");
		document.getElementById("refContenantNS").value = contenu.getAttribute("Ref_Contenant");
		
		var hasContenant = !isEmpty(contenu.getAttribute("Serie_Contenant"));
		document.getElementById("rowTitreContenantNS").collapsed = !hasContenant;
		document.getElementById("rowSerieContenantNS").collapsed = !hasContenant;
		document.getElementById("rowRefContenantNS").collapsed = !hasContenant;

		document.getElementById("bSuiviSerieCSV").disabled = false;
		document.getElementById("bSuiviSeriePDF").disabled = false;
		document.getElementById("bClientsSerieCSV").disabled = true;

		if (contenu.getAttribute("Bloque")=="true") {
			document.getElementById("imgBlocageSerie").setAttribute("src","chrome://opensi/content/design/cadenas.png");
			document.getElementById("bComBlocageSerie").collapsed = false;
			document.getElementById("bBlocageSerie").collapsed = true;
			document.getElementById("bDeblocageSerie").collapsed = false;
		}
		else {
			document.getElementById("imgBlocageSerie").removeAttribute("src");
			document.getElementById("bComBlocageSerie").collapsed = true;
			document.getElementById("bBlocageSerie").collapsed = false;
			document.getElementById("bDeblocageSerie").collapsed = true;
		}

		document.getElementById("localisationNS").value = "";
		document.getElementById("denominationNS").value = "";
		document.getElementById("adresse1NS").value = "";
		document.getElementById("adresse2NS").value = "";
		document.getElementById("adresse3NS").value = "";
		document.getElementById("cpVilleNS").value = "";

		var clientId = contenu.getAttribute("Client_Id");
		var fournisseurId = contenu.getAttribute("Fournisseur_Id");
		var depotId = contenu.getAttribute("Depot_Id");

		if (!isEmpty(clientId)) {
			var qLocalisation = new QueryHttp("Facturation/Clients/loadFicheClient.tmpl");
			qLocalisation.setParam("Client_Id", clientId);
			var resLoc = qLocalisation.execute();
			var localisation = resLoc.responseXML.documentElement;

			document.getElementById("localisationNS").value = "Chez le client : "+ localisation.getAttribute("Num_Client");
			document.getElementById("denominationNS").value = localisation.getAttribute("Denomination");
			document.getElementById("adresse1NS").value = localisation.getAttribute("Adresse_1");
			document.getElementById("adresse2NS").value = localisation.getAttribute("Adresse_2");
			document.getElementById("adresse3NS").value = localisation.getAttribute("Adresse_3");
			document.getElementById("cpVilleNS").value = localisation.getAttribute("Code_Postal") +" "+ localisation.getAttribute("Ville");

			document.getElementById("bClientsSerieCSV").disabled = false;
		}
		else if (!isEmpty(fournisseurId)) {
			var qLocalisation = new QueryHttp("Facturation/Fournisseurs/loadFicheFournisseur.tmpl");
			qLocalisation.setParam("Fournisseur_Id", fournisseurId);
			var resLoc = qLocalisation.execute();
			var localisation = resLoc.responseXML.documentElement;

			document.getElementById("localisationNS").value = "Chez le fournisseur : "+ localisation.getAttribute("Num_Fournisseur");
			document.getElementById("denominationNS").value = localisation.getAttribute("Denomination");
			document.getElementById("adresse1NS").value = localisation.getAttribute("Adresse_1");
			document.getElementById("adresse2NS").value = localisation.getAttribute("Adresse_2");
			document.getElementById("adresse3NS").value = localisation.getAttribute("Adresse_3");
			document.getElementById("cpVilleNS").value = localisation.getAttribute("Code_Postal") +" "+ localisation.getAttribute("Ville");
		}
		else if (!isEmpty(depotId)) {
			var qLocalisation = new QueryHttp("Facturation/Commun/getDepotStock.tmpl");
			qLocalisation.setParam("Depot_Id", depotId);
			var resLoc = qLocalisation.execute();

			document.getElementById("localisationNS").value = "D\u00E9p\u00F4t de stock : "+ resLoc.responseXML.documentElement.getAttribute("Intitule");
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ouvrirCommentairesBlocageSerie() {
	try {

		var url = "chrome://opensi/content/facturation/user/tracabilite_articles/popup-commentairesBlocageSerie.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', currentSerieId);

	} catch (e) {
		recup_erreur(e);
	}
}


function bloquerNumSerie() {
	try {

		var numero = document.getElementById('numeroSerieNS').value;

		if (window.confirm("Confirmez-vous le blocage du n\u00B0 de serie "+ numero +" ?")) {
			var qLock = new QueryHttp("Facturation/Tracabilite/lockNumSerie.tmpl");
			qLock.setParam("Serie_Id", currentSerieId);
			var result = qLock.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				ouvrirCommentairesBlocageSerie();
				document.getElementById("imgBlocageSerie").setAttribute("src","chrome://opensi/content/design/cadenas.png");
				document.getElementById("bComBlocageSerie").collapsed = false;
				document.getElementById("bBlocageSerie").collapsed = true;
				document.getElementById("bDeblocageSerie").collapsed = false;
			}

			listerTout();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function debloquerNumSerie() {
	try {

		var numero = document.getElementById('numeroSerieNS').value;

		if (window.confirm("Confirmez-vous le d\u00E9blocage du n\u00B0 de serie "+ numero +" ?")) {
			var qLock = new QueryHttp("Facturation/Tracabilite/unlockNumSerie.tmpl");
			qLock.setParam("Serie_Id", currentSerieId);
			var result = qLock.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				document.getElementById("imgBlocageSerie").removeAttribute("src");
				document.getElementById("bComBlocageSerie").collapsed = true;
				document.getElementById("bBlocageSerie").collapsed = false;
				document.getElementById("bDeblocageSerie").collapsed = true;
			}

			listerTout();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function editionSerieCSV() {
	try {

		var numero = document.getElementById("numSerie").value;
		var numLot = document.getElementById("numLot").value;
		var numClient = document.getElementById("numClient").value;
		var datePeremptionDebut = document.getElementById("datePeremptionDebut").value;
		var datePeremptionFin = document.getElementById("datePeremptionFin").value;
		var bloque = document.getElementById("bloqueSerie").checked;
		var numFournisseur = document.getElementById("numFournisseur").value;
		var refArticle = document.getElementById("refArticle").value;
		var nbMois = document.getElementById("nbMois").value;
		var localisation = document.getElementById("localisation").value;

		if (!isEmpty(datePeremptionDebut) && !isDate(datePeremptionDebut)) { showWarning("Date de d\u00E9but incorrecte"); }
		else if (!isEmpty(datePeremptionFin) && !isDate(datePeremptionFin)) { showWarning("Date de fin incorrecte"); }
		else if (!isEmpty(datePeremptionDebut) && !isEmpty(datePeremptionFin) && !isDateInterval(datePeremptionDebut, datePeremptionFin)) { showWarning("Plage de dates incorrecte"); }
		else if (!isEmpty(nbMois) && !isPositiveInteger(nbMois)) { showWarning("Nombre de mois incorrect"); }
		else {
			var qEditCSV = new QueryHttp("Facturation/Tracabilite/csvNumSerie.tmpl");

			qEditCSV.setParam("Numero", numero);
			qEditCSV.setParam("Num_Lot", numLot);
			qEditCSV.setParam("Num_Client", numClient);
			qEditCSV.setParam("Date_Peremption_Debut", datePeremptionDebut);
			qEditCSV.setParam("Date_Peremption_Fin", datePeremptionFin);
			qEditCSV.setParam("Bloque", bloque);
			qEditCSV.setParam("Num_Fournisseur", numFournisseur);
			qEditCSV.setParam("Ref_Article", refArticle);
			qEditCSV.setParam("Nb_Mois", nbMois);
			qEditCSV.setParam("Localisation", localisation);

			var result = qEditCSV.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');
				var file = fileChooser("save", fichier);
				if (file!=null) {
					downloadFile(getDirBuffer()+ fichier, file);
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function editionEtatStocksSerieCSV() {
	try {

		var numero = document.getElementById("numSerie").value;
		var numLot = document.getElementById("numLot").value;
		var numClient = document.getElementById("numClient").value;
		var datePeremptionDebut = document.getElementById("datePeremptionDebut").value;
		var datePeremptionFin = document.getElementById("datePeremptionFin").value;
		var bloque = document.getElementById("bloqueSerie").checked;
		var numFournisseur = document.getElementById("numFournisseur").value;
		var refArticle = document.getElementById("refArticle").value;
		var nbMois = document.getElementById("nbMois").value;
		var localisation = document.getElementById("localisation").value;

		if (!isEmpty(datePeremptionDebut) && !isDate(datePeremptionDebut)) { showWarning("Date de d\u00E9but incorrecte"); }
		else if (!isEmpty(datePeremptionFin) && !isDate(datePeremptionFin)) { showWarning("Date de fin incorrecte"); }
		else if (!isEmpty(datePeremptionDebut) && !isEmpty(datePeremptionFin) && !isDateInterval(datePeremptionDebut, datePeremptionFin)) { showWarning("Plage de dates incorrecte"); }
		else if (!isEmpty(nbMois) && !isPositiveInteger(nbMois)) { showWarning("Nombre de mois incorrect"); }
		else {
			var qEditCSV = new QueryHttp("Facturation/Tracabilite/csvEtatStocksSerie.tmpl");

			qEditCSV.setParam("Numero", numero);
			qEditCSV.setParam("Num_Lot", numLot);
			qEditCSV.setParam("Num_Client", numClient);
			qEditCSV.setParam("Date_Peremption_Debut", datePeremptionDebut);
			qEditCSV.setParam("Date_Peremption_Fin", datePeremptionFin);
			qEditCSV.setParam("Bloque", bloque);
			qEditCSV.setParam("Num_Fournisseur", numFournisseur);
			qEditCSV.setParam("Ref_Article", refArticle);
			qEditCSV.setParam("Nb_Mois", nbMois);
			qEditCSV.setParam("Localisation", localisation);

			var result = qEditCSV.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');
				var file = fileChooser("save", fichier);
				if (file!=null) {
					downloadFile(getDirBuffer()+ fichier, file);
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function editionClientsSerieCSV() {
	try {

		var qEditCSV = new QueryHttp("Facturation/Tracabilite/csvClientsSerie.tmpl");
		qEditCSV.setParam("Serie_Id", currentSerieId);
		var result = qEditCSV.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');
			var file = fileChooser("save", fichier);
			if (file!=null) {
				downloadFile(getDirBuffer()+ fichier, file);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function editionSuiviSerieCSV() {
	try {

		var qEditCSV = new QueryHttp("Facturation/Tracabilite/csvSuiviSerie.tmpl");
		qEditCSV.setParam("Serie_Id", currentSerieId);
		var result = qEditCSV.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');
			var file = fileChooser("save", fichier);
			if (file!=null) {
				downloadFile(getDirBuffer()+ fichier, file);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function editionSuiviSeriePDF() {
	try {

		var qEditPDF = new QueryHttp("Facturation/Tracabilite/pdfSuiviSerie.tmpl");
		qEditPDF.setParam("Serie_Id", currentSerieId);
		var result = qEditPDF.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			document.getElementById('deckPDF').selectedIndex = 1;
			document.getElementById('bRetourTracabilite').collapsed = false;

			var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
			document.getElementById('pdf').setAttribute("src", page);
		}

	} catch (e) {
		recup_erreur(e);
	}
}
