/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");


var aExpeditions = new Arbre("Facturation/Retours_Clients/list-expeditionRetournable.tmpl", "listeExpeditions");

var curClientId = null;
var curArticleId = null;



function init() {
  try {



  } catch (e) {
    recup_erreur(e);
  }
}


function listerExpeditions() {
	try {

		if (curArticleId!=null && curClientId!=null) {
			aExpeditions.setParam("Client_Id", curClientId);
			aExpeditions.setParam("Article_Id", curArticleId);
			aExpeditions.initTree();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function createRetourClient() {
	try {

		if (curClientId==null) {
			showWarning("Veuillez choisir un client");
		}
		else if (curArticleId==null) {
			showWarning("Veuillez choisir un article");
		}
		else if (!aExpeditions.isSelected()) {
			showWarning("Veuillez s\u00E9lectionner une exp\u00E9dition");
		}
		else if (window.confirm("Confirmez-vous la cr\u00E9ation d'un retour client pour cette exp\u00E9dition ?")) {
			var bonLivId = aExpeditions.getSelectedCellText("colBonLivId");
			var ligneId = aExpeditions.getSelectedCellText("colLigneId");
			var qteMax = aExpeditions.getSelectedCellText("colQteMax");

	  	var qCreate = new QueryHttp("Facturation/Retours_Clients/createRetourClientFromTR.tmpl");
	  	qCreate.setParam("Bon_Liv_Id", bonLivId);
	  	qCreate.setParam("Ligne_Id", ligneId);
	  	qCreate.setParam("Qte_Max", qteMax);
	  	var result = qCreate.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var retourId = result.responseXML.documentElement.getAttribute("Retour_Id");
				window.arguments[0](retourId);
	  	}

			window.close();
		}

	} catch (e) {
	  recup_erreur(e);
	}
}


function rechercherClient() {
	try {

		var url = "chrome://opensi/content/facturation/user/clients/popup-rechercheClient.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', retourRechercherClient);

	} catch (e) {
		recup_erreur(e);
	}
}


function retourRechercherClient(numClient, clientId) {
	try {

  	document.getElementById('numClient').value = numClient;
		curClientId = clientId;
  	listerExpeditions();

	} catch (e) {
		recup_erreur(e);
	}
}


function rechercherArticle() {
	try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', retourRechercherArticle);

	} catch (e) {
		recup_erreur(e);
	}
}


function retourRechercherArticle(reference, articleId) {
	try {

  	document.getElementById('refArticle').value = reference;
		curArticleId = articleId;
  	listerExpeditions();

	} catch (e) {
		recup_erreur(e);
	}
}
