/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var omt_aApercuTransfert = new Arbre('Facturation/Transferts_Emplacements/list-apercuTransfertEmplacement.tmpl', 'omt-apercu');
var omt_aEtablissements = new Arbre('ComboListe/combo-etablissements.tmpl', 'omt-etablissement');
var omt_aDepots = new Arbre('ComboListe/combo-depotsStock.tmpl', 'omt-depot');
var omt_aTransfertsEmplacements = new Arbre('Facturation/Transferts_Emplacements/list-transfertEmplacement.tmpl', 'omt-listeTransferts');
var omt_qListTE = new QueryHttp("Facturation/Transferts_Emplacements/getDataListTE.tmpl");

var omt_pageCourante;
var omt_nbPages;



function omt_init() {
  try {

		omt_aEtablissements.setParam('Selection', gEtablissementDefaut);
		omt_aEtablissements.initTree(omt_initEtablissement);

  } catch (e) {
  	recup_erreur(e);
  }
}


function omt_initEtablissement() {
	try {

		omt_aDepots.setParam('Selection', gDepotDefaut);
		omt_aDepots.initTree(omt_initCriteres);

	} catch (e) {
		recup_erreur(e);
	}
}


function omt_initCriteres() {
	try {

		document.getElementById('omt-numTransfert').value = "";
		document.getElementById('omt-etat').value = "N";
		document.getElementById('omt-dateDebut').value = "";
		document.getElementById('omt-dateFin').value = "";
		document.getElementById('omt-refArticle').value = "";
		document.getElementById('omt-etablissement').value = gEtablissementDefaut;
		document.getElementById('omt-depot').value = gDepotDefaut;

		omt_listerTransferts();

	} catch (e) {
		recup_erreur(e);
	}
}


function omt_listerTransferts() {
	try {

		var numTransfert = document.getElementById('omt-numTransfert').value;
		var etat = document.getElementById('omt-etat').value;
		var dateDebut = document.getElementById('omt-dateDebut').value;
		var dateFin = document.getElementById('omt-dateFin').value;
		var refArticle = document.getElementById('omt-refArticle').value;
		var etablissement = document.getElementById('omt-etablissement').value;
		var depot = document.getElementById('omt-depot').value;
		var nbLignesParPage = document.getElementById('omt-nbLignesParPage').value;

		if (!isEmpty(dateDebut) && !isDate(dateDebut)) { showWarning("Date de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date de fin incorrecte !"); }
		else if (!isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) { showWarning("Plage de dates incorrecte !"); }
		else {

			omt_pageCourante = 1;
			omt_nbPages = 1;
			document.getElementById('omt-pageDeb').value = 1;
			document.getElementById('omt-pageFin').value = 1;
			document.getElementById('omt-bPrec').disabled = true;
			document.getElementById('omt-bSuiv').disabled = true;

			document.getElementById('omt-listeTransferts').disabled = true;
			document.getElementById('omt-bEditionCsv').disabled = true;
			document.getElementById('omt-bEditionDetailCsv').disabled = true;
			document.getElementById('omt-bEditerTransferts').disabled = true;
			document.getElementById('omt-numTransfertSelect').value = "";
			omt_aApercuTransfert.deleteTree();
			omt_aTransfertsEmplacements.deleteTree();

			omt_qListTE.setParam("Num_Transfert", numTransfert);
			omt_qListTE.setParam("Etat", etat);
			omt_qListTE.setParam("Date_Debut", dateDebut);
			omt_qListTE.setParam("Date_Fin", dateFin);
			omt_qListTE.setParam("Ref_Article", refArticle);
			omt_qListTE.setParam("Etablissement", etablissement);
			omt_qListTE.setParam("Depot", depot);
			omt_qListTE.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
			omt_qListTE.setParam("Current_Page", omt_pageCourante);

			var result = omt_qListTE.execute();

			var contenu = result.responseXML.documentElement;

			omt_nbPages = contenu.getAttribute("Nb_Pages");
			var listTransfertId = contenu.getAttribute("List_Transfert_Id");

			omt_aTransfertsEmplacements.setParam("List_Transfert_Id", listTransfertId);
			omt_aTransfertsEmplacements.initTree(omt_initPagination);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omt_initPagination() {
	try {

		document.getElementById('omt-pageDeb').value = omt_pageCourante;
		document.getElementById('omt-pageFin').value = (omt_nbPages>0?omt_nbPages:1);
		document.getElementById('omt-bPrec').disabled = (omt_pageCourante==1);
		document.getElementById('omt-bSuiv').disabled = (omt_pageCourante>=omt_nbPages); // peut se produire si omt_nbPages=0

		document.getElementById('omt-listeTransferts').disabled = false;
		document.getElementById('omt-bEditionCsv').disabled=(omt_aTransfertsEmplacements.nbLignes()==0);
		document.getElementById('omt-bEditionDetailCsv').disabled=(omt_aTransfertsEmplacements.nbLignes()==0);
		document.getElementById('omt-bEditerTransferts').disabled=(omt_aTransfertsEmplacements.nbLignes()==0);

	} catch (e) {
		recup_erreur(e);
	}
}


function omt_pressOnPagePrec() {
	try {

		omt_pageCourante--;
		omt_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omt_pressOnPageSuiv() {
	try {

		omt_pageCourante++;
		omt_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omt_majPagination() {
	try {

		document.getElementById('omt-pageDeb').value = omt_pageCourante;
		document.getElementById('omt-bPrec').disabled = (omt_pageCourante==1);
		document.getElementById('omt-bSuiv').disabled = (omt_pageCourante==omt_nbPages);

		document.getElementById('omt-numTransfertSelect').value = "";

		document.getElementById('omt-listeTransferts').disabled = true;
		document.getElementById('omt-bEditionCsv').disabled = true;
		document.getElementById('omt-bEditionDetailCsv').disabled = true;
		document.getElementById('omt-bEditerTransferts').disabled = true;
		omt_aApercuTransfert.deleteTree();

		omt_qListTE.setParam("Current_Page", omt_pageCourante);
		var result = omt_qListTE.execute();
		var listTransfertId = result.responseXML.documentElement.getAttribute("List_Transfert_Id");

		omt_aTransfertsEmplacements.setParam("List_Transfert_Id", listTransfertId);
		omt_aTransfertsEmplacements.initTree(omt_afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function omt_afterMajPagination() {
	try {

		document.getElementById('omt-listeTransferts').disabled = false;
		document.getElementById('omt-bEditionCsv').disabled = (omt_aTransfertsEmplacements.nbLignes()==0);
		document.getElementById('omt-bEditionDetailCsv').disabled = (omt_aTransfertsEmplacements.nbLignes()==0);
		document.getElementById('omt-bEditerTransferts').disabled = (omt_aTransfertsEmplacements.nbLignes()==0);

	} catch (e) {
		recup_erreur(e);
	}
}


function omt_selectOnListeTransferts() {
	try {

		if (omt_aTransfertsEmplacements.isSelected()) {
			var transfertId = omt_aTransfertsEmplacements.getSelectedCellText('omt-colTransfertId');
			document.getElementById('omt-numTransfertSelect').value = omt_aTransfertsEmplacements.getSelectedCellText('omt-colNumTransfert');

			omt_aApercuTransfert.setParam("Transfert_Id", transfertId);
			omt_aApercuTransfert.initTree();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omt_pressOnNouveauTransfertEmplacements() {
	try {

		document.getElementById('deck').selectedIndex = 1;
		document.getElementById('bMenuTransferts').collapsed = false;
		oet_nouveauTransfert();

	} catch (e) {
		recup_erreur(e);
	}
}


function omt_pressOnCritere(ev) {
  try {

		if (ev.keyCode==13) {
			omt_listerTransferts();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function omt_pressOnListeTransferts(ev) {
  try {

		if (ev.keyCode==13) {
			omt_ouvrirTransfert();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function omt_ouvrirTransfert() {
  try {

  	if (omt_aTransfertsEmplacements.isSelected()) {
			oet_transfertId = omt_aTransfertsEmplacements.getSelectedCellText('omt-colTransfertId');
			oet_chargerTransfert();
			document.getElementById('deck').selectedIndex = 1;
			document.getElementById('bMenuTransferts').collapsed = false;
  	}

	} catch (e) {
  	recup_erreur(e);
  }
}


function omt_pressOnEditionCsv(detail) {
	try {

		var numTransfert = document.getElementById('omt-numTransfert').value;
		var etat = document.getElementById('omt-etat').value;
		var dateDebut = document.getElementById('omt-dateDebut').value;
		var dateFin = document.getElementById('omt-dateFin').value;
		var refArticle = document.getElementById('omt-refArticle').value;
		var etablissement = document.getElementById('omt-etablissement').value;
		var depot = document.getElementById('omt-depot').value;

		if (!isEmpty(dateDebut) && !isDate(dateDebut)) { showWarning("Date de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date de fin incorrecte !"); }
		else if (!isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) { showWarning("Plage de dates incorrecte !"); }
		else {
			var qEditionCsv = new QueryHttp("Facturation/Transferts_Emplacements/"+ (detail?"csvDetailTransfertEmplacement.tmpl":"csvTransfertEmplacement.tmpl"));

			qEditionCsv.setParam("Num_Transfert", numTransfert);
			qEditionCsv.setParam("Etat", etat);
			qEditionCsv.setParam("Date_Debut", dateDebut);
			qEditionCsv.setParam("Date_Fin", dateFin);
			qEditionCsv.setParam("Ref_Article", refArticle);
			qEditionCsv.setParam("Etablissement", etablissement);
			qEditionCsv.setParam("Depot", depot);

			var result = qEditionCsv.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

				var file = fileChooser("save", fichier);
				if (file!=null) {
					downloadFile(getDirBuffer()+ fichier, file);
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omt_pressOnEditerTransferts() {
	try {

		var numTransfert = document.getElementById('omt-numTransfert').value;
		var etat = document.getElementById('omt-etat').value;
		var dateDebut = document.getElementById('omt-dateDebut').value;
		var dateFin = document.getElementById('omt-dateFin').value;
		var refArticle = document.getElementById('omt-refArticle').value;
		var etablissement = document.getElementById('omt-etablissement').value;
		var depot = document.getElementById('omt-depot').value;

		if (!isEmpty(dateDebut) && !isDate(dateDebut)) { showWarning("Date de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date de fin incorrecte !"); }
		else if (!isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) { showWarning("Plage de dates incorrecte !"); }
		else {
			document.getElementById('omt-pdfTransferts').setAttribute("src", "");

			var qGenPdf = new QueryHttp("Facturation/Transferts_Emplacements/pdfListTransfertEmplacement.tmpl");

			qGenPdf.setParam("Num_Transfert", numTransfert);
			qGenPdf.setParam("Etat", etat);
			qGenPdf.setParam("Date_Debut", dateDebut);
			qGenPdf.setParam("Date_Fin", dateFin);
			qGenPdf.setParam("Ref_Article", refArticle);
			qGenPdf.setParam("Etablissement", etablissement);
			qGenPdf.setParam("Depot", depot);

			var result = qGenPdf.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
				document.getElementById('omt-deckMenu').selectedIndex = 1;
				document.getElementById('bMenuTransferts').collapsed = false;
				document.getElementById('omt-pdfTransferts').setAttribute("src", page);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omt_rechercherArticle() {
	try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', omt_retourRechercherArticle, null);

	} catch (e) {
		recup_erreur(e);
	}
}


function omt_retourRechercherArticle(reference, articleId) {
	try {

  	document.getElementById('omt-refArticle').value = reference;
  	omt_listerTransferts();

	} catch (e) {
		recup_erreur(e);
	}
}
