/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var ota_aFactures = new Arbre('Facturation/Transfert/list-transfertComptaFactureFournisseur.tmpl', 'ota-factures');
var ota_aAvoirs = new Arbre('Facturation/Transfert/list-transfertComptaAvoirFournisseur.tmpl', 'ota-avoirs');
var ota_aAcomptes = new Arbre('Facturation/Transfert/list-transfertComptaAcompteFournisseur.tmpl', 'ota-acomptes');
var ota_aPeriodes = new Arbre('ComboListe/combo-dernieresPeriodes.tmpl', 'ota-Periode');
var ota_aPoles = new Arbre('ComboListe/combo-polesActivite.tmpl', 'ota-poleActivite');
var ota_aFormats = new Arbre('ComboListe/combo-formatsExportCompta.tmpl', 'ota-formatExport');


function ota_init() {
  try {

  	document.getElementById('ota-Type_Periode').value = 'P';
		document.getElementById('ota-Date_Debut').disabled = true;
		document.getElementById('ota-Date_Fin').disabled = true;
		document.getElementById('ota-typeTransfert').value = "FA";
		ota_switchTypeTransfert();

		ota_aFormats.initTree(ota_initFormat);

	} catch (e) {
  	recup_erreur(e);
  }
}


function ota_initFormat() {
	try {
		document.getElementById('ota-formatExport').selectedIndex = 0;
		ota_aPoles.initTree(ota_initPole);
	} catch (e) {
		recup_erreur(e);
	}
}


function ota_initPole() {
	try {
		document.getElementById('ota-poleActivite').selectedIndex = 0;

		ota_aPeriodes.initTree(ota_initPeriode);

		var aJournauxAchat = new Arbre('ComboListe/combo-journaux.tmpl', 'ota-journalAchat');
		aJournauxAchat.setParam('Type_Journal', 'AC');
		aJournauxAchat.initTree(ota_initJournalAchat);

		var aJournauxTransfert = new Arbre('ComboListe/combo-journaux.tmpl', 'ota-journalTransfert');
		aJournauxTransfert.setParam('Type_Journal', 'OD');
		aJournauxTransfert.initTree(ota_initJournalTransfert);

	} catch (e) {
		recup_erreur(e);
	}
}


function ota_initJournalAchat() {
  try {

		document.getElementById('ota-journalAchat').value = gConfig.getJournalAchat();

	} catch (e) {
    recup_erreur(e);
  }
}


function ota_initJournalTransfert() {
  try {

		document.getElementById('ota-journalTransfert').value = gConfig.getJournalAcompteAC();

	} catch (e) {
    recup_erreur(e);
  }
}


function ota_initPeriode() {
  try {

		document.getElementById('ota-Periode').selectedIndex = 0;

		var periode = document.getElementById('ota-Periode').value;
		var poleActivite = document.getElementById('ota-poleActivite').value;
		var numFournisseur = document.getElementById('ota-Num_Fournisseur').value;

		ota_aFactures.setParam('Type_Periode', 'P');
		ota_aFactures.setParam('Transferee', false);
		ota_aFactures.setParam('Periode', periode);
		ota_aFactures.setParam('Pole_Activite', poleActivite);
		ota_aFactures.setParam('Num_Fournisseur', numFournisseur);
		ota_aFactures.initTree(ota_initListeFactures);

		ota_aAvoirs.setParam('Type_Periode', 'P');
		ota_aAvoirs.setParam('Transfere', false);
		ota_aAvoirs.setParam('Periode', periode);
		ota_aAvoirs.setParam('Pole_Activite', poleActivite);
		ota_aAvoirs.setParam('Num_Fournisseur', numFournisseur);
		ota_aAvoirs.initTree(ota_initListeAvoirs);

		ota_aAcomptes.setParam('Type_Periode', 'P');
		ota_aAcomptes.setParam('Comptabilise', false);
		ota_aAcomptes.setParam('Periode', periode);
		ota_aAcomptes.setParam('Pole_Activite', poleActivite);
		ota_aAcomptes.setParam('Num_Fournisseur', numFournisseur);
		ota_aAcomptes.initTree(ota_initListeAcomptes);

	} catch (e) {
    recup_erreur(e);
  }
}


function ota_switchTypeTransfert() {
	try {
		var type = document.getElementById('ota-typeTransfert').value;
		document.getElementById('ota-boxFacturesAvoirs').collapsed = (type!="FA");
		document.getElementById('ota-boxJournalAchat').collapsed = (type!="FA");
		document.getElementById('ota-boxAcomptes').collapsed = (type!="AC");
		document.getElementById('ota-boxJournalTransfert').collapsed = (type!="AC");
	} catch (e) {
		recup_erreur(e);
	}
}


function ota_actualiserListeFactures() {
	try {

		var typePeriode = document.getElementById('ota-Type_Periode').value;
		var periode = document.getElementById('ota-Periode').value;
		var dateDebut = document.getElementById('ota-Date_Debut').value;
		var dateFin = document.getElementById('ota-Date_Fin').value;
		var numFournisseur = document.getElementById('ota-Num_Fournisseur').value;
		var poleActivite = document.getElementById('ota-poleActivite').value;
		var nonTrans = document.getElementById('ota-chkAffFacturesTrans').checked;

		if (typePeriode=="P" || (isDate(dateDebut) && isDate(dateFin) && isDateInterval(dateDebut, dateFin))) {
			ota_aFactures.clearParams();
			ota_aFactures.setParam('Type_Periode', typePeriode);
			ota_aFactures.setParam('Periode', periode);
			ota_aFactures.setParam('Date_Debut', dateDebut);
			ota_aFactures.setParam('Date_Fin', dateFin);
			ota_aFactures.setParam('Pole_Activite', poleActivite);
			ota_aFactures.setParam('Num_Fournisseur', numFournisseur);
			ota_aFactures.setParam('Transferee', nonTrans?"":false);
			ota_aFactures.initTree(ota_initListeFactures);
		}
		else {
			showWarning("Veuillez saisir un intervalle de dates valide !");
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ota_actualiserListeAvoirs() {
	try {

		var typePeriode = document.getElementById('ota-Type_Periode').value;
		var periode = document.getElementById('ota-Periode').value;
		var dateDebut = document.getElementById('ota-Date_Debut').value;
		var dateFin = document.getElementById('ota-Date_Fin').value;
		var numFournisseur = document.getElementById('ota-Num_Fournisseur').value;
		var poleActivite = document.getElementById('ota-poleActivite').value;
		var nonTrans = document.getElementById('ota-chkAffAvoirsTrans').checked;

		if (typePeriode=="P" || (isDate(dateDebut) && isDate(dateFin) && isDateInterval(dateDebut, dateFin))) {
			ota_aAvoirs.clearParams();
			ota_aAvoirs.setParam('Type_Periode', typePeriode);
			ota_aAvoirs.setParam('Periode', periode);
			ota_aAvoirs.setParam('Date_Debut', dateDebut);
			ota_aAvoirs.setParam('Date_Fin', dateFin);
			ota_aAvoirs.setParam('Pole_Activite', poleActivite);
			ota_aAvoirs.setParam('Num_Fournisseur', numFournisseur);
			ota_aAvoirs.setParam('Transfere', nonTrans?"":false);
			ota_aAvoirs.initTree(ota_initListeAvoirs);
		}
		else {
			showWarning("Veuillez saisir un intervalle de dates valide !");
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ota_actualiserListeAcomptes() {
	try {

		var typePeriode = document.getElementById('ota-Type_Periode').value;
		var periode = document.getElementById('ota-Periode').value;
		var dateDebut = document.getElementById('ota-Date_Debut').value;
		var dateFin = document.getElementById('ota-Date_Fin').value;
		var numFournisseur = document.getElementById('ota-Num_Fournisseur').value;
		var poleActivite = document.getElementById('ota-poleActivite').value;
		var nonTrans = document.getElementById('ota-chkAffAcomptesTrans').checked;

		if (typePeriode=="P" || (isDate(dateDebut) && isDate(dateFin) && isDateInterval(dateDebut, dateFin))) {
			ota_aAcomptes.clearParams();
			ota_aAcomptes.setParam('Type_Periode', typePeriode);
			ota_aAcomptes.setParam('Periode', periode);
			ota_aAcomptes.setParam('Date_Debut', dateDebut);
			ota_aAcomptes.setParam('Date_Fin', dateFin);
			ota_aAcomptes.setParam('Pole_Activite', poleActivite);
			ota_aAcomptes.setParam('Num_Fournisseur', numFournisseur);
			ota_aAcomptes.setParam('Comptabilise', nonTrans?"":false);
			ota_aAcomptes.initTree(ota_initListeAcomptes);
		}
		else {
			showWarning("Veuillez saisir un intervalle de dates valide !");
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ota_actualiserSelection() {
  try {

		var typePeriode = document.getElementById('ota-Type_Periode').value;
		var dateDebut = document.getElementById('ota-Date_Debut').value;
		var dateFin = document.getElementById('ota-Date_Fin').value;

		if (typePeriode=="P" || (isDate(dateDebut) && isDate(dateFin) && isDateInterval(dateDebut, dateFin))) {
			ota_actualiserListeFactures();
			ota_actualiserListeAvoirs();
			ota_actualiserListeAcomptes();
		} else {
			showWarning("Veuillez saisir un intervalle de dates valide !");
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function ota_initListeFactures() {
	try {
		toutCocher('ota-factures', true);
	} catch (e) {
		recup_erreur(e);
	}
}


function ota_initListeAvoirs() {
	try {
		toutCocher('ota-avoirs', true);
	} catch (e) {
		recup_erreur(e);
	}
}


function ota_initListeAcomptes() {
	try {
		toutCocher('ota-acomptes', true);
	} catch (e) {
		recup_erreur(e);
	}
}


function ota_changerTypePeriode(tp) {
  try {

		var b = (tp=="P");
		document.getElementById('ota-Date_Debut').disabled = b;
		document.getElementById('ota-Date_Fin').disabled = b;
		document.getElementById('ota-Periode').disabled = !b;

	} catch (e) {
    recup_erreur(e);
  }
}


function ota_transferer() {
	try {
		var type = document.getElementById('ota-typeTransfert').value;
		if (type=="FA") { ota_checkFacturesAvoirs("Transfert"); }
		else { ota_checkAcomptes("Transfert"); }
	} catch (e) {
		recup_erreur(e);
	}
}


function ota_checkFacturesAvoirs(type) {
	try {

		var listboxFactures = document.getElementById("ota-factures");
		var listeFactures="";
		var nbLignes = listboxFactures.getRowCount();

		var i = 0;
		while (i<nbLignes) {
			var item = listboxFactures.getItemAtIndex(i);
			var cks = item.getElementsByTagName("listcell");
			if (cks.item(0).getAttribute("checked")=="true") {
				listeFactures += item.value+",";
			}
			i++;
		}

		var listboxAvoirs = document.getElementById("ota-avoirs");
		var listeAvoirs="";
		nbLignes = listboxAvoirs.getRowCount();
		i = 0;
		while (i<nbLignes) {
			var item = listboxAvoirs.getItemAtIndex(i);
			var cks = item.getElementsByTagName("listcell");
			if (cks.item(0).getAttribute("checked")=="true") {
				listeAvoirs += item.value+",";
			}
			i++;
		}

		if (!isEmpty(listeFactures) || !isEmpty(listeAvoirs)) {
			var journalId = document.getElementById('ota-journalAchat').value;

			if (isEmpty(journalId)) {
				showWarning("Veuillez s\u00E9lectionner un code journal !");
			}
			else if (type=="Export" || window.confirm("Confirmez-vous le transfert en comptabilit\u00E9 des achats s\u00E9lectionn\u00E9s ?")) {
				if (type=="Transfert") { ota_transfererFacturesAvoirs(listeFactures, listeAvoirs, journalId); }
				else { ota_exporterFacturesAvoirs(listeFactures, listeAvoirs, journalId); }
			}

		} else {
			showWarning("Vous n'avez rien s\u00E9lectionn\u00E9 !");
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function ota_transfererFacturesAvoirs(listeFactures, listeAvoirs, journalId) {
	try {
		document.getElementById('ota-bTransfert').disabled = true;
		document.getElementById('ota-bExporter').disabled = true;

		var qTrans = new QueryHttp("Facturation/Transfert/TransfertAchats.tmpl");
		qTrans.setParam('Journal_Id', journalId);
		qTrans.setParam('Liste_Factures', listeFactures);
		qTrans.setParam('Liste_Avoirs', listeAvoirs);
		var result = qTrans.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}

		ota_aFactures.initTree(ota_initListeFactures);
		ota_aAvoirs.initTree(ota_initListeAvoirs);

		document.getElementById('ota-bTransfert').disabled = false;
		document.getElementById('ota-bExporter').disabled = false;
	} catch (e) {
		recup_erreur(e);
	}
}


function ota_checkAcomptes(type) {
	try {

  	var listboxAcomptes = document.getElementById("ota-acomptes");
		var listeAcomptes="";
		var listeAnnulAcomptes="";
		var nbLignes = listboxAcomptes.getRowCount();

		var i = 0;
		while (i<nbLignes) {
			var item = listboxAcomptes.getItemAtIndex(i);
			var cks = item.getElementsByTagName("listcell");
			if (cks.item(0).getAttribute("checked")=="true") {
				if (cks.item(9).getAttribute("label")=="V") { listeAcomptes += item.value+","; }
				else { listeAnnulAcomptes += item.value+","; }
			}
			i++;
		}

		if (!isEmpty(listeAcomptes) || !isEmpty(listeAnnulAcomptes)) {
			var journalId = document.getElementById('ota-journalTransfert').value;

			if (journalId=="") {
				showWarning("Veuillez s\u00E9lectionner un code journal !");
			}
			else if (type=="Export" || window.confirm("Confirmez-vous le transfert en comptabilit\u00E9 des achats s\u00E9lectionn\u00E9s ?")) {
				if (type=="Transfert") { ota_transfererAcomptes(listeAcomptes, listeAnnulAcomptes, journalId); }
				else { ota_exporterAcomptes(listeAcomptes, listeAnnulAcomptes, journalId); }
			}
		} else {
			showWarning("Vous n'avez rien s\u00E9lectionn\u00E9 !");
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function ota_transfererAcomptes(listeAcomptes, listeAnnulAcomptes, journalId) {
	try {
		document.getElementById('ota-bTransfert').disabled = true;
		document.getElementById('ota-bExporter').disabled = true;

		var qTrans = new QueryHttp("Facturation/Transfert/TransfertAcomptesFournisseurs.tmpl");
		qTrans.setParam('Journal_Id', journalId);
		qTrans.setParam('Liste_Acomptes', listeAcomptes);
		qTrans.setParam('Liste_Annul_Acomptes', listeAnnulAcomptes);
		var result = qTrans.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}

		ota_aAcomptes.initTree(ota_initListeAcomptes);

		document.getElementById('ota-bTransfert').disabled = false;
		document.getElementById('ota-bExporter').disabled = false;
	} catch (e) {
		recup_erreur(e);
	}
}


function ota_rechercherFournisseur() {
	try {

		var url = "chrome://opensi/content/facturation/user/fournisseurs/popup-rechercheFournisseur.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', ota_retourRechercherFournisseur);

	} catch (e) {
		recup_erreur(e);
	}
}


function ota_retourRechercherFournisseur(numFournisseur) {
	try {

		document.getElementById('ota-Num_Fournisseur').value = numFournisseur;

	} catch (e) {
		recup_erreur(e);
	}
}


function ota_exporter() {
	try {

		var type = document.getElementById('ota-typeTransfert').value;
		formatExport = document.getElementById('ota-formatExport').value;
		if (isEmpty(formatExport)) { showWarning("Veuillez choisir un format d'export."); }
		else if (checkNomFichierExport(formatExport)) {
			if (type=="FA") { ota_checkFacturesAvoirs("Export"); }
			else { ota_checkAcomptes("Export"); }
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ota_exporterFacturesAvoirs(listeFactures, listeAvoirs, journalId) {
	try {

		document.getElementById('ota-bTransfert').disabled = true;
		document.getElementById('ota-bExporter').disabled = true;

		var qExport = new QueryHttp("Facturation/Transfert/exporterEcritures.tmpl");
		qExport.setParam('Type_Liste', "Factures_Avoirs_Achat");
		qExport.setParam('Format_Id', formatExport);
		qExport.setParam('Journal_Id', journalId);
		qExport.setParam('Liste_Factures', listeFactures);
		qExport.setParam('Liste_Avoirs', listeAvoirs);
		var result = qExport.execute();

		telechargerFichier(result);

		document.getElementById('ota-bTransfert').disabled = false;
		document.getElementById('ota-bExporter').disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function ota_exporterAcomptes(listeAcomptes, listeAnnulAcomptes, journalId) {
	try {

		document.getElementById('ota-bTransfert').disabled = true;
		document.getElementById('ota-bExporter').disabled = true;

		var qExport = new QueryHttp("Facturation/Transfert/exporterEcritures.tmpl");
		qExport.setParam('Type_Liste', "Acomptes_Achat");
		qExport.setParam('Format_Id', formatExport);
		qExport.setParam('Journal_Id', journalId);
		qExport.setParam('Liste_Acomptes', listeAcomptes);
		qExport.setParam('Liste_Annul_Acomptes', listeAnnulAcomptes);
		var result = qExport.execute();

		telechargerFichier(result);

		document.getElementById('ota-bTransfert').disabled = false;
		document.getElementById('ota-bExporter').disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}
