/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var otv_aFactures = new Arbre('Facturation/Transfert/list-transfertComptaFactureClient.tmpl', 'otv-factures');
var otv_aAvoirs = new Arbre('Facturation/Transfert/list-transfertComptaAvoirClient.tmpl', 'otv-avoirs');
var otv_aAcomptes = new Arbre('Facturation/Transfert/list-transfertComptaAcompteClient.tmpl', 'otv-acomptes');
var otv_aPeriodes = new Arbre('ComboListe/combo-dernieresPeriodes.tmpl', 'otv-Periode');
var otv_aPolesActivite = new Arbre('ComboListe/combo-polesActivite.tmpl', 'otv-poleActivite');
var otv_aFormats = new Arbre('ComboListe/combo-formatsExportCompta.tmpl', 'otv-formatExport');



function otv_init() {
  try {

		document.getElementById('otv-Type_Periode').value = 'P';
		document.getElementById('otv-Date_Debut').disabled = true;
		document.getElementById('otv-Date_Fin').disabled = true;
		document.getElementById('otv-typeTransfert').value = "FA";
		otv_switchTypeTransfert();

		otv_aFormats.initTree(otv_initFormat);

		document.getElementById('otv-miProvenanceHL').collapsed = !getProfil().isProvenanceHL();

	} catch (e) {
  	recup_erreur(e);
  }
}


function otv_initFormat() {
	try {
		document.getElementById('otr-formatExport').selectedIndex = 0;
		var aProvenance = new Arbre('ComboListe/combo-sitesWeb.tmpl','otv-provenance');
		aProvenance.initTree(otv_initProvenance);
	} catch (e) {
		recup_erreur(e);
	}
}


function otv_initProvenance() {
	try {
		document.getElementById('otv-provenance').selectedIndex = 0;
		otv_aPolesActivite.initTree(otv_initPoleActivite);

	} catch (e) {
		recup_erreur(e);
	}
}

function otv_initPoleActivite() {
	try {

		document.getElementById('otv-poleActivite').selectedIndex = 0;
		document.getElementById('otv-boxProvenance').collapsed = !gConfig.isECommerce();

		otv_aPeriodes.initTree(otv_initPeriode);

		var aJournauxVente = new Arbre('ComboListe/combo-journaux.tmpl', 'otv-JournalVente');
		aJournauxVente.setParam('Type_Journal', 'VE');
		aJournauxVente.initTree(otv_initJournalVente);

		var aJournauxTransfert = new Arbre('ComboListe/combo-journaux.tmpl', 'otv-JournalTransfert');
		aJournauxTransfert.setParam('Type_Journal', 'OD');
		aJournauxTransfert.initTree(otv_initJournalTransfert);

	} catch (e) {
		recup_erreur(e);
	}
}


function otv_initJournalVente() {
  try {

		document.getElementById('otv-JournalVente').value = gConfig.getJournalVente();

	} catch (e) {
    recup_erreur(e);
  }
}


function otv_initJournalTransfert() {
  try {

		document.getElementById('otv-JournalTransfert').value = gConfig.getJournalAcompteVE();

	} catch (e) {
    recup_erreur(e);
  }
}


function otv_initPeriode() {
  try {

		document.getElementById('otv-Periode').selectedIndex = 0;

		var periode = document.getElementById('otv-Periode').value;
		var provenance = document.getElementById('otv-provenance').value;
		var poleActivite = document.getElementById('otv-poleActivite').value;
		var numClient = document.getElementById('otv-Num_Client').value;

		otv_aFactures.setParam('Type_Periode', 'P');
		otv_aFactures.setParam('Transferee', false);
		otv_aFactures.setParam('Periode', periode);
		otv_aFactures.setParam('Provenance', provenance);
		otv_aFactures.setParam('Num_Client', numClient);
		otv_aFactures.setParam('Pole_Activite', poleActivite);
		otv_aFactures.initTree(otv_initListeFactures);

		otv_aAvoirs.setParam('Type_Periode', 'P');
		otv_aAvoirs.setParam('Transfere', false);
		otv_aAvoirs.setParam('Periode', periode);
		otv_aAvoirs.setParam('Provenance', provenance);
		otv_aAvoirs.setParam('Num_Client', numClient);
		otv_aAvoirs.setParam('Pole_Activite', poleActivite);
		otv_aAvoirs.initTree(otv_initListeAvoirs);

		otv_aAcomptes.setParam('Type_Periode', 'P');
		otv_aAcomptes.setParam('Comptabilise', false);
		otv_aAcomptes.setParam('Periode', periode);
		otv_aAcomptes.setParam('Provenance', provenance);
		otv_aAcomptes.setParam('Num_Client', numClient);
		otv_aAcomptes.setParam('Pole_Activite', poleActivite);
		otv_aAcomptes.initTree(otv_initListeAcomptes);

	} catch (e) {
    recup_erreur(e);
  }
}


function otv_switchTypeTransfert() {
	try {
		var type = document.getElementById('otv-typeTransfert').value;
		document.getElementById('otv-boxFacturesAvoirs').collapsed = (type!="FA");
		document.getElementById('otv-boxJournalVente').collapsed = (type!="FA");
		document.getElementById('otv-boxAcomptes').collapsed = (type!="AC");
		document.getElementById('otv-boxJournalTransfert').collapsed = (type!="AC");
	} catch (e) {
		recup_erreur(e);
	}
}


function otv_actualiserListeFactures() {
	try {

		var typePeriode = document.getElementById('otv-Type_Periode').value;
		var periode = document.getElementById('otv-Periode').value;
		var dateDebut = document.getElementById('otv-Date_Debut').value;
		var dateFin = document.getElementById('otv-Date_Fin').value;
		var numClient = document.getElementById('otv-Num_Client').value;
		var provenance = document.getElementById('otv-provenance').value;
		var poleActivite = document.getElementById('otv-poleActivite').value;
		var nonTrans = document.getElementById('otv-chkAffFactTrans').checked;

		if (typePeriode=="P" || (isDate(dateDebut) && isDate(dateFin) && isDateInterval(dateDebut, dateFin))) {
			otv_aFactures.clearParams();
			otv_aFactures.setParam('Type_Periode', typePeriode);
			otv_aFactures.setParam('Periode', periode);
			otv_aFactures.setParam('Date_Debut', dateDebut);
			otv_aFactures.setParam('Date_Fin', dateFin);
			otv_aFactures.setParam('Num_Client', numClient);
			otv_aFactures.setParam('Provenance', provenance);
			otv_aFactures.setParam('Pole_Activite', poleActivite);
			otv_aFactures.setParam('Transferee', nonTrans?"":false);
			otv_aFactures.initTree(otv_initListeFactures);
		}
		else {
			showWarning("Veuillez saisir un intervalle de dates valide !");
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function otv_actualiserListeAvoirs() {
	try {

		var typePeriode = document.getElementById('otv-Type_Periode').value;
		var periode = document.getElementById('otv-Periode').value;
		var dateDebut = document.getElementById('otv-Date_Debut').value;
		var dateFin = document.getElementById('otv-Date_Fin').value;
		var numClient = document.getElementById('otv-Num_Client').value;
		var provenance = document.getElementById('otv-provenance').value;
		var poleActivite = document.getElementById('otv-poleActivite').value;
		var nonTrans = document.getElementById('otv-chkAffAvoirTrans').checked;

		if (typePeriode=="P" || (isDate(dateDebut) && isDate(dateFin) && isDateInterval(dateDebut, dateFin))) {
			otv_aAvoirs.clearParams();
			otv_aAvoirs.setParam('Type_Periode', typePeriode);
			otv_aAvoirs.setParam('Periode', periode);
			otv_aAvoirs.setParam('Date_Debut', dateDebut);
			otv_aAvoirs.setParam('Date_Fin', dateFin);
			otv_aAvoirs.setParam('Num_Client', numClient);
			otv_aAvoirs.setParam('Provenance', provenance);
			otv_aAvoirs.setParam('Pole_Activite', poleActivite);
			otv_aAvoirs.setParam('Transfere', nonTrans?"":false);
			otv_aAvoirs.initTree(otv_initListeAvoirs);
		}
		else {
			showWarning("Veuillez saisir un intervalle de dates valide !");
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function otv_actualiserListeAcomptes() {
	try {

		var typePeriode = document.getElementById('otv-Type_Periode').value;
		var periode = document.getElementById('otv-Periode').value;
		var dateDebut = document.getElementById('otv-Date_Debut').value;
		var dateFin = document.getElementById('otv-Date_Fin').value;
		var numClient = document.getElementById('otv-Num_Client').value;
		var provenance = document.getElementById('otv-provenance').value;
		var poleActivite = document.getElementById('otv-poleActivite').value;
		var nonTrans = document.getElementById('otv-chkAffAcomptesTrans').checked;

		if (typePeriode=="P" || (isDate(dateDebut) && isDate(dateFin) && isDateInterval(dateDebut, dateFin))) {
			otv_aAcomptes.clearParams();
			otv_aAcomptes.setParam('Type_Periode', typePeriode);
			otv_aAcomptes.setParam('Periode', periode);
			otv_aAcomptes.setParam('Date_Debut', dateDebut);
			otv_aAcomptes.setParam('Date_Fin', dateFin);
			otv_aAcomptes.setParam('Num_Client', numClient);
			otv_aAcomptes.setParam('Provenance', provenance);
			otv_aAcomptes.setParam('Pole_Activite', poleActivite);
			otv_aAcomptes.setParam('Comptabilise', nonTrans?"":false);
			otv_aAcomptes.initTree(otv_initListeAcomptes);
		}
		else {
			showWarning("Veuillez saisir un intervalle de dates valide !");
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function otv_actualiserSelection() {
  try {

		var typePeriode = document.getElementById('otv-Type_Periode').value;
		var dateDebut = document.getElementById('otv-Date_Debut').value;
		var dateFin = document.getElementById('otv-Date_Fin').value;

		if (typePeriode=="P" || (isDate(dateDebut) && isDate(dateFin) && isDateInterval(dateDebut, dateFin))) {
			otv_actualiserListeFactures();
			otv_actualiserListeAvoirs();
			otv_actualiserListeAcomptes();
		}
		else {
			showWarning("Veuillez saisir un intervalle de dates valide !");
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function otv_initListeFactures() {
	try {
		toutCocher('otv-factures', true);
	} catch (e) {
		recup_erreur(e);
	}
}


function otv_initListeAvoirs() {
	try {
		toutCocher('otv-avoirs', true);
	} catch (e) {
		recup_erreur(e);
	}
}


function otv_initListeAcomptes() {
	try {
		toutCocher('otv-acomptes', true);
	} catch (e) {
		recup_erreur(e);
	}
}


function otv_changerTypePeriode(tp) {
  try {

		var b = (tp=="P");
		document.getElementById('otv-Date_Debut').disabled = b;
		document.getElementById('otv-Date_Fin').disabled = b;
		document.getElementById('otv-Periode').disabled = !b;

	} catch (e) {
    recup_erreur(e);
  }
}


function otv_transferer() {
	try {
		var type = document.getElementById('otv-typeTransfert').value;
		if (type=="FA") { otv_checkFacturesAvoirs("Transfert"); }
		else { otv_checkAcomptes("Transfert"); }
	} catch (e) {
		recup_erreur(e);
	}
}


function otv_checkFacturesAvoirs(type) {
  try {

  	var listboxFactures = document.getElementById("otv-factures");
		var listeFactures="";
		var nbLignes = listboxFactures.getRowCount();

		var i = 0;
		while (i<nbLignes) {
			var item = listboxFactures.getItemAtIndex(i);
			var cks = item.getElementsByTagName("listcell");
			if (cks.item(0).getAttribute("checked")=="true") {
				listeFactures += item.value+",";
			}
			i++;
		}

		var listboxAvoirs = document.getElementById("otv-avoirs");
		var listeAvoirs="";
		nbLignes = listboxAvoirs.getRowCount();
		i = 0;
		while (i<nbLignes) {
			var item = listboxAvoirs.getItemAtIndex(i);
			var cks = item.getElementsByTagName("listcell");
			if (cks.item(0).getAttribute("checked")=="true") {
				listeAvoirs += item.value+",";
			}
			i++;
		}

		if (!isEmpty(listeFactures) || !isEmpty(listeAvoirs)) {
			var journalId = document.getElementById('otv-JournalVente').value;

			if (isEmpty(journalId)) {
				showWarning("Veuillez s\u00E9lectionner un code journal !");
			}
			else if (type=="Export" || window.confirm("Confirmez-vous le transfert en comptabilit\u00E9 des ventes s\u00E9lectionn\u00E9es ?")) {
				if (type=="Transfert") {
					var cloture = false;

					if (document.getElementById('otv-Type_Periode').value=="P" && document.getElementById('otv-Periode').selectedIndex==0) {

						var qIsClot = new QueryHttp("Facturation/Transfert/isPeriodeFacturationCloturable.tmpl");
						var result = qIsClot.execute();
						var cloturable = result.responseXML.documentElement.getAttribute('cloturable')=="true";
						var moisEnCours = document.getElementById('otv-Periode').getAttribute("label");

						if (cloturable && window.confirm("Voulez-vous cl\u00F4turer le mois de facturation en cours ("+ moisEnCours +") ?")) {
							var qClot = new QueryHttp("Facturation/Transfert/CloturerMois.tmpl");
							qClot.execute();
							cloture = true;
						}
					}
					otv_transfererFacturesAvoirs(listeFactures, listeAvoirs, journalId);
					if (cloture) {
						otv_aPeriodes.initTree(otv_initPeriodePrec);
					}
				}
				else {
					otv_exporterFacturesAvoirs(listeFactures, listeAvoirs, journalId);
				}
			}

		} else {
			showWarning("Vous n'avez rien s\u00E9lectionn\u00E9 !");
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function otv_transfererFacturesAvoirs(listeFactures, listeAvoirs, journalId) {
	try {

		document.getElementById('otv-bTransfert').disabled = true;
		document.getElementById('otv-bExporter').disabled = true;

		var qTrans = new QueryHttp("Facturation/Transfert/TransfertFactures.tmpl");
		qTrans.setParam('Journal_Id', journalId);
		qTrans.setParam('Liste_Factures', listeFactures);
		qTrans.setParam('Liste_Avoirs', listeAvoirs);
		var result = qTrans.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}

		otv_aFactures.initTree(otv_initListeFactures);
		otv_aAvoirs.initTree(otv_initListeAvoirs);

		document.getElementById('otv-bTransfert').disabled = false;
		document.getElementById('otv-bExporter').disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function otv_checkAcomptes(type) {
	try {

  	var listboxAcomptes = document.getElementById("otv-acomptes");
		var listeAcomptes="";
		var listeAnnulAcomptes="";
		var nbLignes = listboxAcomptes.getRowCount();

		var i = 0;
		while (i<nbLignes) {
			var item = listboxAcomptes.getItemAtIndex(i);
			var cks = item.getElementsByTagName("listcell");
			if (cks.item(0).getAttribute("checked")=="true") {
				if (cks.item(9).getAttribute("label")=="V") { listeAcomptes += item.value+","; }
				else { listeAnnulAcomptes += item.value+","; }
			}
			i++;
		}

		if (!isEmpty(listeAcomptes) || !isEmpty(listeAnnulAcomptes)) {
			var journalId = document.getElementById('otv-JournalTransfert').value;

			if (journalId=="") {
				showWarning("Veuillez s\u00E9lectionner un code journal !");
			}
			else if (type=="Export" || window.confirm("Confirmez-vous le transfert en comptabilit\u00E9 des ventes s\u00E9lectionn\u00E9es ?")) {
				if (type=="Transfert") { otv_transfererAcomptes(listeAcomptes, listeAnnulAcomptes, journalId); }
				else { otv_exporterAcomptes(listeAcomptes, listeAnnulAcomptes, journalId); }
			}
		} else {
			showWarning("Vous n'avez rien s\u00E9lectionn\u00E9 !");
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function otv_transfererAcomptes(listeAcomptes, listeAnnulAcomptes, journalId) {
	try {

		document.getElementById('otv-bTransfert').disabled = true;
		document.getElementById('otv-bExporter').disabled = true;

		var qTrans = new QueryHttp("Facturation/Transfert/TransfertAcomptes.tmpl");
		qTrans.setParam('Journal_Id', journalId);
		qTrans.setParam('Liste_Acomptes', listeAcomptes);
		qTrans.setParam('Liste_Annul_Acomptes', listeAnnulAcomptes);
		var result = qTrans.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}

		otv_aAcomptes.initTree(otv_initListeAcomptes);

		document.getElementById('otv-bTransfert').disabled = false;
		document.getElementById('otv-bExporter').disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function otv_initPeriodePrec() {
  try {

		document.getElementById('otv-Periode').selectedIndex = 1;

	} catch (e) {
    recup_erreur(e);
  }
}


function otv_rechercherClient() {
	try {

		var url = "chrome://opensi/content/facturation/user/clients/popup-rechercheClient.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', otv_retourRechercherClient);

	} catch (e) {
		recup_erreur(e);
	}
}

function otv_retourRechercherClient(numClient) {
	try {
  	document.getElementById('otv-Num_Client').value = numClient;
	} catch (e) {
		recup_erreur(e);
	}
}


function otv_exporter() {
	try {
		var type = document.getElementById('otv-typeTransfert').value;
		formatExport = document.getElementById('otv-formatExport').value;
		if (isEmpty(formatExport)) { showWarning("Veuillez choisir un format d'export."); }
		else  if (checkNomFichierExport(formatExport)) {
			if (type=="FA") { otv_checkFacturesAvoirs("Export"); }
			else { otv_checkAcomptes("Export"); }
		}
	} catch (e) {
		recup_erreur(e);
	}
}


function otv_exporterFacturesAvoirs(listeFactures, listeAvoirs, journalId) {
	try {

		document.getElementById('otv-bTransfert').disabled = true;
		document.getElementById('otv-bExporter').disabled = true;

		var qExport = new QueryHttp("Facturation/Transfert/exporterEcritures.tmpl");
		qExport.setParam('Type_Liste', "Factures_Avoirs_Vente");
		qExport.setParam('Format_Id', formatExport);
		qExport.setParam('Journal_Id', journalId);
		qExport.setParam('Liste_Factures', listeFactures);
		qExport.setParam('Liste_Avoirs', listeAvoirs);
		var result = qExport.execute();

		telechargerFichier(result);

		document.getElementById('otv-bTransfert').disabled = false;
		document.getElementById('otv-bExporter').disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function otv_exporterAcomptes(listeAcomptes, listeAnnulAcomptes, journalId) {
	try {

		document.getElementById('otv-bTransfert').disabled = true;
		document.getElementById('otv-bExporter').disabled = true;

		var qExport = new QueryHttp("Facturation/Transfert/exporterEcritures.tmpl");
		qExport.setParam('Type_Liste', "Acomptes_Vente");
		qExport.setParam('Format_Id', formatExport);
		qExport.setParam('Journal_Id', journalId);
		qExport.setParam('Liste_Acomptes', listeAcomptes);
		qExport.setParam('Liste_Annul_Acomptes', listeAnnulAcomptes);
		var result = qExport.execute();

		telechargerFichier(result);

		document.getElementById('otv-bTransfert').disabled = false;
		document.getElementById('otv-bExporter').disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


