/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var oebt_aEtablissements = new Arbre('ComboListe/combo-etablissements.tmpl', 'oebt-etablissement');
var oebt_aDepotsDepart = new Arbre('ComboListe/combo-depotsStock.tmpl', 'oebt-depotDepart');
var oebt_aDepotsArrivee = new Arbre('ComboListe/combo-depotsStock.tmpl', 'oebt-depotArrivee');
var oebt_aLignes = new Arbre('Facturation/Transferts_Stocks/list-ligneTransfertStock.tmpl', 'oebt-listeArticlesBon');
var oebt_aVersion = new Arbre("Facturation/Transferts_Stocks/list-versionTransfertStock.tmpl","oebt-listeVersion");
var oebt_aUnites = new Arbre("ComboListe/combo-unitesVente.tmpl","oebt-unite");
var oebt_aModesExpedition = new Arbre("ComboListe/combo-modesExpedition.tmpl","oebt-modeExpedition");

var oebt_transfertId;
var oebt_ligneId = null;
var oebt_mode;
var oebt_etatBon;
var oebt_modifie = false;
var oebt_curEtablissement;
var oebt_curModeExpedition;
var oebt_curDepotDepart;
var oebt_curDepotArrivee;
var oebt_defautModeExpedition;
var oebt_currentIndex;
var oebt_toSelectLigne = null;



function oebt_init() {
	try {

		var config = getConfig();

		var actNbPieces = config.isActNbPieces();
		var actUnites = config.isActUnites();
		oebt_defautModeExpedition = config.getDefModeExpedition();
		var gtsDateExpLigne = config.isGTSDateExpLigne();
		var gtsDateRecLigne = config.isGTSDateRecLigne();

		document.getElementById('oebt-symboleUniteVolume').value = config.getSymboleUniteVolume();
		document.getElementById('oebt-symboleUnitePoids').value = config.getSymboleUnitePoids();

		if (!actNbPieces) {
			document.getElementById('oebt-colNbPieces').collapsed = true;
			document.getElementById('oebt-colNbPieces').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oebt-boxNbPieces').collapsed = true;
		}

		if (!actUnites) {
			document.getElementById('oebt-colUnite').collapsed = true;
			document.getElementById('oebt-colUnite').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oebt-boxUnite').collapsed = true;
		}

		if (!gtsDateExpLigne) {
			document.getElementById('oebt-colDateExpedition').collapsed = true;
			document.getElementById('oebt-colDateExpedition').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oebt-fieldDateExpedition').collapsed = true;
		}

		if (!gtsDateRecLigne) {
			document.getElementById('oebt-colDateReception').collapsed = true;
			document.getElementById('oebt-colDateReception').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oebt-fieldDateReception').collapsed = true;
		}

		oebt_aUnites.initTree(oebt_initUnite);

	} catch (e) {
		recup_erreur(e);
	}
}


function oebt_initUnite() {
	try {

		document.getElementById('oebt-unite').value = getConfig().getUniteDefaut();

	} catch (e) {
		recup_erreur(e);
	}
}


function oebt_chargerEtablissement(selection) {
	try {

		oebt_curEtablissement = selection;
		oebt_aEtablissements.setParam("Selection", selection);
		oebt_aEtablissements.initTree(oebt_initEtablissement);

	} catch (e) {
		recup_erreur(e);
	}
}


function oebt_initEtablissement() {
	try {

		document.getElementById('oebt-etablissement').value = oebt_curEtablissement;

	} catch (e) {
		recup_erreur(e);
	}
}


function oebt_chargerModeExpedition(selection) {
	try {

		oebt_curModeExpedition = selection;
		oebt_aModesExpedition.setParam("Selection", selection);
		oebt_aModesExpedition.initTree(oebt_initModeExpedition);

	} catch (e) {
		recup_erreur(e);
	}
}


function oebt_initModeExpedition() {
	try {

		document.getElementById('oebt-modeExpedition').value = oebt_curModeExpedition;

	} catch (e) {
		recup_erreur(e);
	}
}


function oebt_chargerDepotDepart(selection) {
	try {

		oebt_curDepotDepart = selection;
		oebt_aDepotsDepart.setParam("Selection", selection);
		oebt_aDepotsDepart.initTree(oebt_initDepotDepart);

	} catch (e) {
		recup_erreur(e);
	}
}


function oebt_initDepotDepart() {
	try {

		document.getElementById('oebt-depotDepart').value = oebt_curDepotDepart;

	} catch (e) {
		recup_erreur(e);
	}
}


function oebt_chargerDepotArrivee(selection) {
	try {

		oebt_curDepotArrivee = selection;
		oebt_aDepotsArrivee.setParam("Selection", selection);
		oebt_aDepotsArrivee.initTree(oebt_initDepotArrivee);

	} catch (e) {
		recup_erreur(e);
	}
}


function oebt_initDepotArrivee() {
	try {

		document.getElementById('oebt-depotArrivee').value = oebt_curDepotArrivee;

	} catch (e) {
		recup_erreur(e);
	}
}


function oebt_reinitialiser() {
	try {

		oebt_mode = "C";
		oebt_etatBon = "N";

		document.getElementById('oebt-deckBonTransfert').selectedIndex = 0;
		document.getElementById('oebt-tabBoxBon').selectedIndex = 0;
		document.getElementById('oebt-numero').value = "";
		document.getElementById('oebt-dateTransfert').value = "";
		document.getElementById('oebt-etat').value = "";
		document.getElementById('oebt-poidsTotal').value = 0;
		document.getElementById('oebt-volumeTotal').value = 0;

		oebt_aEtablissements.deleteTree();
		oebt_aDepotsDepart.deleteTree();
		oebt_aDepotsArrivee.deleteTree();

		document.getElementById('oebt-tabBon').setAttribute('image', null);

		document.getElementById('oebt-tabVersionDocument').collapsed=true;
		oebt_aVersion.deleteTree();

		document.getElementById('oebt-commentairesFin').value = "";
		document.getElementById('oebt-commentairesInt').value = "";
		document.getElementById('oebt-intitule').value = "";
		document.getElementById('oebt-dateExpedition').value = "";
		document.getElementById('oebt-dateReception').value = "";

		document.getElementById('oebt-creation').value = "";
		document.getElementById('oebt-modification').value = "";
		document.getElementById('oebt-fiche').value = "";
		document.getElementById('oebt-refArticle').value = "";
		document.getElementById('oebt-designation').value = "";
		document.getElementById('oebt-quantite').value = "1";
		document.getElementById('oebt-dateExpeditionLT').value = "";
		document.getElementById('oebt-dateReceptionLT').value = "";
		oebt_modifie = false;

		document.getElementById('oebt-refArticle').disabled = true;
		document.getElementById('oebt-bArticle').disabled = true;
		document.getElementById('oebt-bCommentaire').disabled = true;
		document.getElementById('oebt-designation').disabled = true;
		document.getElementById('oebt-quantite').disabled = true;
		document.getElementById('oebt-dateExpeditionLT').disabled = true;
		document.getElementById('oebt-dateReceptionLT').disabled = true;
		document.getElementById('oebt-bAnnuler').disabled = true;
		document.getElementById('oebt-bValider').disabled = true;
		document.getElementById('oebt-bSupprimer').disabled = true;

		document.getElementById('oebt-etablissement').disabled = true;
		document.getElementById('oebt-modeExpedition').disabled = true;
		document.getElementById('oebt-intitule').disabled = true;
		document.getElementById('oebt-dateExpedition').disabled = true;
		document.getElementById('oebt-dateReception').disabled = true;
		document.getElementById('oebt-depotDepart').disabled = true;
		document.getElementById('oebt-depotArrivee').disabled = true;
		document.getElementById('oebt-commentairesFin').disabled = true;
		document.getElementById('oebt-commentairesInt').disabled = true;

		document.getElementById('oebt-fleches').collapsed = true;
		document.getElementById('oebt-champsSaisie').collapsed = true;

		document.getElementById('oebt-bMoveUp').disabled = true;
		document.getElementById('oebt-bMoveDown').disabled = true;
		document.getElementById('oebt-bMoveFirst').disabled = true;
		document.getElementById('oebt-bMoveLast').disabled = true;
		document.getElementById('oebt-bImporterLignes').disabled = true;

		document.getElementById('oebt-listeArticlesBon').disabled = true;

		document.getElementById('oebt-etablissement').disabled = true;
		document.getElementById('oebt-bEnregistrer').disabled = true;
		document.getElementById('oebt-bValiderBT').disabled = true;
		document.getElementById('oebt-bAnnulerBT').disabled = true;
		document.getElementById('oebt-bSupprimerBT').disabled = true;
		document.getElementById('oebt-bVisualiser').disabled = true;
		document.getElementById('oebt-bGenReassort').disabled = true;
		document.getElementById('oebt-bExpeditions').disabled = true;
		document.getElementById('oebt-bReceptions').disabled = true;
		document.getElementById('oebt-bSolderLiv').disabled = true;
		document.getElementById('oebt-bSolderRec').disabled = true;
		document.getElementById('oebt-bOuvrirCommentairesCaches').disabled = true;
		document.getElementById('oebt-bChoisirMentions').disabled = true;

		document.getElementById('oebt-nbPieces').disabled = true;
		document.getElementById('oebt-unite').disabled = true;

		document.getElementById('oebt-bVisualiser').collapsed = true;
		document.getElementById('oebt-bValiderBT').collapsed = true;

		document.getElementById('oebt-creation').collapsed = true;
		document.getElementById('oebt-modification').collapsed = true;

		oebt_aLignes.deleteTree();

	} catch (e) {
		recup_erreur(e);
	}
}


function oebt_debloquerChamps() {
	try {

		document.getElementById('oebt-etablissement').disabled = false;
		document.getElementById('oebt-modeExpedition').disabled = false;
		document.getElementById('oebt-intitule').disabled = false;
		document.getElementById('oebt-dateExpedition').disabled = false;
		document.getElementById('oebt-dateReception').disabled = false;
		document.getElementById('oebt-depotDepart').disabled = false;
		document.getElementById('oebt-depotArrivee').disabled = false;
		document.getElementById('oebt-commentairesFin').disabled = false;
		document.getElementById('oebt-commentairesInt').disabled = false;
		document.getElementById('oebt-listeArticlesBon').disabled = false;

		document.getElementById('oebt-bChoisirMentions').disabled = false;
		document.getElementById('oebt-bVisualiser').disabled = false;
		document.getElementById('oebt-bEnregistrer').disabled = false;
		document.getElementById('oebt-bSupprimerBT').disabled = false;
		document.getElementById('oebt-bGenReassort').disabled = false;
		document.getElementById('oebt-bExpeditions').disabled = false;
		document.getElementById('oebt-bReceptions').disabled = false;
		document.getElementById('oebt-bSolderLiv').disabled = false;
		document.getElementById('oebt-bSolderRec').disabled = false;

	} catch (e) {
    recup_erreur(e);
  }
}


function oebt_nouveauBon() {
  try {

		oebt_transfertId = "";
  	oebt_reinitialiser();
  	oebt_chargerEtablissement(etablissementDefaut);
  	oebt_chargerDepotDepart(depotDefaut);
  	oebt_chargerDepotArrivee("");
		oebt_chargerModeExpedition(oebt_defautModeExpedition);

		document.getElementById('oebt-etat').value = "Nouveau";
		document.getElementById('oebt-bEnregistrer').collapsed = false;
		document.getElementById('oebt-fleches').collapsed = false;
		document.getElementById('oebt-champsSaisie').collapsed = false;
		document.getElementById('oebt-bSupprimerBT').collapsed = true;
		document.getElementById('oebt-bAnnulerBT').collapsed = true;
		document.getElementById('oebt-bGenReassort').collapsed = true;
		document.getElementById('oebt-bExpeditions').collapsed = true;
		document.getElementById('oebt-bReceptions').collapsed = true;
		document.getElementById('oebt-bSolderLiv').collapsed = true;
		document.getElementById('oebt-bSolderRec').collapsed = true;

		oebt_debloquerChamps();
		oebt_setModifie(false);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oebt_chargerBon() {
  try {

		oebt_reinitialiser();

		oebt_mode = "M";
		var qLoad = new QueryHttp('Facturation/Transferts_Stocks/loadTransfertStock.tmpl');
		qLoad.setParam("Transfert_Id", oebt_transfertId);
		var result = qLoad.execute();
		var contenu = result.responseXML.documentElement;

		oebt_etatBon = contenu.getAttribute("Etat");
		var soldeLiv = contenu.getAttribute("Solde_Liv")=="true";
		var soldeRec = contenu.getAttribute("Solde_Rec")=="true";

		document.getElementById('oebt-bAnnulerBT').disabled = (oebt_etatBon!="T" && oebt_etatBon!="C");

		if (oebt_etatBon=="C") {
			document.getElementById('oebt-etat').value = "Cl\u00F4tur\u00E9";
			document.getElementById('oebt-bSupprimerBT').collapsed = true;
			document.getElementById('oebt-bAnnulerBT').collapsed = true;
			document.getElementById('oebt-bGenReassort').collapsed = true;
			document.getElementById('oebt-bExpeditions').disabled = false;
			document.getElementById('oebt-bReceptions').disabled = false;
			document.getElementById('oebt-bExpeditions').collapsed = false;
			document.getElementById('oebt-bReceptions').collapsed = false;
			document.getElementById('oebt-bSolderLiv').collapsed = true;
			document.getElementById('oebt-bSolderRec').collapsed = true;
			document.getElementById('oebt-bEnregistrer').collapsed = true;
		}
		else if (oebt_etatBon=="T") {
			document.getElementById('oebt-etat').value = "En cours";
			//document.getElementById('oebt-commentairesFin').disabled = false;
			//document.getElementById('oebt-commentairesInt').disabled = false;
			//document.getElementById('oebt-bEnregistrer').disabled = false;
			document.getElementById('oebt-bEnregistrer').collapsed = true;
			document.getElementById('oebt-bSupprimerBT').collapsed = true;
			document.getElementById('oebt-bAnnulerBT').collapsed = false;
			document.getElementById('oebt-bGenReassort').collapsed = true;
			document.getElementById('oebt-bExpeditions').disabled = false;
			document.getElementById('oebt-bReceptions').disabled = false;
			document.getElementById('oebt-bExpeditions').collapsed = false;
			document.getElementById('oebt-bReceptions').collapsed = false;
			document.getElementById('oebt-bSolderLiv').disabled = false;
			document.getElementById('oebt-bSolderRec').disabled = false;
			document.getElementById('oebt-bSolderLiv').collapsed = soldeLiv;
			document.getElementById('oebt-bSolderRec').collapsed = (!soldeLiv || soldeRec);
		}
		else if (oebt_etatBon=="A") {
			document.getElementById('oebt-etat').value = "Annul\u00E9";
			document.getElementById('oebt-bEnregistrer').collapsed = true;
			document.getElementById('oebt-bSupprimerBT').collapsed = true;
			document.getElementById('oebt-bAnnulerBT').collapsed = true;
			document.getElementById('oebt-bGenReassort').collapsed = true;
			document.getElementById('oebt-bExpeditions').collapsed = true;
			document.getElementById('oebt-bReceptions').collapsed = true;
			document.getElementById('oebt-bSolderLiv').collapsed = true;
			document.getElementById('oebt-bSolderRec').collapsed = true;
		}
		else {
			document.getElementById('oebt-etat').value = "Nouveau";
			document.getElementById('oebt-bEnregistrer').collapsed = false;
			document.getElementById('oebt-bAnnulerBT').collapsed = true;
			document.getElementById('oebt-bSupprimerBT').collapsed = false;
			document.getElementById('oebt-bGenReassort').collapsed = false;
			document.getElementById('oebt-refArticle').disabled = false;
			document.getElementById('oebt-bArticle').disabled = false;
			document.getElementById('oebt-designation').disabled = false;
			document.getElementById('oebt-quantite').disabled = false;
			document.getElementById('oebt-dateExpeditionLT').disabled = false;
			document.getElementById('oebt-dateReceptionLT').disabled = false;
			document.getElementById('oebt-bAnnuler').disabled = false;
			document.getElementById('oebt-bValider').disabled = false;
			document.getElementById('oebt-fleches').collapsed = false;
			document.getElementById('oebt-champsSaisie').collapsed = false;
			document.getElementById('oebt-nbPieces').disabled = false;
			document.getElementById('oebt-unite').disabled = false;
			document.getElementById('oebt-bExpeditions').collapsed = true;
			document.getElementById('oebt-bReceptions').collapsed = true;
			document.getElementById('oebt-bSolderLiv').collapsed = true;
			document.getElementById('oebt-bSolderRec').collapsed = true;
		}

		document.getElementById('oebt-bVisualiser').collapsed = (oebt_etatBon=='N');
		document.getElementById('oebt-bValiderBT').collapsed = (oebt_etatBon!='N');
		document.getElementById('oebt-bImporterLignes').disabled = (oebt_etatBon!='N');

		oebt_chargerEtablissement(contenu.getAttribute('Etab_Id'));
		oebt_chargerDepotDepart(contenu.getAttribute('Depot_Depart'));
		oebt_chargerDepotArrivee(contenu.getAttribute('Depot_Arrivee'));
		oebt_chargerModeExpedition(contenu.getAttribute('Mode_Expedition'));

		document.getElementById('oebt-numero').value = contenu.getAttribute("Numero");
		document.getElementById('oebt-dateTransfert').value = contenu.getAttribute("Date_Transfert");
		document.getElementById('oebt-commentairesFin').value = contenu.getAttribute("Commentaires_Fin");
		document.getElementById('oebt-commentairesInt').value = contenu.getAttribute("Commentaires_Int");
		document.getElementById('oebt-intitule').value = contenu.getAttribute("Intitule");
		document.getElementById('oebt-dateExpedition').value = contenu.getAttribute("Date_Expedition");
		document.getElementById('oebt-dateReception').value = contenu.getAttribute("Date_Reception");
		document.getElementById('oebt-bOuvrirCommentairesCaches').disabled = false;

		document.getElementById('oebt-creation').setAttribute("label","Transfert cr\u00E9\u00E9 le "+ contenu.getAttribute('Date_Creation') +" par "+ contenu.getAttribute('Login_Createur'));
		document.getElementById('oebt-modification').setAttribute("label","Derni\u00E8re modification le "+ contenu.getAttribute('Date_Maj') +" par "+ contenu.getAttribute('Login_Maj'));
		document.getElementById('oebt-fiche').setAttribute("label","Transfert N\u00B0 "+ contenu.getAttribute('Numero'));
		document.getElementById('oebt-creation').collapsed = false;
		document.getElementById('oebt-modification').collapsed = false;

		oebt_calculerPoids();

		oebt_aLignes.setParam('Transfert_Id', oebt_transfertId);
		oebt_aLignes.initTree();

		if (oebt_etatBon=='N') {
			oebt_debloquerChamps();
		}
		else {
			document.getElementById('oebt-tabVersionDocument').collapsed = false;
			oebt_initVersion();
		}
		oebt_setModifie(false);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oebt_majAffichageUtilM() {
	try {

		var qLoad = new QueryHttp('Facturation/Transferts_Stocks/loadTransfertStock.tmpl');
		qLoad.setParam("Transfert_Id", oebt_transfertId);
		var result = qLoad.execute();
		var contenu = result.responseXML.documentElement;
		document.getElementById('oebt-modification').setAttribute("label","Derni\u00E8re modification le "+ contenu.getAttribute('Date_Maj') +" par "+ contenu.getAttribute('Login_Maj'));

	} catch (e) {
		recup_erreur(e);
	}
}


function oebt_enregistrerBon(rafraichir) {
  try {

  	var ok = false;

		var commentairesFin = document.getElementById('oebt-commentairesFin').value;
		var commentairesInt = document.getElementById('oebt-commentairesInt').value;
		var etablissement = document.getElementById('oebt-etablissement').value;
		var modeExpedition = document.getElementById('oebt-modeExpedition').value;
		var intitule = document.getElementById('oebt-intitule').value;
		var dateExpedition = document.getElementById('oebt-dateExpedition').value;
		var dateReception = document.getElementById('oebt-dateReception').value;
		var depotDepart = document.getElementById('oebt-depotDepart').value;
		var depotArrivee = document.getElementById('oebt-depotArrivee').value;

		if (isEmpty(etablissement)) { showWarning("Veuillez choisir l'\u00E9tablissement."); }
		else if (isEmpty(depotDepart)) { showWarning("Veuillez choisir le d\u00E9p\u00F4t de d\u00E9part."); }
		else if (isEmpty(depotArrivee)) { showWarning("Veuillez choisir le d\u00E9p\u00F4t d'arriv\u00E9e."); }
		else if (depotDepart==depotArrivee) { showWarning("Le d\u00E9p\u00F4t de d\u00E9part doit \u00EAtre diff\u00E9rent du d\u00E9p\u00F4t d'arriv\u00E9e."); }
		else {
			var qSave;

			if (oebt_mode=="C") {
				qSave = new QueryHttp("Facturation/Transferts_Stocks/createTransfertStock.tmpl");
			}
			else {
				qSave = new QueryHttp("Facturation/Transferts_Stocks/updateTransfertStock.tmpl");
				qSave.setParam("Transfert_Id", oebt_transfertId);
			}

			qSave.setParam("Commentaires_Fin",commentairesFin);
			qSave.setParam("Commentaires_Int",commentairesInt);
			qSave.setParam("Etab_Id", etablissement);
			qSave.setParam("Depot_Depart", depotDepart);
			qSave.setParam("Depot_Arrivee", depotArrivee);
			qSave.setParam("Mode_Expedition", modeExpedition);
			qSave.setParam("Intitule", intitule);
			qSave.setParam("Date_Expedition", dateExpedition);
			qSave.setParam("Date_Reception", dateReception);

			var result = qSave.execute();
			var contenu = result.responseXML.documentElement;

			if (oebt_mode=="C") {
				oebt_transfertId = contenu.getAttribute("Transfert_Id");
				if (rafraichir) { oebt_chargerBon(); }
			}
			else {
				oebt_majAffichageUtilM();
			}

			oebt_setModifie(false);
			ok = true;
		}

		return ok;

	} catch (e) {
  	recup_erreur(e);
  }
}


function oebt_supprimerBon() {
  try {

		if (window.confirm("Confirmez-vous la suppression du transfert de stock ?")) {

			var qDelete = new QueryHttp("Facturation/Transferts_Stocks/deleteTransfertStock.tmpl");
			qDelete.setParam("Transfert_Id", oebt_transfertId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("Le transfert de stock a \u00E9t\u00E9 supprim\u00E9.");
				retourMenuTransferts();
			}
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oebt_deplacerLigne(moveType) {
	try {

		if (oebt_ligneId!=null && oebt_mode=="M") {

			document.getElementById('oebt-bMoveUp').disabled = true;
			document.getElementById('oebt-bMoveDown').disabled = true;
			document.getElementById('oebt-bMoveFirst').disabled = true;
			document.getElementById('oebt-bMoveLast').disabled = true;

			var qMove = new QueryHttp("Facturation/Transferts_Stocks/moveLigneTransfertStock.tmpl");
			qMove.setParam("Ligne_Id", oebt_ligneId);
			qMove.setParam("Move_Type", moveType);
			var result = qMove.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oebt_toSelectLigne = oebt_ligneId;
				oebt_annulerLigne();
				oebt_aLignes.initTree(oebt_afterRefreshLignes);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oebt_afterRefreshLignes() {
	try {

		if (oebt_toSelectLigne!=null) {
			for (var i=0; i<oebt_aLignes.nbLignes(); i++) {
				if (oebt_aLignes.getCellText(i, "oebt-colLigneId")==oebt_toSelectLigne && oebt_aLignes.getCellText(i, "oebt-colTypeLigne")!="C") {
					oebt_aLignes.select(i);
					break;
				}
			}
			oebt_toSelectLigne = null;
		}
		oebt_aLignes.ensureRowIsVisible(oebt_currentIndex);

	} catch (e) {
  	recup_erreur(e);
	}
}


function oebt_annulerLigne() {
	try {

		oebt_aLignes.clearSelection();
		oebt_ligneId = null;

		oebt_initLigneIHM();

		document.getElementById('oebt-refArticle').focus();

	} catch (e) {
		recup_erreur(e);
	}
}


function oebt_initLigneIHM() {
	try {

		document.getElementById('oebt-bMoveUp').disabled = true;
		document.getElementById('oebt-bMoveDown').disabled = true;
		document.getElementById('oebt-bMoveFirst').disabled = true;
		document.getElementById('oebt-bMoveLast').disabled = true;

		document.getElementById('oebt-refArticle').value = "";
		document.getElementById('oebt-designation').value = "";
		document.getElementById('oebt-quantite').value = "1";
		document.getElementById('oebt-dateExpeditionLT').value = "";
		document.getElementById('oebt-dateReceptionLT').value = "";
		document.getElementById('oebt-refArticle').disabled = false;
		document.getElementById('oebt-bArticle').disabled = false;
		document.getElementById('oebt-bCommentaire').disabled = true;
		document.getElementById('oebt-bSupprimer').disabled = true;
		document.getElementById('oebt-nbPieces').value = "";

		oebt_initUnite();

	} catch (e) {
		recup_erreur(e);
	}
}


function oebt_pressOnWindow(ev) {
	try {

		if (ev.altKey && oebt_mode!="V") {
			switch(ev.charCode) {
      	case 97: // 'a'
				case 65: // 'A'
        	oebt_rechercherStock();
        	break;
    	}
		}
		else if (ev.ctrlKey && oebt_mode!="V" && ev.keyCode==46) {
			// ctrl + suppr
			ev.preventDefault();
			oebt_supprimerLigne();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oebt_validerLigne() {
	try {

		var reference = document.getElementById('oebt-refArticle').value;
		var quantite = document.getElementById('oebt-quantite').value;
		var nbPieces = document.getElementById('oebt-nbPieces').value;
		var uniteId = document.getElementById("oebt-unite").value;
		var dateExpedition = document.getElementById('oebt-dateExpeditionLT').value;
		var dateReception = document.getElementById('oebt-dateReceptionLT').value;

		if (isEmpty(reference)) { showWarning("Veuillez saisir une r\u00E9f\u00E9rence."); }
		else if (!checkQte(quantite)) { showWarning("La quantit\u00E9 est incorrecte.");	}
		else if (!isEmpty(nbPieces) && !isPositiveOrNullInteger(nbPieces)) { showWarning("Nombre de pi\u00E8ces incorrect !");	}
		else if (!isEmpty(dateExpedition) && !isDate(dateExpedition)) { showWarning("Date d'exp\u00E9dition pr\u00E9vue incorrecte"); }
		else if (!isEmpty(dateReception) && !isDate(dateReception)) { showWarning("Date de r\u00E9ception pr\u00E9vue incorrecte"); }
		else {
			var qSave;

			if (oebt_ligneId!=null) {
				qSave = new QueryHttp("Facturation/Transferts_Stocks/updateLigneTransfertStock.tmpl");
				qSave.setParam("Ligne_Id", oebt_ligneId);
			}
			else {
				qSave = new QueryHttp("Facturation/Transferts_Stocks/createLigneTransfertStock.tmpl");
				qSave.setParam("Transfert_Id", oebt_transfertId);
				qSave.setParam("Reference", reference);
			}
			qSave.setParam("Quantite", quantite);
			qSave.setParam("Nb_Pieces", nbPieces);
			qSave.setParam("Unite_Id", uniteId);
			qSave.setParam("Date_Expedition", dateExpedition);
			qSave.setParam("Date_Reception", dateReception);
			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oebt_calculerPoids();
				document.getElementById('oebt-bMoveUp').disabled = true;
				document.getElementById('oebt-bMoveDown').disabled = true;
				document.getElementById('oebt-bMoveFirst').disabled = true;
				document.getElementById('oebt-bMoveLast').disabled = true;
				oebt_aLignes.initTree(oebt_annulerLigne);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oebt_supprimerLigne() {
	try {

		var listLigneId = "";
		var maxIndex = 0;

		if (oebt_aLignes.nbSelection()==1) {
			listLigneId = oebt_ligneId;
			maxIndex = oebt_currentIndex;
		}
		else {
			var start = new Object();
			var end = new Object();
			var numRanges = oebt_aLignes.getRangeCount();

			for (var t=0; t<numRanges; t++){
				oebt_aLignes.getRangeAt(t,start,end);
			  for (var v=start.value; v<=end.value; v++){
					if (oebt_aLignes.getCellText(v,'oebt-colTypeLigne')!="C") {
			  		listLigneId += oebt_aLignes.getCellText(v,'oebt-colLigneId')+",";
						if (v>maxIndex) maxIndex = v;
					}
			  }
			}
		}

		if (!isEmpty(listLigneId)) {
			var qDelete = new QueryHttp("Facturation/Transferts_Stocks/deleteLigneTransfertStock.tmpl");
			qDelete.setParam('List_Ligne_Id', listLigneId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oebt_currentIndex = maxIndex-1;
				oebt_calculerPoids();
				document.getElementById('oebt-bMoveUp').disabled = true;
				document.getElementById('oebt-bMoveDown').disabled = true;
				document.getElementById('oebt-bMoveFirst').disabled = true;
				document.getElementById('oebt-bMoveLast').disabled = true;
				oebt_aLignes.initTree(oebt_annulerLigne);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oebt_selectOnListeArticlesBon() {
	try {

		if (oebt_aLignes.isSelected()) {

			if (oebt_aLignes.nbSelection()==1) {
				oebt_currentIndex = oebt_aLignes.getCurrentIndex();
				oebt_ligneId = oebt_aLignes.getSelectedCellText('oebt-colLigneId');
				document.getElementById('oebt-bMultiSuppression').disabled = true;

				if (oebt_aLignes.getSelectedCellText('oebt-colTypeLigne')=="C") {
					oebt_initLigneIHM();
				}
				else {
					document.getElementById('oebt-refArticle').value = oebt_aLignes.getSelectedCellText('oebt-colReference');
					document.getElementById('oebt-designation').value = oebt_aLignes.getSelectedCellText('oebt-colDesignation');
					document.getElementById('oebt-quantite').value = oebt_aLignes.getSelectedCellText('oebt-colQuantite');
					document.getElementById('oebt-nbPieces').value = oebt_aLignes.getSelectedCellText('oebt-colNbPieces');
					document.getElementById('oebt-unite').value = oebt_aLignes.getSelectedCellText('oebt-colUniteId');
					document.getElementById('oebt-dateExpeditionLT').value = oebt_aLignes.getSelectedCellText('oebt-colDateExpedition');
					document.getElementById('oebt-dateReceptionLT').value = oebt_aLignes.getSelectedCellText('oebt-colDateReception');
					document.getElementById('oebt-refArticle').disabled = true;
					document.getElementById('oebt-bArticle').disabled = true;
					document.getElementById('oebt-bCommentaire').disabled = false;
					document.getElementById('oebt-bSupprimer').disabled = false;

					var firstIndex = 0;
					var lastIndex = oebt_aLignes.nbLignes()-1;

					document.getElementById('oebt-bMoveUp').disabled = (oebt_currentIndex==firstIndex);
					document.getElementById('oebt-bMoveDown').disabled = (oebt_currentIndex==lastIndex);
					document.getElementById('oebt-bMoveFirst').disabled = (oebt_currentIndex==firstIndex);
					document.getElementById('oebt-bMoveLast').disabled = (oebt_currentIndex==lastIndex);
				}
			}
			else {
				oebt_initLigneIHM();
				document.getElementById('oebt-bMultiSuppression').disabled = false;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oebt_pressOnRefArticle(ev) {
	try {

		if (ev.keyCode==13) {
			oebt_rechercherReference();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oebt_pressOnQuantite(ev) {
	try {

		if (ev.keyCode==13) {
			oebt_validerLigne();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oebt_rechercherReference() {
	try {

		var reference = document.getElementById('oebt-refArticle').value;

		var qSearch = new QueryHttp("Facturation/Articles/searchReference.tmpl");
		qSearch.setParam("No_Forfait", true);
		qSearch.setParam("Reference", reference);
		var result = qSearch.execute();

		var articleId = result.responseXML.documentElement.getAttribute("Article_Id");

		if (!isEmpty(articleId)) {
			document.getElementById('oebt-refArticle').value = result.responseXML.documentElement.getAttribute("Reference");
			oebt_afficherDesignation(articleId);
		}
		else {
			oebt_rechercherStock(reference);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oebt_rechercherStock(reference) {
	try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oebt_retourRechercherStock, null, reference, null, true);

	} catch (e) {
    recup_erreur(e);
  }
}


function oebt_retourRechercherStock(reference, articleId) {
	try {

		document.getElementById('oebt-refArticle').value = reference;
		oebt_afficherDesignation(articleId);

	} catch (e) {
    recup_erreur(e);
  }
}


function oebt_afficherDesignation(articleId) {
	try {

		var qDesignation = new QueryHttp("Facturation/Articles/getDesignation.tmpl");
		qDesignation.setParam("Article_Id", articleId);
		var result = qDesignation.execute();
		document.getElementById('oebt-designation').value = result.responseXML.documentElement.getAttribute("Designation");
		document.getElementById('oebt-quantite').focus();

	} catch (e) {
		recup_erreur(e);
	}
}


function oebt_demandeEnregistrement() {
  try {

		if (oebt_modifie) {
			if (window.confirm("Voulez-vous enregistrer les modifications apport\u00E9es au transfert de stock ?")) {
				oebt_enregistrerBon(false);
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oebt_setModifie(m) {
  try {

  	oebt_modifie = m;
		if (m) {
			document.getElementById('oebt-tabBon').setAttribute('image', 'chrome://opensi/content/design/icones/modified.png');
			document.getElementById('oebt-bValiderBT').disabled = true;
			document.getElementById('oebt-bVisualiser').disabled = (oebt_etatBon!='T');
			document.getElementById('oebt-bGenReassort').disabled = true;
		}
		else {
			document.getElementById('oebt-tabBon').setAttribute('image', null);
			document.getElementById('oebt-bValiderBT').disabled = (oebt_etatBon=='T');
			document.getElementById('oebt-bVisualiser').disabled = false;
			document.getElementById('oebt-bGenReassort').disabled = false;
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oebt_visualiserBon() {
  try {

		if (oebt_aLignes.nbLignes()==0) {
			showWarning("Le transfert de stock ne contient aucune ligne !");
		}
		else {
			document.getElementById("bRetourTransfert").collapsed = false;
			document.getElementById("oebt-deckBonTransfert").selectedIndex = 1;
			oebt_editerBon();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oebt_editerBon() {
	try {

		document.getElementById('oebt-pdfBonTransfert').setAttribute("src", "");
		var qGenPdf = new QueryHttp("Facturation/Transferts_Stocks/pdfTransfertStock.tmpl");
		qGenPdf.setParam('Transfert_Id', oebt_transfertId);
		var result = qGenPdf.execute();
		var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
		document.getElementById('oebt-pdfBonTransfert').setAttribute("src", page);

	} catch (e) {
		recup_erreur(e);
	}
}


function oebt_envoyerMail() {
	try {

		var url = "chrome://opensi/content/popup/popup-envoyerMail.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', "TS", oebt_transfertId);

	} catch (e) {
		recup_erreur(e);
	}
}


function oebt_validerBon() {
  try {

		if (oebt_aLignes.nbLignes()==0) {
			showWarning("Le transfert de stock ne contient aucune ligne.");
		}
  	else if (window.confirm("Confirmez-vous la validation du transfert de stock ?")) {

			var qValider = new QueryHttp("Facturation/Transferts_Stocks/validTransfertStock.tmpl");
			qValider.setParam('Transfert_Id', oebt_transfertId);
			var result = qValider.execute();
			var errors = new Errors(result);

			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oebt_chargerBon();
			}
  	}

	} catch (e) {
    recup_erreur(e);
  }
}


function oebt_annulerBon() {
	try {

		if (window.confirm("Confirmez-vous l'annulation du transfert de stock ?")) {
			var qAnnuler = new QueryHttp("Facturation/Transferts_Stocks/cancelTransfertStock.tmpl");
			qAnnuler.setParam('Transfert_Id', oebt_transfertId);
			var result = qAnnuler.execute();
			var errors = new Errors(result);

			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("Le transfert de stock a \u00E9t\u00E9 annul\u00E9.");
				oebt_chargerBon();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oebt_solderLivraison() {
	try {

		if (window.confirm("Confirmez-vous le solde de la livraison du transfert de stock ?")) {
			var qSolder = new QueryHttp("Facturation/Transferts_Stocks/settleLivraison.tmpl");
			qSolder.setParam('Transfert_Id', oebt_transfertId);
			var result = qSolder.execute();
			var errors = new Errors(result);

			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("Le transfert de stock a \u00E9t\u00E9 sold\u00E9 en livraison.");
				oebt_chargerBon();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oebt_solderReception() {
	try {

		if (window.confirm("Confirmez-vous le solde de la r\u00E9ception du transfert de stock ?")) {
			var qSolder = new QueryHttp("Facturation/Transferts_Stocks/settleReception.tmpl");
			qSolder.setParam('Transfert_Id', oebt_transfertId);
			var result = qSolder.execute();
			var errors = new Errors(result);

			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("Le transfert de stock a \u00E9t\u00E9 sold\u00E9 en r\u00E9ception.");
				oebt_chargerBon();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oebt_initVersion() {
	try {

		oebt_aVersion.setParam("Transfert_Id", oebt_transfertId);
		oebt_aVersion.initTree();

	} catch (e) {
		recup_erreur(e);
	}
}


function oebt_editerCommentairesInternes()  {
  try {

  	var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesInternes.xul";
  	window.openDialog(url,'','chrome,modal,centerscreen', "TS", oebt_transfertId, false);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oebt_editerCommentairesDocument() {
  try {

		var commentairesFin = document.getElementById('oebt-commentairesFin').value;
		var commentairesInt = document.getElementById('oebt-commentairesInt').value;
		var readOnly = (oebt_etatBon!='N');

		var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesDocument.xul";
  	window.openDialog(url,'','chrome,modal,centerscreen', oebt_retourEditerCommentaires, "TS", oebt_transfertId, commentairesFin, commentairesInt, readOnly);

	} catch (e) {
    recup_erreur(e);
  }
}


function oebt_retourEditerCommentaires(commentairesFin, commentairesInt) {
  try {

		document.getElementById('oebt-commentairesFin').value = commentairesFin;
		document.getElementById('oebt-commentairesInt').value = commentairesInt;

	} catch (e) {
    recup_erreur(e);
  }
}


function oebt_choisirMentions() {
  try {

  	var ok = true;

  	if (oebt_mode=="C") {
			ok = oebt_enregistrerBon(true);
		}

		if (ok) {
			var url = "chrome://opensi/content/facturation/user/commun/popup-mentionsDocument.xul";
	    window.openDialog(url,'','chrome,modal,centerscreen', "TS", oebt_transfertId, false);
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oebt_ouvrirCommentaire() {
  try {

		if (oebt_aLignes.isSelected() && oebt_mode=="M") {
			if (oebt_aLignes.getSelectedCellText('oebt-colTypeLigne')=="C") {
				oebt_editerCommentaire();
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oebt_editerCommentaire() {
  try {

		if (oebt_ligneId!=null) {
			var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesLigne.xul";
    	window.openDialog(url,'','chrome,modal,centerscreen', "TS", oebt_ligneId);

			oebt_aLignes.initTree(oebt_annulerLigne);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oebt_genReassort() {
	try {

		var qReassort = new QueryHttp("Facturation/Transferts_Stocks/genReassortTransfert.tmpl");
		qReassort.setParam('Transfert_Id', oebt_transfertId);
		qReassort.execute();

		oebt_aLignes.initTree(oebt_annulerLigne);

	} catch (e) {
		recup_erreur(e);
	}
}


function oebt_accExpeditions() {
	try {

		document.getElementById('deck').selectedIndex = 2;
		document.getElementById('bMenuTransferts').collapsed = false;
		document.getElementById('bRetourTransfert').collapsed = false;
		oets_transfertId = oebt_transfertId;
		oets_start();

	} catch (e) {
		recup_erreur(e);
	}
}


function oebt_accReceptions() {
	try {

		document.getElementById('deck').selectedIndex = 3;
		document.getElementById('bMenuTransferts').collapsed = false;
		document.getElementById('bRetourTransfert').collapsed = false;
		orts_transfertId = oebt_transfertId;
		orts_start();

	} catch (e) {
		recup_erreur(e);
	}
}


function oebt_importLignes() {
  try {

	  var url = "chrome://opensi/content/facturation/user/transferts_stocks/popup-importerLignes.xul";
	  window.openDialog(url,'','chrome,modal,centerscreen', oebt_retourImportLignes, oebt_transfertId);

  } catch (e) {
    recup_erreur(e);
  }
}


function oebt_retourImportLignes() {
	try {

		oebt_aLignes.initTree();

	} catch (e) {
	  recup_erreur(e);
	}
}


function oebt_calculerPoids() {
	try {

		var qGet = new QueryHttp("Facturation/Transferts_Stocks/getPoidsVolumeTS.tmpl");
		qGet.setParam("Transfert_Id", oebt_transfertId);
		var result = qGet.execute();

		document.getElementById('oebt-poidsTotal').value = result.responseXML.documentElement.getAttribute("Poids");
		document.getElementById('oebt-volumeTotal').value = result.responseXML.documentElement.getAttribute("Volume");

	} catch (e) {
		recup_erreur(e);
	}
}
