/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/formatter.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/lib_tva.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arrondi.js");

var nf2 = new NumberFormat("0.00", true);
var arr2 = new Arrondi(2);
var arr4 = new Arrondi(4);
var arr6 = new Arrondi(6);
var arr9 = new Arrondi(9);


function CalculDocument() {

	// variables en entre
	this.editionTTC = false;
	this.remiseP = 0;
	this.fraisPortBruts = 0;
	this.remiseFPP = 0;
	this.codeTVAFP = 0;
	this.tauxTVAFP = 0;
	this.escompteP = 0;
	this.acompte = 0;

	// variables en sortie
	this.remiseFPM = 0;
	this.fraisPortNets = 0;
	this.montantHT = 0;
	this.remiseM = 0;
	this.totalHT = 0;
	this.totalTVA = 0;
	this.montantTTC = 0;
	this.escompteM = 0;
	this.totalTTC = 0;
	this.netAPayer = 0;
	this.netCommercial = 0;

	// donnes internes
	this.lignesDocument = new Array();
	this.lignesVentilTVA = new Array();
}


CalculDocument.prototype.setEditionTTC = function(editionTTC) { this.editionTTC = editionTTC; }
CalculDocument.prototype.setRemiseP = function(remiseP) { this.remiseP = parseFloat(remiseP); }
CalculDocument.prototype.setRemiseM = function(remiseM) { this.remiseM = parseFloat(remiseM); }
CalculDocument.prototype.setFraisPortBruts = function(fraisPortBruts) { this.fraisPortBruts = parseFloat(fraisPortBruts); }
CalculDocument.prototype.setRemiseFPP = function(remiseFPP) { this.remiseFPP = parseFloat(remiseFPP); }
CalculDocument.prototype.setRemiseFPM = function(remiseFPM) { this.remiseFPM = parseFloat(remiseFPM); }
CalculDocument.prototype.setTauxTVAFP = function(tauxTVAFP) {
	//  modifier plus tard ; si on reoit le code tva, on pourra retrouver le taux
	this.tauxTVAFP = parseFloat(tauxTVAFP);
	this.codeTVAFP = (this.tauxTVAFP==0?1:getCodeTvaNormalFrance());
}
CalculDocument.prototype.setCodeAndTauxTVAFP= function(codeTVAFP,tauxTVAFP) {
	this.tauxTVAFP = parseFloat(tauxTVAFP);
	this.codeTVAFP = codeTVAFP;
}

CalculDocument.prototype.setEscompteP = function(escompteP) { this.escompteP = parseFloat(escompteP); }
CalculDocument.prototype.setAcompte = function(acompte) { this.acompte = parseFloat(acompte); }

CalculDocument.prototype.getMontantHT = function() { return nf2.format(this.montantHT); }
CalculDocument.prototype.getRemiseM = function() { return nf2.format(this.remiseM); }
CalculDocument.prototype.afficherRemiseM = function() { return (this.remiseM!=0); }
CalculDocument.prototype.getFraisPortBruts = function() { return nf2.format(this.fraisPortBruts); }
CalculDocument.prototype.getRemiseFPM = function() { return nf2.format(this.remiseFPM); }
CalculDocument.prototype.afficherRemiseFPM = function() { return (this.remiseFPM!=0); }
CalculDocument.prototype.getTotalHT = function() { return nf2.format(this.totalHT); }
CalculDocument.prototype.getTotalTVA = function() { return nf2.format(this.totalTVA); }
CalculDocument.prototype.getMontantTTC = function() { return nf2.format(this.montantTTC); }
CalculDocument.prototype.getEscompteM = function() { return nf2.format(this.escompteM); }
CalculDocument.prototype.afficherEscompteM = function() { return (this.escompteM!=0); }
CalculDocument.prototype.getAcompte = function() { return nf2.format(this.acompte); }
CalculDocument.prototype.getTotalTTC = function() { return nf2.format(this.totalTTC); }
CalculDocument.prototype.getNetAPayer = function() { return nf2.format(this.netAPayer); }
CalculDocument.prototype.getNetCommercial = function() { return nf2.format(this.netCommercial); }
CalculDocument.prototype.afficherNetCommercial = function() { return (this.escompteM!=0 && this.remiseM!=0); }

// ncessaire pour ne pas faire buguer les interfaces
CalculDocument.prototype.getMontantHTSansFormat = function() { return this.montantHT; }
CalculDocument.prototype.getTotalHTSansFormat = function() { return this.totalHT; }
CalculDocument.prototype.getMontantTTCSansFormat = function() { return this.montantTTC; }


CalculDocument.prototype.addLigneDocument = function(montantLigne, codeTVA) {
	this.lignesDocument.push(new LigneDocument(montantLigne, codeTVA));
}


CalculDocument.prototype.calculerVentilTVA = function() {

	var codeTVAFPTrouve = false;
	for (var i=0; i<this.lignesDocument.length; i++) {
		var trouve = false;
		var j=0;
		while (!trouve && j<this.lignesVentilTVA.length) {
			if (this.lignesDocument[i].codeTVA==this.lignesVentilTVA[j].codeTVABase) {
				trouve = true;
			} else {
				j++;
			}
		}

		if (trouve) {
			this.lignesVentilTVA[j].baseBrut += this.lignesDocument[i].montantLigne;
		} else {
			var ligneVentilTVA = new LigneVentilTVA();
			ligneVentilTVA.codeTVABase = this.lignesDocument[i].codeTVA;
			ligneVentilTVA.tauxTVABase = this.lignesDocument[i].tauxTVA;
			ligneVentilTVA.baseBrut = this.lignesDocument[i].montantLigne;
			this.lignesVentilTVA.push(ligneVentilTVA);
		}

		if (!codeTVAFPTrouve && this.lignesDocument[i].codeTVA==this.codeTVAFP) {
			codeTVAFPTrouve = true;
		}
	}

	if (!codeTVAFPTrouve) {
		var ligneVentilTVA = new LigneVentilTVA();
		ligneVentilTVA.codeTVABase = this.codeTVAFP;
		ligneVentilTVA.tauxTVABase = this.tauxTVAFP;
		this.lignesVentilTVA.push(ligneVentilTVA);
	}

	var totalBaseBrut = 0;
	for (var i=0; i<this.lignesVentilTVA.length; i++) {
		this.lignesVentilTVA[i].baseBrut = arr2.round(this.lignesVentilTVA[i].baseBrut);
		totalBaseBrut += this.lignesVentilTVA[i].baseBrut;
	}

	if (this.remiseM!=0) {
		this.remiseP = arr9.round(totalBaseBrut==0?0:(this.remiseM*100)/totalBaseBrut);
		this.remiseM=0;
	}

	for (var i=0; i<this.lignesVentilTVA.length; i++) {
		this.lignesVentilTVA[i].montantRemiseBase = arr2.round(this.lignesVentilTVA[i].baseBrut*(this.remiseP/100));
		var baseNet = arr2.round(this.lignesVentilTVA[i].baseBrut - this.lignesVentilTVA[i].montantRemiseBase);
		this.lignesVentilTVA[i].montantEscompteBase = arr2.round(baseNet * (this.escompteP/100));
		baseNet = arr2.round(baseNet - this.lignesVentilTVA[i].montantEscompteBase);

		if (this.lignesVentilTVA[i].codeTVABase==this.codeTVAFP) {
			baseNet += this.fraisPortNets;
		}
		if (this.editionTTC) {
			this.lignesVentilTVA[i].baseTTCNet = arr2.round(baseNet);
			this.lignesVentilTVA[i].montantTVABase = arr2.round(this.lignesVentilTVA[i].baseTTCNet * (this.lignesVentilTVA[i].tauxTVABase/100) / (this.lignesVentilTVA[i].tauxTVABase/100+1));
			this.lignesVentilTVA[i].baseHTNet = arr2.round(this.lignesVentilTVA[i].baseTTCNet - this.lignesVentilTVA[i].montantTVABase);
		} else {
			this.lignesVentilTVA[i].baseHTNet = arr2.round(baseNet);
			this.lignesVentilTVA[i].montantTVABase = arr2.round(this.lignesVentilTVA[i].baseHTNet * (this.lignesVentilTVA[i].tauxTVABase/100));
			this.lignesVentilTVA[i].baseTTCNet = arr2.round(this.lignesVentilTVA[i].baseHTNet + this.lignesVentilTVA[i].montantTVABase);
		}
	}
}


CalculDocument.prototype.calculer = function() {

	if (this.remiseFPM!=0) { this.remiseFPP = arr6.round(this.fraisPortBruts==0?0:(this.remiseFPM/this.fraisPortBruts)*100); }
	else { this.remiseFPM = arr2.round(this.fraisPortBruts * (this.remiseFPP/100)); }
	this.fraisPortNets = arr2.round(this.fraisPortBruts - this.remiseFPM);

	this.calculerVentilTVA();

	for (var i=0; i<this.lignesVentilTVA.length; i++) {
		if (this.editionTTC) { this.montantTTC += this.lignesVentilTVA[i].baseBrut; }
		else { this.montantHT += this.lignesVentilTVA[i].baseBrut; }
		this.remiseM += this.lignesVentilTVA[i].montantRemiseBase;
		this.escompteM += this.lignesVentilTVA[i].montantEscompteBase;
		this.totalTVA += this.lignesVentilTVA[i].montantTVABase;
	}
	this.remiseM = arr2.round(this.remiseM);
	this.escompteM = arr2.round(this.escompteM);
	this.totalTVA = arr2.round(this.totalTVA);

	if (this.editionTTC) {
		this.montantTTC = arr2.round(this.montantTTC);
		this.totalTTC = arr2.round(this.montantTTC - this.remiseM - this.escompteM + this.fraisPortNets);
		this.netCommercial = arr2.round(this.montantTTC - this.remiseM);
		this.netAPayer = arr2.round(this.totalTTC - this.acompte);
	}
	else {
		this.montantHT = arr2.round(this.montantHT);
		this.totalHT = arr2.round(this.montantHT - this.remiseM - this.escompteM + this.fraisPortNets);
		this.montantTTC = arr2.round(this.totalHT + this.totalTVA);
		this.netCommercial = arr2.round(this.montantHT - this.remiseM);
		this.totalTTC = arr2.round(this.montantTTC);
		this.netAPayer = arr2.round(this.totalTTC - this.acompte);
	}
}


function LigneDocument(montantLigne, codeTVA) {

	this.montantLigne = parseFloat(montantLigne);
	this.codeTVA = parseInt(codeTVA);
	this.tauxTVA = getTva(this.codeTVA);
}


function LigneVentilTVA() {

	this.codeTVABase = 0;
	this.tauxTVABase = 0;
	this.baseBrut = 0;
	this.montantRemiseBase = 0;
	this.montantEscompteBase = 0;
	this.baseHTNet = 0;
	this.montantTVABase = 0;
	this.baseTTCNet = 0;
}
