/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

/*
 * bibliothque de fonctions pour l'interrogation du serveur
 *
 * charger util.js pralablement
 */


jsLoader.loadSubScript("chrome://opensi/content/libs/param.js");


function QueryHttp(page) {

	this.url = cookie() +"&Page="+ page +"&ContentType=xml";
	this.params = "";
	this.plist = new Array();
}


QueryHttp.prototype.execute = function(callBackFunction, callBackParams) {

	this.buildUrlParam();

	var httpRequest = new XMLHttpRequest();

	if (callBackFunction==undefined) {

		httpRequest.onload = null;
    httpRequest.open("POST", getUrlOpeneas(''), false);
		httpRequest.setRequestHeader("Content-type","application/x-www-form-urlencoded");
    httpRequest.send(this.url + this.params);

		if (httpRequest.responseXML.documentElement.getAttribute('sys-queryhttp-error')==1) {
			alert("Votre session a expir\u00E9. Veuillez vous reconnecter.");
			quit();
		}

    return httpRequest;
	}
	else {

		httpRequest.onload = function (aEvt) {
			if (httpRequest.responseXML.documentElement.getAttribute('sys-queryhttp-error')==1) {
				alert("Votre session a expir\u00E9. Veuillez vous reconnecter.");
				quit();
			}
			else {
				callBackFunction(httpRequest,callBackParams);
			}
		};
		httpRequest.open("POST", getUrlOpeneas(''), true);
		httpRequest.setRequestHeader("Content-type","application/x-www-form-urlencoded");
		httpRequest.send(this.url + this.params);
	}
}


QueryHttp.prototype.setParam = function(pname, pvalue) {

	var param = this.getParam(pname);

	if (param==undefined) {
		this.addParam(pname, pvalue);
	}
	else {
		param.setValue(pvalue);
	}
}


QueryHttp.prototype.addParam = function(pname, pvalue) {

	this.plist.push(new Param(pname, pvalue));
}


QueryHttp.prototype.removeParam = function(pname) {

	var trouve = false;
	var i = 0;

	while (!trouve && i<this.plist.length) {

		trouve = (this.plist[i].pname==pname);
		i++;
	}

	if (trouve) {
		this.plist.splice(i-1,1);
	}
}


QueryHttp.prototype.getParam = function(pname) {

	var trouve = false;
	var i = 0;

	while (!trouve && i<this.plist.length) {
		trouve = this.plist[i].pname==pname;
		i++;
	}

	return (trouve?this.plist[i-1]:undefined);
}


QueryHttp.prototype.clearParams = function() {

	this.plist.length = 0;
}


QueryHttp.prototype.buildUrlParam = function() {

	this.params = "";

	for (var i=0; i<this.plist.length; i++)
		this.params += this.plist[i].getUrlParam();
}





function Errors(queryResult) {

	this.currentError = null;
	this.iterator = -1;

	this.errors = queryResult.responseXML.documentElement.getElementsByTagName("Error");
}


/*  */
Errors.prototype.hasNext = function() {

	this.currentError = this.errors.item(++this.iterator);
	return this.currentError!=null;
}


/*  */
Errors.prototype.show = function() {

	showWarning(this.getMessage());
}


/*  */
Errors.prototype.getCode = function() {

	return this.currentError.getAttribute('Code');
}


/*  */
Errors.prototype.getMessage = function() {

	return this.currentError.getAttribute('Message');
}







