/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

/*
 * Bibliothque de fonctions utiles  OpenSi
 */

// objet pour charger des librairies js  partir d'une autre fichier js
var jsLoader = Components.classes["@mozilla.org/moz/jssubscript-loader;1"].getService(Components.interfaces.mozIJSSubScriptLoader);

var prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);


function getProfil() {
  try {

		return parent!=window?parent.getProfil():opener.getProfil();

	} catch (e) {
    recup_erreur(e);
  }
}


function getConfig() {
  try {

		return parent!=window?parent.getConfig():opener.getConfig();

	} catch (e) {
    recup_erreur(e);
  }
}


function getResetConfig() {
  try {

		if (parent!=window) {
			parent.resetConfig();
		}
		else {
			opener.resetConfig();
		}

		return getConfig();

	} catch (e) {
    recup_erreur(e);
  }
}


var paramOk = true;

try {
  // Extraction des paramtres de la requte HTTP
  // et initialise la variable "paramOk"  false
  // s'il n'y a aucun paramtre.
  if (!location.search) {
    paramOk = false;
  }
  else {
    // liminer le "?"
    var nReq = location.search.substring(1,location.search.length)
    // Extrait les diffrents paramtres avec leur valeur.
    nReq = nReq.split("&");

    var param = new FaitTableau(nReq.length-1)
    for (var i=0;i<(nReq.length);i++) {
      param[i] = nReq[i]
    }
  }
} catch (e) {
  recup_erreur(e);
}


function getVersion() {
  try {

    return "9.9.0";

  } catch (e) {
    recup_erreur(e);
  }
}


function get_os() {
  try {

    return navigator.platform;

  } catch (e) {
    recup_erreur(e);
  }
}


function get_pref_module() {
  try {

    if (prefs.getPrefType("opensi.serveur.module") == prefs.PREF_STRING){
      return prefs.getCharPref("opensi.serveur.module");
    } else {
      return "Facturation";
    }

  } catch (e) {
    recup_erreur(e);
  }
}

function get_pref_entreprise() {
  try {

    if (prefs.getPrefType("opensi.serveur.entreprise") == prefs.PREF_STRING){
      return prefs.getCharPref("opensi.serveur.entreprise");
    } else {
      return "";
    }

  } catch (e) {
    recup_erreur(e);
  }
}

function get_pref_login() {
  try {

    if (prefs.getPrefType("opensi.serveur.login") == prefs.PREF_STRING){
      return prefs.getCharPref("opensi.serveur.login");
    } else {
      return "";
    }

  } catch (e) {
    recup_erreur(e);
  }
}

function get_pref_password() {
  try {

    if (prefs.getPrefType("opensi.serveur.password") == prefs.PREF_STRING){
      return prefs.getCharPref("opensi.serveur.password");
    } else {
      return "";
    }

  } catch (e) {
    recup_erreur(e);
  }
}

function get_pref_login_check() {
  try {

    if (prefs.getPrefType("opensi.serveur.login_check") == prefs.PREF_BOOL){
      return prefs.getBoolPref("opensi.serveur.login_check");
    } else {
      return false;
    }

  } catch (e) {
    recup_erreur(e);
  }
}

function get_pref_password_check() {
  try {

    if (prefs.getPrefType("opensi.serveur.password_check") == prefs.PREF_BOOL){
      return prefs.getBoolPref("opensi.serveur.password_check");
    } else {
      return false;
    }

  } catch (e) {
    recup_erreur(e);
  }
}

function get_pref_acces_check() {
  try {

    if (prefs.getPrefType("opensi.serveur.acces_check") == prefs.PREF_BOOL){
      return prefs.getBoolPref("opensi.serveur.acces_check");
    } else {
      return false;
    }

  } catch (e) {
    recup_erreur(e);
  }
}

function get_pref_ssl() {
  try {

    if (prefs.getPrefType("opensi.serveur.ssl") == prefs.PREF_BOOL){
      return prefs.getBoolPref("opensi.serveur.ssl");
    } else {
      return true;
    }

  } catch (e) {
    recup_erreur(e);
  }
}


function get_pref_ipserveur() {
  try {

    if (prefs.getPrefType("opensi.serveur.addresse") == prefs.PREF_STRING){
      return prefs.getCharPref("opensi.serveur.addresse");
    } else {
      return "serveur01.opensi.eu";
    }

  } catch (e) {
    recup_erreur(e);
  }
}


function get_pref_porttomcat() {
  try {

    if (prefs.getPrefType("opensi.serveur.port") == prefs.PREF_STRING){
      return prefs.getCharPref("opensi.serveur.port");
    } else {
      return "443";
    }

  } catch (e) {
    recup_erreur(e);
  }
}


function get_pref_servlet() {
  try {

    if (prefs.getPrefType("opensi.serveur.servlet") == prefs.PREF_STRING){
      return prefs.getCharPref("opensi.serveur.servlet");
    } else {
      return "OpenSI";
    }

  } catch (e) {
    recup_erreur(e);
  }
}


function set_pref_module(value) {
  try {

    prefs.setCharPref("opensi.serveur.module", value);

  } catch (e) {
    recup_erreur(e);
  }
}

function set_pref_entreprise(value) {
  try {

    prefs.setCharPref("opensi.serveur.entreprise", value);

  } catch (e) {
    recup_erreur(e);
  }
}

function set_pref_login(value) {
  try {

    prefs.setCharPref("opensi.serveur.login", value);

  } catch (e) {
    recup_erreur(e);
  }
}

function set_pref_password(value) {
  try {

    prefs.setCharPref("opensi.serveur.password", value);

  } catch (e) {
    recup_erreur(e);
  }
}

function set_pref_login_check(value) {
  try {

    prefs.setBoolPref("opensi.serveur.login_check", value);

  } catch (e) {
    recup_erreur(e);
  }
}

function set_pref_password_check(value) {
  try {

    prefs.setBoolPref("opensi.serveur.password_check", value);

  } catch (e) {
    recup_erreur(e);
  }
}

function set_pref_acces_check(value) {
  try {

    prefs.setBoolPref("opensi.serveur.acces_check", value);

  } catch (e) {
    recup_erreur(e);
  }
}

function set_pref_ssl(value) {
  try {

    prefs.setBoolPref("opensi.serveur.ssl", value);

  } catch (e) {
    recup_erreur(e);
  }
}


function set_pref_ipserveur(value) {
  try {

    prefs.setCharPref("opensi.serveur.addresse", value);

  } catch (e) {
    recup_erreur(e);
  }
}


function set_pref_porttomcat(value) {
  try {

    prefs.setCharPref("opensi.serveur.port", value);

  } catch (e) {
    recup_erreur(e);
  }
}


function set_pref_servlet(value) {
  try {

    prefs.setCharPref("opensi.serveur.servlet", value);

  } catch (e) {
    recup_erreur(e);
  }
}


// =====================================================================


// ********************************************
// Rcupration de paramtre d'une requte HTTP
// ou rcupration des donnes d'un formulaire.
// Auteur : Oznog (www.trucsweb.com)
// ********************************************

// NE PAS MODIFIER CE CODE


/* cration d'un tableau (array) aux dimensions du nombre de paramtres */
function FaitTableau(n) {
  try {

    this.length = n;
    for (var i = 0; i <= n; i++) {
      this[i] = 0
    }

    return this;

  } catch (e) {
    recup_erreur(e);
  }
}


/* rcupration de la valeur d'une variable pour crer la variable en javascript */
function ParamValeur(nValeur) {
  try {

    if (paramOk) {
      var nTemp = "";
      for (var i=0;i<(param.length+1);i++) {
        if (param[i].substring(0,param[i].indexOf("=")) == nValeur)
          nTemp = param[i].substring(param[i].indexOf("=")+1,param[i].length)
      }
			return Decode(nTemp);
    }
		else {
      return "";
    }

  } catch (e) {
//    alert(e);
  }
}


/* Decoder la requete HTTP manuellement pour le signe (+) */
function Decode(tChaine) {
  try {

    while (true) {
      var i = tChaine.indexOf('+');
      if (i < 0) break;
      tChaine = tChaine.substring(0,i) +'%20'+ tChaine.substring(i + 1, tChaine.length);
    }
    return unescape(tChaine).replace(/\u0080/g, "\u20AC"); // replace pour signe euro

  } catch (e) {
    recup_erreur(e);
  }
}


// =====================================================================


/* recuperation du numero de session OpenEAS */
function cookie() {
	try {

		var s_ = ParamValeur("S_");

		if (parent==window && s_=="") {
			return opener.cookie();
		}
		else {
  		return "S_="+ (s_==""?parent.getSessionId():s_) + nocache();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function getDirServeur() {

	return (get_pref_ssl()?"https":"http") +"://"+ get_pref_ipserveur() +":"+ get_pref_porttomcat() +"/"+ get_pref_servlet() +"/";
}


/* retourne le repertoire d'entre/sortie du serveur */
function getDirBuffer() {
  try {

		return getDirServeur() + getProfil().getIOSubDirectory();

  } catch (e) {
    recup_erreur(e);
  }
}


/* retourne le repertoire de stockage des pdf */
function getDirPdf() {
  try {

		return getDirServeur() + getProfil().getPDFSubDirectory();

  } catch (e) {
    recup_erreur(e);
  }
}


/* retourne le repertoire de stockage des graphiques */
function getDirGraph() {
  try {

    return getDirServeur() + getProfil().getGraphSubDirectory();

  } catch (e) {
    recup_erreur(e);
  }
}


function getUrlOpeneas(paramlist) {
  var retour = getDirServeur() +"openeas";
  if (paramlist != '') {
    retour += "?"+ cookie() + paramlist;
  }
  return retour;
}


/* ne pas utiliser */
function requeteHTTP(param,httpRequest,callbackFn,callbackParams) {
  try {

    if (httpRequest==undefined) {

      var p = new XMLHttpRequest();
      p.onload = null;
      p.open("POST",getUrlOpeneas(''), false);
      p.setRequestHeader("Content-type","application/x-www-form-urlencoded");
      p.send(param);
      return p;

    }	else {

      httpRequest.onload = null;

      if (callbackFn==undefined) {
        httpRequest.open("POST",getUrlOpeneas(''), false);
      } else {
//        httpRequest.onreadystatechange = callbackFn;
//        httpRequest.onload = callbackFn;
        httpRequest.onload = function (aEvt) {
          callbackFn(httpRequest,callbackParams);
        };
        httpRequest.open("POST",getUrlOpeneas(''), true);
      }
      httpRequest.setRequestHeader("Content-type","application/x-www-form-urlencoded");
      httpRequest.send(param);
    }

  } catch (e) {
    alert("Le serveur est introuvable.\n Veuillez v\u00E9rifier son adresse et son port dans les param\u00E8tres avanc\u00E9s");
    return p;
  }
}


function quit() {
	try {

		requeteHTTP(cookie() +"&Page=KillSession.tmpl&ContentType=xml");

  	window.open('chrome://opensi/content/login.xul','','chrome,resizable,minimizable,dialog=no');
  	window.parent.close();

	} catch (e) {
    recup_erreur(e);
  }
}


function parseIntBis(nb) {
  try {

		// parseInt en base 10
    return parseInt(nb, 10);

  } catch (e) {
    recup_erreur(e);
  }
}


/* rcupration des erreurs provenant des exceptions */
function recup_erreur(e) {
  try {

		var stack = "";
		var lines = e.stack.split('\n');

		for (var i=0; i<lines.length; i++) {
			stack += (i==0?"":",")+ lines[i];
		}

		var corps = cookie() +"&Page=RapportDeBug.tmpl&Erreur="+ e;
		corps += "&Location="+ urlEncode(window.location) +"&Fichier="+ urlEncode(window.location.pathname) +"&Stack="+ urlEncode(stack) +"&Version="+ getVersion() +"&User_Agent="+ urlEncode(navigator.userAgent);

		requeteHTTP(corps);

  } catch (e) {
    alert("erreur dans libs/util.js#recup_erreur : "+ e);
  }
}


/* criture d'une trace client dans les logs */
function debug(msg) {
  try {

		requeteHTTP(cookie() +"&Page=Debug.tmpl&Msg="+ urlEncode(msg));

  } catch (e) {
    alert("erreur dans libs/util.js#debug : "+ e);
  }
}


/* renvoie une date au format yyyy:MM:dd */
function prepareDateJava(val) {
  try {

    var retour = "";

    if (val.length == 10) {
      retour = val.substring(6,10) +':'+ val.substring(3,5) +':'+ val.substring(0,2);
    }
		else if (val.length == 8) {
      retour = "20" + val.substring(6,8) +':'+ val.substring(3,5) +':'+ val.substring(0,2);
    }

    return retour;

  } catch (e) {
    recup_erreur(e);
  }
}


/* renvoie une periode au format 20yy:MM:01 */
function preparePeriodeJava(val) {
  try {

    return '20'+ val.substring(2,4) +':'+ val.substring(0,2) +':01';

  } catch (e) {
    recup_erreur(e);
  }
}


/* encode une chaine 'str' en url */
function urlEncode(str) {
  try {

		var url = new String(str);

		// encodage des '%'
		url = url.replace(/\%/g, '%25');
		// encodage des '+'
		url = url.replace(/\+/g, '%2B');
		// encodage des '&'
		url = url.replace(/\&/g, '%26');
		// encodage des '#'
		url = url.replace(/\#/g, '%23');
		// encodage des '|'
		url = url.replace(/\|/g, '%7C');
		// encodage des '_'
		url = url.replace(/\_/g, '%5F');
		// transformation des retours de ligne en \n
		url = url.replace(/\n/g, '%5Cn');

		return url;

  } catch (e) {
    recup_erreur(e);
  }
}


/* renvoie un parametre http fictif pour forcer le rechargement de la page a partir du serveur */
function nocache() {
	try {

		var nocache = new Date();
		return "&NoCache="+ nocache.getMilliseconds();

	} catch (e) {
    recup_erreur(e);
  }
}


/* renvoie l'extension du fichier 'file' */
function getFileExtension(file) {
	try {

		var lastPoint = file.lastIndexOf('.');

		if (lastPoint==-1 || lastPoint==file.length-1) {
			return "";
		}
		else {
			return file.substring(lastPoint+1,file.length);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


/* Message d'information */
function showMessage(msg) {
	try {

		var url = "chrome://opensi/content/popup/message.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', msg);

	} catch (e) {
    recup_erreur(e);
  }
}


/* Message d'alerte */
function showWarning(msg, unfocus) {
	try {

		var url = "chrome://opensi/content/popup/warning.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', msg, (unfocus==null || !unfocus));

	} catch (e) {
    recup_erreur(e);
  }
}


/* Message d'erreur */
function showError(msg) {
	try {

		var url = "chrome://opensi/content/popup/error.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', msg);

	} catch (e) {
    recup_erreur(e);
  }
}


/* valuation d'une expression mathmatique */
function calcExpr(expr) {
	try {

		return eval(expr.replace(/ /gi, ''));

	}	catch(e) {
		showWarning("Expression incorrecte !");
		return expr;
	}
}


/* fentre de choix d'un fichier */
function fileChooser(mode, suggestedFile, filterType) {
	try {

		var nsIFilePicker = Components.interfaces.nsIFilePicker;
		var fp = Components.classes["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);

		if (mode=="save") {
			var pickerMode = nsIFilePicker.modeSave;
			var titre = "Enregistrer sous ...";
		}
		else if (mode=="open") {
			var pickerMode = nsIFilePicker.modeOpen;
			var titre = "Ouvrir un fichier";
		}
		else if (mode=="folder") {
			var pickerMode = nsIFilePicker.modeGetFolder;
			var titre = "Ouvrir un r\u00E9pertoire";
		}

		fp.init(window, titre, pickerMode);
		fp.defaultString = suggestedFile;

		if (filterType==null) {
			fp.appendFilters(nsIFilePicker.filterAll); // filtre obligatoire sinon ca plante
		}
		else {
			switch (filterType) {
				case "XLSX":	fp.appendFilter("Classeur Excel (*.xlsx)", "*.xlsx");						fp.defaultExtension = "xlsx";		break;
				case "XLS":		fp.appendFilter("Classeur Excel 97 - 2003 (*.xls)", "*.xls");		fp.defaultExtension = "xls";		break;
				case "CSV":		fp.appendFilter("CSV (*.csv)", "*.csv");												fp.defaultExtension = "csv";		break;
				case "PDF":		fp.appendFilter("PDF (*.pdf)", "*.pdf");												fp.defaultExtension = "pdf";		break;
				default :			fp.appendFilters(nsIFilePicker.filterAll);
			}
		}

		var res = fp.show();

		if (res == nsIFilePicker.returnOK || res == nsIFilePicker.returnReplace) {
  		return fp.file;
		}
		else {
			return null;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


/* tlchargement d'un fichier depuis l'url 'url' dans le fichier local 'file' */
function downloadFile(url, file) {
	try {

		var ios = Components.classes["@mozilla.org/network/io-service;1"].getService(Components.interfaces.nsIIOService);
		var uri = ios.newURI(url, "", null);
		var wp = Components.classes["@mozilla.org/embedding/browser/nsWebBrowserPersist;1"].createInstance(Components.interfaces.nsIWebBrowserPersist);

		Components.utils.import("resource://gre/modules/Downloads.jsm");Downloads.fetch(url,file);

	} catch (e) {
    recup_erreur(e);
  }
}


/* chargement d'un fichier sur le serveur */
function uploadFile(file) {
	try {

		window.openDialog("chrome://opensi/content/compta/util/upload.xul?"+ cookie() +"&dir="+ getProfil().getIOSubDirectory() +"&file="+ urlEncode(file.path),'','chrome,modal,centerscreen');

	} catch (e) {
    recup_erreur(e);
  }
}


/* vrification d'un fichier pour l'upload */
function checkUploadFile(file) {
	try {

		if (file.fileSize==0) {
			showWarning("Fichier vide");
			return false;
		}

		var fileName = file.leafName;

		var ext = getFileExtension(fileName).toLowerCase();
		if (ext=="exe" || ext=="bat" || ext=="sh" || ext=="msu" || ext=="msi") {
			showWarning("Fichier interdit");
			return false;
		}

		var regex = /^((?!\.\.)[a-zA-Z \.0-9_\-\u00C0-\u00FF])*$/;

		if (!regex.test(fileName)) {
			showWarning("Nom de fichier incorrect (pr\u00E9sence de caract\u00E8res interdits, exemples : # $ & + % [ ] \" ' ` \u20AC \"..\" etc.)");
			return false;
		}

		return true;

	} catch (e) {
    recup_erreur(e);
  }
}


/* ouverture du support d'opensi */
function aide() {
	try {

		window.open("chrome://opensi/content/popup/popup-support.xul?"+ cookie(),'','chrome,centerscreen,resizable');

	} catch (e) {
    recup_erreur(e);
  }
}


/* ouverture du manuel en ligne d'opensi */
function openHelpPage(page) {
	try {

		window.open("http://manuel.opensi.fr"+ (page==undefined?"":page),'','chrome,centerscreen,width=900,height=700,resizable');

	} catch (e) {
    recup_erreur(e);
  }
}


function getDateCourante() {
	try {

		var date = new Date();
		var mois = date.getMonth()+1;
		var jour = date.getDate();

		return (jour.toString().length==1?"0"+jour:jour) +"/"+ (mois.toString().length==1?"0"+mois:mois) +"/"+ date.getFullYear();

	} catch (e) {
		recup_erreur(e);
	}
}


function parseDate(val) {
	try {

		var d = val.substring(0,2);
		var m = parseIntBis(val.substring(3,5)) - 1;
  	var y = val.substring(6,10);

		return new Date(y,m,d).getTime();

	} catch (e) {
		recup_erreur(e);
	}
}


function openInNavigator(url) {
	try {

		var externalProtocolService = Components.classes["@mozilla.org/uriloader/external-protocol-service;1"].getService(Components.interfaces.nsIExternalProtocolService);
		var ioService = Components.classes["@mozilla.org/network/io-service;1"].getService(Components.interfaces.nsIIOService);

		externalProtocolService.loadUrl(ioService.newURI(url, null, null));

	} catch (e) {
		recup_erreur(e);
	}
}
