/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");



//rcupration mot de passe dans gestionnaire de mot de passe
try {
	var hostname = "https://login.opensi.eu";
	var formSubmitURL = "https://login.opensi.eu";
	var httprealm = null;
  var oldusername ="";
  var oldentreprise ="";
  var oldlogin ="";
  var oldpassword ="";
  var oldloginInfo = null;

  // Obtient le gestionnaire d'identification
  var myLoginManager = Components.classes["@mozilla.org/login-manager;1"].getService(Components.interfaces.nsILoginManager);

	var nsLoginInfo = new Components.Constructor("@mozilla.org/login-manager/loginInfo;1", Components.interfaces.nsILoginInfo, "init");

}
catch(ex) {
   // Ceci se produira uniquement s'il n'y a pas de classe de composant nsILoginManager
   // ou annulation au moment du mot de passe manager
}


var gTimeoutConnect = null;
var gTimeoutConnectTest = null;
var installation = false;

var nSession;


function init() {
  try {

		var x = (screen.width / 2) - 405;
    var y = (screen.height / 2) - 290;

		window.innerWidth = 810;
		window.innerHeight = 580;

    window.moveTo(x,y);

    document.getElementById('version').value = "v. "+ getVersion();
    if (get_pref_login_check()) {
      document.getElementById('login_check').checked = true;
      if (get_pref_password_check()) {
        document.getElementById('password_check').checked = true;
      }
      else {
        document.getElementById('password_check').removeAttribute("Checked");
      }
    }
    else {
      document.getElementById('login_check').removeAttribute("Checked");
    }

		var module = get_pref_module();

    document.getElementById('liste').value = module;

		if (module=='Superviseur') {
      affichPassword();
    }
		else {
			if (get_pref_login_check() && myLoginManager.getAllLogins({}).length==0) {
				installation = true;
				setTimeout("install();",10000);
				setTimeout("affichTout();",2000);
			}
			else {
				affichTout();
			}
    }

  } catch (e) {
    recup_erreur(e);
  }
}


function install() {
  try {

		installation = false;

  } catch (e) {
    recup_erreur(e);
  }
}


function affiche_param() {
  try {

		document.getElementById('bLoginParams').disabled = true;
   	document.getElementById('paramavances').collapsed = false;
		document.getElementById('boxLiens').collapsed = true;
		document.getElementById('boxLiens').setAttribute("hidden", true);
   	document.getElementById('ipserveur').value = get_pref_ipserveur();
   	document.getElementById('servlet').value = get_pref_servlet();
   	document.getElementById('porttomcat').value = get_pref_porttomcat();
   	document.getElementById('is_ssl').checked = get_pref_ssl();

  } catch (e) {
    recup_erreur(e);
  }
}


function checkLogin() {
  try {

		var oklog = true;

		if (!installation) {

    	if (!document.getElementById('paramavances').collapsed) {

				var ipserveur = document.getElementById('ipserveur');
    		var porttomcat = document.getElementById('porttomcat');
    		var servlet = document.getElementById('servlet');

    		if (isEmpty(ipserveur.value) || isEmpty(porttomcat.value)) {
      		alert("Vous devez pr\u00E9ciser l'adresse et le port du serveur OpenSi");
      		ipserveur.focus();
					oklog = false;
    		}
    		else if (isEmpty(servlet.value)) {
      		alert("Vous devez pr\u00E9ciser le nom du servlet sur le serveur OpenSi");
      		porttomcat.focus();
					oklog = false;
    		}
				else {
					set_pref_ipserveur(document.getElementById('ipserveur').value);
      		set_pref_porttomcat(document.getElementById('porttomcat').value);
      		set_pref_servlet(document.getElementById('servlet').value);
      		set_pref_ssl(document.getElementById('is_ssl').checked);
				}
    	}

			if (oklog) {
				var entreprise = document.getElementById('Entreprise');
				var login = document.getElementById('login');
    		var passwd = document.getElementById('password');

				if (isEmpty(login.value)) {
      		login.focus();
    		}
				else if (isEmpty(passwd.value)) {
      		passwd.focus();
    		}
				else if (isEmpty(entreprise.value)) {
      		entreprise.focus();
    		}
				else {
    			var corps = "Page=Login.tmpl&ContentType=xml&Login="+ login.value +"&Password="+ urlEncode(passwd.value) +"&Entreprise="+ entreprise.value;

					requeteHTTP(corps,new XMLHttpRequest(),checkLogin2);
					document.getElementById('bLoginOK').disabled = true;
					document.getElementById('label_connect_msg').value = "Connexion en cours...";
					if (gTimeoutConnect) clearTimeout(gTimeoutConnect);
					gTimeoutConnect = setTimeout("timeoutConnect()", 6000);
				}
			}
		}
		else {
			alert('OpenSi termine son installation, veuillez patienter quelques secondes avant de vous connecter');
		}

  } catch(e) {
    recup_erreur(e);
  }
}


function checkLoginChangementServeur(serv) {
  try {

		var oklog = true;

		set_pref_ipserveur(serv.getAttribute('Serveur_URL'));
   	set_pref_porttomcat(serv.getAttribute('Serveur_Port'));
   	set_pref_servlet(serv.getAttribute('Servlet'));
   	set_pref_ssl(serv.getAttribute('Mode_SSL')==1);

		if (oklog) {
			var entreprise = document.getElementById('Entreprise');
			var login = document.getElementById('login');
    	var passwd = document.getElementById('password');

			if (isEmpty(login.value)) {
      	login.focus();
    	}
			else if (isEmpty(passwd.value)) {
      	passwd.focus();
    	}
			else if (isEmpty(entreprise.value)) {
      	entreprise.focus();
    	}
			else {
    		var corps = "Page=Login.tmpl&ContentType=xml&Login="+ login.value +"&Password="+ urlEncode(passwd.value) +"&Entreprise="+ entreprise.value;

				requeteHTTP(corps,new XMLHttpRequest(),checkLogin2);
				document.getElementById('bLoginOK').disabled = true;
				document.getElementById('label_connect_msg').value = "Connexion en cours...";
				if (gTimeoutConnect) clearTimeout(gTimeoutConnect);
				gTimeoutConnect = setTimeout("timeoutConnect()", 6000);
			}
		}

  } catch(e) {
    recup_erreur(e);
  }
}


function timeoutConnect() {

	var testRequest = new XMLHttpRequest();
	testRequest.onload = function (aEvt) {checkSite(testRequest);};
	testRequest.open("GET","https://www.google.fr/", true);
	testRequest.send();

	gTimeoutConnectTest = setTimeout("timeoutConnectTest()", 6000);
}


function timeoutConnectTest() {

	document.getElementById('bLoginOK').disabled = false;
	document.getElementById('label_connect_msg').value = "OpenSi n'est pas accessible. Veuillez v\u00E9rifier votre connexion internet.";
}


function checkSite(testRequest) {
	clearTimeout(gTimeoutConnectTest);
	document.getElementById('bLoginOK').disabled = false;
	if (testRequest.status != "200") {
		document.getElementById('label_connect_msg').value = "Votre connexion internet semble avoir des probl\u00E8mes, veuillez contacter votre administrateur r\u00E9seau";
	}
	else {
		document.getElementById('label_connect_msg').value = "Connexion au serveur impossible. Veuillez v\u00E9rifier vos param\u00E8tres.";
	}

}


function checkLogin2(httpRequest) {
	try {

		clearTimeout(gTimeoutConnect);
		// if(httpRequest.readyState != 4) return false;
		//4==document completement charge; 1==en cours; 2==charge; 3==interactif 0==initialise

		if (httpRequest.status == "0") {
			enableAll();
			timeoutConnect();
			return false;
		}

		if (httpRequest.status != "200") {
			alert("R\u00E9ception erreur "+ httpRequest.status);
			enableAll();
			timeoutConnect();
		}
		else {
			var contenu = httpRequest.responseXML;

			if (contenu==null) {
				alert("Le serveur n\u00E9cessite une connexion s\u00E9curis\u00E9e. Veuillez cocher la case correspondante dans les param\u00E8tres avanc\u00E9s.");
				window.location = "chrome://opensi/content/login.xul";
				return -1;
			}
			else {
				var session = contenu.documentElement;
				nSession = session.getAttribute('cookie');

				if (nSession=="") {
					alert("Entreprise, login ou mot de passe incorrect");
					window.location = "chrome://opensi/content/login.xul";
					return -1;
				}
				else {
					if (session.getAttribute('serveur')!=null && session.getAttribute('serveur')=="true") {
						var serv = session.getElementsByTagName('server')[0];
						 checkLoginChangementServeur(serv);
					}
					else {
						var user = session.getElementsByTagName('user')[0];
						var versionServeur = user.getAttribute('releasename');

						if (versionServeur!=getVersion()) {
							window.location = "update.html?versionServeur="+ versionServeur +"&urlupdate="+ user.getAttribute('urlupdate');
						}
						else {
							checkLogin3(user);
						}
					}
				}
			}
		}

	} catch(e) {
		recup_erreur(e);
		enableAll();
	}
}


function checkLogin3(user) {
  try {

		var vtest = user.getAttribute('vtest');
    var utilisateur = user.getAttribute('id');

    if (isEmpty(utilisateur)) {
      alert("Entreprise, login ou mot de passe incorrect");
      window.location = "chrome://opensi/content/login.xul";
      return -1;
    } else {
      var url="";
      var root = user.getAttribute('root');
      var choix = document.getElementById('liste').value;
      set_pref_module(choix) ;

      if (root == "true") {
        switch (choix) {
          case 'Configuration' :
            url = "chrome://opensi/content/config/main.xul";
            break;
          case 'Superviseur' :
            url = "chrome://opensi/content/superviseur/main.xul";
            break;
          default:
            alert("Entreprise, login ou mot de passe incorrect");
            window.location = "chrome://opensi/content/login.xul";
            return -1;
            break;
          }
			}
			else {
				var entreprise = document.getElementById('Entreprise').value;
			  var login = document.getElementById('login').value;
		    var password = document.getElementById('password').value;
				var administrateur = user.getAttribute('administrateur');

		    /* traite le cas de mmorisation d'identification */
		    if (document.getElementById('login_check').checked) {
		      var username = document.getElementById('Entreprise').value + '---' + document.getElementById('login').value;
					var newloginInfo = new nsLoginInfo(hostname, formSubmitURL, httprealm, username, " ", 'login', 'password');
		      set_pref_login_check(document.getElementById('login_check').checked);
		      if (document.getElementById('password_check').checked) {
		        set_pref_password_check(document.getElementById('password_check').checked);
						var newloginInfo = new nsLoginInfo(hostname, formSubmitURL, httprealm, username, document.getElementById('password').value, 'login', 'password');
            if (username!=oldusername || document.getElementById('password').value!=oldpassword) {
              try {
                if (oldusername!="") {
									myLoginManager.removeLogin(oldloginInfo);
								}
              	myLoginManager.addLogin(newloginInfo);
              }
              catch (ex) {}
          	}
		      }
		      else {
		        set_pref_password_check(false);
		        if (username!=oldusername) {
		        	try {
		        		if (oldusername!="") {
									myLoginManager.removeLogin(oldloginInfo);
								}
		         		myLoginManager.addLogin(newloginInfo);
		         	}
              catch (ex) {}
		      	}
		    	}
		    }
		    else {
					// sinon supprime les informations des prfrences
		    	try {
		      	if (oldusername!="") {
							myLoginManager.removeLogin(oldloginInfo);
						}
					}
	       	catch (ex) {}

		      set_pref_login("");
			  	set_pref_entreprise("");
		      set_pref_login_check(false);
		      set_pref_password("");
		      set_pref_password_check(false);
		    }
				var url;
        switch (choix) {
          case 'Compta':
            url = "chrome://opensi/content/compta/user/main.xul";
            break;
          case 'Facturation':
            url = "chrome://opensi/content/facturation/user/main.xul";
            break;
					case 'CRM':
            url = "chrome://opensi/content/crm/main.xul";
            break;
					case 'TB':
            url = "chrome://opensi/content/tb/main.xul";
            break;
          case 'Configuration':
            url = "chrome://opensi/content/config/main.xul";
            break;
          case 'Utilisateurs':
						if (administrateur=="true") {
            	url = "chrome://opensi/content/utilisateurs/main.xul";
						}
						else {
							alert("Vous n'avez pas les droits d'acc\u00E8s au module Gestion des utilisateurs");
            	window.location = "chrome://opensi/content/login.xul";
            	return -1;
						}
						break;
          default:
            alert("Entreprise, login ou mot de passe incorrect");
            window.location = "chrome://opensi/content/login.xul";
            return -1;
            break;
        }
      }

			window.location = url +"?"+ nSession +"&Utilisateur="+ utilisateur +"&VTest="+ vtest;
    }

  } catch(e) {
		recup_erreur(e);
    enableAll();
  }
}


function keypress(e) {
  try {

    if (e.keyCode==13) {
      checkLogin();
    }

  } catch (e) {
    recup_erreur(e);
  }
}


function enableAll() {
  try {

    document.getElementById('bLoginOK').disabled = false;

  } catch (e) {
    recup_erreur(e);
  }
}


function affichPassword() {
  try {

    document.getElementById('login').collapsed = true;
		document.getElementById('Entreprise').collapsed = true;
    document.getElementById('rowLogin').collapsed = true;
		document.getElementById('rowEntreprise').collapsed = true;
    document.getElementById('login').disabled = true;
		document.getElementById('Entreprise').disabled = true;
    document.getElementById('password').value = "";
    document.getElementById('password').focus();
    document.getElementById('rowConsIdent').collapsed = true;
    document.getElementById('rowConsMDP').collapsed = true;
		document.getElementById('login').value = "root";
		document.getElementById('Entreprise').value = "root";
    check_login();

	} catch (e) {
    recup_erreur(e);
  }
}


function check_login() {
  try {

    document.getElementById('password_check').disabled = !document.getElementById('login_check').checked;

	} catch (e) {
    recup_erreur(e);
  }
}


function affichTout() {
  try {
    // Recherche des utilisateurs pour les paramtres donns
    var logins = myLoginManager.findLogins({}, hostname, formSubmitURL, httprealm);

    // Trouve l'utilisateur dans le tableau d'objets nsILoginInfo renvoy
    for (var i=0; i<logins.length; i++) {
  	  oldusername = logins[i].username;
      var reg=new RegExp("---", "g");
      var ident = oldusername.split(reg);
      oldentreprise = ident[0];
      oldlogin = ident[1];
      oldpassword = logins[i].password;
    }

  	oldloginInfo = new nsLoginInfo(hostname, formSubmitURL, httprealm, oldusername, oldpassword, 'login', 'password');

		if (document.getElementById('login').value == "root") {
      document.getElementById('login').value = "";
			document.getElementById('Entreprise').value = "";
    }
    document.getElementById('login').disabled = false;
		document.getElementById('Entreprise').disabled = false;
    document.getElementById('login').collapsed = false;
    document.getElementById('rowLogin').collapsed = false;
		document.getElementById('rowEntreprise').collapsed = false;
		document.getElementById('Entreprise').collapsed = false;
    document.getElementById('login').focus();
    if (document.getElementById('login_check').checked) {
    	document.getElementById('Entreprise').value = oldentreprise;
     	document.getElementById('login').value = oldlogin;
      if (document.getElementById('password_check').checked) {
        if (oldpassword!=" ") {
    			document.getElementById('password').value = oldpassword;
        }
        else {
    			document.getElementById('password').value = "";
        }
      }
      else {
        document.getElementById('password').focus();
      }
    }
    check_login();
    document.getElementById('rowConsIdent').collapsed = false;
    document.getElementById('rowConsMDP').collapsed = false;

  } catch (e) {
    recup_erreur(e);
  }
}


function forgotPassword() {
  try {

		var entreprise = document.getElementById('Entreprise').value;
		var login = document.getElementById('login').value;

		var url = "chrome://opensi/content/popup-forgotPassword.xul?S_=0";
    window.openDialog(url,'','chrome,modal,centerscreen', entreprise, login);

	} catch (e) {
    recup_erreur(e);
  }
}
