/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");



function init() {
  try {

		document.getElementById('Entreprise').value = window.arguments[0];
		document.getElementById('Login').value = window.arguments[1];

  } catch (e) {
    recup_erreur(e);
  }
}


function resetPassword() {
  try {

		var entreprise = document.getElementById('Entreprise').value;
		var login = document.getElementById('Login').value;

		if (isEmpty(entreprise)) { showWarning("Veuillez indiquer votre identifiant d'entreprise"); }
		else if (isEmpty(login)) { showWarning("Veuillez indiquer votre login utilisateur"); }
		else if (window.confirm("Confirmez-vous la r\u00E9initialisation de votre mot de passe ?")) {

			var qReset = new QueryHttp("resetPassword.tmpl");
			qReset.setParam("Entreprise", entreprise);
			qReset.setParam("Login", login);
			var result = qReset.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("Votre mot de passe a \u00E9t\u00E9 r\u00E9initialis\u00E9. Un e-mail vous a \u00E9t\u00E9 envoy\u00E9 \u00E0 l'adresse reli\u00E9e \u00E0 votre compte utilisateur OpenSi.");
				window.close();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}
