/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");


var aAlertes = new Arbre("Superviseur/alertes/list-alerteTechnique.tmpl", "listeAlertes");
var aDossiers = new Arbre("Superviseur/alertes/list-alerteDossier.tmpl", "listDossiers");

var alerteId;



function init() {
	try {

		nouveauAlerteTechnique();
		filtrerAlerteTechnique();

	} catch (e) {
    recup_erreur(e);
  }
}


function filtrerAlerteTechnique() {
	try {

		aAlertes.setParam("Actif", document.getElementById("filtreActif").checked);
		aAlertes.initTree();

	} catch (e) {
    recup_erreur(e);
  }
}


function nouveauAlerteTechnique() {
  try {

		aAlertes.clearSelection();
		alerteId = "";

		aDossiers.setParam("Alerte_Id", alerteId);
		aDossiers.initTree();

		document.getElementById("Titre").value = "";
		document.getElementById("Message").value = "";
		document.getElementById("Date_D").value = "";
		document.getElementById("Date_F").value = "";
		document.getElementById("Actif").checked = true;
		document.getElementById("Type_Alerte").value = "";
		document.getElementById("For_All").checked = true;
		document.getElementById('boxDossiers').collapsed = true;

		document.getElementById('Titre').focus();

		document.getElementById('bSupprimer').disabled = true;
		document.getElementById('bNouveau').disabled = true;

	} catch (e) {
  	recup_erreur(e);
  }
}


function chargerAlerteTechnique() {
  try {

		if (aAlertes.isSelected()) {
			alerteId = aAlertes.getSelectedCellText("colAlerteId");

			var qLoad = new QueryHttp("Superviseur/alertes/loadAlerteTechnique.tmpl");
			qLoad.setParam("Alerte_Id", alerteId);
			var result = qLoad.execute();

			var contenu = result.responseXML.documentElement;

			document.getElementById("Titre").value = contenu.getAttribute('Titre');
			document.getElementById("Message").value = contenu.getAttribute('Message');
			document.getElementById("Date_D").value = contenu.getAttribute('Date_D');
			document.getElementById("Date_F").value = contenu.getAttribute('Date_F');
			document.getElementById("Actif").checked = contenu.getAttribute("Actif")=="true";
			document.getElementById("Type_Alerte").value = contenu.getAttribute('Type_Alerte');
			document.getElementById("For_All").checked = contenu.getAttribute("For_All")=="true";
			document.getElementById('boxDossiers').collapsed = document.getElementById("For_All").checked;

			aDossiers.setParam("Alerte_Id", alerteId);
			aDossiers.initTree();

			document.getElementById('bSupprimer').disabled = false;
			document.getElementById('bNouveau').disabled = false;
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function enregistrerAlerteTechnique() {
	try {

		var titre = document.getElementById('Titre').value;
		var message = document.getElementById('Message').value;
		var dateD = document.getElementById('Date_D').value;
		var dateF = document.getElementById('Date_F').value;
		var typeAlerte = document.getElementById('Type_Alerte').value;
		var actif = document.getElementById("Actif").checked;
		var forAll = document.getElementById("For_All").checked;

		var listDossierId = "";
		var listAD = "";
		for (var i=0; i<aDossiers.nbLignes(); i++) {
			listDossierId += aDossiers.getCellText(i, "colDossierId") +",";
			listAD += (aDossiers.getCellValue(i, "colSelectDossier")=="true") +",";
  	}

		if (isEmpty(titre)) { showWarning("Veuillez saisir un titre"); }
		else if (isEmpty(message)) { showWarning("Veuillez saisir un message"); }
		else if (isEmpty(typeAlerte)) { showWarning("Veuillez s\u00E9lectionner un type"); }
		else if (!isDate(dateD)) { showWarning("Date de d\u00E9but incorrecte"); }
		else if (!isEmpty(dateF) && !isDate(dateF)) { showWarning("Date de fin incorrecte"); }
		else if (!isEmpty(dateF) && !isDateInterval(dateD, dateF)) { showWarning("La date de fin doit \u00EAtre sup\u00E9rieure \u00E0 la date de d\u00E9but"); }
		else {

			var qSave;

			if (isEmpty(alerteId)) {
				qSave = new QueryHttp("Superviseur/alertes/createAlerteTechnique.tmpl");
			}
			else {
				qSave = new QueryHttp("Superviseur/alertes/updateAlerteTechnique.tmpl");
				qSave.setParam("Alerte_Id", alerteId);
			}

			qSave.setParam("Titre", titre);
			qSave.setParam("Message", message);
			qSave.setParam("Date_D", dateD);
			qSave.setParam("Date_F", dateF);
			qSave.setParam("Actif", actif);
			qSave.setParam("Type_Alerte", typeAlerte);
			qSave.setParam("For_All", forAll);
			qSave.setParam("List_Dossier_Id", listDossierId);
			qSave.setParam("List_AD", listAD);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				nouveauAlerteTechnique();
				aAlertes.initTree();
			}
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function supprimerAlerteTechnique() {
	try {

		if (!isEmpty(alerteId) && window.confirm("Confirmez-vous la suppression de l'alerte ?")) {

			var qDelete = new QueryHttp("Superviseur/alertes/deleteAlerteTechnique.tmpl");
			qDelete.setParam("Alerte_Id", alerteId);

			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			nouveauAlerteTechnique();
			aAlertes.initTree();
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function pressOnForAll() {
	try {

		document.getElementById('boxDossiers').collapsed = document.getElementById('For_All').checked;

	} catch (e) {
  	recup_erreur(e);
  }
}


function toutCocherAD(b) {
	try {

		for (var i=0; i<aDossiers.nbLignes(); i++) {
			aDossiers.setCellValue(i, "colSelectDossier", b);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function retourMenuPrincipal() {
	try {

		window.location = "chrome://opensi/content/superviseur/menu_superviseur.xul";

	} catch (e) {
    recup_erreur(e);
  }
}
