/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");


function init() {
	try {

		document.getElementById('OldPassword').focus();

	} catch (e) {
    recup_erreur(e);
  }
}


function changeRootPassword() {
	try {

		var old_password = document.getElementById('OldPassword').value;
  	var password = document.getElementById('Password').value;
		var password2 = document.getElementById('Password2').value;

		if (isEmpty(old_password) || isEmpty(password) || isEmpty(password2)) {
			showWarning("Vous devez remplir tous les champs !");
		}
		else if (password.length<8) { showWarning("Le mot de passe doit contenir au minimum 8 caract\u00E8res"); }
		else if (!isValidPassword(password)) { showWarning("Le mot de passe doit contenir au moins 3 des 4 types de caract\u00E8res (minuscule, majuscule, chiffre, car. sp\u00E9cial)"); }
		else if (password2 != password) {
			showWarning("Les mots de passe saisis sont diff\u00E9rents. Veuillez reconfirmer le mot de passe");
			document.getElementById('Password2').value = '';
			document.getElementById('Password2').focus();
		}
		else {
			var qChgPass = new QueryHttp("Superviseur/rootpassword/changeRootPassword.tmpl");
			qChgPass.setParam("Old_Password", old_password);
			qChgPass.setParam("New_Password", password);
			var result = qChgPass.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
				document.getElementById('OldPassword').value = "";
				document.getElementById('OldPassword').focus();
			}
			else {
				showMessage("Le mot de passe Superviseur a \u00E9t\u00E9 chang\u00E9 avec succ\u00E9s");
				retour_menuManager();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function retour_menuManager() {
  try {

  	window.location = "chrome://opensi/content/superviseur/menu_superviseur.xul";

	} catch (e) {
    recup_erreur(e);
  }
}
