/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");


var aMandats = new Arbre('TB/Mandats/list-mandat.tmpl', 'tMandats');

var qListMP = new QueryHttp("TB/Mandats/getDataListMP.tmpl");

var pageCourante;
var nbPages;
var etablissement;


function init() {
  try {

		etablissement = window.arguments[1];
		document.getElementById('numeroRUM').focus();

  } catch (e) {
    recup_erreur(e);
  }
}


function pressOnCriteres(ev) {
  try {

		if (ev.keyCode==13) {
			listerMandats();
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function pressOnListeMandats(ev) {
  try {

    if (ev.keyCode==13) {
			ouvrirMandat();
  	}

  } catch (e) {
    recup_erreur(e);
  }
}


function ouvrirMandat() {
  try {

		if (aMandats.isSelected()) {

			var numeroRUM = aMandats.getSelectedCellText('colNumeroRUM');
			var mandatId = aMandats.getSelectedCellText('colMandatId');

			window.arguments[0](numeroRUM, mandatId);
    	window.close();
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function listerMandats() {
	try {

		var numClient = document.getElementById('numClient').value;
		var denomination = document.getElementById('denomination').value;
		var numeroRUM = document.getElementById('numeroRUM').value;
		var typePaiement = document.getElementById('typePaiement').value;
		var typeMandat = document.getElementById('typeMandat').value;
		var nbLignesParPage = document.getElementById('nbLignesParPage').value;

		pageCourante = 1;
		nbPages = 1;
		document.getElementById('pageDeb').value = 1;
		document.getElementById('pageFin').value = 1;
		document.getElementById('bPrec').disabled = true;
		document.getElementById('bSuiv').disabled = true;

		document.getElementById('tMandats').disabled = true;
		aMandats.deleteTree();

		qListMP.setParam("Numero_RUM", numeroRUM);
		qListMP.setParam("Etat", "V");
		qListMP.setParam("Non_Utilise", true);
		qListMP.setParam("Type_Paiement", typePaiement);
		qListMP.setParam("Type_Mandat", typeMandat);
		qListMP.setParam("Etablissement", etablissement);
		qListMP.setParam("Date_Debut_Signature", "");
		qListMP.setParam("Date_Fin_Signature", "");
		qListMP.setParam("Denomination", denomination);
		qListMP.setParam("Num_Client", numClient);
		qListMP.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
		qListMP.setParam("Current_Page", pageCourante);

		var result = qListMP.execute();

		var contenu = result.responseXML.documentElement;

		nbPages = contenu.getAttribute("Nb_Pages");
		var listMandatId = contenu.getAttribute("List_Mandat_Id");
		document.getElementById('nbResultats').value = contenu.getAttribute("Nb_Resultats");

		aMandats.setParam("List_Mandat_Id", listMandatId);
		aMandats.initTree(initPagination);

	} catch (e) {
    recup_erreur(e);
  }
}


function initPagination() {
	try {

		document.getElementById('pageDeb').value = pageCourante;
		document.getElementById('pageFin').value = (nbPages>0?nbPages:1);
		document.getElementById('bPrec').disabled = (pageCourante==1);
		document.getElementById('bSuiv').disabled = (pageCourante>=nbPages); // peut se produire si nbPages=0

		document.getElementById('tMandats').disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPagePrec() {
	try {

		pageCourante--;
		majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPageSuiv() {
	try {

		pageCourante++;
		majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function majPagination() {
	try {

		document.getElementById('pageDeb').value = pageCourante;
		document.getElementById('bPrec').disabled = (pageCourante==1);
		document.getElementById('bSuiv').disabled = (pageCourante==nbPages);

		document.getElementById('tMandats').disabled = true;

		qListMP.setParam("Current_Page", pageCourante);
		var result = qListMP.execute();
		var listMandatId = result.responseXML.documentElement.getAttribute("List_Mandat_Id");

		aMandats.setParam("List_Mandat_Id", listMandatId);
		aMandats.initTree(afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function afterMajPagination() {
	try {

		document.getElementById('tMandats').disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function reinitialiser() {
	try {

		aMandats.deleteTree();

		document.getElementById('numClient').value = "";
		document.getElementById('numeroRUM').value = "";
		document.getElementById('denomination').value = "";
		document.getElementById('typePaiement').value = "";
		document.getElementById('typeMandat').value = "";

	} catch (e) {
    recup_erreur(e);
  }
}

