/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var ofu_utilisateurId;
var ofu_curDossierId = "";
var ofu_curEtablissement;
var ofu_curPole;
var ofu_curBorne;
var ofu_modified = false;
var ofu_mode;

var ofu_accFlash;
var ofu_accBAM;
var ofu_accMWMExpMonoBL;
var ofu_accMWMExpMultiBL;
var ofu_accMWMCdeClient;
var ofu_specLHGDV;
var ofu_specLHGRV;
var ofu_specLHGPV;
var ofu_specLHCFF;
var ofu_specLCARAP;
var ofu_specTNMPA;
var ofu_specTNDAF;
var ofu_specLVPBFC;
var ofu_specLCAGEV;
var ofu_accCrossDock;
var ofu_specLHELE = false;
var ofu_actReassortCC = false;
var ofu_specSMEAR = false;
var ofu_actCodeStats = false;
var ofu_specEDEFV = false;
var ofu_specREERC = false;
var ofu_specLMECR = false;
var ofu_specKEESK = false;
var ofu_specLHFNP = false;
var ofu_specHMDNP = false;
var ofu_gacCoutTrans = false;

var ofu_aDroits = new Arbre('Utilisateurs/Utilisateurs/list-dossierUtilisateurAutorise.tmpl', 'ofu-listeDroits');
var ofu_aDossiers = new Arbre('Utilisateurs/Utilisateurs/list-dossierUtilisateurInterdit.tmpl', 'ofu-listeDossiers');
var ofu_aEtablissements = new Arbre('ComboListe/combo-etablissements.tmpl', 'ofu-etablissementRattachement');
var ofu_aBornes = new Arbre('ComboListe/combo-bornesImpression.tmpl', 'ofu-borneImpression');
var ofu_aPoles = new Arbre("ComboListe/combo-polesActivite.tmpl", "ofu-poleActivite");
var ofu_aDroitsDepots = new Arbre("Utilisateurs/Utilisateurs/list-droitsDepots.tmpl", "ofu-listDroitsDepots");
var ofu_aDroitsEtabs = new Arbre("Utilisateurs/Utilisateurs/list-droitsEtablissements.tmpl", "ofu-listDroitsEtabs");
var ofu_aDroitsFours = new Arbre("Utilisateurs/Utilisateurs/list-droitsFournisseurs.tmpl", "ofu-listDroitsFours");
var ofu_aDroitsProvs = new Arbre("Utilisateurs/Utilisateurs/list-droitsProvenances.tmpl", "ofu-listDroitsProvs");
var ofu_aDroitsCats = new Arbre("Utilisateurs/Utilisateurs/list-droitsCatalogues.tmpl", "ofu-listDroitsCats");
var ofu_aDroitsIndics = new Arbre("Utilisateurs/Utilisateurs/list-droitsIndicateurs.tmpl", "ofu-listDroitsIndics");



function ofu_init() {
  try {

		var qEntMWM = new QueryHttp("Utilisateurs/getEntrepriseAccMWM.tmpl");
		var result = qEntMWM.execute();
		var contenu = result.responseXML.documentElement;

		ofu_accFlash = contenu.getAttribute("Acc_MWM")=="true";
		ofu_accBAM = contenu.getAttribute("Acc_BAM")=="true";
	  ofu_accMWMExpMonoBL = contenu.getAttribute("Acc_MWM_ExpMonoBL")=="true";
	  ofu_accMWMExpMultiBL = contenu.getAttribute("Acc_MWM_ExpMultiBL")=="true";
	  ofu_accMWMCdeClient = contenu.getAttribute("Acc_MWM_CdeClient")=="true";
	  ofu_specLHGDV = contenu.getAttribute("Spec_LH_GDV")=="true";
	  ofu_specLHGRV = contenu.getAttribute("Spec_LH_GRV")=="true";
	  ofu_specLHGPV = contenu.getAttribute("Spec_LH_GPV")=="true";
	  ofu_specLHCFF = contenu.getAttribute("Spec_LH_CFF")=="true";
	  ofu_specLCARAP = contenu.getAttribute("Spec_LCA_RAP")=="true";
	  ofu_specTNMPA = contenu.getAttribute("Spec_TN_MPA")=="true";
	  ofu_specTNDAF = contenu.getAttribute("Spec_TN_DAF")=="true";
	  ofu_specLVPBFC = contenu.getAttribute("Spec_LVP_BFC")=="true";
	  ofu_specLCAGEV = contenu.getAttribute("Spec_LCA_GEV")=="true";
	  ofu_accCrossDock = contenu.getAttribute("Acc_Cross_Dock")=="true";

		document.getElementById("ofu-cFlash").collapsed = !ofu_accFlash;
		document.getElementById("ofu-cAccBAM").collapsed = !ofu_accBAM;
		document.getElementById("ofu-tabActivity").collapsed = !ofu_accBAM;
		document.getElementById("ofu-tabFlash").collapsed = !ofu_accFlash;
		document.getElementById("ofu-boxFlash").collapsed = !ofu_accFlash;
		document.getElementById("ofu-cMWM_ExpMonoBL").collapsed = !ofu_accMWMExpMonoBL;
		document.getElementById("ofu-cMWM_ExpMultiBL").collapsed = !ofu_accMWMExpMultiBL;
		document.getElementById("ofu-cMWM_CdeClient").collapsed = !ofu_accMWMCdeClient;
		document.getElementById("ofu-cGestionIntiVente").collapsed = !ofu_specLHGDV;
		document.getElementById("ofu-rowGestionIntiVente").collapsed = !ofu_specLHGDV;
		document.getElementById("ofu-cGestionRespVente").collapsed = !ofu_specLHGRV;
		document.getElementById("ofu-rowGestionRespVente").collapsed = !ofu_specLHGRV;
		document.getElementById("ofu-cGestionEtabVente").collapsed = !ofu_specLCAGEV;
		document.getElementById("ofu-rowGestionEtabVente").collapsed = !ofu_specLCAGEV;
		document.getElementById("ofu-cGestionPoleVente").collapsed = !ofu_specLHGPV;
		document.getElementById("ofu-rowGestionPoleVente").collapsed = !ofu_specLHGPV;
		document.getElementById("ofu-cGC_AControle").collapsed = !ofu_specLHCFF;
		document.getElementById("ofu-rowRestricAccCDVPA").collapsed = !ofu_specLCARAP;
		document.getElementById("ofu-cModifPrixFA").collapsed = !ofu_specTNMPA;
		document.getElementById("ofu-rowModifPrixFA").collapsed = !ofu_specTNMPA;
		document.getElementById("ofu-cMWM_LocCrossDock").collapsed = !ofu_accCrossDock;
		document.getElementById("ofu-cMWM_ExpCrossDock").collapsed = !ofu_accCrossDock;
		document.getElementById("ofu-cGC_EExpCrossDock").collapsed = !ofu_accCrossDock;
		document.getElementById("ofu-cGestionBloqueCli").collapsed = !ofu_specLVPBFC;
		document.getElementById("ofu-rowGestionBloqueCli").collapsed = !ofu_specLVPBFC;
		document.getElementById("ofu-tabDroitsFours").collapsed = !ofu_specTNDAF;

		var aProfils = new Arbre('ComboListe/combo-profilsType.tmpl', 'ofu-profils');
		aProfils.initTree();

	} catch (e) {
  	recup_erreur(e);
	}
}


function ofu_initIHM() {
	try {

		document.getElementById('ofu-panneau').selectedIndex = 0;

		document.getElementById("ofu-boxFlash").collapsed = ofu_mode=="C" || !ofu_accFlash;

		document.getElementById("ofu-login").disabled = ofu_mode=="M";

		document.getElementById('ofu-tabDroits').collapsed = ofu_mode=="C";

		document.getElementById('ofu-rowModifPassword').collapsed = ofu_mode=="C";
		document.getElementById('ofu-rowPassword').collapsed = ofu_mode=="M";
		document.getElementById('ofu-rowPassword2').collapsed = ofu_mode=="M";

		document.getElementById('ofu-bEnleverDroit').disabled = ofu_mode=="M";
		document.getElementById('ofu-bAjouterDroit').disabled = ofu_mode=="M";

		ofu_setModified(false);

	} catch (e) {
		recup_erreur(e);
	}
}


function ofu_nouveauUtilisateur() {
  try {

		ofu_mode = "C";
		ofu_utilisateurId = "";

		document.getElementById('ofu-lblUtilisateur').value = "Fiche utilisateur";

		document.getElementById("ofu-login").value = "";
		document.getElementById("ofu-password").value = "";
		document.getElementById("ofu-password2").value = "";
		document.getElementById("ofu-civilite").value = "0";
		document.getElementById("ofu-nom").value = "";
		document.getElementById("ofu-prenom").value = "";
		document.getElementById("ofu-fonction").value = "";
		document.getElementById("ofu-telephone").value = "";
		document.getElementById("ofu-email").value = "";
		document.getElementById("ofu-emailRecupPW").value = "";
		document.getElementById('ofu-administrateur').checked = false;
		document.getElementById('ofu-actif').checked = true;
		document.getElementById('ofu-notification').checked = true;

		document.getElementById('ofu-login').focus();

		ofu_initIHM();

	} catch (e) {
  	recup_erreur(e);
  }
}


function ofu_chargerUtilisateur() {
  try {

		ofu_mode = "M";

		var qLoad = new QueryHttp("Utilisateurs/Utilisateurs/loadUtilisateur.tmpl");
		qLoad.setParam('Utilisateur_Id', ofu_utilisateurId);
		var result = qLoad.execute();

		var contenu = result.responseXML.documentElement;

		document.getElementById('ofu-lblUtilisateur').value = "Fiche utilisateur "+ contenu.getAttribute('Login');

		document.getElementById("ofu-login").value = contenu.getAttribute('Login');
		document.getElementById("ofu-civilite").value = contenu.getAttribute('Civilite');
		document.getElementById("ofu-nom").value = contenu.getAttribute('Nom');
		document.getElementById("ofu-prenom").value = contenu.getAttribute('Prenom');
		document.getElementById("ofu-fonction").value = contenu.getAttribute('Fonction');
		document.getElementById("ofu-telephone").value = contenu.getAttribute('Telephone');
		document.getElementById("ofu-email").value = contenu.getAttribute('Email');
		document.getElementById("ofu-emailRecupPW").value = contenu.getAttribute('Email_Recup_PW');
		document.getElementById('ofu-administrateur').checked = (contenu.getAttribute('Administrateur')=="true");
		document.getElementById("ofu-actif").checked = (contenu.getAttribute("Actif")=="true");
		document.getElementById("ofu-notification").checked = (contenu.getAttribute("Notification")=="true");

		ofu_aDroits.setParam('Utilisateur_Id', ofu_utilisateurId);
		ofu_aDroits.initTree();

		ofu_aDossiers.setParam('Utilisateur_Id', ofu_utilisateurId);
		ofu_aDossiers.initTree();

		ofu_aDroitsDepots.setParam("Utilisateur_Id", ofu_utilisateurId);
		ofu_aDroitsEtabs.setParam("Utilisateur_Id", ofu_utilisateurId);
		ofu_aDroitsFours.setParam("Utilisateur_Id", ofu_utilisateurId);
		ofu_aDroitsProvs.setParam("Utilisateur_Id", ofu_utilisateurId);
		ofu_aDroitsCats.setParam("Utilisateur_Id", ofu_utilisateurId);
		ofu_aDroitsIndics.setParam("Utilisateur_Id", ofu_utilisateurId);

		ofu_activerDroitsDossiers(false);

		ofu_initIHM();

	} catch (e) {
  	recup_erreur(e);
  }
}


function ofu_enregistrerUtilisateur() {
	try {

		var login = document.getElementById('ofu-login').value;
		var password = document.getElementById('ofu-password').value;
		var password2 = document.getElementById('ofu-password2').value;
		var civilite = document.getElementById('ofu-civilite').value;
		var nom = document.getElementById('ofu-nom').value;
		var prenom = document.getElementById('ofu-prenom').value;
		var telephone = document.getElementById('ofu-telephone').value;
		var fonction = document.getElementById('ofu-fonction').value;
		var email = document.getElementById('ofu-email').value;
		var emailRecupPW = document.getElementById('ofu-emailRecupPW').value;
		var administrateur = document.getElementById('ofu-administrateur').checked;
		var actif = document.getElementById('ofu-actif').checked;
		var notification = document.getElementById('ofu-notification').checked;

		if (ofu_mode=="C" && isEmpty(login)) { showWarning("Login de l'utilisateur manquant"); }
		else if (isEmpty(nom)) { showWarning("Nom de l'utilisateur manquant"); }
		else if (ofu_mode=="C" && isEmpty(password)) { showWarning("Mot de passe manquant"); }
		else if (ofu_mode=="C" && password.length<8) { showWarning("Le mot de passe doit contenir au minimum 8 caract\u00E8res"); }
		else if (ofu_mode=="C" && !isValidPassword(password)) { showWarning("Le mot de passe doit contenir au moins 3 des 4 types de caract\u00E8res (minuscule, majuscule, chiffre, car. sp\u00E9cial)"); }
		else if (ofu_mode=="C" && password2!=password) {
			showWarning("Les mots de passe saisis sont diff\u00E9rents ! Veuillez reconfirmer le mot de passe");
			document.getElementById('ofu-password2').value = "";
		}
		else if (ofu_mode=="C" && (login.toLowerCase()=="root" || login.toLowerCase()=="auto")) { showWarning("Login non autoris\u00E9"); }
		else if (ofu_mode=="C" && !isCleAlpha(login)) { showWarning("Login incorrect ! (A-Z,a-z,0-9,_)"); }
		else if (!isEmpty(telephone) && !isPhone(telephone)) { showWarning("Le t\u00E9l\u00E9phone est incorrect"); }
		else if (!isEmpty(email) && !isEmail(email)) { showWarning("L'adresse e-mail est incorrecte"); }
		else if (isEmpty(emailRecupPW)) { showWarning("Adresse e-mail de r\u00E9cup\u00E9ration de mot de passe manquante"); }
		else if (!isEmail(emailRecupPW)) { showWarning("L'adresse e-mail de r\u00E9cup\u00E9ration de mot de passe est incorrecte"); }
		else {

			var qSave;

			if (ofu_mode=="C") {
				qSave = new QueryHttp("Utilisateurs/Utilisateurs/createUtilisateur.tmpl");
				qSave.setParam('Login', login);
			}
			else {
				qSave = new QueryHttp("Utilisateurs/Utilisateurs/updateUtilisateur.tmpl");
				qSave.setParam("Utilisateur_Id", ofu_utilisateurId);
			}

			qSave.setParam('Password', password);
			qSave.setParam('Civilite', civilite);
			qSave.setParam('Nom', nom);
			qSave.setParam('Prenom', prenom);
			qSave.setParam('Fonction', fonction);
			qSave.setParam('Telephone', telephone);
			qSave.setParam('Email', email);
			qSave.setParam('Email_Recup_PW', emailRecupPW);
			qSave.setParam('Actif', actif);
			qSave.setParam('Notification', notification);
			qSave.setParam('Administrateur', administrateur);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				if (ofu_mode=="C") {
					ofu_utilisateurId = result.responseXML.documentElement.getAttribute("Utilisateur_Id");
					ofu_chargerUtilisateur();
				}
				else {
					ofu_setModified(false);
				}
			}
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function ofu_demandeEnregistrement() {
  try {

		if (ofu_modified) {
			if (window.confirm("Voulez-vous enregistrer les modifications apport\u00E9es \u00E0 la fiche utilisateur ?")) {
				ofu_enregistrerUtilisateur();
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function ofu_setModified(m) {
  try {

  	ofu_modified = m;
		if (m) {
			document.getElementById('ofu-tabFiche').setAttribute('image', 'chrome://opensi/content/design/icones/modified.png');
		}
		else {
			document.getElementById('ofu-tabFiche').setAttribute('image', null);
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function ofu_genererBadgeMWM() {
	try {

		document.getElementById('ofu-pdfBadge').setAttribute('src', '');
		document.getElementById('ofu-deckUtilisateur').selectedIndex = 1;
		document.getElementById('bRetourUtilisateur').collapsed = false;

		var qBadge = new QueryHttp("Utilisateurs/Utilisateurs/generateBadgeMWM.tmpl");
		qBadge.setParam("Utilisateur_Id", ofu_utilisateurId);
		var result = qBadge.execute();

		var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
		document.getElementById('ofu-pdfBadge').setAttribute("src", page);

	}	catch (e) {
		recup_erreur(e);
	}
}


function ofu_chargerEtablissements(selection) {
	try {

		ofu_curEtablissement = selection;
		ofu_aEtablissements.setParam("Dossier_Id", ofu_curDossierId);
		ofu_aEtablissements.setParam("Selection", ofu_curEtablissement);
		ofu_aEtablissements.setParam("No_Check_Rights", true);
		ofu_aEtablissements.initTree(ofu_initEtablissement);

	} catch (e) {
		recup_erreur(e);
	}
}


function ofu_initEtablissement() {
	try {

		document.getElementById("ofu-etablissementRattachement").value = ofu_curEtablissement;

	} catch (e) {
		recup_erreur(e);
	}
}


function ofu_chargerBornes(selection) {
	try {

		ofu_curBorne = selection;
		ofu_aBornes.setParam("Dossier_Id", ofu_curDossierId);
		ofu_aBornes.setParam("Selection", ofu_curBorne);
		ofu_aBornes.initTree(ofu_initBorne);

	} catch (e) {
		recup_erreur(e);
	}
}


function ofu_initBorne() {
	try {

		document.getElementById("ofu-borneImpression").value = ofu_curBorne;

	} catch (e) {
		recup_erreur(e);
	}
}


function ofu_chargerPoles(selection) {
	try {

		ofu_curPole = selection;
		ofu_aPoles.setParam("Dossier_Id", ofu_curDossierId);
		ofu_aPoles.setParam("Selection", ofu_curPole);
		ofu_aPoles.initTree(ofu_initPole);

	} catch (e) {
		recup_erreur(e);
	}
}


function ofu_initPole() {
	try {

		document.getElementById("ofu-poleActivite").value = ofu_curPole;

	} catch (e) {
		recup_erreur(e);
	}
}


function ofu_affecterDroits() {
	try {

		var rangeCount = ofu_aDossiers.getRangeCount();

		for(var i=0; i<rangeCount; i++) {
			var start = {};
 			var end = {};
 			ofu_aDossiers.getRangeAt(i,start,end);

 			for(var c=start.value; c<=end.value; c++) {

				var dossierId = ofu_aDossiers.getCellText(c,'ofu-colDossierIdNA');

				if (!isEmpty(dossierId)) {
					var qAdd = new QueryHttp("Utilisateurs/Utilisateurs/addRightsOnDossier.tmpl");
					qAdd.setParam('Utilisateur_Id', ofu_utilisateurId);
					qAdd.setParam('Dossier_Id', dossierId);
					qAdd.execute();
				}
 			}
		}

		ofu_aDroits.initTree();
		ofu_aDossiers.initTree();

		document.getElementById('ofu-bAjouterDroit').disabled = true;
		ofu_activerDroitsDossiers(false);

	} catch (e) {
    recup_erreur(e);
  }
}


function ofu_supprimerDroits() {
	try {

		var rangeCount = ofu_aDroits.getRangeCount();

		for(var i=0; i<rangeCount; i++) {
			var start = {};
  		var end = {};
  		ofu_aDroits.getRangeAt(i,start,end);

			for(var c=start.value; c<=end.value; c++) {

				var dossierId = ofu_aDroits.getCellText(c,'ofu-colDossierIdDU');

				if (!isEmpty(dossierId)) {
					var qRemove = new QueryHttp("Utilisateurs/Utilisateurs/removeRightsOnDossier.tmpl");
					qRemove.setParam('Utilisateur_Id', ofu_utilisateurId);
					qRemove.setParam('Dossier_Id', dossierId);
					qRemove.execute();
				}
			}
		}

		ofu_aDroits.initTree();
		ofu_aDossiers.initTree();

		document.getElementById('ofu-bEnleverDroit').disabled = true;
		ofu_activerDroitsDossiers(false);

	} catch (e) {
    recup_erreur(e);
  }
}


function ofu_changerPassword() {
	try {

		var page ="chrome://opensi/content/utilisateurs/utilisateurs/popup-password.xul";
		window.openDialog(page,'','chrome,modal,centerscreen', ofu_utilisateurId);

	} catch (e) {
    recup_erreur(e);
  }
}


function ofu_pressOnDossiersAutorises() {
	try {

		if (ofu_aDroits.isSelected()) {
			document.getElementById('ofu-bEnleverDroit').disabled = false;
			document.getElementById('ofu-bAjouterDroit').disabled = true;
			ofu_aDossiers.clearSelection();
			if (ofu_aDroits.nbSelection()==1) {
				ofu_activerDroitsDossiers(true);
			}
			else {
				ofu_activerDroitsDossiers(false);
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function ofu_pressOnDossiersInterdits() {
	try {

		if (ofu_aDossiers.isSelected()) {
			document.getElementById('ofu-bEnleverDroit').disabled = true;
			document.getElementById('ofu-bAjouterDroit').disabled = false;
			ofu_aDroits.clearSelection();
			ofu_activerDroitsDossiers(false);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function ofu_activerDroitsDossiers(b) {
	try {

		if (b) {
			ofu_curDossierId = ofu_aDroits.getSelectedCellText("ofu-colDossierIdDU");
			document.getElementById('ofu-lblDroits').label = "Droits sur le dossier "+ ofu_aDroits.getSelectedCellText("ofu-colCodeDossierDU");
			ofu_chargerDroitsDossier();
		}
		else {
			ofu_curDossierId = "";
			document.getElementById('ofu-lblDroits').label = "Droits sur le dossier";

			ofu_cocherDG(false);
			ofu_cocherGC(false);
			ofu_cocherCompta(false);
			ofu_cocherStats(false);
			ofu_cocherMWM(false);

			document.getElementById("ofu-cReadOnlyGC_SArticles").checked = false;
			document.getElementById("ofu-cReadOnlyGC_VDevis").checked = false;
			document.getElementById("ofu-cReadOnlyGC_VAffaires").checked = false;
			document.getElementById("ofu-cReadOnlyGC_TClients").checked = false;
			document.getElementById("ofu-cReadOnlyGC_SIOStocks").checked = false;
			document.getElementById("ofu-cReadOnlyGC_DRegCli").checked = false;

			document.getElementById("ofu-etablissementRattachement").value = "";
			document.getElementById("ofu-cMaxValidationDC").value = "";
			document.getElementById("ofu-borneImpression").value = "";
			document.getElementById("ofu-poleActivite").value = "";
			document.getElementById('ofu-nbIndicateurs').value = "";

			document.getElementById("ofu-rowPoleActivite").collapsed = true;
			document.getElementById('ofu-cEditionDES_VLE').collapsed = true;
			document.getElementById('ofu-cEditionDES_VRC').collapsed = true;
			document.getElementById('ofu-cEditionDES_VAR').collapsed = true;
			document.getElementById('ofu-cEditionDES_VCS').collapsed = true;
			document.getElementById('ofu-cEditionDES_VFV').collapsed = true;
			document.getElementById('ofu-cEditionDES_VRE').collapsed = true;
			document.getElementById('ofu-cEditionDES_VCR').collapsed = true;
			document.getElementById('ofu-cEditionDES_VHP').collapsed = true;
			document.getElementById('ofu-cEditionDES_ASF').collapsed = true;
			document.getElementById('ofu-cEditionDES_ASD').collapsed = true;

			ofu_aDroitsDepots.deleteTree();
			ofu_aDroitsEtabs.deleteTree();
			ofu_aDroitsFours.deleteTree();
			ofu_aDroitsProvs.deleteTree();
			ofu_aDroitsCats.deleteTree();
			ofu_aDroitsIndics.deleteTree();
		}

		// Liste profils
		document.getElementById("ofu-profils").disabled = !b;
		document.getElementById("ofu-bValidProfil").disabled = !b;

		// Droits gnraux
		document.getElementById("ofu-cGestionCo").disabled = !b;
		document.getElementById("ofu-cCompta").disabled = !b;
		document.getElementById("ofu-cContact").disabled = !b;
		document.getElementById("ofu-cTransac").disabled = !b;
		document.getElementById("ofu-cConfig").disabled = !b;
		document.getElementById("ofu-cFlash").disabled = !b;
		document.getElementById("ofu-cAccBAM").disabled = !b;
		document.getElementById("ofu-cDirection").disabled = !b;
		document.getElementById("ofu-cValidationCF").disabled = !b;
		document.getElementById("ofu-cValidationCC").disabled = !b;
		document.getElementById("ofu-cValidationCCZero").disabled = !b;
		document.getElementById("ofu-cAnnulationCC").disabled = !b;
		document.getElementById("ofu-cValidationTS").disabled = !b;
		document.getElementById("ofu-cValidationIS").disabled = !b;
		document.getElementById("ofu-cValidationRG").disabled = !b;
		document.getElementById("ofu-cValidationBR").disabled = !b;
		document.getElementById("ofu-cValidationAF").disabled = !b;
		document.getElementById("ofu-cValidationAC").disabled = !b;
		document.getElementById("ofu-cValidationBP").disabled = !b;
		document.getElementById("ofu-cAnnulationBP").disabled = !b;
		document.getElementById("ofu-cValidationBL").disabled = !b;
		document.getElementById("ofu-cAnnulationBL").disabled = !b;
		document.getElementById("ofu-cValidationDC").disabled = !b;
		document.getElementById("ofu-cMaxValidationDC").disabled = !b;
		document.getElementById("ofu-cClotureFact").disabled = !b;
		document.getElementById("ofu-cModifElemFinDV").disabled = !b;
		document.getElementById("ofu-cModifElemFinFCA").disabled = !b;
		document.getElementById("ofu-cIgnorePVPlancher").disabled = !b;
		document.getElementById("ofu-cEditionListeDL").disabled = !b;
		document.getElementById("ofu-cEditionListeDA").disabled = !b;
		document.getElementById("ofu-cEditionListeDV").disabled = !b;
		document.getElementById("ofu-cShowTotauxDV").disabled = !b;
		document.getElementById("ofu-cAccesCoutAchat").disabled = !b;
		document.getElementById("ofu-cAccesBanqueCli").disabled = !b;
		document.getElementById("ofu-cAccesBanqueFou").disabled = !b;
		document.getElementById("ofu-cRestricAccCDVPA").disabled = !b;
		document.getElementById("ofu-cGestionDevisType").disabled = !b;
		document.getElementById("ofu-cShowElemFour").disabled = !b;
		document.getElementById("ofu-cGestionRespVente").disabled = !b;
		document.getElementById("ofu-cGestionEtabVente").disabled = !b;
		document.getElementById("ofu-cGestionPoleVente").disabled = !b;
		document.getElementById("ofu-cGestionIntiVente").disabled = !b;
		document.getElementById("ofu-cGestionBloqueCli").disabled = !b;
		document.getElementById("ofu-cModifStockES").disabled = !b;
		document.getElementById("ofu-cModifPrixFA").disabled = !b;
		document.getElementById("ofu-cModifPADV").disabled = !b;
		document.getElementById("ofu-cAnonymisationFC").disabled = !b;
		document.getElementById("ofu-cGCBrightColor").disabled = !b;
		document.getElementById("ofu-etablissementRattachement").disabled = !b;
		document.getElementById("ofu-borneImpression").disabled = !b;
		document.getElementById("ofu-poleActivite").disabled = !b;
		document.getElementById("ofu-bDGCoche").disabled = !b;
		document.getElementById("ofu-bDGDecoche").disabled = !b;
		document.getElementById("ofu-bEnregistrerDroits").disabled = !b;

		// Accs menus gestion commerciale
		document.getElementById("ofu-cGC_TClients").disabled = !b;
		document.getElementById("ofu-cReadOnlyGC_TClients").disabled = !b;
		document.getElementById("ofu-cGC_VDevis").disabled = !b;
		document.getElementById("ofu-cGC_ACommandes").disabled = !b;
		document.getElementById("ofu-cGC_SArticles").disabled = !b;
		document.getElementById("ofu-cReadOnlyGC_SArticles").disabled = !b;
		document.getElementById("ofu-cGC_DRegFour").disabled = !b;
		document.getElementById("ofu-cGC_TFournisseurs").disabled = !b;
		document.getElementById("ofu-cGC_VAffaires").disabled = !b;
		document.getElementById("ofu-cReadOnlyGC_VDevis").disabled = !b;
		document.getElementById("ofu-cReadOnlyGC_VAffaires").disabled = !b;
		document.getElementById("ofu-cGC_APrepaCom").disabled = !b;
		document.getElementById("ofu-cGC_STarifs").disabled = !b;
		document.getElementById("ofu-cGC_DRegCli").disabled = !b;
		document.getElementById("ofu-cGC_TCommerciaux").disabled = !b;
		document.getElementById("ofu-cGC_ARecepCom").disabled = !b;
		document.getElementById("ofu-cGC_SFabrication").disabled = !b;
		document.getElementById("ofu-cGC_DRemises").disabled = !b;
		document.getElementById("ofu-cGC_ARetours").disabled = !b;
		document.getElementById("ofu-cGC_SInventaire").disabled = !b;
		document.getElementById("ofu-cGC_DEditions").disabled = !b;
		document.getElementById("ofu-cGC_AFactures").disabled = !b;
		document.getElementById("ofu-cGC_AControle").disabled = !b;
		document.getElementById("ofu-cGC_STracabilite").disabled = !b;
		document.getElementById("ofu-cGC_DTabBord").disabled = !b;
		document.getElementById("ofu-cGC_VFactures").disabled = !b;
		document.getElementById("ofu-cGC_VRetours").disabled = !b;
		document.getElementById("ofu-cGC_STransferts").disabled = !b;
		document.getElementById("ofu-cGC_DTransCpta").disabled = !b;
		document.getElementById("ofu-cGC_VFactuAuto").disabled = !b;
		document.getElementById("ofu-cGC_SMouvements").disabled = !b;
		document.getElementById("ofu-cGC_SEmplacements").disabled = !b;
		document.getElementById("ofu-cGC_STransEmp").disabled = !b;
		document.getElementById("ofu-cGC_SIOStocks").disabled = !b;
		document.getElementById("ofu-cReadOnlyGC_SIOStocks").disabled = !b;
		document.getElementById("ofu-cReadOnlyGC_DRegCli").disabled = !b;
		document.getElementById("ofu-cGC_SParamStocks").disabled = !b;
		document.getElementById("ofu-cGC_DExportIdep").disabled = !b;
		document.getElementById("ofu-cGC_DDeclEcoPart").disabled = !b;
		document.getElementById("ofu-cGC_VEnvoiFact").disabled = !b;
		document.getElementById("ofu-cGC_DImpExpCsv").disabled = !b;
		document.getElementById("ofu-cGC_VAbonnements").disabled = !b;
		document.getElementById("ofu-cGC_DPassword").disabled = !b;
		document.getElementById("ofu-cGC_EExpesCC").disabled = !b;
		document.getElementById("ofu-cGC_EExpesTS").disabled = !b;
		document.getElementById("ofu-cGC_EPrepaExpes").disabled = !b;
		document.getElementById("ofu-cGC_EExpCrossDock").disabled = !b;
		document.getElementById("ofu-cGC_ESuiviLog").disabled = !b;
		document.getElementById("ofu-cGC_ESuiviTrans").disabled = !b;
		document.getElementById("ofu-bGCCoche").disabled = !b;
		document.getElementById("ofu-bGCDecoche").disabled = !b;

		// Accs menus comptabilit
		document.getElementById("ofu-cCG_CSaisie").disabled = !b;
		document.getElementById("ofu-cCG_EBalance").disabled = !b;
		document.getElementById("ofu-cCG_SBordGest").disabled = !b;
		document.getElementById("ofu-cCG_AComptes").disabled = !b;
		document.getElementById("ofu-cCG_DComptes").disabled = !b;
		document.getElementById("ofu-cCG_CRevision").disabled = !b;
		document.getElementById("ofu-cCG_ECentral").disabled = !b;
		document.getElementById("ofu-cCG_SBordTres").disabled = !b;
		document.getElementById("ofu-cCG_AGdLivre").disabled = !b;
		document.getElementById("ofu-cCG_DAboEcr").disabled = !b;
		document.getElementById("ofu-cCG_CTransCop").disabled = !b;
		document.getElementById("ofu-cCG_EGdLivre").disabled = !b;
		document.getElementById("ofu-cCG_AParametrages").disabled = !b;
		document.getElementById("ofu-cCG_DModeles").disabled = !b;
		document.getElementById("ofu-cCG_CRappro").disabled = !b;
		document.getElementById("ofu-cCG_EJournaux").disabled = !b;
		document.getElementById("ofu-cCG_DImpBanque").disabled = !b;
		document.getElementById("ofu-cCG_CClotMens").disabled = !b;
		document.getElementById("ofu-cCG_EBalAgee").disabled = !b;
		document.getElementById("ofu-cCG_DImpExpEcr").disabled = !b;
		document.getElementById("ofu-cCG_CClotExo").disabled = !b;
		document.getElementById("ofu-cCG_EBilan").disabled = !b;
		document.getElementById("ofu-cCG_DPassword").disabled = !b;
		document.getElementById("ofu-cCG_EResultat").disabled = !b;
		document.getElementById("ofu-cCG_ESoldes").disabled = !b;
		document.getElementById("ofu-cCG_EPlanCpte").disabled = !b;
		document.getElementById("ofu-bCCoche").disabled = !b;
		document.getElementById("ofu-bCDecoche").disabled = !b;

		// Accs statistiques
		document.getElementById("ofu-cEditionDES_CPC").disabled = !b;
		document.getElementById("ofu-cEditionDES_CLC").disabled = !b;
		document.getElementById("ofu-cEditionDES_FPF").disabled = !b;
		document.getElementById("ofu-cEditionDES_FLF").disabled = !b;
		document.getElementById("ofu-cEditionDES_SPA").disabled = !b;
		document.getElementById("ofu-cEditionDES_SFA").disabled = !b;
		document.getElementById("ofu-cEditionDES_SMS").disabled = !b;
		document.getElementById("ofu-cEditionDES_SES").disabled = !b;
		document.getElementById("ofu-cEditionDES_SRS").disabled = !b;
		document.getElementById("ofu-cEditionDES_SPF").disabled = !b;
		document.getElementById("ofu-cEditionDES_SMA").disabled = !b;
		document.getElementById("ofu-cEditionDES_VJV").disabled = !b;
		document.getElementById("ofu-cEditionDES_VJA").disabled = !b;
		document.getElementById("ofu-cEditionDES_VVA").disabled = !b;
		document.getElementById("ofu-cEditionDES_VFA").disabled = !b;
		document.getElementById("ofu-cEditionDES_VFC").disabled = !b;
		document.getElementById("ofu-cEditionDES_VFD").disabled = !b;
		document.getElementById("ofu-cEditionDES_VSC").disabled = !b;
		document.getElementById("ofu-cEditionDES_VLE").disabled = !b;
		document.getElementById("ofu-cEditionDES_VLC").disabled = !b;
		document.getElementById("ofu-cEditionDES_VEC").disabled = !b;
		document.getElementById("ofu-cEditionDES_VCT").disabled = !b;
		document.getElementById("ofu-cEditionDES_VRC").disabled = !b;
		document.getElementById("ofu-cEditionDES_VAR").disabled = !b;
		document.getElementById("ofu-cEditionDES_VCS").disabled = !b;
		document.getElementById("ofu-cEditionDES_VFV").disabled = !b;
		document.getElementById("ofu-cEditionDES_VRE").disabled = !b;
		document.getElementById("ofu-cEditionDES_VCR").disabled = !b;
		document.getElementById("ofu-cEditionDES_VHP").disabled = !b;
		document.getElementById("ofu-cEditionDES_AJA").disabled = !b;
		document.getElementById("ofu-cEditionDES_AAC").disabled = !b;
		document.getElementById("ofu-cEditionDES_AAA").disabled = !b;
		document.getElementById("ofu-cEditionDES_AEF").disabled = !b;
		document.getElementById("ofu-cEditionDES_ARF").disabled = !b;
		document.getElementById("ofu-cEditionDES_ASF").disabled = !b;
		document.getElementById("ofu-cEditionDES_ASD").disabled = !b;
		document.getElementById("ofu-bSCoche").disabled = !b;
		document.getElementById("ofu-bSDecoche").disabled = !b;

		// Accs menus module flash
		document.getElementById("ofu-cMWM_ExpMonoBL").disabled = !b;
		document.getElementById("ofu-cMWM_ExpMultiBL").disabled = !b;
		document.getElementById("ofu-cMWM_CdeClient").disabled = !b;
		document.getElementById("ofu-cMWM_PrepExpedition").disabled = !b;
		document.getElementById("ofu-cMWM_InfoArticle").disabled = !b;
		document.getElementById("ofu-cMWM_Inventaire").disabled = !b;
		document.getElementById("ofu-cMWM_Inv_Show_SI").disabled = !b;
		document.getElementById("ofu-cMWM_Reception").disabled = !b;
		document.getElementById("ofu-cMWM_Rangement").disabled = !b;
		document.getElementById("ofu-cMWM_LocCrossDock").disabled = !b;
		document.getElementById("ofu-cMWM_ExpCrossDock").disabled = !b;
		document.getElementById("ofu-cMWM_EntSortStk").disabled = !b;
		document.getElementById("ofu-cMWM_ChangeEmp").disabled = !b;
		document.getElementById("ofu-cMWM_TransEmp").disabled = !b;
		document.getElementById("ofu-cMWM_ConsultEmp").disabled = !b;
		document.getElementById("ofu-cMWM_RecepRetCli").disabled = !b;
		document.getElementById("ofu-cMWM_Picking").disabled = !b;
		document.getElementById("ofu-cMWM_Controle_Picking").disabled = !b;
		document.getElementById("ofu-cMWM_PrepExpress").disabled = !b;
		document.getElementById("ofu-cMWM_Controle").disabled = !b;
		document.getElementById("ofu-cMWM_Impression").disabled = !b;
		document.getElementById("ofu-cMWM_Localisation").disabled = !b;
		document.getElementById("ofu-cMWM_PEX_Quantite").disabled = !b;
		document.getElementById("ofu-cMWM_PEX_Qte_Manquante").disabled = !b;
		document.getElementById("ofu-cMWM_Scan_Borne").disabled = !b;
		document.getElementById("ofu-cMWM_Info_Art_Chg_Emp").disabled = !b;
		document.getElementById("ofu-bMWMCoche").disabled = !b;
		document.getElementById("ofu-bMWMDecoche").disabled = !b;

		// Droits fournisseurs
		document.getElementById("ofu-bDFCoche").disabled = !b;
		document.getElementById("ofu-bDFDecoche").disabled = !b;

		// Droits provenances
		document.getElementById("ofu-bDPCoche").disabled = !b;
		document.getElementById("ofu-bDPDecoche").disabled = !b;
		document.getElementById("ofu-bDCCoche").disabled = !b;
		document.getElementById("ofu-bDCDecoche").disabled = !b;
		document.getElementById("ofu-provenanceHL").disabled = !b;
		document.getElementById("ofu-catalogueComplet").disabled = !b;

		// Droits indicateurs
		document.getElementById("ofu-bDICoche").disabled = !b;
		document.getElementById("ofu-bDIDecoche").disabled = !b;

		document.getElementById("ofu-cMaxValidationDC").disabled = !document.getElementById("ofu-cValidationDC").checked;
		document.getElementById("ofu-cModifElemFinFCA").disabled = !document.getElementById("ofu-cModifElemFinDV").checked;

	} catch (e) {
		recup_erreur(e);
	}
}


function ofu_chargerDroitsDossier() {
	try {

		var qLoad = new QueryHttp("Utilisateurs/Utilisateurs/loadRightsOnDossier.tmpl");
		qLoad.setParam("Utilisateur_Id", ofu_utilisateurId);
		qLoad.setParam("Dossier_Id", ofu_curDossierId);

		var result = qLoad.execute();
		var contenu = result.responseXML.documentElement;

		document.getElementById("ofu-rowPoleActivite").collapsed = (contenu.getAttribute("Spec_TK_PA")=="false" && document.getElementById("ofu-rowRestricAccCDVPA").collapsed);

		ofu_specLHELE = contenu.getAttribute("Spec_LH_ELE")=="true";
		ofu_actReassortCC = contenu.getAttribute("Act_Reassort_CC")=="true";
		ofu_specSMEAR = contenu.getAttribute("Spec_SM_EAR")=="true";
		ofu_actCodeStats = contenu.getAttribute("Act_Code_Stats")=="true";
		ofu_specEDEFV = contenu.getAttribute("Spec_ED_EFV")=="true";
		ofu_specREERC = contenu.getAttribute("Spec_RE_ERC")=="true";
		ofu_specLMECR = contenu.getAttribute("Spec_LM_ECR")=="true";
		ofu_specKEESK = contenu.getAttribute("Spec_KE_ESK")=="true";
		ofu_specLHFNP = contenu.getAttribute("Spec_LH_FNP")=="true";
		ofu_specHMDNP = contenu.getAttribute("Spec_HM_DNP")=="true";
		ofu_gacCoutTrans = contenu.getAttribute("GAC_Cout_Trans")=="true";

		document.getElementById('ofu-cEditionDES_VLE').collapsed = !ofu_specLHELE;
		document.getElementById('ofu-cEditionDES_VRC').collapsed = !ofu_actReassortCC;
		document.getElementById('ofu-cEditionDES_VAR').collapsed = !ofu_specSMEAR;
		document.getElementById('ofu-cEditionDES_VCS').collapsed = !ofu_actCodeStats;
		document.getElementById('ofu-cEditionDES_VFV').collapsed = !ofu_specEDEFV;
		document.getElementById('ofu-cEditionDES_VRE').collapsed = !ofu_specREERC;
		document.getElementById('ofu-cEditionDES_VCR').collapsed = !ofu_specLMECR;
		document.getElementById('ofu-cEditionDES_VHP').collapsed = !ofu_specKEESK;
		document.getElementById('ofu-cEditionDES_ASF').collapsed = !ofu_specLHFNP;
		document.getElementById('ofu-cEditionDES_ASD').collapsed = !ofu_specHMDNP;
		document.getElementById('ofu-cEditionDES_VCT').collapsed = !ofu_gacCoutTrans;

		// Droits gnraux
		document.getElementById("ofu-cGestionCo").checked = contenu.getAttribute("Acc_Gest_Com")=="true";
		document.getElementById("ofu-cCompta").checked = contenu.getAttribute("Acc_Compta")=="true";
		document.getElementById("ofu-cContact").checked = contenu.getAttribute("Acc_CRM")=="true";
		document.getElementById("ofu-cTransac").checked = contenu.getAttribute("Acc_TB")=="true";
		document.getElementById("ofu-cConfig").checked = contenu.getAttribute("Acc_Config")=="true";
		document.getElementById("ofu-cFlash").checked = contenu.getAttribute("Acc_MWM")=="true";
		document.getElementById("ofu-cAccBAM").checked = contenu.getAttribute("Acc_BAM")=="true";
		document.getElementById("ofu-cDirection").checked = contenu.getAttribute("Direction")=="true";
		document.getElementById("ofu-cValidationCF").checked = contenu.getAttribute("Validation_CF")=="true";
		document.getElementById("ofu-cValidationCC").checked = contenu.getAttribute("Validation_CC")=="true";
		document.getElementById("ofu-cValidationCCZero").checked = contenu.getAttribute("Validation_CC_Zero")=="true";
		document.getElementById("ofu-cAnnulationCC").checked = contenu.getAttribute("Annulation_CC")=="true";
		document.getElementById("ofu-cValidationTS").checked = contenu.getAttribute("Validation_TS")=="true";
		document.getElementById("ofu-cValidationIS").checked = contenu.getAttribute("Validation_IS")=="true";
		document.getElementById("ofu-cValidationRG").checked = contenu.getAttribute("Validation_RG")=="true";
		document.getElementById("ofu-cValidationBR").checked = contenu.getAttribute("Validation_BR")=="true";
		document.getElementById("ofu-cValidationAF").checked = contenu.getAttribute("Validation_AF")=="true";
		document.getElementById("ofu-cValidationAC").checked = contenu.getAttribute("Validation_AC")=="true";
		document.getElementById("ofu-cValidationBP").checked = contenu.getAttribute("Validation_BP")=="true";
		document.getElementById("ofu-cAnnulationBP").checked = contenu.getAttribute("Annulation_BP")=="true";
		document.getElementById("ofu-cValidationBL").checked = contenu.getAttribute("Validation_BL")=="true";
		document.getElementById("ofu-cAnnulationBL").checked = contenu.getAttribute("Annulation_BL")=="true";
		document.getElementById("ofu-cValidationDC").checked = contenu.getAttribute("Validation_DC")=="true";
		document.getElementById("ofu-cMaxValidationDC").value = contenu.getAttribute("Max_Validation_DC");
		document.getElementById("ofu-cClotureFact").checked = contenu.getAttribute("Cloture_Fact")=="true";
		document.getElementById("ofu-cModifElemFinDV").checked = contenu.getAttribute("Modif_Elem_Fin_DV")=="true";
		document.getElementById("ofu-cModifElemFinFCA").checked = contenu.getAttribute("Modif_Elem_Fin_FCA")=="true";
		document.getElementById("ofu-cIgnorePVPlancher").checked = contenu.getAttribute("Ignore_PV_Plancher")=="true";
		document.getElementById("ofu-cEditionListeDL").checked = contenu.getAttribute("Edition_Liste_DL")=="true";
		document.getElementById("ofu-cEditionListeDA").checked = contenu.getAttribute("Edition_Liste_DA")=="true";
		document.getElementById("ofu-cEditionListeDV").checked = contenu.getAttribute("Edition_Liste_DV")=="true";
		document.getElementById("ofu-cShowTotauxDV").checked = contenu.getAttribute("Show_Totaux_DV")=="true";
		document.getElementById("ofu-cAccesCoutAchat").checked = contenu.getAttribute("Acces_Cout_Achat")=="true";
		document.getElementById("ofu-cAccesBanqueCli").checked = contenu.getAttribute("Acces_Banque_Cli")=="true";
		document.getElementById("ofu-cAccesBanqueFou").checked = contenu.getAttribute("Acces_Banque_Fou")=="true";
		document.getElementById("ofu-cRestricAccCDVPA").checked = contenu.getAttribute("Restric_Acc_CDV_PA")=="true";
		document.getElementById("ofu-cGestionDevisType").checked = contenu.getAttribute("Gestion_Devis_Type")=="true";
		document.getElementById("ofu-cShowElemFour").checked = contenu.getAttribute("Show_Elem_Four")=="true";
		document.getElementById("ofu-cGestionRespVente").checked = contenu.getAttribute("Gestion_Resp_Vente")=="true";
		document.getElementById("ofu-cGestionEtabVente").checked = contenu.getAttribute("Gestion_Etab_Vente")=="true";
		document.getElementById("ofu-cGestionPoleVente").checked = contenu.getAttribute("Gestion_Pole_Vente")=="true";
		document.getElementById("ofu-cGestionIntiVente").checked = contenu.getAttribute("Gestion_Inti_Vente")=="true";
		document.getElementById("ofu-cGestionBloqueCli").checked = contenu.getAttribute("Gestion_Bloque_Cli")=="true";
		document.getElementById("ofu-cModifStockES").checked = contenu.getAttribute("Modif_Stock_ES")=="true";
		document.getElementById("ofu-cModifPrixFA").checked = contenu.getAttribute("Modif_Prix_FA")=="true";
		document.getElementById("ofu-cModifPADV").checked = contenu.getAttribute("Modif_PA_DV")=="true";
		document.getElementById("ofu-cAnonymisationFC").checked = contenu.getAttribute("Anonymisation_FC")=="true";
		document.getElementById("ofu-cGCBrightColor").checked = contenu.getAttribute("GC_Bright_Color")=="true";
		ofu_chargerEtablissements(contenu.getAttribute("Etab_Id"));

		ofu_chargerBornes(contenu.getAttribute("Borne_Id"));
		ofu_chargerPoles(contenu.getAttribute("Pole_Activite"));

		ofu_aDroitsDepots.setParam("Dossier_Id", ofu_curDossierId);
		ofu_aDroitsDepots.initTree();
		ofu_aDroitsEtabs.setParam("Dossier_Id", ofu_curDossierId);
		ofu_aDroitsEtabs.initTree();
		ofu_aDroitsProvs.setParam("Dossier_Id", ofu_curDossierId);
		ofu_aDroitsProvs.initTree();
		ofu_aDroitsCats.setParam("Dossier_Id", ofu_curDossierId);
		ofu_aDroitsCats.initTree();
		ofu_aDroitsIndics.setParam("Dossier_Id", ofu_curDossierId);
		ofu_aDroitsIndics.initTree(ofu_compterIndicateurs);

		if (ofu_specTNDAF) {
			ofu_aDroitsFours.setParam("Dossier_Id", ofu_curDossierId);
			ofu_aDroitsFours.initTree();
		}

		// Accs menus gestion commerciale
		document.getElementById("ofu-cGC_TClients").checked = contenu.getAttribute("MenuGC_TClients")=="true";
		document.getElementById("ofu-cReadOnlyGC_TClients").checked = contenu.getAttribute("ReadOnlyGC_TClients")=="true";
		document.getElementById("ofu-cGC_VDevis").checked = contenu.getAttribute("MenuGC_VDevis")=="true";
		document.getElementById("ofu-cGC_ACommandes").checked = contenu.getAttribute("MenuGC_ACommandes")=="true";
		document.getElementById("ofu-cGC_SArticles").checked = contenu.getAttribute("MenuGC_SArticles")=="true";
		document.getElementById("ofu-cReadOnlyGC_SArticles").checked = contenu.getAttribute("ReadOnlyGC_SArticles")=="true";
		document.getElementById("ofu-cGC_DRegFour").checked = contenu.getAttribute("MenuGC_DRegFour")=="true";
		document.getElementById("ofu-cGC_TFournisseurs").checked = contenu.getAttribute("MenuGC_TFournisseurs")=="true";
		document.getElementById("ofu-cGC_VAffaires").checked = contenu.getAttribute("MenuGC_VAffaires")=="true";
		document.getElementById("ofu-cReadOnlyGC_VDevis").checked = contenu.getAttribute("ReadOnlyGC_VDevis")=="true";
		document.getElementById("ofu-cReadOnlyGC_VAffaires").checked = contenu.getAttribute("ReadOnlyGC_VAffaires")=="true";
		document.getElementById("ofu-cGC_APrepaCom").checked = contenu.getAttribute("MenuGC_APrepaCom")=="true";
		document.getElementById("ofu-cGC_STarifs").checked = contenu.getAttribute("MenuGC_STarifs")=="true";
		document.getElementById("ofu-cGC_DRegCli").checked = contenu.getAttribute("MenuGC_DRegCli")=="true";
		document.getElementById("ofu-cReadOnlyGC_DRegCli").checked = contenu.getAttribute("ReadOnlyGC_DRegCli")=="true";
		document.getElementById("ofu-cGC_TCommerciaux").checked = contenu.getAttribute("MenuGC_TCommerciaux")=="true";
		document.getElementById("ofu-cGC_ARecepCom").checked = contenu.getAttribute("MenuGC_ARecepCom")=="true";
		document.getElementById("ofu-cGC_SFabrication").checked = contenu.getAttribute("MenuGC_SFabrication")=="true";
		document.getElementById("ofu-cGC_DRemises").checked = contenu.getAttribute("MenuGC_DRemises")=="true";
		document.getElementById("ofu-cGC_ARetours").checked = contenu.getAttribute("MenuGC_ARetours")=="true";
		document.getElementById("ofu-cGC_SInventaire").checked = contenu.getAttribute("MenuGC_SInventaire")=="true";
		document.getElementById("ofu-cGC_DEditions").checked = contenu.getAttribute("MenuGC_DEditions")=="true";
		document.getElementById("ofu-cGC_AFactures").checked = contenu.getAttribute("MenuGC_AFactures")=="true";
		document.getElementById("ofu-cGC_AControle").checked = contenu.getAttribute("MenuGC_AControle")=="true";
		document.getElementById("ofu-cGC_STracabilite").checked = contenu.getAttribute("MenuGC_STracabilite")=="true";
		document.getElementById("ofu-cGC_DTabBord").checked = contenu.getAttribute("MenuGC_DTabBord")=="true";
		document.getElementById("ofu-cGC_VRetours").checked = contenu.getAttribute("MenuGC_VRetours")=="true";
		document.getElementById("ofu-cGC_VFactures").checked = contenu.getAttribute("MenuGC_VFactures")=="true";
		document.getElementById("ofu-cGC_STransferts").checked = contenu.getAttribute("MenuGC_STransferts")=="true";
		document.getElementById("ofu-cGC_DTransCpta").checked = contenu.getAttribute("MenuGC_DTransCpta")=="true";
		document.getElementById("ofu-cGC_VFactuAuto").checked = contenu.getAttribute("MenuGC_VFactuAuto")=="true";
		document.getElementById("ofu-cGC_SMouvements").checked = contenu.getAttribute("MenuGC_SMouvements")=="true";
		document.getElementById("ofu-cGC_SEmplacements").checked = contenu.getAttribute("MenuGC_SEmplacements")=="true";
		document.getElementById("ofu-cGC_STransEmp").checked = contenu.getAttribute("MenuGC_STransEmp")=="true";
		document.getElementById("ofu-cGC_SIOStocks").checked = contenu.getAttribute("MenuGC_SIOStocks")=="true";
		document.getElementById("ofu-cReadOnlyGC_SIOStocks").checked = contenu.getAttribute("ReadOnlyGC_SIOStocks")=="true";
		document.getElementById("ofu-cGC_SParamStocks").checked = contenu.getAttribute("MenuGC_SParamStocks")=="true";
		document.getElementById("ofu-cGC_DExportIdep").checked = contenu.getAttribute("MenuGC_DExportIdep")=="true";
		document.getElementById("ofu-cGC_DDeclEcoPart").checked = contenu.getAttribute("MenuGC_DDeclEcoPart")=="true";
		document.getElementById("ofu-cGC_VEnvoiFact").checked = contenu.getAttribute("MenuGC_VEnvoiFact")=="true";
		document.getElementById("ofu-cGC_DImpExpCsv").checked = contenu.getAttribute("MenuGC_DImpExpCsv")=="true";
		document.getElementById("ofu-cGC_VAbonnements").checked = contenu.getAttribute("MenuGC_VAbonnements")=="true";
		document.getElementById("ofu-cGC_DPassword").checked = contenu.getAttribute("MenuGC_DPassword")=="true";
		document.getElementById("ofu-cGC_EExpesCC").checked = contenu.getAttribute("MenuGC_EExpesCC")=="true";
		document.getElementById("ofu-cGC_EExpesTS").checked = contenu.getAttribute("MenuGC_EExpesTS")=="true";
		document.getElementById("ofu-cGC_EPrepaExpes").checked = contenu.getAttribute("MenuGC_EPrepaExpes")=="true";
		document.getElementById("ofu-cGC_EExpCrossDock").checked = contenu.getAttribute("MenuGC_EExpCrossDock")=="true";
		document.getElementById("ofu-cGC_ESuiviLog").checked = contenu.getAttribute("MenuGC_ESuiviLog")=="true";
		document.getElementById("ofu-cGC_ESuiviTrans").checked = contenu.getAttribute("MenuGC_ESuiviTrans")=="true";

		// Accs menus comptabilit
		document.getElementById("ofu-cCG_CSaisie").checked = contenu.getAttribute("MenuCG_CSaisie")=="true";
		document.getElementById("ofu-cCG_EBalance").checked = contenu.getAttribute("MenuCG_EBalance")=="true";
		document.getElementById("ofu-cCG_SBordGest").checked = contenu.getAttribute("MenuCG_SBordGest")=="true";
		document.getElementById("ofu-cCG_AComptes").checked = contenu.getAttribute("MenuCG_AComptes")=="true";
		document.getElementById("ofu-cCG_DComptes").checked = contenu.getAttribute("MenuCG_DComptes")=="true";
		document.getElementById("ofu-cCG_CRevision").checked = contenu.getAttribute("MenuCG_CRevision")=="true";
		document.getElementById("ofu-cCG_ECentral").checked = contenu.getAttribute("MenuCG_ECentral")=="true";
		document.getElementById("ofu-cCG_SBordTres").checked = contenu.getAttribute("MenuCG_SBordTres")=="true";
		document.getElementById("ofu-cCG_AGdLivre").checked = contenu.getAttribute("MenuCG_AGdLivre")=="true";
		document.getElementById("ofu-cCG_DAboEcr").checked = contenu.getAttribute("MenuCG_DAboEcr")=="true";
		document.getElementById("ofu-cCG_CTransCop").checked = contenu.getAttribute("MenuCG_CTransCop")=="true";
		document.getElementById("ofu-cCG_EGdLivre").checked = contenu.getAttribute("MenuCG_EGdLivre")=="true";
		document.getElementById("ofu-cCG_AParametrages").checked = contenu.getAttribute("MenuCG_AParametrages")=="true";
		document.getElementById("ofu-cCG_DModeles").checked = contenu.getAttribute("MenuCG_DModeles")=="true";
		document.getElementById("ofu-cCG_CRappro").checked = contenu.getAttribute("MenuCG_CRappro")=="true";
		document.getElementById("ofu-cCG_EJournaux").checked = contenu.getAttribute("MenuCG_EJournaux")=="true";
		document.getElementById("ofu-cCG_DImpBanque").checked = contenu.getAttribute("MenuCG_DImpBanque")=="true";
		document.getElementById("ofu-cCG_CClotMens").checked = contenu.getAttribute("MenuCG_CClotMens")=="true";
		document.getElementById("ofu-cCG_EBalAgee").checked = contenu.getAttribute("MenuCG_EBalAgee")=="true";
		document.getElementById("ofu-cCG_DImpExpEcr").checked = contenu.getAttribute("MenuCG_DImpExpEcr")=="true";
		document.getElementById("ofu-cCG_CClotExo").checked = contenu.getAttribute("MenuCG_CClotExo")=="true";
		document.getElementById("ofu-cCG_EBilan").checked = contenu.getAttribute("MenuCG_EBilan")=="true";
		document.getElementById("ofu-cCG_DPassword").checked = contenu.getAttribute("MenuCG_DPassword")=="true";
		document.getElementById("ofu-cCG_EResultat").checked = contenu.getAttribute("MenuCG_EResultat")=="true";
		document.getElementById("ofu-cCG_ESoldes").checked = contenu.getAttribute("MenuCG_ESoldes")=="true";
		document.getElementById("ofu-cCG_EPlanCpte").checked = contenu.getAttribute("MenuCG_EPlanCpte")=="true";

		// Accs statistiques
		document.getElementById("ofu-cEditionDES_CPC").checked = contenu.getAttribute("Edition_DES_CPC")=="true";
		document.getElementById("ofu-cEditionDES_CLC").checked = contenu.getAttribute("Edition_DES_CLC")=="true";
		document.getElementById("ofu-cEditionDES_FPF").checked = contenu.getAttribute("Edition_DES_FPF")=="true";
		document.getElementById("ofu-cEditionDES_FLF").checked = contenu.getAttribute("Edition_DES_FLF")=="true";
		document.getElementById("ofu-cEditionDES_SPA").checked = contenu.getAttribute("Edition_DES_SPA")=="true";
		document.getElementById("ofu-cEditionDES_SFA").checked = contenu.getAttribute("Edition_DES_SFA")=="true";
		document.getElementById("ofu-cEditionDES_SMS").checked = contenu.getAttribute("Edition_DES_SMS")=="true";
		document.getElementById("ofu-cEditionDES_SES").checked = contenu.getAttribute("Edition_DES_SES")=="true";
		document.getElementById("ofu-cEditionDES_SRS").checked = contenu.getAttribute("Edition_DES_SRS")=="true";
		document.getElementById("ofu-cEditionDES_SPF").checked = contenu.getAttribute("Edition_DES_SPF")=="true";
		document.getElementById("ofu-cEditionDES_SMA").checked = contenu.getAttribute("Edition_DES_SMA")=="true";
		document.getElementById("ofu-cEditionDES_VJV").checked = contenu.getAttribute("Edition_DES_VJV")=="true";
		document.getElementById("ofu-cEditionDES_VJA").checked = contenu.getAttribute("Edition_DES_VJA")=="true";
		document.getElementById("ofu-cEditionDES_VVA").checked = contenu.getAttribute("Edition_DES_VVA")=="true";
		document.getElementById("ofu-cEditionDES_VFA").checked = contenu.getAttribute("Edition_DES_VFA")=="true";
		document.getElementById("ofu-cEditionDES_VFC").checked = contenu.getAttribute("Edition_DES_VFC")=="true";
		document.getElementById("ofu-cEditionDES_VFD").checked = contenu.getAttribute("Edition_DES_VFD")=="true";
		document.getElementById("ofu-cEditionDES_VSC").checked = contenu.getAttribute("Edition_DES_VSC")=="true";
		document.getElementById("ofu-cEditionDES_VLE").checked = contenu.getAttribute("Edition_DES_VLE")=="true";
		document.getElementById("ofu-cEditionDES_VLC").checked = contenu.getAttribute("Edition_DES_VLC")=="true";
		document.getElementById("ofu-cEditionDES_VEC").checked = contenu.getAttribute("Edition_DES_VEC")=="true";
		document.getElementById("ofu-cEditionDES_VCT").checked = contenu.getAttribute("Edition_DES_VCT")=="true";
		document.getElementById("ofu-cEditionDES_VRC").checked = contenu.getAttribute("Edition_DES_VRC")=="true";
		document.getElementById("ofu-cEditionDES_VAR").checked = contenu.getAttribute("Edition_DES_VAR")=="true";
		document.getElementById("ofu-cEditionDES_VCS").checked = contenu.getAttribute("Edition_DES_VCS")=="true";
		document.getElementById("ofu-cEditionDES_VFV").checked = contenu.getAttribute("Edition_DES_VFV")=="true";
		document.getElementById("ofu-cEditionDES_VRE").checked = contenu.getAttribute("Edition_DES_VRE")=="true";
		document.getElementById("ofu-cEditionDES_VCR").checked = contenu.getAttribute("Edition_DES_VCR")=="true";
		document.getElementById("ofu-cEditionDES_VHP").checked = contenu.getAttribute("Edition_DES_VHP")=="true";
		document.getElementById("ofu-cEditionDES_AJA").checked = contenu.getAttribute("Edition_DES_AJA")=="true";
		document.getElementById("ofu-cEditionDES_AAC").checked = contenu.getAttribute("Edition_DES_AAC")=="true";
		document.getElementById("ofu-cEditionDES_AAA").checked = contenu.getAttribute("Edition_DES_AAA")=="true";
		document.getElementById("ofu-cEditionDES_AEF").checked = contenu.getAttribute("Edition_DES_AEF")=="true";
		document.getElementById("ofu-cEditionDES_ARF").checked = contenu.getAttribute("Edition_DES_ARF")=="true";
		document.getElementById("ofu-cEditionDES_ASF").checked = contenu.getAttribute("Edition_DES_ASF")=="true";
		document.getElementById("ofu-cEditionDES_ASD").checked = contenu.getAttribute("Edition_DES_ASD")=="true";

		// Accs menus module flash
		document.getElementById("ofu-cMWM_ExpMonoBL").checked = contenu.getAttribute("MenuMWM_ExpMonoBL")=="true";
		document.getElementById("ofu-cMWM_ExpMultiBL").checked = contenu.getAttribute("MenuMWM_ExpMultiBL")=="true";
		document.getElementById("ofu-cMWM_CdeClient").checked = contenu.getAttribute("MenuMWM_CdeClient")=="true";
		document.getElementById("ofu-cMWM_PrepExpedition").checked = contenu.getAttribute("MenuMWM_PrepExpedition")=="true";
		document.getElementById("ofu-cMWM_InfoArticle").checked = contenu.getAttribute("MenuMWM_InfoArticle")=="true";
		document.getElementById("ofu-cMWM_Inventaire").checked = contenu.getAttribute("MenuMWM_Inventaire")=="true";
		document.getElementById("ofu-cMWM_Inv_Show_SI").checked = contenu.getAttribute("MWM_Inv_Show_SI")=="true";
		document.getElementById("ofu-cMWM_Reception").checked = contenu.getAttribute("MenuMWM_Reception")=="true";
		document.getElementById("ofu-cMWM_Rangement").checked = contenu.getAttribute("MenuMWM_Rangement")=="true";
		document.getElementById("ofu-cMWM_LocCrossDock").checked = contenu.getAttribute("MenuMWM_LocCrossDock")=="true";
		document.getElementById("ofu-cMWM_ExpCrossDock").checked = contenu.getAttribute("MenuMWM_ExpCrossDock")=="true";
		document.getElementById("ofu-cMWM_EntSortStk").checked = contenu.getAttribute("MenuMWM_EntSortStk")=="true";
		document.getElementById("ofu-cMWM_ChangeEmp").checked = contenu.getAttribute("MenuMWM_ChangeEmp")=="true";
		document.getElementById("ofu-cMWM_TransEmp").checked = contenu.getAttribute("MenuMWM_TransEmp")=="true";
		document.getElementById("ofu-cMWM_ConsultEmp").checked = contenu.getAttribute("MenuMWM_ConsultEmp")=="true";
		document.getElementById("ofu-cMWM_RecepRetCli").checked = contenu.getAttribute("MenuMWM_RecepRetCli")=="true";
		document.getElementById("ofu-cMWM_Picking").checked = contenu.getAttribute("MenuMWM_Picking")=="true";
		document.getElementById("ofu-cMWM_Controle_Picking").checked = contenu.getAttribute("MWM_Controle_Picking")=="true";
		document.getElementById("ofu-cMWM_PrepExpress").checked = contenu.getAttribute("MenuMWM_PrepExpress")=="true";
		document.getElementById("ofu-cMWM_Controle").checked = contenu.getAttribute("MenuMWM_Controle")=="true";
		document.getElementById("ofu-cMWM_Impression").checked = contenu.getAttribute("MenuMWM_Impression")=="true";
		document.getElementById("ofu-cMWM_Localisation").checked = contenu.getAttribute("MenuMWM_Localisation")=="true";
		document.getElementById("ofu-cMWM_PEX_Quantite").checked = contenu.getAttribute("MWM_PEX_Quantite")=="true";
		document.getElementById("ofu-cMWM_PEX_Qte_Manquante").checked = contenu.getAttribute("MWM_PEX_Qte_Manquante")=="true";
		document.getElementById("ofu-cMWM_Scan_Borne").checked = contenu.getAttribute("MWM_Scan_Borne")=="true";
		document.getElementById("ofu-cMWM_Info_Art_Chg_Emp").checked = contenu.getAttribute("MWM_Info_Art_Chg_Emp")=="true";

		// Droits provenances
		document.getElementById("ofu-provenanceHL").checked = contenu.getAttribute("Provenance_HL")=="true";
		document.getElementById("ofu-catalogueComplet").checked = contenu.getAttribute("Catalogue_Complet")=="true";

		ofu_clickOnCatalogueComplet();

	} catch (e) {
		recup_erreur(e);
	}
}


function ofu_enregistrerDroitsDossier() {
	try {

		// Droits gnraux
		var acc_compta = document.getElementById("ofu-cCompta").checked;
		var acc_contact = document.getElementById("ofu-cContact").checked;
		var acc_transac = document.getElementById("ofu-cTransac").checked;
		var acc_gest_com = document.getElementById("ofu-cGestionCo").checked;
		var acc_config = document.getElementById("ofu-cConfig").checked;
		var acc_flash = document.getElementById("ofu-cFlash").checked;
		var accBAM = document.getElementById("ofu-cAccBAM").checked;
		var direction = document.getElementById("ofu-cDirection").checked;
		var validationCF = document.getElementById("ofu-cValidationCF").checked;
		var validationCC = document.getElementById("ofu-cValidationCC").checked;
		var validationCCZero = document.getElementById("ofu-cValidationCCZero").checked;
		var annulationCC = document.getElementById("ofu-cAnnulationCC").checked;
		var validationTS = document.getElementById("ofu-cValidationTS").checked;
		var validationIS = document.getElementById("ofu-cValidationIS").checked;
		var validationRG = document.getElementById("ofu-cValidationRG").checked;
		var validationBR = document.getElementById("ofu-cValidationBR").checked;
		var validationAF = document.getElementById("ofu-cValidationAF").checked;
		var validationAC = document.getElementById("ofu-cValidationAC").checked;
		var validationBP = document.getElementById("ofu-cValidationBP").checked;
		var annulationBP = document.getElementById("ofu-cAnnulationBP").checked;
		var validationBL = document.getElementById("ofu-cValidationBL").checked;
		var annulationBL = document.getElementById("ofu-cAnnulationBL").checked;
		var validationDC = document.getElementById("ofu-cValidationDC").checked;
		var maxValidationDC = (validationDC?document.getElementById("ofu-cMaxValidationDC").value:"");
		var clotureFact = document.getElementById("ofu-cClotureFact").checked;
		var modifElemFinDV = document.getElementById("ofu-cModifElemFinDV").checked;
		var modifElemFinFCA = document.getElementById("ofu-cModifElemFinFCA").checked;
		var ignorePVPlancher = document.getElementById("ofu-cIgnorePVPlancher").checked;
		var editionListeDL = document.getElementById("ofu-cEditionListeDL").checked;
		var editionListeDA = document.getElementById("ofu-cEditionListeDA").checked;
		var editionListeDV = document.getElementById("ofu-cEditionListeDV").checked;
		var showTotauxDV = document.getElementById("ofu-cShowTotauxDV").checked;
		var accesCoutAchat = document.getElementById("ofu-cAccesCoutAchat").checked;
		var accesBanqueCli = document.getElementById("ofu-cAccesBanqueCli").checked;
		var accesBanqueFou = document.getElementById("ofu-cAccesBanqueFou").checked;
		var restricAccCDVPA = document.getElementById("ofu-cRestricAccCDVPA").checked;
		var gestionDevisType = document.getElementById("ofu-cGestionDevisType").checked;
		var showElemFour = document.getElementById("ofu-cShowElemFour").checked;
		var gestionRespVente = document.getElementById("ofu-cGestionRespVente").checked;
		var gestionEtabVente = document.getElementById("ofu-cGestionEtabVente").checked;
		var gestionPoleVente = document.getElementById("ofu-cGestionPoleVente").checked;
		var gestionIntiVente = document.getElementById("ofu-cGestionIntiVente").checked;
		var gestionBloqueCli = document.getElementById("ofu-cGestionBloqueCli").checked;
		var modifStockES = document.getElementById("ofu-cModifStockES").checked;
		var modifPrixFA = document.getElementById("ofu-cModifPrixFA").checked;
		var modifPADV = document.getElementById("ofu-cModifPADV").checked;
		var anonymisationFC = document.getElementById("ofu-cAnonymisationFC").checked;
		var gcBrightColor = document.getElementById("ofu-cGCBrightColor").checked;
		var etabId = document.getElementById("ofu-etablissementRattachement").value;
		var borneId = document.getElementById("ofu-borneImpression").value;
		var poleActivite = document.getElementById("ofu-poleActivite").value;

		// Accs menus gestion commerciale
		var MenuGC_TClients = document.getElementById("ofu-cGC_TClients").checked;
		var ReadOnlyGC_TClients = document.getElementById("ofu-cReadOnlyGC_TClients").checked;
		var MenuGC_TFournisseurs = document.getElementById("ofu-cGC_TFournisseurs").checked;
		var MenuGC_TCommerciaux = document.getElementById("ofu-cGC_TCommerciaux").checked;
		var MenuGC_VDevis = document.getElementById("ofu-cGC_VDevis").checked;
		var MenuGC_VAffaires = document.getElementById("ofu-cGC_VAffaires").checked;
		var ReadOnlyGC_VDevis = document.getElementById("ofu-cReadOnlyGC_VDevis").checked;
		var ReadOnlyGC_VAffaires = document.getElementById("ofu-cReadOnlyGC_VAffaires").checked;
		var MenuGC_VRetours = document.getElementById("ofu-cGC_VRetours").checked;
		var MenuGC_VFactures = document.getElementById("ofu-cGC_VFactures").checked;
		var MenuGC_VFactuAuto = document.getElementById("ofu-cGC_VFactuAuto").checked;
		var MenuGC_VEnvoiFact = document.getElementById("ofu-cGC_VEnvoiFact").checked;
		var MenuGC_VAbonnements = document.getElementById("ofu-cGC_VAbonnements").checked;
		var MenuGC_EExpesCC = document.getElementById("ofu-cGC_EExpesCC").checked;
		var MenuGC_EExpesTS = document.getElementById("ofu-cGC_EExpesTS").checked;
		var MenuGC_EPrepaExpes = document.getElementById("ofu-cGC_EPrepaExpes").checked;
		var MenuGC_EExpCrossDock = document.getElementById("ofu-cGC_EExpCrossDock").checked;
		var MenuGC_ESuiviLog = document.getElementById("ofu-cGC_ESuiviLog").checked;
		var MenuGC_ESuiviTrans = document.getElementById("ofu-cGC_ESuiviTrans").checked;
		var MenuGC_ACommandes = document.getElementById("ofu-cGC_ACommandes").checked;
		var MenuGC_APrepaCom = document.getElementById("ofu-cGC_APrepaCom").checked;
		var MenuGC_ARecepCom = document.getElementById("ofu-cGC_ARecepCom").checked;
		var MenuGC_ARetours = document.getElementById("ofu-cGC_ARetours").checked;
		var MenuGC_AFactures = document.getElementById("ofu-cGC_AFactures").checked;
		var MenuGC_AControle = document.getElementById("ofu-cGC_AControle").checked;
		var MenuGC_SArticles = document.getElementById("ofu-cGC_SArticles").checked;
		var ReadOnlyGC_SArticles = document.getElementById("ofu-cReadOnlyGC_SArticles").checked;
		var MenuGC_STarifs = document.getElementById("ofu-cGC_STarifs").checked;
		var MenuGC_SFabrication = document.getElementById("ofu-cGC_SFabrication").checked;
		var MenuGC_SInventaire = document.getElementById("ofu-cGC_SInventaire").checked;
		var MenuGC_STracabilite = document.getElementById("ofu-cGC_STracabilite").checked;
		var MenuGC_STransferts = document.getElementById("ofu-cGC_STransferts").checked;
		var MenuGC_SMouvements = document.getElementById("ofu-cGC_SMouvements").checked;
		var MenuGC_SEmplacements = document.getElementById("ofu-cGC_SEmplacements").checked;
		var MenuGC_STransEmp = document.getElementById("ofu-cGC_STransEmp").checked;
		var MenuGC_SIOStocks = document.getElementById("ofu-cGC_SIOStocks").checked;
		var ReadOnlyGC_SIOStocks = document.getElementById("ofu-cReadOnlyGC_SIOStocks").checked;
		var MenuGC_SParamStocks = document.getElementById("ofu-cGC_SParamStocks").checked;
		var MenuGC_DRegFour =  document.getElementById("ofu-cGC_DRegFour").checked;
		var MenuGC_DRegCli = document.getElementById("ofu-cGC_DRegCli").checked;
		var ReadOnlyGC_DRegCli = document.getElementById("ofu-cReadOnlyGC_DRegCli").checked;
		var MenuGC_DRemises = document.getElementById("ofu-cGC_DRemises").checked;
		var MenuGC_DEditions = document.getElementById("ofu-cGC_DEditions").checked;
		var MenuGC_DTabBord = document.getElementById("ofu-cGC_DTabBord").checked;
		var MenuGC_DTransCpta = document.getElementById("ofu-cGC_DTransCpta").checked;
		var MenuGC_DExportIdep = document.getElementById("ofu-cGC_DExportIdep").checked;
		var MenuGC_DDeclEcoPart = document.getElementById("ofu-cGC_DDeclEcoPart").checked;
		var MenuGC_DImpExpCsv = document.getElementById("ofu-cGC_DImpExpCsv").checked;
		var MenuGC_DPassword = document.getElementById("ofu-cGC_DPassword").checked;

		// Accs menus comptabilit
		var MenuCG_CSaisie = document.getElementById("ofu-cCG_CSaisie").checked;
		var MenuCG_CRevision = document.getElementById("ofu-cCG_CRevision").checked;
		var MenuCG_CTransCop = document.getElementById("ofu-cCG_CTransCop").checked;
		var MenuCG_CRappro = document.getElementById("ofu-cCG_CRappro").checked;
		var MenuCG_CClotMens = document.getElementById("ofu-cCG_CClotMens").checked;
		var MenuCG_CClotExo = document.getElementById("ofu-cCG_CClotExo").checked;
		var MenuCG_EBalance = document.getElementById("ofu-cCG_EBalance").checked;
		var MenuCG_ECentral = document.getElementById("ofu-cCG_ECentral").checked;
		var MenuCG_EGdLivre = document.getElementById("ofu-cCG_EGdLivre").checked;
		var MenuCG_EJournaux = document.getElementById("ofu-cCG_EJournaux").checked;
		var MenuCG_EBalAgee = document.getElementById("ofu-cCG_EBalAgee").checked;
		var MenuCG_EBilan = document.getElementById("ofu-cCG_EBilan").checked;
		var MenuCG_EResultat = document.getElementById("ofu-cCG_EResultat").checked;
		var MenuCG_ESoldes = document.getElementById("ofu-cCG_ESoldes").checked;
		var MenuCG_EPlanCpte = document.getElementById("ofu-cCG_EPlanCpte").checked;
		var MenuCG_SBordGest = document.getElementById("ofu-cCG_SBordGest").checked;
		var MenuCG_SBordTres = document.getElementById("ofu-cCG_SBordTres").checked;
		var MenuCG_AComptes = document.getElementById("ofu-cCG_AComptes").checked;
		var MenuCG_AGdLivre = document.getElementById("ofu-cCG_AGdLivre").checked;
		var MenuCG_AParametrages = document.getElementById("ofu-cCG_AParametrages").checked;
		var MenuCG_DComptes = document.getElementById("ofu-cCG_DComptes").checked;
		var MenuCG_DAboEcr = document.getElementById("ofu-cCG_DAboEcr").checked;
		var MenuCG_DModeles = document.getElementById("ofu-cCG_DModeles").checked;
		var MenuCG_DImpBanque = document.getElementById("ofu-cCG_DImpBanque").checked;
		var MenuCG_DImpExpEcr = document.getElementById("ofu-cCG_DImpExpEcr").checked;
		var MenuCG_DPassword = document.getElementById("ofu-cCG_DPassword").checked;

		// Accs statistiques
		var editionDES_CPC = document.getElementById("ofu-cEditionDES_CPC").checked;
		var editionDES_CLC = document.getElementById("ofu-cEditionDES_CLC").checked;
		var editionDES_FPF = document.getElementById("ofu-cEditionDES_FPF").checked;
		var editionDES_FLF = document.getElementById("ofu-cEditionDES_FLF").checked;
		var editionDES_SPA = document.getElementById("ofu-cEditionDES_SPA").checked;
		var editionDES_SFA = document.getElementById("ofu-cEditionDES_SFA").checked;
		var editionDES_SMS = document.getElementById("ofu-cEditionDES_SMS").checked;
		var editionDES_SES = document.getElementById("ofu-cEditionDES_SES").checked;
		var editionDES_SRS = document.getElementById("ofu-cEditionDES_SRS").checked;
		var editionDES_SPF = document.getElementById("ofu-cEditionDES_SPF").checked;
		var editionDES_SMA = document.getElementById("ofu-cEditionDES_SMA").checked;
		var editionDES_VJV = document.getElementById("ofu-cEditionDES_VJV").checked;
		var editionDES_VJA = document.getElementById("ofu-cEditionDES_VJA").checked;
		var editionDES_VVA = document.getElementById("ofu-cEditionDES_VVA").checked;
		var editionDES_VFA = document.getElementById("ofu-cEditionDES_VFA").checked;
		var editionDES_VFC = document.getElementById("ofu-cEditionDES_VFC").checked;
		var editionDES_VFD = document.getElementById("ofu-cEditionDES_VFD").checked;
		var editionDES_VSC = document.getElementById("ofu-cEditionDES_VSC").checked;
		var editionDES_VLE = document.getElementById("ofu-cEditionDES_VLE").checked;
		var editionDES_VLC = document.getElementById("ofu-cEditionDES_VLC").checked;
		var editionDES_VEC = document.getElementById("ofu-cEditionDES_VEC").checked;
		var editionDES_VCT = document.getElementById("ofu-cEditionDES_VCT").checked;
		var editionDES_VRC = document.getElementById("ofu-cEditionDES_VRC").checked;
		var editionDES_VAR = document.getElementById("ofu-cEditionDES_VAR").checked;
		var editionDES_VCS = document.getElementById("ofu-cEditionDES_VCS").checked;
		var editionDES_VFV = document.getElementById("ofu-cEditionDES_VFV").checked;
		var editionDES_VRE = document.getElementById("ofu-cEditionDES_VRE").checked;
		var editionDES_VCR = document.getElementById("ofu-cEditionDES_VCR").checked;
		var editionDES_VHP = document.getElementById("ofu-cEditionDES_VHP").checked;
		var editionDES_AJA = document.getElementById("ofu-cEditionDES_AJA").checked;
		var editionDES_AAC = document.getElementById("ofu-cEditionDES_AAC").checked;
		var editionDES_AAA = document.getElementById("ofu-cEditionDES_AAA").checked;
		var editionDES_AEF = document.getElementById("ofu-cEditionDES_AEF").checked;
		var editionDES_ARF = document.getElementById("ofu-cEditionDES_ARF").checked;
		var editionDES_ASF = document.getElementById("ofu-cEditionDES_ASF").checked;
		var editionDES_ASD = document.getElementById("ofu-cEditionDES_ASD").checked;

		// Accs menus module flash
		var MenuMWM_ExpMonoBL = document.getElementById("ofu-cMWM_ExpMonoBL").checked;
		var MenuMWM_ExpMultiBL = document.getElementById("ofu-cMWM_ExpMultiBL").checked;
		var MenuMWM_CdeClient = document.getElementById("ofu-cMWM_CdeClient").checked;
		var MenuMWM_PrepExpedition = document.getElementById("ofu-cMWM_PrepExpedition").checked;
		var MenuMWM_InfoArticle = document.getElementById("ofu-cMWM_InfoArticle").checked;
		var MenuMWM_Inventaire = document.getElementById("ofu-cMWM_Inventaire").checked;
		var MWM_Inv_Show_SI = document.getElementById("ofu-cMWM_Inv_Show_SI").checked;
		var MenuMWM_Reception = document.getElementById("ofu-cMWM_Reception").checked;
		var MenuMWM_Rangement = document.getElementById("ofu-cMWM_Rangement").checked;
		var MenuMWM_LocCrossDock = document.getElementById("ofu-cMWM_LocCrossDock").checked;
		var MenuMWM_ExpCrossDock = document.getElementById("ofu-cMWM_ExpCrossDock").checked;
		var MenuMWM_EntSortStk = document.getElementById("ofu-cMWM_EntSortStk").checked;
		var MenuMWM_ChangeEmp = document.getElementById("ofu-cMWM_ChangeEmp").checked;
		var MenuMWM_TransEmp = document.getElementById("ofu-cMWM_TransEmp").checked;
		var MenuMWM_ConsultEmp = document.getElementById("ofu-cMWM_ConsultEmp").checked;
		var MenuMWM_RecepRetCli = document.getElementById("ofu-cMWM_RecepRetCli").checked;
		var MenuMWM_Picking = document.getElementById("ofu-cMWM_Picking").checked;
		var MWM_Controle_Picking = document.getElementById("ofu-cMWM_Controle_Picking").checked;
		var MenuMWM_PrepExpress = document.getElementById("ofu-cMWM_PrepExpress").checked;
		var MenuMWM_Controle = document.getElementById("ofu-cMWM_Controle").checked;
		var MenuMWM_Impression = document.getElementById("ofu-cMWM_Impression").checked;
		var MenuMWM_Localisation = document.getElementById("ofu-cMWM_Localisation").checked;
		var MWM_PEX_Quantite = document.getElementById("ofu-cMWM_PEX_Quantite").checked;
		var MWM_PEX_Qte_Manquante = document.getElementById("ofu-cMWM_PEX_Qte_Manquante").checked;
		var MWM_Scan_Borne = document.getElementById("ofu-cMWM_Scan_Borne").checked;
		var MWM_Info_Art_Chg_Emp = document.getElementById("ofu-cMWM_Info_Art_Chg_Emp").checked;

		// Droits provenances

		var provenanceHL = document.getElementById("ofu-provenanceHL").checked;
		var catalogueComplet = document.getElementById("ofu-catalogueComplet").checked;

		var listeDepots = "";
		for (var i=0; i<ofu_aDroitsDepots.nbLignes(); i++) {
			listeDepots += ofu_aDroitsDepots.getCellText(i, "ofu-colDepot_Id") +",";
  	}

		var listeDD = "";
		for (var i=0; i<ofu_aDroitsDepots.nbLignes(); i++) {
			listeDD += (ofu_aDroitsDepots.getCellValue(i, "ofu-colSelect")=="true") +",";
  	}

		var listeEtabs = "";
		for (var i=0; i<ofu_aDroitsEtabs.nbLignes(); i++) {
			listeEtabs += ofu_aDroitsEtabs.getCellText(i, "ofu-colEtab_Id") +",";
  	}

		var listeDE = "";
		for (var i=0; i<ofu_aDroitsEtabs.nbLignes(); i++) {
			listeDE += (ofu_aDroitsEtabs.getCellValue(i, "ofu-colSelectEtab")=="true") +",";
  	}

		var listeProvs = "";
		var listeDP = "";
		for (var i=0; i<ofu_aDroitsProvs.nbLignes(); i++) {
			listeProvs += ofu_aDroitsProvs.getCellText(i, "ofu-colSiteIdDP") +",";
			listeDP += (ofu_aDroitsProvs.getCellValue(i, "ofu-colSelectDP")=="true") +",";
  	}

		var listeCats = "";
		var listeDC = "";
		for (var i=0; i<ofu_aDroitsCats.nbLignes(); i++) {
			listeCats += ofu_aDroitsCats.getCellText(i, "ofu-colSiteIdDC") +",";
			listeDC += (ofu_aDroitsCats.getCellValue(i, "ofu-colSelectDC")=="true") +",";
  	}

		var nbIndics = parseIntBis(document.getElementById('ofu-nbIndicateurs').value);
		var listeIndics = "";
		var listeDI = "";
		for (var i=0; i<ofu_aDroitsIndics.nbLignes(); i++) {
			listeIndics += ofu_aDroitsIndics.getCellText(i, "ofu-colIndicateurIdDI") +",";
			listeDI += (ofu_aDroitsIndics.getCellValue(i, "ofu-colSelectDI")=="true") +",";
  	}

		var listeFours = "";
		var listeDF = "";
		for (var i=0; i<ofu_aDroitsFours.nbLignes(); i++) {
			listeFours += ofu_aDroitsFours.getCellText(i, "ofu-colFournisseur_Id") +",";
			listeDF += (ofu_aDroitsFours.getCellValue(i, "ofu-colSelectFournisseur")=="true") +",";
  	}

		if (isEmpty(etabId)) { showWarning("Veuillez choisir un \u00E9tablissement de rattachement."); }
		else if (!isEmpty(maxValidationDC) && !isPositiveOrNull(maxValidationDC)) {
			showWarning("Montant maximum de validation d'un devis incorrect");
		}
		else if (nbIndics>10) {
			showWarning("Nombre d'indicateurs coch\u00E9s trop \u00E9lev\u00E9 (10 maximum)");
		}
		else {
			var qUpdate = new QueryHttp("Utilisateurs/Utilisateurs/updateRightsOnDossier.tmpl");
			qUpdate.setParam("Utilisateur_Id", ofu_utilisateurId);
			qUpdate.setParam("Dossier_Id", ofu_curDossierId);

			// Droits gnraux
			qUpdate.setParam("Acc_Compta", acc_compta);
			qUpdate.setParam("Acc_CRM", acc_contact);
			qUpdate.setParam("Acc_Gest_Com", acc_gest_com);
			qUpdate.setParam("Acc_TB", acc_transac);
			qUpdate.setParam("Acc_Config", acc_config);
			qUpdate.setParam("Acc_MWM", acc_flash);
			qUpdate.setParam("Acc_BAM", accBAM);
			qUpdate.setParam("Direction", direction);
			qUpdate.setParam("Validation_CF", validationCF);
			qUpdate.setParam("Validation_CC", validationCC);
			qUpdate.setParam("Validation_CC_Zero", validationCCZero);
			qUpdate.setParam("Annulation_CC", annulationCC);
			qUpdate.setParam("Validation_TS", validationTS);
			qUpdate.setParam("Validation_IS", validationIS);
			qUpdate.setParam("Validation_RG", validationRG);
			qUpdate.setParam("Validation_BR", validationBR);
			qUpdate.setParam("Validation_AF", validationAF);
			qUpdate.setParam("Validation_AC", validationAC);
			qUpdate.setParam("Validation_BP", validationBP);
			qUpdate.setParam("Annulation_BP", annulationBP);
			qUpdate.setParam("Validation_BL", validationBL);
			qUpdate.setParam("Annulation_BL", annulationBL);
			qUpdate.setParam("Validation_DC", validationDC);
			qUpdate.setParam("Max_Validation_DC", maxValidationDC);
			qUpdate.setParam("Cloture_Fact", clotureFact);
			qUpdate.setParam("Modif_Elem_Fin_DV", modifElemFinDV);
			qUpdate.setParam("Modif_Elem_Fin_FCA", modifElemFinFCA);
			qUpdate.setParam("Ignore_PV_Plancher", ignorePVPlancher);
			qUpdate.setParam("Edition_Liste_DL", editionListeDL);
			qUpdate.setParam("Edition_Liste_DA", editionListeDA);
			qUpdate.setParam("Edition_Liste_DV", editionListeDV);
			qUpdate.setParam("Show_Totaux_DV", showTotauxDV);
			qUpdate.setParam("Acces_Cout_Achat", accesCoutAchat);
			qUpdate.setParam("Acces_Banque_Cli", accesBanqueCli);
			qUpdate.setParam("Acces_Banque_Fou", accesBanqueFou);
			qUpdate.setParam("Restric_Acc_CDV_PA", restricAccCDVPA);
			qUpdate.setParam("Gestion_Devis_Type", gestionDevisType);
			qUpdate.setParam("Show_Elem_Four", showElemFour);
			qUpdate.setParam("Gestion_Resp_Vente", gestionRespVente);
			qUpdate.setParam("Gestion_Etab_Vente", gestionEtabVente);
			qUpdate.setParam("Gestion_Pole_Vente", gestionPoleVente);
			qUpdate.setParam("Gestion_Inti_Vente", gestionIntiVente);
			qUpdate.setParam("Gestion_Bloque_Cli", gestionBloqueCli);
			qUpdate.setParam("Modif_Stock_ES", modifStockES);
			qUpdate.setParam("Modif_Prix_FA", modifPrixFA);
			qUpdate.setParam("Modif_PA_DV", modifPADV);
			qUpdate.setParam("Anonymisation_FC", anonymisationFC);
			qUpdate.setParam("GC_Bright_Color", gcBrightColor);
			qUpdate.setParam("Etab_Id", etabId);
			qUpdate.setParam("Borne_Id", borneId);
			qUpdate.setParam("Pole_Activite", poleActivite);

			// Accs menus gestion commerciale
			qUpdate.setParam("MenuGC_TClients", MenuGC_TClients);
			qUpdate.setParam("ReadOnlyGC_TClients", ReadOnlyGC_TClients);
			qUpdate.setParam("MenuGC_TFournisseurs", MenuGC_TFournisseurs);
			qUpdate.setParam("MenuGC_TCommerciaux", MenuGC_TCommerciaux);
			qUpdate.setParam("MenuGC_VDevis", MenuGC_VDevis);
			qUpdate.setParam("MenuGC_VAffaires", MenuGC_VAffaires);
			qUpdate.setParam("ReadOnlyGC_VDevis", ReadOnlyGC_VDevis);
			qUpdate.setParam("ReadOnlyGC_VAffaires", ReadOnlyGC_VAffaires);
			qUpdate.setParam("MenuGC_VRetours", MenuGC_VRetours);
			qUpdate.setParam("MenuGC_VFactures", MenuGC_VFactures);
			qUpdate.setParam("MenuGC_VFactuAuto", MenuGC_VFactuAuto);
			qUpdate.setParam("MenuGC_VEnvoiFact", MenuGC_VEnvoiFact);
			qUpdate.setParam("MenuGC_VAbonnements", MenuGC_VAbonnements);
			qUpdate.setParam("MenuGC_EExpesCC", MenuGC_EExpesCC);
			qUpdate.setParam("MenuGC_EExpesTS", MenuGC_EExpesTS);
			qUpdate.setParam("MenuGC_EPrepaExpes", MenuGC_EPrepaExpes);
			qUpdate.setParam("MenuGC_EExpCrossDock", MenuGC_EExpCrossDock);
			qUpdate.setParam("MenuGC_ESuiviLog", MenuGC_ESuiviLog);
			qUpdate.setParam("MenuGC_ESuiviTrans", MenuGC_ESuiviTrans);
			qUpdate.setParam("MenuGC_ACommandes", MenuGC_ACommandes);
			qUpdate.setParam("MenuGC_APrepaCom", MenuGC_APrepaCom);
			qUpdate.setParam("MenuGC_ARecepCom", MenuGC_ARecepCom);
			qUpdate.setParam("MenuGC_ARetours", MenuGC_ARetours);
			qUpdate.setParam("MenuGC_AFactures", MenuGC_AFactures);
			qUpdate.setParam("MenuGC_AControle", MenuGC_AControle);
			qUpdate.setParam("MenuGC_SArticles", MenuGC_SArticles);
			qUpdate.setParam("ReadOnlyGC_SArticles", ReadOnlyGC_SArticles);
			qUpdate.setParam("MenuGC_STarifs", MenuGC_STarifs);
			qUpdate.setParam("MenuGC_SFabrication", MenuGC_SFabrication);
			qUpdate.setParam("MenuGC_SInventaire", MenuGC_SInventaire);
			qUpdate.setParam("MenuGC_STracabilite", MenuGC_STracabilite);
			qUpdate.setParam("MenuGC_STransferts", MenuGC_STransferts);
			qUpdate.setParam("MenuGC_SMouvements", MenuGC_SMouvements);
			qUpdate.setParam("MenuGC_SEmplacements", MenuGC_SEmplacements);
			qUpdate.setParam("MenuGC_STransEmp", MenuGC_STransEmp);
			qUpdate.setParam("MenuGC_SIOStocks", MenuGC_SIOStocks);
			qUpdate.setParam("ReadOnlyGC_SIOStocks", ReadOnlyGC_SIOStocks);
			qUpdate.setParam("MenuGC_SParamStocks", MenuGC_SParamStocks);
			qUpdate.setParam("MenuGC_DRegFour", MenuGC_DRegFour);
			qUpdate.setParam("MenuGC_DRegCli", MenuGC_DRegCli);
			qUpdate.setParam("ReadOnlyGC_DRegCli", ReadOnlyGC_DRegCli);
			qUpdate.setParam("MenuGC_DRemises", MenuGC_DRemises);
			qUpdate.setParam("MenuGC_DEditions", MenuGC_DEditions);
			qUpdate.setParam("MenuGC_DTabBord", MenuGC_DTabBord);
			qUpdate.setParam("MenuGC_DTransCpta", MenuGC_DTransCpta);
			qUpdate.setParam("MenuGC_DExportIdep", MenuGC_DExportIdep);
			qUpdate.setParam("MenuGC_DDeclEcoPart", MenuGC_DDeclEcoPart);
			qUpdate.setParam("MenuGC_DImpExpCsv", MenuGC_DImpExpCsv);
			qUpdate.setParam("MenuGC_DPassword", MenuGC_DPassword);

			// Accs menus comptabilit
			qUpdate.setParam("MenuCG_CSaisie", MenuCG_CSaisie);
			qUpdate.setParam("MenuCG_CRevision", MenuCG_CRevision);
			qUpdate.setParam("MenuCG_CTransCop", MenuCG_CTransCop);
			qUpdate.setParam("MenuCG_CRappro", MenuCG_CRappro);
			qUpdate.setParam("MenuCG_CClotMens", MenuCG_CClotMens);
			qUpdate.setParam("MenuCG_CClotExo", MenuCG_CClotExo);
			qUpdate.setParam("MenuCG_EBalance", MenuCG_EBalance);
			qUpdate.setParam("MenuCG_ECentral", MenuCG_ECentral);
			qUpdate.setParam("MenuCG_EGdLivre", MenuCG_EGdLivre);
			qUpdate.setParam("MenuCG_EJournaux", MenuCG_EJournaux);
			qUpdate.setParam("MenuCG_EBalAgee", MenuCG_EBalAgee);
			qUpdate.setParam("MenuCG_EBilan", MenuCG_EBilan);
			qUpdate.setParam("MenuCG_EResultat", MenuCG_EResultat);
			qUpdate.setParam("MenuCG_ESoldes", MenuCG_ESoldes);
			qUpdate.setParam("MenuCG_EPlanCpte", MenuCG_EPlanCpte);
			qUpdate.setParam("MenuCG_SBordGest", MenuCG_SBordGest);
			qUpdate.setParam("MenuCG_SBordTres", MenuCG_SBordTres);
			qUpdate.setParam("MenuCG_AComptes", MenuCG_AComptes);
			qUpdate.setParam("MenuCG_AGdLivre", MenuCG_AGdLivre);
			qUpdate.setParam("MenuCG_AParametrages", MenuCG_AParametrages);
			qUpdate.setParam("MenuCG_DComptes", MenuCG_DComptes);
			qUpdate.setParam("MenuCG_DAboEcr", MenuCG_DAboEcr);
			qUpdate.setParam("MenuCG_DModeles", MenuCG_DModeles);
			qUpdate.setParam("MenuCG_DImpBanque", MenuCG_DImpBanque);
			qUpdate.setParam("MenuCG_DImpExpEcr", MenuCG_DImpExpEcr);
			qUpdate.setParam("MenuCG_DPassword", MenuCG_DPassword);

			// Accs statistiques
			qUpdate.setParam("Edition_DES_CPC", editionDES_CPC);
			qUpdate.setParam("Edition_DES_CLC", editionDES_CLC);
			qUpdate.setParam("Edition_DES_FPF", editionDES_FPF);
			qUpdate.setParam("Edition_DES_FLF", editionDES_FLF);
			qUpdate.setParam("Edition_DES_SPA", editionDES_SPA);
			qUpdate.setParam("Edition_DES_SFA", editionDES_SFA);
			qUpdate.setParam("Edition_DES_SMS", editionDES_SMS);
			qUpdate.setParam("Edition_DES_SES", editionDES_SES);
			qUpdate.setParam("Edition_DES_SRS", editionDES_SRS);
			qUpdate.setParam("Edition_DES_SPF", editionDES_SPF);
			qUpdate.setParam("Edition_DES_SMA", editionDES_SMA);
			qUpdate.setParam("Edition_DES_VJV", editionDES_VJV);
			qUpdate.setParam("Edition_DES_VJA", editionDES_VJA);
			qUpdate.setParam("Edition_DES_VVA", editionDES_VVA);
			qUpdate.setParam("Edition_DES_VFA", editionDES_VFA);
			qUpdate.setParam("Edition_DES_VFC", editionDES_VFC);
			qUpdate.setParam("Edition_DES_VFD", editionDES_VFD);
			qUpdate.setParam("Edition_DES_VSC", editionDES_VSC);
			qUpdate.setParam("Edition_DES_VLE", editionDES_VLE);
			qUpdate.setParam("Edition_DES_VLC", editionDES_VLC);
			qUpdate.setParam("Edition_DES_VEC", editionDES_VEC);
			qUpdate.setParam("Edition_DES_VCT", editionDES_VCT);
			qUpdate.setParam("Edition_DES_VRC", editionDES_VRC);
			qUpdate.setParam("Edition_DES_VAR", editionDES_VAR);
			qUpdate.setParam("Edition_DES_VCS", editionDES_VCS);
			qUpdate.setParam("Edition_DES_VFV", editionDES_VFV);
			qUpdate.setParam("Edition_DES_VRE", editionDES_VRE);
			qUpdate.setParam("Edition_DES_VCR", editionDES_VCR);
			qUpdate.setParam("Edition_DES_VHP", editionDES_VHP);
			qUpdate.setParam("Edition_DES_AJA", editionDES_AJA);
			qUpdate.setParam("Edition_DES_AAC", editionDES_AAC);
			qUpdate.setParam("Edition_DES_AAA", editionDES_AAA);
			qUpdate.setParam("Edition_DES_AEF", editionDES_AEF);
			qUpdate.setParam("Edition_DES_ARF", editionDES_ARF);
			qUpdate.setParam("Edition_DES_ASF", editionDES_ASF);
			qUpdate.setParam("Edition_DES_ASD", editionDES_ASD);

			// Accs menus module flash
			qUpdate.setParam("MenuMWM_ExpMonoBL", MenuMWM_ExpMonoBL);
			qUpdate.setParam("MenuMWM_ExpMultiBL", MenuMWM_ExpMultiBL);
			qUpdate.setParam("MenuMWM_CdeClient", MenuMWM_CdeClient);
			qUpdate.setParam("MenuMWM_PrepExpedition", MenuMWM_PrepExpedition);
			qUpdate.setParam("MenuMWM_InfoArticle", MenuMWM_InfoArticle);
			qUpdate.setParam("MenuMWM_Inventaire", MenuMWM_Inventaire);
			qUpdate.setParam("MWM_Inv_Show_SI", MWM_Inv_Show_SI);
			qUpdate.setParam("MenuMWM_Reception", MenuMWM_Reception);
			qUpdate.setParam("MenuMWM_Rangement", MenuMWM_Rangement);
			qUpdate.setParam("MenuMWM_LocCrossDock", MenuMWM_LocCrossDock);
			qUpdate.setParam("MenuMWM_ExpCrossDock", MenuMWM_ExpCrossDock);
			qUpdate.setParam("MenuMWM_EntSortStk", MenuMWM_EntSortStk);
			qUpdate.setParam("MenuMWM_ChangeEmp", MenuMWM_ChangeEmp);
			qUpdate.setParam("MenuMWM_TransEmp", MenuMWM_TransEmp);
			qUpdate.setParam("MenuMWM_ConsultEmp", MenuMWM_ConsultEmp);
			qUpdate.setParam("MenuMWM_RecepRetCli", MenuMWM_RecepRetCli);
			qUpdate.setParam("MenuMWM_Picking", MenuMWM_Picking);
			qUpdate.setParam("MWM_Controle_Picking", MWM_Controle_Picking);
			qUpdate.setParam("MenuMWM_PrepExpress", MenuMWM_PrepExpress);
			qUpdate.setParam("MenuMWM_Controle", MenuMWM_Controle);
			qUpdate.setParam("MenuMWM_Impression", MenuMWM_Impression);
			qUpdate.setParam("MenuMWM_Localisation", MenuMWM_Localisation);
			qUpdate.setParam("MWM_PEX_Quantite", MWM_PEX_Quantite);
			qUpdate.setParam("MWM_PEX_Qte_Manquante", MWM_PEX_Qte_Manquante);
			qUpdate.setParam("MWM_Scan_Borne", MWM_Scan_Borne);
			qUpdate.setParam("MWM_Info_Art_Chg_Emp", MWM_Info_Art_Chg_Emp);

			// Droits provenances
			qUpdate.setParam("Provenance_HL", provenanceHL);
			qUpdate.setParam("Catalogue_Complet", catalogueComplet);

			qUpdate.setParam("Liste_Depots", listeDepots);
			qUpdate.setParam("Liste_DD", listeDD);
			qUpdate.setParam("Liste_Etabs", listeEtabs);
			qUpdate.setParam("Liste_DE", listeDE);
			qUpdate.setParam("Liste_Fours", listeFours);
			qUpdate.setParam("Liste_DF", listeDF);
			qUpdate.setParam("Liste_Provs", listeProvs);
			qUpdate.setParam("Liste_DP", listeDP);
			qUpdate.setParam("Liste_Cats", listeCats);
			qUpdate.setParam("Liste_DC", listeDC);
			qUpdate.setParam("Liste_Indics", listeIndics);
			qUpdate.setParam("Liste_DI", listeDI);

			qUpdate.execute();

			ofu_aDroitsDepots.initTree();
			ofu_aDroitsEtabs.initTree();
			ofu_aDroitsProvs.initTree();
			ofu_aDroitsCats.initTree();
			ofu_aDroitsIndics.initTree(ofu_compterIndicateurs);

			if (ofu_specTNDAF) {
				ofu_aDroitsFours.initTree();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofu_cocherCompta(b) {
	try {

		document.getElementById("ofu-cCG_CSaisie").checked = b;
		document.getElementById("ofu-cCG_EBalance").checked = b;
		document.getElementById("ofu-cCG_SBordGest").checked = b;
		document.getElementById("ofu-cCG_AComptes").checked = b;
		document.getElementById("ofu-cCG_DComptes").checked = b;
		document.getElementById("ofu-cCG_CRevision").checked = b;
		document.getElementById("ofu-cCG_ECentral").checked = b;
		document.getElementById("ofu-cCG_SBordTres").checked = b;
		document.getElementById("ofu-cCG_AGdLivre").checked = b;
		document.getElementById("ofu-cCG_DAboEcr").checked = b;
		document.getElementById("ofu-cCG_CTransCop").checked = b;
		document.getElementById("ofu-cCG_EGdLivre").checked = b;
		document.getElementById("ofu-cCG_AParametrages").checked = b;
		document.getElementById("ofu-cCG_DModeles").checked = b;
		document.getElementById("ofu-cCG_CRappro").checked = b;
		document.getElementById("ofu-cCG_EJournaux").checked = b;
		document.getElementById("ofu-cCG_DImpBanque").checked = b;
		document.getElementById("ofu-cCG_CClotMens").checked = b;
		document.getElementById("ofu-cCG_EBalAgee").checked = b;
		document.getElementById("ofu-cCG_DImpExpEcr").checked = b;
		document.getElementById("ofu-cCG_CClotExo").checked = b;
		document.getElementById("ofu-cCG_EBilan").checked = b;
		document.getElementById("ofu-cCG_DPassword").checked = b;
		document.getElementById("ofu-cCG_EResultat").checked = b;
		document.getElementById("ofu-cCG_ESoldes").checked = b;
		document.getElementById("ofu-cCG_EPlanCpte").checked = b;

  } catch (e) {
    recup_erreur(e);
  }
}


function ofu_cocherStats(b) {
	try {

		document.getElementById("ofu-cEditionDES_CPC").checked = b;
		document.getElementById("ofu-cEditionDES_CLC").checked = b;
		document.getElementById("ofu-cEditionDES_FPF").checked = b;
		document.getElementById("ofu-cEditionDES_FLF").checked = b;
		document.getElementById("ofu-cEditionDES_SPA").checked = b;
		document.getElementById("ofu-cEditionDES_SFA").checked = b;
		document.getElementById("ofu-cEditionDES_SMS").checked = b;
		document.getElementById("ofu-cEditionDES_SES").checked = b;
		document.getElementById("ofu-cEditionDES_SRS").checked = b;
		document.getElementById("ofu-cEditionDES_SPF").checked = b;
		document.getElementById("ofu-cEditionDES_SMA").checked = b;
		document.getElementById("ofu-cEditionDES_VJV").checked = b;
		document.getElementById("ofu-cEditionDES_VJA").checked = b;
		document.getElementById("ofu-cEditionDES_VVA").checked = b;
		document.getElementById("ofu-cEditionDES_VFA").checked = b;
		document.getElementById("ofu-cEditionDES_VFC").checked = b;
		document.getElementById("ofu-cEditionDES_VFD").checked = b;
		document.getElementById("ofu-cEditionDES_VSC").checked = b;
		document.getElementById("ofu-cEditionDES_VLE").checked = b || !ofu_specLHELE;
		document.getElementById("ofu-cEditionDES_VLC").checked = b;
		document.getElementById("ofu-cEditionDES_VEC").checked = b;
		document.getElementById("ofu-cEditionDES_VCT").checked = b || !ofu_gacCoutTrans;
		document.getElementById("ofu-cEditionDES_VRC").checked = b || !ofu_actReassortCC;
		document.getElementById("ofu-cEditionDES_VAR").checked = b || !ofu_specSMEAR;
		document.getElementById("ofu-cEditionDES_VCS").checked = b || !ofu_actCodeStats;
		document.getElementById("ofu-cEditionDES_VFV").checked = b || !ofu_specEDEFV;
		document.getElementById("ofu-cEditionDES_VRE").checked = b || !ofu_specREERC;
		document.getElementById("ofu-cEditionDES_VCR").checked = b || !ofu_specLMECR;
		document.getElementById("ofu-cEditionDES_VHP").checked = b || !ofu_specKEESK;
		document.getElementById("ofu-cEditionDES_AJA").checked = b;
		document.getElementById("ofu-cEditionDES_AAC").checked = b;
		document.getElementById("ofu-cEditionDES_AAA").checked = b;
		document.getElementById("ofu-cEditionDES_AEF").checked = b;
		document.getElementById("ofu-cEditionDES_ARF").checked = b;
		document.getElementById("ofu-cEditionDES_ASF").checked = b || !ofu_specLHFNP;
		document.getElementById("ofu-cEditionDES_ASD").checked = b || !ofu_specHMDNP;

  } catch (e) {
    recup_erreur(e);
  }
}


function ofu_cocherGC(b) {
	try {

		document.getElementById("ofu-cGC_TClients").checked = b;
		document.getElementById("ofu-cGC_VDevis").checked = b;
		document.getElementById("ofu-cGC_ACommandes").checked = b;
		document.getElementById("ofu-cGC_SArticles").checked = b;
		document.getElementById("ofu-cGC_DRegFour").checked = b;
		document.getElementById("ofu-cGC_TFournisseurs").checked = b;
		document.getElementById("ofu-cGC_VAffaires").checked = b;
		document.getElementById("ofu-cGC_APrepaCom").checked = b;
		document.getElementById("ofu-cGC_STarifs").checked = b;
		document.getElementById("ofu-cGC_DRegCli").checked = b;
		document.getElementById("ofu-cGC_TCommerciaux").checked = b;
		document.getElementById("ofu-cGC_ARecepCom").checked = b;
		document.getElementById("ofu-cGC_SFabrication").checked = b;
		document.getElementById("ofu-cGC_DRemises").checked = b;
		document.getElementById("ofu-cGC_ARetours").checked = b;
		document.getElementById("ofu-cGC_SInventaire").checked = b;
		document.getElementById("ofu-cGC_DEditions").checked = b;
		document.getElementById("ofu-cGC_AFactures").checked = b;
		document.getElementById("ofu-cGC_AControle").checked = b || !ofu_specLHCFF;
		document.getElementById("ofu-cGC_STracabilite").checked = b;
		document.getElementById("ofu-cGC_DTabBord").checked = b;
		document.getElementById("ofu-cGC_VRetours").checked = b;
		document.getElementById("ofu-cGC_VFactures").checked = b;
		document.getElementById("ofu-cGC_STransferts").checked = b;
		document.getElementById("ofu-cGC_DTransCpta").checked = b;
		document.getElementById("ofu-cGC_VFactuAuto").checked = b;
		document.getElementById("ofu-cGC_SMouvements").checked = b;
		document.getElementById("ofu-cGC_SEmplacements").checked = b;
		document.getElementById("ofu-cGC_STransEmp").checked = b;
		document.getElementById("ofu-cGC_SIOStocks").checked = b;
		document.getElementById("ofu-cGC_SParamStocks").checked = b;
		document.getElementById("ofu-cGC_DExportIdep").checked = b;
		document.getElementById("ofu-cGC_DDeclEcoPart").checked = b;
		document.getElementById("ofu-cGC_VEnvoiFact").checked = b;
		document.getElementById("ofu-cGC_DImpExpCsv").checked = b;
		document.getElementById("ofu-cGC_VAbonnements").checked = b;
		document.getElementById("ofu-cGC_DPassword").checked = b;
		document.getElementById("ofu-cGC_EExpesCC").checked = b;
		document.getElementById("ofu-cGC_EExpesTS").checked = b;
		document.getElementById("ofu-cGC_EPrepaExpes").checked = b;
		document.getElementById("ofu-cGC_EExpCrossDock").checked = b || !ofu_accCrossDock;
		document.getElementById("ofu-cGC_ESuiviLog").checked = b;
		document.getElementById("ofu-cGC_ESuiviTrans").checked = b;

  } catch (e) {
    recup_erreur(e);
  }
}


function ofu_cocherDG(b) {
	try {

		document.getElementById("ofu-cGestionCo").checked = b;
		document.getElementById("ofu-cCompta").checked = b;
		document.getElementById("ofu-cContact").checked = b;
		document.getElementById("ofu-cTransac").checked = b;
		document.getElementById("ofu-cConfig").checked = b;
		document.getElementById("ofu-cFlash").checked = b && ofu_accFlash;
		document.getElementById("ofu-cAccBAM").checked = b && ofu_accBAM;
		document.getElementById("ofu-cDirection").checked = b;
		document.getElementById("ofu-cValidationCF").checked = b;
		document.getElementById("ofu-cValidationCC").checked = b;
		document.getElementById("ofu-cValidationCCZero").checked = b;
		document.getElementById("ofu-cAnnulationCC").checked = b;
		document.getElementById("ofu-cValidationTS").checked = b;
		document.getElementById("ofu-cValidationIS").checked = b;
		document.getElementById("ofu-cValidationRG").checked = b;
		document.getElementById("ofu-cValidationBR").checked = b;
		document.getElementById("ofu-cValidationAF").checked = b;
		document.getElementById("ofu-cValidationAC").checked = b;
		document.getElementById("ofu-cValidationBP").checked = b;
		document.getElementById("ofu-cAnnulationBP").checked = b;
		document.getElementById("ofu-cValidationBL").checked = b;
		document.getElementById("ofu-cAnnulationBL").checked = b;
		document.getElementById("ofu-cValidationDC").checked = b;
		document.getElementById("ofu-cMaxValidationDC").disabled = !b;
		document.getElementById("ofu-cClotureFact").checked = b;
		document.getElementById("ofu-cModifElemFinDV").checked = b;
		document.getElementById("ofu-cModifElemFinFCA").checked = b;
		document.getElementById("ofu-cIgnorePVPlancher").checked = b;
		document.getElementById("ofu-cEditionListeDL").checked = b;
		document.getElementById("ofu-cEditionListeDA").checked = b;
		document.getElementById("ofu-cEditionListeDV").checked = b;
		document.getElementById("ofu-cShowTotauxDV").checked = b;
		document.getElementById("ofu-cAccesCoutAchat").checked = b;
		document.getElementById("ofu-cAccesBanqueCli").checked = b;
		document.getElementById("ofu-cAccesBanqueFou").checked = b;
		document.getElementById("ofu-cRestricAccCDVPA").checked = b && ofu_specLCARAP;
		document.getElementById("ofu-cGestionDevisType").checked = b;
		document.getElementById("ofu-cShowElemFour").checked = b;
		document.getElementById("ofu-cGestionRespVente").checked = b || !ofu_specLHGRV;
		document.getElementById("ofu-cGestionEtabVente").checked = b || !ofu_specLCAGEV;
		document.getElementById("ofu-cGestionPoleVente").checked = b || !ofu_specLHGPV;
		document.getElementById("ofu-cGestionIntiVente").checked = b || !ofu_specLHGDV;
		document.getElementById("ofu-cGestionBloqueCli").checked = b || !ofu_specLVPBFC;
		document.getElementById("ofu-cModifStockES").checked = b;
		document.getElementById("ofu-cModifPrixFA").checked = b || !ofu_specTNMPA;
		document.getElementById("ofu-cModifPADV").checked = b;
		document.getElementById("ofu-cAnonymisationFC").checked = b;
		document.getElementById("ofu-cGCBrightColor").checked = b;

  } catch (e) {
    recup_erreur(e);
  }
}


function ofu_cocherMWM(b) {
	try {

		document.getElementById("ofu-cMWM_ExpMonoBL").checked = b && ofu_accMWMExpMonoBL;
		document.getElementById("ofu-cMWM_ExpMultiBL").checked = b && ofu_accMWMExpMultiBL;
		document.getElementById("ofu-cMWM_CdeClient").checked = b && ofu_accMWMCdeClient;
		document.getElementById("ofu-cMWM_PrepExpedition").checked = b;
		document.getElementById("ofu-cMWM_InfoArticle").checked = b;
		document.getElementById("ofu-cMWM_Inventaire").checked = b;
		document.getElementById("ofu-cMWM_Inv_Show_SI").checked = b;
		document.getElementById("ofu-cMWM_Reception").checked = b;
		document.getElementById("ofu-cMWM_Rangement").checked = b;
		document.getElementById("ofu-cMWM_LocCrossDock").checked = b && ofu_accCrossDock;
		document.getElementById("ofu-cMWM_ExpCrossDock").checked = b && ofu_accCrossDock;
		document.getElementById("ofu-cMWM_EntSortStk").checked = b;
		document.getElementById("ofu-cMWM_ChangeEmp").checked = b;
		document.getElementById("ofu-cMWM_TransEmp").checked = b;
		document.getElementById("ofu-cMWM_ConsultEmp").checked = b;
		document.getElementById("ofu-cMWM_RecepRetCli").checked = b;
		document.getElementById("ofu-cMWM_Picking").checked = b;
		document.getElementById("ofu-cMWM_Controle_Picking").checked = b;
		document.getElementById("ofu-cMWM_PrepExpress").checked = b;
		document.getElementById("ofu-cMWM_Controle").checked = b;
		document.getElementById("ofu-cMWM_Impression").checked = b;
		document.getElementById("ofu-cMWM_Localisation").checked = b;
		document.getElementById("ofu-cMWM_PEX_Quantite").checked = b;
		document.getElementById("ofu-cMWM_PEX_Qte_Manquante").checked = b;
		document.getElementById("ofu-cMWM_Scan_Borne").checked = b;
		document.getElementById("ofu-cMWM_Info_Art_Chg_Emp").checked = b;

  } catch (e) {
    recup_erreur(e);
  }
}


function ofu_toutCocherDF(b) {
	try {

		for (var i=0; i<ofu_aDroitsFours.nbLignes(); i++) {
			if (ofu_aDroitsFours.isEditable(i, "ofu-colSelectFournisseur")) {
				ofu_aDroitsFours.setCellValue(i, "ofu-colSelectFournisseur", b);
  		}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofu_toutCocherDP(b) {
	try {

		for (var i=0; i<ofu_aDroitsProvs.nbLignes(); i++) {
			if (ofu_aDroitsProvs.isEditable(i, "ofu-colSelectDP")) {
				ofu_aDroitsProvs.setCellValue(i, "ofu-colSelectDP", b);
  		}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofu_toutCocherDC(b) {
	try {

		for (var i=0; i<ofu_aDroitsCats.nbLignes(); i++) {
			if (ofu_aDroitsCats.isEditable(i, "ofu-colSelectDC")) {
				ofu_aDroitsCats.setCellValue(i, "ofu-colSelectDC", b);
  		}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofu_toutCocherDI(b) {
	try {

		for (var i=0; i<ofu_aDroitsIndics.nbLignes(); i++) {
			if (ofu_aDroitsIndics.isEditable(i, "ofu-colSelectDI")) {
				ofu_aDroitsIndics.setCellValue(i, "ofu-colSelectDI", b);
  		}
		}
		
		ofu_compterIndicateurs();

	} catch (e) {
		recup_erreur(e);
	}
}


function ofu_clickOnValidationDC() {
	try {

		if (document.getElementById("ofu-cValidationDC").checked) {
			document.getElementById("ofu-cMaxValidationDC").disabled = false;
		}
		else {
			document.getElementById("ofu-cMaxValidationDC").disabled = true;
			document.getElementById("ofu-cMaxValidationDC").value = "";
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function ofu_clickOnModifElemFinDV() {
	try {

		document.getElementById("ofu-cModifElemFinFCA").disabled = !document.getElementById("ofu-cModifElemFinDV").checked;

	} catch (e) {
    recup_erreur(e);
  }
}


function ofu_clickOnCatalogueComplet() {
	try {

		var catalogueComplet = document.getElementById("ofu-catalogueComplet").checked;

		if (!catalogueComplet) {
			ofu_toutCocherDC(false);
		}

		document.getElementById("ofu-bDCCoche").collapsed = catalogueComplet;
		document.getElementById("ofu-bDCDecoche").collapsed = catalogueComplet;
		document.getElementById("ofu-listDroitsCats").collapsed = catalogueComplet;

	} catch (e) {
    recup_erreur(e);
  }
}


function ofu_compterIndicateurs() {
	try {

		var nbCoches = 0;

		for (var i=0; i<ofu_aDroitsIndics.nbLignes(); i++) {
			if (ofu_aDroitsIndics.getCellValue(i, "ofu-colSelectDI")=="true") {
				nbCoches++;
			}
  	}

		document.getElementById('ofu-nbIndicateurs').value = nbCoches;

	} catch (e) {
		recup_erreur(e);
	}
}


function ofu_chargerProfil() {
	try {

		var profilId = document.getElementById("ofu-profils").value;

		if (profilId=="") {
			showWarning("Veuillez choisir un profil");
		}
		else {
			var qGetProfil = new QueryHttp("Utilisateurs/Profils/loadProfilType.tmpl")
			qGetProfil.setParam("Profil_Id", profilId);

			var result = qGetProfil.execute();
			var contenu = result.responseXML.documentElement;

			// Droits gnraux
			document.getElementById("ofu-cConfig").checked = contenu.getAttribute("Acc_Config")=="true";
			document.getElementById("ofu-cGestionCo").checked = contenu.getAttribute("Acc_Gest_Com")=="true";
			document.getElementById("ofu-cCompta").checked = contenu.getAttribute("Acc_Compta")=="true";
			document.getElementById("ofu-cContact").checked = contenu.getAttribute("Acc_CRM")=="true";
			document.getElementById("ofu-cTransac").checked = contenu.getAttribute("Acc_TB")=="true";
			document.getElementById("ofu-cFlash").checked = contenu.getAttribute("Acc_MWM")=="true" && ofu_accFlash;
			document.getElementById("ofu-cAccBAM").checked = contenu.getAttribute("Acc_BAM")=="true" && ofu_accBAM;
			document.getElementById("ofu-cDirection").checked = contenu.getAttribute("Direction")=="true";
			document.getElementById("ofu-cValidationCF").checked = contenu.getAttribute("Validation_CF")=="true";
			document.getElementById("ofu-cValidationCC").checked = contenu.getAttribute("Validation_CC")=="true";
			document.getElementById("ofu-cValidationCCZero").checked = contenu.getAttribute("Validation_CC_Zero")=="true";
			document.getElementById("ofu-cAnnulationCC").checked = contenu.getAttribute("Annulation_CC")=="true";
			document.getElementById("ofu-cValidationTS").checked = contenu.getAttribute("Validation_TS")=="true";
			document.getElementById("ofu-cValidationIS").checked = contenu.getAttribute("Validation_IS")=="true";
			document.getElementById("ofu-cValidationRG").checked = contenu.getAttribute("Validation_RG")=="true";
			document.getElementById("ofu-cValidationBR").checked = contenu.getAttribute("Validation_BR")=="true";
			document.getElementById("ofu-cValidationAF").checked = contenu.getAttribute("Validation_AF")=="true";
			document.getElementById("ofu-cValidationAC").checked = contenu.getAttribute("Validation_AC")=="true";
			document.getElementById("ofu-cValidationBP").checked = contenu.getAttribute("Validation_BP")=="true";
			document.getElementById("ofu-cAnnulationBP").checked = contenu.getAttribute("Annulation_BP")=="true";
			document.getElementById("ofu-cValidationBL").checked = contenu.getAttribute("Validation_BL")=="true";
			document.getElementById("ofu-cAnnulationBL").checked = contenu.getAttribute("Annulation_BL")=="true";
			document.getElementById("ofu-cValidationDC").checked = contenu.getAttribute("Validation_DC")=="true";
			document.getElementById("ofu-cMaxValidationDC").value = contenu.getAttribute("Max_Validation_DC");
			document.getElementById("ofu-cClotureFact").checked = contenu.getAttribute("Cloture_Fact")=="true";
			document.getElementById("ofu-cModifElemFinDV").checked = contenu.getAttribute("Modif_Elem_Fin_DV")=="true";
			document.getElementById("ofu-cModifElemFinFCA").checked = contenu.getAttribute("Modif_Elem_Fin_FCA")=="true";
			document.getElementById("ofu-cIgnorePVPlancher").checked = contenu.getAttribute("Ignore_PV_Plancher")=="true";
			document.getElementById("ofu-cEditionListeDL").checked = contenu.getAttribute("Edition_Liste_DL")=="true";
			document.getElementById("ofu-cEditionListeDA").checked = contenu.getAttribute("Edition_Liste_DA")=="true";
			document.getElementById("ofu-cEditionListeDV").checked = contenu.getAttribute("Edition_Liste_DV")=="true";
			document.getElementById("ofu-cShowTotauxDV").checked = contenu.getAttribute("Show_Totaux_DV")=="true";
			document.getElementById("ofu-cAccesCoutAchat").checked = contenu.getAttribute("Acces_Cout_Achat")=="true";
			document.getElementById("ofu-cAccesBanqueCli").checked = contenu.getAttribute("Acces_Banque_Cli")=="true";
			document.getElementById("ofu-cAccesBanqueFou").checked = contenu.getAttribute("Acces_Banque_Fou")=="true";
			document.getElementById("ofu-cRestricAccCDVPA").checked = contenu.getAttribute("Restric_Acc_CDV_PA")=="true" && ofu_specLCARAP;
			document.getElementById("ofu-cGestionDevisType").checked = contenu.getAttribute("Gestion_Devis_Type")=="true";
			document.getElementById("ofu-cShowElemFour").checked = contenu.getAttribute("Show_Elem_Four")=="true";
			document.getElementById("ofu-cGestionRespVente").checked = contenu.getAttribute("Gestion_Resp_Vente")=="true" || !ofu_specLHGRV;
			document.getElementById("ofu-cGestionEtabVente").checked = contenu.getAttribute("Gestion_Etab_Vente")=="true" || !ofu_specLCAGEV;
			document.getElementById("ofu-cGestionPoleVente").checked = contenu.getAttribute("Gestion_Pole_Vente")=="true" || !ofu_specLHGPV;
			document.getElementById("ofu-cGestionIntiVente").checked = contenu.getAttribute("Gestion_Inti_Vente")=="true" || !ofu_specLHGDV;
			document.getElementById("ofu-cGestionBloqueCli").checked = contenu.getAttribute("Gestion_Bloque_Cli")=="true" || !ofu_specLVPBFC;
			document.getElementById("ofu-cModifStockES").checked = contenu.getAttribute("Modif_Stock_ES")=="true";
			document.getElementById("ofu-cModifPrixFA").checked = contenu.getAttribute("Modif_Prix_FA")=="true" || !ofu_specTNMPA;
			document.getElementById("ofu-cModifPADV").checked = contenu.getAttribute("Modif_PA_DV")=="true";
			document.getElementById("ofu-cAnonymisationFC").checked = contenu.getAttribute("Anonymisation_FC")=="true";
			document.getElementById("ofu-cGCBrightColor").checked = contenu.getAttribute("GC_Bright_Color")=="true";

			// Accs menus gestion commerciale
			document.getElementById("ofu-cGC_TClients").checked = contenu.getAttribute("MenuGC_TClients")=="true";
			document.getElementById("ofu-cReadOnlyGC_TClients").checked = contenu.getAttribute("ReadOnlyGC_TClients")=="true";
			document.getElementById("ofu-cGC_VDevis").checked = contenu.getAttribute("MenuGC_VDevis")=="true";
			document.getElementById("ofu-cGC_ACommandes").checked = contenu.getAttribute("MenuGC_ACommandes")=="true";
			document.getElementById("ofu-cGC_SArticles").checked = contenu.getAttribute("MenuGC_SArticles")=="true";
			document.getElementById("ofu-cReadOnlyGC_SArticles").checked = contenu.getAttribute("ReadOnlyGC_SArticles")=="true";
			document.getElementById("ofu-cGC_DRegFour").checked = contenu.getAttribute("MenuGC_DRegFour")=="true";
			document.getElementById("ofu-cGC_TFournisseurs").checked = contenu.getAttribute("MenuGC_TFournisseurs")=="true";
			document.getElementById("ofu-cGC_VAffaires").checked = contenu.getAttribute("MenuGC_VAffaires")=="true";
			document.getElementById("ofu-cReadOnlyGC_VDevis").checked = contenu.getAttribute("ReadOnlyGC_VDevis")=="true";
			document.getElementById("ofu-cReadOnlyGC_VAffaires").checked = contenu.getAttribute("ReadOnlyGC_VAffaires")=="true";
			document.getElementById("ofu-cGC_APrepaCom").checked = contenu.getAttribute("MenuGC_APrepaCom")=="true";
			document.getElementById("ofu-cGC_STarifs").checked = contenu.getAttribute("MenuGC_STarifs")=="true";
			document.getElementById("ofu-cGC_DRegCli").checked = contenu.getAttribute("MenuGC_DRegCli")=="true";
			document.getElementById("ofu-cReadOnlyGC_DRegCli").checked = contenu.getAttribute("ReadOnlyGC_DRegCli")=="true";
			document.getElementById("ofu-cGC_TCommerciaux").checked = contenu.getAttribute("MenuGC_TCommerciaux")=="true";
			document.getElementById("ofu-cGC_ARecepCom").checked = contenu.getAttribute("MenuGC_ARecepCom")=="true";
			document.getElementById("ofu-cGC_SFabrication").checked = contenu.getAttribute("MenuGC_SFabrication")=="true";
			document.getElementById("ofu-cGC_DRemises").checked = contenu.getAttribute("MenuGC_DRemises")=="true";
			document.getElementById("ofu-cGC_ARetours").checked = contenu.getAttribute("MenuGC_ARetours")=="true";
			document.getElementById("ofu-cGC_SInventaire").checked = contenu.getAttribute("MenuGC_SInventaire")=="true";
			document.getElementById("ofu-cGC_DEditions").checked = contenu.getAttribute("MenuGC_DEditions")=="true";
			document.getElementById("ofu-cGC_AFactures").checked = contenu.getAttribute("MenuGC_AFactures")=="true";
			document.getElementById("ofu-cGC_AControle").checked = contenu.getAttribute("MenuGC_AControle")=="true" || !ofu_specLHCFF;
			document.getElementById("ofu-cGC_STracabilite").checked = contenu.getAttribute("MenuGC_STracabilite")=="true";
			document.getElementById("ofu-cGC_DTabBord").checked = contenu.getAttribute("MenuGC_DTabBord")=="true";
			document.getElementById("ofu-cGC_VRetours").checked = contenu.getAttribute("MenuGC_VRetours")=="true";
			document.getElementById("ofu-cGC_VFactures").checked = contenu.getAttribute("MenuGC_VFactures")=="true";
			document.getElementById("ofu-cGC_STransferts").checked = contenu.getAttribute("MenuGC_STransferts")=="true";
			document.getElementById("ofu-cGC_DTransCpta").checked = contenu.getAttribute("MenuGC_DTransCpta")=="true";
			document.getElementById("ofu-cGC_VFactuAuto").checked = contenu.getAttribute("MenuGC_VFactuAuto")=="true";
			document.getElementById("ofu-cGC_SMouvements").checked = contenu.getAttribute("MenuGC_SMouvements")=="true";
			document.getElementById("ofu-cGC_SEmplacements").checked = contenu.getAttribute("MenuGC_SEmplacements")=="true";
			document.getElementById("ofu-cGC_STransEmp").checked = contenu.getAttribute("MenuGC_STransEmp")=="true";
			document.getElementById("ofu-cGC_SIOStocks").checked = contenu.getAttribute("MenuGC_SIOStocks")=="true";
			document.getElementById("ofu-cReadOnlyGC_SIOStocks").checked = contenu.getAttribute("ReadOnlyGC_SIOStocks")=="true";
			document.getElementById("ofu-cGC_SParamStocks").checked = contenu.getAttribute("MenuGC_SParamStocks")=="true";
			document.getElementById("ofu-cGC_DExportIdep").checked = contenu.getAttribute("MenuGC_DExportIdep")=="true";
			document.getElementById("ofu-cGC_DDeclEcoPart").checked = contenu.getAttribute("MenuGC_DDeclEcoPart")=="true";
			document.getElementById("ofu-cGC_VEnvoiFact").checked = contenu.getAttribute("MenuGC_VEnvoiFact")=="true";
			document.getElementById("ofu-cGC_DImpExpCsv").checked = contenu.getAttribute("MenuGC_DImpExpCsv")=="true";
			document.getElementById("ofu-cGC_VAbonnements").checked = contenu.getAttribute("MenuGC_VAbonnements")=="true";
			document.getElementById("ofu-cGC_DPassword").checked = contenu.getAttribute("MenuGC_DPassword")=="true";
			document.getElementById("ofu-cGC_EExpesCC").checked = contenu.getAttribute("MenuGC_EExpesCC")=="true";
			document.getElementById("ofu-cGC_EExpesTS").checked = contenu.getAttribute("MenuGC_EExpesTS")=="true";
			document.getElementById("ofu-cGC_EPrepaExpes").checked = contenu.getAttribute("MenuGC_EPrepaExpes")=="true";
			document.getElementById("ofu-cGC_EExpCrossDock").checked = contenu.getAttribute("MenuGC_EExpCrossDock")=="true" || !ofu_accCrossDock;
			document.getElementById("ofu-cGC_ESuiviLog").checked = contenu.getAttribute("MenuGC_ESuiviLog")=="true";
			document.getElementById("ofu-cGC_ESuiviTrans").checked = contenu.getAttribute("MenuGC_ESuiviTrans")=="true";

			// Accs menus comptabilit
			document.getElementById("ofu-cCG_CSaisie").checked = contenu.getAttribute("MenuCG_CSaisie")=="true";
			document.getElementById("ofu-cCG_EBalance").checked = contenu.getAttribute("MenuCG_EBalance")=="true";
			document.getElementById("ofu-cCG_SBordGest").checked = contenu.getAttribute("MenuCG_SBordGest")=="true";
			document.getElementById("ofu-cCG_AComptes").checked = contenu.getAttribute("MenuCG_AComptes")=="true";
			document.getElementById("ofu-cCG_DComptes").checked = contenu.getAttribute("MenuCG_DComptes")=="true";
			document.getElementById("ofu-cCG_CRevision").checked = contenu.getAttribute("MenuCG_CRevision")=="true";
			document.getElementById("ofu-cCG_ECentral").checked = contenu.getAttribute("MenuCG_ECentral")=="true";
			document.getElementById("ofu-cCG_SBordTres").checked = contenu.getAttribute("MenuCG_SBordTres")=="true";
			document.getElementById("ofu-cCG_AGdLivre").checked = contenu.getAttribute("MenuCG_AGdLivre")=="true";
			document.getElementById("ofu-cCG_DAboEcr").checked = contenu.getAttribute("MenuCG_DAboEcr")=="true";
			document.getElementById("ofu-cCG_CTransCop").checked = contenu.getAttribute("MenuCG_CTransCop")=="true";
			document.getElementById("ofu-cCG_EGdLivre").checked = contenu.getAttribute("MenuCG_EGdLivre")=="true";
			document.getElementById("ofu-cCG_AParametrages").checked = contenu.getAttribute("MenuCG_AParametrages")=="true";
			document.getElementById("ofu-cCG_DModeles").checked = contenu.getAttribute("MenuCG_DModeles")=="true";
			document.getElementById("ofu-cCG_CRappro").checked = contenu.getAttribute("MenuCG_CRappro")=="true";
			document.getElementById("ofu-cCG_EJournaux").checked = contenu.getAttribute("MenuCG_EJournaux")=="true";
			document.getElementById("ofu-cCG_DImpBanque").checked = contenu.getAttribute("MenuCG_DImpBanque")=="true";
			document.getElementById("ofu-cCG_CClotMens").checked = contenu.getAttribute("MenuCG_CClotMens")=="true";
			document.getElementById("ofu-cCG_EBalAgee").checked = contenu.getAttribute("MenuCG_EBalAgee")=="true";
			document.getElementById("ofu-cCG_DImpExpEcr").checked = contenu.getAttribute("MenuCG_DImpExpEcr")=="true";
			document.getElementById("ofu-cCG_CClotExo").checked = contenu.getAttribute("MenuCG_CClotExo")=="true";
			document.getElementById("ofu-cCG_EBilan").checked = contenu.getAttribute("MenuCG_EBilan")=="true";
			document.getElementById("ofu-cCG_DPassword").checked = contenu.getAttribute("MenuCG_DPassword")=="true";
			document.getElementById("ofu-cCG_EResultat").checked = contenu.getAttribute("MenuCG_EResultat")=="true";
			document.getElementById("ofu-cCG_ESoldes").checked = contenu.getAttribute("MenuCG_ESoldes")=="true";
			document.getElementById("ofu-cCG_EPlanCpte").checked = contenu.getAttribute("MenuCG_EPlanCpte")=="true";

			// Accs statistiques
			document.getElementById("ofu-cEditionDES_CPC").checked = contenu.getAttribute("Edition_DES_CPC")=="true";
			document.getElementById("ofu-cEditionDES_CLC").checked = contenu.getAttribute("Edition_DES_CLC")=="true";
			document.getElementById("ofu-cEditionDES_FPF").checked = contenu.getAttribute("Edition_DES_FPF")=="true";
			document.getElementById("ofu-cEditionDES_FLF").checked = contenu.getAttribute("Edition_DES_FLF")=="true";
			document.getElementById("ofu-cEditionDES_SPA").checked = contenu.getAttribute("Edition_DES_SPA")=="true";
			document.getElementById("ofu-cEditionDES_SFA").checked = contenu.getAttribute("Edition_DES_SFA")=="true";
			document.getElementById("ofu-cEditionDES_SMS").checked = contenu.getAttribute("Edition_DES_SMS")=="true";
			document.getElementById("ofu-cEditionDES_SES").checked = contenu.getAttribute("Edition_DES_SES")=="true";
			document.getElementById("ofu-cEditionDES_SRS").checked = contenu.getAttribute("Edition_DES_SRS")=="true";
			document.getElementById("ofu-cEditionDES_SPF").checked = contenu.getAttribute("Edition_DES_SPF")=="true";
			document.getElementById("ofu-cEditionDES_SMA").checked = contenu.getAttribute("Edition_DES_SMA")=="true";
			document.getElementById("ofu-cEditionDES_VJV").checked = contenu.getAttribute("Edition_DES_VJV")=="true";
			document.getElementById("ofu-cEditionDES_VJA").checked = contenu.getAttribute("Edition_DES_VJA")=="true";
			document.getElementById("ofu-cEditionDES_VVA").checked = contenu.getAttribute("Edition_DES_VVA")=="true";
			document.getElementById("ofu-cEditionDES_VFA").checked = contenu.getAttribute("Edition_DES_VFA")=="true";
			document.getElementById("ofu-cEditionDES_VFC").checked = contenu.getAttribute("Edition_DES_VFC")=="true";
			document.getElementById("ofu-cEditionDES_VFD").checked = contenu.getAttribute("Edition_DES_VFD")=="true";
			document.getElementById("ofu-cEditionDES_VSC").checked = contenu.getAttribute("Edition_DES_VSC")=="true";
			document.getElementById("ofu-cEditionDES_VLE").checked = contenu.getAttribute("Edition_DES_VLE")=="true" || !ofu_specLHELE;
			document.getElementById("ofu-cEditionDES_VLC").checked = contenu.getAttribute("Edition_DES_VLC")=="true";
			document.getElementById("ofu-cEditionDES_VEC").checked = contenu.getAttribute("Edition_DES_VEC")=="true";
			document.getElementById("ofu-cEditionDES_VCT").checked = contenu.getAttribute("Edition_DES_VCT")=="true" || !ofu_gacCoutTrans;
			document.getElementById("ofu-cEditionDES_VRC").checked = contenu.getAttribute("Edition_DES_VRC")=="true" || !ofu_actReassortCC;
			document.getElementById("ofu-cEditionDES_VAR").checked = contenu.getAttribute("Edition_DES_VAR")=="true" || !ofu_specSMEAR;
			document.getElementById("ofu-cEditionDES_VCS").checked = contenu.getAttribute("Edition_DES_VCS")=="true" || !ofu_actCodeStats;
			document.getElementById("ofu-cEditionDES_VFV").checked = contenu.getAttribute("Edition_DES_VFV")=="true" || !ofu_specEDEFV;
			document.getElementById("ofu-cEditionDES_VRE").checked = contenu.getAttribute("Edition_DES_VRE")=="true" || !ofu_specREERC;
			document.getElementById("ofu-cEditionDES_VCR").checked = contenu.getAttribute("Edition_DES_VCR")=="true" || !ofu_specLMECR;
			document.getElementById("ofu-cEditionDES_VHP").checked = contenu.getAttribute("Edition_DES_VHP")=="true" || !ofu_specKEESK;
			document.getElementById("ofu-cEditionDES_AJA").checked = contenu.getAttribute("Edition_DES_AJA")=="true";
			document.getElementById("ofu-cEditionDES_AAC").checked = contenu.getAttribute("Edition_DES_AAC")=="true";
			document.getElementById("ofu-cEditionDES_AAA").checked = contenu.getAttribute("Edition_DES_AAA")=="true";
			document.getElementById("ofu-cEditionDES_AEF").checked = contenu.getAttribute("Edition_DES_AEF")=="true";
			document.getElementById("ofu-cEditionDES_ARF").checked = contenu.getAttribute("Edition_DES_ARF")=="true";
			document.getElementById("ofu-cEditionDES_ASF").checked = contenu.getAttribute("Edition_DES_ASF")=="true" || !ofu_specLHFNP;
			document.getElementById("ofu-cEditionDES_ASD").checked = contenu.getAttribute("Edition_DES_ASD")=="true" || !ofu_specHMDNP;

			// Accs menus module flash
			document.getElementById("ofu-cMWM_ExpMonoBL").checked = contenu.getAttribute("MenuMWM_ExpMonoBL")=="true" && ofu_accMWMExpMonoBL;
			document.getElementById("ofu-cMWM_ExpMultiBL").checked = contenu.getAttribute("MenuMWM_ExpMultiBL")=="true" && ofu_accMWMExpMultiBL;
			document.getElementById("ofu-cMWM_CdeClient").checked = contenu.getAttribute("MenuMWM_CdeClient")=="true" && ofu_accMWMCdeClient;
			document.getElementById("ofu-cMWM_PrepExpedition").checked = contenu.getAttribute("MenuMWM_PrepExpedition")=="true";
			document.getElementById("ofu-cMWM_InfoArticle").checked = contenu.getAttribute("MenuMWM_InfoArticle")=="true";
			document.getElementById("ofu-cMWM_Inventaire").checked = contenu.getAttribute("MenuMWM_Inventaire")=="true";
			document.getElementById("ofu-cMWM_Inv_Show_SI").checked = contenu.getAttribute("MWM_Inv_Show_SI")=="true";
			document.getElementById("ofu-cMWM_Reception").checked = contenu.getAttribute("MenuMWM_Reception")=="true";
			document.getElementById("ofu-cMWM_Rangement").checked = contenu.getAttribute("MenuMWM_Rangement")=="true";
			document.getElementById("ofu-cMWM_LocCrossDock").checked = contenu.getAttribute("MenuMWM_LocCrossDock")=="true" && ofu_accCrossDock;
			document.getElementById("ofu-cMWM_ExpCrossDock").checked = contenu.getAttribute("MenuMWM_ExpCrossDock")=="true" && ofu_accCrossDock;
			document.getElementById("ofu-cMWM_EntSortStk").checked = contenu.getAttribute("MenuMWM_EntSortStk")=="true";
			document.getElementById("ofu-cMWM_ChangeEmp").checked = contenu.getAttribute("MenuMWM_ChangeEmp")=="true";
			document.getElementById("ofu-cMWM_TransEmp").checked = contenu.getAttribute("MenuMWM_TransEmp")=="true";
			document.getElementById("ofu-cMWM_ConsultEmp").checked = contenu.getAttribute("MenuMWM_ConsultEmp")=="true";
			document.getElementById("ofu-cMWM_RecepRetCli").checked = contenu.getAttribute("MenuMWM_RecepRetCli")=="true";
			document.getElementById("ofu-cMWM_Picking").checked = contenu.getAttribute("MenuMWM_Picking")=="true";
			document.getElementById("ofu-cMWM_Controle_Picking").checked = contenu.getAttribute("MWM_Controle_Picking")=="true";
			document.getElementById("ofu-cMWM_PrepExpress").checked = contenu.getAttribute("MenuMWM_PrepExpress")=="true";
			document.getElementById("ofu-cMWM_Controle").checked = contenu.getAttribute("MenuMWM_Controle")=="true";
			document.getElementById("ofu-cMWM_Impression").checked = contenu.getAttribute("MenuMWM_Impression")=="true";
			document.getElementById("ofu-cMWM_Localisation").checked = contenu.getAttribute("MenuMWM_Localisation")=="true";
			document.getElementById("ofu-cMWM_PEX_Quantite").checked = contenu.getAttribute("MWM_PEX_Quantite")=="true";
			document.getElementById("ofu-cMWM_PEX_Qte_Manquante").checked = contenu.getAttribute("MWM_PEX_Qte_Manquante")=="true";
			document.getElementById("ofu-cMWM_Scan_Borne").checked = contenu.getAttribute("MWM_Scan_Borne")=="true";
			document.getElementById("ofu-cMWM_Info_Art_Chg_Emp").checked = contenu.getAttribute("MWM_Info_Art_Chg_Emp")=="true";

			document.getElementById("ofu-cMaxValidationDC").disabled = !document.getElementById("ofu-cValidationDC").checked;
			document.getElementById("ofu-cModifElemFinFCA").disabled = !document.getElementById("ofu-cModifElemFinDV").checked;
		}

  } catch (e) {
    recup_erreur(e);
  }
}
