/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");


function init() {
  try {

  	window.resizeTo(900,500);

		var qDate = new QueryHttp("GetDates.tmpl");
		document.getElementById('labelAvancement').value = "Etat d'avancement au "+ qDate.execute().responseXML.documentElement.getAttribute("auj");
		chargerAvancement();

		document.getElementById('bQuitter').focus();

  } catch (e) {
    recup_erreur(e);
  }
}


function chargerAvancement() {
  try {

		var XUL_NS = "http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul";

		var qAvancement = new QueryHttp("Compta/Saisie/getEtatAvancement.tmpl");
		qAvancement.setParam("Exercice_Precedent", false);
		var result = qAvancement.execute();
		var listCodeJournal = result.responseXML.documentElement.getAttribute("List_Code_Journal").split(",");
		var listTotalJournal = result.responseXML.documentElement.getAttribute("List_Total_Journal").split(",");
		var listLibellePeriode = result.responseXML.documentElement.getAttribute("List_Libelle_Periode").split(",");
		var listNbOp = result.responseXML.documentElement.getAttribute("List_Nb_Op").split(",");
		var listTotalPeriode = result.responseXML.documentElement.getAttribute("List_Total_Periode").split(",");
		var totalGeneral = result.responseXML.documentElement.getAttribute("Total_General");

		var gridAvancement = document.getElementById('gridAvancement');
		while (gridAvancement.hasChildNodes()) { gridAvancement.removeChild(gridAvancement.firstChild); }

	  var columns = document.createElementNS(XUL_NS, "xul:columns");
	  var column = document.createElementNS(XUL_NS, "xul:column");
	  column.setAttribute("style", "min-width:50px");
	  columns.appendChild(column);
	  for (var i=0; i<listCodeJournal.length; i++) {
	  	column = document.createElementNS(XUL_NS, "xul:column");
	  	column.setAttribute("style", "min-width:50px");
	  	columns.appendChild(column);
	  }
	  column = document.createElementNS(XUL_NS, "xul:column");
  	column.setAttribute("style", "min-width:50px");
	  columns.appendChild(column);
	  gridAvancement.appendChild(columns);
	  var rows = document.createElementNS(XUL_NS, "xul:rows");
	  var row = document.createElementNS(XUL_NS, "xul:row");
	  var label = document.createElementNS(XUL_NS, "xul:label");
	  label.setAttribute("class", "case_entete");
	  label.setAttribute("value", "");
	  row.appendChild(label);
	  for (var i=0; i<listCodeJournal.length; i++) {
		  var codeJournal = listCodeJournal[i];
		  label = document.createElementNS(XUL_NS, "xul:label");
		  label.setAttribute("class", "row_entete");
		  label.setAttribute("value", codeJournal);
		  label.setAttribute("style", "text-align:center;font-weight:bold");
		  row.appendChild(label);
	  }
	  label = document.createElementNS(XUL_NS, "xul:label");
	  label.setAttribute("class", "row_entete");
	  label.setAttribute("value", "Total");
	  label.setAttribute("style", "text-align:center;font-weight:bold");
	  row.appendChild(label);
	  rows.appendChild(row);

	  var rang = 0;
	  for (var i=0; i<listLibellePeriode.length; i++) {
	  	row = document.createElementNS(XUL_NS, "xul:row");
		  var periode = listLibellePeriode[i];
		  var totalPeriode = listTotalPeriode[i];
		  label = document.createElementNS(XUL_NS, "xul:label");
		  label.setAttribute("class", "col_entete");
		  label.setAttribute("value", periode);
		  label.setAttribute("style", "text-align:center;font-weight:bold");
		  row.appendChild(label);
		  for (var j=0; j<listCodeJournal.length; j++) {
		  	var nbOp = listNbOp[rang];
		  	rang++;
		  	label = document.createElementNS(XUL_NS, "xul:label");
			  label.setAttribute("class", "case");
			  label.setAttribute("value", nbOp);
			  label.setAttribute("style", "text-align:right");
			  row.appendChild(label);
		  }
		  label = document.createElementNS(XUL_NS, "xul:label");
		  label.setAttribute("class", "case");
		  label.setAttribute("value", totalPeriode);
		  label.setAttribute("style", "text-align:right");
		  row.appendChild(label);
		  rows.appendChild(row);
	  }

	  row = document.createElementNS(XUL_NS, "xul:row");
	  row.setAttribute("style", "border-bottom: solid 1px");
	  label = document.createElementNS(XUL_NS, "xul:label");
	  label.setAttribute("class", "case_entete");
	  label.setAttribute("value", "Total");
	  label.setAttribute("style", "text-align:center;font-weight:bold");
	  row.appendChild(label);
	  for (var i=0; i<listTotalJournal.length; i++) {
		  var codeJournal = listCodeJournal[i];
		  var nbOp = listTotalJournal[i];
		  label = document.createElementNS(XUL_NS, "xul:label");
		  label.setAttribute("class", "row_case");
		  label.setAttribute("value", nbOp);
		  label.setAttribute("style", "text-align:right");
		  row.appendChild(label);
	  }
	  label = document.createElementNS(XUL_NS, "xul:label");
	  label.setAttribute("class", "row_case");
	  label.setAttribute("value", totalGeneral);
	  label.setAttribute("style", "text-align:right");
	  row.appendChild(label);
	  rows.appendChild(row);
	  gridAvancement.appendChild(rows);

	} catch (e) {
    recup_erreur(e);
  }
}
