/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var opc_currentClasse = -2;
var opc_tabTitresClasse;
var opc_numCompte;
var opc_compteId;
var opc_currentChampCompte;
var opc_currentCodeTVA = "";
var opc_actAnalytique;
var opc_ventilationId;
var opc_compteAnaId;

var opc_aVentilations = new Arbre("Compta/Analytique/Comptes/list-preventilationAnalytique.tmpl", 'opc-treeVentilations');
var opc_aClasses = new Arbre('Compta/Comptes/list-compteByClasse.tmpl', 'opc-Compte');
var opc_qListNC = new QueryHttp("Compta/Comptes/getDataListNC.tmpl");

var opc_pageCourante;
var opc_nbPages;



function opc_init() {
	try {

		opc_activeGroupeVentilation(false);
		opc_chargerTVA("");

		var aPlan = new Arbre('ComboListe/combo-plansComptables.tmpl', 'opc-planComptable');
		aPlan.initTree(opc_initPlan);

		opc_actAnalytique = gConfig.isActAnalytique();
		document.getElementById('opc-groupeVentilation').collapsed = !opc_actAnalytique;
		document.getElementById('opc-numeroAna').readOnly = true;

	} catch (e) {
		recup_erreur(e);
	}
}


function opc_chargerTVA(selection) {
	try {

		opc_currentCodeTVA = selection;
		var aTxTva = new Arbre('ComboListe/combo-tauxTVA.tmpl', 'opc-Code_TVA');
		aTxTva.setParam("Selection", opc_currentCodeTVA);
		aTxTva.initTree(opc_initTva);

	} catch (e) {
		recup_erreur(e);
	}
}


function opc_initTva() {
	try {

		if (isEmpty(opc_currentCodeTVA)) {
			document.getElementById('opc-Code_TVA').selectedIndex = 0;
		}
		else {
			document.getElementById('opc-Code_TVA').value = opc_currentCodeTVA;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function opc_initPlan() {
	try {

		document.getElementById('opc-planComptable').selectedIndex = 0;
		var aDossier = new Arbre("ComboListe/combo-dossiers.tmpl", 'opc-dossier');
		aDossier.initTree(opc_selDossier);

	} catch (e) {
		recup_erreur(e);
	}
}


function opc_selDossier() {
	try {

		document.getElementById("opc-dossier").selectedIndex = 0;
		document.getElementById("opc-Niveau").value = "2";
		opc_nouveauCompte();
		opc_chargerTitresClasse();
		opc_chargerClasse(-2);

	} catch (e) {
		recup_erreur(e);
	}
}


function opc_import_compte() {
	try {

		var dossierId = document.getElementById("opc-dossier").value;
		if (!isEmpty(dossierId)) {

			var dlg = "confirmez-vous la copie des comptes du plan comptable du dossier "+ document.getElementById("opc-dossier").getAttribute("label") + " dans le dossier "+ getProfil().getCodeDossier() +" (import des nouveaux comptes)";
			if (window.confirm(dlg)) {
				var qCopy = new QueryHttp("Compta/Comptes/copyComptes.tmpl");
				qCopy.setParam("Dossier_Id", dossierId);
				var result = qCopy.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					showMessage("La liste des comptes a \u00E9t\u00E9 mise \u00E0 jour");
					opc_init();
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function opc_chargerTitresClasse() {
	try {

		opc_tabTitresClasse = new Array();

		opc_tabTitresClasse.push("Comptes clients");
		opc_tabTitresClasse.push("Comptes fournisseurs");
		opc_tabTitresClasse.push("Comptes auxiliaires");

		var qGet = new QueryHttp("Compta/PlanComptable/getClasseNiveau1.tmpl");
		var result = qGet.execute();

		var classes = result.responseXML.documentElement.getElementsByTagName("classe");

		for (var i=0; i<classes.length; i++) {
			var numClasse = parseInt(classes.item(i).getAttribute('Num_Classe'));
			opc_tabTitresClasse[numClasse+2] = "Classe "+ numClasse +" - "+ classes.item(i).getAttribute('Libelle');
		}

		document.getElementById("opc-titreClasse").value = opc_tabTitresClasse[opc_currentClasse+2];

	} catch (e) {
		recup_erreur(e);
	}
}


function opc_chargerClasse(classe) {
	try {

		opc_currentClasse = classe;
		document.getElementById("opc-titreClasse").value = opc_tabTitresClasse[opc_currentClasse+2];

		if (opc_currentClasse>0) {
			var niveau = document.getElementById("opc-Niveau").value;
			var actif = document.getElementById('opc-filterActif').checked;
			document.getElementById("opc-num").flex = niveau;
			document.getElementById('opc-pagination1').collapsed = true;
			document.getElementById('opc-pagination2').collapsed = true;
			document.getElementById('opc-niveaux').collapsed = false;
			opc_aClasses.setParam("Arborescence", true);
			opc_aClasses.setParam('Actif', actif);
			opc_aClasses.setParam('Niveau', niveau);
			opc_aClasses.setParam('Classe', opc_currentClasse);
			opc_aClasses.initTree();
		}
		else {
			document.getElementById("opc-num").flex = 1;
			document.getElementById('opc-pagination1').collapsed = false;
			document.getElementById('opc-pagination2').collapsed = false;
			document.getElementById('opc-niveaux').collapsed = true;
			opc_listerComptes();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function opc_rechargerClasse() {
	try {

		opc_chargerClasse(opc_currentClasse);

	} catch (e) {
		recup_erreur(e);
	}
}


function opc_listerComptes() {
	try {

		var typeCompte = opc_currentClasse==-2?"C":opc_currentClasse==-1?"F":"A";
		var actif = document.getElementById('opc-filterActif').checked;
		var nbLignesParPage = document.getElementById('opc-nbLignesParPage').value;

		opc_pageCourante = 1;
		opc_nbPages = 1;
		document.getElementById('opc-pageDeb').value = 1;
		document.getElementById('opc-pageFin').value = 1;
		document.getElementById('opc-bPrec').disabled = true;
		document.getElementById('opc-bSuiv').disabled = true;

		document.getElementById('opc-Compte').disabled = true;
		opc_aClasses.deleteTree();

		opc_qListNC.setParam("Actif", actif);
		opc_qListNC.setParam("Type_Compte", typeCompte);
		opc_qListNC.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
		opc_qListNC.setParam("Current_Page", opc_pageCourante);

		var result = opc_qListNC.execute();

		var contenu = result.responseXML.documentElement;

		opc_nbPages = contenu.getAttribute("Nb_Pages");
		var listCompteId = contenu.getAttribute("List_Compte_Id");

		opc_aClasses.setParam("Arborescence", false);
		opc_aClasses.setParam("List_Compte_Id", listCompteId);
		opc_aClasses.initTree(opc_initPagination);

	} catch (e) {
    recup_erreur(e);
  }
}


function opc_initPagination() {
	try {

		document.getElementById('opc-pageDeb').value = opc_pageCourante;
		document.getElementById('opc-pageFin').value = (opc_nbPages>0?opc_nbPages:1);
		document.getElementById('opc-bPrec').disabled = (opc_pageCourante==1);
		document.getElementById('opc-bSuiv').disabled = (opc_pageCourante>=opc_nbPages); // peut se produire si nbPages=0

		opc_afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function opc_pressOnPagePrec() {
	try {

		opc_pageCourante--;
		opc_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function opc_pressOnPageSuiv() {
	try {

		opc_pageCourante++;
		opc_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function opc_majPagination() {
	try {

		document.getElementById('opc-pageDeb').value = opc_pageCourante;
		document.getElementById('opc-bPrec').disabled = (opc_pageCourante==1);
		document.getElementById('opc-bSuiv').disabled = (opc_pageCourante==opc_nbPages);

		document.getElementById('opc-Compte').disabled = true;

		opc_qListNC.setParam("Current_Page", opc_pageCourante);
		var result = opc_qListNC.execute();
		var listCompteId = result.responseXML.documentElement.getAttribute("List_Compte_Id");

		opc_aClasses.setParam("List_Compte_Id", listCompteId);
		opc_aClasses.initTree(opc_afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function opc_afterMajPagination() {
	try {

		document.getElementById('opc-Compte').disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function opc_ouvrirCompte() {
	try {

		if (opc_aClasses.isSelected()) {

			opc_numCompte = opc_aClasses.getSelectedCellText('opc-num');
			opc_compteId = opc_aClasses.getSelectedCellText('opc-colCompteId');

			if (!isEmpty(opc_compteId)) {
				document.getElementById('opc-bSupprimer').disabled = false;
				document.getElementById('opc-numCompte').disabled = true;

				var qLoad = new QueryHttp("Compta/Comptes/loadCompte.tmpl");
				qLoad.setParam("Compte_Id", opc_compteId);
				var result = qLoad.execute();

				var contenu = result.responseXML.documentElement;

				var existeMvts = (contenu.getAttribute('Existe_Mvts')=="true");
				document.getElementById('opc-Type_Compte').disabled = existeMvts;
				document.getElementById('opc-Collectif').disabled = existeMvts;
				document.getElementById('opc-bRechCollectif').disabled = existeMvts;

				document.getElementById('opc-numCompte').value = contenu.getAttribute('Num_Compte');
				document.getElementById('opc-Intitule').value = contenu.getAttribute('Intitule');
				document.getElementById('opc-Type_Compte').value = contenu.getAttribute('Type_Compte');
				opc_pressOnTypeCompte();
				document.getElementById('opc-chkCentralisateur').checked = contenu.getAttribute('Centralisateur')=="true";
				opc_chargerTVA(contenu.getAttribute('Code_TVA'));
				document.getElementById('opc-Cumul_Journal').checked = contenu.getAttribute('Cumul_Journal')=="true";
				document.getElementById('opc-Detail_Cloture').checked = contenu.getAttribute('Detail_Cloture')=="true";
				document.getElementById('opc-Tva_Encaissement').checked = contenu.getAttribute('Tva_Encaissement')=="true";
				document.getElementById('opc-actif').checked = contenu.getAttribute('Actif')=="true";
				document.getElementById('opc-Collectif').value = contenu.getAttribute('Collectif');
				document.getElementById('opc-Contrepartie').value = contenu.getAttribute('Contrepartie');

				opc_leaveNumCompte();

				opc_remplir_tabsoldes();

				// gestion analytique
				if (opc_actAnalytique) {
					opc_aVentilations.deleteTree();
					opc_annulerAna();
					opc_activeGroupeVentilation(false);
					if (opc_isCompteChargeOuProduit(opc_numCompte)) {
						opc_activeGroupeVentilation(true);
						opc_initArbreVentilations();
					}
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function opc_recherche_compte(numCompte,id) {
  try {

  	opc_currentChampCompte = id;
    var url = "chrome://opensi/content/compta/user/comptes/popup-rechercheCompte.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', opc_retourRechercheCompte, numCompte, "", "", "", (id=="opc-Collectif"));

	} catch (e) {
		recup_erreur(e);
	}
}


function opc_retourRechercheCompte(numCompte, compteId) {
	try {

		document.getElementById(opc_currentChampCompte).value = numCompte;

	} catch (e) {
		recup_erreur(e);
	}
}


function opc_remplir_tabsoldes() {
	try {

		var qGet = new QueryHttp("Compta/Comptes/getInfosCompte.tmpl");
		qGet.setParam("Num_Compte", opc_numCompte);
		qGet.setParam("Soldes_N2", true);
		var result = qGet.execute();

		var contenu = result.responseXML.documentElement;

		document.getElementById('opc-debit_compte').value = contenu.getAttribute('Debit_N');
		document.getElementById('opc-credit_compte').value = contenu.getAttribute('Credit_N');

		document.getElementById('opc-old_debit_compte').value = contenu.getAttribute('Debit_N1');
		document.getElementById('opc-old_credit_compte').value = contenu.getAttribute('Credit_N1');

		document.getElementById('opc-old_2_debit_compte').value = contenu.getAttribute('Debit_N2');
		document.getElementById('opc-old_2_credit_compte').value = contenu.getAttribute('Credit_N2');

	} catch (e) {
		recup_erreur(e);
	}
}


function opc_nouveauCompte() {
	try {

		opc_aClasses.clearSelection();

		opc_numCompte = "";
		opc_compteId = "";

		document.getElementById('opc-debit_compte').value = "";
		document.getElementById('opc-credit_compte').value = "";
		document.getElementById('opc-old_debit_compte').value = "";
		document.getElementById('opc-old_credit_compte').value = "";
		document.getElementById('opc-old_2_debit_compte').value = "";
		document.getElementById('opc-old_2_credit_compte').value = "";
		document.getElementById("opc-Detail_Cloture").checked = true;
		document.getElementById("opc-actif").checked = true;
		document.getElementById("opc-Cumul_Journal").checked = false;
		document.getElementById("opc-Tva_Encaissement").checked = false;
		document.getElementById('opc-Contrepartie').value = '';
		document.getElementById('opc-Collectif').value = '';

		document.getElementById('opc-numCompte').disabled = false;
		document.getElementById('opc-numCompte').value = '';

		document.getElementById('opc-Intitule').value = '';

		document.getElementById('opc-bSupprimer').disabled = true;
		opc_chargerTVA("");
		document.getElementById('opc-Type_Compte').value = "G";
		document.getElementById("opc-Type_Compte").disabled = false;
		document.getElementById('opc-Collectif').disabled = false;
		document.getElementById('opc-bRechCollectif').disabled = false;

		opc_pressOnTypeCompte();
		document.getElementById("opc-Tva_Encaissement").collapsed = true;

		// gestion de la compta analytique
		opc_annulerAna();
		opc_initArbreVentilations();
		opc_activeGroupeVentilation(false);

	} catch (e) {
		recup_erreur(e);
	}
}


function opc_leaveNumCompte() {
	try {

		var typeCompte = document.getElementById('opc-Type_Compte').value;
		var numCompte = document.getElementById('opc-numCompte').value;
		var racineCompte = numCompte.substring(0,1);
		document.getElementById("opc-Tva_Encaissement").collapsed = (typeCompte!="G" || (racineCompte!='6' && racineCompte!='7'));

	} catch (e) {
		recup_erreur(e);
	}
}


function opc_supprimerCompte() {
	try {

		if (window.confirm("Confirmez-vous la suppression du compte "+ opc_numCompte +" ?")) {

			var qDelete = new QueryHttp("Compta/Comptes/deleteCompte.tmpl");
			qDelete.setParam("Compte_Id", opc_compteId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("Le compte "+ opc_numCompte+" a \u00E9t\u00E9 supprim\u00E9 avec succ\u00E8s");

				opc_nouveauCompte();
				opc_rechargerClasse();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function opc_enregistrerCompte() {
	try {

		var numCompte = document.getElementById('opc-numCompte').value;
		var intitule = document.getElementById('opc-Intitule').value;
		var actif = document.getElementById('opc-actif').checked;
		var typeCompte = document.getElementById('opc-Type_Compte').value;
		var codeTVA = document.getElementById('opc-Code_TVA').value;
		var cumulJournal = document.getElementById('opc-Cumul_Journal').checked;
		var detailCloture = document.getElementById('opc-Detail_Cloture').checked;
		var tvaEncaissement = document.getElementById('opc-Tva_Encaissement').checked;
		var collectif = document.getElementById('opc-Collectif').value;
		var contrepartie = document.getElementById('opc-Contrepartie').value;
		var creation = (opc_numCompte!=numCompte);

		if (isEmpty(numCompte)) { showWarning("Veuillez saisir un num\u00E9ro de compte !"); }
		else if (isEmpty(intitule)) { showWarning("Veuillez saisir un libell\u00E9 !"); }
		else if (!isCompteCorrect(numCompte)) { showWarning("Le num\u00E9ro de compte est incorrect !"); }
		else if (typeCompte=="G" && (numCompte.charAt(0)<'1' || numCompte.charAt(0)>'7')) { showWarning("Le num\u00E9ro de compte doit commencer par un chiffre de 1 \u00E0 7"); }
		else if (typeCompte!="G" && numCompte.charAt(0)>'0' && numCompte.charAt(0)<'9') { showWarning("Le num\u00E9ro de compte ne doit pas commencer par un chiffre de 1 \u00E0 8"); }
		else if (typeCompte!="G" && !isCompteCorrect(collectif)) { showWarning("Le compte collectif doit \u00EAtre rempli"); }
		else if (typeCompte=="F" && collectif.substr(0,2)!="40") { showWarning("La racine d'un compte collectif fournisseur doit \u00EAtre 40"); }
		else if (typeCompte=="C" && collectif.substr(0,2)!="41") { showWarning("La racine d'un compte collectif client doit \u00EAtre 41"); }
		else if (typeCompte=="A" && (collectif.substr(0,2)=="40" || collectif.substr(0,2)=="41")) { showWarning("La racine d'un compte collectif auxiliaire ne doit pas \u00EAtre 40 ni 41"); }

		else if (window.confirm("Confirmez-vous l'enregistrement du compte '"+ numCompte +"' ?")) {

			var qSave = new QueryHttp("Compta/Comptes/saveCompte.tmpl");

			qSave.setParam('Num_Compte', numCompte);
			qSave.setParam('Intitule', intitule);
			qSave.setParam('Actif', actif);
			qSave.setParam('Type_Compte', typeCompte);
			qSave.setParam('Code_TVA', codeTVA);
			qSave.setParam('Cumul_Journal', cumulJournal);
			qSave.setParam('Detail_Cloture', detailCloture);
			qSave.setParam('Collectif', collectif);
			qSave.setParam('Contrepartie', contrepartie);
			qSave.setParam('Tva_Encaissement', tvaEncaissement);
			qSave.setParam('Creation', creation);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				opc_nouveauCompte();
				opc_rechargerClasse();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function opc_enregistrerPlan() {
	try {

		var planComptable = document.getElementById('opc-planComptable').value;

		var qUpdate = new QueryHttp("Compta/PlanComptable/setPlanComptable.tmpl");
		qUpdate.setParam("Plan_Comptable", planComptable);
		var result = qUpdate.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}

		opc_chargerTitresClasse();
		opc_chargerClasse(-2);

	} catch (e) {
		recup_erreur(e);
	}
}


function opc_pressOnTypeCompte() {
	try {

		var typeCompte = document.getElementById('opc-Type_Compte').value;
		document.getElementById('opc-Collectif').value = "";
		document.getElementById('opc-rCollectif').collapsed = (typeCompte=="G");
		document.getElementById('opc-lblCollectif').collapsed = (typeCompte=="G");

		if (typeCompte=="C") {
			document.getElementById('opc-Collectif').value = gConfig.getCollectifClient();
		}
		else if (typeCompte=="F") {
			document.getElementById('opc-Collectif').value = gConfig.getCollectifFournisseur();
		}

		document.getElementById('opc-Detail_Cloture').checked = true;
		document.getElementById('opc-Detail_Cloture').collapsed = (typeCompte=="G");

		document.getElementById('opc-chkCentralisateur').checked = false;
		document.getElementById('opc-chkCentralisateur').collapsed = (typeCompte!="G");

		document.getElementById('opc-Contrepartie').value = "";
		document.getElementById("opc-rContrepartie").collapsed = (typeCompte=="G");
		document.getElementById("opc-lblContrepartie").collapsed = (typeCompte=="G");

		opc_leaveNumCompte();

	} catch (e) {
		recup_erreur(e);
	}
}


function opc_isCompteChargeOuProduit(num) {
	try {

		var val = num.toString();
    return (val.charAt(0)=='6' || val.charAt(0)=='7');

	} catch (e) {
		recup_erreur(e);
	}
}


function opc_activeGroupeVentilation(boolean) {
	try {

		document.getElementById('opc-treeVentilations').disabled = !boolean;
		opc_activeFlechesVentilation(boolean);
		opc_activeMenuVentilation(boolean);

	} catch (e) {
		recup_erreur(e);
	}
}


function opc_activeFlechesVentilation(boolean) {
	try {

		document.getElementById('opc-bFlecheHaut').disabled = !boolean || opc_aVentilations.getCurrentIndex()==-1 || opc_aVentilations.getCurrentIndex()==0;
		document.getElementById('opc-bFlecheBas').disabled = !boolean || opc_aVentilations.getCurrentIndex()==-1 || opc_aVentilations.getCurrentIndex()==(opc_aVentilations.nbLignes()-1);

	} catch (e) {
		recup_erreur(e);
	}
}


function opc_activeMenuVentilation(boolean) {
	try {

		document.getElementById('opc-numeroAna').disabled = !boolean;
		document.getElementById('opc-bRechercheCompteAna').disabled = !boolean;
		document.getElementById('opc-libelleAna').disabled = !boolean;
		document.getElementById('opc-ventilation').disabled = !boolean;
		document.getElementById('opc-bAnnulerAna').disabled = !boolean;
		document.getElementById('opc-bValiderAna').disabled = !boolean || opc_compteAnaId==0;
		document.getElementById('opc-bSupprimerAna').disabled = !boolean || opc_ventilationId==0;

	} catch (e) {
		recup_erreur(e);
	}
}


function opc_initArbreVentilations() {
	try {

		if (!isEmpty(opc_compteId)) {
			opc_aVentilations.setParam("Compte_Gen", opc_compteId);
			opc_aVentilations.initTree();
		}
		else {
			opc_aVentilations.deleteTree();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function opc_selectOnTreeVentilation() {
	try {

		if (opc_aVentilations.isSelected()) {
			var index = opc_aVentilations.getCurrentIndex();

			opc_ventilationId = opc_aVentilations.getCellText(index,'opc-colVentilationId');
			opc_compteAnaId = opc_aVentilations.getCellText(index,'opc-colCompteAnaId');

			document.getElementById('opc-numeroAna').value = opc_aVentilations.getCellText(index,'opc-colNumeroAna');
			document.getElementById('opc-libelleAna').value = opc_aVentilations.getCellText(index,'opc-colLibelleAna');
			document.getElementById('opc-ventilation').value = opc_aVentilations.getCellText(index,'opc-colVentilation');

			opc_activeMenuVentilation(true);
			opc_activeFlechesVentilation(true);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function opc_deplacerLigneHaut() {
	try {

		opc_activeFlechesVentilation(false);

		var qMove = new QueryHttp("Compta/Analytique/Comptes/saveVentilationRank.tmpl");
		qMove.setParam("Ventilation_Id", opc_ventilationId);
		qMove.setParam("Sens", "Haut");

		var result = qMove.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			opc_aVentilations.initTree();
			opc_annulerAna();
			opc_activeMenuVentilation(true);
		}

		opc_activeFlechesVentilation(true);

	} catch (e) {
		recup_erreur(e);
	}
}


function opc_deplacerLigneBas() {
	try {

		opc_activeFlechesVentilation(false);

		var qMove = new QueryHttp("Compta/Analytique/Comptes/saveVentilationRank.tmpl");
		qMove.setParam("Ventilation_Id", opc_ventilationId);
		qMove.setParam("Sens", "Bas");
		var result = qMove.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			opc_aVentilations.initTree();
			opc_annulerAna();
			opc_activeMenuVentilation(true);
		}

		opc_activeFlechesVentilation(true);

	} catch (e) {
		recup_erreur(e);
	}
}


function opc_pressOnRechercheCompteAna() {
	try {

		opc_activeMenuVentilation(false);
		opc_rechercheCompteAna(document.getElementById('opc-numeroAna').value);

	} catch (e) {
		recup_erreur(e);
	}
}


function opc_rechercheCompteAna(numCompte) {
	try {

		var url = "chrome://opensi/content/compta/user/analytique/comptes/popup-rechercheCompteAnalytique.xul";
   	window.openDialog(url,'','chrome,modal,centerscreen', opc_finRechercheCompteAna, numCompte);
   	opc_activeMenuVentilation(true);

	} catch (e) {
		recup_erreur(e);
	}
}


function opc_finRechercheCompteAna(compteId, numCompte) {
	try {

		opc_compteAnaId = compteId;
		document.getElementById('opc-numeroAna').value = numCompte;

		var qGet = new QueryHttp("Compta/Analytique/Comptes/getIntitule.tmpl");
		qGet.setParam("Compte_Id", opc_compteAnaId);
		var result = qGet.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
			opc_annulerAna();
		}
		else {
			document.getElementById('opc-libelleAna').value = result.responseXML.documentElement.getAttribute('Intitule');
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function opc_pressOnAnnulerAna() {
	try {

		opc_activeMenuVentilation(false);
		opc_annulerAna();
		opc_activeFlechesVentilation(true);
		opc_activeMenuVentilation(true);

	} catch (e) {
		recup_erreur(e);
	}
}


function opc_pressOnValiderAna() {
	try {

		if (isEmpty(document.getElementById('opc-libelleAna'))) { showWarning("Libell\u00E9 incorrect"); }
		else if (!checkNumber(document.getElementById('opc-ventilation').value, 7, 2)) { showWarning("Ventilation incorrecte"); }
		else if (document.getElementById('opc-ventilation').value==0) { showWarning("Ventilation incorrecte"); }
		else {
			opc_activeMenuVentilation(false);
			opc_saveAna();
			opc_activeFlechesVentilation(true);
			opc_activeMenuVentilation(true);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function opc_pressOnSupprimerAna() {
	try {

		opc_activeMenuVentilation(false);
		opc_deleteAna();
		opc_activeFlechesVentilation(true);
		opc_activeMenuVentilation(true);

	} catch (e) {
		recup_erreur(e);
	}
}


function opc_annulerAna() {
	try {

		opc_ventilationId = 0;
		opc_compteAnaId = 0;

		document.getElementById('opc-numeroAna').value = "";
		document.getElementById('opc-libelleAna').value = "";
		document.getElementById('opc-ventilation').value = "";

		opc_aVentilations.clearSelection();

	} catch (e) {
		recup_erreur(e);
	}
}


function opc_saveAna() {
	try {

		var qSave = new QueryHttp("Compta/Analytique/Comptes/saveVentilation.tmpl");

		qSave.setParam("Ventilation_Id", opc_ventilationId);
		qSave.setParam("Compte_Gen", opc_numCompte);
		qSave.setParam("Compte_Ana", opc_compteAnaId);
		qSave.setParam("Libelle", document.getElementById('opc-libelleAna').value);
		qSave.setParam("Ventilation", document.getElementById('opc-ventilation').value);

		var result = qSave.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			opc_aVentilations.initTree();
			opc_annulerAna();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function opc_deleteAna() {
	try {

		var qDelete = new QueryHttp("Compta/Analytique/Comptes/deleteVentilation.tmpl");
		qDelete.setParam("Ventilation_Id", opc_ventilationId);
		var result = qDelete.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			opc_aVentilations.initTree();
			opc_annulerAna();
		}

	} catch (e) {
		recup_erreur(e);
	}
}
