/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");



function init() {
	try {
		
		var qGet = new QueryHttp("Compta/Exercice/getDatesExercice.tmpl");
		qGet.setParam("Sel_Exercice", "D");
		var result = qGet.execute();

		var debut = result.responseXML.documentElement.getAttribute('Debut_Exercice');
		var fin = result.responseXML.documentElement.getAttribute('Fin_Exercice');

		document.getElementById("Ancien_Exercice").value = "Ancien Exercice: Du "+ debut +" au "+ fin;

		document.getElementById('Date_Fin').value = fin.substring(0,6)+(parseIntBis(fin.substring(6,10))+1);
		document.getElementById("Date_Fin").focus();

		var aJAN = new Arbre('ComboListe/combo-journaux.tmpl', 'JournalAN');
		aJAN.setParam('Type_Journal', 'AN');
		aJAN.initTree(selectJournalAN);

	} catch (e) {
    recup_erreur(e);
  }
}


function selectJournalAN() {
	try {

    document.getElementById('JournalAN').selectedIndex = 0;

	} catch (e) {
    recup_erreur(e);
  }
}


function createExercice() {
	try {

		var date_fin = document.getElementById('Date_Fin').value;
		var journal_an = document.getElementById('JournalAN').value;

		if (isEmpty(journal_an)) {
			showWarning("Impossible de cr\u00E9er l'exercice, aucun journal d'A Nouveau disponible !");
		}
		else if (isEmpty(date_fin)) {
			showWarning("Vous devez sp\u00E9cifier une date de fin d'exercice !");
  	}
		else if (!isDate(date_fin)) {
			showWarning("Date de fin d'exercice incorrecte !");
		}
		else {
			document.getElementById('bOk').disabled = true;
			document.getElementById('progression').collapsed = false;
			document.getElementById('pm').setAttribute("mode", "undetermined");

			var qCreate = new QueryHttp("Compta/UpdateDatabase/CreerExercice.tmpl");
			qCreate.setParam('Fin_Exercice', date_fin);
			qCreate.setParam('JournalAN', journal_an);
			var result = qCreate.execute();

			document.getElementById('progression').collapsed = true;
			document.getElementById('pm').setAttribute("mode", "none");

			var errors = new Errors(result);

			if (errors.hasNext()) {
				errors.show();
				document.getElementById('Date_Fin').focus();
				document.getElementById('bOk').disabled = false;
			}
			else {
    		showMessage("Le nouvel exercice a \u00E9t\u00E9 cr\u00E9\u00E9 avec succ\u00E9s");
				retourMenuExercice();
  		}
    }

	} catch (e) {
    recup_erreur(e);
  }
}


function retourMenuExercice() {
	try {

  	window.location = "chrome://opensi/content/compta/user/menu_dossier.xul?"+ cookie();

	} catch (e) {
    recup_erreur(e);
  }
}


function retourChoixDossier() {
  try {

    window.location = "chrome://opensi/content/compta/user/menu.xul?"+ cookie();

  } catch (e) {
    recup_erreur(e);
  }
}

