/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");


var lastFichierPDF = null;



function init() {
  try {

		document.getElementById('typePeriode').value = "E";
		document.getElementById('detail').checked = false;
		document.getElementById('comparatif').checked = true;
		document.getElementById('proratisation').checked = false;
		document.getElementById('sansCodeDossier').checked = false;
		document.getElementById('sansDateHeure').checked = false;
		document.getElementById('projet').checked = false;

  } catch (e) {
    recup_erreur(e);
  }
}


function pressOnTypePeriode() {
	try {

		var typePeriode = document.getElementById("typePeriode").value;

		if (typePeriode=='E') {
			document.getElementById('dateFin').disabled = true;
			document.getElementById('dateFin').value = "";
		}
		else {
			document.getElementById('dateFin').disabled = false;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function pressOnComparatif() {
	try {

		document.getElementById("proratisation").disabled = !document.getElementById("comparatif").checked;

	} catch (e) {
    recup_erreur(e);
  }
}


function editionPDF() {
	try {

		var dateFin = document.getElementById('dateFin').value;
		var typePeriode = document.getElementById('typePeriode').value;
		var detail = document.getElementById('detail').checked;
		var comparatif = document.getElementById('comparatif').checked;
		var proratisation = document.getElementById('proratisation').checked;
		var sansCodeDossier = document.getElementById('sansCodeDossier').checked;
		var sansDateHeure = document.getElementById('sansDateHeure').checked;
		var projet = document.getElementById('projet').checked;

		if (typePeriode=="D" && !isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date de fin de p\u00E9riode incorrecte"); }
		else {
			document.getElementById('pmbox').collapsed = false;
			document.getElementById('pm').setAttribute('mode', 'undetermined');

			document.getElementById('pdfResultat').setAttribute("src", "");
			lastFichierPDF = null;

			var qEditionPdf = new QueryHttp("Compta/Editions/pdfCompteResultat.tmpl");

			qEditionPdf.setParam("Date_Fin", dateFin);
			qEditionPdf.setParam("Detail", detail);
			qEditionPdf.setParam("Comparatif", comparatif);
			qEditionPdf.setParam("Proratisation", proratisation);
			qEditionPdf.setParam("Sans_Code_Dossier", sansCodeDossier);
			qEditionPdf.setParam("Sans_Date_Heure", sansDateHeure);
			qEditionPdf.setParam("Projet", projet);

			qEditionPdf.execute(editionPDF_2);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function editionPDF_2(result) {
	try {

		document.getElementById('pmbox').collapsed = true;
		document.getElementById('pm').setAttribute('mode', 'none');

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var fichierPDF = result.responseXML.documentElement.getAttribute('FichierPDF');
			var page = getDirPdf() + fichierPDF;
			document.getElementById('pdfResultat').setAttribute("src", page);

			document.getElementById('deck').selectedIndex = 1;
			document.getElementById('bRetourOptions').collapsed = false;

			lastFichierPDF = fichierPDF;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function envoyerMail() {
	try {

		if (lastFichierPDF!=null) {
			var url = "chrome://opensi/content/popup/popup-envoyerMail.xul";
			window.openDialog(url,'','chrome,modal,centerscreen', "CGCR", lastFichierPDF);
		}

	}	catch (e) {
    recup_erreur(e);
  }
}


function retourOptions() {
  try {

		document.getElementById('pdfResultat').setAttribute("src", "");
   	document.getElementById('deck').selectedIndex = 0;
		document.getElementById('bRetourOptions').collapsed = true;

  } catch (e) {
    recup_erreur(e);
  }
}


function retourMenuPrincipal() {
  try {

    window.location = "chrome://opensi/content/compta/user/menu_exercice.xul";

	} catch (e) {
    recup_erreur(e);
  }
}
