/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");


var aExos = new Arbre('Compta/list-exercices.tmpl', 'tree-exercices');



function init() {
  try {

		aExos.initTree(focus_tree);

		parent.document.getElementById("boxExercice").collapsed = true;
		parent.document.getElementById("date_exercice").value = "";

  } catch (e) {
    recup_erreur(e);
  }
}


function focus_tree() {
  try {

    aExos.select(0);

  } catch (e) {
    recup_erreur(e);
  }
}


function nouvel_exercice() {
  try {

		var qGet = new QueryHttp("Compta/Exercice/getNbExerciceOuvert.tmpl");
	  var result = qGet.execute();

		var nbExosOuverts = result.responseXML.documentElement.getAttribute('Nb_Exercice_Ouvert');

		if (nbExosOuverts<2) {
  	  window.location = "chrome://opensi/content/compta/user/creer_exercice.xul?"+ cookie();
	  }
		else {
		  showWarning("Impossible d'ouvrir un nouvel exercice ! Vous devez cl\u00F4turer l'exercice pr\u00E9c\u00E9dent");
    }

	} catch (e) {
    recup_erreur(e);
  }
}


function ok() {
  try {

		if (aExos.isSelected()) {
    	var libelle = aExos.getSelectedCellText("colLibelle");
			var exerciceId = aExos.getSelectedCellText("colExerciceId");

			var qEnterExercice = new QueryHttp("EnterExercice.tmpl");
			qEnterExercice.setParam('Exercice_Id', exerciceId);
			qEnterExercice.execute();

			getProfil().setExerciceId(exerciceId);

			parent.document.getElementById("date_exercice").value = "Exercice "+ libelle;
			parent.document.getElementById("boxExercice").collapsed = false;
    	window.location = "chrome://opensi/content/compta/user/control_coherence.xul?"+ cookie();
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function keypress(e) {
  try {

    switch(e.keyCode){
      case 13:	ok();	break;
      case 78:	nouvel_exercice(); break;
    }

	} catch (e) {
    recup_erreur(e);
  }
}


function retourChoixDossier() {
  try {

    window.location = "chrome://opensi/content/compta/user/menu.xul?"+ cookie();

  } catch (e) {
    recup_erreur(e);
  }
}
