/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");


var suiviLoaded = false;



function init() {
  try {

		var profil = getProfil();

		document.getElementById('tabSuivi').collapsed = !profil.isDirection();

		var qGet = new QueryHttp("Compta/Exercice/isCloturable.tmpl");
		var result = qGet.execute();
		var cloturable = result.responseXML.documentElement.getAttribute('Cloturable')=="true";

		var actAnalytique = getConfig().isActAnalytique();

		document.getElementById('CSaisie').collapsed = !profil.isMenuCG_CSaisie();
		document.getElementById('CRevision').collapsed = !profil.isMenuCG_CRevision();
		document.getElementById('CTransCop').collapsed = !profil.isMenuCG_CTransCop();
		document.getElementById('CRappro').collapsed = !profil.isMenuCG_CRappro();
		document.getElementById('CClotMens').collapsed = !profil.isMenuCG_CClotMens();
		document.getElementById('CClotExo').collapsed = !profil.isMenuCG_CClotExo() || !cloturable;
		document.getElementById('EBalance').collapsed = !profil.isMenuCG_EBalance();
		document.getElementById('ECentral').collapsed = !profil.isMenuCG_ECentral();
		document.getElementById('EGdLivre').collapsed = !profil.isMenuCG_EGdLivre();
		document.getElementById('EJournaux').collapsed = !profil.isMenuCG_EJournaux();
		document.getElementById('EBalAgee').collapsed = !profil.isMenuCG_EBalAgee();
		document.getElementById('EBilan').collapsed = !profil.isMenuCG_EBilan();
		document.getElementById('EResultat').collapsed = !profil.isMenuCG_EResultat();
		document.getElementById('ESoldes').collapsed = !profil.isMenuCG_ESoldes();
		document.getElementById('EPlanCpte').collapsed = !profil.isMenuCG_EPlanCpte();
		document.getElementById('SBordGest').collapsed = !profil.isMenuCG_SBordGest();
		document.getElementById('SBordTres').collapsed = !profil.isMenuCG_SBordTres();
		document.getElementById('AComptes').collapsed = !profil.isMenuCG_AComptes();
		document.getElementById('AGdLivre').collapsed = !profil.isMenuCG_AGdLivre();
		document.getElementById('AParametrages').collapsed = !profil.isMenuCG_AParametrages();
		document.getElementById('DComptes').collapsed = !profil.isMenuCG_DComptes();
		document.getElementById('DAboEcr').collapsed = !profil.isMenuCG_DAboEcr();
		document.getElementById('DModeles').collapsed = !profil.isMenuCG_DModeles();
		document.getElementById('DImpBanque').collapsed = !profil.isMenuCG_DImpBanque();
		document.getElementById('DImpExpEcr').collapsed = !profil.isMenuCG_DImpExpEcr();
		document.getElementById('DPassword').collapsed = !profil.isMenuCG_DPassword();

		document.getElementById('bouton_comptabilite').collapsed = document.getElementById('CSaisie').collapsed && document.getElementById('CRevision').collapsed && document.getElementById('CTransCop').collapsed
																													&& document.getElementById('CRappro').collapsed && document.getElementById('CClotMens').collapsed && document.getElementById('CClotExo').collapsed;

		document.getElementById('bouton_editions').collapsed = document.getElementById('EBalance').collapsed && document.getElementById('ECentral').collapsed && document.getElementById('EGdLivre').collapsed
																													&& document.getElementById('EJournaux').collapsed && document.getElementById('EBalAgee').collapsed && document.getElementById('EBilan').collapsed
																													&& document.getElementById('EResultat').collapsed && document.getElementById('ESoldes').collapsed && document.getElementById('EPlanCpte').collapsed;

		document.getElementById('bouton_suiviactivite').collapsed = document.getElementById('SBordGest').collapsed && document.getElementById('SBordTres').collapsed;

		document.getElementById('bouton_analytique').collapsed = !actAnalytique || (document.getElementById('AComptes').collapsed && document.getElementById('AGdLivre').collapsed && document.getElementById('AParametrages').collapsed);

		document.getElementById('bouton_opdiv').collapsed = document.getElementById('DComptes').collapsed && document.getElementById('DAboEcr').collapsed && document.getElementById('DModeles').collapsed
																													&& document.getElementById('DImpBanque').collapsed && document.getElementById('DImpExpEcr').collapsed && document.getElementById('DPassword').collapsed;

		initAlertes();

		document.getElementById('news').setAttribute("src", "https://connect.opensi.fr/actus-frame");

  } catch (e) {
    recup_erreur(e);
  }
}


function initAlertes() {
	try {

		var queryMessages = new QueryHttp("Commun/checkMessages.tmpl");
		var result = queryMessages.execute();
		var message = parseIntBis(result.responseXML.documentElement.getAttribute('Nb_Messages'))>0;

		if (message) {
			var aMessages = new Arbre("Commun/list-messages.tmpl", "boxMessages");
			aMessages.initTree();

			document.getElementById('tabMessages').collapsed = false;
			document.getElementById('tbActivite').selectedIndex = 2;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function initSuivi() {
  try {

		if (!suiviLoaded) {

			suiviLoaded = true;

			var querySuivi = new QueryHttp("Compta/getSuiviActiviteCG.tmpl");
			var result = querySuivi.execute();

    	var contenu = result.responseXML.documentElement;

			document.getElementById('SoldeTresorerie').value = contenu.getAttribute('Solde_Tresorerie') +" \u20AC";
			document.getElementById('TotalCAN').value = contenu.getAttribute('Total_CAN') +" \u20AC";

			document.getElementById('GraphCA').setAttribute("src", getDirGraph() + contenu.getAttribute('Image_Graph_CA'));
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function goToMenu(m) {
  try {

		switch(m) {
			case 1:		window.location = "chrome://opensi/content/compta/user/saisie/menuSaisie.xul";														break;
			case 2:		window.location = "chrome://opensi/content/compta/user/consultation/menu_consultation.xul";								break;
			case 3:		window.location = "chrome://opensi/content/compta/user/autres/cp_journaux.xul";														break;
			case 4:		window.location = "chrome://opensi/content/compta/user/rapprochement_bancaire/gestionRapprochement.xul";	break;
			case 5:		window.location = "chrome://opensi/content/compta/user/cloture/options_cloture.xul";											break;
			case 6:		window.location = "chrome://opensi/content/compta/user/edition/options_balance.xul";											break;
			case 7:		window.location = "chrome://opensi/content/compta/user/edition/options_centralisateur.xul";								break;
			case 8:		window.location = "chrome://opensi/content/compta/user/edition/options_grandlivre.xul";										break;
			case 9:		window.location = "chrome://opensi/content/compta/user/edition/options_journaux.xul";											break;
			case 10:	window.location = "chrome://opensi/content/compta/user/edition/options_balanceagee.xul";									break;
			case 11:	window.location = "chrome://opensi/content/compta/user/edition/options_bilan.xul";												break;
			case 12:	window.location = "chrome://opensi/content/compta/user/edition/options_resultat.xul";											break;
			case 13:	window.location = "chrome://opensi/content/compta/user/edition/options_sig.xul";													break;
			case 14:	window.location = "chrome://opensi/content/compta/user/tab_bord/gestion.xul";															break;
			case 15:	window.location = "chrome://opensi/content/compta/user/tab_bord/tresorerie.xul";													break;
			case 20:	window.location = "chrome://opensi/content/compta/user/config/menu_comptabilite.xul";											break;
			case 23:	window.location = "chrome://opensi/content/compta/user/autres/change_user_password.xul";									break;
			case 24:	window.location = "chrome://opensi/content/compta/user/edition/options_plancomptable.xul";								break;
			case 25:	window.location = "chrome://opensi/content/compta/user/cloture/optionsClotureMois.xul";										break;
			case 26:	window.location = "chrome://opensi/content/compta/user/abonnementsecriture/gestionAbonnements.xul";				break;
			case 27:	window.location = "chrome://opensi/content/compta/user/modelesecriture/gestionModeles.xul";								break;
			case 28:	window.location = "chrome://opensi/content/compta/user/import_banque/importBanque.xul";										break;
			case 29:	window.location = "chrome://opensi/content/compta/user/analytique/parametrages/parametrages.xul";					break;
			case 30:	window.location = "chrome://opensi/content/compta/user/analytique/comptes/gestionComptes.xul";						break;
			case 31:	window.location = "chrome://opensi/content/compta/user/analytique/editions/editionGrandLivre.xul";				break;
			case 34:	window.location = "chrome://opensi/content/compta/user/autres/import_export.xul";													break;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function ouvrirSousMenu(idSM) {
  try {

		document.getElementById('smComptabilite').collapsed = true;
		document.getElementById('smEditions').collapsed = true;
		document.getElementById('smSA').collapsed = true;
		document.getElementById('smAna').collapsed = true;
		document.getElementById('smOD').collapsed = true;

		document.getElementById(idSM).collapsed = false;

	} catch (e) {
    recup_erreur(e);
  }
}


function retourMenuExercice() {
  try {

    window.location = "chrome://opensi/content/compta/user/menu_dossier.xul?"+ cookie();

  } catch (e) {
    recup_erreur(e);
  }
}


function retourChoixDossier() {
  try {

    window.location = "chrome://opensi/content/compta/user/menu.xul?"+ cookie();

  } catch (e) {
    recup_erreur(e);
  }
}
