/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");


var aModeles = new Arbre("Compta/ModelesEcriture/list-modeleEcriture.tmpl", "listeModeles");
var aLignes = new Arbre("Compta/ModelesEcriture/list-ligneModeleEcriture.tmpl", "listeLignes");



function init() {
	try {

		aModeles.setParam("Only_Valide", true);
 		aModeles.initTree();

	} catch (e) {
		recup_erreur(e);
	}
}


function selectOnListeModele() {
	try {

 		if (aModeles.isSelected()) {
			aLignes.setParam("Modele_Id", aModeles.getSelectedCellText("colModeleId"));
			aLignes.initTree();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnTree(ev) {
  try {

    if (ev.keyCode==13) {
			ouvrirModele();
  	}

  } catch (e) {
    recup_erreur(e);
  }
}


function ouvrirModele() {
	try {

		if (aModeles.isSelected()) {
			window.arguments[0](aModeles.getSelectedCellText("colModeleId"));
			setTimeout("window.close()",0); // pour fermeture si fonction appele d'un autre popup
		}

	} catch (e) {
		recup_erreur(e);
	}
}

