/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arrondi.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/formatter.js");
jsLoader.loadSubScript("chrome://opensi/content/compta/user/saisie/ligneVentilation.js");


XUL_NS = "http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul";

var rd2 = new Arrondi(2);
var nf = new NumberFormat("0.00", true);

var montantInit = 0;
var lock = false;
var wTreeLignes;
var index = -1;
var radio = 1;
var id;
var numero;
var modif;



function init() {
	try {

		modif = false;
		lock = (window.arguments[2]=="true");
		activeAll(!lock);

		wTreeLignes = document.getElementById('treeVentilations');

		document.getElementById('totalMontant').readOnly = true;
		document.getElementById('totalPourcentage').readOnly = true;

		// verif montant
		montantInit = window.arguments[1];
		montantInit = isEmpty(montantInit)?0:parseFloat(montantInit);
		collapseMenu();

		// rcupration des lignes d'origine
		var tab = window.arguments[3];
		var bPourcentage = false;
		for (var i=0; i<tab.length; i++) {
			var ligne = new Ligne();
			ligne.id = tab[i].id;
			ligne.numero = tab[i].numero;
			ligne.intitule = tab[i].intitule;
			var montant = tab[i].montant;
			montant = isEmpty(montant)?0:parseFloat(montant);
			var pourcentage = tab[i].pourcentage;
			pourcentage = isEmpty(pourcentage)?0:parseFloat(pourcentage);
			ligne.pourcentage = pourcentage;
			if (pourcentage!=0) {
				ligne.montant = rd2.round(tab[i].pourcentage*montantInit/100);
				bPourcentage = true;
			} else {
				ligne.montant = tab[i].montant;
			}
			createLigne(ligne);
		}

		if (tab.length==0 || bPourcentage) {
			// nouvelle ventilation ou presence pourcentage
			radio = 1;
		} else {
			// ventilation connue et pas de pourcentages
			radio = 2;
		}
		document.getElementById('modeSaisie').value = radio;

		collapseMenu();
		majTotaux();

		document.getElementById('numero').focus();

		window.parent.addEventListener("close",fermerPopup, false);

	} catch (e) {
		recup_erreur(e);
	}
}


function collapseMenu() {
	try {
		annulerSaisie();
		// pourcentage (radio=1)
		document.getElementById('colTxtPourcentage').collapsed = (radio=="2");
		document.getElementById('boxTP').collapsed = (radio=="2");
		document.getElementById('colSaisiePourcentage').collapsed = (radio=="2");
		document.getElementById('lblPourcentage').collapsed = (radio=="2");
		document.getElementById('pourcentage').collapsed = (radio=="2");
		document.getElementById('symbole').collapsed = (radio=="2");
		// montant (radio=2)
		document.getElementById('colTxtMontant').collapsed = !((radio=="2")||(montantInit!=0));
		document.getElementById('boxTM').collapsed = !((radio=="2")||(montantInit!=0));
		document.getElementById('colSaisieMontant').collapsed = (radio=="1");
		document.getElementById('lblMontant').collapsed = (radio=="1");
		document.getElementById('montant').collapsed = (radio=="1");
		document.getElementById('montant').readOnly = (radio=="1");
	} catch (e) {
		recup_erreur(e);
	}
}

function activeAll(boolean) {
	try {
		document.getElementById('treeVentilations').disabled = lock || !boolean;
		document.getElementById('modeSaisie').disabled = lock || !boolean;
		document.getElementById('totalMontant').disabled = lock || !boolean;
		document.getElementById('totalPourcentage').disabled = lock || !boolean;
		activeSaisie(boolean);
	} catch (e) {
		recup_erreur(e);
	}
}

function activeSaisie(boolean) {
	try {
		document.getElementById('numero').disabled = lock || !boolean;
		document.getElementById('libelle').disabled = lock || !boolean;
		document.getElementById('montant').disabled = lock || !boolean;
		document.getElementById('pourcentage').disabled = lock || !boolean;
		document.getElementById('bAnnuler').disabled = lock || !boolean;
		document.getElementById('bValider').disabled = lock || !boolean;
		document.getElementById('bSupprimer').disabled = lock || !boolean;
	} catch (e) {
		recup_erreur(e);
	}
}

function majTotaux() {
	try {
		var montantTotal = 0;
		var pourcentageTotal = 0;
		for (var i=0; i<wTreeLignes.view.rowCount; i++) {
			var montant = wTreeLignes.view.getCellText(i,wTreeLignes.columns.getColumnAt(4));
			var pourcentage = wTreeLignes.view.getCellText(i,wTreeLignes.columns.getColumnAt(6));
			if (!isEmpty(montant)) {
				montantTotal += parseFloat(montant);
			}
			if (!isEmpty(pourcentage)) {
				pourcentageTotal += parseFloat(pourcentage);
			}
		}
		if (montantTotal!=0) {
			document.getElementById('totalMontant').value = nf.format(rd2.round(montantTotal));
		} else {
			document.getElementById('totalMontant').value = "";
		}
		if (pourcentageTotal!=0) {
			document.getElementById('totalPourcentage').value = percentToText(rd2.round(pourcentageTotal));
		} else {
			document.getElementById('totalPourcentage').value = "";
		}
	} catch (e) {
		recup_erreur(e);
	}
}

function percentToText(val) {
	try {
		var text = "";
		if (val!=0) {
			text = nf.format(val)+"%";
		}
		return text;
	} catch (e) {
		recup_erreur(e);
	}
}

function selectOnTreeVentilations() {
	try {
		index = wTreeLignes.currentIndex;
		if (index!=-1) {
			id = wTreeLignes.view.getCellText(index,wTreeLignes.columns.getColumnAt(0));
			numero = wTreeLignes.view.getCellText(index,wTreeLignes.columns.getColumnAt(1));
			document.getElementById('numero').value = numero;
			document.getElementById('libelle').value = wTreeLignes.view.getCellText(index,wTreeLignes.columns.getColumnAt(2));
			var montant = wTreeLignes.view.getCellText(index,wTreeLignes.columns.getColumnAt(4));
			document.getElementById('montant').value = (isEmpty(montant) || parseFloat(montant)==0)?"":montant;
			var pourcentage = wTreeLignes.view.getCellText(index,wTreeLignes.columns.getColumnAt(6));
			document.getElementById('pourcentage').value = (isEmpty(pourcentage) || parseFloat(pourcentage)==0)?"":pourcentage;
		}
	} catch (e) {
		recup_erreur(e);
	}
}

function pressOnModeSaisie() {
	try {
		modif = true;
		var newRadio = document.getElementById('modeSaisie').value;
		if (newRadio!=radio) {
			document.getElementById('modeSaisie').value = radio;
			var confirm = true;
			if (wTreeLignes.view!=null && wTreeLignes.view.rowCount>0) {
				confirm = window.confirm("Confirmez-vous le changement de mode de saisie ?\n(attention toutes les \u00E9critures d\u00E9j\u00E0 saisies seront recalcul\u00E9es)");
			}
			if (confirm) {
				radio = newRadio;
				document.getElementById('modeSaisie').value = radio;
				collapseMenu();
				if (radio==1) {
					// montants => pourcentages
					recalculerPourcentages();
				} else if (radio==2) {
					// pourcentages => montants
					recalculerMontants();
					razPourcentages();
				}
				majTotaux();
			}
		}
	} catch (e) {
		recup_erreur(e);
	}
}

function recalculerPourcentages() {
	try {
		for (var i=0; i<wTreeLignes.view.rowCount; i++) {
			var montant = wTreeLignes.view.getCellText(i,wTreeLignes.columns.getColumnAt(4));
			montant = isEmpty(montant)?0:montant;
			var pourcent = 0;
			if (montantInit!=0) {
				pourcent = rd2.round(montant*100/montantInit);
			}
			wTreeLignes.view.setCellText(i,wTreeLignes.columns.getColumnAt(5), percentToText(pourcent));
			wTreeLignes.view.setCellText(i,wTreeLignes.columns.getColumnAt(6), pourcent);
		}
	} catch (e) {
		recup_erreur(e);
	}
}

function recalculerMontants() {
	try {
		for (var i=0; i<wTreeLignes.view.rowCount; i++) {
			var pourcent = wTreeLignes.view.getCellText(i,wTreeLignes.columns.getColumnAt(6));
			pourcent = isEmpty(pourcent)?0:pourcent;
			var montant = 0;
			if (montantInit!=0) {
				var montant = rd2.round(montantInit*pourcent/100);
			}
			wTreeLignes.view.setCellText(i,wTreeLignes.columns.getColumnAt(3), nf.format(montant));
			wTreeLignes.view.setCellText(i,wTreeLignes.columns.getColumnAt(4), montant);
		}
	} catch (e) {
		recup_erreur(e);
	}
}

function razPourcentages() {
	try {
		for (var i=0; i<wTreeLignes.view.rowCount; i++) {
			var pourcent = 0;
			wTreeLignes.view.setCellText(i,wTreeLignes.columns.getColumnAt(5), percentToText(pourcent));
			wTreeLignes.view.setCellText(i,wTreeLignes.columns.getColumnAt(6), pourcent);
		}
	} catch (e) {
		recup_erreur(e);
	}
}

function changeOnNumero() {
	try {
		numero = document.getElementById('numero').value;
	} catch (e) {
		recup_erreur(e);
	}
}

function keyPressOnNumero(event) {
	try {
		if (event.keyCode==13) {
			activeSaisie(false);
			numero = document.getElementById('numero').value;
			rechercheCompte();
			activeSaisie(true);
		}
	} catch (e) {
		recup_erreur(e);
	}
}

function keyPressOnLibelle(event) {
	try {
		if (event.keyCode==13) {
			if (radio==1) {
				document.getElementById('pourcentage').focus();
			} else if (radio==2) {
				document.getElementById('montant').focus();
			}
		} else if (event.keyCode==27) {
			document.getElementById('numero').focus();
		}
	} catch (e) {
		recup_erreur(e);
	}
}

function keyPressOnMontant(event) {
	try {
		if (event.keyCode==13) {
			pressOnValider();
		} else if (event.keyCode==27) {
			document.getElementById('libelle').focus();
		}
	} catch (e) {
		recup_erreur(e);
	}
}

function keyPressOnPourcentage(event) {
	try {
		if (event.keyCode==13) {
			pressOnValider();
		} else if (event.keyCode==27) {
			document.getElementById('libelle').focus();
		}
	} catch (e) {
		recup_erreur(e);
	}
}


function rechercheCompte() {
	try {

		var qSearch = new QueryHttp("Compta/Analytique/Comptes/searchNumCompte.tmpl");
		qSearch.setParam("Num_Compte", numero);
		qSearch.setParam("Search_Like", true);
		var result = qSearch.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var findCompte = result.responseXML.documentElement.getAttribute("Num_Compte");

			if (!isEmpty(findCompte)) {
				var compteId = result.responseXML.documentElement.getAttribute("Compte_Id");
				finRechercheCompte(compteId, findCompte);
			}
			else {
				var url = "chrome://opensi/content/compta/user/analytique/comptes/popup-rechercheCompteAnalytique.xul";
    		window.openDialog(url,'','chrome,modal,centerscreen', finRechercheCompte, numero);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function finRechercheCompte(compteId, numCompte) {
	try {

		numero = numCompte;
		document.getElementById('numero').value = numero;

		var qGet = new QueryHttp("Compta/Analytique/Comptes/getIntitule.tmpl");
		qGet.setParam("Compte_Id", compteId);
		var result = qGet.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			document.getElementById('libelle').value = result.responseXML.documentElement.getAttribute('Intitule');
		}

		activeSaisie(true);
		document.getElementById('libelle').focus();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnReset() {
	try {
		activeSaisie(false);
		annulerSaisie();
		activeSaisie(true);
	} catch (e) {
		recup_erreur(e);
	}
}

function pressOnValider() {
	try {
		activeSaisie(false);
		var ok = true;
		if (!checkNumero(numero)) {
			showWarning("Numero de compte invalide !");
			ok = false;
		}
		else if (existNumero(numero) && index==-1) {
			showWarning("Il existe  d\u00E9j\u00E0 une ventilation pour ce compte analytique !");
			ok = false;
		}
		else if (radio==1) {
			if (!checkNumber(document.getElementById('pourcentage').value, 5, 2)) {
				showWarning("Pourcentage incorrect !");
				ok = false;
			}
			else if (!isPositive(document.getElementById('pourcentage').value)) {
				showWarning("Pourcentage incorrect !");
				ok = false;
			}
			else if (document.getElementById('pourcentage').value>100) {
				showWarning("Pourcentage incorrect !");
				ok = false;
			}
		}
		else if (radio==2) {
			if (!checkNumber(document.getElementById('montant').value, 16, 2)) {
				showWarning("Montant incorrect !");
				ok = false;
			}
			else if (!isPositive(document.getElementById('montant').value)) {
				showWarning("Montant incorrect !");
				ok = false;
			}
		}
		if (ok) {
			validerSaisie();
		}
		activeSaisie(true);
	} catch (e) {
		recup_erreur(e);
	}
}

function pressOnSupprimer() {
	try {
		supprimerSaisie();
	} catch (e) {
		recup_erreur(e);
	}
}

function checkNumero(num) {
	try {
		var qGetCompte = new QueryHttp("Compta/Analytique/Comptes/getCompteByNumero.tmpl");
		qGetCompte.setParam("Numero", numero);
		var result = qGetCompte.execute();
		var errors = new Errors(result);

		var ok = true;
		if (errors.hasNext()) {
			//errors.show();
			ok = false;
		} else {
			ok = (result.responseXML.documentElement.getAttribute('Actif')=="true");
		}
		return ok;
	} catch (e) {
		recup_erreur(e);
	}
}

function existNumero(num) {
	try {
		var trouve = false;
		for (var i=0; i<wTreeLignes.view.rowCount && !trouve; i++) {
			trouve = (numero==wTreeLignes.view.getCellText(i,wTreeLignes.columns.getColumnAt(1)));
		}
		return trouve;
	} catch (e) {
		recup_erreur(e);
	}
}

function annulerSaisie() {
	try {
		id = 0;
		numero = "";
		index = -1;
		wTreeLignes.view.selection.select(-1);
		document.getElementById('numero').value = numero;
		document.getElementById('libelle').value = "";
		document.getElementById('montant').value = "";
		document.getElementById('pourcentage').value = "";
		activeSaisie(true);
		document.getElementById('numero').focus();
	} catch (e) {
		recup_erreur(e);
	}
}

function validerSaisie() {
	try {
		modif = true;
		var ligne = new Ligne();
		ligne.id = id;
		ligne.numero = numero;
		ligne.intitule = document.getElementById('libelle').value;
		ligne.montant = document.getElementById('montant').value;
		ligne.pourcentage = document.getElementById('pourcentage').value;
		if (index==-1) {
			// creation nouvelle ligne
			createLigne(ligne);
		} else {
			// modif ligne
			var montant = rd2.round((isEmpty(ligne.montant))?0:ligne.montant);
			var pourcentage = rd2.round((isEmpty(ligne.pourcentage))?0:ligne.pourcentage);
			wTreeLignes.view.setCellText(index,wTreeLignes.columns.getColumnAt(0), ligne.id);
			wTreeLignes.view.setCellText(index,wTreeLignes.columns.getColumnAt(1), ligne.numero);
			wTreeLignes.view.setCellText(index,wTreeLignes.columns.getColumnAt(2), ligne.intitule);
			wTreeLignes.view.setCellText(index,wTreeLignes.columns.getColumnAt(3), nf.format(montant));
			wTreeLignes.view.setCellText(index,wTreeLignes.columns.getColumnAt(4), montant);
			wTreeLignes.view.setCellText(index,wTreeLignes.columns.getColumnAt(5), percentToText(pourcentage));
			wTreeLignes.view.setCellText(index,wTreeLignes.columns.getColumnAt(6), pourcentage);
		}
		if (radio==2) {
			// mode saisie montants
			recalculerPourcentages();
		} else if (radio==1) {
			// mode saisie pourcentages
			recalculerMontants();
		}
		majTotaux();
		annulerSaisie();
	} catch (e) {
		recup_erreur(e);
	}
}

function createLigne(ligne) {
	try {
		var treechildren = wTreeLignes.getElementsByTagName('treechildren')[0];

		var treeitem = document.createElementNS(XUL_NS, "xul:treeitem");
		var treerow = document.createElementNS(XUL_NS, "xul:treerow");

		var treecell = document.createElementNS(XUL_NS, "xul:treecell");
		treecell.setAttribute("label", ligne.id);
		treerow.appendChild(treecell);

		treecell = document.createElementNS(XUL_NS, "xul:treecell");
		treecell.setAttribute("label", ligne.numero);
		treerow.appendChild(treecell);

		treecell = document.createElementNS(XUL_NS, "xul:treecell");
		treecell.setAttribute("label", ligne.intitule);
		treerow.appendChild(treecell);

		var montant = rd2.round((isEmpty(ligne.montant))?0:ligne.montant)
		treecell = document.createElementNS(XUL_NS, "xul:treecell");
		treecell.setAttribute("label", nf.format(montant));
		treerow.appendChild(treecell);

		treecell = document.createElementNS(XUL_NS, "xul:treecell");
		treecell.setAttribute("label", montant);
		treerow.appendChild(treecell);

		var pourcentage = rd2.round((isEmpty(ligne.pourcentage))?0:ligne.pourcentage);
		treecell = document.createElementNS(XUL_NS, "xul:treecell");
		treecell.setAttribute("label", percentToText(pourcentage));
		treerow.appendChild(treecell);

		treecell = document.createElementNS(XUL_NS, "xul:treecell");
		treecell.setAttribute("label", pourcentage);
		treerow.appendChild(treecell);

		treeitem.appendChild(treerow);
		treechildren.appendChild(treeitem);
	} catch (e) {
		recup_erreur(e);
	}
}

function supprimerSaisie() {
	try {
		modif = true;
		var item = wTreeLignes.treeBoxObject.view.getItemAtIndex(index);
		item.parentNode.removeChild(item);
		annulerSaisie();
		majTotaux();
	} catch (e) {
		recup_erreur(e);
	}
}

function pressOnAnnuler() {
	try {
		if (verifAnnuler()) {
			window.close();
		}
	} catch (e) {
		recup_erreur(e);
	}
}

function pressOnOk() {
	try {
		if (!modif || lock) {
			window.close();
		} else if (verifTabVentil()) {
			quitter();
		}
	} catch (e) {
		recup_erreur(e);
	}
}

function verifAnnuler() {
	try {
		if (!modif || lock || wTreeLignes.view.rowCount==0) {
			return true;
		} else {
			return window.confirm("Les modifications saisies actuellement seront perdues. Voulez-vous continuer ?");
		}
	} catch (e) {
		recup_erreur(e);
	}
}

function quitter() {
	try {
		var tab = getTabLignesVentilation();
		window.arguments[0](tab);
		window.close();

	} catch (e) {
		recup_erreur(e);
	}
}

function getTabLignesVentilation() {
	try {
		var tab = new Array();
		for (var i=0; i<wTreeLignes.view.rowCount; i++) {
			var ligne = new Ligne();
			ligne.id = wTreeLignes.view.getCellText(i,wTreeLignes.columns.getColumnAt(0));
			ligne.numero = wTreeLignes.view.getCellText(i,wTreeLignes.columns.getColumnAt(1));
			ligne.intitule = wTreeLignes.view.getCellText(i,wTreeLignes.columns.getColumnAt(2));
			ligne.montant = wTreeLignes.view.getCellText(i,wTreeLignes.columns.getColumnAt(4));
			ligne.pourcentage = wTreeLignes.view.getCellText(i,wTreeLignes.columns.getColumnAt(6));
			tab.push(ligne);
		}
		return tab;
	} catch (e) {
		recup_erreur(e);
	}
}

function fermerPopup(event) {
	try {
		if (!verifAnnuler()) {
			event.preventDefault();
		}
	} catch (e) {
		recup_erreur(e);
	}
}

function verifTabVentil() {
	try {
		var montantZero = false;
		var totalMontant = 0;
		var pourcentageZero = false;
		var totalPourcentage = 0;
		var ok = true;

		for (var i=0; i<wTreeLignes.view.rowCount; i++) {
			var montant = wTreeLignes.view.getCellText(i,wTreeLignes.columns.getColumnAt(4));
			var pourcentage = wTreeLignes.view.getCellText(i,wTreeLignes.columns.getColumnAt(6));
			if (!isEmpty(montant)) {
				montantZero = (montantZero || (montant==0));
				totalMontant += parseFloat(montant);
			} else {
				montantZero = true;
			}
			if (!isEmpty(pourcentage)) {
				pourcentageZero = (pourcentageZero || (pourcentage==0));
				totalPourcentage += parseFloat(pourcentage);
			} else {
				pourcentageZero = true;
			}
		}
		// si tableau vide -> ok : suppression
		// sinon
		if (i!=0) {
			totalMontant = rd2.round(totalMontant);
			totalPourcentage = rd2.round(totalPourcentage);
			// detection des zeros restants
			if (!((radio==1 && !pourcentageZero) || (radio==2 && !montantZero))) {
				showWarning("Les montants ou pourcentages doivent sup\u00E9rieurs \u00E0 0 !");
				ok = false;
			}
			// 100%
			else if (radio==1 && totalPourcentage!=100) {
				showWarning("Le total de la ventilation en pourcentages n'est pas \u00E9gal \u00E0 100% !");
				ok = false;
			}
			// full montant
			else if (radio==2 && montantInit!=0 && totalMontant!=montantInit) {
				showWarning("Le total de la ventilation en montants n'est pas \u00E9gal au montant d'origine !");
				ok = false;
			}
		}
		return ok;
	} catch (e) {
		recup_erreur(e);
	}
}
