/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");


var aTableauTR = new Arbre('Compta/TableauxBord/list-tableauTR.tmpl', 'tableauTR');



function init() {
  try {

		document.getElementById('sousTitre').value = "AU "+ parent.document.getElementById('date_courante').value;

		var qGet = new QueryHttp("Compta/TableauxBord/getTableauxBordTresorerie.tmpl");
		var result = qGet.execute();

    var contenu = result.responseXML.documentElement;

		document.getElementById('graphEvolTR').setAttribute("src", getDirGraph() + contenu.getAttribute('Graph_Evol_TR'));

		document.getElementById('JM30').value = contenu.getAttribute('JM30');
		document.getElementById('J').value = contenu.getAttribute('J');
		document.getElementById('JP15').value = contenu.getAttribute('JP15');
		document.getElementById('JP30').value = contenu.getAttribute('JP30');
		document.getElementById('autresDettes').value = contenu.getAttribute('AutresDettes');
		document.getElementById('fournisseurs30').value = contenu.getAttribute('Fournisseurs30');
		document.getElementById('clients30').value = contenu.getAttribute('Clients30');

		document.getElementById("b90C").value = contenu.getAttribute('B90C');
		document.getElementById("b60C").value = contenu.getAttribute('B60C');
		document.getElementById("b30C").value = contenu.getAttribute('B30C');
		document.getElementById("b00C").value = contenu.getAttribute('B00C');
		document.getElementById("soldeC").value = contenu.getAttribute('SoldeC');

		document.getElementById("b90F").value = contenu.getAttribute('B90F');
		document.getElementById("b60F").value = contenu.getAttribute('B60F');
		document.getElementById("b30F").value = contenu.getAttribute('B30F');
		document.getElementById("b00F").value = contenu.getAttribute('B00F');
		document.getElementById("soldeF").value = contenu.getAttribute('SoldeF');

		chargerTableauTR();

  } catch (e) {
    recup_erreur(e);
  }
}


function chargerTableauTR() {
	try {

		var deltaJour = document.getElementById('deltaJour').value;

		aTableauTR.setParam("Delta_Jour", deltaJour);
    aTableauTR.initTree();

	} catch (e) {
    recup_erreur(e);
  }
}


function goToBalanceAgee(typeBalance) {
  try {

    window.location = "chrome://opensi/content/compta/user/edition/options_balanceagee.xul?Type="+ typeBalance;

  } catch (e) {
    recup_erreur(e);
  }
}


function retourMenuPrincipal() {
  try {

    window.location = "chrome://opensi/content/compta/user/menu_exercice.xul";

  } catch (e) {
    recup_erreur(e);
  }
}
