/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var opcg_aTypeReglement = new Arbre('Config/cg/list-typeReglement.tmpl', 'opcg-listeTypeReglement');
var opcg_currentTypeRegId = "";
var opcg_modified = false;



function opcg_init() {
	try {

		document.getElementById("opcg-bEnregistrerTR").disabled = true;
		opcg_aTypeReglement.initTree(opcg_chargerPrefs);
		document.getElementById("opcg-gpAnalytique").collapsed = !adminMode;

	} catch (e) {
		recup_erreur(e);
	}
}


function opcg_demandeEnregistrement() {
	try {

		if (opcg_modified && window.confirm("Voulez-vous enregistrer les modifications apport\u00E9es ?")) {
			opcg_enregistrerParametrage();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function opcg_chargerPrefs() {
	try {

		var qLoad = new QueryHttp("Config/cg/getPreferencesCG.tmpl");
		var result = qLoad.execute();
		var contenu = result.responseXML.documentElement;

		document.getElementById("opcg-Mode_Rappro").value = contenu.getAttribute('Mode_Rappro');
		document.getElementById("opcg-Intitule_Ecr_Tiers").checked = contenu.getAttribute('Intitule_Ecr_Tiers')=="true";
		document.getElementById("opcg-Opt_MR_Lib_Ecr").checked = contenu.getAttribute('Opt_MR_Lib_Ecr')=="true";
		document.getElementById("opcg-Opt_TB_Lib_Ecr").checked = contenu.getAttribute('Opt_TB_Lib_Ecr')=="true";
		document.getElementById("opcg-Opt_TB_Com_Ecr").checked = contenu.getAttribute('Opt_TB_Com_Ecr')=="true";
		document.getElementById("opcg-Opt_NP_Lib_Ecr").checked = contenu.getAttribute('Opt_NP_Lib_Ecr')=="true";
		document.getElementById("opcg-Trans_Auto_FC").checked = contenu.getAttribute('Trans_Auto_FC')=="true";
		document.getElementById("opcg-Trans_Auto_FAC").checked = contenu.getAttribute('Trans_Auto_FAC')=="true";
		document.getElementById("opcg-Trans_Auto_FF").checked = contenu.getAttribute('Trans_Auto_FF')=="true";
		document.getElementById("opcg-Trans_Auto_FAF").checked = contenu.getAttribute('Trans_Auto_FAF')=="true";
		document.getElementById("opcg-Trans_Auto_Enc").checked = contenu.getAttribute('Trans_Auto_Enc')=="true";
		document.getElementById("opcg-Trans_Auto_Rem").checked = contenu.getAttribute('Trans_Auto_Rem')=="true";
		document.getElementById("opcg-Trans_Auto_Regul").checked = contenu.getAttribute('Trans_Auto_Regul')=="true";
		document.getElementById("opcg-Trans_Auto_Regul_AC").checked = contenu.getAttribute('Trans_Auto_Regul_AC')=="true";
		document.getElementById("opcg-Trans_Auto_Remb").checked = contenu.getAttribute('Trans_Auto_Remb')=="true";
		document.getElementById("opcg-Trans_Auto_Remb_AC").checked = contenu.getAttribute('Trans_Auto_Remb_AC')=="true";
		document.getElementById("opcg-Trans_Auto_Reg_AC").checked = contenu.getAttribute('Trans_Auto_Reg_AC')=="true";
		document.getElementById("opcg-Rappel_Auto_Saisie").checked = contenu.getAttribute('Rappel_Auto_Saisie')=="true";
		document.getElementById("opcg-Act_Analytique").checked = contenu.getAttribute('Act_Analytique')=="true";
		document.getElementById("opcg-Lettrage_Auto_Vente").checked = contenu.getAttribute('Lettrage_Auto_Vente')=="true";
		document.getElementById("opcg-Lettrage_Auto_Achat").checked = contenu.getAttribute('Lettrage_Auto_Achat')=="true";
		document.getElementById("opcg-Detail_AN_Temp").checked = contenu.getAttribute('Detail_AN_Temp')=="true";

		opcg_setModified(false);

	} catch (e) {
    recup_erreur(e);
  }
}


function opcg_enregistrerParametrage() {
	try {

		var qUpdate = new QueryHttp("Config/cg/updatePreferencesCG.tmpl");

		qUpdate.setParam("Mode_Rappro", document.getElementById('opcg-Mode_Rappro').value);
		qUpdate.setParam("Intitule_Ecr_Tiers", document.getElementById("opcg-Intitule_Ecr_Tiers").checked);
		qUpdate.setParam("Opt_MR_Lib_Ecr", document.getElementById("opcg-Opt_MR_Lib_Ecr").checked);
		qUpdate.setParam("Opt_TB_Lib_Ecr", document.getElementById("opcg-Opt_TB_Lib_Ecr").checked);
		qUpdate.setParam("Opt_TB_Com_Ecr", document.getElementById("opcg-Opt_TB_Com_Ecr").checked);
		qUpdate.setParam("Opt_NP_Lib_Ecr", document.getElementById("opcg-Opt_NP_Lib_Ecr").checked);
		qUpdate.setParam("Trans_Auto_FC", document.getElementById("opcg-Trans_Auto_FC").checked);
		qUpdate.setParam("Trans_Auto_FAC", document.getElementById("opcg-Trans_Auto_FAC").checked);
		qUpdate.setParam("Trans_Auto_FF", document.getElementById("opcg-Trans_Auto_FF").checked);
		qUpdate.setParam("Trans_Auto_FAF", document.getElementById("opcg-Trans_Auto_FAF").checked);
		qUpdate.setParam("Trans_Auto_Enc", document.getElementById("opcg-Trans_Auto_Enc").checked);
		qUpdate.setParam("Trans_Auto_Rem", document.getElementById("opcg-Trans_Auto_Rem").checked);
		qUpdate.setParam("Trans_Auto_Regul", document.getElementById("opcg-Trans_Auto_Regul").checked);
		qUpdate.setParam("Trans_Auto_Regul_AC", document.getElementById("opcg-Trans_Auto_Regul_AC").checked);
		qUpdate.setParam("Trans_Auto_Remb", document.getElementById("opcg-Trans_Auto_Remb").checked);
		qUpdate.setParam("Trans_Auto_Remb_AC", document.getElementById("opcg-Trans_Auto_Remb_AC").checked);
		qUpdate.setParam("Trans_Auto_Reg_AC", document.getElementById("opcg-Trans_Auto_Reg_AC").checked);
		qUpdate.setParam("Rappel_Auto_Saisie", document.getElementById("opcg-Rappel_Auto_Saisie").checked);
		qUpdate.setParam("Act_Analytique", document.getElementById("opcg-Act_Analytique").checked);
		qUpdate.setParam("Lettrage_Auto_Vente", document.getElementById("opcg-Lettrage_Auto_Vente").checked);
		qUpdate.setParam("Lettrage_Auto_Achat", document.getElementById("opcg-Lettrage_Auto_Achat").checked);
		qUpdate.setParam("Detail_AN_Temp", document.getElementById("opcg-Detail_AN_Temp").checked);

		var result = qUpdate.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			opcg_setModified(false);
			showMessage("Param\u00E8tres sauvegard\u00E9s !");
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function opcg_chargerTypeReglement() {
	try {

		if (opcg_aTypeReglement.isSelected()) {
			opcg_currentTypeRegId = opcg_aTypeReglement.getSelectedCellText("opcg-ColTypeRegId");
			document.getElementById("opcg-TR_TypeReglement").value = opcg_aTypeReglement.getSelectedCellText("opcg-ColTypeReglement");
			document.getElementById("opcg-TR_Transfert_Enc").checked = opcg_aTypeReglement.getSelectedCellText("opcg-ColTransfertEnc")=="true";
			document.getElementById("opcg-TR_Ecr_Glob_Remise").checked = opcg_aTypeReglement.getSelectedCellText("opcg-ColEcrGlobRemise")=="true";
			document.getElementById("opcg-bEnregistrerTR").disabled = false;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function opcg_enregistrerTypeReglement() {
	try {

		var qSaveTR = new QueryHttp("Config/cg/updateTypeReglement.tmpl");
		qSaveTR.setParam("Type_Reg_Id", opcg_currentTypeRegId);
		qSaveTR.setParam("Transfert_Enc", document.getElementById('opcg-TR_Transfert_Enc').checked);
		qSaveTR.setParam("Ecr_Glob_Remise", document.getElementById('opcg-TR_Ecr_Glob_Remise').checked);
		qSaveTR.execute();

		opcg_currentTypeRegId = "";
		document.getElementById("opcg-TR_TypeReglement").value = "";
		document.getElementById("opcg-TR_Transfert_Enc").checked = false;
		document.getElementById("opcg-TR_Ecr_Glob_Remise").checked = false;
		document.getElementById("opcg-bEnregistrerTR").disabled = true;

		opcg_aTypeReglement.initTree();

	} catch (e) {
    recup_erreur(e);
  }
}


function opcg_setModified(modified) {
	try {

		opcg_modified = modified;
		document.getElementById('opcg-imgModified').collapsed = !modified;

	} catch (e) {
		recup_erreur(e);
	}
}

