/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var omef_aMotifsEcartFacturation = new Arbre("Config/gc/achats/list-motifEcartFacturation.tmpl", "omef-listMotifEcartFacturation");

var omef_currentMotifId = "";



function omef_init() {
	try {

		omef_nouveauMotifEcartFacturation();

	} catch (e) {
    recup_erreur(e);
  }
}


function omef_filtrerMotifEcartFacturation() {
	try {

		omef_aMotifsEcartFacturation.setParam("Actif", document.getElementById("omef-filtreActif").checked);
		omef_aMotifsEcartFacturation.initTree();

	} catch (e) {
    recup_erreur(e);
  }
}


function omef_chargerMotifEcartFacturation() {
	try {

		if (omef_aMotifsEcartFacturation.isSelected()) {
			omef_currentMotifId = omef_aMotifsEcartFacturation.getSelectedCellText('omef-colMotifId');

			var qLoad = new QueryHttp("Config/gc/achats/loadMotifEcartFacturation.tmpl");
			qLoad.setParam("Motif_Id", omef_currentMotifId);

			var result = qLoad.execute();

			document.getElementById("omef-libelle").value = result.responseXML.documentElement.getAttribute("Libelle");
			document.getElementById("omef-actif").checked = result.responseXML.documentElement.getAttribute("Actif")=="true";

			document.getElementById("omef-bSupprimer").disabled = false;
		}

	} catch (e) {
    recup_erreur(e);
	}
}


function omef_nouveauMotifEcartFacturation() {
	try {

		omef_aMotifsEcartFacturation.clearSelection();
		omef_currentMotifId = "";

		document.getElementById("omef-libelle").value = "";
		document.getElementById("omef-actif").checked = true;
		document.getElementById("omef-bSupprimer").disabled = true;
		document.getElementById("omef-libelle").focus();

		omef_filtrerMotifEcartFacturation();

	} catch (e) {
    recup_erreur(e);
	}
}


function omef_supprimerMotifEcartFacturation() {
	try {

		if (!isEmpty(omef_currentMotifId) && window.confirm("Confirmez-vous la suppression du motif ?")) {
			var qDelete = new QueryHttp("Config/gc/achats/deleteMotifEcartFacturation.tmpl");
			qDelete.setParam("Motif_Id", omef_currentMotifId);

			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			omef_nouveauMotifEcartFacturation();
		}

	} catch (e) {
    recup_erreur(e);
	}
}


function omef_enregistrerMotifEcartFacturation() {
	try {

		var libelle = document.getElementById("omef-libelle").value;
		var actif = document.getElementById("omef-actif").checked;

		if (isEmpty(libelle)) {
			showWarning("Libell\u00E9 du motif manquant");
		}
		else {
			var qSave;

			if (isEmpty(omef_currentMotifId)) {
				qSave = new QueryHttp("Config/gc/achats/createMotifEcartFacturation.tmpl");
			}
			else {
				qSave = new QueryHttp("Config/gc/achats/updateMotifEcartFacturation.tmpl");
				qSave.setParam("Motif_Id", omef_currentMotifId);
			}

			qSave.setParam("Libelle", libelle);
			qSave.setParam("Actif", actif);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				omef_nouveauMotifEcartFacturation();
			}
		}

	} catch (e) {
    recup_erreur(e);
	}
}
