/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var om_aMarquesArticle = new Arbre("Config/gc/articles/list-marqueArticle.tmpl", "om-listeMarquesArticle");

var om_currentMarqueId = "";



function om_init() {
	try {

		om_listerMarquesArticle();

	} catch (e) {
    recup_erreur(e);
  }
}


function om_listerMarquesArticle() {
	try {

		om_aMarquesArticle.setParam("Actif", document.getElementById("om-filtreActif").checked);
		om_aMarquesArticle.initTree();
		om_nouveauMarqueArticle();

	} catch (e) {
		recup_erreur(e);
	}
}


function om_nouveauMarqueArticle() {
	try {

		om_currentMarqueId = "";
		om_aMarquesArticle.clearSelection();

		document.getElementById('om-libelle').value = "";
		document.getElementById('om-actif').checked = true;

		document.getElementById('om-bSupprimer').collapsed = true;
		document.getElementById('om-bNouveau').collapsed = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function om_chargerMarqueArticle() {
	try {

		if (om_aMarquesArticle.isSelected()) {
			om_currentMarqueId = om_aMarquesArticle.getSelectedCellText("om-colMarqueId");

			var qLoad = new QueryHttp("Config/gc/articles/loadMarqueArticle.tmpl");
			qLoad.setParam("Marque_Id", om_currentMarqueId);
			var result = qLoad.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var contenu = result.responseXML.documentElement;

				document.getElementById('om-libelle').value = contenu.getAttribute('Libelle');
				document.getElementById('om-actif').checked = contenu.getAttribute('Actif')=="true";

				document.getElementById('om-bSupprimer').collapsed = false;
				document.getElementById('om-bNouveau').collapsed = false;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function om_enregistrerMarqueArticle() {
	try {

		var libelle = document.getElementById('om-libelle').value;
		var actif = document.getElementById('om-actif').checked;

		if (isEmpty(libelle)) {
			showWarning("Intitul\u00E9 manquant");
		}
		else {
			var qSave;

			if (!isEmpty(om_currentMarqueId)) {
				qSave = new QueryHttp("Config/gc/articles/updateMarqueArticle.tmpl");
				qSave.setParam("Marque_Id", om_currentMarqueId);
			}
			else {
				qSave = new QueryHttp("Config/gc/articles/createMarqueArticle.tmpl");
			}

			qSave.setParam("Libelle", libelle);
			qSave.setParam("Actif", actif);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				om_listerMarquesArticle();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function om_supprimerMarqueArticle() {
	try {

		if (!isEmpty(om_currentMarqueId) && window.confirm("Confirmez-vous la suppression de la marque s\u00E9lectionn\u00E9e ?")) {

			var qDelete = new QueryHttp("Config/gc/articles/deleteMarqueArticle.tmpl");
			qDelete.setParam("Marque_Id", om_currentMarqueId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				om_listerMarquesArticle();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}
