/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var osw_currentSiteId = "";
var osw_aSitesWeb = new Arbre('Config/gc/ecommerce/list-siteWeb.tmpl', 'osw-listeSites');
var osw_aCoord = new Arbre('Config/gc/ecommerce/list-coordSiteWebVente.tmpl', 'osw-listeCoord');
var osw_aResponsables = new Arbre("ComboListe/combo-responsables.tmpl", "osw-utilResp");
var osw_aFamillesClient = new Arbre("ComboListe/combo-famillesClient.tmpl", "osw-familleClient");
var osw_aDepots = new Arbre('Config/gc/ecommerce/list-depotSiteWeb.tmpl', 'osw-listDepots');
var osw_aBanquesRemiseSW = new Arbre('Config/gc/ecommerce/list-banqueRemiseSiteWeb.tmpl', 'osw-listBanqueRemise');
var osw_aEtablissements = new Arbre('ComboListe/combo-etablissements.tmpl', 'osw-etabGestion');
var osw_aBanques = new Arbre('ComboListe/combo-banques.tmpl', 'osw-banqueRemise');
var osw_aBanquesBR = new Arbre("ComboListe/combo-banques.tmpl", "osw-banqueRemiseBR");


var osw_CompteClientDefaut;
var osw_unitePoidsDefaut;
var osw_uniteVolumeDefaut;
var osw_uniteDimensionsDefaut;
var osw_curResponsable = "";
var osw_curFamilleClient = "";
var osw_curUnitePoids = "";
var osw_curUniteVolume = "";
var osw_curUniteDimensions = "";
var osw_currentCoordId = "";
var osw_selEtablissement = "";
var osw_selBanqueId = "";
var osw_selBanqueBR = "";
var osw_fieldCompte;



function osw_init() {
	try {

		document.getElementById('osw-bVoirLogo').collapsed = true;
		document.getElementById('osw-bChangerLogo').collapsed = true;
		document.getElementById('osw-bSupprimerLogo').collapsed = true;
		document.getElementById('osw-bSupprimer').collapsed = true;
		document.getElementById('osw-bDupliquer').collapsed = true;
		document.getElementById('osw-bChangerCGV').collapsed = true;
		document.getElementById('osw-bSupprimerCGV').collapsed = true;

		document.getElementById("osw-rowDepots").collapsed = !adminMode;
		document.getElementById("osw-rowOptTarifClient").collapsed = !adminMode;
		document.getElementById("osw-rowUnitePoids").collapsed = !adminMode;
		document.getElementById("osw-rowUniteVolume").collapsed = !adminMode;
		document.getElementById("osw-rowUniteDimensions").collapsed = !adminMode;

		var config = getResetConfig();

		osw_unitePoidsDefaut = config.getUnitePoids();
		osw_uniteVolumeDefaut = config.getUniteVolume();
		osw_uniteDimensionsDefaut = config.getUniteDimensions();

		osw_CompteClientDefaut = config.getCompteClients();
		document.getElementById('osw-compteClientPart').value = osw_CompteClientDefaut;
		document.getElementById('osw-compteClientPro').value = osw_CompteClientDefaut;

		osw_aEtablissements.setParam("No_Check_Rights", true);

		var aEmails = new Arbre('ComboListe/combo-emails.tmpl', 'osw-emailVCC');
		aEmails.initTree(osw_chargerDepot);

		var aModeRegBR = new Arbre("ComboListe/combo-modesReglement.tmpl", "osw-modeReglementBR");
		aModeRegBR.initTree();

		var aPaysLivCSWV = new Arbre("ComboListe/combo-pays.tmpl", "osw-codePaysLivCSWV");
		aPaysLivCSWV.initTree();

		var aPaysCSWV = new Arbre("ComboListe/combo-pays.tmpl", "osw-codePaysCSWV");
		aPaysCSWV.initTree();

	} catch (e) {
    recup_erreur(e);
  }
}


function osw_chargerDepot() {
	try {

		document.getElementById('osw-emailVCC').selectedIndex = 0;

		var aDepot = new Arbre('ComboListe/combo-depotsStock.tmpl', 'osw-depotStock');
		aDepot.setParam("No_Check_Rights", true);
		aDepot.initTree(osw_chargerTarifVente);

	} catch (e) {
		recup_erreur(e);
	}
}


function osw_chargerTarifVente() {
	try {

		document.getElementById('osw-depotStock').selectedIndex = 0;

		var aTarifsVente = new Arbre('ComboListe/combo-tarifsVente.tmpl', 'osw-tarifVente');
		aTarifsVente.initTree(osw_chargerPays);

	} catch (e) {
		recup_erreur(e);
	}
}


function osw_chargerPays() {
	try {

		document.getElementById('osw-tarifVente').selectedIndex = 0;

		var aPays = new Arbre("ComboListe/combo-pays.tmpl", "osw-codePays");
		aPays.initTree(osw_initEmailVCC);

	} catch (e) {
		recup_erreur(e);
	}
}


function osw_initEmailVCC() {
	try {

		document.getElementById('osw-codePays').value = "FR";

		var aEmails = new Arbre('ComboListe/combo-emails.tmpl', 'osw-emailACC');
		aEmails.initTree(osw_initEmailACC);

	} catch (e) {
		recup_erreur(e);
	}
}


function osw_initEmailACC() {
	try {

		document.getElementById('osw-emailACC').selectedIndex = 0;

		var aEmails = new Arbre('ComboListe/combo-emails.tmpl', 'osw-emailECC');
		aEmails.initTree(osw_initEmailECC);

	} catch (e) {
		recup_erreur(e);
	}
}


function osw_initEmailECC() {
	try {

		document.getElementById('osw-emailECC').selectedIndex = 0;

		var aEmails = new Arbre('ComboListe/combo-emails.tmpl', 'osw-emailPCC');
		aEmails.initTree(osw_initEmailPCC);

	} catch (e) {
		recup_erreur(e);
	}
}


function osw_initEmailPCC() {
	try {

		document.getElementById('osw-emailPCC').selectedIndex = 0;

		var aEmails = new Arbre('ComboListe/combo-emails.tmpl', 'osw-emailVFC');
		aEmails.initTree(osw_initEmailRCC);

	} catch (e) {
		recup_erreur(e);
	}
}


function osw_initEmailRCC() {
	try {

		document.getElementById('osw-emailRCC').selectedIndex = 0;

		var aEmails = new Arbre('ComboListe/combo-emails.tmpl', 'osw-emailRCC');
		aEmails.initTree(osw_initEmailVFC);

	} catch (e) {
		recup_erreur(e);
	}
}


function osw_initEmailVFC() {
	try {

		document.getElementById('osw-emailVFC').selectedIndex = 0;

		var aEmails = new Arbre('ComboListe/combo-emails.tmpl', 'osw-emailVAC');
		aEmails.initTree(osw_initEmailVAC);

	} catch (e) {
		recup_erreur(e);
	}
}


function osw_initEmailVAC() {
	try {

		document.getElementById('osw-emailVAC').selectedIndex = 0;

		var aEmails = new Arbre('ComboListe/combo-emails.tmpl', 'osw-emailRRC');
		aEmails.initTree(osw_initEmailRRC);

	} catch (e) {
		recup_erreur(e);
	}
}


function osw_initEmailRRC() {
	try {

		document.getElementById('osw-emailRRC').selectedIndex = 0;

		var aEmails = new Arbre('ComboListe/combo-emails.tmpl', 'osw-emailVRP');
		aEmails.initTree(osw_initEmailVRP);

	} catch (e) {
		recup_erreur(e);
	}
}


function osw_initEmailVRP() {
	try {

		document.getElementById('osw-emailVRP').selectedIndex = 0;

		var aEmails = new Arbre('ComboListe/combo-emails.tmpl', 'osw-emailVBL');
		aEmails.initTree(osw_initEmailVBL);

	} catch (e) {
		recup_erreur(e);
	}
}


function osw_initEmailVBL() {
	try {

		document.getElementById('osw-emailVBL').selectedIndex = 0;

		osw_aSitesWeb.initTree(osw_initListeSitesWeb);

	} catch (e) {
		recup_erreur(e);
	}
}


function osw_chargerFamilleClient(selection) {
	try {

		osw_curFamilleClient = selection;
		osw_aFamillesClient.setParam("Selection", osw_curFamilleClient);
		osw_aFamillesClient.initTree(osw_initFamilleClient);

	} catch (e) {
		recup_erreur(e);
	}
}


function osw_initFamilleClient() {
	try {

		document.getElementById("osw-familleClient").value = osw_curFamilleClient;

	} catch (e) {
		recup_erreur(e);
	}
}


function osw_chargerBanques(selection) {
	try {

		osw_selBanqueId = selection;
		osw_aBanques.setParam("Selection", osw_selBanqueId);
		osw_aBanques.initTree(osw_initBanque);

	} catch (e) {
		recup_erreur(e);
	}
}


function osw_initBanque() {
  try {

		document.getElementById('osw-banqueRemise').value = osw_selBanqueId;

	} catch (e) {
  	recup_erreur(e);
	}
}


function osw_chargerBanquesBR(selection) {
	try {

		osw_selBanqueBR = selection;
		osw_aBanquesBR.setParam("Selection", osw_selBanqueBR);
		osw_aBanquesBR.initTree(osw_initBanqueBR);

	} catch (e) {
		recup_erreur(e);
	}
}


function osw_initBanqueBR() {
  try {

		document.getElementById('osw-banqueRemiseBR').value = osw_selBanqueBR;

	} catch (e) {
  	recup_erreur(e);
	}
}


function osw_chargerResponsable(selection) {
	try {

		osw_curResponsable = selection;
		osw_aResponsables.setParam("Selection", osw_curResponsable);
		osw_aResponsables.initTree(osw_initResponsable);

	} catch (e) {
		recup_erreur(e);
	}
}


function osw_initResponsable() {
	try {

		document.getElementById("osw-utilResp").value = osw_curResponsable;

	} catch (e) {
		recup_erreur(e);
	}
}


function osw_chargerEtablissements(selection) {
	try {

		osw_selEtablissement = selection;
		osw_aEtablissements.setParam("Selection", osw_selEtablissement);
		osw_aEtablissements.initTree(osw_initEtablissement);

	} catch (e) {
		recup_erreur(e);
	}
}


function osw_initEtablissement() {
	try {

		document.getElementById("osw-etabGestion").value = osw_selEtablissement;

	} catch (e) {
		recup_erreur(e);
	}
}


function osw_chargerUnitePoids(selection) {
	try {

		osw_curUnitePoids = selection;

		var aUnitesPoids = new Arbre("ComboListe/combo-unitesVente.tmpl", "osw-unitePoids");
		aUnitesPoids.setParam("Type_Unite", "P");
		aUnitesPoids.setParam("Selection", selection);
		aUnitesPoids.initTree(osw_initUnitePoids);

	} catch (e) {
		recup_erreur(e);
	}
}


function osw_initUnitePoids() {
	try {

		document.getElementById("osw-unitePoids").value = osw_curUnitePoids;

	} catch (e) {
		recup_erreur(e);
	}
}


function osw_chargerUniteVolume(selection) {
	try {

		osw_curUniteVolume = selection;

		var aUnitesVolume = new Arbre("ComboListe/combo-unitesVente.tmpl", "osw-uniteVolume");
		aUnitesVolume.setParam("Type_Unite", "V");
		aUnitesVolume.setParam("Selection", selection);
		aUnitesVolume.initTree(osw_initUniteVolume);

	} catch (e) {
		recup_erreur(e);
	}
}


function osw_initUniteVolume() {
	try {

		document.getElementById("osw-uniteVolume").value = osw_curUniteVolume;

	} catch (e) {
		recup_erreur(e);
	}
}


function osw_chargerUniteDimensions(selection) {
	try {

		osw_curUniteDimensions = selection;

		var aUnitesDimensions = new Arbre("ComboListe/combo-unitesVente.tmpl", "osw-uniteDimensions");
		aUnitesDimensions.setParam("Type_Unite", "L");
		aUnitesDimensions.setParam("Selection", selection);
		aUnitesDimensions.initTree(osw_initUniteDimensions);

	} catch (e) {
		recup_erreur(e);
	}
}


function osw_initUniteDimensions() {
	try {

		document.getElementById("osw-uniteDimensions").value = osw_curUniteDimensions;

	} catch (e) {
		recup_erreur(e);
	}
}


function osw_desactiverTout(b) {
	try {

		document.getElementById('osw-listeSites').disabled = b;
		document.getElementById('osw-codeSite').disabled = b;
		document.getElementById('osw-nomSite').disabled = b;
		document.getElementById('osw-adresseSite').disabled = b;
		document.getElementById('osw-chkActif').disabled = b;
		document.getElementById('osw-banqueRemise').disabled = b;
		document.getElementById('osw-etabGestion').disabled = b;
		document.getElementById('osw-denomination').disabled = b;
		document.getElementById('osw-adresse1').disabled = b;
		document.getElementById('osw-adresse2').disabled = b;
		document.getElementById('osw-adresse3').disabled = b;
		document.getElementById('osw-codePostal').disabled = b;
		document.getElementById('osw-ville').disabled = b;
		document.getElementById('osw-codePays').disabled = b;
		document.getElementById('osw-email').disabled = b;
		document.getElementById('osw-tel').disabled = b;
		document.getElementById('osw-fax').disabled = b;
		document.getElementById('osw-typeTechno').disabled = b;
		document.getElementById('osw-emailVCC').disabled = b;
		document.getElementById('osw-emailACC').disabled = b;
		document.getElementById('osw-emailECC').disabled = b;
		document.getElementById('osw-emailPCC').disabled = b;
		document.getElementById('osw-emailVFC').disabled = b;
		document.getElementById('osw-emailVAC').disabled = b;
		document.getElementById('osw-emailRRC').disabled = b;
		document.getElementById('osw-emailVRP').disabled = b;
		document.getElementById('osw-emailVBL').disabled = b;
		document.getElementById('osw-commentaireFC').disabled = b;
		document.getElementById('osw-commentaireBL').disabled = b;
		document.getElementById('osw-commentaireRC').disabled = b;
		document.getElementById('osw-sendFactSameAff').disabled = b;
		document.getElementById('osw-numAutoCompte').disabled = b;
		document.getElementById('osw-prefixeCompte').disabled = b;
		document.getElementById('osw-familleClient').disabled = b;
		document.getElementById('osw-optTarifClient').disabled = b;
		document.getElementById('osw-optTCInfWeb').disabled = b;
		document.getElementById('osw-contenuLogo').disabled = b;
		document.getElementById('osw-bVoirLogo').disabled = b;
		document.getElementById('osw-bChangerLogo').disabled = b;
		document.getElementById('osw-bSupprimerLogo').disabled = b;
		document.getElementById('osw-bNouveau').disabled = b;
		document.getElementById('osw-bEnregistrer').disabled = b;
		document.getElementById('osw-bSupprimer').disabled = b;
		document.getElementById('osw-bDupliquer').disabled = b;
		document.getElementById('osw-bChangerCGV').disabled = b;
		document.getElementById('osw-bSupprimerCGV').disabled = b;

		if (b) { document.getElementById('osw-bReporterEtab').disabled = true; }

	} catch (e) {
		recup_erreur(e);
	}
}


function osw_loadLogo() {
  try {

		document.getElementById('osw-vignette').setAttribute("src", getDirServeur() +"data/"+ getProfil().getCodeDossier() +"/logos/SW_"+ osw_currentSiteId +"_small.jpg?"+ nocache());

	} catch (e) {
    recup_erreur(e);
  }
}


function osw_voirLogo() {
  try {

		var urlLogo = getDirServeur() +"data/"+ getProfil().getCodeDossier() +"/logos/SW_"+ osw_currentSiteId +".jpg?"+ nocache();

		var url = "chrome://opensi/content/config/commun/popup-visualisationLogo.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', urlLogo);

	} catch (e) {
    recup_erreur(e);
  }
}


function osw_changerLogo() {
  try {

		var url = "chrome://opensi/content/config/commun/popup-chargementLogo.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', "W", osw_currentSiteId);

		osw_loadLogo();

	} catch (e) {
    recup_erreur(e);
  }
}


function osw_supprimerLogo() {
  try {

		if (window.confirm("Confirmez-vous la suppression du logo ?")) {
			var qDelete = new QueryHttp("Config/gc/ecommerce/deleteLogo.tmpl");
			qDelete.setParam("Site_Id", osw_currentSiteId);
			qDelete.execute();

			document.getElementById('osw-vignette').setAttribute("src", "chrome://opensi/content/design/default_logo.jpg");
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function osw_rafraichirListeSitesWeb() {
	try {

		document.getElementById('osw-bVoirLogo').collapsed = true;
		document.getElementById('osw-bChangerLogo').collapsed = true;
		document.getElementById('osw-bSupprimerLogo').collapsed = true;
		document.getElementById('osw-bSupprimer').collapsed = true;
		document.getElementById('osw-bDupliquer').collapsed = true;
		document.getElementById('osw-bChangerCGV').collapsed = true;
		document.getElementById('osw-bSupprimerCGV').collapsed = true;
		osw_desactiverTout(true);
		osw_aSitesWeb.initTree(osw_initListeSitesWeb);

	} catch (e) {
		recup_erreur(e);
	}
}


function osw_initListeSitesWeb() {
	try {

		osw_desactiverTout(false);
		osw_nouveauSiteWeb();

	} catch (e) {
		recup_erreur(e);
	}
}


function osw_pressOnEtabGestion() {
	try {

		var etabGestion = document.getElementById('osw-etabGestion').value;
		document.getElementById('osw-bReporterEtab').disabled = isEmpty(etabGestion);

	} catch (e) {
		recup_erreur(e);
	}
}


function osw_reporterEtabGestion() {
	try {

		var etabGestion = document.getElementById('osw-etabGestion').value;
		if (!isEmpty(etabGestion)) {
			var qEtab = new QueryHttp("Config/globale/loadEtablissement.tmpl");
			qEtab.setParam("Etablissement_Id", etabGestion);
			var result = qEtab.execute();
			var contenu = result.responseXML.documentElement;

			document.getElementById('osw-denomination').value = contenu.getAttribute("Denomination");
			document.getElementById('osw-adresse1').value = contenu.getAttribute("Adresse_1");
			document.getElementById('osw-adresse2').value = contenu.getAttribute("Adresse_2");
			document.getElementById('osw-adresse3').value = contenu.getAttribute("Adresse_3");
			document.getElementById('osw-codePostal').value = contenu.getAttribute("Code_Postal");
			document.getElementById('osw-ville').value = contenu.getAttribute("Ville");
			document.getElementById('osw-codePays').value = contenu.getAttribute("Code_Pays");
			document.getElementById('osw-email').value = contenu.getAttribute("Email");
			document.getElementById('osw-tel').value = contenu.getAttribute("Tel");
			document.getElementById('osw-fax').value = contenu.getAttribute("Fax");
			document.getElementById('osw-numeroTVA').value = contenu.getAttribute("Numero_TVA");
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function osw_nouveauSiteWeb() {
	try {

		document.getElementById('osw-panneau').selectedIndex = 0;
		osw_hideButtons(false);

		osw_aSitesWeb.clearSelection();

		document.getElementById('osw-bVoirLogo').collapsed = true;
		document.getElementById('osw-bChangerLogo').collapsed = true;
		document.getElementById('osw-bSupprimerLogo').collapsed = true;
		document.getElementById('osw-bSupprimer').collapsed = true;
		document.getElementById('osw-bDupliquer').collapsed = true;
		document.getElementById('osw-bChangerCGV').collapsed = true;
		document.getElementById('osw-bSupprimerCGV').collapsed = true;
		document.getElementById("osw-ligneBR").collapsed = true;
		document.getElementById('osw-tabCoord').collapsed = true;

		osw_currentSiteId = "";

		document.getElementById('osw-codeSite').value = "";
		document.getElementById('osw-nomSite').value = "";
		document.getElementById('osw-adresseSite').value = "";
		document.getElementById('osw-urlLogo').value = "";
		document.getElementById('osw-chkActif').checked = true;
		document.getElementById('osw-depotStock').value = "";
		document.getElementById('osw-tarifVente').value = "";
		document.getElementById('osw-etabGestion').value = "";
		osw_pressOnEtabGestion();
		document.getElementById('osw-denomination').value = "";
		document.getElementById('osw-adresse1').value = "";
		document.getElementById('osw-adresse2').value = "";
		document.getElementById('osw-adresse3').value = "";
		document.getElementById('osw-codePostal').value = "";
		document.getElementById('osw-ville').value = "";
		document.getElementById('osw-codePays').value = "FR";
		document.getElementById('osw-numeroTVA').value = "";
		document.getElementById('osw-email').value = "";
		document.getElementById('osw-tel').value = "";
		document.getElementById('osw-fax').value = "";
		document.getElementById('osw-typeTechno').value = "";
		document.getElementById('osw-emailVCC').value = "";
		document.getElementById('osw-emailACC').value = "";
		document.getElementById('osw-emailECC').value = "";
		document.getElementById('osw-emailPCC').value = "";
		document.getElementById('osw-emailRCC').value = "";
		document.getElementById('osw-emailVFC').value = "";
		document.getElementById('osw-emailVAC').value = "";
		document.getElementById('osw-emailRRC').value = "";
		document.getElementById('osw-emailVRP').value = "";
		document.getElementById('osw-emailVBL').value = "";
		document.getElementById('osw-commentaireFC').value = "";
		document.getElementById('osw-commentaireBL').value = "";
		document.getElementById('osw-commentaireRC').value = "";
		document.getElementById('osw-sendFactSameAff').checked = false;
		document.getElementById('osw-numAutoCompte').checked = false;
		document.getElementById('osw-prefixeCompte').value = "";
		document.getElementById('osw-rowPrefixe').collapsed = true;
		document.getElementById('osw-compteClientPart').value = osw_CompteClientDefaut;
		document.getElementById('osw-compteClientPro').value = osw_CompteClientDefaut;
		document.getElementById('osw-contenuLogo').value = "N";
		document.getElementById('osw-fichierCGV').value = "";
		document.getElementById('osw-optTarifClient').checked = false;
		document.getElementById('osw-optTCInfWeb').checked = false;
		document.getElementById('osw-optTCInfWeb').disabled = true;

		osw_aDepots.deleteTree();
		osw_aBanquesRemiseSW.deleteTree();

		osw_chargerEtablissements("");
		osw_chargerResponsable("");
		osw_chargerBanques("");
		osw_chargerFamilleClient("");
		osw_chargerUnitePoids(osw_unitePoidsDefaut);
		osw_chargerUniteVolume(osw_uniteVolumeDefaut);
		osw_chargerUniteDimensions(osw_uniteDimensionsDefaut);

		osw_loadLogo();

	} catch (e) {
		recup_erreur(e);
	}
}


function osw_ouvrirSite() {
	try {

		if (osw_aSitesWeb.isSelected()) {

			osw_currentSiteId = osw_aSitesWeb.getSelectedCellText('osw-colSiteId');

			var qLoad = new QueryHttp("Config/gc/ecommerce/loadSiteWeb.tmpl");
			qLoad.setParam("Site_Id", osw_currentSiteId);
			var result = qLoad.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var contenu = result.responseXML.documentElement;

				document.getElementById('osw-codeSite').value = contenu.getAttribute('Code');
				document.getElementById('osw-nomSite').value = contenu.getAttribute('Nom_Site');
				document.getElementById('osw-adresseSite').value = contenu.getAttribute('URL_Site');
				document.getElementById('osw-urlLogo').value = contenu.getAttribute('URL_Logo');
				document.getElementById('osw-chkActif').checked = contenu.getAttribute('Actif')=="true";
				document.getElementById('osw-denomination').value = contenu.getAttribute('Denomination');
				document.getElementById('osw-adresse1').value = contenu.getAttribute('Adresse_1');
				document.getElementById('osw-adresse2').value = contenu.getAttribute('Adresse_2');
				document.getElementById('osw-adresse3').value = contenu.getAttribute('Adresse_3');
				document.getElementById('osw-codePostal').value = contenu.getAttribute('Code_Postal');
				document.getElementById('osw-ville').value = contenu.getAttribute('Ville');
				document.getElementById('osw-codePays').value = contenu.getAttribute('Code_Pays');
				document.getElementById('osw-numeroTVA').value = contenu.getAttribute('Numero_TVA');
				document.getElementById('osw-email').value = contenu.getAttribute('Email');
				document.getElementById('osw-tel').value = contenu.getAttribute('Tel');
				document.getElementById('osw-fax').value = contenu.getAttribute('Fax');
				document.getElementById('osw-typeTechno').value = contenu.getAttribute('Type_Techno');
				document.getElementById('osw-emailVCC').value = contenu.getAttribute('Email_VCC');
				document.getElementById('osw-emailACC').value = contenu.getAttribute('Email_ACC');
				document.getElementById('osw-emailECC').value = contenu.getAttribute('Email_ECC');
				document.getElementById('osw-emailPCC').value = contenu.getAttribute('Email_PCC');
				document.getElementById('osw-emailRCC').value = contenu.getAttribute('Email_RCC');
				document.getElementById('osw-emailVFC').value = contenu.getAttribute('Email_VFC');
				document.getElementById('osw-emailVAC').value = contenu.getAttribute('Email_VAC');
				document.getElementById('osw-emailRRC').value = contenu.getAttribute('Email_RRC');
				document.getElementById('osw-emailVRP').value = contenu.getAttribute('Email_VRP');
				document.getElementById('osw-emailVBL').value = contenu.getAttribute('Email_VBL');
				document.getElementById('osw-compteClientPart').value = contenu.getAttribute('Compte_Client_Part');
				document.getElementById('osw-compteClientPro').value = contenu.getAttribute('Compte_Client_Pro');
				document.getElementById('osw-contenuLogo').value = contenu.getAttribute('Contenu_Logo');
				document.getElementById('osw-depotStock').value = contenu.getAttribute('Depot_Id');
				document.getElementById('osw-tarifVente').value = contenu.getAttribute('Tarif_Id');
				document.getElementById('osw-commentaireFC').value = contenu.getAttribute('Commentaire_FC');
				document.getElementById('osw-commentaireBL').value = contenu.getAttribute('Commentaire_BL');
				document.getElementById('osw-commentaireRC').value = contenu.getAttribute('Commentaire_RC');
				document.getElementById('osw-sendFactSameAff').checked = contenu.getAttribute('Send_Fact_Same_Aff')=="true";
				document.getElementById('osw-numAutoCompte').checked = contenu.getAttribute('Num_Auto_Compte')=="true";
				document.getElementById('osw-prefixeCompte').value = contenu.getAttribute('Prefixe_Compte');
				document.getElementById('osw-fichierCGV').value = contenu.getAttribute('Fichier_CGV');
				document.getElementById('osw-optTarifClient').checked = contenu.getAttribute('Opt_Tarif_Client')=="true";
				document.getElementById('osw-optTCInfWeb').checked = contenu.getAttribute('Opt_TC_Inf_Web')=="true";

				osw_pressOnEtabGestion();
				osw_changeNumAutoCompte();
				osw_checkOptTarifClient();

				osw_chargerBanques(contenu.getAttribute('Banque_Remise'));
				osw_chargerEtablissements(contenu.getAttribute('Etab_Gest'));
				osw_chargerFamilleClient(contenu.getAttribute('Famille_Client'));
				osw_chargerResponsable(contenu.getAttribute('Util_R'));
				osw_chargerUnitePoids(contenu.getAttribute('Unite_Poids'));
				osw_chargerUniteVolume(contenu.getAttribute('Unite_Volume'));
				osw_chargerUniteDimensions(contenu.getAttribute('Unite_Dimensions'));

				osw_loadLogo();

				document.getElementById('osw-bVoirLogo').collapsed = false;
				document.getElementById('osw-bChangerLogo').collapsed = false;
				document.getElementById('osw-bSupprimerLogo').collapsed = false;
				document.getElementById('osw-bSupprimer').collapsed = false;
				document.getElementById('osw-bDupliquer').collapsed = !adminMode;
				document.getElementById('osw-bChangerCGV').collapsed = false;
				document.getElementById('osw-bSupprimerCGV').collapsed = false;

				osw_aDepots.setParam("Site_Id", osw_currentSiteId);
				osw_aDepots.initTree();

				osw_aBanquesRemiseSW.setParam("Site_Id", osw_currentSiteId);
				osw_aBanquesRemiseSW.initTree();

				osw_nouveauBR();
				document.getElementById("osw-ligneBR").collapsed = false;
				document.getElementById('osw-tabCoord').collapsed = false;

				osw_listerCoord();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function osw_supprimerSiteWeb() {
	try {

		if (!isEmpty(osw_currentSiteId) && window.confirm("Voulez-vous supprimer le site web s\u00E9lectionn\u00E9 ?")) {
			var qDelete = new QueryHttp("Config/gc/ecommerce/deleteSiteWeb.tmpl");
			qDelete.setParam("Site_Id", osw_currentSiteId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				osw_rafraichirListeSitesWeb();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function osw_enregistrerSiteWeb() {
	try {

		var codeSite = document.getElementById('osw-codeSite').value;
		var nomSite = document.getElementById('osw-nomSite').value;
		var adresseSite = document.getElementById('osw-adresseSite').value;
		var urlLogo = document.getElementById('osw-urlLogo').value;
		var actif = document.getElementById('osw-chkActif').checked;
		var banqueRemise = document.getElementById('osw-banqueRemise').value;
		var etabGestion = document.getElementById('osw-etabGestion').value;
		var depot = document.getElementById('osw-depotStock').value;
		var denomination = document.getElementById('osw-denomination').value;
		var adresse1 = document.getElementById('osw-adresse1').value;
		var adresse2 = document.getElementById('osw-adresse2').value;
		var adresse3 = document.getElementById('osw-adresse3').value;
		var codePostal = document.getElementById('osw-codePostal').value;
		var ville = document.getElementById('osw-ville').value;
		var codePays = document.getElementById('osw-codePays').value;
		var numeroTVA = document.getElementById('osw-numeroTVA').value;
		var email = document.getElementById('osw-email').value;
		var tel = document.getElementById('osw-tel').value;
		var fax = document.getElementById('osw-fax').value;
		var typeTechno = document.getElementById('osw-typeTechno').value;
		var emailVCC = document.getElementById('osw-emailVCC').value;
		var emailACC = document.getElementById('osw-emailACC').value;
		var emailECC = document.getElementById('osw-emailECC').value;
		var emailPCC = document.getElementById('osw-emailPCC').value;
		var emailRCC = document.getElementById('osw-emailRCC').value;
		var emailVFC = document.getElementById('osw-emailVFC').value;
		var emailVAC = document.getElementById('osw-emailVAC').value;
		var emailRRC = document.getElementById('osw-emailRRC').value;
		var emailVRP = document.getElementById('osw-emailVRP').value;
		var emailVBL = document.getElementById('osw-emailVBL').value;
		var contenuLogo = document.getElementById('osw-contenuLogo').value;
		var compteClientPart = document.getElementById('osw-compteClientPart').value;
		var compteClientPro = document.getElementById('osw-compteClientPro').value;
		var utilResp = document.getElementById('osw-utilResp').value;
		var tarifVente = document.getElementById('osw-tarifVente').value;
		var commentaireFC = document.getElementById('osw-commentaireFC').value;
		var commentaireBL = document.getElementById('osw-commentaireBL').value;
		var commentaireRC = document.getElementById('osw-commentaireRC').value;
		var sendFactSameAff = document.getElementById('osw-sendFactSameAff').checked;
		var numAutoCompte = document.getElementById('osw-numAutoCompte').checked;
		var prefixeCompte = document.getElementById('osw-prefixeCompte').value;
		var familleClient = document.getElementById('osw-familleClient').value;
		var optTarifClient = document.getElementById('osw-optTarifClient').checked;
		var optTCInfWeb = document.getElementById('osw-optTCInfWeb').checked;
		var unitePoids = document.getElementById('osw-unitePoids').value;
		var uniteVolume = document.getElementById('osw-uniteVolume').value;
		var uniteDimensions = document.getElementById('osw-uniteDimensions').value;

		var listeDepots = "";
		for (var i=0; i<osw_aDepots.nbLignes(); i++) {
			if (osw_aDepots.getCellValue(i, "osw-colSelectLD")=="true") {
				listeDepots += osw_aDepots.getCellText(i, "osw-colDepotIdLD") +",";
			}
  	}

		var rgxPrefixe = /^[a-zA-Z09_\\-]{1}[a-zA-Z0-9_\\-]{0,1}$/;

		if (isEmpty(codeSite)) { showWarning("Veuillez saisir le code du site.") }
		else if (!isCleAlpha(codeSite)) { showWarning("Le code du site ne doit pas contenir d'accents ni de caract\u00E8res sp\u00E9ciaux.") }
		else if (isEmpty(nomSite)) { showWarning("Veuillez saisir le nom du site.") }
		else if (isEmpty(etabGestion)) { showWarning("Veuillez choisir un \u00E9tablissement de gestion."); }
		else if (isEmpty(denomination)) { showWarning("Veuillez saisir la d\u00E9nomination."); }
		else if (isEmpty(adresse1)) { showWarning("Veuillez saisir l'adresse."); }
		else if (isEmpty(ville)) { showWarning("Veuillez saisir la ville."); }
		else if (!isEmpty(tel) && !isPhone(tel)) { showWarning("Le t\u00E9l\u00E9phone est incorrect."); }
		else if (!isEmpty(fax) && !isPhone(fax)) { showWarning("Le fax est incorrect."); }
		else if (!isEmpty(email) && !isEmail(email)) { showWarning("L'e-mail est incorrect."); }
		else if (isEmpty(utilResp)) { showWarning("Veuillez s\u00E9lectionner un responsable"); }
		else if (isEmpty(depot)) { showWarning("Veuillez s\u00E9lectionner un d\u00E9p\u00F4t"); }
		else if (isEmpty(tarifVente)) { showWarning("Veuillez s\u00E9lectionner un tarif"); }
		else if (isEmpty(typeTechno)) { showWarning("Veuillez choisir la technologie e-commerce"); }
		else if (numAutoCompte && isEmpty(prefixeCompte)) { showWarning("Veuillez saisir un pr\u00E9fixe de compte"); }
		else if (numAutoCompte && !rgxPrefixe.test(prefixeCompte)) { showWarning("Pr\u00E9fixe de compte incorrect"); }
		else {

			var qSave;

			if (!isEmpty(osw_currentSiteId)) {
				qSave = new QueryHttp("Config/gc/ecommerce/updateSiteWeb.tmpl");
				qSave.setParam("Site_Id", osw_currentSiteId);
			}
			else {
				qSave = new QueryHttp("Config/gc/ecommerce/createSiteWeb.tmpl");
			}

			qSave.setParam("Code", codeSite);
			qSave.setParam("Nom_Site", nomSite);
			qSave.setParam("URL_Site", adresseSite);
			qSave.setParam("URL_Logo", urlLogo);
			qSave.setParam("Actif", actif);
			qSave.setParam("Contenu_Logo", contenuLogo);
			qSave.setParam("Denomination", denomination);
			qSave.setParam("Adresse_1", adresse1);
			qSave.setParam("Adresse_2", adresse2);
			qSave.setParam("Adresse_3", adresse3);
			qSave.setParam("Code_Postal", codePostal);
			qSave.setParam("Ville", ville);
			qSave.setParam("Code_Pays", codePays);
			qSave.setParam("Numero_TVA", numeroTVA);
			qSave.setParam("Email", email);
			qSave.setParam("Tel", tel);
			qSave.setParam("Fax", fax);
			qSave.setParam("Type_Techno", typeTechno);
			qSave.setParam("Compte_Client_Part", compteClientPart);
			qSave.setParam("Compte_Client_Pro", compteClientPro);
			qSave.setParam("Util_R", utilResp);
			qSave.setParam("Depot_Id", depot);
			qSave.setParam("Tarif_Id", tarifVente);
			qSave.setParam("Banque_Remise", banqueRemise);
			qSave.setParam("Etab_Gest", etabGestion);
			qSave.setParam("Email_VCC", emailVCC);
			qSave.setParam("Email_ACC", emailACC);
			qSave.setParam("Email_ECC", emailECC);
			qSave.setParam("Email_PCC", emailPCC);
			qSave.setParam("Email_RCC", emailRCC);
			qSave.setParam("Email_VFC", emailVFC);
			qSave.setParam("Email_VAC", emailVAC);
			qSave.setParam("Email_RRC", emailRRC);
			qSave.setParam("Email_VRP", emailVRP);
			qSave.setParam("Email_VBL", emailVBL);
			qSave.setParam("Commentaire_FC", commentaireFC);
			qSave.setParam("Commentaire_BL", commentaireBL);
			qSave.setParam("Commentaire_RC", commentaireRC);
			qSave.setParam("Send_Fact_Same_Aff", sendFactSameAff);
			qSave.setParam("Num_Auto_Compte", numAutoCompte);
			qSave.setParam("Prefixe_Compte", prefixeCompte);
			qSave.setParam("Famille_Client", familleClient);
			qSave.setParam("Opt_Tarif_Client", optTarifClient);
			qSave.setParam("Opt_TC_Inf_Web", optTCInfWeb);
			qSave.setParam("Unite_Poids", unitePoids);
			qSave.setParam("Unite_Volume", uniteVolume);
			qSave.setParam("Unite_Dimensions", uniteDimensions);
			qSave.setParam("Liste_Depots", listeDepots);

			var result = qSave.execute();
			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				osw_rafraichirListeSitesWeb();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function osw_dupliquerSiteWeb() {
	try {

		var actif = document.getElementById('osw-chkActif').checked;
		var banqueRemise = document.getElementById('osw-banqueRemise').value;
		var etabGestion = document.getElementById('osw-etabGestion').value;
		var depot = document.getElementById('osw-depotStock').value;
		var denomination = document.getElementById('osw-denomination').value;
		var adresse1 = document.getElementById('osw-adresse1').value;
		var adresse2 = document.getElementById('osw-adresse2').value;
		var adresse3 = document.getElementById('osw-adresse3').value;
		var codePostal = document.getElementById('osw-codePostal').value;
		var ville = document.getElementById('osw-ville').value;
		var codePays = document.getElementById('osw-codePays').value;
		var numeroTVA = document.getElementById('osw-numeroTVA').value;
		var email = document.getElementById('osw-email').value;
		var tel = document.getElementById('osw-tel').value;
		var fax = document.getElementById('osw-fax').value;
		var typeTechno = document.getElementById('osw-typeTechno').value;
		var emailVCC = document.getElementById('osw-emailVCC').value;
		var emailACC = document.getElementById('osw-emailACC').value;
		var emailECC = document.getElementById('osw-emailECC').value;
		var emailPCC = document.getElementById('osw-emailPCC').value;
		var emailRCC = document.getElementById('osw-emailRCC').value;
		var emailVFC = document.getElementById('osw-emailVFC').value;
		var emailVAC = document.getElementById('osw-emailVAC').value;
		var emailRRC = document.getElementById('osw-emailRRC').value;
		var emailVRP = document.getElementById('osw-emailVRP').value;
		var emailVBL = document.getElementById('osw-emailVBL').value;
		var sendFactSameAff = document.getElementById('osw-sendFactSameAff').checked;
		var utilResp = document.getElementById('osw-utilResp').value;

		osw_nouveauSiteWeb();

		document.getElementById('osw-chkActif').checked = actif;
		document.getElementById('osw-depotStock').value = depot;
		document.getElementById('osw-denomination').value = denomination;
		document.getElementById('osw-adresse1').value = adresse1;
		document.getElementById('osw-adresse2').value = adresse2;
		document.getElementById('osw-adresse3').value = adresse3;
		document.getElementById('osw-codePostal').value = codePostal;
		document.getElementById('osw-ville').value = ville;
		document.getElementById('osw-codePays').value = codePays;
		document.getElementById('osw-numeroTVA').value = numeroTVA;
		document.getElementById('osw-email').value = email;
		document.getElementById('osw-tel').value = tel;
		document.getElementById('osw-fax').value = fax;
		document.getElementById('osw-typeTechno').value = typeTechno;
		document.getElementById('osw-emailVCC').value = emailVCC;
		document.getElementById('osw-emailACC').value = emailACC;
		document.getElementById('osw-emailECC').value = emailECC;
		document.getElementById('osw-emailPCC').value = emailPCC;
		document.getElementById('osw-emailRCC').value = emailRCC;
		document.getElementById('osw-emailVFC').value = emailVFC;
		document.getElementById('osw-emailVAC').value = emailVAC;
		document.getElementById('osw-emailRRC').value = emailRRC;
		document.getElementById('osw-emailVRP').value = emailVRP;
		document.getElementById('osw-emailVBL').value = emailVBL;
		document.getElementById('osw-sendFactSameAff').checked = sendFactSameAff;
		osw_chargerResponsable(utilResp);
		osw_chargerEtablissements(etabGestion);
		osw_chargerBanques(banqueRemise);

	} catch (e) {
		recup_erreur(e);
	}
}


function osw_rechercherCompte(fieldToFill) {
	try {

		osw_fieldCompte = fieldToFill;

	  var url ="chrome://opensi/content/compta/user/comptes/popup-rechercheCompte.xul";
	  window.openDialog(url,'','chrome,modal,centerscreen', osw_retourRechercherCompte, "", "C", "CLIENT", "", false);

	} catch (e) {
    recup_erreur(e);
  }
}


function osw_retourRechercherCompte(numCompte, compteId) {
	try {

		document.getElementById(osw_fieldCompte).value = numCompte;

	} catch (e) {
		  recup_erreur(e);
	}
}


function osw_checkOptTarifClient() {
	try {

		document.getElementById("osw-optTCInfWeb").disabled = !document.getElementById("osw-optTarifClient").checked;

	} catch (e) {
		recup_erreur(e);
	}
}


function osw_changeNumAutoCompte() {
	try {

		var numAuto = document.getElementById("osw-numAutoCompte").checked;

		document.getElementById("osw-rowPrefixe").collapsed = !numAuto;
		if (!numAuto) {
			document.getElementById("osw-prefixeCompte").value = "";
		}

	} catch (e) {
		  recup_erreur(e);
	}
}


function osw_changerCGV() {
  try {

		var url = "chrome://opensi/content/config/gc/ecommerce/popup-changerCGV.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', osw_retourChangerCGV, osw_currentSiteId);

	} catch (e) {
    recup_erreur(e);
  }
}


function osw_retourChangerCGV(fichierCGV) {
	try {

		document.getElementById('osw-fichierCGV').value = fichierCGV;

	} catch (e) {
    recup_erreur(e);
  }
}


function osw_supprimerCGV() {
  try {

		if (window.confirm("Confirmez-vous la suppression du fichier des CGV ?")) {
			var qSup = new QueryHttp("Config/gc/ecommerce/deleteCGV.tmpl");
			qSup.setParam("Site_Id", osw_currentSiteId);
			qSup.execute();

			document.getElementById('osw-fichierCGV').value = "";
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function osw_pressOnListeBanqueRemise() {
	try {

		if (osw_aBanquesRemiseSW.isSelected()) {
			document.getElementById("osw-modeReglementBR").value = osw_aBanquesRemiseSW.getSelectedCellText("osw-colModeRegId");
			osw_chargerBanquesBR(osw_aBanquesRemiseSW.getSelectedCellText("osw-colBanqueId"));
			document.getElementById("osw-modeReglementBR").disabled = true;
			document.getElementById("osw-bValiderBR").disabled = false;
			document.getElementById("osw-bSupprimerBR").disabled = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function osw_nouveauBR() {
	try {

		osw_aBanquesRemiseSW.clearSelection();
		document.getElementById("osw-modeReglementBR").value = "";
		osw_chargerBanquesBR("");
		document.getElementById("osw-modeReglementBR").disabled = false;
		document.getElementById("osw-bValiderBR").disabled = false;
		document.getElementById("osw-bSupprimerBR").disabled = true;

	} catch (e) {
		recup_erreur(e);
	}
}


function osw_validerBR() {
	try {

		var modeRegId = document.getElementById("osw-modeReglementBR").value;
		var banqueId = document.getElementById("osw-banqueRemiseBR").value;

		if (isEmpty(modeRegId)) {
			showWarning("Mode de r\u00E8glement obligatoire");
		}
		else if (isEmpty(banqueId)) {
			showWarning("Banque de remise obligatoire");
		}
		else {
			var qSave = new QueryHttp("Config/gc/ecommerce/saveBanqueRemiseSiteWeb.tmpl")
			qSave.setParam("Site_Id", osw_currentSiteId);
			qSave.setParam("Mode_Reg_Id", modeRegId);
			qSave.setParam("Banque_Id", banqueId);
			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				osw_aBanquesRemiseSW.initTree();
				osw_nouveauBR();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function osw_supprimerBR() {
	try {

		var modeRegId = document.getElementById("osw-modeReglementBR").value;

		var qSup = new QueryHttp("Config/gc/ecommerce/deleteBanqueRemiseSiteWeb.tmpl");
		qSup.setParam("Site_Id", osw_currentSiteId);
		qSup.setParam("Mode_Reg_Id", modeRegId);
		var result = qSup.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}

		osw_aBanquesRemiseSW.initTree();
		osw_nouveauBR();

	} catch (e) {
		recup_erreur(e);
	}
}


function osw_hideButtons(b) {
	try {

		document.getElementById('osw-buttons').collapsed = b;

	} catch (e) {
  	recup_erreur(e);
  }
}


// Gestion des coordonnes par pays


function osw_listerCoord() {
	try {

		osw_aCoord.setParam("Site_Web_Id", osw_currentSiteId);
		osw_aCoord.initTree();

		osw_nouveauCoord();

	} catch (e) {
		recup_erreur(e);
	}
}


function osw_nouveauCoord() {
	try {

		osw_currentCoordId = "";
		osw_aCoord.clearSelection();

		document.getElementById('osw-codePaysLivCSWV').value = "";
		document.getElementById('osw-numeroTVACSWV').value = "";
		document.getElementById('osw-denominationCSWV').value = "";
		document.getElementById('osw-adresse1CSWV').value = "";
		document.getElementById('osw-adresse2CSWV').value = "";
		document.getElementById('osw-adresse3CSWV').value = "";
		document.getElementById('osw-codePostalCSWV').value = "";
		document.getElementById('osw-villeCSWV').value = "";
		document.getElementById('osw-codePaysCSWV').value = "";
		document.getElementById('osw-telCSWV').value = "";
		document.getElementById('osw-faxCSWV').value = "";
		document.getElementById('osw-emailCSWV').value = "";
		document.getElementById('osw-siteWebCSWV').value = "";

		document.getElementById('osw-bSupprimerCoord').collapsed = true;
		document.getElementById('osw-bNouveauCoord').collapsed = true;

	} catch (e) {
		recup_erreur(e);
	}
}


function osw_chargerCoord() {
	try {

		if (osw_aCoord.isSelected()) {
			osw_currentCoordId = osw_aCoord.getSelectedCellText("osw-colCoordIdCSWV");

			var qLoad = new QueryHttp("Config/gc/ecommerce/loadCoordSiteWebVente.tmpl");
			qLoad.setParam("Coord_Id", osw_currentCoordId);
			var result = qLoad.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var contenu = result.responseXML.documentElement;

				document.getElementById('osw-codePaysLivCSWV').value = contenu.getAttribute('Code_Pays_Liv');
				document.getElementById('osw-numeroTVACSWV').value = contenu.getAttribute('Numero_TVA');
				document.getElementById('osw-denominationCSWV').value = contenu.getAttribute('Denomination');
				document.getElementById('osw-adresse1CSWV').value = contenu.getAttribute('Adresse_1');
				document.getElementById('osw-adresse2CSWV').value = contenu.getAttribute('Adresse_2');
				document.getElementById('osw-adresse3CSWV').value = contenu.getAttribute('Adresse_3');
				document.getElementById('osw-codePostalCSWV').value = contenu.getAttribute('Code_Postal');
				document.getElementById('osw-villeCSWV').value = contenu.getAttribute('Ville');
				document.getElementById('osw-codePaysCSWV').value = contenu.getAttribute('Code_Pays');
				document.getElementById('osw-telCSWV').value = contenu.getAttribute('Tel');
				document.getElementById('osw-faxCSWV').value = contenu.getAttribute('Fax');
				document.getElementById('osw-emailCSWV').value = contenu.getAttribute('Email');
				document.getElementById('osw-siteWebCSWV').value = contenu.getAttribute('Site_Web');

				document.getElementById('osw-bSupprimerCoord').collapsed = false;
				document.getElementById('osw-bNouveauCoord').collapsed = false;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function osw_enregistrerCoord() {
	try {

		var codePaysLiv = document.getElementById('osw-codePaysLivCSWV').value;
		var numeroTVA = document.getElementById('osw-numeroTVACSWV').value;
		var denomination = document.getElementById('osw-denominationCSWV').value;
		var adresse1 = document.getElementById('osw-adresse1CSWV').value;
		var adresse2 = document.getElementById('osw-adresse2CSWV').value;
		var adresse3 = document.getElementById('osw-adresse3CSWV').value;
		var codePostal = document.getElementById('osw-codePostalCSWV').value;
		var ville = document.getElementById('osw-villeCSWV').value;
		var codePays = document.getElementById('osw-codePaysCSWV').value;
		var tel = document.getElementById('osw-telCSWV').value;
		var fax = document.getElementById('osw-faxCSWV').value;
		var email = document.getElementById('osw-emailCSWV').value;
		var siteWeb = document.getElementById('osw-siteWebCSWV').value;

		if (!isEmpty(tel) && !isPhone(tel)) { showWarning("T\u00E9l\u00E9phone incorrect"); }
		else if (!isEmpty(fax) && !isPhone(fax)) { showWarning("Fax incorrect"); }
		else if (!isEmpty(email) && !isEmail(email)) { showWarning("E-Mail incorrect"); }
		else if (isEmpty(denomination)) { showWarning("D\u00E9nomination manquante"); }
		else if (isEmpty(adresse1)) { showWarning("Adresse manquante"); }
		else if (isEmpty(ville)) { showWarning("Ville manquante"); }
		else if (isEmpty(codePays)) { showWarning("Pays manquant"); }
		else if (isEmpty(codePaysLiv)) { showWarning("Pays de livraison manquant"); }
		else {
			var qSave;

			if (isEmpty(osw_currentCoordId)) {
				qSave = new QueryHttp("Config/gc/ecommerce/createCoordSiteWebVente.tmpl");
				qSave.setParam("Site_Web_Id", osw_currentSiteId);
			}
			else {
				qSave = new QueryHttp("Config/gc/ecommerce/updateCoordSiteWebVente.tmpl");
				qSave.setParam("Coord_Id", osw_currentCoordId);
			}

			qSave.setParam("Code_Pays_Liv", codePaysLiv);
			qSave.setParam("Numero_TVA", numeroTVA);
			qSave.setParam("Denomination", denomination);
			qSave.setParam("Adresse_1", adresse1);
			qSave.setParam("Adresse_2", adresse2);
			qSave.setParam("Adresse_3", adresse3);
			qSave.setParam("Code_Postal", codePostal);
			qSave.setParam("Ville", ville);
			qSave.setParam("Code_Pays", codePays);
			qSave.setParam("Tel", tel);
			qSave.setParam("Fax", fax);
			qSave.setParam("Email", email);
			qSave.setParam("Site_Web", siteWeb);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				osw_listerCoord();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function osw_supprimerCoord() {
	try {

		if (window.confirm("Confirmez-vous la suppression des coordonn\u00E9es s\u00E9lectionn\u00E9es ?")) {
			var qDelete = new QueryHttp("Config/gc/ecommerce/deleteCoordSiteWebVente.tmpl");
			qDelete.setParam("Coord_Id", osw_currentCoordId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				osw_listerCoord();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function osw_reporterCoord() {
	try {

		document.getElementById('osw-numeroTVACSWV').value = document.getElementById('osw-numeroTVA').value;
		document.getElementById('osw-denominationCSWV').value = document.getElementById('osw-denomination').value;
		document.getElementById('osw-adresse1CSWV').value = document.getElementById('osw-adresse1').value;
		document.getElementById('osw-adresse2CSWV').value = document.getElementById('osw-adresse2').value;
		document.getElementById('osw-adresse3CSWV').value = document.getElementById('osw-adresse3').value;
		document.getElementById('osw-codePostalCSWV').value = document.getElementById('osw-codePostal').value;
		document.getElementById('osw-villeCSWV').value = document.getElementById('osw-ville').value;
		document.getElementById('osw-codePaysCSWV').value = document.getElementById('osw-codePays').value;
		document.getElementById('osw-telCSWV').value = document.getElementById('osw-tel').value;
		document.getElementById('osw-faxCSWV').value = document.getElementById('osw-fax').value;
		document.getElementById('osw-emailCSWV').value = document.getElementById('osw-email').value;
		document.getElementById('osw-siteWebCSWV').value = document.getElementById('osw-adresseSite').value;

	} catch (e) {
		recup_erreur(e);
	}
}


