/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var ome_curModeLivraisonId = '';
var ome_curIntitule = '';
var ome_curFormatExport;
var ome_aModesLivraison = new Arbre("Config/gc/expeditions/list-modeExpedition.tmpl", "ome-liste_modes_livraison");
var ome_aFormatsExport = new Arbre("ComboListe/combo-formatsTransporteur.tmpl", "ome-Format");



function ome_init() {
	try {

		var config = getResetConfig();

		var accMWM = getProfil().isAccMWM();

		ome_filtrerModeExpedition();
		ome_chargerExport("");

		document.getElementById('ome-rowMWMEnvoiTransFTP').collapsed = !accMWM;
		document.getElementById('ome-rowAutExpDPA').collapsed = !config.isGACDropPossibleAuto();
		document.getElementById('ome-rowSoldeAutoExclu').collapsed = !config.isSoldeAutoCC();
		document.getElementById('ome-etiqTransArticle').collapsed = !config.isSpecBECME();
		document.getElementById('ome-etapePrepaBLCC').collapsed = !config.isSpecBECME();

	} catch (e) {
    recup_erreur(e);
  }
}


function ome_filtrerModeExpedition() {
	try {

		ome_aModesLivraison.setParam("Actif", document.getElementById("ome-filtreActif").checked);
		ome_aModesLivraison.initTree();

	} catch (e) {
    recup_erreur(e);
  }
}


function ome_chargerExport(selection) {
	try {

		ome_curFormatExport = selection;
		ome_aFormatsExport.setParam("Selection", selection);
		ome_aFormatsExport.initTree(ome_initExport);

	} catch (e) {
		recup_erreur(e);
	}
}


function ome_initExport() {
	try {

		document.getElementById('ome-Format').value = ome_curFormatExport;

	} catch (e) {
		recup_erreur(e);
	}
}


function ome_selectModeLivraison() {
	try {

		if (ome_aModesLivraison.isSelected()) {
			var currentIndex = ome_aModesLivraison.getCurrentIndex();

			ome_curModeLivraisonId = ome_aModesLivraison.getCellText(currentIndex, 'ome-ColModeExpId');
			ome_curIntitule = ome_aModesLivraison.getCellText(currentIndex, 'ome-ColIntitule');

			document.getElementById('ome-intitule').value = ome_aModesLivraison.getCellText(currentIndex, 'ome-ColIntitule');
			document.getElementById('ome-typeLiv').value = ome_aModesLivraison.getCellText(currentIndex, 'ome-ColTypeLiv');
			document.getElementById('ome-Transporteur').value = ome_aModesLivraison.getCellText(currentIndex, 'ome-ColTransporteur');
			document.getElementById('ome-CodeTransport').value = ome_aModesLivraison.getCellText(currentIndex, 'ome-ColCodeTransport');
			document.getElementById('ome-CodeOption').value = ome_aModesLivraison.getCellText(currentIndex, 'ome-ColCodeOption');
			document.getElementById('ome-Num_Expediteur').value = ome_aModesLivraison.getCellText(currentIndex, 'ome-ColNumExpediteur');
			document.getElementById('ome-Actif').checked = (ome_aModesLivraison.getCellText(currentIndex, 'ome-ColActif')=="true");
			document.getElementById('ome-Assurance').checked = (ome_aModesLivraison.getCellText(currentIndex, 'ome-ColAssurance')=="true");
			document.getElementById('ome-Seuil_Assur').value = ome_aModesLivraison.getCellText(currentIndex, 'ome-ColSeuilAssur');
			document.getElementById('ome-MWM_Envoi_Trans_FTP').checked = (ome_aModesLivraison.getCellText(currentIndex, 'ome-ColMWMEnvoiTransFTP')=="true");
			document.getElementById('ome-Aut_Exp_DPA').checked = (ome_aModesLivraison.getCellText(currentIndex, 'ome-ColAutExpDPA')=="true");
			document.getElementById('ome-soldeAutoExclu').checked = (ome_aModesLivraison.getCellText(currentIndex, 'ome-colSoldeAutoExclu')=="true");
			document.getElementById('ome-Etape_Confirm_BL_CC').value = ome_aModesLivraison.getCellText(currentIndex, 'ome-ColEtapeConfirmBLCC');
			document.getElementById('ome-Etape_Confirm_BL_TS').value = ome_aModesLivraison.getCellText(currentIndex, 'ome-ColEtapeConfirmBLTS');
			document.getElementById('ome-Etape_Confirm_BL_RF').value = ome_aModesLivraison.getCellText(currentIndex, 'ome-ColEtapeConfirmBLRF');
			document.getElementById('ome-Etape_Confirm_OL').value = ome_aModesLivraison.getCellText(currentIndex, 'ome-ColEtapeConfirmOL');
			document.getElementById('ome-Etape_Confirm_LF').value = ome_aModesLivraison.getCellText(currentIndex, 'ome-ColEtapeConfirmLF');
			document.getElementById('ome-etiqTransArticle').checked = (ome_aModesLivraison.getCellText(currentIndex, 'ome-colEtiqTransArticle')=="true");
			document.getElementById('ome-etapePrepaBLCC').checked = (ome_aModesLivraison.getCellText(currentIndex, 'ome-colEtapePrepaBLCC')=="true");
			ome_chargerExport(ome_aModesLivraison.getCellText(currentIndex, 'ome-ColFormatDefaut'));

			ome_checkOnAssurance();
			document.getElementById('ome-bSupprimer').disabled = false;
			document.getElementById('ome-bNouveau').disabled = false;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function ome_nouveauMode() {
	try {

		ome_aModesLivraison.clearSelection();

		document.getElementById('ome-intitule').value = "";
		document.getElementById('ome-typeLiv').value = "E";
		document.getElementById('ome-Transporteur').value = "";
		document.getElementById('ome-CodeTransport').value = "";
		document.getElementById('ome-CodeOption').value = "";
		document.getElementById('ome-Num_Expediteur').value = "";
		document.getElementById('ome-Actif').checked = true;
		document.getElementById('ome-Assurance').checked = false;
		document.getElementById('ome-Seuil_Assur').value = "0";
		document.getElementById('ome-MWM_Envoi_Trans_FTP').checked = false;
		document.getElementById('ome-Aut_Exp_DPA').checked = false;
		document.getElementById('ome-soldeAutoExclu').checked = false;
		document.getElementById('ome-Etape_Confirm_BL_CC').value = "";
		document.getElementById('ome-Etape_Confirm_BL_TS').value = "";
		document.getElementById('ome-Etape_Confirm_BL_RF').value = "";
		document.getElementById('ome-Etape_Confirm_OL').value = "";
		document.getElementById('ome-Etape_Confirm_LF').value = "";
		document.getElementById('ome-etiqTransArticle').checked = false;
		document.getElementById('ome-etapePrepaBLCC').checked = false;

		ome_chargerExport("");
		ome_changeTypeLiv();
		ome_checkOnAssurance();

		document.getElementById('ome-bSupprimer').disabled = true;
		document.getElementById('ome-bNouveau').disabled = true;

		ome_curModeLivraisonId = '';
		ome_curIntitule = '';

	} catch (e) {
    recup_erreur(e);
  }
}


function ome_supprimerMode() {
	try {

		if (!isEmpty(ome_curModeLivraisonId) && window.confirm("Confirmez-vous la suppression du mode d'exp\u00E9dition '"+ ome_curIntitule +"' ?")) {

			var qSupprimerMode = new QueryHttp("Config/gc/expeditions/deleteModeExpedition.tmpl");
			qSupprimerMode.setParam("Mode_Exp_Id", ome_curModeLivraisonId);
			var result = qSupprimerMode.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				ome_aModesLivraison.initTree();
				ome_nouveauMode();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function ome_enregistrerMode() {
	try {

		var intitule = document.getElementById('ome-intitule').value;
		var typeLiv = document.getElementById('ome-typeLiv').value;
		var numFournisseur = document.getElementById('ome-Transporteur').value;
		var formatDefaut = document.getElementById('ome-Format').value;
		var codeTransport = document.getElementById('ome-CodeTransport').value;
		var codeOption = document.getElementById('ome-CodeOption').value;
		var numExpediteur = document.getElementById('ome-Num_Expediteur').value;
		var actif = document.getElementById('ome-Actif').checked;
		var assurance = document.getElementById('ome-Assurance').checked;
		var seuilAssur = document.getElementById('ome-Seuil_Assur').value;
		var mwmEnvoiTransFTP = document.getElementById('ome-MWM_Envoi_Trans_FTP').checked;
		var autExpDPA = document.getElementById('ome-Aut_Exp_DPA').checked;
		var soldeAutoExclu = document.getElementById('ome-soldeAutoExclu').checked;
		var etapeConfirmBLCC = document.getElementById('ome-Etape_Confirm_BL_CC').value;
		var etapeConfirmBLTS = document.getElementById('ome-Etape_Confirm_BL_TS').value;
		var etapeConfirmBLRF = document.getElementById('ome-Etape_Confirm_BL_RF').value;
		var etapeConfirmOL = document.getElementById('ome-Etape_Confirm_OL').value;
		var etapeConfirmLF = document.getElementById('ome-Etape_Confirm_LF').value;
		var etiqTransArticle = document.getElementById('ome-etiqTransArticle').checked;
		var etapePrepaBLCC = document.getElementById('ome-etapePrepaBLCC').checked;

		if (isEmpty(intitule)) {
			showWarning("Veuillez saisir l'intitul\u00E9 du mode d'exp\u00E9dition");
		}
		else if (!isPositiveOrNullInteger(seuilAssur)) {
			showWarning("Valeur de seuil pour l'assurance incorrecte");
		}
		else {
			var qSave;

			if (!isEmpty(ome_curModeLivraisonId)) {
				qSave = new QueryHttp("Config/gc/expeditions/updateModeExpedition.tmpl");
				qSave.setParam("Mode_Exp_Id", ome_curModeLivraisonId);
			}
			else {
				qSave = new QueryHttp("Config/gc/expeditions/createModeExpedition.tmpl");
			}

			qSave.setParam("Intitule", intitule);
			qSave.setParam("Type_Liv", typeLiv);
			qSave.setParam("Num_Fournisseur", numFournisseur);
			qSave.setParam("Format_Defaut", formatDefaut);
			qSave.setParam("Code_Transport", codeTransport);
			qSave.setParam("Code_Option", codeOption);
			qSave.setParam("Num_Expediteur", numExpediteur);
			qSave.setParam("Actif", actif);
			qSave.setParam("Assurance", assurance);
			qSave.setParam("Seuil_Assur", seuilAssur);
			qSave.setParam("MWM_Envoi_Trans_FTP", mwmEnvoiTransFTP);
			qSave.setParam("Etape_Confirm_BL_CC", etapeConfirmBLCC);
			qSave.setParam("Etape_Confirm_BL_TS", etapeConfirmBLTS);
			qSave.setParam("Etape_Confirm_BL_RF", etapeConfirmBLRF);
			qSave.setParam("Etape_Confirm_OL", etapeConfirmOL);
			qSave.setParam("Etape_Confirm_LF", etapeConfirmLF);
			qSave.setParam("Aut_Exp_DPA", autExpDPA);
			qSave.setParam("Solde_Auto_Exclu", soldeAutoExclu);
			qSave.setParam("Etiq_Trans_Article", etiqTransArticle);
			qSave.setParam("Etape_Prepa_BL_CC", etapePrepaBLCC);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				ome_aModesLivraison.initTree();
				ome_nouveauMode();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function ome_pressOnTypeLiv() {
	try {

		ome_changeTypeLiv();

		document.getElementById('ome-Transporteur').value = "";
		document.getElementById('ome-Format').value = "";
		document.getElementById('ome-CodeTransport').value = "";
		document.getElementById('ome-CodeOption').value = "";
		document.getElementById('ome-Num_Expediteur').value = "";

	} catch (e) {
    recup_erreur(e);
  }
}


function ome_changeTypeLiv() {
	try {

		var retrait = (document.getElementById('ome-typeLiv').value=="M");

		document.getElementById('ome-Transporteur').disabled = retrait;
		document.getElementById('ome-Format').disabled = retrait;
		document.getElementById('ome-CodeTransport').disabled = retrait;
		document.getElementById('ome-CodeOption').disabled = retrait;
		document.getElementById('ome-Num_Expediteur').disabled = retrait;

	} catch (e) {
    recup_erreur(e);
  }
}


function ome_checkOnAssurance() {
	try {

		document.getElementById('ome-rowSeuilAssur').collapsed = !document.getElementById('ome-Assurance').checked;
		if (!document.getElementById('ome-Assurance').checked) {
			document.getElementById('ome-Seuil_Assur').value = "0";
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function ome_rechercherFournisseur() {
	try {

		var url = "chrome://opensi/content/facturation/user/fournisseurs/popup-rechercheFournisseur.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', ome_retourRechercherFournisseur);

  } catch (e) {
    recup_erreur(e);
  }
}


function ome_retourRechercherFournisseur(numFournisseur) {
	try {

		document.getElementById('ome-Transporteur').value = numFournisseur;

	} catch (e) {
		recup_erreur(e);
	}
}
