/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var opex_curPEXBorneDefaut;
var opex_modified = false;



function opex_init() {
	try {

		var config = getResetConfig();

		var accMWM = getProfil().isAccMWM();

		document.getElementById('opex-boxMWMPicking').collapsed = !accMWM;
		document.getElementById('opex-boxMWMRetour').collapsed = !accMWM;
		document.getElementById('opex-boxMWMPrepa').collapsed = !accMWM;

		var aEtiquettes = new Arbre("ComboListe/combo-etiquettes.tmpl", "opex-Etiquette_Expedition");
		aEtiquettes.setParam("Type_Etiquette", "C");
		aEtiquettes.initTree(opex_init2);
		document.getElementById("opex-gpCycleCTC").collapsed = !adminMode;
		document.getElementById("opex-gpTransStock").collapsed = !adminMode;
		document.getElementById("opex-gpRetFour").collapsed = !adminMode;
		document.getElementById("opex-GAC_Envoi_Trans_FTP").collapsed = !adminMode;
		document.getElementById("opex-PEX_Envoi_Trans_FTP").collapsed = !adminMode;
		document.getElementById("opex-PEX_Envoi_Doc_FTP").collapsed = !adminMode;
		document.getElementById("opex-EXL_Envoi_Trans_FTP").collapsed = !adminMode;
		document.getElementById("opex-EXL_Envoi_Doc_FTP").collapsed = !adminMode;
		document.getElementById("opex-EXL_Groupement_Client").collapsed = !adminMode;
		document.getElementById("opex-EXL_Prefill_Date_Exp").collapsed = !adminMode;
		document.getElementById("opex-gpPrefixeExpedition").collapsed = !adminMode;
		document.getElementById("opex-boxEtapePicking").collapsed = !adminMode || !accMWM;
		document.getElementById("opex-Etape_Prepa_LF").collapsed = !adminMode;
		document.getElementById("opex-gpMaxCartonActif").collapsed = !adminMode;
		document.getElementById("opex-gpMaxOccurCarton").collapsed = !adminMode;
		document.getElementById("opex-boxEtiquetteCrossDock").collapsed = !config.isActCrossDock();
		document.getElementById("opex-boxTraitementECD").collapsed = !config.isActCrossDock();
		document.getElementById("opex-Pick_Reserve_GC").collapsed = !config.isActEmplacements();
		document.getElementById("opex-GDE_Pick_Asc").collapsed = !config.isActEmplacements();
		document.getElementById("opex-MWM_Picking_SB_Prem_Qte").collapsed = !adminMode;
		document.getElementById("opex-GAC_Date_Exp_Ligne").collapsed = !adminMode;
		document.getElementById("opex-Designation_CC_BP").collapsed = !adminMode;
		document.getElementById("opex-Trad_Url_Tracking").collapsed = !adminMode;
		document.getElementById("opex-MWM_PEX_Colisage").collapsed = !adminMode;
		document.getElementById("opex-MWM_PEX_Imp_Etiq").collapsed = !adminMode;
		document.getElementById("opex-MWM_PEX_Valid_Only").collapsed = !adminMode;
		document.getElementById("opex-MWM_PEX_Prefill_Poids").collapsed = !adminMode;
		document.getElementById("opex-PEX_Imp_Colisage").collapsed = !adminMode;
		document.getElementById("opex-PEX_Imp_Col_Multi").collapsed = !adminMode;
		document.getElementById("opex-Nomeref_FTP").collapsed = !adminMode;
		document.getElementById("opex-boxEtiquetteLigneExpedition").collapsed = !adminMode;
		document.getElementById("opex-Envoi_ELE_FTP").collapsed = !adminMode;

	} catch (e) {
    recup_erreur(e);
  }
}


function opex_init2() {
	try {

		var aEXLProvenance = new Arbre("ComboListe/combo-sitesWeb.tmpl", "opex-EXL_Provenance");
		aEXLProvenance.setParam("No_Check_Rights", true);
		aEXLProvenance.initTree(opex_init3);

	} catch (e) {
    recup_erreur(e);
  }
}


function opex_init3() {
	try {

		var aModesLivraison = new Arbre("ComboListe/combo-modesExpedition.tmpl", "opex-Def_Mode_Expedition");
		aModesLivraison.initTree(opex_init4);

	} catch (e) {
    recup_erreur(e);
  }
}


function opex_init4() {
	try {

		var aConfExp = new Arbre("ComboListe/combo-configExpedition.tmpl", "opex-EXL_Config");
		aConfExp.initTree(opex_init5);

	} catch (e) {
    recup_erreur(e);
  }
}


function opex_init5() {
	try {

		var aEtiquettesColisage = new Arbre("ComboListe/combo-etiquettes.tmpl", "opex-Etiquette_Colisage");
		aEtiquettesColisage.setParam("Type_Etiquette", "P");
		aEtiquettesColisage.initTree(opex_init6);

	} catch (e) {
    recup_erreur(e);
  }
}


function opex_init6() {
	try {

		var aEtiquettesCrossDock = new Arbre("ComboListe/combo-etiquettes.tmpl", "opex-Etiquette_Cross_Dock");
		aEtiquettesCrossDock.setParam("Type_Etiquette", "D");
		aEtiquettesCrossDock.initTree(opex_init7);

	} catch (e) {
    recup_erreur(e);
  }
}


function opex_init7() {
	try {

		var aEtiquettesBacPicking = new Arbre("ComboListe/combo-etiquettes.tmpl", "opex-Etiquette_Bac_Picking");
		aEtiquettesBacPicking.setParam("Type_Etiquette", "B");
		aEtiquettesBacPicking.initTree(opex_init8);

	} catch (e) {
    recup_erreur(e);
  }
}


function opex_init8() {
	try {

		var aEtiquettesLigneExpedition = new Arbre("ComboListe/combo-etiquettes.tmpl", "opex-Etiquette_Ligne_Expedition");
		aEtiquettesLigneExpedition.setParam("Type_Etiquette", "Z");
		aEtiquettesLigneExpedition.initTree(opex_loadPreferences);

	} catch (e) {
    recup_erreur(e);
  }
}


function opex_demandeEnregistrement() {
	try {

		if (opex_modified && window.confirm("Voulez-vous enregistrer les modifications apport\u00E9es ?")) {
			opex_updatePreferences();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function opex_loadPreferences() {
	try {

		var qLoad = new QueryHttp("Config/gc/expeditions/getPreferencesExpedition.tmpl");
		var result = qLoad.execute();
		var contenu = result.responseXML.documentElement;

		document.getElementById("opex-Com_BL").value = contenu.getAttribute("Com_BL");
		document.getElementById("opex-Commentaires_RC").value = contenu.getAttribute("Commentaires_RC");
		document.getElementById("opex-Url_CTC_Controler").value = contenu.getAttribute("Url_CTC_Controler");
		document.getElementById("opex-Colisage_Auto").checked = contenu.getAttribute("Colisage_Auto")=="true";
		document.getElementById("opex-Methode_Colisage").value = contenu.getAttribute("Methode_Colisage");
		document.getElementById("opex-Optim_Colisage").value = contenu.getAttribute("Optim_Colisage");
		document.getElementById("opex-Perte_Colisage").checked = contenu.getAttribute("Perte_Colisage")=="true";
		document.getElementById("opex-Etiquette_Expedition").value = contenu.getAttribute("Etiquette_Expedition");
		document.getElementById("opex-Etiquette_Ligne_Expedition").value = contenu.getAttribute("Etiquette_Ligne_Expedition");
		document.getElementById("opex-Etiquette_Colisage").value = contenu.getAttribute("Etiquette_Colisage");
		document.getElementById("opex-Etiquette_Cross_Dock").value = contenu.getAttribute("Etiquette_Cross_Dock");
		document.getElementById("opex-Resume_Colisage_BP").checked = contenu.getAttribute("Resume_Colisage_BP")=="true";
		document.getElementById("opex-Col_Colisage_BP").checked = contenu.getAttribute("Col_Colisage_BP")=="true";
		document.getElementById("opex-Export_CN23").checked = contenu.getAttribute("Export_CN23")=="true";
		document.getElementById("opex-Prefixe_Expedition").value = contenu.getAttribute("Prefixe_Expedition");
		document.getElementById("opex-GAC_Edit_BP").checked = contenu.getAttribute("GAC_Edit_BP")=="true";
		document.getElementById("opex-GAC_Edit_CF").checked = contenu.getAttribute("GAC_Edit_CF")=="true";
		document.getElementById("opex-GAC_Edit_LF").checked = contenu.getAttribute("GAC_Edit_LF")=="true";
		document.getElementById("opex-GAC_Envoi_Trans_FTP").checked = contenu.getAttribute("GAC_Envoi_Trans_FTP")=="true";
		document.getElementById("opex-GTS_Envoi_Trans_FTP").checked = contenu.getAttribute("GTS_Envoi_Trans_FTP")=="true";
		document.getElementById("opex-GRF_Envoi_Trans_FTP").checked = contenu.getAttribute("GRF_Envoi_Trans_FTP")=="true";
		document.getElementById("opex-Act_Depot_Ligne_CC").checked = contenu.getAttribute("Act_Depot_Ligne_CC")=="true";
		document.getElementById("opex-Bloquer_BL_Sans_Stock").checked = contenu.getAttribute("Bloquer_BL_Sans_Stock")=="true";
		document.getElementById("opex-Solde_Auto_CC").checked = contenu.getAttribute("Solde_Auto_CC")=="true";
		document.getElementById("opex-Solde_Auto_Hors_CB").checked = contenu.getAttribute("Solde_Auto_Hors_CB")=="true";
		document.getElementById("opex-EXL_Provenance").value = contenu.getAttribute("EXL_Provenance");
		document.getElementById("opex-EXL_Etat_Paiement").value = contenu.getAttribute("EXL_Etat_Paiement");
		document.getElementById("opex-EXL_Expediable").value = contenu.getAttribute("EXL_Expediable");
		document.getElementById("opex-EXT_Expediable").value = contenu.getAttribute("EXT_Expediable");
		document.getElementById("opex-EXL_Config").value = contenu.getAttribute("EXL_Config");
		document.getElementById("opex-EXL_Bac_Prepa").checked = contenu.getAttribute("EXL_Bac_Prepa")=="true";
		document.getElementById("opex-Ordre_Inverse_Bacs").checked = contenu.getAttribute("Ordre_Inverse_Bacs")=="true";
		document.getElementById("opex-EXL_Confirmation").checked = contenu.getAttribute("EXL_Confirmation")=="true";
		document.getElementById("opex-EXL_Envoi_Trans_FTP").checked = contenu.getAttribute("EXL_Envoi_Trans_FTP")=="true";
		document.getElementById("opex-EXL_Envoi_Doc_FTP").checked = contenu.getAttribute("EXL_Envoi_Doc_FTP")=="true";
		document.getElementById("opex-EXL_Groupement_Client").checked = contenu.getAttribute("EXL_Groupement_Client")=="true";
		document.getElementById("opex-EXL_Prefill_Date_Exp").checked = contenu.getAttribute("EXL_Prefill_Date_Exp")=="true";
		document.getElementById("opex-ECD_Prefill_Date_Exp").checked = contenu.getAttribute("ECD_Prefill_Date_Exp")=="true";
		document.getElementById("opex-Col_Photo_BP").checked = contenu.getAttribute("Col_Photo_BP")=="true";
		document.getElementById("opex-Designation_CC_BP").checked = contenu.getAttribute("Designation_CC_BP")=="true";
		document.getElementById("opex-Col_Photo_PK").checked = contenu.getAttribute("Col_Photo_PK")=="true";
		document.getElementById("opex-BL_Chiffre").checked = contenu.getAttribute("BL_Chiffre")=="true";
		document.getElementById("opex-Def_Mode_Expedition").value = contenu.getAttribute("Def_Mode_Expedition");
		document.getElementById("opex-PEX_Avoid_Chk").checked = contenu.getAttribute("PEX_Avoid_Chk")=="true";
		document.getElementById("opex-PEX_Regul_Stock").checked = contenu.getAttribute("PEX_Regul_Stock")=="true";
		document.getElementById("opex-PEX_Edit_BL").checked = contenu.getAttribute("PEX_Edit_BL")=="true";
		document.getElementById("opex-PEX_Gen_FC").checked = contenu.getAttribute("PEX_Gen_FC")=="true";
		document.getElementById("opex-PEX_Edit_FC").checked = contenu.getAttribute("PEX_Edit_FC")=="true";
		document.getElementById("opex-PEX_Envoi_Trans_FTP").checked = contenu.getAttribute("PEX_Envoi_Trans_FTP")=="true";
		document.getElementById("opex-PEX_Envoi_Doc_FTP").checked = contenu.getAttribute("PEX_Envoi_Doc_FTP")=="true";
		opex_curPEXBorneDefaut = contenu.getAttribute("PEX_Borne_Defaut");
		document.getElementById("opex-PEX_New_Client").checked = contenu.getAttribute("PEX_New_Client")=="true";
		document.getElementById("opex-Nb_CC_New_Client").value = contenu.getAttribute("Nb_CC_New_Client");
		document.getElementById("opex-Pick_Reserve_GC").checked = contenu.getAttribute("Pick_Reserve_GC")=="true";
		document.getElementById("opex-GDE_Pick_Asc").checked = contenu.getAttribute("GDE_Pick_Asc")=="true";
		document.getElementById("opex-Col_Ref_Fabricant_BP").checked = contenu.getAttribute("Col_Ref_Fabricant_BP")=="true";
		document.getElementById("opex-Col_Ref_Fabricant_PK").checked = contenu.getAttribute("Col_Ref_Fabricant_PK")=="true";
		document.getElementById("opex-Reliquats_LF").checked = contenu.getAttribute("Reliquats_LF")=="true";
		document.getElementById("opex-Etape_Picking_BL_CC").checked = contenu.getAttribute("Etape_Picking_BL_CC")=="true";
		document.getElementById("opex-Etape_Picking_BL_TS").checked = contenu.getAttribute("Etape_Picking_BL_TS")=="true";
		document.getElementById("opex-Etape_Prepa_BL_CC").checked = contenu.getAttribute("Etape_Prepa_BL_CC")=="true";
		document.getElementById("opex-Etape_Prepa_BL_TS").checked = contenu.getAttribute("Etape_Prepa_BL_TS")=="true";
		document.getElementById("opex-Etape_Prepa_BL_RF").checked = contenu.getAttribute("Etape_Prepa_BL_RF")=="true";
		document.getElementById("opex-Etape_Prepa_OL").checked = contenu.getAttribute("Etape_Prepa_OL")=="true";
		document.getElementById("opex-Etape_Prepa_LF").checked = contenu.getAttribute("Etape_Prepa_LF")=="true";
		document.getElementById("opex-Etape_Confirm_BL_CC").checked = contenu.getAttribute("Etape_Confirm_BL_CC")=="true";
		document.getElementById("opex-Etape_Confirm_BL_TS").checked = contenu.getAttribute("Etape_Confirm_BL_TS")=="true";
		document.getElementById("opex-Etape_Confirm_BL_RF").checked = contenu.getAttribute("Etape_Confirm_BL_RF")=="true";
		document.getElementById("opex-Etape_Confirm_OL").checked = contenu.getAttribute("Etape_Confirm_OL")=="true";
		document.getElementById("opex-Etape_Confirm_LF").checked = contenu.getAttribute("Etape_Confirm_LF")=="true";
		document.getElementById("opex-MWM_Picking_Scan_Bac").checked = contenu.getAttribute("MWM_Picking_Scan_Bac")=="true";
		document.getElementById("opex-MWM_Picking_SB_Prem_Qte").checked = contenu.getAttribute("MWM_Picking_SB_Prem_Qte")=="true";
		document.getElementById("opex-MWM_Mode_Picking").value = contenu.getAttribute("MWM_Mode_Picking");
		document.getElementById("opex-MWM_Controle_Picking").checked = contenu.getAttribute("MWM_Controle_Picking")=="true";
		document.getElementById("opex-MWM_Ctrl_Pick_First").checked = contenu.getAttribute("MWM_Ctrl_Pick_First")=="true";
		document.getElementById("opex-MWM_Ctrl_Pick_Manquant").checked = contenu.getAttribute("MWM_Ctrl_Pick_Manquant")=="true";
		document.getElementById("opex-Etiquette_Bac_Picking").value = contenu.getAttribute("Etiquette_Bac_Picking");
		document.getElementById("opex-Max_Carton_Actif").value = contenu.getAttribute("Max_Carton_Actif");
		document.getElementById("opex-Max_Occur_Carton").value = contenu.getAttribute("Max_Occur_Carton");
		document.getElementById("opex-EXL_Max_CC").value = contenu.getAttribute("EXL_Max_CC");
		document.getElementById("opex-EXT_Max_TS").value = contenu.getAttribute("EXT_Max_TS");
		document.getElementById("opex-PEX_Borne_Resp").checked = contenu.getAttribute("PEX_Borne_Resp")=="true";
		document.getElementById("opex-MWM_Avoir_Retour").checked = contenu.getAttribute("MWM_Avoir_Retour")=="true";
		document.getElementById("opex-GAC_Date_Exp_Ligne").checked = contenu.getAttribute("GAC_Date_Exp_Ligne")=="true";
		document.getElementById("opex-Trad_Url_Tracking").checked = contenu.getAttribute("Trad_Url_Tracking")=="true";
		document.getElementById("opex-MWM_PEX_Ref_Attendue").checked = contenu.getAttribute("MWM_PEX_Ref_Attendue")=="true";
		document.getElementById("opex-MWM_PEX_Scan_Avant_Qte").checked = contenu.getAttribute("MWM_PEX_Scan_Avant_Qte")=="true";
		document.getElementById("opex-Show_Cols_Douane_Colisage").checked = contenu.getAttribute("Show_Cols_Douane_Colisage")=="true";
		document.getElementById("opex-MWM_PEX_Colisage").checked = contenu.getAttribute("MWM_PEX_Colisage")=="true";
		document.getElementById("opex-MWM_PEX_Imp_Etiq").checked = contenu.getAttribute("MWM_PEX_Imp_Etiq")=="true";
		document.getElementById("opex-MWM_PEX_Valid_Only").checked = contenu.getAttribute("MWM_PEX_Valid_Only")=="true";
		document.getElementById("opex-MWM_PEX_Prefill_Poids").checked = contenu.getAttribute("MWM_PEX_Prefill_Poids")=="true";
		document.getElementById("opex-PEX_Imp_Colisage").checked = contenu.getAttribute("PEX_Imp_Colisage")=="true";
		document.getElementById("opex-PEX_Imp_Col_Multi").checked = contenu.getAttribute("PEX_Imp_Col_Multi")=="true";
		document.getElementById("opex-Show_Filigrane_NP_BP").checked = contenu.getAttribute("Show_Filigrane_NP_BP")=="true";
		document.getElementById("opex-PEX_Alerte_NP").checked = contenu.getAttribute("PEX_Alerte_NP")=="true";
		document.getElementById("opex-GAC_Alerte_NP_BP").checked = contenu.getAttribute("GAC_Alerte_NP_BP")=="true";
		document.getElementById("opex-Nomeref_FTP").checked = contenu.getAttribute("Nomeref_FTP")=="true";
		document.getElementById("opex-Envoi_ELE_FTP").checked = contenu.getAttribute("Envoi_ELE_FTP")=="true";
		document.getElementById("opex-MWM_PEX_Aff_Forfait").checked = contenu.getAttribute("MWM_PEX_Aff_Forfait")=="true";

		var aPEXBorneDefaut = new Arbre("ComboListe/combo-bornesImpression.tmpl", "opex-PEX_Borne_Defaut");
		aPEXBorneDefaut.setParam("Selection", opex_curPEXBorneDefaut);
		aPEXBorneDefaut.initTree(opex_setPEXBorneDefaut);

		opex_checkOptimisation();
		opex_checkPEXGenFC();
		opex_checkSoldeAutoCC();
		opex_checkEXLBacPrepa();
		opex_checkModePicking();
		opex_checkMWMPickingScanBac();
		opex_checkMWMPEXColisage();
		opex_checkPEXImpColisage();

		document.getElementById("opex-bEnregistrer").disabled = false;

		opex_setModified(false);

	} catch (e) {
    recup_erreur(e);
  }
}


function opex_setPEXBorneDefaut() {
	try {

		document.getElementById("opex-PEX_Borne_Defaut").value = opex_curPEXBorneDefaut;

	} catch (e) {
    recup_erreur(e);
  }
}


function opex_updatePreferences() {
	try {

		var comBL = document.getElementById("opex-Com_BL").value;
		var commentairesRC = document.getElementById("opex-Commentaires_RC").value;
		var urlCTCControler = document.getElementById("opex-Url_CTC_Controler").value;
		var colisageAuto = document.getElementById("opex-Colisage_Auto").checked;
		var methodeColisage = document.getElementById("opex-Methode_Colisage").value;
		var optimColisage = document.getElementById("opex-Optim_Colisage").value;
		var perteColisage = document.getElementById("opex-Perte_Colisage").checked;
		var etiquetteExpedition = document.getElementById("opex-Etiquette_Expedition").value;
		var etiquetteLigneExpedition = document.getElementById("opex-Etiquette_Ligne_Expedition").value;
		var etiquetteColisage = document.getElementById("opex-Etiquette_Colisage").value;
		var etiquetteCrossDock = document.getElementById("opex-Etiquette_Cross_Dock").value;
		var resumeColisageBP = document.getElementById("opex-Resume_Colisage_BP").checked;
		var colColisageBP = document.getElementById("opex-Col_Colisage_BP").checked;
		var exportCN23 = document.getElementById("opex-Export_CN23").checked;
		var prefixeExpedition = document.getElementById("opex-Prefixe_Expedition").value;
		var gacEditBP = document.getElementById("opex-GAC_Edit_BP").checked;
		var gacEditCF = document.getElementById("opex-GAC_Edit_CF").checked;
		var gacEditLF = document.getElementById("opex-GAC_Edit_LF").checked;
		var gacEnvoiTransFTP = document.getElementById("opex-GAC_Envoi_Trans_FTP").checked;
		var gtsEnvoiTransFTP = document.getElementById("opex-GTS_Envoi_Trans_FTP").checked;
		var grfEnvoiTransFTP = document.getElementById("opex-GRF_Envoi_Trans_FTP").checked;
		var actDepotLigneCC = document.getElementById("opex-Act_Depot_Ligne_CC").checked;
		var bloquerBLSansStock = document.getElementById("opex-Bloquer_BL_Sans_Stock").checked;
		var soldeAutoCC = document.getElementById("opex-Solde_Auto_CC").checked;
		var soldeAutoHorsCB = document.getElementById("opex-Solde_Auto_Hors_CB").checked;
		var exlProvenance = document.getElementById("opex-EXL_Provenance").value;
		var exlEtatPaiement = document.getElementById("opex-EXL_Etat_Paiement").value;
		var exlExpediable = document.getElementById("opex-EXL_Expediable").value;
		var extExpediable = document.getElementById("opex-EXT_Expediable").value;
		var exlConfig = document.getElementById("opex-EXL_Config").value;
		var exlBacPrepa = document.getElementById("opex-EXL_Bac_Prepa").checked;
		var ordreInverseBacs = document.getElementById("opex-Ordre_Inverse_Bacs").checked;
		var exlConfirmation = document.getElementById("opex-EXL_Confirmation").checked;
		var exlEnvoiTransFTP = document.getElementById("opex-EXL_Envoi_Trans_FTP").checked;
		var exlEnvoiDocFTP = document.getElementById("opex-EXL_Envoi_Doc_FTP").checked;
		var exlGroupementClient = document.getElementById("opex-EXL_Groupement_Client").checked;
		var exlPrefillDateExp = document.getElementById("opex-EXL_Prefill_Date_Exp").checked;
		var ecdPrefillDateExp = document.getElementById("opex-ECD_Prefill_Date_Exp").checked;
		var colPhotoBP = document.getElementById("opex-Col_Photo_BP").checked;
		var designationCCBP = document.getElementById("opex-Designation_CC_BP").checked;
		var colPhotoPK = document.getElementById("opex-Col_Photo_PK").checked;
		var blChiffre = document.getElementById("opex-BL_Chiffre").checked;
		var defModeExpedition = document.getElementById("opex-Def_Mode_Expedition").value;
		var pexAvoidChk = document.getElementById("opex-PEX_Avoid_Chk").checked;
		var pexRegulStock = document.getElementById("opex-PEX_Regul_Stock").checked;
		var pexEditBL = document.getElementById("opex-PEX_Edit_BL").checked;
		var pexGenFC = document.getElementById("opex-PEX_Gen_FC").checked;
		var pexEditFC = document.getElementById("opex-PEX_Edit_FC").checked;
		var pexEnvoiTransFTP = document.getElementById("opex-PEX_Envoi_Trans_FTP").checked;
		var pexEnvoiDocFTP = document.getElementById("opex-PEX_Envoi_Doc_FTP").checked;
		var pexBorneDefaut = document.getElementById("opex-PEX_Borne_Defaut").value;
		var pexNewClient = document.getElementById("opex-PEX_New_Client").checked;
		var nbCCNewClient = document.getElementById("opex-Nb_CC_New_Client").value;
		var pickReserveGC = document.getElementById("opex-Pick_Reserve_GC").checked;
		var gdePickAsc = document.getElementById("opex-GDE_Pick_Asc").checked;
		var colRefFabricantBP = document.getElementById("opex-Col_Ref_Fabricant_BP").checked;
		var colRefFabricantPK = document.getElementById("opex-Col_Ref_Fabricant_PK").checked;
		var reliquatsLF = document.getElementById("opex-Reliquats_LF").checked;
		var etapePickingBLCC = document.getElementById("opex-Etape_Picking_BL_CC").checked;
		var etapePickingBLTS = document.getElementById("opex-Etape_Picking_BL_TS").checked;
		var etapePrepaBLCC = document.getElementById("opex-Etape_Prepa_BL_CC").checked;
		var etapePrepaBLTS = document.getElementById("opex-Etape_Prepa_BL_TS").checked;
		var etapePrepaBLRF = document.getElementById("opex-Etape_Prepa_BL_RF").checked;
		var etapePrepaOL = document.getElementById("opex-Etape_Prepa_OL").checked;
		var etapePrepaLF = document.getElementById("opex-Etape_Prepa_LF").checked;
		var etapeConfirmBLCC = document.getElementById("opex-Etape_Confirm_BL_CC").checked;
		var etapeConfirmBLTS = document.getElementById("opex-Etape_Confirm_BL_TS").checked;
		var etapeConfirmBLRF = document.getElementById("opex-Etape_Confirm_BL_RF").checked;
		var etapeConfirmOL = document.getElementById("opex-Etape_Confirm_OL").checked;
		var etapeConfirmLF = document.getElementById("opex-Etape_Confirm_LF").checked;
		var mwmPickingScanBac = document.getElementById("opex-MWM_Picking_Scan_Bac").checked;
		var mwmPickingSBPremQte = document.getElementById("opex-MWM_Picking_SB_Prem_Qte").checked;
		var mwmModePicking = document.getElementById("opex-MWM_Mode_Picking").value;
		var mwmControlePicking = document.getElementById("opex-MWM_Controle_Picking").checked;
		var mwmCtrlPickFirst = document.getElementById("opex-MWM_Ctrl_Pick_First").checked;
		var mwmCtrlPickManquant = document.getElementById("opex-MWM_Ctrl_Pick_Manquant").checked;
		var etiquetteBacPicking = document.getElementById("opex-Etiquette_Bac_Picking").value;
		var maxCartonActif = document.getElementById("opex-Max_Carton_Actif").value;
		var maxOccurCarton = document.getElementById("opex-Max_Occur_Carton").value;
		var exlMaxCC = document.getElementById("opex-EXL_Max_CC").value;
		var extMaxTS = document.getElementById("opex-EXT_Max_TS").value;
		var pexBorneResp = document.getElementById("opex-PEX_Borne_Resp").checked;
		var mwmAvoirRetour = document.getElementById("opex-MWM_Avoir_Retour").checked;
		var gacDateExpLigne = document.getElementById("opex-GAC_Date_Exp_Ligne").checked;
		var tradUrlTracking = document.getElementById("opex-Trad_Url_Tracking").checked;
		var mwmPEXRefAttendue = document.getElementById("opex-MWM_PEX_Ref_Attendue").checked;
		var mwmPEXScanAvantQte = document.getElementById("opex-MWM_PEX_Scan_Avant_Qte").checked;
		var showColsDouaneColisage = document.getElementById("opex-Show_Cols_Douane_Colisage").checked;
		var mwmPEXColisage = document.getElementById("opex-MWM_PEX_Colisage").checked;
		var mwmPEXImpEtiq = document.getElementById("opex-MWM_PEX_Imp_Etiq").checked;
		var mwmPEXValidOnly = document.getElementById("opex-MWM_PEX_Valid_Only").checked;
		var mwmPEXPrefillPoids = document.getElementById("opex-MWM_PEX_Prefill_Poids").checked;
		var pexImpColisage = document.getElementById("opex-PEX_Imp_Colisage").checked;
		var pexImpColMulti = document.getElementById("opex-PEX_Imp_Col_Multi").checked;
		var showFiligraneNPBP = document.getElementById("opex-Show_Filigrane_NP_BP").checked;
		var pexAlerteNP = document.getElementById("opex-PEX_Alerte_NP").checked;
		var gacAlerteNPBP = document.getElementById("opex-GAC_Alerte_NP_BP").checked;
		var nomerefFTP = document.getElementById("opex-Nomeref_FTP").checked;
		var envoiELEFTP = document.getElementById("opex-Envoi_ELE_FTP").checked;
		var mwmPEXAffForfait = document.getElementById("opex-MWM_PEX_Aff_Forfait").checked;

		if (!isPositiveInteger(maxCartonActif)) { showWarning("Maximum de mod\u00E8les de carton actifs incorrect"); }
		else if (!isPositiveInteger(maxOccurCarton)) { showWarning("Nombre maximum d'occurences d'un m\u00EAme carton incorrect"); }
		else if (Math.pow(parseIntBis(maxOccurCarton)+1,maxCartonActif)>Math.pow(2,25)) { showWarning("Combinaison maximum mod\u00E8les de carton / nb occurences non autoris\u00E9"); }
		else if (!isPositiveInteger(exlMaxCC) || parseIntBis(exlMaxCC)>250) { showWarning("Nb maximum de commandes par lot incorrect (max. 250)"); }
		else if (!isPositiveInteger(extMaxTS) || parseIntBis(extMaxTS)>250) { showWarning("Nb maximum de transferts par lot incorrect (max. 250)"); }
		else if (!gacEditCF && !gacEditLF) { showWarning("Vous devez cocher au moins une des deux cases 'Editer la commande fournisseur' ou 'Editer le bon de livraison' pour les commandes directes fournisseurs"); }
		else if (!isPositiveInteger(nbCCNewClient)) { showWarning("Nombre de commandes pour la mention \u0022nouveau client\u0022 incorrect"); }
		else {
			var qUpdate = new QueryHttp("Config/gc/expeditions/updatePreferencesExpedition.tmpl");

			qUpdate.setParam("Com_BL", comBL);
			qUpdate.setParam("Commentaires_RC", commentairesRC);
			qUpdate.setParam("Url_CTC_Controler", urlCTCControler);
			qUpdate.setParam("Colisage_Auto", colisageAuto);
			qUpdate.setParam("Methode_Colisage", methodeColisage);
			qUpdate.setParam("Optim_Colisage", optimColisage);
			qUpdate.setParam("Perte_Colisage", perteColisage);
			qUpdate.setParam("Etiquette_Expedition", etiquetteExpedition);
			qUpdate.setParam("Etiquette_Ligne_Expedition", etiquetteLigneExpedition);
			qUpdate.setParam("Etiquette_Colisage", etiquetteColisage);
			qUpdate.setParam("Etiquette_Cross_Dock", etiquetteCrossDock);
			qUpdate.setParam("Resume_Colisage_BP", resumeColisageBP);
			qUpdate.setParam("Col_Colisage_BP", colColisageBP);
			qUpdate.setParam("Export_CN23", exportCN23);
			qUpdate.setParam("Prefixe_Expedition", prefixeExpedition);
			qUpdate.setParam("GAC_Edit_BP", gacEditBP);
			qUpdate.setParam("GAC_Edit_CF", gacEditCF);
			qUpdate.setParam("GAC_Edit_LF", gacEditLF);
			qUpdate.setParam("GAC_Envoi_Trans_FTP", gacEnvoiTransFTP);
			qUpdate.setParam("GTS_Envoi_Trans_FTP", gtsEnvoiTransFTP);
			qUpdate.setParam("GRF_Envoi_Trans_FTP", grfEnvoiTransFTP);
			qUpdate.setParam("Act_Depot_Ligne_CC", actDepotLigneCC);
			qUpdate.setParam("Bloquer_BL_Sans_Stock", bloquerBLSansStock);
			qUpdate.setParam("Solde_Auto_CC", soldeAutoCC);
			qUpdate.setParam("Solde_Auto_Hors_CB", soldeAutoHorsCB);
			qUpdate.setParam("EXL_Provenance", exlProvenance);
			qUpdate.setParam("EXL_Etat_Paiement", exlEtatPaiement);
			qUpdate.setParam("EXL_Expediable", exlExpediable);
			qUpdate.setParam("EXT_Expediable", extExpediable);
			qUpdate.setParam("EXL_Config", exlConfig);
			qUpdate.setParam("EXL_Bac_Prepa", exlBacPrepa);
			qUpdate.setParam("Ordre_Inverse_Bacs", ordreInverseBacs);
			qUpdate.setParam("EXL_Confirmation", exlConfirmation);
			qUpdate.setParam("EXL_Envoi_Trans_FTP", exlEnvoiTransFTP);
			qUpdate.setParam("EXL_Envoi_Doc_FTP", exlEnvoiDocFTP);
			qUpdate.setParam("EXL_Groupement_Client", exlGroupementClient);
			qUpdate.setParam("EXL_Prefill_Date_Exp", exlPrefillDateExp);
			qUpdate.setParam("ECD_Prefill_Date_Exp", ecdPrefillDateExp);
			qUpdate.setParam("Col_Photo_BP", colPhotoBP);
			qUpdate.setParam("Designation_CC_BP", designationCCBP);
			qUpdate.setParam("Col_Photo_PK", colPhotoPK);
			qUpdate.setParam("BL_Chiffre", blChiffre);
			qUpdate.setParam("Def_Mode_Expedition", defModeExpedition);
			qUpdate.setParam("PEX_Avoid_Chk", pexAvoidChk);
			qUpdate.setParam("PEX_Regul_Stock", pexRegulStock);
			qUpdate.setParam("PEX_Edit_BL", pexEditBL);
			qUpdate.setParam("PEX_Gen_FC", pexGenFC);
			qUpdate.setParam("PEX_Edit_FC", pexEditFC);
			qUpdate.setParam("PEX_Envoi_Trans_FTP", pexEnvoiTransFTP);
			qUpdate.setParam("PEX_Envoi_Doc_FTP", pexEnvoiDocFTP);
			qUpdate.setParam("PEX_Borne_Defaut", pexBorneDefaut);
			qUpdate.setParam("PEX_New_Client", pexNewClient);
			qUpdate.setParam("Nb_CC_New_Client", nbCCNewClient);
			qUpdate.setParam("Pick_Reserve_GC", pickReserveGC);
			qUpdate.setParam("GDE_Pick_Asc", gdePickAsc);
			qUpdate.setParam("Col_Ref_Fabricant_BP", colRefFabricantBP);
			qUpdate.setParam("Col_Ref_Fabricant_PK", colRefFabricantPK);
			qUpdate.setParam("Reliquats_LF", reliquatsLF);
			qUpdate.setParam("Etape_Picking_BL_CC", etapePickingBLCC);
			qUpdate.setParam("Etape_Picking_BL_TS", etapePickingBLTS);
			qUpdate.setParam("Etape_Prepa_BL_CC", etapePrepaBLCC);
			qUpdate.setParam("Etape_Prepa_BL_TS", etapePrepaBLTS);
			qUpdate.setParam("Etape_Prepa_BL_RF", etapePrepaBLRF);
			qUpdate.setParam("Etape_Prepa_OL", etapePrepaOL);
			qUpdate.setParam("Etape_Prepa_LF", etapePrepaLF);
			qUpdate.setParam("Etape_Confirm_BL_CC", etapeConfirmBLCC);
			qUpdate.setParam("Etape_Confirm_BL_TS", etapeConfirmBLTS);
			qUpdate.setParam("Etape_Confirm_BL_RF", etapeConfirmBLRF);
			qUpdate.setParam("Etape_Confirm_OL", etapeConfirmOL);
			qUpdate.setParam("Etape_Confirm_LF", etapeConfirmLF);
			qUpdate.setParam("MWM_Picking_Scan_Bac", mwmPickingScanBac);
			qUpdate.setParam("MWM_Picking_SB_Prem_Qte", mwmPickingSBPremQte);
			qUpdate.setParam("MWM_Mode_Picking", mwmModePicking);
			qUpdate.setParam("MWM_Controle_Picking", mwmControlePicking);
			qUpdate.setParam("MWM_Ctrl_Pick_First", mwmCtrlPickFirst);
			qUpdate.setParam("MWM_Ctrl_Pick_Manquant", mwmCtrlPickManquant);
			qUpdate.setParam("Etiquette_Bac_Picking", etiquetteBacPicking);
			qUpdate.setParam("Max_Carton_Actif", maxCartonActif);
			qUpdate.setParam("Max_Occur_Carton", maxOccurCarton);
			qUpdate.setParam("EXL_Max_CC", exlMaxCC);
			qUpdate.setParam("EXT_Max_TS", extMaxTS);
			qUpdate.setParam("PEX_Borne_Resp", pexBorneResp);
			qUpdate.setParam("MWM_Avoir_Retour", mwmAvoirRetour);
			qUpdate.setParam("GAC_Date_Exp_Ligne", gacDateExpLigne);
			qUpdate.setParam("Trad_Url_Tracking", tradUrlTracking);
			qUpdate.setParam("MWM_PEX_Ref_Attendue", mwmPEXRefAttendue);
			qUpdate.setParam("MWM_PEX_Scan_Avant_Qte", mwmPEXScanAvantQte);
			qUpdate.setParam("Show_Cols_Douane_Colisage", showColsDouaneColisage);
			qUpdate.setParam("MWM_PEX_Colisage", mwmPEXColisage);
			qUpdate.setParam("MWM_PEX_Imp_Etiq", mwmPEXImpEtiq);
			qUpdate.setParam("MWM_PEX_Valid_Only", mwmPEXValidOnly);
			qUpdate.setParam("MWM_PEX_Prefill_Poids", mwmPEXPrefillPoids);
			qUpdate.setParam("PEX_Imp_Colisage", pexImpColisage);
			qUpdate.setParam("PEX_Imp_Col_Multi", pexImpColMulti);
			qUpdate.setParam("Show_Filigrane_NP_BP", showFiligraneNPBP);
			qUpdate.setParam("PEX_Alerte_NP", pexAlerteNP);
			qUpdate.setParam("GAC_Alerte_NP_BP", gacAlerteNPBP);
			qUpdate.setParam("Nomeref_FTP", nomerefFTP);
			qUpdate.setParam("Envoi_ELE_FTP", envoiELEFTP);
			qUpdate.setParam("MWM_PEX_Aff_Forfait", mwmPEXAffForfait);

			var result = qUpdate.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				opex_setModified(false);
				showMessage("Pr\u00E9f\u00E9rences d'exp\u00E9dition sauvegard\u00E9es");
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function opex_checkPerteColisage() {
	try {

		document.getElementById("opex-Perte_Colisage").disabled = (document.getElementById("opex-Optim_Colisage").value=="C" || document.getElementById("opex-Methode_Colisage").value=="Q");

	} catch (e) {
		recup_erreur(e);
	}
}


function opex_checkOptimisation() {
	try {

		var blocked = (document.getElementById("opex-Methode_Colisage").value!="V");
		document.getElementById("opex-Optim_Colisage").disabled = blocked;
		opex_checkPerteColisage();

	} catch (e) {
		recup_erreur(e);
	}
}


function opex_checkPEXGenFC() {
	try {

		var chkCreerFacture = document.getElementById('opex-PEX_Gen_FC').checked;
		document.getElementById('opex-PEX_Edit_FC').disabled = !chkCreerFacture;
		if (!chkCreerFacture) {
			document.getElementById('opex-PEX_Edit_FC').checked = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function opex_checkSoldeAutoCC() {
	try {

		document.getElementById("opex-Solde_Auto_Hors_CB").disabled = !document.getElementById("opex-Solde_Auto_CC").checked;

	} catch (e) {
		recup_erreur(e);
	}
}


function opex_checkMWMPickingScanBac() {
	try {

		document.getElementById("opex-MWM_Picking_SB_Prem_Qte").disabled = !document.getElementById("opex-MWM_Picking_Scan_Bac").checked;

	} catch (e) {
		recup_erreur(e);
	}
}


function opex_checkMWMPEXColisage() {
	try {

		document.getElementById("opex-MWM_PEX_Prefill_Poids").disabled = !document.getElementById("opex-MWM_PEX_Colisage").checked;

	} catch (e) {
		recup_erreur(e);
	}
}


function opex_checkEXLBacPrepa() {
	try {

		document.getElementById("opex-EXL_Groupement_Client").disabled = document.getElementById("opex-EXL_Bac_Prepa").checked;
		document.getElementById("opex-Ordre_Inverse_Bacs").collapsed = !document.getElementById("opex-EXL_Bac_Prepa").checked;

	} catch (e) {
		recup_erreur(e);
	}
}


function opex_checkModePicking() {
	try {

		document.getElementById("opex-rowEtiquetteBacPicking").collapsed = document.getElementById("opex-MWM_Mode_Picking").value!="C";

	} catch (e) {
		recup_erreur(e);
	}
}


function opex_checkPEXImpColisage() {
	try {

		document.getElementById("opex-PEX_Imp_Col_Multi").disabled = !document.getElementById("opex-PEX_Imp_Colisage").checked;

	} catch (e) {
		recup_erreur(e);
	}
}


function opex_setModified(modified) {
	try {

		opex_modified = modified;
		document.getElementById('opex-imgModified').collapsed = !modified;

	} catch (e) {
		recup_erreur(e);
	}
}

