/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var omd_aMentions = new Arbre("Config/gc/list-mention.tmpl", "omd-listeMentions");

var omd_currentMentionId = "";



function omd_init() {
	try {

		omd_listerMentions();

	} catch (e) {
    recup_erreur(e);
  }
}


function omd_listerMentions() {
	try {

		omd_aMentions.setParam("Actif", document.getElementById("omd-filtreActif").checked);
		omd_aMentions.initTree();
		omd_nouveauMention();

	} catch (e) {
		recup_erreur(e);
	}
}


function omd_nouveauMention() {
	try {

		omd_currentMentionId = "";
		omd_aMentions.clearSelection();

		document.getElementById('omd-libelle').value = "";
		document.getElementById('omd-actif').checked = true;

		document.getElementById('omd-bSupprimer').collapsed = true;
		document.getElementById('omd-bNouveau').collapsed = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function omd_chargerMention() {
	try {

		if (omd_aMentions.isSelected()) {
			omd_currentMentionId = omd_aMentions.getSelectedCellText("omd-colMentionId");

			var qLoad = new QueryHttp("Config/gc/loadMention.tmpl");
			qLoad.setParam("Mention_Id", omd_currentMentionId);
			var result = qLoad.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var contenu = result.responseXML.documentElement;

				document.getElementById('omd-libelle').value = contenu.getAttribute('Libelle');
				document.getElementById('omd-actif').checked = contenu.getAttribute('Actif')=="true";

				document.getElementById('omd-bSupprimer').collapsed = false;
				document.getElementById('omd-bNouveau').collapsed = false;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omd_enregistrerMention() {
	try {

		var libelle = document.getElementById('omd-libelle').value;
		var actif = document.getElementById('omd-actif').checked;

		if (isEmpty(libelle)) {
			showWarning("Libell\u00E9 manquant");
		}
		else {
			var qSave;

			if (!isEmpty(omd_currentMentionId)) {
				qSave = new QueryHttp("Config/gc/updateMention.tmpl");
				qSave.setParam("Mention_Id", omd_currentMentionId);
			}
			else {
				qSave = new QueryHttp("Config/gc/createMention.tmpl");
			}

			qSave.setParam("Libelle", libelle);
			qSave.setParam("Actif", actif);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				omd_listerMentions();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function omd_supprimerMention() {
	try {

		if (!isEmpty(omd_currentMentionId) && window.confirm("Confirmez-vous la suppression de la mention s\u00E9lectionn\u00E9e ?")) {

			var qDelete = new QueryHttp("Config/gc/deleteMention.tmpl");
			qDelete.setParam("Mention_Id", omd_currentMentionId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				omd_listerMentions();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}
