/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var opgc_aBanques = new Arbre("ComboListe/combo-banques.tmpl", "opgc-Banque_Id");
var opgc_aDepots = new Arbre("ComboListe/combo-depotsStock.tmpl", "opgc-GDF_Def_Filtre_Depot");
var opgc_aDepotsFab = new Arbre("Config/gc/list-depotFabrication.tmpl", "opgc-listDepotFabrication");

var opgc_curLangueDefaut;
var opgc_modified = false;
var opgc_selBanqueId = "";
var opgc_selDepotId;



function opgc_init() {
	try {

		var accBAM = getProfil().isAccBAM();

		document.getElementById('opgc-boxActivity').collapsed = !accBAM;

		document.getElementById("opgc-rowFormatNL").collapsed = !adminMode;
		document.getElementById("opgc-gpFichiersAssoc").collapsed = !adminMode;
		document.getElementById("opgc-gpUnitesMesure").collapsed = !adminMode;
		document.getElementById("opgc-Act_Devis_Web").collapsed = !adminMode;
		document.getElementById("opgc-Act_Emplacements").collapsed = !adminMode;
		document.getElementById("opgc-Act_Cross_Dock").collapsed = !adminMode;
		document.getElementById("opgc-GDE_Chg_Emp_Stk_Prepa").collapsed = !adminMode;
		document.getElementById("opgc-bPurgeEmp").collapsed = !adminMode;
		document.getElementById("opgc-GTS_Date_Exp_Ligne").collapsed = !adminMode;
		document.getElementById("opgc-Remise_Rejet_Prel").collapsed = !adminMode;
		document.getElementById("opgc-PDS_Comp_Fab").collapsed = !adminMode;

		var aCodesRegimeIntro = new Arbre("ComboListe/combo-debRegimes.tmpl", "opgc-Code_Regime_Intro");
		aCodesRegimeIntro.setParam("Type_Regime", 0);
		aCodesRegimeIntro.initTree(opgc_init3);

	} catch (e) {
    recup_erreur(e);
  }
}


function opgc_init3() {
	try {

		var aCodesRegimeExpe = new Arbre("ComboListe/combo-debRegimes.tmpl", "opgc-Code_Regime_Expe");
		aCodesRegimeExpe.setParam("Type_Regime", 1);
		aCodesRegimeExpe.initTree(opgc_init4);

	} catch (e) {
    recup_erreur(e);
  }
}


function opgc_init4() {
	try {

		var aTransactionsIntro = new Arbre("ComboListe/combo-debTransactions.tmpl", "opgc-Nature_Transaction_Intro");
		aTransactionsIntro.initTree(opgc_init5);

	} catch (e) {
    recup_erreur(e);
  }
}


function opgc_init5() {
	try {

		var aTransactionsExpe = new Arbre("ComboListe/combo-debTransactions.tmpl", "opgc-Nature_Transaction_Expe");
		aTransactionsExpe.initTree(opgc_init6);

	} catch (e) {
    recup_erreur(e);
  }
}


function opgc_init6() {
	try {

		var aModesTransportIntro = new Arbre("ComboListe/combo-debModesTransport.tmpl", "opgc-Mode_Transport_Intro");
		aModesTransportIntro.initTree(opgc_init7);

	} catch (e) {
    recup_erreur(e);
  }
}


function opgc_init7() {
	try {

		var aModesTransportExpe = new Arbre("ComboListe/combo-debModesTransport.tmpl", "opgc-Mode_Transport_Expe");
		aModesTransportExpe.initTree(opgc_init8);

	} catch (e) {
    recup_erreur(e);
  }
}


function opgc_init8() {
	try {

		var aFieldCol1 = new Arbre("ComboListe/combo-groupesAttribut.tmpl", "opgc-Field_Column_DL_1");
		aFieldCol1.initTree(opgc_init9);

	} catch (e) {
    recup_erreur(e);
  }
}


function opgc_init9() {
	try {

		var aFieldCol2 = new Arbre("ComboListe/combo-groupesAttribut.tmpl", "opgc-Field_Column_DL_2");
		aFieldCol2.initTree(opgc_init10);

	} catch (e) {
    recup_erreur(e);
  }
}


function opgc_init10() {
	try {

		var aModalitesC = new Arbre("ComboListe/combo-modalitesReglement.tmpl", "opgc-Def_Modalite_C");
		aModalitesC.setParam("Type_Tiers", "C");
		aModalitesC.initTree(opgc_init11);

	} catch (e) {
    recup_erreur(e);
  }
}


function opgc_init11() {
	try {

		var aModalitesF = new Arbre("ComboListe/combo-modalitesReglement.tmpl", "opgc-Def_Modalite_F");
		aModalitesF.setParam("Type_Tiers", "F");
		aModalitesF.initTree(opgc_init12);

	} catch (e) {
    recup_erreur(e);
  }
}


function opgc_init12() {
	try {

		var aModalitesW = new Arbre("ComboListe/combo-modalitesReglement.tmpl", "opgc-Def_Modalite_W");
		aModalitesW.setParam("Type_Tiers", "C");
		aModalitesW.initTree(opgc_init13);

	} catch (e) {
    recup_erreur(e);
  }
}


function opgc_init13() {
	try {

		var aEtiquettesFabrication = new Arbre("ComboListe/combo-etiquettes.tmpl", "opgc-Etiquette_Fabrication");
		aEtiquettesFabrication.setParam("Type_Etiquette", "F");
		aEtiquettesFabrication.initTree(opgc_init14);

	} catch (e) {
    recup_erreur(e);
  }
}


function opgc_init14() {
	try {

		var aAccesFTP = new Arbre("ComboListe/combo-accesFTP.tmpl", "opgc-Assoc_Acces_FTP");
		aAccesFTP.initTree(opgc_init17);

	} catch (e) {
    recup_erreur(e);
  }
}


function opgc_init17() {
	try {

		var aModesReg = new Arbre("ComboListe/combo-modesReglement.tmpl", "opgc-Def_Mode_Reglement_C");
		aModesReg.initTree(opgc_init18);

	} catch (e) {
    recup_erreur(e);
  }
}


function opgc_init18() {
	try {

		var aModesReg = new Arbre("ComboListe/combo-modesReglement.tmpl", "opgc-Def_Mode_Reglement_F");
		aModesReg.initTree(opgc_init19);

	} catch (e) {
    recup_erreur(e);
  }
}


function opgc_init19() {
	try {

		var aFormats = new Arbre("ComboListe/combo-formatsNumerotation.tmpl", "opgc-Format_NC");
		aFormats.initTree(opgc_init20);

	} catch (e) {
    recup_erreur(e);
  }
}


function opgc_init20() {
	try {

		var aFormats = new Arbre("ComboListe/combo-formatsNumerotation.tmpl", "opgc-Format_NF");
		aFormats.initTree(opgc_init21);

	} catch (e) {
    recup_erreur(e);
  }
}


function opgc_init21() {
	try {

		var aFormats = new Arbre("ComboListe/combo-formatsNumerotation.tmpl", "opgc-Format_NA");
		aFormats.initTree(opgc_init22);

	} catch (e) {
    recup_erreur(e);
  }
}


function opgc_init22() {
	try {

		var aFormats = new Arbre("ComboListe/combo-formatsNumerotation.tmpl", "opgc-Format_NL");
		aFormats.initTree(opgc_init23);

	} catch (e) {
    recup_erreur(e);
  }
}


function opgc_init23() {
	try {

		var aFormats = new Arbre("ComboListe/combo-formatsNumerotation.tmpl", "opgc-Format_NS");
		aFormats.initTree(opgc_init24);

	} catch (e) {
    recup_erreur(e);
  }
}


function opgc_init24() {
	try {

		var aGrpAtt = new Arbre("ComboListe/combo-groupesAttribut.tmpl", "opgc-Grp_Att_Def_1");
		aGrpAtt.initTree(opgc_init25);

	} catch (e) {
    recup_erreur(e);
  }
}


function opgc_init25() {
	try {

		var aGrpAtt = new Arbre("ComboListe/combo-groupesAttribut.tmpl", "opgc-Grp_Att_Def_2");
		aGrpAtt.initTree(opgc_init26);

	} catch (e) {
    recup_erreur(e);
  }
}


function opgc_init26() {
	try {

		var aGrpAtt = new Arbre("ComboListe/combo-groupesAttribut.tmpl", "opgc-Grp_Att_Def_3");
		aGrpAtt.initTree(opgc_init27);

	} catch (e) {
    recup_erreur(e);
  }
}


function opgc_init27() {
	try {

		var aGrpAtt = new Arbre("ComboListe/combo-groupesAttribut.tmpl", "opgc-Grp_Att_Def_4");
		aGrpAtt.initTree(opgc_init28);

	} catch (e) {
    recup_erreur(e);
  }
}


function opgc_init28() {
	try {

		var aGrpAtt = new Arbre("ComboListe/combo-groupesAttribut.tmpl", "opgc-Grp_Att_Def_5");
		aGrpAtt.initTree(opgc_init29);

	} catch (e) {
    recup_erreur(e);
  }
}


function opgc_init29() {
	try {

		var aGrpAtt = new Arbre("ComboListe/combo-groupesAttribut.tmpl", "opgc-Grp_Att_Def_6");
		aGrpAtt.initTree(opgc_init30);

	} catch (e) {
    recup_erreur(e);
  }
}


function opgc_init30() {
	try {

		var aEtiquettesArticle = new Arbre("ComboListe/combo-etiquettes.tmpl", "opgc-Etiquette_Article");
		aEtiquettesArticle.setParam("Type_Etiquette", "A");
		aEtiquettesArticle.initTree(opgc_init31);

	} catch (e) {
    recup_erreur(e);
  }
}


function opgc_init31() {
	try {

		var aUnitesDimensions = new Arbre("ComboListe/combo-unitesVente.tmpl", "opgc-Unite_Dimensions");
		aUnitesDimensions.setParam("Type_Unite", "L");
		aUnitesDimensions.initTree(opgc_init32);

	} catch (e) {
    recup_erreur(e);
  }
}


function opgc_init32() {
	try {

		var aUnitesPoids = new Arbre("ComboListe/combo-unitesVente.tmpl", "opgc-Unite_Poids");
		aUnitesPoids.setParam("Type_Unite", "P");
		aUnitesPoids.initTree(opgc_init33);

	} catch (e) {
    recup_erreur(e);
  }
}


function opgc_init33() {
	try {

		var aUnitesVolume = new Arbre("ComboListe/combo-unitesVente.tmpl", "opgc-Unite_Volume");
		aUnitesVolume.setParam("Type_Unite", "V");
		aUnitesVolume.initTree(opgc_init34);

	} catch (e) {
    recup_erreur(e);
  }
}


function opgc_init34() {
	try {

		var aEtiquettesEmplacement = new Arbre("ComboListe/combo-etiquettes.tmpl", "opgc-Etiquette_Emplacement");
		aEtiquettesEmplacement.setParam("Type_Etiquette", "E");
		aEtiquettesEmplacement.initTree(opgc_init35);

	} catch (e) {
    recup_erreur(e);
  }
}


function opgc_init35() {
	try {

		var aTarifs = new Arbre("ComboListe/combo-tarifsVente.tmpl", "opgc-GDT_Tarif_Impacte");
		aTarifs.initTree(opgc_init36);

	} catch (e) {
    recup_erreur(e);
  }
}


function opgc_init36() {
	try {

		opgc_aDepotsFab.initTree(opgc_loadPreferences);

	} catch (e) {
    recup_erreur(e);
  }
}


function opgc_chargerBanques(selection) {
	try {

		opgc_selBanqueId = selection;
		opgc_aBanques.setParam("Selection", opgc_selBanqueId);
		opgc_aBanques.initTree(opgc_initBanque);

	} catch (e) {
		recup_erreur(e);
	}
}


function opgc_initBanque() {
  try {

		document.getElementById('opgc-Banque_Id').value = opgc_selBanqueId;

	} catch (e) {
  	recup_erreur(e);
	}
}


function opgc_chargerDepots(selection) {
	try {

		opgc_selDepotId = selection;
		opgc_aDepots.setParam("Selection", opgc_selDepotId);
		opgc_aDepots.initTree(opgc_initDepot);

	} catch (e) {
		recup_erreur(e);
	}
}


function opgc_initDepot() {
  try {

		document.getElementById('opgc-GDF_Def_Filtre_Depot').value = opgc_selDepotId;

	} catch (e) {
  	recup_erreur(e);
	}
}


function opgc_demandeEnregistrement() {
	try {

		if (opgc_modified && window.confirm("Voulez-vous enregistrer les modifications apport\u00E9es ?")) {
			opgc_updatePreferences();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function opgc_loadPreferences() {
	try {

		var qLoad = new QueryHttp("Config/gc/getPreferencesGC.tmpl");
		var result = qLoad.execute();
		var contenu = result.responseXML.documentElement;

		document.getElementById("opgc-Imp_Nom_OF").collapsed = !getConfig().isSpecREOF();

		document.getElementById("opgc-Act_Code_Stats").checked = contenu.getAttribute("Act_Code_Stats")=="true";
		document.getElementById("opgc-Act_Suivi_Lot").checked = contenu.getAttribute("Act_Suivi_Lot")=="true";
		document.getElementById("opgc-Act_Nb_Pieces").checked = contenu.getAttribute("Act_Nb_Pieces")=="true";
		document.getElementById("opgc-Act_Unites").checked = contenu.getAttribute("Act_Unites")=="true";
		document.getElementById("opgc-Act_Suivi_Serie").checked = contenu.getAttribute("Act_Suivi_Serie")=="true";
		document.getElementById("opgc-Act_Devis_Web").checked = contenu.getAttribute("Act_Devis_Web")=="true";
		document.getElementById("opgc-Act_Emplacements").checked = contenu.getAttribute("Act_Emplacements")=="true";
		document.getElementById("opgc-Act_Cross_Dock").checked = contenu.getAttribute("Act_Cross_Dock")=="true";
		document.getElementById("opgc-Concat_Attributs_PDF").checked = contenu.getAttribute("Concat_Attributs_PDF")=="true";
		document.getElementById("opgc-Ligne_Gris_Pdf").checked = contenu.getAttribute("Ligne_Gris_Pdf")=="true";
		document.getElementById("opgc-Opt_Num_Doc_QRC").checked = contenu.getAttribute("Opt_Num_Doc_QRC")=="true";
		opgc_curLangueDefaut = contenu.getAttribute("Langue_Defaut");
		document.getElementById("opgc-Etiquette_Fabrication").value = contenu.getAttribute("Etiquette_Fabrication");
		document.getElementById("opgc-Etiquette_Article").value = contenu.getAttribute("Etiquette_Article");
		document.getElementById("opgc-Etiquette_Emplacement").value = contenu.getAttribute("Etiquette_Emplacement");
		document.getElementById("opgc-Field_Column_DL_1").value = contenu.getAttribute("Field_Column_DL_1");
		document.getElementById("opgc-Field_Column_DL_2").value = contenu.getAttribute("Field_Column_DL_2");
		document.getElementById("opgc-Lien_Fichier").value = contenu.getAttribute("Lien_Fichier");
		document.getElementById("opgc-Assoc_Acces_FTP").value = contenu.getAttribute("Assoc_Acces_FTP");
		document.getElementById("opgc-Assoc_Dossier_FTP").value = contenu.getAttribute("Assoc_Dossier_FTP");
		document.getElementById("opgc-Imp_Desc1_Fiche").checked = contenu.getAttribute("Imp_Desc1_Fiche")=="true";
		document.getElementById("opgc-Imp_Desc2_Fiche").checked = contenu.getAttribute("Imp_Desc2_Fiche")=="true";
		document.getElementById("opgc-Imp_Nom_Fiche").checked = contenu.getAttribute("Imp_Nom_Fiche")=="true";
		document.getElementById("opgc-Imp_Desc1_Devis").checked = contenu.getAttribute("Imp_Desc1_Devis")=="true";
		document.getElementById("opgc-Imp_Desc2_Devis").checked = contenu.getAttribute("Imp_Desc2_Devis")=="true";
		document.getElementById("opgc-Imp_Nom_Devis").checked = contenu.getAttribute("Imp_Nom_Devis")=="true";
		document.getElementById("opgc-Imp_Desc1_OF").checked = contenu.getAttribute("Imp_Desc1_OF")=="true";
		document.getElementById("opgc-Imp_Desc2_OF").checked = contenu.getAttribute("Imp_Desc2_OF")=="true";
		document.getElementById("opgc-Imp_Nom_OF").checked = contenu.getAttribute("Imp_Nom_OF")=="true";
		document.getElementById("opgc-Imp_Desc1_BP").checked = contenu.getAttribute("Imp_Desc1_BP")=="true";
		document.getElementById("opgc-Imp_Desc2_BP").checked = contenu.getAttribute("Imp_Desc2_BP")=="true";
		document.getElementById("opgc-Imp_Desc1_Bon").checked = contenu.getAttribute("Imp_Desc1_Bon")=="true";
		document.getElementById("opgc-Imp_Desc2_Bon").checked = contenu.getAttribute("Imp_Desc2_Bon")=="true";
		document.getElementById("opgc-Imp_Nom_Bon").checked = contenu.getAttribute("Imp_Nom_Bon")=="true";
		document.getElementById("opgc-Imp_Nom_BP").checked = contenu.getAttribute("Imp_Nom_BP")=="true";
		document.getElementById("opgc-Imp_Desc1_Facture").checked = contenu.getAttribute("Imp_Desc1_Facture")=="true";
		document.getElementById("opgc-Imp_Desc2_Facture").checked = contenu.getAttribute("Imp_Desc2_Facture")=="true";
		document.getElementById("opgc-Imp_Nom_Facture").checked = contenu.getAttribute("Imp_Nom_Facture")=="true";
		document.getElementById("opgc-Imp_Desc1_BCF").checked = contenu.getAttribute("Imp_Desc1_BCF")=="true";
		document.getElementById("opgc-Imp_Desc2_BCF").checked = contenu.getAttribute("Imp_Desc2_BCF")=="true";
		document.getElementById("opgc-Niveau_Obligation_Intro").value = contenu.getAttribute("Niveau_Obligation_Intro");
		document.getElementById("opgc-Niveau_Obligation_Expe").value = contenu.getAttribute("Niveau_Obligation_Expe");
		document.getElementById("opgc-Code_Regime_Intro").value = contenu.getAttribute("Code_Regime_Intro");
		document.getElementById("opgc-Code_Regime_Expe").value = contenu.getAttribute("Code_Regime_Expe");
		document.getElementById("opgc-Nature_Transaction_Intro").value = contenu.getAttribute("Nature_Transaction_Intro");
		document.getElementById("opgc-Nature_Transaction_Expe").value = contenu.getAttribute("Nature_Transaction_Expe");
		document.getElementById("opgc-Mode_Transport_Intro").value = contenu.getAttribute("Mode_Transport_Intro");
		document.getElementById("opgc-Mode_Transport_Expe").value = contenu.getAttribute("Mode_Transport_Expe");
		document.getElementById("opgc-DEB_Num_Hab").value = contenu.getAttribute("DEB_Num_Hab");
		document.getElementById("opgc-DEB_Contact").value = contenu.getAttribute("DEB_Contact");
		document.getElementById("opgc-DEB_Inclure_FP").checked = contenu.getAttribute("DEB_Inclure_FP")=="true";
		document.getElementById("opgc-Def_Modalite_C").value = contenu.getAttribute("Def_Modalite_C");
		document.getElementById("opgc-Def_Modalite_F").value = contenu.getAttribute("Def_Modalite_F");
		document.getElementById("opgc-Def_Modalite_W").value = contenu.getAttribute("Def_Modalite_W");
		document.getElementById("opgc-Def_Mode_Reglement_C").value = contenu.getAttribute("Def_Mode_Reglement_C");
		document.getElementById("opgc-Def_Mode_Reglement_F").value = contenu.getAttribute("Def_Mode_Reglement_F");
		document.getElementById("opgc-Unite_Poids").value = contenu.getAttribute("Unite_Poids");
		document.getElementById("opgc-Unite_Volume").value = contenu.getAttribute("Unite_Volume");
		document.getElementById("opgc-Unite_Dimensions").value = contenu.getAttribute("Unite_Dimensions");
		document.getElementById("opgc-Format_NC").value = contenu.getAttribute("Format_NC");
		document.getElementById("opgc-Format_NF").value = contenu.getAttribute("Format_NF");
		document.getElementById("opgc-Format_NA").value = contenu.getAttribute("Format_NA");
		document.getElementById("opgc-Format_NL").value = contenu.getAttribute("Format_NL");
		document.getElementById("opgc-Format_NS").value = contenu.getAttribute("Format_NS");
		document.getElementById("opgc-Num_Auto_Compte_Client").checked = contenu.getAttribute("Num_Auto_Compte_Client")=="true";
		document.getElementById("opgc-Prefixe_Compte_Client").value = contenu.getAttribute("Prefixe_Compte_Client");
		document.getElementById("opgc-Num_Auto_Compte_Fourn").checked = contenu.getAttribute("Num_Auto_Compte_Fourn")=="true";
		document.getElementById("opgc-Prefixe_Compte_Fourn").value = contenu.getAttribute("Prefixe_Compte_Fourn");
		document.getElementById("opgc-Grp_Att_Def_1").value = contenu.getAttribute("Grp_Att_Def_1");
		document.getElementById("opgc-Grp_Att_Def_2").value = contenu.getAttribute("Grp_Att_Def_2");
		document.getElementById("opgc-Grp_Att_Def_3").value = contenu.getAttribute("Grp_Att_Def_3");
		document.getElementById("opgc-Grp_Att_Def_4").value = contenu.getAttribute("Grp_Att_Def_4");
		document.getElementById("opgc-Grp_Att_Def_5").value = contenu.getAttribute("Grp_Att_Def_5");
		document.getElementById("opgc-Grp_Att_Def_6").value = contenu.getAttribute("Grp_Att_Def_6");
		document.getElementById("opgc-TDB_Date_Calc_Com").value = contenu.getAttribute("TDB_Date_Calc_Com");
		document.getElementById("opgc-GTS_Only_Dispo_Reassort").checked = contenu.getAttribute("GTS_Only_Dispo_Reassort")=="true";
		document.getElementById("opgc-Deduction_Avoir_Commission").checked = contenu.getAttribute("Deduction_Avoir_Commission")=="true";
		document.getElementById("opgc-Maj_Auto_PA_Forfait").checked = contenu.getAttribute("Maj_Auto_PA_Forfait")=="true";
		document.getElementById("opgc-Maj_Auto_PV_Forfait").value = contenu.getAttribute("Maj_Auto_PV_Forfait");
		document.getElementById("opgc-Aide_Saisie_Date").checked = contenu.getAttribute("Aide_Saisie_Date")=="true";
		document.getElementById("opgc-GDT_Element_A_Modifier").value = contenu.getAttribute("GDT_Element_A_Modifier");
		document.getElementById("opgc-GDT_Tarif_Impacte").value = contenu.getAttribute("GDT_Tarif_Impacte");
		document.getElementById("opgc-Show_Fax").checked = contenu.getAttribute("Show_Fax")=="true";
		document.getElementById("opgc-Mail_Exp_Util").checked = contenu.getAttribute("Mail_Exp_Util")=="true";
		document.getElementById("opgc-GDE_No_Multi_Ref").checked = contenu.getAttribute("GDE_No_Multi_Ref")=="true";
		document.getElementById("opgc-Type_Valo_Art_Fab").value = contenu.getAttribute("Type_Valo_Art_Fab");
		document.getElementById("opgc-GDE_Chg_Emp_Stk_Prepa").checked = contenu.getAttribute("GDE_Chg_Emp_Stk_Prepa")=="true";
		document.getElementById("opgc-Supp_Auto_Emp_Art_Picking").checked = contenu.getAttribute("Supp_Auto_Emp_Art_Picking")=="true";
		document.getElementById("opgc-Supp_Auto_EA_Pic_Sec_Only").checked = contenu.getAttribute("Supp_Auto_EA_Pic_Sec_Only")=="true";
		document.getElementById("opgc-Supp_Auto_Emp_Art_Reserve").checked = contenu.getAttribute("Supp_Auto_Emp_Art_Reserve")=="true";
		document.getElementById("opgc-Supp_Auto_EA_Res_Sec_Only").checked = contenu.getAttribute("Supp_Auto_EA_Res_Sec_Only")=="true";
		document.getElementById("opgc-GTS_Date_Exp_Ligne").checked = contenu.getAttribute("GTS_Date_Exp_Ligne")=="true";
		document.getElementById("opgc-GTS_Date_Rec_Ligne").checked = contenu.getAttribute("GTS_Date_Rec_Ligne")=="true";
		document.getElementById("opgc-Remise_Rejet_Prel").checked = contenu.getAttribute("Remise_Rejet_Prel")=="true";
		document.getElementById("opgc-Cout_Fabrication").value = contenu.getAttribute("Cout_Fabrication");
		document.getElementById("opgc-Act_Serie_DLC").checked = contenu.getAttribute("Act_Serie_DLC")=="true";
		document.getElementById("opgc-PDS_Comp_Fab").checked = contenu.getAttribute("PDS_Comp_Fab")=="true";
		document.getElementById("opgc-BAM_CC_Non_Valid").checked = contenu.getAttribute("BAM_CC_Non_Valid")=="true";

		opgc_chargerBanques(contenu.getAttribute("Banque_Id"));
		opgc_chargerDepots(contenu.getAttribute("GDF_Def_Filtre_Depot"));

		var aLangues = new Arbre("ComboListe/combo-langues.tmpl", "opgc-Langue_Defaut");
		aLangues.setParam("Selection", opgc_curLangueDefaut);
		aLangues.initTree(opgc_initLangueDefaut);

		opgc_action_DEB();
		opgc_changeNumAutoCompteClient();
		opgc_changeNumAutoCompteFourn();
		opgc_changeActEmplacements();
		opgc_changeActSuiviSerie();

		document.getElementById("opgc-bEnregistrer").disabled = false;

		opgc_setModified(false);

	} catch (e) {
    recup_erreur(e);
  }
}


function opgc_initLangueDefaut() {
	try {

		document.getElementById("opgc-Langue_Defaut").value = opgc_curLangueDefaut;

	} catch (e) {
    recup_erreur(e);
  }
}


function opgc_updatePreferences() {
	try {

		var actCodeStats = document.getElementById("opgc-Act_Code_Stats").checked;
		var actSuiviLot = document.getElementById("opgc-Act_Suivi_Lot").checked;
		var actNbPieces = document.getElementById("opgc-Act_Nb_Pieces").checked;
		var actUnites = document.getElementById("opgc-Act_Unites").checked;
		var actSuiviSerie = document.getElementById("opgc-Act_Suivi_Serie").checked;
		var actDevisWeb = document.getElementById("opgc-Act_Devis_Web").checked;
		var actEmplacements = document.getElementById("opgc-Act_Emplacements").checked;
		var actCrossDock = document.getElementById("opgc-Act_Cross_Dock").checked;
		var concatAttributsPDF = document.getElementById("opgc-Concat_Attributs_PDF").checked;
		var ligneGrisPdf = document.getElementById("opgc-Ligne_Gris_Pdf").checked;
		var optNumDocQRC = document.getElementById("opgc-Opt_Num_Doc_QRC").checked;
		var langueDefaut = document.getElementById("opgc-Langue_Defaut").value;
		var etiquetteFabrication = document.getElementById("opgc-Etiquette_Fabrication").value;
		var etiquetteArticle = document.getElementById("opgc-Etiquette_Article").value;
		var etiquetteEmplacement = document.getElementById("opgc-Etiquette_Emplacement").value;
		var fieldColumnDL1 = document.getElementById("opgc-Field_Column_DL_1").value;
		var fieldColumnDL2 = document.getElementById("opgc-Field_Column_DL_2").value;
		var lienFichier = document.getElementById("opgc-Lien_Fichier").value;
		var assocAccesFTP = document.getElementById("opgc-Assoc_Acces_FTP").value;
		var assocDossierFTP = document.getElementById("opgc-Assoc_Dossier_FTP").value;
		var impDesc1Fiche = document.getElementById("opgc-Imp_Desc1_Fiche").checked;
		var impDesc2Fiche = document.getElementById("opgc-Imp_Desc2_Fiche").checked;
		var impNomFiche = document.getElementById("opgc-Imp_Nom_Fiche").checked;
		var impDesc1Devis = document.getElementById("opgc-Imp_Desc1_Devis").checked;
		var impDesc2Devis = document.getElementById("opgc-Imp_Desc2_Devis").checked;
		var impNomDevis = document.getElementById("opgc-Imp_Nom_Devis").checked;
		var impDesc1OF = document.getElementById("opgc-Imp_Desc1_OF").checked;
		var impDesc2OF = document.getElementById("opgc-Imp_Desc2_OF").checked;
		var impNomOF = document.getElementById("opgc-Imp_Nom_OF").checked;
		var impDesc1BP = document.getElementById("opgc-Imp_Desc1_BP").checked;
		var impDesc2BP = document.getElementById("opgc-Imp_Desc2_BP").checked;
		var impDesc1Bon = document.getElementById("opgc-Imp_Desc1_Bon").checked;
		var impDesc2Bon = document.getElementById("opgc-Imp_Desc2_Bon").checked;
		var impNomBon = document.getElementById("opgc-Imp_Nom_Bon").checked;
		var impNomBP = document.getElementById("opgc-Imp_Nom_BP").checked;
		var impDesc1Facture = document.getElementById("opgc-Imp_Desc1_Facture").checked;
		var impDesc2Facture = document.getElementById("opgc-Imp_Desc2_Facture").checked;
		var impNomFacture = document.getElementById("opgc-Imp_Nom_Facture").checked;
		var impDesc1BCF = document.getElementById("opgc-Imp_Desc1_BCF").checked;
		var impDesc2BCF = document.getElementById("opgc-Imp_Desc2_BCF").checked;
		var niveauObligationIntro = document.getElementById("opgc-Niveau_Obligation_Intro").value;
		var niveauObligationExpe = document.getElementById("opgc-Niveau_Obligation_Expe").value;
		var codeRegimeIntro = document.getElementById("opgc-Code_Regime_Intro").value;
		var codeRegimeExpe = document.getElementById("opgc-Code_Regime_Expe").value;
		var natureTransactionIntro = document.getElementById("opgc-Nature_Transaction_Intro").value;
		var natureTransactionExpe = document.getElementById("opgc-Nature_Transaction_Expe").value;
		var modeTransportIntro = document.getElementById("opgc-Mode_Transport_Intro").value;
		var modeTransportExpe = document.getElementById("opgc-Mode_Transport_Expe").value;
		var debNumHab = document.getElementById("opgc-DEB_Num_Hab").value;
		var debContact = document.getElementById("opgc-DEB_Contact").value;
		var debInclureFP = document.getElementById("opgc-DEB_Inclure_FP").checked;
		var defModaliteC = document.getElementById("opgc-Def_Modalite_C").value;
		var defModaliteF = document.getElementById("opgc-Def_Modalite_F").value;
		var defModaliteW = document.getElementById("opgc-Def_Modalite_W").value;
		var defModeReglementC = document.getElementById("opgc-Def_Mode_Reglement_C").value;
		var defModeReglementF = document.getElementById("opgc-Def_Mode_Reglement_F").value;
		var banqueId = document.getElementById("opgc-Banque_Id").value;
		var unitePoids = document.getElementById("opgc-Unite_Poids").value;
		var uniteVolume = document.getElementById("opgc-Unite_Volume").value;
		var uniteDimensions = document.getElementById("opgc-Unite_Dimensions").value;
		var formatNC = document.getElementById("opgc-Format_NC").value;
		var formatNF = document.getElementById("opgc-Format_NF").value;
		var formatNA = document.getElementById("opgc-Format_NA").value;
		var formatNL = document.getElementById("opgc-Format_NL").value;
		var formatNS = document.getElementById("opgc-Format_NS").value;
		var numAutoCompteClient = document.getElementById("opgc-Num_Auto_Compte_Client").checked;
		var prefixeCompteClient = document.getElementById("opgc-Prefixe_Compte_Client").value;
		var numAutoCompteFourn = document.getElementById("opgc-Num_Auto_Compte_Fourn").checked;
		var prefixeCompteFourn = document.getElementById("opgc-Prefixe_Compte_Fourn").value;
		var grpAttDef1 = document.getElementById("opgc-Grp_Att_Def_1").value;
		var grpAttDef2 = document.getElementById("opgc-Grp_Att_Def_2").value;
		var grpAttDef3 = document.getElementById("opgc-Grp_Att_Def_3").value;
		var grpAttDef4 = document.getElementById("opgc-Grp_Att_Def_4").value;
		var grpAttDef5 = document.getElementById("opgc-Grp_Att_Def_5").value;
		var grpAttDef6 = document.getElementById("opgc-Grp_Att_Def_6").value;
		var tdbDateCalcCom = document.getElementById("opgc-TDB_Date_Calc_Com").value;
		var gtsOnlyDispoReassort = document.getElementById("opgc-GTS_Only_Dispo_Reassort").checked;
		var deductionAvoirCommission = document.getElementById("opgc-Deduction_Avoir_Commission").checked;
		var majAutoPAForfait = document.getElementById("opgc-Maj_Auto_PA_Forfait").checked;
		var majAutoPVForfait = document.getElementById("opgc-Maj_Auto_PV_Forfait").value;
		var aideSaisieDate = document.getElementById("opgc-Aide_Saisie_Date").checked;
		var gdtElementAModifier = document.getElementById("opgc-GDT_Element_A_Modifier").value;
		var gdtTarifImpacte = document.getElementById("opgc-GDT_Tarif_Impacte").value;
		var showFax = document.getElementById("opgc-Show_Fax").checked;
		var mailExpUtil = document.getElementById("opgc-Mail_Exp_Util").checked;
		var gdeNoMultiRef = document.getElementById("opgc-GDE_No_Multi_Ref").checked;
		var typeValoArtFab = document.getElementById("opgc-Type_Valo_Art_Fab").value;
		var gdeChgEmpStkPrepa = document.getElementById("opgc-GDE_Chg_Emp_Stk_Prepa").checked;
		var suppAutoEmpArtPicking = document.getElementById("opgc-Supp_Auto_Emp_Art_Picking").checked;
		var suppAutoEAPicSecOnly = document.getElementById("opgc-Supp_Auto_EA_Pic_Sec_Only").checked;
		var suppAutoEmpArtReserve = document.getElementById("opgc-Supp_Auto_Emp_Art_Reserve").checked;
		var suppAutoEAResSecOnly = document.getElementById("opgc-Supp_Auto_EA_Res_Sec_Only").checked;
		var gtsDateExpLigne = document.getElementById("opgc-GTS_Date_Exp_Ligne").checked;
		var gtsDateRecLigne = document.getElementById("opgc-GTS_Date_Rec_Ligne").checked;
		var remiseRejetPrel = document.getElementById("opgc-Remise_Rejet_Prel").checked;
		var coutFabrication = document.getElementById("opgc-Cout_Fabrication").value;
		var actSerieDLC = document.getElementById("opgc-Act_Serie_DLC").checked;
		var pdsCompFab = document.getElementById("opgc-PDS_Comp_Fab").checked;
		var gdfDefFiltreDepot = document.getElementById("opgc-GDF_Def_Filtre_Depot").value;
		var bamCCNonValid = document.getElementById("opgc-BAM_CC_Non_Valid").checked;

		var listeDepots = "";
		var listeDF = "";
		for (var i=0; i<opgc_aDepotsFab.nbLignes(); i++) {
			listeDepots += opgc_aDepotsFab.getCellText(i, "opgc-colDepotIdDF") +",";
			listeDF += (opgc_aDepotsFab.getCellValue(i, "opgc-colSelectDF")=="true") +",";
  	}

		var rgxPrefixe = /^[a-zA-Z09_\\-]{1}[a-zA-Z0-9_\\-]{0,1}$/;

		if (numAutoCompteClient && isEmpty(prefixeCompteClient)) {
			showWarning("Veuillez saisir un pr\u00E9fixe de compte client");
		}
		else if (numAutoCompteClient && !rgxPrefixe.test(prefixeCompteClient)) {
			showWarning("Pr\u00E9fixe de compte client incorrect");
		}
		else if (numAutoCompteFourn && isEmpty(prefixeCompteFourn)) {
			showWarning("Veuillez saisir un pr\u00E9fixe de compte fournisseur");
		}
		else if (numAutoCompteFourn && !rgxPrefixe.test(prefixeCompteFourn)) {
			showWarning("Pr\u00E9fixe de compte fournisseur incorrect");
		}
		else if (!isEmpty(formatNC) && !opgc_isFormatNumTiers(formatNC)) {
			showWarning("Format de num\u00E9ro client inadapt\u00E9 (nombre de caract\u00E8res trop important, maximum 10)");
		}
		else if (!isEmpty(formatNF) && !opgc_isFormatNumTiers(formatNF)) {
			showWarning("Format de num\u00E9ro fournisseur inadapt\u00E9 (nombre de caract\u00E8res trop important, maximum 10)");
		}
		else if ((!isEmpty(grpAttDef1) && (grpAttDef1==grpAttDef2 || grpAttDef1==grpAttDef3 || grpAttDef1==grpAttDef4 || grpAttDef1==grpAttDef5 || grpAttDef1==grpAttDef6))
					|| (!isEmpty(grpAttDef2) && (grpAttDef2==grpAttDef3 || grpAttDef2==grpAttDef4 || grpAttDef2==grpAttDef5 || grpAttDef2==grpAttDef6))
					|| (!isEmpty(grpAttDef3) && (grpAttDef3==grpAttDef4 || grpAttDef3==grpAttDef5 || grpAttDef3==grpAttDef6))
					|| (!isEmpty(grpAttDef4) && (grpAttDef4==grpAttDef5 || grpAttDef4==grpAttDef6))
					|| (!isEmpty(grpAttDef5) && grpAttDef5==grpAttDef6)) {
			showWarning("Il ne doit pas y avoir d'attributs identiques s\u00E9lectionn\u00E9s dans les attributs principaux");
		}
		else if ((isEmpty(grpAttDef1) && !isEmpty(grpAttDef2)) || (isEmpty(grpAttDef2) && !isEmpty(grpAttDef3)) || (isEmpty(grpAttDef3) && !isEmpty(grpAttDef4))
					 || (isEmpty(grpAttDef4) && !isEmpty(grpAttDef5)) || (isEmpty(grpAttDef5) && !isEmpty(grpAttDef6))) {
			showWarning("Il ne doit pas y avoir de trous dans les attributs principaux");
		}
		else if (majAutoPVForfait=="C" && !majAutoPAForfait) {
			showWarning("Forfaits : Mise \u00E0 jour automatique du prix de revient par les composants obligatoire avec l'option de mise \u00E0 jour automatique du prix de vente par coefficient sur prix de revient");
		}
		else if (!isPositiveOrNull(coutFabrication) || !checkNumber(coutFabrication,10,4)) {
			showWarning("Co\u00FBt de fabrication incorrect");
		}
		else {
			var qUpdate = new QueryHttp("Config/gc/updatePreferencesGC.tmpl");

			qUpdate.setParam("Act_Code_Stats", actCodeStats);
			qUpdate.setParam("Act_Suivi_Lot", actSuiviLot);
			qUpdate.setParam("Act_Nb_Pieces", actNbPieces);
			qUpdate.setParam("Act_Unites", actUnites);
			qUpdate.setParam("Act_Suivi_Serie", actSuiviSerie);
			qUpdate.setParam("Act_Devis_Web", actDevisWeb);
			qUpdate.setParam("Act_Emplacements", actEmplacements);
			qUpdate.setParam("Act_Cross_Dock", actCrossDock);
			qUpdate.setParam("Concat_Attributs_PDF", concatAttributsPDF);
			qUpdate.setParam("Ligne_Gris_Pdf", ligneGrisPdf);
			qUpdate.setParam("Opt_Num_Doc_QRC", optNumDocQRC);
			qUpdate.setParam("Langue_Defaut", langueDefaut);
			qUpdate.setParam("Etiquette_Fabrication", etiquetteFabrication);
			qUpdate.setParam("Etiquette_Article", etiquetteArticle);
			qUpdate.setParam("Etiquette_Emplacement", etiquetteEmplacement);
			qUpdate.setParam("Field_Column_DL_1", fieldColumnDL1);
			qUpdate.setParam("Field_Column_DL_2", fieldColumnDL2);
			qUpdate.setParam("Lien_Fichier", lienFichier);
			qUpdate.setParam("Assoc_Acces_FTP", assocAccesFTP);
			qUpdate.setParam("Assoc_Dossier_FTP", assocDossierFTP);
			qUpdate.setParam("Imp_Desc1_Fiche", impDesc1Fiche);
			qUpdate.setParam("Imp_Desc2_Fiche", impDesc2Fiche);
			qUpdate.setParam("Imp_Nom_Fiche", impNomFiche);
			qUpdate.setParam("Imp_Desc1_Devis", impDesc1Devis);
			qUpdate.setParam("Imp_Desc2_Devis", impDesc2Devis);
			qUpdate.setParam("Imp_Nom_Devis", impNomDevis);
			qUpdate.setParam("Imp_Desc1_OF", impDesc1OF);
			qUpdate.setParam("Imp_Desc2_OF", impDesc2OF);
			qUpdate.setParam("Imp_Nom_OF", impNomOF);
			qUpdate.setParam("Imp_Desc1_BP", impDesc1BP);
			qUpdate.setParam("Imp_Desc2_BP", impDesc2BP);
			qUpdate.setParam("Imp_Desc1_Bon", impDesc1Bon);
			qUpdate.setParam("Imp_Desc2_Bon", impDesc2Bon);
			qUpdate.setParam("Imp_Nom_Bon", impNomBon);
			qUpdate.setParam("Imp_Nom_BP", impNomBP);
			qUpdate.setParam("Imp_Desc1_Facture", impDesc1Facture);
			qUpdate.setParam("Imp_Desc2_Facture", impDesc2Facture);
			qUpdate.setParam("Imp_Nom_Facture", impNomFacture);
			qUpdate.setParam("Imp_Desc1_BCF", impDesc1BCF);
			qUpdate.setParam("Imp_Desc2_BCF", impDesc2BCF);
			qUpdate.setParam("Niveau_Obligation_Intro", niveauObligationIntro);
			qUpdate.setParam("Niveau_Obligation_Expe", niveauObligationExpe);
			qUpdate.setParam("Code_Regime_Intro", codeRegimeIntro);
			qUpdate.setParam("Code_Regime_Expe", codeRegimeExpe);
			qUpdate.setParam("Nature_Transaction_Intro", natureTransactionIntro);
			qUpdate.setParam("Nature_Transaction_Expe", natureTransactionExpe);
			qUpdate.setParam("Mode_Transport_Intro", modeTransportIntro);
			qUpdate.setParam("Mode_Transport_Expe", modeTransportExpe);
			qUpdate.setParam("DEB_Num_Hab", debNumHab);
			qUpdate.setParam("DEB_Contact", debContact);
			qUpdate.setParam("DEB_Inclure_FP", debInclureFP);
			qUpdate.setParam("Def_Modalite_C", defModaliteC);
			qUpdate.setParam("Def_Modalite_F", defModaliteF);
			qUpdate.setParam("Def_Modalite_W", defModaliteW);
			qUpdate.setParam("Def_Mode_Reglement_C", defModeReglementC);
			qUpdate.setParam("Def_Mode_Reglement_F", defModeReglementF);
			qUpdate.setParam("Banque_Id", banqueId);
			qUpdate.setParam("Unite_Poids", unitePoids);
			qUpdate.setParam("Unite_Volume", uniteVolume);
			qUpdate.setParam("Unite_Dimensions", uniteDimensions);
			qUpdate.setParam("Format_NC", formatNC);
			qUpdate.setParam("Format_NF", formatNF);
			qUpdate.setParam("Format_NA", formatNA);
			qUpdate.setParam("Format_NL", formatNL);
			qUpdate.setParam("Format_NS", formatNS);
			qUpdate.setParam("Num_Auto_Compte_Client", numAutoCompteClient);
			qUpdate.setParam("Prefixe_Compte_Client", prefixeCompteClient);
			qUpdate.setParam("Num_Auto_Compte_Fourn", numAutoCompteFourn);
			qUpdate.setParam("Prefixe_Compte_Fourn", prefixeCompteFourn);
			qUpdate.setParam("Grp_Att_Def_1", grpAttDef1);
			qUpdate.setParam("Grp_Att_Def_2", grpAttDef2);
			qUpdate.setParam("Grp_Att_Def_3", grpAttDef3);
			qUpdate.setParam("Grp_Att_Def_4", grpAttDef4);
			qUpdate.setParam("Grp_Att_Def_5", grpAttDef5);
			qUpdate.setParam("Grp_Att_Def_6", grpAttDef6);
			qUpdate.setParam("TDB_Date_Calc_Com", tdbDateCalcCom);
			qUpdate.setParam("GTS_Only_Dispo_Reassort", gtsOnlyDispoReassort);
			qUpdate.setParam("Deduction_Avoir_Commission", deductionAvoirCommission);
			qUpdate.setParam("Maj_Auto_PA_Forfait", majAutoPAForfait);
			qUpdate.setParam("Maj_Auto_PV_Forfait", majAutoPVForfait);
			qUpdate.setParam("Aide_Saisie_Date", aideSaisieDate);
			qUpdate.setParam("GDT_Element_A_Modifier", gdtElementAModifier);
			qUpdate.setParam("GDT_Tarif_Impacte", gdtTarifImpacte);
			qUpdate.setParam("Show_Fax", showFax);
			qUpdate.setParam("Mail_Exp_Util", mailExpUtil);
			qUpdate.setParam("GDE_No_Multi_Ref", gdeNoMultiRef);
			qUpdate.setParam("Type_Valo_Art_Fab", typeValoArtFab);
			qUpdate.setParam("GDE_Chg_Emp_Stk_Prepa", gdeChgEmpStkPrepa);
			qUpdate.setParam("Supp_Auto_Emp_Art_Picking", suppAutoEmpArtPicking);
			qUpdate.setParam("Supp_Auto_EA_Pic_Sec_Only", suppAutoEAPicSecOnly);
			qUpdate.setParam("Supp_Auto_Emp_Art_Reserve", suppAutoEmpArtReserve);
			qUpdate.setParam("Supp_Auto_EA_Res_Sec_Only", suppAutoEAResSecOnly);
			qUpdate.setParam("GTS_Date_Exp_Ligne", gtsDateExpLigne);
			qUpdate.setParam("GTS_Date_Rec_Ligne", gtsDateRecLigne);
			qUpdate.setParam("Remise_Rejet_Prel", remiseRejetPrel);
			qUpdate.setParam("Cout_Fabrication", coutFabrication);
			qUpdate.setParam("Act_Serie_DLC", actSerieDLC);
			qUpdate.setParam("PDS_Comp_Fab", pdsCompFab);
			qUpdate.setParam("GDF_Def_Filtre_Depot", gdfDefFiltreDepot);
			qUpdate.setParam("BAM_CC_Non_Valid", bamCCNonValid);

			// Dpts pour le rassort de fabrication
			qUpdate.setParam("Liste_Depots", listeDepots);
			qUpdate.setParam("Liste_DF", listeDF);

			var result = qUpdate.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				opgc_setModified(false);
				showMessage("Pr\u00E9f\u00E9rences sauvegard\u00E9es");
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function opgc_action_DEB() {
	try {

		var niveauObligationIntro = document.getElementById("opgc-Niveau_Obligation_Intro").value;
		document.getElementById("opgc-Code_Regime_Intro").disabled = (niveauObligationIntro>1);
		document.getElementById("opgc-Nature_Transaction_Intro").disabled = (niveauObligationIntro>1);
		document.getElementById("opgc-Mode_Transport_Intro").disabled = (niveauObligationIntro>1);

		var niveauObligationExpe = document.getElementById("opgc-Niveau_Obligation_Expe").value;
		var codeRegimeExpe = document.getElementById("opgc-Code_Regime_Expe").value;
		document.getElementById("opgc-Nature_Transaction_Expe").disabled = (niveauObligationExpe>1 || (codeRegimeExpe==25 || codeRegimeExpe==26 || codeRegimeExpe==31));
		document.getElementById("opgc-Mode_Transport_Expe").disabled = (niveauObligationExpe>1 || (codeRegimeExpe==25 || codeRegimeExpe==26 || codeRegimeExpe==31));

	} catch (e) {
		recup_erreur(e);
	}
}


function opgc_setModified(modified) {
	try {

		opgc_modified = modified;
		document.getElementById('opgc-imgModified').collapsed = !modified;

	} catch (e) {
		recup_erreur(e);
	}
}


function opgc_clickOnDepotFabrication(ev) {
	try {

		var col = opgc_aDepotsFab.getClickedCol(ev);

		if (col!=null && col.id=="opgc-colSelectDF") {
			opgc_setModified(true);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function opgc_changeNumAutoCompteClient() {
	try {

		var numAuto = document.getElementById("opgc-Num_Auto_Compte_Client").checked;

		document.getElementById("opgc-rowPrefixeCompteClient").collapsed = !numAuto;
		if (!numAuto) {
			document.getElementById("opgc-Prefixe_Compte_Client").value = "";
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function opgc_changeNumAutoCompteFourn() {
	try {

		var numAuto = document.getElementById("opgc-Num_Auto_Compte_Fourn").checked;

		document.getElementById("opgc-rowPrefixeCompteFourn").collapsed = !numAuto;
		if (!numAuto) {
			document.getElementById("opgc-Prefixe_Compte_Fourn").value = "";
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function opgc_changeActEmplacements() {
	try {

		var actEmplacements = document.getElementById("opgc-Act_Emplacements").checked;

		document.getElementById("opgc-boxSuppAutoEmpArt").collapsed = !actEmplacements;

	} catch (e) {
		recup_erreur(e);
	}
}


function opgc_changeActSuiviSerie() {
	try {

		var actSuiviSerie = document.getElementById("opgc-Act_Suivi_Serie").checked;

		document.getElementById("opgc-Act_Serie_DLC").collapsed = !actSuiviSerie;

	} catch (e) {
		recup_erreur(e);
	}
}


function opgc_isFormatNumTiers(formatId) {
	try {

		var query = new QueryHttp("Config/gc/nbCharacterFormatNumerotation.tmpl");
		query.setParam("Format_Id", formatId);
		var result = query.execute();
		var nbcar = result.responseXML.documentElement.getAttribute("Nb_Character");

		return nbcar<=10;

	} catch (e) {
		recup_erreur(e);
	}
}


function opgc_purgerEmplacements() {
	try {

		document.getElementById("opgc-bPurgeEmp").disabled = true;

		if (window.confirm("Confirmez-vous le lancement de la purge des emplacements ?")) {
			var qPurge = new QueryHttp("Config/gc/purgeAllEmplacementArticle.tmpl");

			var result = qPurge.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("Purge des emplacements termin\u00E9e");
			}
		}

		document.getElementById("opgc-bPurgeEmp").disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}
