/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var oahl_currentAffectationDS;
var oahl_aAffDepotArticle = new Arbre("Config/gc/ventes/list-affectationDepotLigneCC.tmpl", "oahl-listeAffectationsDepotArticle");
var oahl_aFamille1 = new Arbre('ComboListe/combo-famillesArticle.tmpl', 'oahl-famille1');
var oahl_aFamille2 = new Arbre('ComboListe/combo-famillesArticle.tmpl', 'oahl-famille2');
var oahl_aFamille3 = new Arbre('ComboListe/combo-famillesArticle.tmpl', 'oahl-famille3');
var oahl_aAttributs1 = new Arbre('ComboListe/combo-attributs.tmpl', 'oahl-attribut1');
var oahl_aAttributs2 = new Arbre('ComboListe/combo-attributs.tmpl', 'oahl-attribut2');
var oahl_aAttributs3 = new Arbre('ComboListe/combo-attributs.tmpl', 'oahl-attribut3');
var oahl_aAttributs4 = new Arbre('ComboListe/combo-attributs.tmpl', 'oahl-attribut4');
var oahl_aAttributs5 = new Arbre('ComboListe/combo-attributs.tmpl', 'oahl-attribut5');
var oahl_aAttributs6 = new Arbre('ComboListe/combo-attributs.tmpl', 'oahl-attribut6');
var oahl_aCodesPostaux = new Arbre("Config/gc/ventes/list-codePostalAffectationDepotLigneCC.tmpl", "oahl-listeCodesPostaux");
var oahl_chargerFamille1 = "";
var oahl_chargerFamille2 = "";
var oahl_chargerFamille3 = "";
var oahl_circonstAttr1 = false;
var oahl_circonstAttr2 = false;
var oahl_circonstAttr3 = false;
var oahl_circonstAttr4 = false;
var oahl_circonstAttr5 = false;
var oahl_circonstAttr6 = false;
var oahl_groupeAttr1;
var oahl_groupeAttr2;
var oahl_groupeAttr3;
var oahl_groupeAttr4;
var oahl_groupeAttr5;
var oahl_groupeAttr6;
var oahl_codeId;

var oahl_currentAffectationFP = "";
var oahl_aAffectationFraisPort = new Arbre('Config/gc/ventes/list-affectationFraisPort.tmpl', 'oahl-listeAffectationFraisPort');

var oahl_currentAffectationME = "";
var oahl_aAffectationModeExpedition = new Arbre('Config/gc/ventes/list-affectationModeExpedition.tmpl', 'oahl-listeAffectationModeExpedition');
var oahl_aModesExpe = new Arbre('ComboListe/combo-modesExpedition.tmpl', 'oahl-modeExpedition_AME');

var oahl_currentAffectationMD = "";
var oahl_aAffectationModeExpeditionDevis = new Arbre('Config/gc/ecommerce/list-affectationModeExpedition.tmpl', 'oahl-listeAffectationModeExpeditionDevis');
var oahl_aModesExpeInitial = new Arbre('ComboListe/combo-modesExpedition.tmpl', 'oahl-modeExpeInitial_MD');
var oahl_aModesExpeFinal = new Arbre('ComboListe/combo-modesExpedition.tmpl', 'oahl-modeExpeFinal_MD');



function oahl_init() {
	try {

		var config = getResetConfig();

		var actDepotLigneCC = config.isActDepotLigneCC();

		document.getElementById("oahl-boxAffDS").collapsed = !actDepotLigneCC;
		document.getElementById("oahl-boxNoAffDS").collapsed = actDepotLigneCC;
		document.getElementById("oahl-tabAffME").collapsed = !config.isSpecPCAME();
		document.getElementById("oahl-tabAffFP").collapsed = !config.isSpecPCAFP();

		oahl_aAffDepotArticle.initTree();

		var qAttPrinc = new QueryHttp("Facturation/Commun/getAttributsPrincipaux.tmpl");
		var result = qAttPrinc.execute();

		var contenu = result.responseXML.documentElement;

		oahl_groupeAttr1 = contenu.getAttribute("Groupe_Id_1");
		oahl_groupeAttr2 = contenu.getAttribute("Groupe_Id_2");
		oahl_groupeAttr3 = contenu.getAttribute("Groupe_Id_3");
		oahl_groupeAttr4 = contenu.getAttribute("Groupe_Id_4");
		oahl_groupeAttr5 = contenu.getAttribute("Groupe_Id_5");
		oahl_groupeAttr6 = contenu.getAttribute("Groupe_Id_6");

		if (!isEmpty(oahl_groupeAttr1)) {
			document.getElementById('oahl-lblAttribut1').value = contenu.getAttribute('Intitule_1') +" :";
			document.getElementById('oahl-colAttribut1').setAttribute("label", contenu.getAttribute('Intitule_1'));
			oahl_circonstAttr1 = (contenu.getAttribute('Circonst_1')=="true");
			oahl_aAttributs1.setParam("Groupe_Id", oahl_groupeAttr1);
			oahl_aAttributs1.initTree();
		}
		else {
			document.getElementById('oahl-lblAttribut1').value = "Att. Princ. 1 :";
			document.getElementById('oahl-lblAttribut1').disabled = true;
			document.getElementById('oahl-attribut1').disabled = true;
			document.getElementById("oahl-colAttribut1").collapsed = true;
			document.getElementById("oahl-colAttribut1").setAttribute("ignoreincolumnpicker", true);
		}

		if (!isEmpty(oahl_groupeAttr2)) {
			document.getElementById('oahl-lblAttribut2').value = contenu.getAttribute('Intitule_2') +" :";
			document.getElementById('oahl-colAttribut2').setAttribute("label", contenu.getAttribute('Intitule_2'));
			oahl_circonstAttr2 = (contenu.getAttribute('Circonst_2')=="true");
			oahl_aAttributs2.setParam("Groupe_Id", oahl_groupeAttr2);
			oahl_aAttributs2.initTree();
		}
		else {
			document.getElementById('oahl-lblAttribut2').value = "Att. Princ. 2 :";
			document.getElementById('oahl-lblAttribut2').disabled = true;
			document.getElementById('oahl-attribut2').disabled = true;
			document.getElementById("oahl-colAttribut2").collapsed = true;
			document.getElementById("oahl-colAttribut2").setAttribute("ignoreincolumnpicker", true);
		}

		if (!isEmpty(oahl_groupeAttr3)) {
			document.getElementById('oahl-lblAttribut3').value = contenu.getAttribute('Intitule_3') +" :";
			document.getElementById('oahl-colAttribut3').setAttribute("label", contenu.getAttribute('Intitule_3'));
			oahl_circonstAttr3 = (contenu.getAttribute('Circonst_3')=="true");
			oahl_aAttributs3.setParam("Groupe_Id", oahl_groupeAttr3);
			oahl_aAttributs3.initTree();
		}
		else {
			document.getElementById('oahl-lblAttribut3').value = "Att. Princ. 3 :";
			document.getElementById('oahl-lblAttribut3').disabled = true;
			document.getElementById('oahl-attribut3').disabled = true;
			document.getElementById("oahl-colAttribut3").collapsed = true;
			document.getElementById("oahl-colAttribut3").setAttribute("ignoreincolumnpicker", true);
		}

		if (!isEmpty(oahl_groupeAttr4)) {
			document.getElementById('oahl-lblAttribut4').value = contenu.getAttribute('Intitule_4') +" :";
			document.getElementById('oahl-colAttribut4').setAttribute("label", contenu.getAttribute('Intitule_4'));
			oahl_circonstAttr4 = (contenu.getAttribute('Circonst_4')=="true");
			oahl_aAttributs4.setParam("Groupe_Id", oahl_groupeAttr4);
			oahl_aAttributs4.initTree();
		}
		else {
			document.getElementById('oahl-lblAttribut4').value = "Att. Princ. 4 :";
			document.getElementById('oahl-lblAttribut4').disabled = true;
			document.getElementById('oahl-attribut4').disabled = true;
			document.getElementById("oahl-colAttribut4").collapsed = true;
			document.getElementById("oahl-colAttribut4").setAttribute("ignoreincolumnpicker", true);
		}

		if (!isEmpty(oahl_groupeAttr5)) {
			document.getElementById('oahl-lblAttribut5').value = contenu.getAttribute('Intitule_5') +" :";
			document.getElementById('oahl-colAttribut5').setAttribute("label", contenu.getAttribute('Intitule_5'));
			oahl_circonstAttr5 = (contenu.getAttribute('Circonst_5')=="true");
			oahl_aAttributs5.setParam("Groupe_Id", oahl_groupeAttr5);
			oahl_aAttributs5.initTree();
		}
		else {
			document.getElementById('oahl-lblAttribut5').value = "Att. Princ. 5 :";
			document.getElementById('oahl-lblAttribut5').disabled = true;
			document.getElementById('oahl-attribut5').disabled = true;
			document.getElementById("oahl-colAttribut5").collapsed = true;
			document.getElementById("oahl-colAttribut5").setAttribute("ignoreincolumnpicker", true);
		}

		if (!isEmpty(oahl_groupeAttr6)) {
			document.getElementById('oahl-lblAttribut6').value = contenu.getAttribute('Intitule_6') +" :";
			document.getElementById('oahl-colAttribut6').setAttribute("label", contenu.getAttribute('Intitule_6'));
			oahl_circonstAttr6 = (contenu.getAttribute('Circonst_6')=="true");
			oahl_aAttributs6.setParam("Groupe_Id", oahl_groupeAttr6);
			oahl_aAttributs6.initTree();
		}
		else {
			document.getElementById('oahl-lblAttribut6').value = "Att. Princ. 6 :";
			document.getElementById('oahl-lblAttribut6').disabled = true;
			document.getElementById('oahl-attribut6').disabled = true;
			document.getElementById("oahl-colAttribut6").collapsed = true;
			document.getElementById("oahl-colAttribut6").setAttribute("ignoreincolumnpicker", true);
		}

		var aDepots = new Arbre('ComboListe/combo-depotsStock.tmpl', 'oahl-depot');
		aDepots.setParam("No_Check_Rights", true);
		aDepots.setParam('Depot_Vente', false);
		aDepots.setParam('Depot_Quarantaine', false);
		aDepots.initTree();

		oahl_chargerFamilles1();
		oahl_chargerFamilles2();
		oahl_chargerFamilles3();

		var aDepartements = new Arbre('ComboListe/combo-departements.tmpl', 'oahl-departement');
		aDepartements.initTree();

		var aPays = new Arbre("ComboListe/combo-pays.tmpl", "oahl-codePays");
		aPays.initTree();

		var aDepartementsMD = new Arbre('ComboListe/combo-departements.tmpl', 'oahl-departement_MD');
		aDepartementsMD.initTree();

		var aPaysMD = new Arbre("ComboListe/combo-pays.tmpl", "oahl-codePays_MD");
		aPaysMD.initTree();

		oahl_nouvelleAffectation();
		oahl_nouvelleAffectationFraisPort();
		oahl_nouvelleAffectationModeExpedition();
		oahl_nouvelleAffectationModeExpeditionDevis();

	} catch (e) {
    recup_erreur(e);
  }
}



// AFFECTATIONS DEPOT


function oahl_chargerFamilles1() {
	try {

		oahl_aFamille1.initTree(oahl_initFamille1);

	} catch (e) {
		recup_erreur(e);
	}
}


function oahl_initFamille1() {
  try {

		document.getElementById('oahl-famille1').value = oahl_chargerFamille1;
		if (oahl_chargerFamille1 != "") {
			oahl_chargerFamille1 = "";
			oahl_chargerFamilles2();
		} else {
			oahl_aFamille2.deleteTree();
			oahl_aFamille3.deleteTree();
			document.getElementById('oahl-famille2').selectedIndex=0;
			document.getElementById('oahl-famille3').selectedIndex=0;
			document.getElementById('oahl-famille2').disabled = true;
			document.getElementById('oahl-famille3').disabled = true;

			oahl_manageCirconstAttributs();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oahl_chargerFamilles2() {
	try {

		var famille1 = document.getElementById('oahl-famille1').value;
		if (famille1=="") {
			document.getElementById('oahl-famille2').disabled = true;
			oahl_aFamille2.deleteTree();
			document.getElementById('oahl-famille2').selectedIndex=0;

			document.getElementById('oahl-famille3').disabled = true;
			oahl_aFamille3.deleteTree();
			document.getElementById('oahl-famille3').selectedIndex=0;
		}
		else {
			oahl_aFamille2.setParam('Parent_Id', famille1);
			oahl_aFamille2.initTree(oahl_initFamille2);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oahl_initFamille2() {
  try {

		document.getElementById('oahl-famille2').value = oahl_chargerFamille2;
		if (document.getElementById('oahl-famille1').value!="") {
			document.getElementById('oahl-famille2').disabled = false;
		}
		if (oahl_chargerFamille2 != "") {
			oahl_chargerFamille2 = "";
			oahl_chargerFamilles3();
		} else {
			oahl_aFamille3.deleteTree();
			document.getElementById('oahl-famille3').selectedIndex=0;
			document.getElementById('oahl-famille3').disabled = true;

			oahl_manageCirconstAttributs();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oahl_chargerFamilles3() {
	try {

		var famille2 = document.getElementById('oahl-famille2').value;
		if (famille2=="") {
			document.getElementById('oahl-famille3').disabled = true;
			oahl_aFamille3.deleteTree();
			document.getElementById('oahl-famille3').selectedIndex=0;
		}
		else {
			oahl_aFamille3.setParam('Parent_Id', famille2);
			oahl_aFamille3.initTree(oahl_initFamille3);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oahl_initFamille3() {
  try {

		document.getElementById('oahl-famille3').value = oahl_chargerFamille3;
		if (document.getElementById('oahl-famille2').value!="") {
			document.getElementById('oahl-famille3').disabled = false;
		}
		if (oahl_chargerFamille3 != "") {
			oahl_chargerFamille3 = "";
		}
		oahl_manageCirconstAttributs();

	} catch (e) {
		recup_erreur(e);
	}
}


function oahl_chargerFamilles(famille1, famille2, famille3) {
	try {

		oahl_chargerFamille1 = famille1;
		oahl_chargerFamille2 = famille2;
		oahl_chargerFamille3 = famille3;
		oahl_chargerFamilles1();

	} catch (e) {
		recup_erreur(e);
	}
}


function oahl_manageCirconstAttributs() {
	try {

		var famille1 = document.getElementById('oahl-famille1').value;
		var famille2 = document.getElementById('oahl-famille2').value;
		var famille3 = document.getElementById('oahl-famille3').value;

		var familleId = !isEmpty(famille3)?famille3:!isEmpty(famille2)?famille2:famille1;

		if (!isEmpty(familleId)) {
			var qCirc = new QueryHttp("Facturation/Commun/existGroupeAttributFamilleArticle.tmpl");
			qCirc.setParam("Famille_Id", familleId);

			if (oahl_circonstAttr1 && !isEmpty(oahl_groupeAttr1)) {
				qCirc.setParam("Groupe_Id", oahl_groupeAttr1);
				var result = qCirc.execute();
				if (result.responseXML.documentElement.getAttribute('Exist')=="false") {
					document.getElementById('oahl-attribut1').disabled = true;
					document.getElementById('oahl-attribut1').value = "";
				}
				else {
					document.getElementById('oahl-attribut1').disabled = false;
				}
			}

			if (oahl_circonstAttr2 && !isEmpty(oahl_groupeAttr2)) {
				qCirc.setParam("Groupe_Id", oahl_groupeAttr2);
				var result = qCirc.execute();
				if (result.responseXML.documentElement.getAttribute('Exist')=="false") {
					document.getElementById('oahl-attribut2').disabled = true;
					document.getElementById('oahl-attribut2').value = "";
				}
				else {
					document.getElementById('oahl-attribut2').disabled = false;
				}
			}

			if (oahl_circonstAttr3 && !isEmpty(oahl_groupeAttr3)) {
				qCirc.setParam("Groupe_Id", oahl_groupeAttr3);
				var result = qCirc.execute();
				if (result.responseXML.documentElement.getAttribute('Exist')=="false") {
					document.getElementById('oahl-attribut3').disabled = true;
					document.getElementById('oahl-attribut3').value = "";
				}
				else {
					document.getElementById('oahl-attribut3').disabled = false;
				}
			}

			if (oahl_circonstAttr4 && !isEmpty(oahl_groupeAttr4)) {
				qCirc.setParam("Groupe_Id", oahl_groupeAttr4);
				var result = qCirc.execute();
				if (result.responseXML.documentElement.getAttribute('Exist')=="false") {
					document.getElementById('oahl-attribut4').disabled = true;
					document.getElementById('oahl-attribut4').value = "";
				}
				else {
					document.getElementById('oahl-attribut4').disabled = false;
				}
			}

			if (oahl_circonstAttr5 && !isEmpty(oahl_groupeAttr5)) {
				qCirc.setParam("Groupe_Id", oahl_groupeAttr5);
				var result = qCirc.execute();
				if (result.responseXML.documentElement.getAttribute('Exist')=="false") {
					document.getElementById('oahl-attribut5').disabled = true;
					document.getElementById('oahl-attribut5').value = "";
				}
				else {
					document.getElementById('oahl-attribut5').disabled = false;
				}
			}

			if (oahl_circonstAttr6 && !isEmpty(oahl_groupeAttr6)) {
				qCirc.setParam("Groupe_Id", oahl_groupeAttr6);
				var result = qCirc.execute();
				if (result.responseXML.documentElement.getAttribute('Exist')=="false") {
					document.getElementById('oahl-attribut6').disabled = true;
					document.getElementById('oahl-attribut6').value = "";
				}
				else {
					document.getElementById('oahl-attribut6').disabled = false;
				}
			}
		}
		else {
			document.getElementById('oahl-attribut1').disabled = isEmpty(oahl_groupeAttr1);
			document.getElementById('oahl-attribut2').disabled = isEmpty(oahl_groupeAttr2);
			document.getElementById('oahl-attribut3').disabled = isEmpty(oahl_groupeAttr3);
			document.getElementById('oahl-attribut4').disabled = isEmpty(oahl_groupeAttr4);
			document.getElementById('oahl-attribut5').disabled = isEmpty(oahl_groupeAttr5);
			document.getElementById('oahl-attribut6').disabled = isEmpty(oahl_groupeAttr6);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oahl_deplacerLigne(moveType) {
	try {

		if (oahl_aAffDepotArticle.isSelected()) {
			var affectationId = oahl_aAffDepotArticle.getSelectedCellText('oahl-colAffectationId');
			var qMove = new QueryHttp("Config/gc/ventes/moveAffectationDepotLigneCC.tmpl");
			qMove.setParam("Affectation_Id", affectationId);
			qMove.setParam("Move_Type", moveType);
			qMove.execute();

			oahl_aAffDepotArticle.initTree(oahl_nouvelleAffectation);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oahl_nouvelleAffectation() {
	try {

		oahl_aAffDepotArticle.clearSelection();

		document.getElementById('oahl-depot').value = "";
		document.getElementById('oahl-nonPrioritaire').checked = false;
		document.getElementById('oahl-famille1').value = "";
		document.getElementById('oahl-famille2').value = "";
		document.getElementById('oahl-famille3').value = "";
		document.getElementById('oahl-attribut1').value = "";
		document.getElementById('oahl-attribut2').value = "";
		document.getElementById('oahl-attribut3').value = "";
		document.getElementById('oahl-attribut4').value = "";
		document.getElementById('oahl-attribut5').value = "";
		document.getElementById('oahl-attribut6').value = "";
		document.getElementById('oahl-referenceLike').value = "";
		document.getElementById('oahl-departement').value = "";
		document.getElementById('oahl-codePays').value = "";
		document.getElementById('oahl-bNouvelleAffectation').collapsed = true;
		document.getElementById('oahl-bSupprimerAffectation').collapsed = true;
		document.getElementById('oahl-bModifierAffectation').collapsed = true;
		document.getElementById('oahl-bCreerAffectation').collapsed = false;
		document.getElementById('oahl-bFlecheHaut').disabled = true;
		document.getElementById('oahl-bFlecheBas').disabled = true;
		oahl_currentAffectationDS = "";
		oahl_manageCirconstAttributs();
		oahl_chargerFamilles("","","");
		oahl_aCodesPostaux.deleteTree();
		document.getElementById('oahl-rowCodePostal').collapsed = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function oahl_supprimerAffectation() {
	try {

		if (window.confirm("Confirmez-vous la suppression de cette affectation ?")) {
			var qSupprimerAffectation = new QueryHttp("Config/gc/ventes/deleteAffectationDepotLigneCC.tmpl");
			qSupprimerAffectation.setParam("Affectation_Id", oahl_currentAffectationDS);
			var result = qSupprimerAffectation.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				document.getElementById('oahl-bSupprimerAffectation').collapsed = true;
				document.getElementById('oahl-bModifierAffectation').collapsed = true;
				document.getElementById('oahl-bCreerAffectation').collapsed = false;
				document.getElementById('oahl-bNouvelleAffectation').collapsed = true;
				oahl_aAffDepotArticle.initTree(oahl_nouvelleAffectation);
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oahl_enregistrerAffectation(mode) {
	try {

		var depotId = document.getElementById('oahl-depot').value;
		var nonPrioritaire = document.getElementById('oahl-nonPrioritaire').checked;
		var famille1 = document.getElementById('oahl-famille1').value;
		var famille2 = document.getElementById('oahl-famille2').value;
		var famille3 = document.getElementById('oahl-famille3').value;
		var attribut1 = document.getElementById('oahl-attribut1').value;
		var attribut2 = document.getElementById('oahl-attribut2').value;
		var attribut3 = document.getElementById('oahl-attribut3').value;
		var attribut4 = document.getElementById('oahl-attribut4').value;
		var attribut5 = document.getElementById('oahl-attribut5').value;
		var attribut6 = document.getElementById('oahl-attribut6').value;
		var referenceLike = document.getElementById('oahl-referenceLike').value;
		var departementId = document.getElementById('oahl-departement').value;
		var codePays = document.getElementById('oahl-codePays').value;

		var qSave;

		if (mode=="C") {
			qSave = new QueryHttp("Config/gc/ventes/createAffectationDepotLigneCC.tmpl");
		}
		else {
			qSave = new QueryHttp("Config/gc/ventes/updateAffectationDepotLigneCC.tmpl");
			qSave.setParam("Affectation_Id", oahl_currentAffectationDS);
		}

		qSave.setParam("Depot_Id", depotId);
		qSave.setParam("Non_Prioritaire", nonPrioritaire);
		qSave.setParam("Famille_1", famille1);
		qSave.setParam("Famille_2", famille2);
		qSave.setParam("Famille_3", famille3);
		qSave.setParam("Attribut_1", attribut1);
		qSave.setParam("Attribut_2", attribut2);
		qSave.setParam("Attribut_3", attribut3);
		qSave.setParam("Attribut_4", attribut4);
		qSave.setParam("Attribut_5", attribut5);
		qSave.setParam("Attribut_6", attribut6);
		qSave.setParam("Reference_Like", referenceLike);
		qSave.setParam("Departement_Id", departementId);
		qSave.setParam("Code_Pays", codePays);

		if (isEmpty(depotId)) { showWarning("Veuillez sp\u00E9cifier un d\u00E9p\u00F4t"); }
		else if (isEmpty(famille1) && isEmpty(famille2) && isEmpty(famille3) && isEmpty(attribut1) && isEmpty(attribut2) && isEmpty(attribut3) && isEmpty(attribut4) && isEmpty(attribut5) && isEmpty(attribut6) && isEmpty(referenceLike) && isEmpty(departementId) && isEmpty(codePays) && oahl_aCodesPostaux.nbLignes()==0) { showWarning("Veuillez sp\u00E9cifier au moins un crit\u00E8re"); }
		else {
			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				if (mode=="C") {
					oahl_currentAffectationDS = result.responseXML.documentElement.getAttribute('Affectation_Id');
					document.getElementById('oahl-bCreerAffectation').collapsed = true;
					document.getElementById('oahl-bModifierAffectation').collapsed = false;
					document.getElementById('oahl-bNouvelleAffectation').collapsed = false;
					document.getElementById('oahl-bSupprimerAffectation').collapsed = false;
				}
			}
			oahl_aAffDepotArticle.initTree(oahl_nouvelleAffectation);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oahl_chargerAffectation() {
	try {

		if (oahl_aAffDepotArticle.isSelected()) {

			var affectationId = oahl_aAffDepotArticle.getSelectedCellText("oahl-colAffectationId");

			var qLoad = new QueryHttp("Config/gc/ventes/loadAffectationDepotLigneCC.tmpl");
			qLoad.setParam("Affectation_Id", affectationId);
			var result = qLoad.execute();

			var contenu = result.responseXML.documentElement;

			oahl_currentAffectationDS = affectationId;

			document.getElementById('oahl-depot').value = contenu.getAttribute('Depot_Id');
			document.getElementById('oahl-nonPrioritaire').checked = contenu.getAttribute('Non_Prioritaire')=="true";
			document.getElementById('oahl-famille1').value = contenu.getAttribute('Famille_1');

			oahl_aFamille2.deleteTree();
			oahl_aFamille3.deleteTree();
			document.getElementById('oahl-famille2').selectedIndex = 0;
			document.getElementById('oahl-famille3').selectedIndex = 0;
			document.getElementById('oahl-famille2').disabled = true;
			document.getElementById('oahl-famille3').disabled = true;
			oahl_manageCirconstAttributs();

			oahl_chargerFamille1 = contenu.getAttribute('Famille_1');
			oahl_chargerFamille2 = contenu.getAttribute('Famille_2');
			oahl_chargerFamille3 = contenu.getAttribute('Famille_3');

			oahl_chargerFamilles1();

			document.getElementById('oahl-attribut1').value = contenu.getAttribute('Attribut_1');
			document.getElementById('oahl-attribut2').value = contenu.getAttribute('Attribut_2');
			document.getElementById('oahl-attribut3').value = contenu.getAttribute('Attribut_3');
			document.getElementById('oahl-attribut4').value = contenu.getAttribute('Attribut_4');
			document.getElementById('oahl-attribut5').value = contenu.getAttribute('Attribut_5');
			document.getElementById('oahl-attribut6').value = contenu.getAttribute('Attribut_6');
			document.getElementById('oahl-referenceLike').value = contenu.getAttribute('Reference_Like');
			document.getElementById('oahl-departement').value = contenu.getAttribute('Departement_Id');
			document.getElementById('oahl-codePays').value = contenu.getAttribute('Code_Pays');
			document.getElementById('oahl-bSupprimerAffectation').collapsed = false;
			document.getElementById('oahl-bModifierAffectation').collapsed = false;
			document.getElementById('oahl-bNouvelleAffectation').collapsed = false;
			document.getElementById('oahl-bCreerAffectation').collapsed = true;

			var idx = oahl_aAffDepotArticle.getCurrentIndex();
			document.getElementById('oahl-bFlecheHaut').disabled = (idx==0);
			document.getElementById('oahl-bFlecheBas').disabled = (idx==oahl_aAffDepotArticle.nbLignes()-1);

			oahl_aCodesPostaux.setParam("Affectation_Id", oahl_currentAffectationDS);
			oahl_aCodesPostaux.initTree();
			document.getElementById('oahl-rowCodePostal').collapsed = false;
			oahl_nouveauCodePostal();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oahl_nouveauCodePostal() {
	try {

		oahl_codeId = null;
		document.getElementById("oahl-codePostal").value = "";
		document.getElementById("oahl-bSupprimerCP").disabled = true;
		oahl_aCodesPostaux.clearSelection();

	} catch (e) {
		recup_erreur(e);
	}
}


function oahl_enregistrerCodePostal() {
	try {

		var codePostal = document.getElementById("oahl-codePostal").value;

		if (isEmpty(codePostal)) {
			showWarning("Code postal incorrect");
		}
		else {
			var qSave;
			if (oahl_codeId==null) {
				qSave = new QueryHttp("Config/gc/ventes/createCodePostalAffectationDepotLigneCC.tmpl");
				qSave.setParam("Affectation_Id", oahl_currentAffectationDS);
			}
			else {
				qSave = new QueryHttp("Config/gc/ventes/updateCodePostalAffectationDepotLigneCC.tmpl");
				qSave.setParam("Code_Id", oahl_codeId);
			}
			qSave.setParam("Code_Postal", codePostal);
			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			oahl_aCodesPostaux.initTree();
			oahl_nouveauCodePostal();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oahl_supprimerCodePostal() {
	try {

		if (oahl_codeId!=null) {
			var qDelete = new QueryHttp("Config/gc/ventes/deleteCodePostalAffectationDepotLigneCC.tmpl");
			qDelete.setParam("Code_Id", oahl_codeId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			oahl_aCodesPostaux.initTree();
			oahl_nouveauCodePostal();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oahl_pressOnListeCodesPostaux() {
	try {

		if (oahl_aCodesPostaux.isSelected()) {
			oahl_codeId = oahl_aCodesPostaux.getSelectedCellText("oahl-colCodeId");
			document.getElementById("oahl-codePostal").value = oahl_aCodesPostaux.getSelectedCellText("oahl-colCodePostal");
			document.getElementById("oahl-bSupprimerCP").disabled = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oahl_importerCodesPostaux() {
  try {

	  var url = "chrome://opensi/content/config/gc/ventes/popup-importCodePostalAffectationDepotLigneCC.xul";
	  window.openDialog(url,'','chrome,modal,centerscreen', oahl_retourImporterCodesPostaux, oahl_currentAffectationDS);

  } catch (e) {
    recup_erreur(e);
  }
}


function oahl_retourImporterCodesPostaux() {
	try {

		oahl_aCodesPostaux.initTree();
		oahl_nouveauCodePostal();

	} catch (e) {
	  recup_erreur(e);
	}
}



// AFFECTATIONS FRAIS PORT


function oahl_nouvelleAffectationFraisPort() {
	try {

		oahl_aAffectationFraisPort.initTree();

		document.getElementById('oahl-bSupprimer_AFP').collapsed = true;
		oahl_currentAffectationFP = "";

		document.getElementById('oahl-fraisPort_AFP').value = "";
		document.getElementById('oahl-montantDebut_AFP').value = "";
		document.getElementById('oahl-montantFin_AFP').value = "";

	} catch (e) {
		recup_erreur(e);
	}
}


function oahl_ouvrirAffectationFraisPort() {
	try {

		var i = oahl_aAffectationFraisPort.getCurrentIndex();
		document.getElementById('oahl-fraisPort_AFP').value = oahl_aAffectationFraisPort.getCellText(i, 'oahl-colFraisPort_AFP');
		document.getElementById('oahl-montantDebut_AFP').value = oahl_aAffectationFraisPort.getCellText(i, 'oahl-colMontantDebut_AFP');
		document.getElementById('oahl-montantFin_AFP').value = oahl_aAffectationFraisPort.getCellText(i, 'oahl-colMontantFin_AFP');
		oahl_currentAffectationFP = oahl_aAffectationFraisPort.getCellText(i, 'oahl-colAffectationId_AFP');

		document.getElementById('oahl-bSupprimer_AFP').collapsed = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function oahl_supprimerAffectationFraisPort() {
	try {

		if (!isEmpty(oahl_currentAffectationFP) && window.confirm("Voulez-vous supprimer l'affectation s\u00E9lectionn\u00E9e ?")) {
			var qSupprimer = new QueryHttp("Config/gc/ventes/deleteAffectationFraisPort.tmpl");
			qSupprimer.setParam("Affectation_Id", oahl_currentAffectationFP);
			var result = qSupprimer.execute();
			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			} else {
				oahl_nouvelleAffectationFraisPort();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oahl_enregistrerAffectationFraisPort() {
	try {

		var fraisPort = document.getElementById('oahl-fraisPort_AFP').value;
		var montantDebut = document.getElementById('oahl-montantDebut_AFP').value;
		var montantFin = document.getElementById('oahl-montantFin_AFP').value;

		if (isEmpty(fraisPort)) { showWarning("Veuillez saisir les frais de port") }
		else if (!isPositiveOrNull(fraisPort) || !checkDecimal(fraisPort,2)) { showWarning("Frais de port incorrects") }
		else if (isEmpty(montantDebut)) { showWarning("Veuillez saisir le montant de d\u00E9part.") }
		else if (!isPositiveOrNull(montantDebut) || !checkDecimal(montantDebut,2)) { showWarning("Montant de d\u00E9part erron\u00E9") }
		else if (!isEmpty(montantFin) && (!isPositiveOrNull(montantFin) || !checkDecimal(montantFin,2))) { showWarning("Montant de fin erron\u00E9") }
		else if (parseFloat(montantDebut)>parseFloat(montantFin)) { showWarning("Montant de fin erron\u00E9") }
		else {

			var qEnregistrer;

			if (!isEmpty(oahl_currentAffectationFP)) {
				qEnregistrer = new QueryHttp("Config/gc/ventes/updateAffectationFraisPort.tmpl");
				qEnregistrer.setParam("Affectation_Id", oahl_currentAffectationFP);
			}
			else {
				qEnregistrer = new QueryHttp("Config/gc/ventes/createAffectationFraisPort.tmpl");
			}

			qEnregistrer.setParam("Frais_Port", fraisPort);
			qEnregistrer.setParam("Montant_Debut", montantDebut);
			qEnregistrer.setParam("Montant_Fin", montantFin);

			var result = qEnregistrer.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oahl_nouvelleAffectationFraisPort();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}



// AFFECTATIONS MODE EXPEDITION


function oahl_nouvelleAffectationModeExpedition() {
	try {

		oahl_aAffectationModeExpedition.initTree();

		document.getElementById('oahl-bSupprimer_AME').collapsed = true;
		oahl_currentAffectationME = "";
		oahl_aModesExpe.clearParams();
		oahl_aModesExpe.initTree();

		document.getElementById('oahl-modeExpedition_AME').value = "";
		document.getElementById('oahl-typeAffectation_AME').value = "";
		document.getElementById('oahl-poidsDebut_AME').value = "";
		document.getElementById('oahl-poidsFin_AME').value = "";

	} catch (e) {
		recup_erreur(e);
	}
}


function oahl_ouvrirAffectationModeExpedition() {
	try {

		oahl_aModesExpe.setParam("Selection", oahl_aAffectationModeExpedition.getSelectedCellText('oahl-colModeExpeditionId_AME'));
		oahl_aModesExpe.initTree(oahl_ouvrirAffectationModeExpedition2);

	} catch (e) {
		recup_erreur(e);
	}
}


function oahl_ouvrirAffectationModeExpedition2() {
	try {

		var i = oahl_aAffectationModeExpedition.getCurrentIndex();
		document.getElementById('oahl-modeExpedition_AME').value = oahl_aAffectationModeExpedition.getCellText(i, 'oahl-colModeExpeditionId_AME');
		document.getElementById('oahl-typeAffectation_AME').value = oahl_aAffectationModeExpedition.getCellText(i, 'oahl-colTypeAffectation_AME');
		document.getElementById('oahl-poidsDebut_AME').value = oahl_aAffectationModeExpedition.getCellText(i, 'oahl-colPoidsDebut_AME');
		document.getElementById('oahl-poidsFin_AME').value = oahl_aAffectationModeExpedition.getCellText(i, 'oahl-colPoidsFin_AME');
		oahl_currentAffectationME = oahl_aAffectationModeExpedition.getCellText(i, 'oahl-colAffectationId_AME');

		document.getElementById('oahl-bSupprimer_AME').collapsed = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function oahl_supprimerAffectationModeExpedition() {
	try {

		if (!isEmpty(oahl_currentAffectationME) && window.confirm("Voulez-vous supprimer l'affectation s\u00E9lectionn\u00E9e ?")) {
			var qSupprimer = new QueryHttp("Config/gc/ventes/deleteAffectationModeExpedition.tmpl");
			qSupprimer.setParam("Affectation_Id", oahl_currentAffectationME);
			var result = qSupprimer.execute();
			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			} else {
				oahl_nouvelleAffectationModeExpedition();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oahl_enregistrerAffectationModeExpedition() {
	try {

		var modeExpedition = document.getElementById('oahl-modeExpedition_AME').value;
		var typeAffectation = document.getElementById('oahl-typeAffectation_AME').value;
		var poidsDebut = document.getElementById('oahl-poidsDebut_AME').value;
		var poidsFin = document.getElementById('oahl-poidsFin_AME').value;

		if (isEmpty(modeExpedition)) { showWarning("Veuillez choisir le mode d'exp\u00E9dition") }
		else if (isEmpty(typeAffectation)) { showWarning("Veuillez choisir le type d'affectation") }
		else if (isEmpty(poidsDebut)) { showWarning("Veuillez saisir le poids de d\u00E9part.") }
		else if (!isPositiveOrNull(poidsDebut) || !checkDecimal(poidsDebut,3)) { showWarning("Poids de d\u00E9part erron\u00E9") }
		else if (!isEmpty(poidsFin) && (!isPositiveOrNull(poidsFin) || !checkDecimal(poidsFin,3))) { showWarning("Poids de fin erron\u00E9") }
		else if (parseFloat(poidsDebut)>parseFloat(poidsFin)) { showWarning("Poids de fin erron\u00E9") }
		else {

			var qEnregistrer;

			if (!isEmpty(oahl_currentAffectationME)) {
				qEnregistrer = new QueryHttp("Config/gc/ventes/updateAffectationModeExpedition.tmpl");
				qEnregistrer.setParam("Affectation_Id", oahl_currentAffectationME);
			}
			else {
				qEnregistrer = new QueryHttp("Config/gc/ventes/createAffectationModeExpedition.tmpl");
			}

			qEnregistrer.setParam("Type_Affectation", typeAffectation);
			qEnregistrer.setParam("Mode_Expedition", modeExpedition);
			qEnregistrer.setParam("Poids_Debut", poidsDebut);
			qEnregistrer.setParam("Poids_Fin", poidsFin);

			var result = qEnregistrer.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oahl_nouvelleAffectationModeExpedition();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


// AFFECTATIONS MODE EXPEDITION DEVIS


function oahl_nouvelleAffectationModeExpeditionDevis() {
	try {

		oahl_aAffectationModeExpeditionDevis.setParam("Origine", "D");
		oahl_aAffectationModeExpeditionDevis.initTree();

		document.getElementById('oahl-bSupprimer_MD').collapsed = true;
		oahl_currentAffectationME = "";
		oahl_aModesExpeInitial.clearParams();
		oahl_aModesExpeInitial.initTree();
		oahl_aModesExpeFinal.clearParams();
		oahl_aModesExpeFinal.initTree();

		document.getElementById('oahl-modeExpeInitial_MD').value = "";
		document.getElementById('oahl-modeExpeFinal_MD').value = "";
		document.getElementById('oahl-poidsDeb_MD').value = "";
		document.getElementById('oahl-poidsFin_MD').value = "";
		document.getElementById('oahl-colisageSpe_MD').checked = false;
		document.getElementById('oahl-departement_MD').value = "";
		document.getElementById('oahl-codePays_MD').value = "";

	} catch (e) {
		recup_erreur(e);
	}
}


function oahl_ouvrirAffectationModeExpeditionDevis() {
	try {

		if (oahl_aAffectationModeExpeditionDevis.isSelected()) {
			oahl_currentAffectationME = oahl_aAffectationModeExpeditionDevis.getSelectedCellText('oahl-colAffectationId_MD');
			oahl_aModesExpeInitial.setParam("Selection", oahl_aAffectationModeExpeditionDevis.getSelectedCellText('oahl-colModeExpeInitId_MD'));
			oahl_aModesExpeInitial.initTree(oahl_ouvrirAffectationModeExpeditionDevis2);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oahl_ouvrirAffectationModeExpeditionDevis2() {
	try {

		document.getElementById('oahl-modeExpeInitial_MD').value = oahl_aAffectationModeExpeditionDevis.getSelectedCellText('oahl-colModeExpeInitId_MD');
		oahl_aModesExpeFinal.setParam("Selection", oahl_aAffectationModeExpeditionDevis.getSelectedCellText('oahl-colModeExpeFinalId_MD'));
		oahl_aModesExpeFinal.initTree(oahl_ouvrirAffectationModeExpeditionDevis3);

	} catch (e) {
		recup_erreur(e);
	}
}


function oahl_ouvrirAffectationModeExpeditionDevis3() {
	try {

		var i = oahl_aAffectationModeExpeditionDevis.getCurrentIndex();
		document.getElementById('oahl-modeExpeFinal_MD').value = oahl_aAffectationModeExpeditionDevis.getCellText(i, 'oahl-colModeExpeFinalId_MD');
		document.getElementById('oahl-poidsDeb_MD').value = oahl_aAffectationModeExpeditionDevis.getCellText(i, 'oahl-colPoidsDeb_MD');
		document.getElementById('oahl-poidsFin_MD').value = oahl_aAffectationModeExpeditionDevis.getCellText(i, 'oahl-colPoidsFin_MD');
		document.getElementById('oahl-colisageSpe_MD').checked = oahl_aAffectationModeExpeditionDevis.getCellText(i, 'oahl-colColisageId_MD')=="true";
		document.getElementById('oahl-codePays_MD').value = oahl_aAffectationModeExpeditionDevis.getCellText(i, 'oahl-colCodePays_MD');
		document.getElementById('oahl-departement_MD').value = oahl_aAffectationModeExpeditionDevis.getCellText(i, 'oahl-colDepartementId_MD');
		document.getElementById('oahl-bSupprimer_MD').collapsed = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function oahl_supprimerAffectationModeExpeditionDevis() {
	try {

		if (!isEmpty(oahl_currentAffectationME) && window.confirm("Voulez-vous supprimer l'affectation s\u00E9lectionn\u00E9e ?")) {
			var qDelete = new QueryHttp("Config/gc/ecommerce/deleteAffectationModeExpedition.tmpl");
			qDelete.setParam("Affectation_Id", oahl_currentAffectationME);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oahl_nouvelleAffectationModeExpeditionDevis();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oahl_enregistrerAffectationModeExpeditionDevis() {
	try {

		var modeExpeInitial = document.getElementById('oahl-modeExpeInitial_MD').value;
		var modeExpeFinal = document.getElementById('oahl-modeExpeFinal_MD').value;
		var poidsDeb = document.getElementById('oahl-poidsDeb_MD').value;
		var poidsFin = document.getElementById('oahl-poidsFin_MD').value;
		var colisageSpe = document.getElementById('oahl-colisageSpe_MD').checked;
		var departementId = document.getElementById('oahl-departement_MD').value;
		var codePays = document.getElementById('oahl-codePays_MD').value;

		if (isEmpty(modeExpeInitial)) { showWarning("Veuillez saisir le mode d'exp\u00E9dition initial") }
		else if (isEmpty(modeExpeFinal)) { showWarning("Veuillez saisir le mode d'exp\u00E9dition final") }
		else if (modeExpeInitial==modeExpeFinal) { showWarning("Veuillez saisir un mode d'exp\u00E9dition final diff\u00E9rent de l'initial") }
		else if (isEmpty(poidsDeb)) { showWarning("Veuillez saisir le poids de d\u00E9part.") }
		else if (!isPositiveOrNull(poidsDeb)) { showWarning("Poids de d\u00E9part erron\u00E9") }
		else if (!isEmpty(poidsFin) && !isPositiveOrNull(poidsFin)) { showWarning("Poids de fin erron\u00E9") }
		else if (parseFloat(poidsDeb)>parseFloat(poidsFin)) { showWarning("Poids de fin erron\u00E9") }
		else {

			var qSave;

			if (!isEmpty(oahl_currentAffectationME)) {
				qSave = new QueryHttp("Config/gc/ecommerce/updateAffectationModeExpedition.tmpl");
				qSave.setParam("Affectation_Id", oahl_currentAffectationME);
			}
			else {
				qSave = new QueryHttp("Config/gc/ecommerce/createAffectationModeExpedition.tmpl");
				qSave.setParam("Origine", "D");
			}

			qSave.setParam("Mode_Expe_Init", modeExpeInitial);
			qSave.setParam("Mode_Expe_Final", modeExpeFinal);
			qSave.setParam("Poids_Debut", poidsDeb);
			qSave.setParam("Poids_Fin", poidsFin);
			qSave.setParam("Colisage_Spe", colisageSpe);
			qSave.setParam("Departement_Id", departementId);
			qSave.setParam("Code_Pays", codePays);

			var result = qSave.execute();
			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oahl_nouvelleAffectationModeExpeditionDevis();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}
