/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var oea_aEmails = new Arbre("Config/gc/ventes/list-email.tmpl", "oea-listeEmails");

var oea_currentEmailId = "";



function oea_init() {
	try {

		oea_listerEmails();

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_listerEmails() {
	try {

		oea_aEmails.initTree();
		oea_nouveauEmail();

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_nouveauEmail() {
	try {

		oea_currentEmailId = "";
		oea_aEmails.clearSelection();

		document.getElementById('oea-libelle').value = "";
		document.getElementById('oea-expediteur').value="";
		document.getElementById('oea-destCC').value="";
		document.getElementById('oea-destBCC').value="";
		document.getElementById('oea-sujet').value="";

		document.getElementById('oea-bSupprimer').collapsed = true;
		document.getElementById('oea-bNouveau').collapsed = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_chargerEmail() {
	try {

		if (oea_aEmails.isSelected()) {
			oea_currentEmailId = oea_aEmails.getSelectedCellText("oea-colEmailId");

			var qLoad = new QueryHttp("Config/gc/ventes/loadEmail.tmpl");
			qLoad.setParam("Email_Id", oea_currentEmailId);
			var result = qLoad.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var contenu = result.responseXML.documentElement;

				document.getElementById('oea-libelle').value = contenu.getAttribute('Libelle');
				document.getElementById('oea-expediteur').value = contenu.getAttribute('Expediteur');
				document.getElementById('oea-destCC').value = contenu.getAttribute('Dest_CC');
				document.getElementById('oea-destBCC').value = contenu.getAttribute('Dest_BCC');
				document.getElementById('oea-sujet').value = contenu.getAttribute('Sujet');

				document.getElementById('oea-bSupprimer').collapsed = false;
				document.getElementById('oea-bNouveau').collapsed = false;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_enregistrerEmail() {
	try {

		var libelle = document.getElementById('oea-libelle').value;
		var expediteur = document.getElementById('oea-expediteur').value;
		var destCC = document.getElementById('oea-destCC').value;
		var destBCC = document.getElementById('oea-destBCC').value;
		var sujet = document.getElementById('oea-sujet').value;

		if (isEmpty(libelle)) { showWarning("Intitul\u00E9 manquant"); }
		else if (isEmpty(expediteur) || !isEmail(expediteur)) { showWarning("E-mail exp\u00E9diteur incorrect"); }
		else if (!isEmpty(destCC) && !isEmail(destCC)) { showWarning("Destinataire CC incorrect"); }
		else if (!isEmpty(destBCC) && !isEmail(destBCC)) { showWarning("Destinataire BCC incorrect"); }
		else if (isEmpty(sujet)) { showWarning("Sujet manquant"); }
		else {
			var qSave;

			if (!isEmpty(oea_currentEmailId)) {
				qSave = new QueryHttp("Config/gc/ventes/updateEmail.tmpl");
				qSave.setParam("Email_Id", oea_currentEmailId);
			}
			else {
				qSave = new QueryHttp("Config/gc/ventes/createEmail.tmpl");
			}

			qSave.setParam("Libelle", libelle);
			qSave.setParam('Expediteur', expediteur);
			qSave.setParam('Dest_CC', destCC);
			qSave.setParam('Dest_BCC', destBCC);
			qSave.setParam('Sujet', sujet);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oea_listerEmails();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_supprimerEmail() {
	try {

		if (!isEmpty(oea_currentEmailId) && window.confirm("Confirmez-vous la suppression de l'e-mail s\u00E9lectionn\u00E9 ?")) {

			var qDelete = new QueryHttp("Config/gc/ventes/deleteEmail.tmpl");
			qDelete.setParam("Email_Id", oea_currentEmailId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oea_listerEmails();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}
