/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var opvt_aDepots = new Arbre("ComboListe/combo-depotsStock.tmpl", "opvt-GAC_Def_Filtre_Depot");

var opvt_modified = false;
var opvt_selDepotId;



function opvt_init() {
	try {

		var aGACProvenance = new Arbre("ComboListe/combo-sitesWeb.tmpl","opvt-GAC_Provenance");
		aGACProvenance.setParam("No_Check_Rights", true);
		aGACProvenance.initTree(opvt_init2);
		document.getElementById("opvt-gpModeTarif").collapsed = !adminMode;
		document.getElementById("opvt-Histo_Avant_Valid_DC").collapsed = !adminMode;
		document.getElementById("opvt-Histo_Avant_Valid_CC").collapsed = !adminMode;
		document.getElementById("opvt-GAC_Cout_Trans").collapsed = !adminMode;
		document.getElementById("opvt-GAC_Rech_Market_Place").collapsed = !adminMode;
		document.getElementById("opvt-GAC_Statut_Archive").collapsed = !adminMode;
		document.getElementById("opvt-GAC_Drop_Possible_Auto").collapsed = !adminMode;
		document.getElementById("opvt-GAC_Creneau_Livraison").collapsed = !adminMode;
		document.getElementById("opvt-Restocking_Prio_Recep").collapsed = !adminMode;

	} catch (e) {
    recup_erreur(e);
  }
}


function opvt_init2() {
	try {

		var aEmails = new Arbre("ComboListe/combo-emails.tmpl", "opvt-Email_VCC");
		aEmails.initTree(opvt_init3);

	} catch (e) {
    recup_erreur(e);
  }
}


function opvt_init3() {
	try {

		var aEmails = new Arbre("ComboListe/combo-emails.tmpl", "opvt-Email_ACC");
		aEmails.initTree(opvt_init4);

	} catch (e) {
    recup_erreur(e);
  }
}


function opvt_init4() {
	try {

		var aEmails = new Arbre("ComboListe/combo-emails.tmpl", "opvt-Email_ECC");
		aEmails.initTree(opvt_init5);

	} catch (e) {
    recup_erreur(e);
  }
}


function opvt_init5() {
	try {

		var aEmails = new Arbre("ComboListe/combo-emails.tmpl", "opvt-Email_PCC");
		aEmails.initTree(opvt_init6);

	} catch (e) {
    recup_erreur(e);
  }
}


function opvt_init6() {
	try {

		var aEmails = new Arbre("ComboListe/combo-emails.tmpl", "opvt-Email_VFC");
		aEmails.initTree(opvt_init7);

	} catch (e) {
    recup_erreur(e);
  }
}


function opvt_init7() {
	try {

		var aEmails = new Arbre("ComboListe/combo-emails.tmpl", "opvt-Email_VAC");
		aEmails.initTree(opvt_init8);

	} catch (e) {
    recup_erreur(e);
  }
}


function opvt_init8() {
	try {

		var aEmails = new Arbre("ComboListe/combo-emails.tmpl", "opvt-Email_RCC");
		aEmails.initTree(opvt_init9);

	} catch (e) {
    recup_erreur(e);
  }
}


function opvt_init9() {
	try {

		var aEmails = new Arbre("ComboListe/combo-emails.tmpl", "opvt-Email_RRC");
		aEmails.initTree(opvt_init10);

	} catch (e) {
    recup_erreur(e);
  }
}


function opvt_init10() {
	try {

		var aEmails = new Arbre("ComboListe/combo-emails.tmpl", "opvt-Email_ERF");
		aEmails.initTree(opvt_init11);

	} catch (e) {
    recup_erreur(e);
  }
}


function opvt_init11() {
	try {

		var aEmails = new Arbre("ComboListe/combo-emails.tmpl", "opvt-Email_ERC_1");
		aEmails.initTree(opvt_init12);

	} catch (e) {
    recup_erreur(e);
  }
}


function opvt_init12() {
	try {

		var aEmails = new Arbre("ComboListe/combo-emails.tmpl", "opvt-Email_ERC_2");
		aEmails.initTree(opvt_init13);

	} catch (e) {
    recup_erreur(e);
  }
}


function opvt_init13() {
	try {

		var aEmails = new Arbre("ComboListe/combo-emails.tmpl", "opvt-Email_ERC_3");
		aEmails.initTree(opvt_init14);

	} catch (e) {
    recup_erreur(e);
  }
}


function opvt_init14() {
	try {

		var aEmails = new Arbre("ComboListe/combo-emails.tmpl", "opvt-Email_VRP");
		aEmails.initTree(opvt_init15);

	} catch (e) {
    recup_erreur(e);
  }
}


function opvt_init15() {
	try {

		var aFieldCol1 = new Arbre("ComboListe/combo-groupesAttribut.tmpl", "opvt-Field_Column_DV_1");
		aFieldCol1.initTree(opvt_init16);

	} catch (e) {
    recup_erreur(e);
  }
}


function opvt_init16() {
	try {

		var aFieldCol2 = new Arbre("ComboListe/combo-groupesAttribut.tmpl", "opvt-Field_Column_DV_2");
		aFieldCol2.initTree(opvt_init17);

	} catch (e) {
    recup_erreur(e);
  }
}


function opvt_init17() {
	try {

		var aTarifsVente = new Arbre("ComboListe/combo-tarifsVente.tmpl", "opvt-Tarif_Vente_1");
		aTarifsVente.initTree(opvt_init18);

	} catch (e) {
    recup_erreur(e);
  }
}


function opvt_init18() {
	try {

		var aTarifsVente = new Arbre("ComboListe/combo-tarifsVente.tmpl", "opvt-Tarif_Vente_2");
		aTarifsVente.initTree(opvt_init19);

	} catch (e) {
    recup_erreur(e);
  }
}


function opvt_init19() {
	try {

		var aTarifsVente = new Arbre("ComboListe/combo-tarifsVente.tmpl", "opvt-Tarif_Vente_3");
		aTarifsVente.initTree(opvt_init20);

	} catch (e) {
    recup_erreur(e);
  }
}


function opvt_init20() {
	try {

		var aTarifsVente = new Arbre("ComboListe/combo-tarifsVente.tmpl", "opvt-Tarif_Vente_4");
		aTarifsVente.initTree(opvt_init21);

	} catch (e) {
    recup_erreur(e);
  }
}


function opvt_init21() {
	try {

		var aTarifsVente = new Arbre("ComboListe/combo-tarifsVente.tmpl", "opvt-Tarif_Vente_5");
		aTarifsVente.initTree(opvt_init22);

	} catch (e) {
    recup_erreur(e);
  }
}


function opvt_init22() {
	try {

		var aEmails = new Arbre("ComboListe/combo-emails.tmpl", "opvt-Email_VBL");
		aEmails.initTree(opvt_init23);

	} catch (e) {
    recup_erreur(e);
  }
}


function opvt_init23() {
	try {

		var aConfigSMS = new Arbre("ComboListe/combo-configSMS.tmpl", "opvt-Config_SMS_RCC");
		aConfigSMS.initTree(opvt_loadPreferences);

	} catch (e) {
    recup_erreur(e);
  }
}


function opvt_demandeEnregistrement() {
	try {

		if (opvt_modified && window.confirm("Voulez-vous enregistrer les modifications apport\u00E9es ?")) {
			opvt_updatePreferences();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function opvt_chargerDepots(selection) {
	try {

		opvt_selDepotId = selection;
		opvt_aDepots.setParam('Depot_Vente', false);
		opvt_aDepots.setParam('Depot_Quarantaine', false);
		opvt_aDepots.setParam("Selection", opvt_selDepotId);
		opvt_aDepots.initTree(opvt_initDepot);

	} catch (e) {
		recup_erreur(e);
	}
}


function opvt_initDepot() {
  try {

		document.getElementById('opvt-GAC_Def_Filtre_Depot').value = opvt_selDepotId;

	} catch (e) {
  	recup_erreur(e);
	}
}


function opvt_loadPreferences() {
	try {

		var qLoad = new QueryHttp("Config/gc/ventes/getPreferencesVente.tmpl");
		var result = qLoad.execute();
		var contenu = result.responseXML.documentElement;

		document.getElementById("opvt-Vente_TTC").checked = contenu.getAttribute("Vente_TTC")=="true";
		document.getElementById("opvt-Taxation_TVA_Liv").checked = contenu.getAttribute("Taxation_TVA_Liv")=="true";
		document.getElementById("opvt-Col_PU_Net").checked = contenu.getAttribute("Col_PU_Net")=="true";
		document.getElementById("opvt-Show_Mention_CGV").checked = contenu.getAttribute("Show_Mention_CGV")=="true";
		document.getElementById("opvt-Alerte_Encours_Client").checked = contenu.getAttribute("Alerte_Encours_Client")=="true";
		document.getElementById("opvt-Encours_Cli_Mutualise").checked = contenu.getAttribute("Encours_Cli_Mutualise")=="true";
		document.getElementById("opvt-Col_Photo_DC").checked = contenu.getAttribute("Col_Photo_DC")=="true";
		document.getElementById("opvt-Show_Photo_XL_DC").checked = contenu.getAttribute("Show_Photo_XL_DC")=="true";
		document.getElementById("opvt-Mode_Traitement").value = contenu.getAttribute("Mode_Traitement");
		document.getElementById("opvt-Def_Etat_Rech_Com").value = contenu.getAttribute("Def_Etat_Rech_Com");
		document.getElementById("opvt-Def_Etat_Rech_Log").value = contenu.getAttribute("Def_Etat_Rech_Log");
		document.getElementById("opvt-GAC_Etat_Paiement").value = contenu.getAttribute("GAC_Etat_Paiement");
		document.getElementById("opvt-GAC_Provenance").value = contenu.getAttribute("GAC_Provenance");
		document.getElementById("opvt-GAC_Def_Filtre_Etab").value = contenu.getAttribute("GAC_Def_Filtre_Etab");
		document.getElementById("opvt-GAC_Aff_Auto_Fact_Avoir").checked = contenu.getAttribute("GAC_Aff_Auto_Fact_Avoir")=="true";
		document.getElementById("opvt-GAC_Proposer_Rbt").checked = contenu.getAttribute("GAC_Proposer_Rbt")=="true";
		document.getElementById("opvt-GAC_Prop_Rbt_Annul").checked = contenu.getAttribute("GAC_Prop_Rbt_Annul")=="true";
		document.getElementById("opvt-GAC_Drop_Possible_Auto").checked = contenu.getAttribute("GAC_Drop_Possible_Auto")=="true";
		document.getElementById("opvt-GAC_No_Stock_Four_DPA").checked = contenu.getAttribute("GAC_No_Stock_Four_DPA")=="true";
		document.getElementById("opvt-GAC_Drop_Auto_Partiel").checked = contenu.getAttribute("GAC_Drop_Auto_Partiel")=="true";
		document.getElementById("opvt-GAC_Montant_Min_DPA").value = contenu.getAttribute("GAC_Montant_Min_DPA");
		document.getElementById("opvt-GAC_Aut_Non_Facturable").checked = contenu.getAttribute("GAC_Aut_Non_Facturable")=="true";
		document.getElementById("opvt-Calcul_Stock").checked = contenu.getAttribute("Calcul_Stock")=="true";
		document.getElementById("opvt-Type_Calcul_Stock").checked = contenu.getAttribute("Type_Calcul_Stock")=="true";
		document.getElementById("opvt-CS_Date_Expedition").checked = contenu.getAttribute("CS_Date_Expedition")=="true";
		document.getElementById("opvt-Show_Intitule_DC").checked = contenu.getAttribute("Show_Intitule_DC")=="true";
		document.getElementById("opvt-Show_Mode_Expedition_DC").checked = contenu.getAttribute("Show_Mode_Expedition_DC")=="true";
		document.getElementById("opvt-Show_Sous_Totaux_DC").checked = contenu.getAttribute("Show_Sous_Totaux_DC")=="true";
		document.getElementById("opvt-Show_Modalites_DC").checked = contenu.getAttribute("Show_Modalites_DC")=="true";
		document.getElementById("opvt-Show_Intitule_Cde_CC").checked = contenu.getAttribute("Show_Intitule_Cde_CC")=="true";
		document.getElementById("opvt-Imp_RIB_CC").value = contenu.getAttribute("Imp_RIB_CC");
		document.getElementById("opvt-Imp_RIB_DC").value = contenu.getAttribute("Imp_RIB_DC");
		document.getElementById("opvt-Email_VCC").value = contenu.getAttribute("Email_VCC");
		document.getElementById("opvt-Email_ACC").value = contenu.getAttribute("Email_ACC");
		document.getElementById("opvt-Email_ECC").value = contenu.getAttribute("Email_ECC");
		document.getElementById("opvt-Email_PCC").value = contenu.getAttribute("Email_PCC");
		document.getElementById("opvt-Email_RCC").value = contenu.getAttribute("Email_RCC");
		document.getElementById("opvt-Email_VFC").value = contenu.getAttribute("Email_VFC");
		document.getElementById("opvt-Email_VAC").value = contenu.getAttribute("Email_VAC");
		document.getElementById("opvt-Email_RRC").value = contenu.getAttribute("Email_RRC");
		document.getElementById("opvt-Email_ERF").value = contenu.getAttribute("Email_ERF");
		document.getElementById("opvt-Email_ERC_1").value = contenu.getAttribute("Email_ERC_1");
		document.getElementById("opvt-Email_ERC_2").value = contenu.getAttribute("Email_ERC_2");
		document.getElementById("opvt-Email_ERC_3").value = contenu.getAttribute("Email_ERC_3");
		document.getElementById("opvt-Email_VRP").value = contenu.getAttribute("Email_VRP");
		document.getElementById("opvt-Email_VBL").value = contenu.getAttribute("Email_VBL");
		document.getElementById("opvt-Attach_LC_Email_ECC").checked = contenu.getAttribute("Attach_LC_Email_ECC")=="true";
		document.getElementById("opvt-Copy_CEC_Email_VFC").checked = contenu.getAttribute("Copy_CEC_Email_VFC")=="true";
		document.getElementById("opvt-Mode_Tarif").value = contenu.getAttribute("Mode_Tarif");
		document.getElementById("opvt-Com_Devis").value = contenu.getAttribute("Com_Devis");
		document.getElementById("opvt-Com_Fact").value = contenu.getAttribute("Com_Fact");
		document.getElementById("opvt-Infos_Pied_Facture").value = contenu.getAttribute("Infos_Pied_Facture");
		document.getElementById("opvt-Def_Mode_Facturation").value = contenu.getAttribute("Def_Mode_Facturation");
		document.getElementById("opvt-Def_Fact_Avant_Liv").checked = contenu.getAttribute("Def_Fact_Avant_Liv")=="true";
		document.getElementById("opvt-Def_Periode_Facturation").value = contenu.getAttribute("Def_Periode_Facturation");
		document.getElementById("opvt-Def_Mode_Envoi_Facture").value = contenu.getAttribute("Def_Mode_Envoi_Facture");
		document.getElementById("opvt-Module_Envoi").checked = contenu.getAttribute("Module_Envoi")=="true";
		document.getElementById("opvt-Imp_LCR").checked = contenu.getAttribute("Imp_LCR")=="true";
		document.getElementById("opvt-Imp_RIB_FC").value = contenu.getAttribute("Imp_RIB_FC");
		document.getElementById("opvt-Opt_TB_Facture").checked = contenu.getAttribute("Opt_TB_Facture")=="true";
		document.getElementById("opvt-Show_NC8_Orig_FC").checked = contenu.getAttribute("Show_NC8_Orig_FC")=="true";
		document.getElementById("opvt-Show_NC8_Orig_PF").checked = contenu.getAttribute("Show_NC8_Orig_PF")=="true";
		document.getElementById("opvt-Show_Intitule_Cde_FC").checked = contenu.getAttribute("Show_Intitule_Cde_FC")=="true";
		document.getElementById("opvt-Show_Reserve_Propriete").checked = contenu.getAttribute("Show_Reserve_Propriete")=="true";
		document.getElementById("opvt-Show_Mention_Acquit").checked = contenu.getAttribute("Show_Mention_Acquit")=="true";
		document.getElementById("opvt-GAC_Detail_Grp_FC").checked = contenu.getAttribute("GAC_Detail_Grp_FC")=="true";
		document.getElementById("opvt-Coeff_Interet_Retard").value = contenu.getAttribute("Coeff_Interet_Retard");
		document.getElementById("opvt-PAcompte_CC").value = contenu.getAttribute("PAcompte_CC");
		document.getElementById("opvt-Imp_Ex_Fact_Ent").checked = contenu.getAttribute("Imp_Ex_Fact_Ent")=="true";
		document.getElementById("opvt-Edition_X3_FC").checked = contenu.getAttribute("Edition_X3_FC")=="true";
		document.getElementById("opvt-Frais_Port_Prem").value = contenu.getAttribute("Frais_Port_Prem")=="true"?"1":"0";
		document.getElementById("opvt-Mode_Cloture_Fact").value = contenu.getAttribute("Mode_Cloture_Fact");
		document.getElementById("opvt-Jour_Cloture_Fact").value = contenu.getAttribute("Jour_Cloture_Fact");
		document.getElementById("opvt-Marge_CC_LDF").checked = contenu.getAttribute("Marge_CC_LDF")=="true";
		document.getElementById("opvt-Marge_CC_CFD").checked = contenu.getAttribute("Marge_CC_CFD")=="true";
		document.getElementById("opvt-GAC_Maj_Prix_Client").checked = contenu.getAttribute("GAC_Maj_Prix_Client")=="true";
		document.getElementById("opvt-GAC_Cout_Trans").checked = contenu.getAttribute("GAC_Cout_Trans")=="true";
		document.getElementById("opvt-Type_Marge_DC").value = contenu.getAttribute("Type_Marge_DC");
		document.getElementById("opvt-Type_Marge_CC").value = contenu.getAttribute("Type_Marge_CC");
		document.getElementById("opvt-Type_Marge_FC").value = contenu.getAttribute("Type_Marge_FC");
		document.getElementById("opvt-CCW_Marge_Paiement").value = contenu.getAttribute("CCW_Marge_Paiement");
		document.getElementById("opvt-Marge_Paiement_CC").value = contenu.getAttribute("Marge_Paiement_CC");
		document.getElementById("opvt-fichierCGV").value = contenu.getAttribute("Fichier_CGV");
		document.getElementById("opvt-Field_Column_DV_1").value = contenu.getAttribute("Field_Column_DV_1");
		document.getElementById("opvt-Field_Column_DV_2").value = contenu.getAttribute("Field_Column_DV_2");
		document.getElementById("opvt-GAC_Rech_Market_Place").checked = contenu.getAttribute("GAC_Rech_Market_Place")=="true";
		document.getElementById("opvt-GAC_Statut_Archive").checked = contenu.getAttribute("GAC_Statut_Archive")=="true";
		document.getElementById("opvt-GAC_Creneau_Livraison").checked = contenu.getAttribute("GAC_Creneau_Livraison")=="true";
		document.getElementById("opvt-GAC_Resp_LF_CF").checked = contenu.getAttribute("GAC_Resp_LF_CF")=="true";
		document.getElementById("opvt-GAC_Date_Exp_Liv_LF_CF").checked = contenu.getAttribute("GAC_Date_Exp_Liv_LF_CF")=="true";
		document.getElementById("opvt-GAC_Def_Regle_Expedition").value = contenu.getAttribute("GAC_Def_Regle_Expedition");
		document.getElementById("opvt-Aut_Deduction_FC").checked = contenu.getAttribute("Aut_Deduction_FC")=="true";
		document.getElementById("opvt-Histo_Avant_Valid_CC").checked = contenu.getAttribute("Histo_Avant_Valid_CC")=="true";
		document.getElementById("opvt-Histo_Avant_Valid_DC").checked = contenu.getAttribute("Histo_Avant_Valid_DC")=="true";
		document.getElementById("opvt-Email_Auto_HL_Only").checked = contenu.getAttribute("Email_Auto_HL_Only")=="true";
		document.getElementById("opvt-Type_Relance_1").value = contenu.getAttribute("Type_Relance_1");
		document.getElementById("opvt-Type_Relance_2").value = contenu.getAttribute("Type_Relance_2");
		document.getElementById("opvt-Type_Relance_3").value = contenu.getAttribute("Type_Relance_3");
		document.getElementById("opvt-Delai_Relance_1").value = contenu.getAttribute("Delai_Relance_1");
		document.getElementById("opvt-Delai_Relance_2").value = contenu.getAttribute("Delai_Relance_2");
		document.getElementById("opvt-Delai_Relance_3").value = contenu.getAttribute("Delai_Relance_3");
		document.getElementById("opvt-GAC_Gen_OF_Rupture").checked = contenu.getAttribute("GAC_Gen_OF_Rupture")=="true";
		document.getElementById("opvt-GAC_Lancer_OF").checked = contenu.getAttribute("GAC_Lancer_OF")=="true";
		document.getElementById("opvt-GDC_Refresh_On_Copy").checked = contenu.getAttribute("GDC_Refresh_On_Copy")=="true";
		document.getElementById("opvt-GDC_Refresh_On_Copy_Type").checked = contenu.getAttribute("GDC_Refresh_On_Copy_Type")=="true";
		document.getElementById("opvt-GAC_Alerte_Doublon_Ligne").checked = contenu.getAttribute("GAC_Alerte_Doublon_Ligne")=="true";
		document.getElementById("opvt-GAC_Prop_Substitution").checked = contenu.getAttribute("GAC_Prop_Substitution")=="true";
		document.getElementById("opvt-Tarif_Vente_1").value = contenu.getAttribute("Tarif_Vente_1");
		document.getElementById("opvt-Tarif_Vente_2").value = contenu.getAttribute("Tarif_Vente_2");
		document.getElementById("opvt-Tarif_Vente_3").value = contenu.getAttribute("Tarif_Vente_3");
		document.getElementById("opvt-Tarif_Vente_4").value = contenu.getAttribute("Tarif_Vente_4");
		document.getElementById("opvt-Tarif_Vente_5").value = contenu.getAttribute("Tarif_Vente_5");
		document.getElementById("opvt-Show_Option_Debits_FC").checked = contenu.getAttribute("Show_Option_Debits_FC")=="true";
		document.getElementById("opvt-Show_Nature_Oper_FC").checked = contenu.getAttribute("Show_Nature_Oper_FC")=="true";
		document.getElementById("opvt-Show_Siren_FC").checked = contenu.getAttribute("Show_Siren_FC")=="true";
		document.getElementById("opvt-GAC_Remain_After_Val_CC").checked = contenu.getAttribute("GAC_Remain_After_Val_CC")=="true";
		document.getElementById("opvt-Attach_BL_Email_ECC").checked = contenu.getAttribute("Attach_BL_Email_ECC")=="true";
		document.getElementById("opvt-GAC_Com_Pub").checked = contenu.getAttribute("GAC_Com_Pub")=="true";
		document.getElementById("opvt-GAC_Cloture_Conf").checked = contenu.getAttribute("GAC_Cloture_Conf")=="true";
		document.getElementById("opvt-GAC_Aff_Avoir_CC").checked = contenu.getAttribute("GAC_Aff_Avoir_CC")=="true";
		document.getElementById("opvt-GFC_Def_Etat_Rech").value = contenu.getAttribute("GFC_Def_Etat_Rech");
		document.getElementById("opvt-GDC_Resp_Createur").checked = contenu.getAttribute("GDC_Resp_Createur")=="true";
		document.getElementById("opvt-Restocking_Prio_Recep").checked = contenu.getAttribute("Restocking_Prio_Recep")=="true";
		document.getElementById("opvt-Message_SMS_RCC").value = contenu.getAttribute("Message_SMS_RCC");
		document.getElementById("opvt-Config_SMS_RCC").value = contenu.getAttribute("Config_SMS_RCC");
		document.getElementById("opvt-Ret_Comp_SMS_RCC").checked = contenu.getAttribute("Ret_Comp_SMS_RCC")=="true";

		opvt_chargerDepots(contenu.getAttribute("GAC_Def_Filtre_Depot"));

		opvt_pressOnModeFacturation();
		opvt_pressOnModeClotureFact();
		opvt_pressOnGACDropPossibleAuto();
		opvt_pressOnGACGenOFRupture();
		opvt_pressOnColPhotoDC();

		document.getElementById("opvt-bEnregistrer").disabled = false;

		opvt_setModified(false);

	} catch (e) {
    recup_erreur(e);
  }
}


function opvt_updatePreferences() {
	try {

		var venteTTC = document.getElementById("opvt-Vente_TTC").checked;
		var taxationTVALiv = document.getElementById("opvt-Taxation_TVA_Liv").checked;
		var colPUNet = document.getElementById("opvt-Col_PU_Net").checked;
		var showMentionCGV = document.getElementById("opvt-Show_Mention_CGV").checked;
		var alerteEncoursClient = document.getElementById("opvt-Alerte_Encours_Client").checked;
		var encoursCliMutualise = document.getElementById("opvt-Encours_Cli_Mutualise").checked;
		var colPhotoDC = document.getElementById("opvt-Col_Photo_DC").checked;
		var showPhotoXLDC = document.getElementById("opvt-Show_Photo_XL_DC").checked;
		var modeTraitement = document.getElementById("opvt-Mode_Traitement").value;
		var defEtatRechCom = document.getElementById("opvt-Def_Etat_Rech_Com").value;
		var defEtatRechLog = document.getElementById("opvt-Def_Etat_Rech_Log").value;
		var gacEtatPaiement = document.getElementById("opvt-GAC_Etat_Paiement").value;
		var gacProvenance = document.getElementById("opvt-GAC_Provenance").value;
		var gacDefFiltreEtab = document.getElementById("opvt-GAC_Def_Filtre_Etab").value;
		var gacAffAutoFactAvoir = document.getElementById("opvt-GAC_Aff_Auto_Fact_Avoir").checked;
		var gacProposerRbt = document.getElementById("opvt-GAC_Proposer_Rbt").checked;
		var gacPropRbtAnnul = document.getElementById("opvt-GAC_Prop_Rbt_Annul").checked;
		var gacDropPossibleAuto = document.getElementById("opvt-GAC_Drop_Possible_Auto").checked;
		var gacDropAutoPartiel = document.getElementById("opvt-GAC_Drop_Auto_Partiel").checked;
		var gacNoStockFourDPA = document.getElementById("opvt-GAC_No_Stock_Four_DPA").checked;
		var gacMontantMinDPA = document.getElementById("opvt-GAC_Montant_Min_DPA").value;
		var gacAutNonFacturable = document.getElementById("opvt-GAC_Aut_Non_Facturable").checked;
		var calculStock = document.getElementById("opvt-Calcul_Stock").checked;
		var typeCalculStock = document.getElementById("opvt-Type_Calcul_Stock").checked;
		var csDateExpedition = document.getElementById("opvt-CS_Date_Expedition").checked;
		var showIntituleDC = document.getElementById("opvt-Show_Intitule_DC").checked;
		var showModeExpeditionDC = document.getElementById("opvt-Show_Mode_Expedition_DC").checked;
		var showSousTotauxDC = document.getElementById("opvt-Show_Sous_Totaux_DC").checked;
		var showModalitesDC = document.getElementById("opvt-Show_Modalites_DC").checked;
		var showIntituleCdeCC = document.getElementById("opvt-Show_Intitule_Cde_CC").checked;
		var impRIBCC = document.getElementById("opvt-Imp_RIB_CC").value;
		var impRIBDC = document.getElementById("opvt-Imp_RIB_DC").value;
		var emailVCC = document.getElementById("opvt-Email_VCC").value;
		var emailACC = document.getElementById("opvt-Email_ACC").value;
		var emailECC = document.getElementById("opvt-Email_ECC").value;
		var emailPCC = document.getElementById("opvt-Email_PCC").value;
		var emailRCC = document.getElementById("opvt-Email_RCC").value;
		var emailVFC = document.getElementById("opvt-Email_VFC").value;
		var emailVAC = document.getElementById("opvt-Email_VAC").value;
		var emailRRC = document.getElementById("opvt-Email_RRC").value;
		var emailERF = document.getElementById("opvt-Email_ERF").value;
		var emailERC1 = document.getElementById("opvt-Email_ERC_1").value;
		var emailERC2 = document.getElementById("opvt-Email_ERC_2").value;
		var emailERC3 = document.getElementById("opvt-Email_ERC_3").value;
		var emailVRP = document.getElementById("opvt-Email_VRP").value;
		var emailVBL = document.getElementById("opvt-Email_VBL").value;
		var attachLCEmailECC = document.getElementById("opvt-Attach_LC_Email_ECC").checked;
		var copyCECEmailVFC = document.getElementById("opvt-Copy_CEC_Email_VFC").checked;
		var modeTarif = document.getElementById("opvt-Mode_Tarif").value;
		var comDevis = document.getElementById("opvt-Com_Devis").value;
		var comFact = document.getElementById("opvt-Com_Fact").value;
		var infosPiedFacture = document.getElementById("opvt-Infos_Pied_Facture").value;
		var defModeFacturation = document.getElementById("opvt-Def_Mode_Facturation").value;
		var defFactAvantLiv = document.getElementById("opvt-Def_Fact_Avant_Liv").checked;
		var defPeriodeFacturation = document.getElementById("opvt-Def_Periode_Facturation").value;
		var defModeEnvoiFacture = document.getElementById("opvt-Def_Mode_Envoi_Facture").value;
		var moduleEnvoi = document.getElementById("opvt-Module_Envoi").checked;
		var impLCR = document.getElementById("opvt-Imp_LCR").checked;
		var impRIBFC = document.getElementById("opvt-Imp_RIB_FC").value;
		var optTBFacture = document.getElementById("opvt-Opt_TB_Facture").checked;
		var showNC8OrigFC = document.getElementById("opvt-Show_NC8_Orig_FC").checked;
		var showNC8OrigPF = document.getElementById("opvt-Show_NC8_Orig_PF").checked;
		var showIntituleCdeFC = document.getElementById("opvt-Show_Intitule_Cde_FC").checked;
		var showReservePropriete = document.getElementById("opvt-Show_Reserve_Propriete").checked;
		var showMentionAcquit = document.getElementById("opvt-Show_Mention_Acquit").checked;
		var gacDetailGrpFC = document.getElementById("opvt-GAC_Detail_Grp_FC").checked;
		var coeffInteretRetard = document.getElementById("opvt-Coeff_Interet_Retard").value;
		var pAcompteCC = document.getElementById("opvt-PAcompte_CC").value;
		var impExFactEnt = document.getElementById("opvt-Imp_Ex_Fact_Ent").checked;
		var editionX3FC = document.getElementById("opvt-Edition_X3_FC").checked;
		var fraisPortPrem = document.getElementById("opvt-Frais_Port_Prem").value=="1";
		var modeClotureFact = document.getElementById("opvt-Mode_Cloture_Fact").value;
		var jourClotureFact = document.getElementById("opvt-Jour_Cloture_Fact").value;
		var margeCCLDF = document.getElementById("opvt-Marge_CC_LDF").checked;
		var margeCCCFD = document.getElementById("opvt-Marge_CC_CFD").checked;
		var gacMajPrixClient = document.getElementById("opvt-GAC_Maj_Prix_Client").checked;
		var specMPOCT = document.getElementById("opvt-GAC_Cout_Trans").checked;
		var typeMargeDC = document.getElementById("opvt-Type_Marge_DC").value;
		var typeMargeCC = document.getElementById("opvt-Type_Marge_CC").value;
		var typeMargeFC = document.getElementById("opvt-Type_Marge_FC").value;
		var ccwMargePaiement = document.getElementById("opvt-CCW_Marge_Paiement").value;
		var margePaiementCC = document.getElementById("opvt-Marge_Paiement_CC").value;
		var fieldColumnDV1 = document.getElementById("opvt-Field_Column_DV_1").value;
		var fieldColumnDV2 = document.getElementById("opvt-Field_Column_DV_2").value;
		var gacRechMarketPlace = document.getElementById("opvt-GAC_Rech_Market_Place").checked;
		var gacStatutArchive = document.getElementById("opvt-GAC_Statut_Archive").checked;
		var gacCreneauLivraison = document.getElementById("opvt-GAC_Creneau_Livraison").checked;
		var gacRespLFCF = document.getElementById("opvt-GAC_Resp_LF_CF").checked;
		var gacDateExpLivLFCF = document.getElementById("opvt-GAC_Date_Exp_Liv_LF_CF").checked;
		var gacDefRegleExpedition = document.getElementById("opvt-GAC_Def_Regle_Expedition").value;
		var autDeductionFC = document.getElementById("opvt-Aut_Deduction_FC").checked;
		var histoAvantValidCC = document.getElementById("opvt-Histo_Avant_Valid_CC").checked;
		var histoAvantValidDC = document.getElementById("opvt-Histo_Avant_Valid_DC").checked;
		var emailAutoHLOnly = document.getElementById("opvt-Email_Auto_HL_Only").checked;
		var typeRelance1 = document.getElementById("opvt-Type_Relance_1").value;
		var typeRelance2 = document.getElementById("opvt-Type_Relance_2").value;
		var typeRelance3 = document.getElementById("opvt-Type_Relance_3").value;
		var delaiRelance1 = document.getElementById("opvt-Delai_Relance_1").value;
		var delaiRelance2 = document.getElementById("opvt-Delai_Relance_2").value;
		var delaiRelance3 = document.getElementById("opvt-Delai_Relance_3").value;
		var gacGenOFRupture = document.getElementById("opvt-GAC_Gen_OF_Rupture").checked;
		var gacLancerOF = document.getElementById("opvt-GAC_Lancer_OF").checked;
		var gdcRefreshOnCopy = document.getElementById("opvt-GDC_Refresh_On_Copy").checked;
		var gdcRefreshOnCopyType = document.getElementById("opvt-GDC_Refresh_On_Copy_Type").checked;
		var gacAlerteDoublonLigne = document.getElementById("opvt-GAC_Alerte_Doublon_Ligne").checked;
		var gacPropSubstitution = document.getElementById("opvt-GAC_Prop_Substitution").checked;
		var tarifVente1 = document.getElementById("opvt-Tarif_Vente_1").value;
		var tarifVente2 = document.getElementById("opvt-Tarif_Vente_2").value;
		var tarifVente3 = document.getElementById("opvt-Tarif_Vente_3").value;
		var tarifVente4 = document.getElementById("opvt-Tarif_Vente_4").value;
		var tarifVente5 = document.getElementById("opvt-Tarif_Vente_5").value;
		var showOptionDebitsFC = document.getElementById("opvt-Show_Option_Debits_FC").checked;
		var showNatureOperFC = document.getElementById("opvt-Show_Nature_Oper_FC").checked;
		var showSirenFC = document.getElementById("opvt-Show_Siren_FC").checked;
		var gacRemainAfterValCC = document.getElementById("opvt-GAC_Remain_After_Val_CC").checked;
		var attachBLEmailECC = document.getElementById("opvt-Attach_BL_Email_ECC").checked;
		var gacComPub = document.getElementById("opvt-GAC_Com_Pub").checked;
		var gacClotureConf = document.getElementById("opvt-GAC_Cloture_Conf").checked;
		var gacAffAvoirCC = document.getElementById("opvt-GAC_Aff_Avoir_CC").checked;
		var gfcDefEtatRech = document.getElementById("opvt-GFC_Def_Etat_Rech").value;
		var gdcRespCreateur = document.getElementById("opvt-GDC_Resp_Createur").checked;
		var restockingPrioRecep = document.getElementById("opvt-Restocking_Prio_Recep").checked;
		var messageSMSRCC = document.getElementById("opvt-Message_SMS_RCC").value;
		var configSMSRCC = document.getElementById("opvt-Config_SMS_RCC").value;
		var retCompSMSRCC = document.getElementById("opvt-Ret_Comp_SMS_RCC").checked;
		var gacDefFiltreDepot = document.getElementById("opvt-GAC_Def_Filtre_Depot").value;

		if (defModeFacturation=="B" && defFactAvantLiv) {
			showWarning("Le mode de facturation par bon de livraison et l'option facturable avant livraison sont incompatibles");
		}
		else if (isEmpty(coeffInteretRetard) || !isPositive(coeffInteretRetard)) {
			showWarning("Coefficient multiplicateur du taux l\u00E9gal d'int\u00E9r\u00EAt de retard incorrect");
		}
		else if (isEmpty(pAcompteCC) || !isTaux(pAcompteCC)) {
			showWarning("Pourcentage d'acompte par d\u00E9faut incorrect");
		}
		else if (!isPositiveInteger(ccwMargePaiement)) {
			showWarning("Marge de paiement pour les commandes web incorrecte");
		}
		else if (!isPositiveInteger(jourClotureFact) || parseIntBis(jourClotureFact)>31) {
			showWarning("Jour de cl\u00F4ture de facturation maximum incorrect (1 \u00E0 31)");
		}
		else if (!isPositiveOrNull(gacMontantMinDPA)) {
			showWarning("Montant minimum de commande pour le dropshipping automatique incorrect");
		}
		else if (!isPositiveInteger(delaiRelance1)) {
			showWarning("D\u00E9lai avant 1\u00E8re relance incorrect");
		}
		else if (!isPositiveInteger(delaiRelance2)) {
			showWarning("D\u00E9lai avant 2\u00E8me relance incorrect");
		}
		else if (!isPositiveInteger(delaiRelance3)) {
			showWarning("D\u00E9lai avant 3\u00E8me relance incorrect");
		}
		else if ((!isEmpty(tarifVente1) && (tarifVente1==tarifVente2 || tarifVente1==tarifVente3 || tarifVente1==tarifVente4 || tarifVente1==tarifVente5))
					|| (!isEmpty(tarifVente2) && (tarifVente2==tarifVente3 || tarifVente2==tarifVente4 || tarifVente2==tarifVente5))
					|| (!isEmpty(tarifVente3) && (tarifVente3==tarifVente4 || tarifVente3==tarifVente5))
					|| (!isEmpty(tarifVente4) && (tarifVente4==tarifVente5))) {
			showWarning("Il ne doit pas y avoir de tarifs identiques s\u00E9lectionn\u00E9s dans les tarifs principaux");
		}
		else if ((isEmpty(tarifVente1) && !isEmpty(tarifVente2)) || (isEmpty(tarifVente2) && !isEmpty(tarifVente3)) || (isEmpty(tarifVente3) && !isEmpty(tarifVente4))
					 || (isEmpty(tarifVente4) && !isEmpty(tarifVente5))) {
			showWarning("Il ne doit pas y avoir de trous dans les tarifs principaux");
		}
		else {
			var qUpdate = new QueryHttp("Config/gc/ventes/updatePreferencesVente.tmpl");

			qUpdate.setParam("Vente_TTC", venteTTC);
			qUpdate.setParam("Taxation_TVA_Liv", taxationTVALiv);
			qUpdate.setParam("Col_PU_Net", colPUNet);
			qUpdate.setParam("Show_Mention_CGV", showMentionCGV);
			qUpdate.setParam("Alerte_Encours_Client", alerteEncoursClient);
			qUpdate.setParam("Encours_Cli_Mutualise", encoursCliMutualise);
			qUpdate.setParam("Col_Photo_DC", colPhotoDC);
			qUpdate.setParam("Show_Photo_XL_DC", showPhotoXLDC);
			qUpdate.setParam("Mode_Traitement", modeTraitement);
			qUpdate.setParam("Def_Etat_Rech_Com", defEtatRechCom);
			qUpdate.setParam("Def_Etat_Rech_Log", defEtatRechLog);
			qUpdate.setParam("GAC_Etat_Paiement", gacEtatPaiement);
			qUpdate.setParam("GAC_Provenance", gacProvenance);
			qUpdate.setParam("GAC_Def_Filtre_Etab", gacDefFiltreEtab);
			qUpdate.setParam("GAC_Aff_Auto_Fact_Avoir", gacAffAutoFactAvoir);
			qUpdate.setParam("GAC_Proposer_Rbt", gacProposerRbt);
			qUpdate.setParam("GAC_Prop_Rbt_Annul", gacPropRbtAnnul);
			qUpdate.setParam("GAC_Drop_Possible_Auto", gacDropPossibleAuto);
			qUpdate.setParam("GAC_Drop_Auto_Partiel", gacDropAutoPartiel);
			qUpdate.setParam("GAC_No_Stock_Four_DPA", gacNoStockFourDPA);
			qUpdate.setParam("GAC_Montant_Min_DPA", gacMontantMinDPA);
			qUpdate.setParam("GAC_Aut_Non_Facturable", gacAutNonFacturable);
			qUpdate.setParam("Calcul_Stock", calculStock);
			qUpdate.setParam("Type_Calcul_Stock", typeCalculStock);
			qUpdate.setParam("CS_Date_Expedition", csDateExpedition);
			qUpdate.setParam("Show_Intitule_DC", showIntituleDC);
			qUpdate.setParam("Show_Mode_Expedition_DC", showModeExpeditionDC);
			qUpdate.setParam("Show_Sous_Totaux_DC", showSousTotauxDC);
			qUpdate.setParam("Show_Modalites_DC", showModalitesDC);
			qUpdate.setParam("Show_Intitule_Cde_CC", showIntituleCdeCC);
			qUpdate.setParam("Imp_RIB_CC", impRIBCC);
			qUpdate.setParam("Imp_RIB_DC", impRIBDC);
			qUpdate.setParam("Email_VCC", emailVCC);
			qUpdate.setParam("Email_ACC", emailACC);
			qUpdate.setParam("Email_ECC", emailECC);
			qUpdate.setParam("Email_PCC", emailPCC);
			qUpdate.setParam("Email_RCC", emailRCC);
			qUpdate.setParam("Email_VFC", emailVFC);
			qUpdate.setParam("Email_VAC", emailVAC);
			qUpdate.setParam("Email_RRC", emailRRC);
			qUpdate.setParam("Email_ERF", emailERF);
			qUpdate.setParam("Email_ERC_1", emailERC1);
			qUpdate.setParam("Email_ERC_2", emailERC2);
			qUpdate.setParam("Email_ERC_3", emailERC3);
			qUpdate.setParam("Email_VRP", emailVRP);
			qUpdate.setParam("Email_VBL", emailVBL);
			qUpdate.setParam("Attach_LC_Email_ECC", attachLCEmailECC);
			qUpdate.setParam("Copy_CEC_Email_VFC", copyCECEmailVFC);
			qUpdate.setParam("Mode_Tarif", modeTarif);
			qUpdate.setParam("Com_Devis", comDevis);
			qUpdate.setParam("Com_Fact", comFact);
			qUpdate.setParam("Infos_Pied_Facture", infosPiedFacture);
			qUpdate.setParam("Def_Mode_Facturation", defModeFacturation);
			qUpdate.setParam("Def_Fact_Avant_Liv", defFactAvantLiv);
			qUpdate.setParam("Def_Periode_Facturation", defPeriodeFacturation);
			qUpdate.setParam("Def_Mode_Envoi_Facture", defModeEnvoiFacture);
			qUpdate.setParam("Module_Envoi", moduleEnvoi);
			qUpdate.setParam("Imp_LCR", impLCR);
			qUpdate.setParam("Imp_RIB_FC", impRIBFC);
			qUpdate.setParam("Opt_TB_Facture", optTBFacture);
			qUpdate.setParam("Show_NC8_Orig_FC", showNC8OrigFC);
			qUpdate.setParam("Show_NC8_Orig_PF", showNC8OrigPF);
			qUpdate.setParam("Show_Intitule_Cde_FC", showIntituleCdeFC);
			qUpdate.setParam("Show_Reserve_Propriete", showReservePropriete);
			qUpdate.setParam("Show_Mention_Acquit", showMentionAcquit);
			qUpdate.setParam("GAC_Detail_Grp_FC", gacDetailGrpFC);
			qUpdate.setParam("Coeff_Interet_Retard", coeffInteretRetard);
			qUpdate.setParam("PAcompte_CC", pAcompteCC);
			qUpdate.setParam("Imp_Ex_Fact_Ent", impExFactEnt);
			qUpdate.setParam("Edition_X3_FC", editionX3FC);
			qUpdate.setParam("Frais_Port_Prem", fraisPortPrem);
			qUpdate.setParam("Mode_Cloture_Fact", modeClotureFact);
			qUpdate.setParam("Jour_Cloture_Fact", jourClotureFact);
			qUpdate.setParam("Marge_CC_LDF", margeCCLDF);
			qUpdate.setParam("Marge_CC_CFD", margeCCCFD);
			qUpdate.setParam("GAC_Maj_Prix_Client", gacMajPrixClient);
			qUpdate.setParam("GAC_Cout_Trans", specMPOCT);
			qUpdate.setParam("Type_Marge_DC", typeMargeDC);
			qUpdate.setParam("Type_Marge_CC", typeMargeCC);
			qUpdate.setParam("Type_Marge_FC", typeMargeFC);
			qUpdate.setParam("CCW_Marge_Paiement", ccwMargePaiement);
			qUpdate.setParam("Marge_Paiement_CC", margePaiementCC);
			qUpdate.setParam("Field_Column_DV_1", fieldColumnDV1);
			qUpdate.setParam("Field_Column_DV_2", fieldColumnDV2);
			qUpdate.setParam("GAC_Rech_Market_Place", gacRechMarketPlace);
			qUpdate.setParam("GAC_Statut_Archive", gacStatutArchive);
			qUpdate.setParam("GAC_Creneau_Livraison", gacCreneauLivraison);
			qUpdate.setParam("GAC_Resp_LF_CF", gacRespLFCF);
			qUpdate.setParam("GAC_Date_Exp_Liv_LF_CF", gacDateExpLivLFCF);
			qUpdate.setParam("GAC_Def_Regle_Expedition", gacDefRegleExpedition);
			qUpdate.setParam("Aut_Deduction_FC", autDeductionFC);
			qUpdate.setParam("Histo_Avant_Valid_CC", histoAvantValidCC);
			qUpdate.setParam("Histo_Avant_Valid_DC", histoAvantValidDC);
			qUpdate.setParam("Email_Auto_HL_Only", emailAutoHLOnly);
			qUpdate.setParam("Type_Relance_1", typeRelance1);
			qUpdate.setParam("Type_Relance_2", typeRelance2);
			qUpdate.setParam("Type_Relance_3", typeRelance3);
			qUpdate.setParam("Delai_Relance_1", delaiRelance1);
			qUpdate.setParam("Delai_Relance_2", delaiRelance2);
			qUpdate.setParam("Delai_Relance_3", delaiRelance3);
			qUpdate.setParam("GAC_Gen_OF_Rupture", gacGenOFRupture);
			qUpdate.setParam("GAC_Lancer_OF", gacLancerOF);
			qUpdate.setParam("GDC_Refresh_On_Copy", gdcRefreshOnCopy);
			qUpdate.setParam("GDC_Refresh_On_Copy_Type", gdcRefreshOnCopyType);
			qUpdate.setParam("GAC_Alerte_Doublon_Ligne", gacAlerteDoublonLigne);
			qUpdate.setParam("GAC_Prop_Substitution", gacPropSubstitution);
			qUpdate.setParam("Tarif_Vente_1", tarifVente1);
			qUpdate.setParam("Tarif_Vente_2", tarifVente2);
			qUpdate.setParam("Tarif_Vente_3", tarifVente3);
			qUpdate.setParam("Tarif_Vente_4", tarifVente4);
			qUpdate.setParam("Tarif_Vente_5", tarifVente5);
			qUpdate.setParam("Show_Option_Debits_FC", showOptionDebitsFC);
			qUpdate.setParam("Show_Nature_Oper_FC", showNatureOperFC);
			qUpdate.setParam("Show_Siren_FC", showSirenFC);
			qUpdate.setParam("GAC_Remain_After_Val_CC", gacRemainAfterValCC);
			qUpdate.setParam("Attach_BL_Email_ECC", attachBLEmailECC);
			qUpdate.setParam("GAC_Com_Pub", gacComPub);
			qUpdate.setParam("GAC_Cloture_Conf", gacClotureConf);
			qUpdate.setParam("GAC_Aff_Avoir_CC", gacAffAvoirCC);
			qUpdate.setParam("GFC_Def_Etat_Rech", gfcDefEtatRech);
			qUpdate.setParam("GDC_Resp_Createur", gdcRespCreateur);
			qUpdate.setParam("Restocking_Prio_Recep", restockingPrioRecep);
			qUpdate.setParam("Message_SMS_RCC", messageSMSRCC);
			qUpdate.setParam("Config_SMS_RCC", configSMSRCC);
			qUpdate.setParam("Ret_Comp_SMS_RCC", retCompSMSRCC);
			qUpdate.setParam("GAC_Def_Filtre_Depot", gacDefFiltreDepot);

			var result = qUpdate.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				opvt_setModified(false);
				showMessage("Pr\u00E9f\u00E9rences de vente sauvegard\u00E9es");
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function opvt_pressOnModeFacturation() {
	try {

		var modeFacturation = document.getElementById('opvt-Def_Mode_Facturation').value;
		if (modeFacturation=="B") {
			document.getElementById('opvt-Def_Fact_Avant_Liv').checked = false;
		}
		document.getElementById('opvt-Def_Fact_Avant_Liv').disabled = (modeFacturation=="B");

	} catch (e) {
		recup_erreur(e);
	}
}


function opvt_pressOnModeClotureFact() {
	try {

		document.getElementById('opvt-boxJourClotureFact').collapsed = document.getElementById('opvt-Mode_Cloture_Fact').value!="S";

	} catch (e) {
		recup_erreur(e);
	}
}


function opvt_pressOnGACDropPossibleAuto() {
	try {

		var gacDropPossibleAuto = document.getElementById('opvt-GAC_Drop_Possible_Auto').checked;

		document.getElementById('opvt-boxGACMontantMinDPA').collapsed = !gacDropPossibleAuto;
		document.getElementById('opvt-GAC_Drop_Auto_Partiel').collapsed = !gacDropPossibleAuto;
		document.getElementById('opvt-GAC_No_Stock_Four_DPA').collapsed = !gacDropPossibleAuto;

	} catch (e) {
		recup_erreur(e);
	}
}


function opvt_pressOnGACGenOFRupture() {
	try {

		document.getElementById("opvt-GAC_Lancer_OF").disabled = !document.getElementById("opvt-GAC_Gen_OF_Rupture").checked;

	} catch (e) {
		recup_erreur(e);
	}
}


function opvt_pressOnColPhotoDC() {
	try {

		document.getElementById("opvt-Show_Photo_XL_DC").disabled = !document.getElementById("opvt-Col_Photo_DC").checked;

	} catch (e) {
		recup_erreur(e);
	}
}


function opvt_setModified(modified) {
	try {

		opvt_modified = modified;
		document.getElementById('opvt-imgModified').collapsed = !modified;

	} catch (e) {
		recup_erreur(e);
	}
}


function opvt_changerCGV() {
  try {

		var url = "chrome://opensi/content/config/gc/ventes/popup-changerCGV.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', opvt_retourChangerCGV);

	} catch (e) {
    recup_erreur(e);
  }
}


function opvt_retourChangerCGV(fichierCGV) {
	try {

		document.getElementById('opvt-fichierCGV').value = fichierCGV;

	} catch (e) {
    recup_erreur(e);
  }
}


function opvt_supprimerCGV() {
  try {

		if (window.confirm("Confirmez-vous la suppression du fichier des CGV ?")) {
			var qSup = new QueryHttp("Config/gc/ventes/deleteCGV.tmpl");
			qSup.execute();

			document.getElementById('opvt-fichierCGV').value = "";
		}

	} catch (e) {
    recup_erreur(e);
  }
}
