/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var otva_currentChampCompte;

var otva_aTauxNat = new Arbre('Config/globale/list-tauxTVA.tmpl', 'otva-listTauxNat');
var otva_currentCodeTVANat = "";

var otva_aTauxUE = new Arbre('Config/globale/list-tauxTVA.tmpl', 'otva-listTauxUE');
var otva_currentCodeTVAUE = "";

var otva_aVentilNatUE = new Arbre('Config/globale/list-ventilTVANationalUE.tmpl', 'otva-listVentilNatUE');
var otva_currentVentilId = "";

var otva_aTauxInter = new Arbre('Config/globale/list-tauxTVAInternational.tmpl', 'otva-listTauxInter');
var otva_currentCodeTVAInter = "";



function otva_init() {
	try {

		otva_aTauxUE.setParam("Zone_UE", true);

		otva_filtrerTauxNat();
		otva_filtrerTauxUE();
		otva_aTauxInter.initTree();
		otva_aVentilNatUE.initTree();

		var aPays = new Arbre("ComboListe/combo-pays.tmpl", 'otva-pays_UE');
		aPays.setParam("Only_UE", true);
		aPays.initTree();

	} catch (e) {
    recup_erreur(e);
  }
}



// TAUX NATIONAUX


function otva_filtrerTauxNat() {
	try {

		otva_aTauxNat.setParam("Actif", document.getElementById("otva-filtreActifNat").checked);
		otva_aTauxNat.initTree();

	} catch (e) {
    recup_erreur(e);
  }
}


function otva_resetTauxNat() {
  try {

		otva_nouveauTauxNat();
		otva_aTauxNat.initTree();
		otva_aVentilNatUE.initTree();

	} catch (e) {
    recup_erreur(e);
  }
}


function otva_nouveauTauxNat() {
  try {

		otva_currentCodeTVANat = "";
  	otva_aTauxNat.clearSelection();

		document.getElementById('otva-tauxTVA_Nat').value = "";
		document.getElementById('otva-compteTVAAchat_Nat').value = "";
		document.getElementById('otva-compteTVAVente_Nat').value = "";
		document.getElementById('otva-compteAchat_Nat').value = "";
		document.getElementById('otva-compteVente_Nat').value = "";
		document.getElementById('otva-comptePortAchat_Nat').value = "";
		document.getElementById('otva-comptePortVente_Nat').value = "";
		document.getElementById('otva-Actif_Nat').checked = true;
		document.getElementById('otva-Actif_Nat').disabled = false;
		document.getElementById('otva-rowTauxTVA_Nat').collapsed = false;
		document.getElementById('otva-rowCompteTVAAchats_Nat').collapsed = false;
		document.getElementById('otva-rowCompteTVAVentes_Nat').collapsed = false;
		document.getElementById('otva-bSupprimer_Nat').collapsed = true;
		document.getElementById('otva-bNouveau_Nat').collapsed = true;
		document.getElementById('otva-tauxTVA_Nat').focus();

	} catch (e) {
    recup_erreur(e);
  }
}


function otva_reporterTauxNat() {
  try {

		if (otva_aTauxNat.isSelected()) {
			var tauxTVA = otva_aTauxNat.getSelectedCellText('otva-colTauxTVA_Nat');
			document.getElementById('otva-tauxTVA_Nat').value = tauxTVA;
			var tauxExonere = parseFloat(tauxTVA)==0;
			otva_currentCodeTVANat = otva_aTauxNat.getSelectedCellText('otva-colCodeTVA_Nat');
			var tauxNormal = otva_aTauxNat.getSelectedCellText('otva-colNormal_Nat')=="true";
			document.getElementById('otva-Actif_Nat').checked = (otva_aTauxNat.getSelectedCellText('otva-colActif_Nat')=="true");
			document.getElementById('otva-Actif_Nat').disabled = (tauxNormal || tauxExonere);

			document.getElementById('otva-compteTVAAchat_Nat').value = otva_aTauxNat.getSelectedCellText('otva-colCompteTVAAchat_Nat');
			document.getElementById('otva-compteTVAVente_Nat').value = otva_aTauxNat.getSelectedCellText('otva-colCompteTVAVente_Nat');
			document.getElementById('otva-compteAchat_Nat').value = otva_aTauxNat.getSelectedCellText('otva-colCompteAchat_Nat');
			document.getElementById('otva-compteVente_Nat').value = otva_aTauxNat.getSelectedCellText('otva-colCompteVente_Nat');
			document.getElementById('otva-comptePortAchat_Nat').value = otva_aTauxNat.getSelectedCellText('otva-colComptePortAchat_Nat');
			document.getElementById('otva-comptePortVente_Nat').value = otva_aTauxNat.getSelectedCellText('otva-colComptePortVente_Nat');

			document.getElementById('otva-rowTauxTVA_Nat').collapsed = tauxExonere;
			document.getElementById('otva-rowCompteTVAAchats_Nat').collapsed = tauxExonere;
			document.getElementById('otva-rowCompteTVAVentes_Nat').collapsed = tauxExonere;

			document.getElementById('otva-bSupprimer_Nat').collapsed = false;
			document.getElementById('otva-bNouveau_Nat').collapsed = false;
			document.getElementById('otva-bSupprimer_Nat').disabled = (tauxNormal || tauxExonere);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function otva_supprimerTauxNat() {
	try {

		if (otva_aTauxNat.isSelected()) {

			var tauxTVA = otva_aTauxNat.getSelectedCellText('otva-colTauxTVA_Nat');

			if (window.confirm("Confirmez-vous la suppression du taux de TVA de "+ tauxTVA +" % ?")) {

				var qDelete = new QueryHttp("Config/globale/deleteTauxTVA.tmpl");
				qDelete.setParam('Code_TVA', otva_currentCodeTVANat);
				var result = qDelete.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					otva_resetTauxNat();
				}
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function otva_enregistrerTauxNat() {
	try {

		var tauxTVA = document.getElementById('otva-tauxTVA_Nat').value;
		var compteTVAAchat = document.getElementById('otva-compteTVAAchat_Nat').value;
		var compteTVAVente = document.getElementById('otva-compteTVAVente_Nat').value;
		var compteAchat = document.getElementById('otva-compteAchat_Nat').value;
		var compteVente = document.getElementById('otva-compteVente_Nat').value;
		var comptePortAchat = document.getElementById('otva-comptePortAchat_Nat').value;
		var comptePortVente = document.getElementById('otva-comptePortVente_Nat').value;
		var actif = document.getElementById('otva-Actif_Nat').checked;

		if (isEmpty(tauxTVA) || !isTaux(tauxTVA) || parseFloat(tauxTVA)>=100) {
			showWarning("Taux de TVA incorrect");
		}
		else if (parseFloat(tauxTVA)>0 && isEmpty(compteTVAAchat)) {
			showWarning("Veuillez indiquer un compte de TVA sur achat");
		}
		else if (parseFloat(tauxTVA)>0 && isEmpty(compteTVAVente)) {
			showWarning("Veuillez indiquer un compte de TVA sur vente");
		}
		else if (isEmpty(compteAchat)) {
			showWarning("Veuillez indiquer un compte d'achat");
		}
		else if (isEmpty(compteVente)) {
			showWarning("Veuillez indiquer un compte de vente");
		}
		else if (isEmpty(comptePortAchat)) {
			showWarning("Veuillez indiquer un compte de port sur achat");
		}
		else if (isEmpty(comptePortVente)) {
			showWarning("Veuillez indiquer un compte de port sur vente");
		}
		else {
			var ok = false;
			var qSave;

			if (isEmpty(otva_currentCodeTVANat)) {
				qSave = new QueryHttp("Config/globale/createTauxTVA.tmpl");
				qSave.setParam('Code_Pays', "FR");
				ok = true;
			}
			else {
				qSave = new QueryHttp("Config/globale/saveTauxTVA.tmpl");
				qSave.setParam('Code_TVA', otva_currentCodeTVANat);

				if (otva_aTauxNat.isSelected()) {
					var oldTauxTVA = otva_aTauxNat.getSelectedCellText("otva-colTauxTVA_Nat");
					ok = parseFloat(tauxTVA)==parseFloat(oldTauxTVA) || window.confirm("Confirmez-vous le changement du taux de TVA de "+ oldTauxTVA +"% \u00E0 "+ tauxTVA +"% ?");
				}
			}

			if (ok) {
				qSave.setParam('Taux_TVA', tauxTVA);
				qSave.setParam('Compte_TVA_Achat', compteTVAAchat);
				qSave.setParam('Compte_TVA_Vente', compteTVAVente);
				qSave.setParam('Compte_Achat', compteAchat);
				qSave.setParam('Compte_Vente', compteVente);
				qSave.setParam('Compte_Port_Achat', comptePortAchat);
				qSave.setParam('Compte_Port_Vente', comptePortVente);
				qSave.setParam('Actif', actif);

				var result = qSave.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					otva_resetTauxNat();
				}
			}
  	}

	} catch (e) {
    recup_erreur(e);
  }
}


function otva_affecterTauxNat() {
	try {

		var url = "chrome://opensi/content/config/globale/popup-affectCpteNational.xul";
    window.openDialog(url,'','chrome,modal,centerscreen');

		otva_resetTauxNat();

	} catch (e) {
    recup_erreur(e);
  }
}



// TAUX UNION EUROPEENNE


function otva_filtrerTauxUE() {
	try {

		otva_aTauxUE.setParam("Actif", document.getElementById("otva-filtreActifUE").checked);
		otva_aTauxUE.initTree();

	} catch (e) {
    recup_erreur(e);
  }
}


function otva_resetTauxUE() {
  try {

		otva_nouveauTauxUE();
		otva_aTauxUE.initTree();

	} catch (e) {
    recup_erreur(e);
  }
}


function otva_nouveauTauxUE() {
  try {

		otva_currentCodeTVAUE = "";
  	otva_aTauxUE.clearSelection();

		document.getElementById('otva-pays_UE').selectedIndex = 0;
		document.getElementById('otva-pays_UE').disabled = false;
		document.getElementById('otva-tauxTVA_UE').value = "";
		document.getElementById('otva-compteTVAVente_UE').value = "";
		document.getElementById('otva-compteTVAAchat_UE').value = "";
		document.getElementById('otva-compteAchat_UE').value = "";
		document.getElementById('otva-compteVente_UE').value = "";
		document.getElementById('otva-comptePortAchat_UE').value = "";
		document.getElementById('otva-comptePortVente_UE').value = "";
		document.getElementById('otva-Actif_UE').checked = true;
		document.getElementById('otva-Actif_UE').disabled = false;
		document.getElementById('otva-bSupprimer_UE').collapsed = true;
		document.getElementById('otva-bNouveau_UE').collapsed = true;
		document.getElementById('otva-rowTauxTVA_UE').collapsed = false;
		document.getElementById('otva-rowCompteTVAVentes_UE').collapsed = false;
		document.getElementById('otva-rowCompteTVAAchats_UE').collapsed = false;
  	document.getElementById('otva-tauxTVA_UE').focus();

	} catch (e) {
    recup_erreur(e);
  }
}


function otva_reporterTauxUE() {
  try {

		if (otva_aTauxUE.isSelected()) {
			var tauxTVA = otva_aTauxUE.getSelectedCellText('otva-colTauxTVA_UE');
    	document.getElementById('otva-tauxTVA_UE').value = tauxTVA;
			otva_currentCodeTVAUE = otva_aTauxUE.getSelectedCellText('otva-colCodeTVA_UE');
			var tauxNormal = otva_aTauxUE.getSelectedCellText('otva-colNormal_UE')=="true";
			var tauxExonere = parseFloat(tauxTVA)==0;

			document.getElementById('otva-Actif_UE').checked = (otva_aTauxUE.getSelectedCellText('otva-colActif_UE')=="true");
			document.getElementById('otva-Actif_UE').disabled = (tauxNormal || tauxExonere);

			document.getElementById('otva-pays_UE').value = otva_aTauxUE.getSelectedCellText('otva-colCodePays_UE');
			document.getElementById('otva-compteTVAVente_UE').value = otva_aTauxUE.getSelectedCellText('otva-colCompteTVAVente_UE');
			document.getElementById('otva-compteTVAAchat_UE').value = otva_aTauxUE.getSelectedCellText('otva-colCompteTVAAchat_UE');
			document.getElementById('otva-compteAchat_UE').value = otva_aTauxUE.getSelectedCellText('otva-colCompteAchat_UE');
			document.getElementById('otva-compteVente_UE').value = otva_aTauxUE.getSelectedCellText('otva-colCompteVente_UE');
			document.getElementById('otva-comptePortAchat_UE').value = otva_aTauxUE.getSelectedCellText('otva-colComptePortAchat_UE');
			document.getElementById('otva-comptePortVente_UE').value = otva_aTauxUE.getSelectedCellText('otva-colComptePortVente_UE');
			document.getElementById('otva-pays_UE').disabled = true;

			document.getElementById('otva-bSupprimer_UE').collapsed = false;
			document.getElementById('otva-bNouveau_UE').collapsed = false;
			document.getElementById('otva-bSupprimer_UE').disabled = (tauxNormal || tauxExonere);
			document.getElementById('otva-rowTauxTVA_UE').collapsed = tauxExonere;
			document.getElementById('otva-rowCompteTVAVentes_UE').collapsed = tauxExonere;
			document.getElementById('otva-rowCompteTVAAchats_UE').collapsed = tauxExonere;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function otva_supprimerTauxUE() {
	try {

		if (otva_aTauxUE.isSelected()) {
			var tauxTVA = otva_aTauxUE.getSelectedCellText('otva-colTauxTVA_UE');

			if (window.confirm("Confirmez-vous la suppression du taux de TVA de "+ tauxTVA +" % ?")) {

				var qDelete = new QueryHttp("Config/globale/deleteTauxTVA.tmpl");
				qDelete.setParam('Code_TVA', otva_currentCodeTVAUE);
				var result = qDelete.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					otva_resetTauxUE();
				}
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function otva_enregistrerTauxUE() {
	try {

		var tauxTVA = document.getElementById('otva-tauxTVA_UE').value;
		var compteTVAVente = document.getElementById('otva-compteTVAVente_UE').value;
		var compteTVAAchat = document.getElementById('otva-compteTVAAchat_UE').value;
		var compteAchat = document.getElementById('otva-compteAchat_UE').value;
		var compteVente = document.getElementById('otva-compteVente_UE').value;
		var comptePortAchat = document.getElementById('otva-comptePortAchat_UE').value;
		var comptePortVente = document.getElementById('otva-comptePortVente_UE').value;
		var actif = document.getElementById('otva-Actif_UE').checked;
		var codePays = document.getElementById('otva-pays_UE').value;

		if (isEmpty(codePays)) {
			showWarning("Veuillez choisir un pays");
		}
		else if (isEmpty(tauxTVA) || !isTaux(tauxTVA) || parseFloat(tauxTVA)>=100) {
			showWarning("Taux de TVA incorrect");
		}
		else if (parseFloat(tauxTVA)!=0 && isEmpty(compteTVAAchat)) {
			showWarning("Veuillez indiquer un compte de TVA sur achat");
		}
		else if (parseFloat(tauxTVA)!=0 && isEmpty(compteTVAVente)) {
			showWarning("Veuillez indiquer un compte de TVA sur vente");
		}
		else if (isEmpty(compteAchat)) {
			showWarning("Veuillez indiquer un compte d'achat");
		}
		else if (isEmpty(compteVente)) {
			showWarning("Veuillez indiquer un compte de vente");
		}
		else if (isEmpty(comptePortAchat)) {
			showWarning("Veuillez indiquer un compte de port sur achat");
		}
		else if (isEmpty(comptePortVente)) {
			showWarning("Veuillez indiquer un compte de port sur vente");
		}
		else {
			var ok = false;
			var qSave;

			if (isEmpty(otva_currentCodeTVAUE)) {
				qSave = new QueryHttp("Config/globale/createTauxTVA.tmpl");
				qSave.setParam('Code_Pays', codePays);
				ok = true;
			}
			else {
				qSave = new QueryHttp("Config/globale/saveTauxTVA.tmpl");
				qSave.setParam('Code_TVA', otva_currentCodeTVAUE);

				if (otva_aTauxUE.isSelected()) {
					var oldTauxTVA = otva_aTauxUE.getSelectedCellText("otva-colTauxTVA_UE");
					ok = parseFloat(tauxTVA)==parseFloat(oldTauxTVA) || window.confirm("Confirmez-vous le changement du taux de TVA de "+ oldTauxTVA +"% \u00E0 "+ tauxTVA +"% ?");
				}
			}

			if (ok) {
				qSave.setParam('Taux_TVA', tauxTVA);
				qSave.setParam('Compte_TVA_Vente', compteTVAVente);
				qSave.setParam('Compte_TVA_Achat', compteTVAAchat);
				qSave.setParam('Compte_Achat', compteAchat);
				qSave.setParam('Compte_Vente', compteVente);
				qSave.setParam('Compte_Port_Achat', comptePortAchat);
				qSave.setParam('Compte_Port_Vente', comptePortVente);
				qSave.setParam('Actif', actif);

				var result = qSave.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					otva_resetTauxUE();
				}
			}
  	}

	} catch (e) {
    recup_erreur(e);
  }
}


function otva_affecterTauxUE() {
	try {

		var url = "chrome://opensi/content/config/globale/popup-affectCpteUE.xul";
    window.openDialog(url,'','chrome,modal,centerscreen');

		otva_resetTauxUE();

	} catch (e) {
    recup_erreur(e);
  }
}



// TAUX NATIONAUX POUR L'UE


function otva_resetNatUE() {
  try {

		otva_currentVentilId = "";
		otva_aVentilNatUE.clearSelection();

		document.getElementById('otva-pays_Nat_UE').value = "";
		document.getElementById('otva-compteVente_Nat_UE').value = "";
		document.getElementById('otva-comptePortVente_Nat_UE').value = "";

		otva_aVentilNatUE.initTree();

	} catch (e) {
    recup_erreur(e);
  }
}


function otva_reporterNatUE() {
  try {

		if (otva_aVentilNatUE.isSelected()) {
			otva_currentVentilId = otva_aVentilNatUE.getSelectedCellText('otva-colVentilId_Nat_UE');
			document.getElementById('otva-pays_Nat_UE').value = otva_aVentilNatUE.getSelectedCellText('otva-colPays_Nat_UE');
			document.getElementById('otva-compteVente_Nat_UE').value = otva_aVentilNatUE.getSelectedCellText('otva-colCompteVente_Nat_UE');
			document.getElementById('otva-comptePortVente_Nat_UE').value = otva_aVentilNatUE.getSelectedCellText('otva-colComptePortVente_Nat_UE');
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function otva_enregistrerNatUE() {
	try {

		var compteVente = document.getElementById('otva-compteVente_Nat_UE').value;
		var comptePortVente = document.getElementById('otva-comptePortVente_Nat_UE').value;

		if (isEmpty(otva_currentVentilId)) {
			showWarning("Veuillez s\u00E9lectionner un pays");
		}
		else if (isEmpty(compteVente)) {
			showWarning("Veuillez d\u00E9finir un compte de vente");
		}
		else if (isEmpty(comptePortVente)) {
			showWarning("Veuillez d\u00E9finir un compte de port sur vente");
		}
		else {
			var qUpdate = new QueryHttp("Config/globale/updateVentilTVANationalUE.tmpl");

			qUpdate.setParam('Ventil_Id', otva_currentVentilId);
			qUpdate.setParam('Compte_Vente', compteVente);
			qUpdate.setParam('Compte_Port_Vente', comptePortVente);

			var result = qUpdate.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				otva_resetNatUE();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function otva_affecterNatUE() {
	try {

		var url = "chrome://opensi/content/config/globale/popup-affectCpteNatUE.xul";
    window.openDialog(url,'','chrome,modal,centerscreen');

		otva_resetNatUE();

	} catch (e) {
    recup_erreur(e);
  }
}



// TAUX INTERNATIONAUX


function otva_resetInter() {
  try {

		otva_currentCodeTVAInter = "";
		otva_aTauxInter.clearSelection();

		document.getElementById('otva-pays_Inter').value = "";
		document.getElementById('otva-compteAchat_Inter').value = "";
		document.getElementById('otva-compteVente_Inter').value = "";
		document.getElementById('otva-comptePortAchat_Inter').value = "";
		document.getElementById('otva-comptePortVente_Inter').value = "";

		otva_aTauxInter.initTree();

	} catch (e) {
    recup_erreur(e);
  }
}


function otva_reporterInter() {
  try {

		if (otva_aTauxInter.isSelected()) {
			otva_currentCodeTVAInter = otva_aTauxInter.getSelectedCellText('otva-colCodeTVA_Inter');
			document.getElementById('otva-pays_Inter').value = otva_aTauxInter.getSelectedCellText('otva-colPays_Inter');
			document.getElementById('otva-compteAchat_Inter').value = otva_aTauxInter.getSelectedCellText('otva-colCompteAchat_Inter');
			document.getElementById('otva-compteVente_Inter').value = otva_aTauxInter.getSelectedCellText('otva-colCompteVente_Inter');
			document.getElementById('otva-comptePortAchat_Inter').value = otva_aTauxInter.getSelectedCellText('otva-colComptePortAchat_Inter');
			document.getElementById('otva-comptePortVente_Inter').value = otva_aTauxInter.getSelectedCellText('otva-colComptePortVente_Inter');
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function otva_enregistrerInter() {
	try {

		var compteAchat = document.getElementById('otva-compteAchat_Inter').value;
		var compteVente = document.getElementById('otva-compteVente_Inter').value;
		var comptePortAchat = document.getElementById('otva-comptePortAchat_Inter').value;
		var comptePortVente = document.getElementById('otva-comptePortVente_Inter').value;

		if (isEmpty(otva_currentCodeTVAInter)) {
			showWarning("Veuillez s\u00E9lectionner un pays");
		}
		else if (isEmpty(compteAchat)) {
			showWarning("Veuillez d\u00E9finir un compte d'achat");
		}
		else if (isEmpty(compteVente)) {
			showWarning("Veuillez d\u00E9finir un compte de vente");
		}
		else if (isEmpty(comptePortAchat)) {
			showWarning("Veuillez d\u00E9finir un compte de port sur achat");
		}
		else if (isEmpty(comptePortVente)) {
			showWarning("Veuillez d\u00E9finir un compte de port sur vente");
		}
		else {
			var qUpdate = new QueryHttp("Config/globale/updateTauxTVAInternational.tmpl");

			qUpdate.setParam('Code_TVA', otva_currentCodeTVAInter);
			qUpdate.setParam('Compte_Achat', compteAchat);
			qUpdate.setParam('Compte_Vente', compteVente);
			qUpdate.setParam('Compte_Port_Achat', comptePortAchat);
			qUpdate.setParam('Compte_Port_Vente', comptePortVente);

			var result = qUpdate.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				otva_resetInter();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function otva_affecterInter() {
	try {

		var url = "chrome://opensi/content/config/globale/popup-affectCpteInternational.xul";
    window.openDialog(url,'','chrome,modal,centerscreen');

		otva_resetInter();

	} catch (e) {
    recup_erreur(e);
  }
}



// COMMUN


function otva_changerCompte(id, debCompte, titre) {
  try {

  	otva_currentChampCompte = id;
    var url = "chrome://opensi/content/compta/user/comptes/popup-rechercheCompte.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', otva_retourChangerCompte, debCompte, "G", titre, debCompte, false);

  } catch (e) {
    recup_erreur(e);
  }
}


function otva_retourChangerCompte(numCompte, compteId) {
	try {

		document.getElementById(otva_currentChampCompte).value = numCompte;

	} catch (e) {
		recup_erreur(e);
	}
}
