/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var omem_aModelesEmail = new Arbre('Config/globale/list-modeleEmail.tmpl', 'omem-tree-modelesEmail');
var omem_modeleId = "";


function omem_init() {
	try {

		omem_aModelesEmail.initTree();
		var aTypeDoc = new Arbre('ComboListe/combo-typeDocument.tmpl', 'omem-Type_Document');
		aTypeDoc.initTree(omem_nouveauModele);

	} catch (e) {
    recup_erreur(e);
  }
}


function omem_nouveauModele() {
	try {

		omem_aModelesEmail.clearSelection();
		document.getElementById('omem-bNouveauModele').collapsed = true;
		document.getElementById('omem-bSupprimerModele').collapsed = true;
		document.getElementById('omem-Message').value = "";
		document.getElementById('omem-Intitule').value = "";
		document.getElementById('omem-Type_Document').value = "";
		omem_modeleId = "";

	} catch (e) {
    recup_erreur(e);
  }
}


function omem_chargerModele() {
	try {

		if (omem_aModelesEmail.isSelected()) {
			document.getElementById('omem-bNouveauModele').collapsed = false;
			document.getElementById('omem-bSupprimerModele').collapsed = false;
			document.getElementById('omem-Message').value = omem_aModelesEmail.getSelectedCellText('omem-ColMessage');
			document.getElementById('omem-Intitule').value = omem_aModelesEmail.getSelectedCellText('omem-ColIntitule');
			document.getElementById('omem-Type_Document').value = omem_aModelesEmail.getSelectedCellText('omem-ColTypeDocument');

			omem_modeleId = omem_aModelesEmail.getSelectedCellText('omem-ColModeleId');
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function omem_enregistrerModele() {
	try {

		var intitule = document.getElementById('omem-Intitule').value;
		var message = document.getElementById('omem-Message').value;
		var typeDocument = document.getElementById('omem-Type_Document').value;

		if (isEmpty(intitule)) { showWarning("Intitul\u00E9 incorrect"); }
		else if (isEmpty(message)) { showWarning("Message incorrect"); }
		else {
			var qEnregistrer;
			if (omem_modeleId=="") {
				qEnregistrer = new QueryHttp("Config/globale/createModeleEmail.tmpl");
			}
			else {
				qEnregistrer = new QueryHttp("Config/globale/updateModeleEmail.tmpl");
				qEnregistrer.setParam("Modele_Id", omem_modeleId);
			}
			qEnregistrer.setParam('Intitule', intitule);
			qEnregistrer.setParam('Message', message);
			qEnregistrer.setParam('Type_Document', typeDocument);
			var result = qEnregistrer.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				omem_aModelesEmail.initTree(omem_nouveauModele);
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function omem_supprimerModele() {
	try {

		if (window.confirm("Confirmez-vous la suppression du mod\u00E8le s\u00E9lectionn\u00E9 ?")) {

			var querySup = new QueryHttp("Config/globale/deleteModeleEmail.tmpl");
			querySup.setParam("Modele_Id", omem_modeleId);
			var result = querySup.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				omem_aModelesEmail.initTree(omem_nouveauModele);
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}
