/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var ofsaPays = new Arbre("ComboListe/combo-pays.tmpl", "ofs-listePays");
var ofsaType = new Arbre("ComboListe/combo-typesProspect.tmpl", "ofs-listeType");
var ofsaResp = new Arbre("ComboListe/combo-responsables.tmpl", "ofs-listeResponsable");
var ofs_aPolesActivite = new Arbre("ComboListe/combo-polesActivite.tmpl", "ofs-pole-activite");
var ofsaCivilites = new Arbre("ComboListe/combo-civilites.tmpl", "ofs-civ");
var isClient = false;
var ofs_selPoleActivite;


function ofs_pressOnSupprimer() {
	try {

		if (window.confirm("Voulez-vous supprimer ce compte ?")) {
			ofsSupprimer();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofsSupprimer() {
	try {

		var qDeleteProspect=new QueryHttp("CRM/GestionComptes/deleteProspect.tmpl");
		qDeleteProspect.setParam("Client_Id", globalClientId);
		var result = qDeleteProspect.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			initialiser("N");
			document.getElementById('ofc-tabContact').disabled = true;
			document.getElementById('ofc-tabEvenement').disabled = true;
		}

	} catch(e) {
		recup_erreur(e);
	}
}


function ofs_selTypeClient(t) {
  try {

		switch(t) {
			case 'P':	document.getElementById('bcParticulier').collapsed = true;
								document.getElementById('rowFormeJuridique').collapsed = true;
								break;
			case 'E':	document.getElementById('bcParticulier').collapsed = false;
								document.getElementById('rowFormeJuridique').collapsed = false;
								break;
			case 'O': document.getElementById('bcParticulier').collapsed = false;
								document.getElementById('rowFormeJuridique').collapsed = true;
								break;
			case 'A': document.getElementById('bcParticulier').collapsed = false;
								document.getElementById('rowFormeJuridique').collapsed = true;
								break;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function ofs_chargerPolesActivite(selection) {
	try {

		ofs_selPoleActivite = selection;
		ofs_aPolesActivite.setParam("Selection", ofs_selPoleActivite);
		ofs_aPolesActivite.initTree(ofs_initPoleActivite);

	} catch (e) {
		recup_erreur(e);
	}
}


function ofs_initPoleActivite() {
  try {

		document.getElementById('ofs-pole-activite').value = ofs_selPoleActivite;

	} catch (e) {
  	recup_erreur(e);
	}
}


function ofsEnregistrer(quit) {
	try {

		var nbEmployes = document.getElementById("ofs-nbr-employes").value;
		var chiffreAffaire = document.getElementById("ofs-CA").value;

		var auth = false;
		if (document.getElementById("ofs-typeClient").value!="P" && document.getElementById("ofs-denomination").value == "") {
			document.getElementById("ofc-onglets").selectedIndex=0;
			showWarning("D\u00E9nomination incorrecte");
		}
		else if (document.getElementById("ofs-typeClient").value=="P" && document.getElementById("ofs-nom").value == "") {
			document.getElementById("ofc-onglets").selectedIndex=0;
			showWarning("Nom incorrect");
		}
		else {
			if (document.getElementById("ofs-adresse1").value == "") {
				document.getElementById("ofc-onglets").selectedIndex=0;
				showWarning("Adresse incorrecte");
			} else {
				if (document.getElementById("ofs-ville").value==""){
					document.getElementById("ofc-onglets").selectedIndex=0;
					showWarning("Ville incorrecte");
				} else {
					if (document.getElementById("ofs-listeResponsable").value==""){
						document.getElementById("ofc-onglets").selectedIndex=0;
						showWarning("Selectionnez un responsable");
					} else {
						if (!isPhone(document.getElementById("ofs-tel1").value)&&document.getElementById("ofs-tel1").value!=""){
							document.getElementById("ofc-onglets").selectedIndex=0;
							showWarning("T\u00E9l\u00E9phone incorrect");
						} else {
							if (!isEmail(document.getElementById("ofs-email1").value)&&document.getElementById("ofs-email1").value!=""){
								document.getElementById("ofc-onglets").selectedIndex=0;
								showWarning("Email incorrect");
							} else {
								if (!isPhone(document.getElementById("ofs-fax1").value)&&document.getElementById("ofs-fax1").value!=""){
									document.getElementById("ofc-onglets").selectedIndex=0;
									showWarning("Fax incorrect");
								} else {
									auth = true;
								}
							}
						}
					}
				}
			}
		}

		if (auth) {
			if (!isPositiveOrNullInteger(chiffreAffaire) && chiffreAffaire!="" ){
				auth=false;
				document.getElementById("ofc-onglets").selectedIndex=0;
				showWarning("Erreur dans le formatage du chiffre d'affaires , entrez un montant entier positif ou nul.");
			} else {
				if (!isPositiveOrNullInteger(nbEmployes) && nbEmployes!="" ){
					auth=false;
					document.getElementById("ofc-onglets").selectedIndex=0;
					showWarning("Erreur dans le formatage du nombre d'employ\u00E9s , entrez un montant entier positif ou nul.");
				}
			}
		}

		// si tout les points de contrles ont t passs
		if (auth) {

			if (isEmpty(chiffreAffaire)) chiffreAffaire = 0;
			if (isEmpty(nbEmployes)) nbEmployes = 0;

			var qSave = new QueryHttp("CRM/GestionComptes/saveProspect.tmpl");
			qSave.setParam("utilR", document.getElementById("ofs-listeResponsable").value);
			qSave.setParam("Chiffre_Affaire", chiffreAffaire);
			qSave.setParam("Nb_Employes", nbEmployes);
			qSave.setParam("Commentaires", document.getElementById("ofs-comLibre").value);
			qSave.setParam("Tel_1", document.getElementById("ofs-tel1").value);
			qSave.setParam("Tel_2", document.getElementById("ofs-tel2").value);
			qSave.setParam("Tel_3", document.getElementById("ofs-tel3").value);
			qSave.setParam("Fax_1", document.getElementById("ofs-fax1").value);
			qSave.setParam("Fax_2", document.getElementById("ofs-fax2").value);
			qSave.setParam("Email_1", document.getElementById("ofs-email1").value);
			qSave.setParam("Email_2", document.getElementById("ofs-email2").value);
			qSave.setParam("Site_Web", document.getElementById("ofs-siteWeb").value);
			qSave.setParam("Type", document.getElementById("ofs-listeType").value);
			qSave.setParam("Denomination", document.getElementById("ofs-denomination").value);
			qSave.setParam("Adresse_1", document.getElementById("ofs-adresse1").value);
			qSave.setParam("Adresse_2", document.getElementById("ofs-adresse2").value);
			qSave.setParam("Adresse_3", document.getElementById("ofs-adresse3").value);
			qSave.setParam("Code_Postal", document.getElementById("ofs-codePostal").value);
			qSave.setParam("Ville", document.getElementById("ofs-ville").value);
			qSave.setParam("Code_Pays", document.getElementById("ofs-listePays").value);
			qSave.setParam("Projet", document.getElementById("ofs-projet").checked);
			qSave.setParam("Client_Id", globalClientId);
			qSave.setParam("Pole", document.getElementById("ofs-pole-activite").value);
			qSave.setParam("Actif", document.getElementById("ofs-actif").checked);
			qSave.setParam("Civilite", document.getElementById("ofs-civ").value);
			qSave.setParam("Nom", document.getElementById("ofs-nom").value);
			qSave.setParam("Prenom", document.getElementById("ofs-prenom").value);
			qSave.setParam("Num_SIRET", document.getElementById("ofs-numSIRET").value);
			qSave.setParam("Code_NAF", document.getElementById("ofs-codeNAF").value);
			qSave.setParam("Num_TVA_Intra", document.getElementById("ofs-numTVA").value);
			qSave.setParam("Type_Client", document.getElementById("ofs-typeClient").value);
			qSave.setParam("Forme_Juridique", document.getElementById("ofs-formeJuridique").value);

			var reponse = qSave.execute();
			globalClientId = reponse.responseXML.documentElement.getAttribute("Client_Id");
			document.getElementById("bofs-transferer").disabled = (isClient==true);
			document.getElementById("bofs-Supprimer").collapsed = false;

			initialiser("");
			document.getElementById('ofc-tabContact').disabled = false;
			document.getElementById('ofc-tabEvenement').disabled = false;
			setModifSignaletique(false);
			if (quit=="liste") {
				quitAndReturnListeCompte();
			}
			else if (quit=="menu") {
				quitAndReturnMainMenu();
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function initofsaResp() {
	try {

		document.getElementById("ofs-listeResponsable").value = gProfil.getLoggedUser();
		setModifSignaletique(false);

	} catch (e) {
		recup_erreur(e);
	}
}


function ofs_initCivilite() {
	try {

		document.getElementById('ofs-civ').selectedIndex = 0;
		setModifSignaletique(false);

	} catch(e) {
		recup_erreur(e);
	}
}


function initialiser(type) {
	try {

		document.getElementById("bMenuComptes").collapsed = false;
		document.getElementById("ofs-listeResponsable").disabled = !gProfil.isDirection();
		ofsNouveauContact();

		if (type=="N") {
			globalClientId = "";
			ofsaResp.initTree(initofsaResp);
			ofs_chargerPolesActivite("");

			document.getElementById("Creation").setAttribute("label", "");
			document.getElementById("Modification").setAttribute("label", "");
			document.getElementById("Fiche").setAttribute("label", "");

			document.getElementById("ofs-denomination").value = "";
			document.getElementById("ofs-adresse1").value = "";
			document.getElementById("ofs-adresse2").value = "";
			document.getElementById("ofs-adresse3").value = "";
			document.getElementById("ofs-codePostal").value = "";
			document.getElementById("ofs-ville").value = "";
			document.getElementById("ofs-listePays").value = "FR";
			document.getElementById("ofs-tel1").value = "";
			document.getElementById("ofs-tel2").value = "";
			document.getElementById("ofs-tel3").value = "";
			document.getElementById("ofs-fax1").value = "";
			document.getElementById("ofs-fax2").value = "";
			document.getElementById("ofs-email1").value = "";
			document.getElementById("ofs-email2").value = "";
			document.getElementById("ofs-siteWeb").value = "";
			document.getElementById("ofs-nbr-employes").value = "";
			document.getElementById("ofs-CA").value = "";
			document.getElementById("ofs-comLibre").value = "";
			document.getElementById("ofs-listeType").value = "";
			document.getElementById("ofs-numClient").value = "";
			document.getElementById("bofs-transferer").disabled = true;
			document.getElementById("bofs-Supprimer").collapsed = true;
			document.getElementById("ofs-rowNumClient").collapsed = true;
			document.getElementById("ofs-projet").checked = true;
			document.getElementById('ofs-civ').value = "0";
			document.getElementById("ofs-nom").value = "";
			document.getElementById("ofs-prenom").value = "";
			document.getElementById("ofs-numSIRET").value = "";
			document.getElementById("ofs-numTVA").value = "";
			document.getElementById("ofs-codeNAF").value = "";
			document.getElementById("ofs-typeClient").value = "E";
			document.getElementById("ofs-formeJuridique").value = "";
			ofs_selTypeClient("E");
			isClient = false;
			setModifSignaletique(false);
		}
		else {
			initContact();
			initFicheTaches();

			var qGetInfos = new QueryHttp("CRM/GestionComptes/loadProspect.tmpl");
			qGetInfos.setParam("Client_Id", globalClientId);
			var result = qGetInfos.execute();
			var dateCreation = result.responseXML.documentElement.getAttribute("Date_C");
			var dateModification = result.responseXML.documentElement.getAttribute("Date_M");
			var utilC = result.responseXML.documentElement.getAttribute("loginUtil_C");
			var utilM = result.responseXML.documentElement.getAttribute("loginUtil_M");

			document.getElementById("Creation").label = "Compte cr\u00E9\u00E9 le "+dateCreation+" par "+utilC;
			document.getElementById("Modification").label = "Derni\u00E8re modification le "+dateModification+" par "+utilM;

			var denomination = document.getElementById("ofs-denomination").value;
			if (!isEmpty(denomination)) {
				document.getElementById("Fiche").setAttribute("label", "Compte "+ denomination);
			}

			document.getElementById("ofs-adresse1").value = result.responseXML.documentElement.getAttribute("Adresse_1");
			document.getElementById("ofs-adresse2").value = result.responseXML.documentElement.getAttribute("Adresse_2");
			document.getElementById("ofs-adresse3").value = result.responseXML.documentElement.getAttribute("Adresse_3");
			document.getElementById("ofs-codePostal").value = result.responseXML.documentElement.getAttribute("Code_Postal");
			document.getElementById("ofs-ville").value = result.responseXML.documentElement.getAttribute("Ville");
			document.getElementById("ofs-listePays").value = result.responseXML.documentElement.getAttribute("Code_Pays");
			document.getElementById("ofs-tel1").value = result.responseXML.documentElement.getAttribute("Tel_1");
			document.getElementById("ofs-tel2").value = result.responseXML.documentElement.getAttribute("Tel_2");
			document.getElementById("ofs-tel3").value = result.responseXML.documentElement.getAttribute("Tel_3");
			document.getElementById("ofs-fax1").value = result.responseXML.documentElement.getAttribute("Fax_1");
			document.getElementById("ofs-fax2").value = result.responseXML.documentElement.getAttribute("Fax_2");
			document.getElementById("ofs-siteWeb").value = result.responseXML.documentElement.getAttribute("Site_Web");
			document.getElementById("ofs-email1").value = result.responseXML.documentElement.getAttribute("Email_1");
			document.getElementById("ofs-email2").value = result.responseXML.documentElement.getAttribute("Email_2");
			document.getElementById("ofs-nbr-employes").value = result.responseXML.documentElement.getAttribute("Nb_Employes");
			document.getElementById("ofs-CA").value = result.responseXML.documentElement.getAttribute("Chiffre_Affaire");
			document.getElementById("ofs-projet").checked = result.responseXML.documentElement.getAttribute("Projet")=="true";
			document.getElementById("ofs-listeResponsable").value = result.responseXML.documentElement.getAttribute("Util_R");
			document.getElementById("ofs-listeType").value = result.responseXML.documentElement.getAttribute("Type");
			document.getElementById("ofs-comLibre").value = result.responseXML.documentElement.getAttribute("Commentaires");
			ofs_chargerPolesActivite(result.responseXML.documentElement.getAttribute("Pole"));
			document.getElementById("ofs-actif").checked = result.responseXML.documentElement.getAttribute("Actif")=="true";
			document.getElementById("ofs-civ").value = result.responseXML.documentElement.getAttribute("Civilite");
			document.getElementById("ofs-nom").value = result.responseXML.documentElement.getAttribute("Nom");
			document.getElementById("ofs-prenom").value = result.responseXML.documentElement.getAttribute("Prenom");
			document.getElementById("ofs-numSIRET").value = result.responseXML.documentElement.getAttribute("Num_SIRET");
			document.getElementById("ofs-numTVA").value = result.responseXML.documentElement.getAttribute("Num_TVA_Intra");
			document.getElementById("ofs-codeNAF").value = result.responseXML.documentElement.getAttribute("Code_NAF");
			document.getElementById("ofs-typeClient").value = result.responseXML.documentElement.getAttribute("Type_Client");
			document.getElementById("ofs-formeJuridique").value = result.responseXML.documentElement.getAttribute("Forme_Juridique");

			document.getElementById("bofs-Supprimer").collapsed = false;

			var numClient = result.responseXML.documentElement.getAttribute("Num_Client");
			isClient = (numClient!="");
			if (!isClient) {
				document.getElementById("bofs-transferer").disabled = false;
				document.getElementById("ofs-rowNumClient").collapsed = true;
			}
			else {
				document.getElementById("bofs-transferer").disabled = true;
				document.getElementById("ofs-rowNumClient").collapsed = false;
				document.getElementById("ofs-numClient").value = numClient;
			}

			setModifSignaletique(false);
		}

  } catch (e) {
		recup_erreur(e);
	}
}


function setModifSignaletique(m) {
	try {

		modifSignaletique = m;

		if (m) {
			document.getElementById('ofc-tabSignaletique').setAttribute('image', 'chrome://opensi/content/design/icones/modified.png');
		}
		else {
			document.getElementById('ofc-tabSignaletique').setAttribute('image', null);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofsTransferer() {
	try {

		if (modifSignaletique) {
			showWarning("Veuillez enregistrer les modifications apport\u00E9es");
		}
		else {
			var numerotationAuto = !isEmpty(gConfig.getFormatNC());
			if (numerotationAuto) {
				transfererClientId(document.getElementById("ofs-numClient").value);
			}
			else {
				var url = "chrome://opensi/content/crm/gestion_compte/popup-choixNumClient.xul";
		   	window.openDialog(url,'','chrome,modal,centerscreen', transfererClientId);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function transfererClientId(numClient) {
	try {

		var qTransferProspect = new QueryHttp("CRM/GestionComptes/transProspectClient.tmpl");
		qTransferProspect.setParam("Num_Client", numClient);
		qTransferProspect.setParam("Client_Id", globalClientId);
		qTransferProspect.execute();

		isClient = true;

		document.getElementById("bofs-transferer").disabled = isClient;
		var qGetInfos = new QueryHttp("CRM/GestionComptes/loadProspect.tmpl");
		qGetInfos.setParam("Client_Id", globalClientId);
		var result = qGetInfos.execute();
		document.getElementById("ofs-rowNumClient").collapsed = false;
		document.getElementById("ofs-numClient").value = result.responseXML.documentElement.getAttribute("Num_Client");

	} catch (e) {
		recup_erreur(e);
	}
}
