/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/calculDocument.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/lib_tva.js");


var gProfil;
var gConfig;
var gEtablissementDefaut;



function init() {
	try {

  	window.parent.addEventListener("close", demandeEnregistrement, false);

		gProfil = getProfil();

		gEtablissementDefaut = gProfil.getEtabId();

		gConfig = getConfig();

		reconduireAbonnements();

  	omc_init();
  	omm_init();
		oec_init();
		oem_init();
		omf_init();

		if (isEmpty(ParamValeur("Facturation"))) {
 			document.getElementById('deck').selectedIndex = 0;
		}
		else {
			retourMenuFacturation();
		}

		document.getElementById('deck').collapsed = false;

	} catch (e) {
    recup_erreur(e);
  }
}


function desinit() {
	try {

		window.parent.removeEventListener("close", demandeEnregistrement, false);

	} catch (e) {
    recup_erreur(e);
  }
}


function pressOnWindow(ev) {
	try {

		var currentDeck = document.getElementById('deck').selectedIndex;
		if (currentDeck==1) {
			oec_pressOnWindow(ev);
		}
		else if (currentDeck==3) {
			oem_pressOnWindow(ev);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function retourMenuContrats() {
	try {

		document.getElementById('omc-pdf').setAttribute("src", "");
		document.getElementById('oec-pdfAbonnement').setAttribute("src", "");
		document.getElementById('omc-deckMenu').selectedIndex = 0;
		document.getElementById('deck').selectedIndex = 0;
		document.getElementById('bMenuContrats').collapsed = true;
		document.getElementById('bMenuModeles').collapsed = false;
		document.getElementById('bMenuFacturation').collapsed = false;
		document.getElementById('bRetourContrat').collapsed = true;

		document.activeElement.blur();
		omc_listerContrats();

	} catch (e) {
		recup_erreur(e);
	}
}


function retourContrat() {
  try {

		document.getElementById('oec-pdfAbonnement').setAttribute("src", "");
		oec_chargerContrat();
		document.getElementById('oec-deckContrat').selectedIndex = 0;
		document.getElementById('bRetourContrat').collapsed = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function retourMenuModeles() {
	try {

		document.getElementById('omm-pdf').setAttribute("src", "");
		//document.getElementById('oem-pdfModele').setAttribute("src", "");
		document.getElementById('omm-deckMenu').selectedIndex = 0;
		document.getElementById('deck').selectedIndex = 2;
		document.getElementById('bMenuContrats').collapsed = false;
		document.getElementById('bMenuModeles').collapsed = true;
		document.getElementById('bMenuFacturation').collapsed = false;
		document.getElementById('bRetourModele').collapsed = true;

		document.activeElement.blur();
		omm_listerModeles();

	} catch (e) {
		recup_erreur(e);
	}
}


function retourModele() {
  try {

		//document.getElementById('oem-pdfModele').setAttribute("src", "");
		oem_chargerModele();
		document.getElementById('oem-deckModele').selectedIndex = 0;
		document.getElementById('bRetourModele').collapsed = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function retourMenuFacturation() {
	try {

		document.getElementById('omf-pdf').setAttribute("src", "");
		document.getElementById('omf-deckMenu').selectedIndex = 0;
		document.getElementById('omf-panneau').selectedIndex = 0;
		document.getElementById('deck').selectedIndex = 4;

		document.getElementById('bMenuFacturation').collapsed = true;
		document.getElementById('bMenuContrats').collapsed = false;
		document.getElementById('bMenuModeles').collapsed = false;

		document.activeElement.blur();
		omf_listerFacturesAEmettre();

	} catch (e) {
		recup_erreur(e);
	}
}


function demandeEnregistrement() {
	try {

		var currentDeck = parseIntBis(document.getElementById('deck').selectedIndex);
		if (currentDeck==1) { oec_demandeEnregistrement(); }
		else if (currentDeck==3) { oem_demandeEnregistrement(); }

	} catch (e) {
		recup_erreur(e);
	}
}


function reconduireAbonnements() {
	try {

		var qManage = new QueryHttp("Facturation/Abonnements/manageAllContratAbonnement.tmpl");
		var result = qManage.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}

	}	catch(e) {
   	recup_erreur(e);
  }
}


function retourMenuPrincipal() {
	try {

		window.location = "chrome://opensi/content/facturation/user/menu_principal.xul";

	} catch (e) {
    recup_erreur(e);
  }
}
