/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var omf_aFacturation = new Arbre("Facturation/Abonnements/list-factureAEmettre.tmpl", "omf-facturesAEmettre");
var omf_aHistorique = new Arbre("Facturation/Abonnements/list-historiqueFacturation.tmpl", "omf-listeHistorique");

var omf_fmon = new NumberFormat("0.00", true);



function omf_init() {
  try {

		document.getElementById('omf-panneau').selectedIndex = 0;

  } catch (e) {
  	recup_erreur(e);
  }
}



// ONGLET FACTURES A EMETTRE


function omf_listerFacturesAEmettre() {
	try {

		document.getElementById('bGenererFacture').disabled = true;
		omf_aFacturation.initTree(omf_afterRefreshFacturesAEmettre);

	}	catch(e) {
		recup_erreur(e);
  }
}


function omf_afterRefreshFacturesAEmettre() {
	try {

		if (omf_aFacturation.nbLignes()>0) {
			document.getElementById('bGenererFacture').disabled = false;
		}

		var totalHT = 0;
		var totalTTC = 0;

		for (var i=0; i<omf_aFacturation.nbLignes(); i++) {
			totalHT += parseFloat(omf_aFacturation.getCellValue(i, "omf-colTotalHTAE"));
			totalTTC += parseFloat(omf_aFacturation.getCellValue(i, "omf-colTotalTTCAE"));
		}

		document.getElementById('omf-totalHTAE').value = omf_fmon.format(totalHT);
		document.getElementById('omf-totalTTCAE').value = omf_fmon.format(totalTTC);

	}	catch (e) {
    recup_erreur(e);
  }
}


function omf_genererFacturation() {
	try {

		if (omf_aFacturation.nbLignes()==0) {
			showWarning("Il n'y a pas de factures \u00E0 g\u00E9n\u00E9rer");
		}
		else {
			document.getElementById('bGenererFacture').disabled = true;

			document.getElementById('bMenuPrincipal').disabled = true;
			document.getElementById('bMenuModeles').disabled = true;
			document.getElementById('bMenuContrats').disabled = true;

			document.getElementById('omf-pmbox').collapsed = false;
			document.getElementById('omf-pm').setAttribute('mode', 'undetermined');

			var listEcheanceId = "";

			for (i=0; i<omf_aFacturation.nbLignes(); i++) {
				listEcheanceId += omf_aFacturation.getCellText(i,'omf-colEcheanceIdAE') +",";
			}

			var qGenerate = new QueryHttp("Facturation/Abonnements/generateFacturation.tmpl");
			qGenerate.setParam("listEcheanceId", listEcheanceId);
			qGenerate.execute(omf_genererFacturation_2);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function omf_genererFacturation_2(result) {
	try {

		document.getElementById('omf-pmbox').collapsed = true;
		document.getElementById('omf-pm').setAttribute('mode', 'none');

		document.getElementById('bMenuPrincipal').disabled = false;
		document.getElementById('bMenuModeles').disabled = false;
		document.getElementById('bMenuContrats').disabled = false;

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var listFactureId = result.responseXML.documentElement.getAttribute("listFactureId");
			omf_editerFactures(listFactureId);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function omf_editerFactures(listFactureId) {
	try	{

		var qEditionPdf = new QueryHttp("Facturation/Abonnements/pdfEditionFactures.tmpl");
		qEditionPdf.setParam("List_Facture_Id", listFactureId);
		var result = qEditionPdf.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
			document.getElementById('omf-deckMenu').selectedIndex = 1;
			document.getElementById('bMenuFacturation').collapsed = false;
			document.getElementById('bMenuContrats').collapsed = true;
			document.getElementById('bMenuModeles').collapsed = true;
			document.getElementById('omf-pdf').setAttribute("src", page);
		}

	}	catch (e)	{
    recup_erreur(e);
  }
}



// ONGLET HISTORIQUE FACTURES EMISES


function omf_listerHistoriqueFacturation() {
	try {

		document.getElementById('bReediterFactures').disabled = true;
		omf_aHistorique.initTree(omf_afterRefreshHistoriqueFacturation);

	}	catch(e) {
		recup_erreur(e);
  }
}


function omf_afterRefreshHistoriqueFacturation() {
	try {

		if (omf_aHistorique.nbLignes()>0) {
			document.getElementById('bReediterFactures').disabled = false;
		}

		var totalHT = 0;
		var totalTTC = 0;

		for (var i=0; i<omf_aHistorique.nbLignes(); i++) {
			totalHT += parseFloat(omf_aHistorique.getCellValue(i, "omf-colTotalHTHF"));
			totalTTC += parseFloat(omf_aHistorique.getCellValue(i, "omf-colTotalTTCHF"));
		}

		document.getElementById('omf-totalHTHF').value = omf_fmon.format(totalHT);
		document.getElementById('omf-totalTTCHF').value = omf_fmon.format(totalTTC);

	}	catch (e) {
    recup_erreur(e);
  }
}


function omf_ouvrirFacture() {
	try {

		if (omf_aHistorique.isSelected()) {
			var factureId = omf_aHistorique.getSelectedCellText('omf-colFactureIdHF');
			window.location = "chrome://opensi/content/facturation/user/factures_vente/gestionFactures.xul?Facture_Id="+ factureId;
    }

	} catch (e) {
		recup_erreur(e);
	}
}


function omf_reediterFactures() {
	try {

		if (omf_aHistorique.nbLignes()==0) {
			showWarning("Il n'y a pas de factures \u00E0 r\u00E9\u00E9diter");
		}
		else {
			document.getElementById('bReediterFactures').disabled = true;

			var listFactureId = "";

			for (i=0; i<omf_aHistorique.nbLignes(); i++) {
				listFactureId += omf_aHistorique.getCellText(i,'omf-colFactureIdHF') +",";
			}

			omf_editerFactures(listFactureId);
		}

	} catch (e) {
		recup_erreur(e);
	}
}
