/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var oec_commandeId = "";
var oec_modeLigne = "";
var oec_codeTVAPort = "";
var oec_tauxTVAPort;
var oec_zoneUE;
var oec_modeTarif;
var oec_mode;
var oec_etatCommande;
var oec_soldee;
var oec_defEditionTTC;
var oec_editionTTC;
var oec_assujettiTVA;
var oec_defModeExpedition;
var oec_defModeReglement;
var oec_defRegleExpedition;
var oec_typeRistourne = 'P';
var oec_typeRemise;
var oec_typeRemiseFP;
var oec_editionPdf;
var oec_premiereCommande;
var oec_nf = new NumberFormat("0.00", false);
var oec_chargerModeReg;
var oec_chargerModeExpedition;
var oec_chargerResponsable;
var oec_selPoleActivite;
var oec_selTarifVente;
var oec_acompte;
var oec_currentIndex;
var oec_toSelectLigne = null;
var oec_montantHT;
var oec_montantTTC;
var oec_clientId = "";
var oec_typeEditionPdf;
var oec_docIdPdf;
var oec_editionInitiale;
var oec_alerteEncoursClient;
var oec_typeLigne;
var oec_prixId = "";
var oec_ligneId;
var oec_articleId = "";
var oec_libelle = "";
var oec_modifie = false;
var oec_bloque = false;
var oec_langueDefaut;
var oec_curEtablissement;
var oec_curDepot;
var oec_actDepotLigneCC;
var oec_calculStock;
var oec_gestionResp;
var oec_gestionEtab;
var oec_gestionPole;
var oec_gestionInti;
var oec_modifElemFin;
var oec_existeBL;
var oec_existeFacture;
var oec_codesTvaInactifs = "";
var oec_insertionLigneId = 0;
var oec_uniteDefaut;
var oec_alerteDoublonLigne;
var oec_substitution = false;
var oec_cloturable;
var oec_gacAffAvoirCC;
var oec_accesLPE;
var oec_modeRegClient;

var oec_aResponsables = new Arbre("ComboListe/combo-responsables.tmpl","oec-responsable");
var oec_aUnites = new Arbre("ComboListe/combo-unitesVente.tmpl", "oec-unite");
var oec_aTarifsVente = new Arbre("ComboListe/combo-tarifsVente.tmpl", "oec-tarifVente");
var oec_aModesExpedition = new Arbre("ComboListe/combo-modesExpedition.tmpl","oec-modeExpedition");
var oec_aPolesActivite = new Arbre("ComboListe/combo-polesActivite.tmpl", "oec-poleActivite");
var oec_aPaysFact = new Arbre("ComboListe/combo-pays.tmpl", "oec-codePaysFact");
var oec_aPaysLiv = new Arbre("ComboListe/combo-pays.tmpl", "oec-codePaysLiv");
var oec_aPaysEnvoi = new Arbre("ComboListe/combo-pays.tmpl", "oec-codePaysEnvoi");
var oec_aPaysEF = new Arbre("ComboListe/combo-pays.tmpl", "oec-codePaysEF");
var oec_aCodesTVA = new Arbre("ComboListe/combo-tauxTVA.tmpl", "oec-codeTVA");
var oec_aCodesTVAFraisPort = new Arbre("ComboListe/combo-tauxTVA.tmpl", "oec-codeTVAFraisPort");
var oec_aLignes = new Arbre("Facturation/Affaires/liste-articlesCommande.tmpl", "oec-articles");
var oec_aModesReglements = new Arbre("ComboListe/combo-modesReglement.tmpl", "oec-modeReglement");
var oec_aAcomptes = new Arbre("Facturation/Affaires/list-acompteClient.tmpl","oec-listeAcomptes");
var oec_aListeReglements = new Arbre("Facturation/Affaires/list-reglementsCommande.tmpl","oec-listeReglements");
var oec_aLiensColis = new Arbre("Facturation/Affaires/list-colisCC.tmpl","oec-liensColis");
var oec_aListeHistorique = new Arbre("Facturation/Affaires/list-historiqueCommandeClient.tmpl","oec-listeHistorique");
var oec_aVersion = new Arbre("Facturation/Affaires/list-versionCommandeClient.tmpl","oec-listeVersion");
var oec_aLangues = new Arbre("ComboListe/combo-langues.tmpl", "oec-langueDefaut");
var oec_aEtablissements = new Arbre('ComboListe/combo-etablissements.tmpl', 'oec-etablissement');
var oec_aDepots = new Arbre('ComboListe/combo-depotsStock.tmpl', 'oec-depot');
var oec_aDepotsLigne = new Arbre('ComboListe/combo-depotsStock.tmpl', 'oec-depotLigne');
var oec_aSuivi = new Arbre("Facturation/Affaires/liste-suiviCommande.tmpl", "oec-listeSuivi");
var oec_aTypeSuivi = new Arbre("ComboListe/combo-typesSuiviCC.tmpl", "oec-typeSuiviId");
var oec_aComposantsLigne = new Arbre("Facturation/Affaires/list-composantLigneCC.tmpl", "oec-listComposantsLigne");

const gClipboardHelper = Components.classes["@mozilla.org/widget/clipboardhelper;1"].getService(Components.interfaces.nsIClipboardHelper);



function oec_init() {
  try {

		oec_modifElemFin = gProfil.isModifElemFinDV();
		oec_gestionResp = gProfil.isGestionRespVente();
		oec_gestionEtab = gProfil.isGestionEtabVente();
		oec_gestionPole = gProfil.isGestionPoleVente();
		oec_gestionInti = gProfil.isGestionIntiVente();

		document.getElementById('oec-rowFax').collapsed = !gShowFax;

		document.getElementById('oec-rowFamilleClient').collapsed = !gConfig.isSpecLHGFC();

		document.getElementById('oec-symboleUniteVolume').value = gConfig.getSymboleUniteVolume();
		document.getElementById('oec-symboleUnitePoids').value = gConfig.getSymboleUnitePoids();
		document.getElementById("oec-colVolumeColis").setAttribute("label", "Volume ("+ gConfig.getSymboleUniteVolume() +")");

		var actCodeStats = gConfig.isActCodeStats();
		oec_calculStock = gConfig.isCalculStock();
		if (!actCodeStats) {
			document.getElementById('oec-colCodeStats').collapsed = true;
			document.getElementById('oec-colCodeStats').setAttribute('ignoreincolumnpicker', true);
	  	document.getElementById('oec-actCodeStats').collapsed = true;
		}
		else {
			document.getElementById('oec-labelRef').setAttribute('style', 'margin-left:0px');
			document.getElementById('oec-reference').setAttribute('style', 'margin-left:0px');
		}

		var actUnites = gConfig.isActUnites();
		var actNbPieces = gConfig.isActNbPieces();
		var actDispoFour = gConfig.isActDispoFour();
		var gacDateExpLigne = gConfig.isGACDateExpLigne();
		oec_alerteDoublonLigne = gConfig.isGACAlerteDoublonLigne();
		oec_actDepotLigneCC = gConfig.isActDepotLigneCC();
		oec_uniteDefaut = gConfig.getUniteDefaut();
		oec_gacAffAvoirCC = gConfig.isGACAffAvoirCC();
		oec_accesLPE = !isEmpty(gConfig.getConfigLPE());

		document.getElementById('oec-bDesaffecterAvoir').collapsed = !oec_gacAffAvoirCC;
		document.getElementById('oec-chkNonFacturable').collapsed = !gConfig.isGACAutNonFacturable();
		document.getElementById('oec-noDropShipping').collapsed = !gConfig.isGACDropPossibleAuto();

		if (oec_actDepotLigneCC) {
			document.getElementById('oec-fieldDepotLigne').collapsed = false;
			document.getElementById('oec-colLibDepot').collapsed = false;
			document.getElementById('oec-labelDepot').value = "D\u00E9p\u00F4t par d\u00E9faut :";
		}
		else {
			document.getElementById('oec-colLibDepot').setAttribute('ignoreincolumnpicker', true);
		}

		if (!actUnites) {
			document.getElementById('oec-colSymboleUnite').collapsed = true;
			document.getElementById('oec-colSymboleUnite').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oec-fieldUnite').collapsed = true;
		}

		if (!actNbPieces) {
			document.getElementById('oec-colNbPieces').collapsed = true;
			document.getElementById('oec-colNbPieces').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oec-fieldNbPieces').collapsed = true;
		}

		if (!gacDateExpLigne) {
			document.getElementById('oec-colDateExpedition').collapsed = true;
			document.getElementById('oec-colDateExpedition').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oec-fieldDateExpedition').collapsed = true;
		}

		if (!actDispoFour) {
			document.getElementById('oec-colDispoFournisseur').collapsed = true;
			document.getElementById('oec-colDispoFournisseur').setAttribute('ignoreincolumnpicker', true);
		}

		if (!oec_calculStock) {
			document.getElementById('oec-colStock').setAttribute("hidden",true);
			document.getElementById('oec-colStock').setAttribute("ignoreincolumnpicker",true);
			document.getElementById('oec-colFournisseur').setAttribute("hidden",true);
			document.getElementById('oec-colFournisseur').setAttribute("ignoreincolumnpicker",true);
		}

		oec_defEditionTTC = gConfig.isVenteTTC();
		oec_defModeExpedition = gConfig.getDefModeExpedition();
		oec_defModeReglement = gConfig.getDefModeReglementC();
		oec_defRegleExpedition = gConfig.getGACDefRegleExpedition();

		oec_modeTarif = gConfig.getModeTarif();
		if (oec_modeTarif=='Q') {
			document.getElementById('oec-rowTarif').collapsed = true;
		}

		oec_aUnites.initTree(oec_initUnite);

		oec_aTypeSuivi.initTree();

		document.getElementById('oec-boxOF').collapsed = !gConfig.isSpecREOF();
		document.getElementById('oec-rowCoutTransport').collapsed = !gConfig.isGACCoutTrans();

		oec_alerteEncoursClient = gConfig.isAlerteEncoursClient();

		if (gReadOnly) {
			document.getElementById('oec-bImporterLignes').collapsed = true;
			document.getElementById('oec-bSolderLigne').collapsed = true;
			document.getElementById('oec-bAjouterLigne').collapsed = true;
			document.getElementById('oec-bMultiSuppression').collapsed = true;
			document.getElementById('oec-bMoveUp').collapsed = true;
			document.getElementById('oec-bMoveDown').collapsed = true;
			document.getElementById('oec-bMoveFirst').collapsed = true;
			document.getElementById('oec-bMoveLast').collapsed = true;
			document.getElementById('oec-gridLigneCommande').collapsed = true;
			document.getElementById('oec-bAnnulerAcompte').collapsed = true;
			document.getElementById('oec-bAnnulerColis').collapsed = true;
			document.getElementById('oec-bNouveauMessageSuivi').collapsed = true;
			document.getElementById('oec-bEnregistrerMessageSuivi').collapsed = true;
			document.getElementById('oec-tabCommande').setAttribute('tooltiptext', "Lecture seule");
		}

		if (!gAccesCoutAchat) {
			document.getElementById('oec-colPrixAchat').setAttribute("ignoreincolumnpicker", true);
			document.getElementById('oec-colTauxMarque').setAttribute("ignoreincolumnpicker", true);
			document.getElementById('oec-colTauxMarge').setAttribute("ignoreincolumnpicker", true);
			document.getElementById('oec-colMargeHT').setAttribute("ignoreincolumnpicker", true);
		}

		if (gConfig.isGACCreneauLivraison()) {
			document.getElementById('oec-lblDateLivraisonFin').collapsed = false;
			document.getElementById('oec-dateLivraisonFin').collapsed = false;
			document.getElementById('oec-dateLivraison').setAttribute("tooltiptext", "format : jj/mm/aaaa hh:mm");
			document.getElementById('oec-dateLivraison').setAttribute("size", "12");
			document.getElementById('oec-dateLivraison').setAttribute("maxlength", "16");
		}

		if (gConfig.isGACComPub()) {
			document.getElementById('oec-rowEngagement').collapsed = false;
			document.getElementById('oec-rowService').collapsed = false;
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oec_initUnite() {
	try {

    document.getElementById('oec-unite').selectedIndex = 0;
		oec_aPaysFact.initTree(oec_initPaysFact);

	} catch (e) {
    recup_erreur(e);
  }
}


function oec_initModeExpedition() {
	try {

		document.getElementById('oec-modeExpedition').value = oec_chargerModeExpedition;

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_initPaysFact() {
	try {

		document.getElementById('oec-codePaysFact').value = "FR";
		oec_aPaysLiv.initTree(oec_initPaysLiv);

	} catch (e) {
    recup_erreur(e);
  }
}


function oec_initPaysLiv() {
	try {

		document.getElementById('oec-codePaysLiv').value = "FR";
		oec_aPaysEnvoi.initTree(oec_initPaysEnvoi);

	} catch (e) {
    recup_erreur(e);
  }
}


function oec_initPaysEnvoi() {
	try {

		document.getElementById('oec-codePaysEnvoi').value = "FR";
		oec_aPaysEF.initTree(oec_initPaysEF);

	} catch (e) {
    recup_erreur(e);
  }
}


function oec_initPaysEF() {
	try {

		document.getElementById('oec-codePaysEF').value = "FR";
		oec_chargerResponsables(gProfil.getLoggedUser());

	} catch (e) {
    recup_erreur(e);
  }
}


function oec_chargerEtablissement(selection) {
	try {

		oec_curEtablissement = selection;
		oec_aEtablissements.setParam("Selection", selection);
		oec_aEtablissements.initTree(oec_initEtablissement);

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_initEtablissement() {
	try {

		document.getElementById('oec-etablissement').value = oec_curEtablissement;

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_chargerDepot(selection) {
	try {

		oec_curDepot = selection;
		oec_aDepots.setParam("Selection", selection);
		oec_aDepots.setParam("Depot_Vente", false);
		oec_aDepots.setParam("Depot_Quarantaine", false);
		oec_aDepots.initTree(oec_initDepot);

		oec_aDepotsLigne.setParam("Selection", selection);
		oec_aDepotsLigne.setParam("Depot_Vente", false);
		oec_aDepotsLigne.setParam("Depot_Quarantaine", false);
		oec_aDepotsLigne.initTree(oec_initDepotLigne);

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_initDepot() {
	try {

		document.getElementById('oec-depot').value = oec_curDepot;

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_initDepotLigne() {
	try {

		document.getElementById('oec-depotLigne').value = oec_curDepot;

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_chargerModesReglements(selection) {
	try {

		oec_chargerModeReg = selection;
		oec_aModesReglements.setParam("Selection", oec_chargerModeReg);
		oec_aModesReglements.initTree(oec_initModeReglement);

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_chargerModesExpedition(selection) {
	try {

		oec_chargerModeExpedition = selection;
		oec_aModesExpedition.setParam("Selection", oec_chargerModeExpedition);
		oec_aModesExpedition.initTree(oec_initModeExpedition);

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_initModeReglement() {
	try {

		document.getElementById('oec-modeReglement').value = oec_chargerModeReg;
		oec_changeModeReglement();

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_chargerResponsables(selection) {
	try {

		oec_chargerResponsable = selection;
		oec_aResponsables.setParam("Selection", oec_chargerResponsable);
		oec_aResponsables.initTree(oec_initResponsable);

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_initResponsable() {
  try {

		document.getElementById('oec-responsable').value = oec_chargerResponsable;

	} catch (e) {
  	recup_erreur(e);
	}
}


function oec_chargerPolesActivite(selection) {
	try {

		oec_selPoleActivite = selection;
		oec_aPolesActivite.setParam("Selection", oec_selPoleActivite);
		oec_aPolesActivite.initTree(oec_initPoleActivite);

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_initPoleActivite() {
  try {

		document.getElementById('oec-poleActivite').value = oec_selPoleActivite;

	} catch (e) {
  	recup_erreur(e);
	}
}


function oec_ouvrirMessageSuivi() {
  try {

		if (oec_aSuivi.isSelected()) {
			var i = oec_aSuivi.getCurrentIndex();
			document.getElementById('oec-messageSuivi').value = oec_aSuivi.getCellText(i,'oec-colSuiviMessage');
			document.getElementById('oec-messageSuivi').setAttribute('readonly', true);
			document.getElementById('oec-typeSuiviId').value = oec_aSuivi.getCellText(i,'oec-colTypeSuiviId');

			document.getElementById('oec-suiviEnvoiMail').checked = oec_aSuivi.getCellText(i,'oec-colEnvoiClientId')=="true";
			document.getElementById('oec-suiviVisibleClient').checked = oec_aSuivi.getCellText(i,'oec-colVisibleClientId')=="true";

			document.getElementById('oec-typeSuiviId').disabled = true;
			document.getElementById('oec-suiviEnvoiMail').disabled = true;
			document.getElementById('oec-suiviVisibleClient').disabled = true;
			document.getElementById('oec-bEnregistrerMessageSuivi').disabled = true;
			gClipboardHelper.copyString(oec_aSuivi.getCellText(i,'oec-colSuiviMessage'));
		}

  } catch (e) {
  	recup_erreur(e);
	}
}


function oec_nouveauMessageSuivi() {
  try {

		document.getElementById('oec-messageSuivi').value = "";
		document.getElementById('oec-messageSuivi').removeAttribute('readonly');
		document.getElementById('oec-typeSuiviId').value = "";
		document.getElementById('oec-typeSuiviId').disabled = false;
		document.getElementById('oec-suiviEnvoiMail').disabled = false;
		document.getElementById('oec-suiviVisibleClient').disabled = false;

		document.getElementById('oec-bEnregistrerMessageSuivi').disabled = false;
		document.getElementById('oec-suiviEnvoiMail').checked = false;
		document.getElementById('oec-suiviVisibleClient').checked = false;

  } catch (e) {
  	recup_erreur(e);
	}
}


function oec_enregistrerMessageSuivi() {
  try {

  	var message = document.getElementById('oec-messageSuivi').value;
		var typeSuiviId = document.getElementById('oec-typeSuiviId').value;

		if (isEmpty(message)) {
			showWarning("Le message ne peut pas \u00EAtre vide");
		}
		else if (isEmpty(typeSuiviId)) {
			showWarning("Veuillez s\u00E9lectionner un type de message");
		}
		else {
			var qCreate = new QueryHttp("Facturation/Affaires/createSuiviCommande.tmpl");
			qCreate.setParam("Commande_Id", oec_commandeId);
			qCreate.setParam("Message", message);
			qCreate.setParam("EnvoiMail", document.getElementById('oec-suiviEnvoiMail').checked);
			qCreate.setParam("VisibleClient", document.getElementById('oec-suiviVisibleClient').checked);
			qCreate.setParam("Type_Suivi_Id", typeSuiviId);
			var result = qCreate.execute();
			var errors = new Errors(result);

			if (errors.hasNext()) {
				errors.show();
			}
			else {
				gClipboardHelper.copyString(message);
				oec_aSuivi.initTree();
				oec_nouveauMessageSuivi();
			}
		}

  } catch (e) {
  	recup_erreur(e);
	}
}


function oec_editerMessageSuivi() {
  try {

		var message = document.getElementById('oec-messageSuivi').value;
		var readOnly = document.getElementById('oec-bEnregistrerMessageSuivi').disabled || gReadOnly;

		var url = "chrome://opensi/content/facturation/user/affaires/popup-messageSuiviCommandeClient.xul";
  	window.openDialog(url,'','chrome,modal,centerscreen', oec_retourEditerMessageSuivi, message, readOnly);

	} catch (e) {
    recup_erreur(e);
  }
}


function oec_retourEditerMessageSuivi(message) {
  try {

		document.getElementById('oec-messageSuivi').value = message;

	} catch (e) {
    recup_erreur(e);
  }
}


function oec_reinitialiser() {
	try {

		oec_modeLigne = "C";
		oec_zoneUE=false;

		oec_etatCommande = "";
		oec_soldee = false;
		oec_cloturable = false;
		oec_assujettiTVA = false;
		oec_typeRemise = "P";
		oec_typeRemiseFP = "P";
		oec_editionTTC = oec_defEditionTTC;
		oec_editionPdf = "C";
		oec_editionInitiale = false;
		oec_premiereCommande = true;
		oec_chargerModeReg = oec_defModeReglement;
		oec_chargerModeExpedition = oec_defModeExpedition;
		oec_chargerResponsable="";
		oec_selPoleActivite = "";
		oec_currentIndex=0;

		oec_montantHT = 0;
		oec_montantTTC = 0;

		oec_typeEditionPdf = "";
		oec_docIdPdf = "";
		oec_curEtablissement = "";
		oec_curDepot = "";
		oec_codesTvaInactifs = "";
		oec_codeTVAPort = "";

		document.getElementById("oec-tabBoxAdresses").collapsed = false;
		document.getElementById("oec-boxApercuArticle").collapsed = true;
		oec_aComposantsLigne.deleteTree();

		document.getElementById('oec-deckCommande').selectedIndex = 0;
		document.getElementById('oec-tabBoxCommande').selectedIndex = 0;
		document.getElementById('oec-tabCommande').setAttribute('image', gReadOnly?'chrome://opensi/content/design/icones/readonly.png':null);
		oec_aAcomptes.deleteTree();
		document.getElementById('oec-tabEncaissements').collapsed = true;
		document.getElementById('oec-caTTCFacture').value = "";
		document.getElementById('oec-caTTCPaye').value = "";
		document.getElementById('oec-pourcCATTCPaye').value = "";
		document.getElementById('oec-soldeAEncaisser').value = "";
		document.getElementById('oec-pourcSoldeAEncaisser').value = "";
		document.getElementById('oec-encoursAutorise').value = "0.00 \u20AC";
		document.getElementById('oec-encoursActuel').value = "0.00 \u20AC";
		document.getElementById('oec-boxEncoursClient').collapsed = false;
		document.getElementById('oec-boxWarning').collapsed = true;
		document.getElementById('oec-alerteClientBloque').collapsed = true;
		document.getElementById('oec-depEncoursClient').collapsed = true;
		document.getElementById('oec-depEncoursFacturation').collapsed = true;
		document.getElementById('oec-bSupprimerReglement').disabled = true;
		document.getElementById('oec-bAnnulerReglement').disabled = true;
		document.getElementById('oec-bDesaffecterAvoir').disabled = true;
		oec_aListeReglements.deleteTree();
		document.getElementById('oec-boxReglement').collapsed = true;
		document.getElementById('oec-bNouveauReglement').collapsed = true;
		document.getElementById('oec-bAffecterAvoir').collapsed = true;
		document.getElementById('oec-boxNouvelAcompte').collapsed = true;
		document.getElementById('oec-bEnvoyerLPE').collapsed = true;
		document.getElementById('oec-bAnnulerAcompte').disabled = true;
		document.getElementById('oec-bReediterAcompte').disabled = true;
		oec_aLiensColis.deleteTree();
		oec_aListeHistorique.deleteTree();

		document.getElementById('oec-tabVersionDocument').collapsed = true;
		oec_aVersion.deleteTree();

		document.getElementById('oec-caHT').value = "0.00 \u20AC";
		document.getElementById('oec-paHT').value = "0.00 \u20AC";
		document.getElementById('oec-margeHT').value = "0.00 \u20AC";
		document.getElementById('oec-tauxMarque').value = "0.00 %";
		document.getElementById('oec-tauxMarge').value = "0.00 %";
		document.getElementById('oec-qteArticles').value = "0";
		document.getElementById('oec-nbLignes').value = "0";
		document.getElementById('oec-nbComClient').value = "0";
		document.getElementById('oec-nbArticlesDejaLivres').value = "0";
		document.getElementById('oec-nbArticlesRestantALivrer').value = "0";
		document.getElementById('oec-avancementCommande').value = "0 %";
		document.getElementById('oec-lblMargeHT').setAttribute("style", "color:black");
		document.getElementById('oec-margeHT').setAttribute("style", "color:black");
		document.getElementById('oec-lblTauxMarque').setAttribute("style", "color:black");
		document.getElementById('oec-tauxMarque').setAttribute("style", "color:black");
		document.getElementById('oec-lblTauxMarge').setAttribute("style", "color:black");
		document.getElementById('oec-tauxMarge').setAttribute("style", "color:black");
		document.getElementById('oec-pictoMargeNegative').collapsed = true;

		oec_aModesReglements.deleteTree();
		oec_aResponsables.deleteTree();
		oec_aEtablissements.deleteTree();
		oec_aDepots.deleteTree();
		oec_aDepotsLigne.deleteTree();

		oec_aSuivi.deleteTree();
		document.getElementById('oec-messageSuivi').value = "";
		document.getElementById('oec-messageSuivi').removeAttribute('readonly');
		document.getElementById('oec-typeSuiviId').value = "";
		document.getElementById('oec-typeSuiviId').disabled = false;
		document.getElementById('oec-bEnregistrerMessageSuivi').disabled = false;

		document.getElementById('oec-tabHistorique').collapsed = true;
		document.getElementById('oec-tabAcomptes').collapsed = true;
		document.getElementById('oec-tabSuivi').collapsed = true;
		document.getElementById('oec-tabColis').collapsed = true;
		document.getElementById('oec-numAffaire').value = "";
		document.getElementById('oec-numCommande').value = "";
		document.getElementById('oec-refCommande').value = "";
		document.getElementById('oec-intitule').value = "";
		document.getElementById('oec-dateCommande').value = "";
		document.getElementById('oec-poidsTotal').value = 0;
		document.getElementById('oec-volumeTotal').value = 0;
		document.getElementById('oec-dateExpedition').value = "";
		document.getElementById('oec-dateLivraison').value = "";
		document.getElementById('oec-dateLivraisonFin').value = "";
		document.getElementById('oec-consignesLiv').value = "";
		document.getElementById('oec-regleExpedition').value = oec_defRegleExpedition;
		document.getElementById('oec-chkNonFacturable').checked = false;
		document.getElementById('oec-chkPaquetCadeau').checked = false;
		document.getElementById('oec-chkPrioritaireLiv').checked = false;
		document.getElementById('oec-chkExpeditionNeutre').checked = false;
		document.getElementById('oec-chkLivTransitaire').checked = false;
		document.getElementById('oec-noDropShipping').checked = false;
		document.getElementById('oec-numDevisOrigine').value = "";
		document.getElementById('oec-etatCommande').value = "";
		document.getElementById('oec-statutPaiement').value = "";
		document.getElementById('oec-rowFrancoPort').collapsed = true;
		document.getElementById('oec-lblFrancoPort').value = "";
		oec_clientId = "";
		document.getElementById('oec-numClient').value = "";
		document.getElementById('oec-familleClient').value = "";
		document.getElementById('oec-labelLogin').value = "";
		document.getElementById('oec-rowLoginWeb').collapsed = true;
		document.getElementById('oec-assujettiTVA').checked = false;
		document.getElementById('oec-numTVA').value = "";
		document.getElementById('oec-regimeTVA').selectedIndex = 0;
		document.getElementById('oec-editionTTC').checked = oec_editionTTC;
		document.getElementById('oec-indications').value = "";
		document.getElementById('oec-tabWeb').collapsed = true;
		document.getElementById('oec-siteOrigine').value = "";
		document.getElementById('oec-refComWeb').value = "";
		document.getElementById('oec-marketplace').value = "";
		document.getElementById('oec-refMarketplace').value = "";
		document.getElementById('oec-lien').value = "";
		document.getElementById('oec-pointRetrait').value = "";
		document.getElementById('oec-coutTransport').value = "";
		document.getElementById('oec-numEngagement').value = "";
		document.getElementById('oec-codeService').value = "";

		document.getElementById('oec-tabBoxAdresses').selectedIndex = 0;
		document.getElementById('oec-denominationFact').value = "";
		document.getElementById('oec-adresse1Fact').value = "";
		document.getElementById('oec-adresse2Fact').value = "";
		document.getElementById('oec-adresse3Fact').value = "";
		document.getElementById('oec-codePostalFact').value = "";
		document.getElementById('oec-villeFact').value = "";
		document.getElementById('oec-codePaysFact').value = "FR";
		document.getElementById('oec-civInterFact').selectedIndex = 0;
		document.getElementById('oec-nomInterFact').value = "";
		document.getElementById('oec-prenomInterFact').value = "";
		document.getElementById('oec-telInter1Fact').value = "";
		document.getElementById('oec-telInter2Fact').value = "";
		document.getElementById('oec-faxInterFact').value = "";
		document.getElementById('oec-emailInterFact').value = "";
		document.getElementById('oec-denominationLiv').value = "";
		document.getElementById('oec-adresse1Liv').value = "";
		document.getElementById('oec-adresse2Liv').value = "";
		document.getElementById('oec-adresse3Liv').value = "";
		document.getElementById('oec-codePostalLiv').value = "";
		document.getElementById('oec-villeLiv').value = "";
		document.getElementById('oec-codePaysLiv').value = "FR";
		document.getElementById('oec-civInterLiv').selectedIndex = 0;
		document.getElementById('oec-nomInterLiv').value = "";
		document.getElementById('oec-prenomInterLiv').value = "";
		document.getElementById('oec-telInter1Liv').value = "";
		document.getElementById('oec-telInter2Liv').value = "";
		document.getElementById('oec-faxInterLiv').value = "";
		document.getElementById('oec-emailInterLiv').value = "";
		document.getElementById('oec-denominationEnvoi').value = "";
		document.getElementById('oec-adresse1Envoi').value = "";
		document.getElementById('oec-adresse2Envoi').value = "";
		document.getElementById('oec-adresse3Envoi').value = "";
		document.getElementById('oec-codePostalEnvoi').value = "";
		document.getElementById('oec-villeEnvoi').value = "";
		document.getElementById('oec-codePaysEnvoi').value = "FR";
		document.getElementById('oec-civInterEnvoi').selectedIndex = 0;
		document.getElementById('oec-nomInterEnvoi').value = "";
		document.getElementById('oec-prenomInterEnvoi').value = "";
		document.getElementById('oec-telInter1Envoi').value = "";
		document.getElementById('oec-telInter2Envoi').value = "";
		document.getElementById('oec-faxInterEnvoi').value = "";
		document.getElementById('oec-emailInterEnvoi').value = "";
		document.getElementById('oec-denominationEF').value = "";
		document.getElementById('oec-adresse1EF').value = "";
		document.getElementById('oec-adresse2EF').value = "";
		document.getElementById('oec-adresse3EF').value = "";
		document.getElementById('oec-codePostalEF').value = "";
		document.getElementById('oec-villeEF').value = "";
		document.getElementById('oec-codePaysEF').value = "FR";
		document.getElementById('oec-civInterEF').selectedIndex = 0;
		document.getElementById('oec-nomInterEF').value = "";
		document.getElementById('oec-prenomInterEF').value = "";
		document.getElementById('oec-telInter1EF').value = "";
		document.getElementById('oec-telInter2EF').value = "";
		document.getElementById('oec-faxInterEF').value = "";
		document.getElementById('oec-emailInterEF').value = "";

		document.getElementById('oec-codeStats').value = "";
		document.getElementById('oec-reference').value = "";
		document.getElementById('oec-designation').value = "";
		document.getElementById('oec-nbPieces').value = "";
		document.getElementById('oec-quantite').value = "1";
		document.getElementById('oec-unite').value = oec_uniteDefaut;
		document.getElementById('oec-PU').value = "";
		document.getElementById('oec-ristourne').value = "0.00";
		document.getElementById('oec-codeTVA').value = getCodeTvaNormal(document.getElementById('oec-codePaysLiv').value, oec_assujettiTVA, document.getElementById('oec-regimeTVA').value);

		document.getElementById('oec-commentairesFin').value = "";
		document.getElementById('oec-commentairesInt').value = "";
		document.getElementById('oec-modeReglement').selectedIndex = 0;
		document.getElementById('oec-bRemise').setAttribute('class', 'bIcoPourcentage');
		document.getElementById('oec-remise').value = "0.00";
		document.getElementById('oec-fraisPort').value = "0.00";
		document.getElementById('oec-codeTVAFraisPort').selectedIndex = 0;
		document.getElementById('oec-bRemiseFP').setAttribute('class', 'bIcoPourcentage');
		document.getElementById('oec-remiseFP').value = "0.00";
		document.getElementById('oec-escompte').value = "0.00";
		oec_acompte = 0;
		document.getElementById('oec-alerteModeReg').collapsed = true;
		oec_modeRegClient = "";

		document.getElementById('oec-colTotal').setAttribute("label", oec_editionTTC?"Total TTC":"Total HT");
		document.getElementById('oec-colPU').setAttribute("label", oec_editionTTC?"P.U TTC":"P.U HT");
		document.getElementById('oec-lblFraisPort').value = (oec_editionTTC?"Frais de port (ttc) :":"Frais de port (ht) :");
		document.getElementById('oec-lblPU').value = (oec_editionTTC?"P.U TTC :":"P.U HT :");
		document.getElementById('oec-piedTTC').collapsed = !oec_editionTTC;
		document.getElementById('oec-piedHT').collapsed = oec_editionTTC;
		document.getElementById('oec-montantHT').value = "0.00";
		document.getElementById('oec-montantRemise').value = "0.00";
		document.getElementById('oec-montantFraisPort').value = "0.00";
		document.getElementById('oec-montantRemiseFP').value = "0.00";
		document.getElementById('oec-totalHT').value = "0.00";
		document.getElementById('oec-TVA').value = "0.00";
		document.getElementById('oec-montantEscompte').value = "0.00";
		document.getElementById('oec-montantAcompte').value = "0.00";
		document.getElementById('oec-totalTTC').value = "0.00";
		document.getElementById('oec-pttcMontantTTC').value = "0.00";
		document.getElementById('oec-pttcMontantRemise').value = "0.00";
		document.getElementById('oec-pttcMontantFraisPort').value = "0.00";
		document.getElementById('oec-pttcMontantRemiseFP').value = "0.00";
		document.getElementById('oec-pttcTotalTTC').value = "0.00";
		document.getElementById('oec-pttcTVA').value = "0.00";
		document.getElementById('oec-pttcMontantEscompte').value = "0.00";
		document.getElementById('oec-pttcMontantAcompte').value = "0.00";
		document.getElementById('oec-pttcNetTTC').value = "0.00";

		document.getElementById('oec-rowNetCommercialHT').collapsed = true;
		document.getElementById('oec-rowEscompteTTC').collapsed = true;
		document.getElementById('oec-pttcNetCommercial').value = "0.00";
		document.getElementById('oec-netCommercial').value = "0.00";

		document.getElementById('oec-rowRemiseHT').collapsed = true;
		document.getElementById('oec-rowRemiseFPHT').collapsed = true;
		document.getElementById('oec-rowEscompteHT').collapsed = true;
		document.getElementById('oec-rowRemiseTTC').collapsed = true;
		document.getElementById('oec-rowRemiseFPTTC').collapsed = true;
		document.getElementById('oec-rowEscompteTTC').collapsed = true;

		document.getElementById('oec-creation').setAttribute("label", "");
		document.getElementById('oec-modification').setAttribute("label", "");
		document.getElementById('oec-fiche').setAttribute("label", "");

		oec_typeLigne = "";
		oec_prixId = "";
		oec_ligneId = "";
		oec_libelle = "";
		oec_modifie = false;
		oec_bloque = false;
		oec_existeBL = false;
		oec_existeFacture = false;

		document.getElementById('oec-refCommande').disabled = true;
		document.getElementById('oec-intitule').disabled = true;
		document.getElementById('oec-dateExpedition').disabled = true;
		document.getElementById('oec-dateLivraison').disabled = true;
		document.getElementById('oec-dateLivraisonFin').disabled = true;
		document.getElementById('oec-pointRetrait').disabled = true;
		document.getElementById('oec-coutTransport').disabled = true;
		document.getElementById('oec-consignesLiv').disabled = true;
		document.getElementById('oec-regleExpedition').disabled = true;
		document.getElementById('oec-chkNonFacturable').disabled = true;
		document.getElementById('oec-chkPaquetCadeau').disabled = true;
		document.getElementById('oec-chkPrioritaireLiv').disabled = true;
		document.getElementById('oec-chkExpeditionNeutre').disabled = true;
		document.getElementById('oec-chkLivTransitaire').disabled = true;
		document.getElementById('oec-noDropShipping').disabled = true;
		document.getElementById('oec-responsable').disabled = true;
		document.getElementById('oec-tarifVente').disabled = true;
		document.getElementById('oec-modeExpedition').disabled = true;
		document.getElementById('oec-etablissement').disabled = true;
		document.getElementById('oec-depot').disabled = true;
		document.getElementById('oec-poleActivite').disabled = true;
		document.getElementById('oec-assujettiTVA').disabled = true;
		document.getElementById('oec-numTVA').disabled = true;
		document.getElementById('oec-regimeTVA').disabled = true;
		document.getElementById('oec-editionTTC').disabled = true;
		document.getElementById('oec-bVoirFichier').disabled = true;
		document.getElementById('oec-indications').disabled = true;
		document.getElementById('oec-numEngagement').disabled = true;
		document.getElementById('oec-codeService').disabled = true;
		document.getElementById('oec-denominationFact').setAttribute('readonly', true);
		document.getElementById('oec-adresse1Fact').setAttribute('readonly', true);
		document.getElementById('oec-adresse2Fact').setAttribute('readonly', true);
		document.getElementById('oec-adresse3Fact').setAttribute('readonly', true);
		document.getElementById('oec-codePostalFact').setAttribute('readonly', true);
		document.getElementById('oec-villeFact').setAttribute('readonly', true);
		document.getElementById('oec-codePaysFact').disabled = true;
		document.getElementById('oec-civInterFact').disabled = true;
		document.getElementById('oec-nomInterFact').setAttribute('readonly', true);
		document.getElementById('oec-prenomInterFact').setAttribute('readonly', true);
		document.getElementById('oec-telInter1Fact').setAttribute('readonly', true);
		document.getElementById('oec-telInter2Fact').setAttribute('readonly', true);
		document.getElementById('oec-faxInterFact').setAttribute('readonly', true);
		document.getElementById('oec-emailInterFact').setAttribute('readonly', true);
		document.getElementById('oec-bChercherAdrFact').disabled = true;
		document.getElementById('oec-bChercherInter').disabled = true;
		document.getElementById('oec-bCopierFactVersLivEnvoi').disabled = true;
		document.getElementById('oec-denominationLiv').setAttribute('readonly', true);
		document.getElementById('oec-adresse1Liv').setAttribute('readonly', true);
		document.getElementById('oec-adresse2Liv').setAttribute('readonly', true);
		document.getElementById('oec-adresse3Liv').setAttribute('readonly', true);
		document.getElementById('oec-codePostalLiv').setAttribute('readonly', true);
		document.getElementById('oec-villeLiv').setAttribute('readonly', true);
		document.getElementById('oec-codePaysLiv').disabled = true;
		document.getElementById('oec-civInterLiv').disabled = true;
		document.getElementById('oec-nomInterLiv').setAttribute('readonly', true);
		document.getElementById('oec-prenomInterLiv').setAttribute('readonly', true);
		document.getElementById('oec-telInter1Liv').setAttribute('readonly', true);
		document.getElementById('oec-telInter2Liv').setAttribute('readonly', true);
		document.getElementById('oec-faxInterLiv').setAttribute('readonly', true);
		document.getElementById('oec-emailInterLiv').setAttribute('readonly', true);
		document.getElementById('oec-bChercherAdrLiv').disabled = true;
		document.getElementById('oec-bChercherInterLiv').disabled = true;
		document.getElementById('oec-bChercherRelais').disabled = true;
		document.getElementById('oec-denominationEnvoi').setAttribute('readonly', true);
		document.getElementById('oec-adresse1Envoi').setAttribute('readonly', true);
		document.getElementById('oec-adresse2Envoi').setAttribute('readonly', true);
		document.getElementById('oec-adresse3Envoi').setAttribute('readonly', true);
		document.getElementById('oec-codePostalEnvoi').setAttribute('readonly', true);
		document.getElementById('oec-villeEnvoi').setAttribute('readonly', true);
		document.getElementById('oec-codePaysEnvoi').disabled = true;
		document.getElementById('oec-civInterEnvoi').disabled = true;
		document.getElementById('oec-nomInterEnvoi').setAttribute('readonly', true);
		document.getElementById('oec-prenomInterEnvoi').setAttribute('readonly', true);
		document.getElementById('oec-telInter1Envoi').setAttribute('readonly', true);
		document.getElementById('oec-telInter2Envoi').setAttribute('readonly', true);
		document.getElementById('oec-faxInterEnvoi').setAttribute('readonly', true);
		document.getElementById('oec-emailInterEnvoi').setAttribute('readonly', true);
		document.getElementById('oec-bChercherAdrEnvoi').disabled = true;
		document.getElementById('oec-bChercherInterEnvoi').disabled = true;
		document.getElementById('oec-denominationEF').setAttribute('readonly', true);
		document.getElementById('oec-adresse1EF').setAttribute('readonly', true);
		document.getElementById('oec-adresse2EF').setAttribute('readonly', true);
		document.getElementById('oec-adresse3EF').setAttribute('readonly', true);
		document.getElementById('oec-codePostalEF').setAttribute('readonly', true);
		document.getElementById('oec-villeEF').setAttribute('readonly', true);
		document.getElementById('oec-codePaysEF').disabled = true;
		document.getElementById('oec-civInterEF').disabled = true;
		document.getElementById('oec-nomInterEF').setAttribute('readonly', true);
		document.getElementById('oec-prenomInterEF').setAttribute('readonly', true);
		document.getElementById('oec-telInter1EF').setAttribute('readonly', true);
		document.getElementById('oec-telInter2EF').setAttribute('readonly', true);
		document.getElementById('oec-faxInterEF').setAttribute('readonly', true);
		document.getElementById('oec-emailInterEF').setAttribute('readonly', true);
		document.getElementById('oec-bChercherAdrEF').disabled = true;
		document.getElementById('oec-bChercherInterEF').disabled = true;

		document.getElementById('oec-commentairesFin').disabled = true;
		document.getElementById('oec-commentairesInt').disabled = true;
		document.getElementById('oec-bOuvrirCommentairesCaches').disabled = true;
		document.getElementById('oec-bChoisirMentions').disabled = true;
		document.getElementById('oec-bOuvrirCommentaires').disabled = true;
		document.getElementById('oec-modeReglement').disabled = true;
		document.getElementById('oec-bRemise').disabled = true;
		document.getElementById('oec-remise').disabled = true;
		document.getElementById('oec-fraisPort').disabled = true;
		document.getElementById('oec-codeTVAFraisPort').disabled = true;
		document.getElementById('oec-bRemiseFP').disabled = true;
		document.getElementById('oec-remiseFP').disabled = true;
		document.getElementById('oec-escompte').disabled = true;
		document.getElementById('oec-bAnnulerCommande').disabled = true;
		document.getElementById('oec-bEnregistrer').disabled = true;
		document.getElementById('oec-bValiderCommande').disabled = true;
		document.getElementById('oec-bSolder').disabled = true;
		document.getElementById('oec-bModifier').disabled = true;
		document.getElementById('oec-bBloquer').disabled = true;
		document.getElementById('oec-bDebloquer').disabled = true;
		document.getElementById('oec-bModifier').collapsed = true;
		document.getElementById('oec-bBloquer').collapsed = true;
		document.getElementById('oec-bDebloquer').collapsed = true;
		document.getElementById('oec-bCloturer').collapsed = true;
		document.getElementById('oec-bDecloturer').collapsed = true;
		document.getElementById('oec-bVisualiser').disabled = true;
		document.getElementById('oec-bEditionInitiale').collapsed = true;
		document.getElementById('oec-bCopierCommande').collapsed = true;
		document.getElementById('oec-bProforma').collapsed = true;

		document.getElementById('oec-codeStats').disabled = true;
		document.getElementById('oec-reference').disabled = true;
		document.getElementById('oec-designation').disabled = true;
		document.getElementById('oec-nbPieces').disabled = true;
		document.getElementById('oec-quantite').disabled = true;
		document.getElementById('oec-unite').disabled = true;
		document.getElementById('oec-depotLigne').disabled = true;
		document.getElementById('oec-PU').disabled = true;
		document.getElementById('oec-ristourne').disabled = true;
		document.getElementById('oec-codeTVA').disabled = true;
		document.getElementById('oec-dateExpeditionLC').disabled = true;
		document.getElementById('oec-bSupprimer').disabled = true;
		document.getElementById('oec-bMoveUp').disabled = true;
		document.getElementById('oec-bMoveDown').disabled = true;
		document.getElementById('oec-bMoveFirst').disabled = true;
		document.getElementById('oec-bMoveLast').disabled = true;
		document.getElementById('oec-bMultiSuppression').disabled = true;
		document.getElementById('oec-bValider').disabled = true;
		document.getElementById('oec-bAnnuler').disabled = true;
		document.getElementById('oec-bArticle').disabled = true;
		document.getElementById('oec-bCommentaire').disabled = true;
		document.getElementById('oec-bImporterLignes').disabled = true;
		document.getElementById('oec-bExporterLignes').disabled = true;
		document.getElementById('oec-bSolderLigne').disabled = true;
		document.getElementById('oec-bAnnulerColis').disabled = true;
		document.getElementById('oec-bAjouterLigne').disabled = true;
		document.getElementById('oec-bEditerOF').collapsed = true;
		oec_aLignes.deleteTree();

		document.getElementById('oec-bSwitchPdf').setAttribute('label', 'Ordre de fabrication');
		document.getElementById('oec-bSwitchPdf').collapsed = false;
		document.getElementById('oec-pdfCommande').setAttribute('src', '');

		document.getElementById('oec-suiviMagento').collapsed = true;
		document.getElementById('oec-colEnvoiClient').collapsed = true;
		document.getElementById('oec-colVisibleClient').collapsed = true;

		document.getElementById('oec-colStock').setAttribute("hidden", true);
		document.getElementById('oec-colFournisseur').setAttribute("hidden", true);

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_initClient() {
	try {

		var qGet = new QueryHttp("Facturation/Affaires/getAffaire.tmpl");
		qGet.setParam("Affaire_Id", ofa_affaireId);
		var result = qGet.execute();
		var contenu = result.responseXML.documentElement;

		oec_clientId = contenu.getAttribute("Client_Id");

		if (!isEmpty(oec_clientId)) {
			oec_chargerCoord();
		}
		else {
			oec_chargerModesReglements(oec_defModeReglement);
			oec_chargerModesExpedition("");
			oec_chargerResponsables(contenu.getAttribute("Util_R"));
			oec_chargerTarifsVente(gConfig.getTarifDefaut());
			document.getElementById('oec-denominationFact').value = contenu.getAttribute("Denomination");
			document.getElementById('oec-denominationLiv').value = contenu.getAttribute("Denomination");
			document.getElementById('oec-denominationEnvoi').value = contenu.getAttribute("Denomination");
			document.getElementById('oec-denominationEF').value = contenu.getAttribute("Denomination");
			document.getElementById('oec-telInter1Fact').value = contenu.getAttribute("Tel_1");
			document.getElementById('oec-telInter2Fact').value = contenu.getAttribute("Tel_2");
			document.getElementById('oec-telInter1Liv').value = contenu.getAttribute("Tel_1");
			document.getElementById('oec-telInter2Liv').value = contenu.getAttribute("Tel_2");
			document.getElementById('oec-telInter1Envoi').value = contenu.getAttribute("Tel_1");
			document.getElementById('oec-telInter2Envoi').value = contenu.getAttribute("Tel_2");
			document.getElementById('oec-telInter1EF').value = contenu.getAttribute("Tel_1");
			document.getElementById('oec-telInter2EF').value = contenu.getAttribute("Tel_2");
			document.getElementById('oec-faxInterFact').value = contenu.getAttribute("Fax");
			document.getElementById('oec-faxInterLiv').value = contenu.getAttribute("Fax");
			document.getElementById('oec-faxInterEnvoi').value = contenu.getAttribute("Fax");
			document.getElementById('oec-faxInterEF').value = contenu.getAttribute("Fax");
			document.getElementById('oec-emailInterFact').value = contenu.getAttribute("Email");
			document.getElementById('oec-emailInterLiv').value = contenu.getAttribute("Email");
			document.getElementById('oec-emailInterEnvoi').value = contenu.getAttribute("Email");
			document.getElementById('oec-emailInterEF').value = contenu.getAttribute("Email");
		}

		document.getElementById('oec-intitule').value = contenu.getAttribute("Intitule");

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_debloquerChamps() {
	try {

		document.getElementById('oec-refCommande').disabled = false;
		document.getElementById('oec-intitule').disabled = !oec_gestionInti;
		document.getElementById('oec-dateExpedition').disabled = false;
		document.getElementById('oec-dateLivraison').disabled = false;
		document.getElementById('oec-dateLivraisonFin').disabled = false;
		document.getElementById('oec-pointRetrait').disabled = false;
		document.getElementById('oec-bChercherRelais').disabled = false;
		document.getElementById('oec-coutTransport').disabled = false;
		document.getElementById('oec-consignesLiv').disabled = false;
		document.getElementById('oec-regleExpedition').disabled = false;
		document.getElementById('oec-chkNonFacturable').disabled = false;
		document.getElementById('oec-chkPaquetCadeau').disabled = false;
		document.getElementById('oec-chkPrioritaireLiv').disabled = false;
		document.getElementById('oec-chkExpeditionNeutre').disabled = false;
		document.getElementById('oec-chkLivTransitaire').disabled = false;
		document.getElementById('oec-noDropShipping').disabled = false;
		document.getElementById('oec-responsable').disabled = !oec_gestionResp;
		document.getElementById('oec-modeExpedition').disabled = false;
		document.getElementById('oec-poleActivite').disabled = !oec_gestionPole;
		document.getElementById('oec-etablissement').disabled = !oec_gestionEtab;
		document.getElementById('oec-depot').disabled = false;
		document.getElementById('oec-assujettiTVA').disabled = !oec_premiereCommande;
		document.getElementById('oec-numTVA').disabled = !document.getElementById('oec-assujettiTVA').checked;
		document.getElementById('oec-regimeTVA').disabled = false;
		document.getElementById('oec-editionTTC').disabled = !oec_premiereCommande;
		document.getElementById('oec-indications').disabled = false;
		document.getElementById('oec-numEngagement').disabled = false;
		document.getElementById('oec-codeService').disabled = false;
		document.getElementById('oec-denominationFact').removeAttribute('readonly');
		document.getElementById('oec-adresse1Fact').removeAttribute('readonly');
		document.getElementById('oec-adresse2Fact').removeAttribute('readonly');
		document.getElementById('oec-adresse3Fact').removeAttribute('readonly');
		document.getElementById('oec-codePostalFact').removeAttribute('readonly');
		document.getElementById('oec-villeFact').removeAttribute('readonly');
		document.getElementById('oec-codePaysFact').disabled = false;
		document.getElementById('oec-civInterFact').disabled = false;
		document.getElementById('oec-nomInterFact').removeAttribute('readonly');
		document.getElementById('oec-prenomInterFact').removeAttribute('readonly');
		document.getElementById('oec-telInter1Fact').removeAttribute('readonly');
		document.getElementById('oec-telInter2Fact').removeAttribute('readonly');
		document.getElementById('oec-faxInterFact').removeAttribute('readonly');
		document.getElementById('oec-emailInterFact').removeAttribute('readonly');
		document.getElementById('oec-bCopierFactVersLivEnvoi').disabled = false;
		document.getElementById('oec-tarifVente').disabled = false;
		document.getElementById('oec-denominationLiv').removeAttribute('readonly');
		document.getElementById('oec-adresse1Liv').removeAttribute('readonly');
		document.getElementById('oec-adresse2Liv').removeAttribute('readonly');
		document.getElementById('oec-adresse3Liv').removeAttribute('readonly');
		document.getElementById('oec-codePostalLiv').removeAttribute('readonly');
		document.getElementById('oec-villeLiv').removeAttribute('readonly');
		document.getElementById('oec-codePaysLiv').disabled = false;
		document.getElementById('oec-civInterLiv').disabled = false;
		document.getElementById('oec-nomInterLiv').removeAttribute('readonly');
		document.getElementById('oec-prenomInterLiv').removeAttribute('readonly');
		document.getElementById('oec-telInter1Liv').removeAttribute('readonly');
		document.getElementById('oec-telInter2Liv').removeAttribute('readonly');
		document.getElementById('oec-faxInterLiv').removeAttribute('readonly');
		document.getElementById('oec-emailInterLiv').removeAttribute('readonly');
		document.getElementById('oec-denominationEnvoi').removeAttribute('readonly');
		document.getElementById('oec-adresse1Envoi').removeAttribute('readonly');
		document.getElementById('oec-adresse2Envoi').removeAttribute('readonly');
		document.getElementById('oec-adresse3Envoi').removeAttribute('readonly');
		document.getElementById('oec-codePostalEnvoi').removeAttribute('readonly');
		document.getElementById('oec-villeEnvoi').removeAttribute('readonly');
		document.getElementById('oec-codePaysEnvoi').disabled = false;
		document.getElementById('oec-civInterEnvoi').disabled = false;
		document.getElementById('oec-nomInterEnvoi').removeAttribute('readonly');
		document.getElementById('oec-prenomInterEnvoi').removeAttribute('readonly');
		document.getElementById('oec-telInter1Envoi').removeAttribute('readonly');
		document.getElementById('oec-telInter2Envoi').removeAttribute('readonly');
		document.getElementById('oec-faxInterEnvoi').removeAttribute('readonly');
		document.getElementById('oec-emailInterEnvoi').removeAttribute('readonly');
		document.getElementById('oec-denominationEF').removeAttribute('readonly');
		document.getElementById('oec-adresse1EF').removeAttribute('readonly');
		document.getElementById('oec-adresse2EF').removeAttribute('readonly');
		document.getElementById('oec-adresse3EF').removeAttribute('readonly');
		document.getElementById('oec-codePostalEF').removeAttribute('readonly');
		document.getElementById('oec-villeEF').removeAttribute('readonly');
		document.getElementById('oec-codePaysEF').disabled = false;
		document.getElementById('oec-civInterEF').disabled = false;
		document.getElementById('oec-nomInterEF').removeAttribute('readonly');
		document.getElementById('oec-prenomInterEF').removeAttribute('readonly');
		document.getElementById('oec-telInter1EF').removeAttribute('readonly');
		document.getElementById('oec-telInter2EF').removeAttribute('readonly');
		document.getElementById('oec-faxInterEF').removeAttribute('readonly');
		document.getElementById('oec-emailInterEF').removeAttribute('readonly');

		document.getElementById('oec-commentairesFin').disabled = false;
		document.getElementById('oec-commentairesInt').disabled = false;
		document.getElementById('oec-bChoisirMentions').disabled = false;
		document.getElementById('oec-bOuvrirCommentaires').disabled = false;
		document.getElementById('oec-modeReglement').disabled = false;
		document.getElementById('oec-bRemise').disabled = !oec_modifElemFin;
		document.getElementById('oec-remise').disabled = !oec_modifElemFin;
		document.getElementById('oec-fraisPort').disabled = !oec_modifElemFin;
		document.getElementById('oec-codeTVAFraisPort').disabled = !oec_modifElemFin;
		document.getElementById('oec-bRemiseFP').disabled = !oec_modifElemFin;
		document.getElementById('oec-remiseFP').disabled = !oec_modifElemFin;
		document.getElementById('oec-escompte').disabled = !oec_modifElemFin;
		document.getElementById('oec-bEnregistrer').disabled = false;

		document.getElementById('oec-codeStats').disabled = false;
		document.getElementById('oec-reference').disabled = false;
		document.getElementById('oec-designation').disabled = false;
		document.getElementById('oec-nbPieces').disabled = false;
		document.getElementById('oec-quantite').disabled = false;
		document.getElementById('oec-unite').disabled = false;
		document.getElementById('oec-depotLigne').disabled = false;
		document.getElementById('oec-dateExpeditionLC').disabled = false;
		document.getElementById('oec-PU').disabled = !oec_modifElemFin;
		document.getElementById('oec-ristourne').disabled = !oec_modifElemFin;
		document.getElementById('oec-codeTVA').disabled = !oec_modifElemFin;
		document.getElementById('oec-bValider').disabled = false;
		document.getElementById('oec-bAnnuler').disabled = false;
		document.getElementById('oec-bArticle').disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_checkPremiereCommande() {
	try {

		var qGet = new QueryHttp("Facturation/Affaires/getInfosAffaire.tmpl");
		qGet.setParam("Affaire_Id", ofa_affaireId);
		var result = qGet.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var contenu = result.responseXML.documentElement;

			var nbCommandes = parseIntBis(contenu.getAttribute("Nb_Commandes"));
			oec_premiereCommande = (oec_mode=="C"?nbCommandes==0:nbCommandes==1);

			if (!oec_premiereCommande) {
				oec_assujettiTVA = contenu.getAttribute("Assujetti_TVA")=="true";
				oec_editionTTC = contenu.getAttribute("Edition_TTC")=="true";
				document.getElementById('oec-assujettiTVA').checked = oec_assujettiTVA;
				document.getElementById('oec-editionTTC').checked = oec_editionTTC;
				document.getElementById('oec-numTVA').value = contenu.getAttribute("Numero_TVA");
				oec_listeTVA();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_nouvelleCommande() {
	try {

		oec_mode = "C";
		oec_commandeId = "";
		oec_reinitialiser();
		oec_listeTVAFraisPort();
		oec_chargerDepot(depotDefaut);
		oec_chargerEtablissement(etablissementDefaut);
		oec_chargerPolesActivite("");
		document.getElementById('oec-numAffaire').value = ofa_numAffaire;
		oec_initClient();
		oec_checkPremiereCommande();
		oec_debloquerChamps();
		oec_typeRistourne = 'P';
		document.getElementById('oec-bRistourne').setAttribute("class", "bIcoPourcentage");

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_chargerCommande() {
	try {

		oec_mode = "M";
		oec_reinitialiser();

		oec_aLignes.setParam("Commande_Id", oec_commandeId);
		oec_aLignes.initTree(oec_chargerCommande2);

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_chargerCommande2() {
  try {

		var qLoad = new QueryHttp("Facturation/Affaires/loadCommandeClient.tmpl");
		qLoad.setParam("Commande_Id", oec_commandeId);
		var result = qLoad.execute();

		var contenu = result.responseXML.documentElement;

		ofa_affaireId = contenu.getAttribute('Affaire_Id');

		oec_etatCommande = contenu.getAttribute("Etat");
		if (oec_etatCommande!='N') {
			oec_mode = "V";
		}

		oec_checkPremiereCommande();

		var numCommande = contenu.getAttribute('Num_Commande');
		document.getElementById('oec-numCommande').value = numCommande;

		oec_cloturable = contenu.getAttribute('Ctx_Cloturable')=="true";
		oec_soldee = contenu.getAttribute('Soldee')=="true";
		oec_typeRemise = (parseFloat(contenu.getAttribute('MRemise'))!=0?'M':'P');
		document.getElementById('oec-remise').value = (oec_typeRemise=='P'?contenu.getAttribute('PRemise'):contenu.getAttribute('MRemise'));
		document.getElementById('oec-bRemise').setAttribute("class", (oec_typeRemise=='P'?"bIcoPourcentage":"bIcoEuro"));

		oec_typeRemiseFP = (parseFloat(contenu.getAttribute('MRemise_FP'))!=0?'M':'P');
		document.getElementById('oec-remiseFP').value = (oec_typeRemiseFP=='P'?contenu.getAttribute('PRemise_FP'):contenu.getAttribute('MRemise_FP'));
		document.getElementById('oec-bRemiseFP').setAttribute("class", (oec_typeRemiseFP=='P'?"bIcoPourcentage":"bIcoEuro"));

		document.getElementById('oec-escompte').value = contenu.getAttribute('Escompte');
		oec_acompte = contenu.getAttribute('Acompte');
		document.getElementById('oec-fraisPort').value = contenu.getAttribute('Frais_Port');
		document.getElementById('oec-commentairesFin').value = contenu.getAttribute('Commentaires_Fin');
		document.getElementById('oec-commentairesInt').value = contenu.getAttribute('Commentaires_Int');
		document.getElementById('oec-dateCommande').value = contenu.getAttribute('Date_Commande');
		document.getElementById('oec-refCommande').value = contenu.getAttribute('Ref_Commande');
		document.getElementById('oec-intitule').value = contenu.getAttribute('Intitule');
		document.getElementById('oec-dateExpedition').value = contenu.getAttribute('Date_Expedition');
		document.getElementById('oec-dateLivraison').value = contenu.getAttribute('Date_Livraison');
		document.getElementById('oec-dateLivraisonFin').value = contenu.getAttribute('Date_Livraison_Fin');
		document.getElementById('oec-consignesLiv').value = contenu.getAttribute('Consignes_Liv');
		document.getElementById('oec-regleExpedition').value = contenu.getAttribute('Regle_Expedition');
		document.getElementById('oec-chkNonFacturable').checked = contenu.getAttribute('Non_Facturable')=="true";
		document.getElementById('oec-chkPaquetCadeau').checked = contenu.getAttribute('Paquet_Cadeau')=="true";
		document.getElementById('oec-chkPrioritaireLiv').checked = contenu.getAttribute('Prioritaire_Liv')=="true";
		document.getElementById('oec-chkExpeditionNeutre').checked = contenu.getAttribute('Expedition_Neutre')=="true";
		document.getElementById('oec-chkLivTransitaire').checked = contenu.getAttribute('Liv_Transitaire')=="true";
		document.getElementById('oec-noDropShipping').checked = contenu.getAttribute('No_Drop_Shipping')=="true";
		document.getElementById('oec-numDevisOrigine').value = contenu.getAttribute('Num_Devis_Origine');
		document.getElementById('oec-pointRetrait').value = contenu.getAttribute('Point_Retrait');
		document.getElementById('oec-coutTransport').value = contenu.getAttribute('Cout_Transport');
		document.getElementById('oec-numEngagement').value = contenu.getAttribute("Num_Engagement");
		document.getElementById('oec-codeService').value = contenu.getAttribute("Code_Service");
		oec_modeRegClient = contenu.getAttribute('Mode_Reg_Client');
		oec_chargerModesReglements(contenu.getAttribute('Mode_Reglement'));
		oec_chargerModesExpedition(contenu.getAttribute('Mode_Expedition'));
		oec_chargerDepot(contenu.getAttribute('Depot_Id'));
		oec_chargerEtablissement(contenu.getAttribute('Etab_Id'));
		oec_chargerTarifsVente(contenu.getAttribute('Tarif_Id'));
		document.getElementById('oec-numAffaire').value = contenu.getAttribute('Num_Affaire');

		document.getElementById('oec-denominationFact').value = contenu.getAttribute('Denomination');
		document.getElementById('oec-adresse1Fact').value = contenu.getAttribute('Adresse_1');
		document.getElementById('oec-adresse2Fact').value = contenu.getAttribute('Adresse_2');
		document.getElementById('oec-adresse3Fact').value = contenu.getAttribute('Adresse_3');
		document.getElementById('oec-codePostalFact').value = contenu.getAttribute('Code_Postal');
		document.getElementById('oec-villeFact').value = contenu.getAttribute('Ville');
		document.getElementById('oec-codePaysFact').value = contenu.getAttribute('Code_Pays');
		document.getElementById('oec-civInterFact').value = contenu.getAttribute('Civ_Inter');
		document.getElementById('oec-nomInterFact').value = contenu.getAttribute('Nom_Inter');
		document.getElementById('oec-prenomInterFact').value = contenu.getAttribute('Prenom_Inter');
		document.getElementById('oec-telInter1Fact').value = contenu.getAttribute('Tel_Inter_1');
		document.getElementById('oec-telInter2Fact').value = contenu.getAttribute('Tel_Inter_2');
		document.getElementById('oec-faxInterFact').value = contenu.getAttribute('Fax_Inter');
		document.getElementById('oec-emailInterFact').value = contenu.getAttribute('Email_Inter');

		document.getElementById('oec-denominationLiv').value = contenu.getAttribute('Denomination_Liv');
		document.getElementById('oec-adresse1Liv').value = contenu.getAttribute('Adresse_1_Liv');
		document.getElementById('oec-adresse2Liv').value = contenu.getAttribute('Adresse_2_Liv');
		document.getElementById('oec-adresse3Liv').value = contenu.getAttribute('Adresse_3_Liv');
		document.getElementById('oec-codePostalLiv').value = contenu.getAttribute('Code_Postal_Liv');
		document.getElementById('oec-villeLiv').value = contenu.getAttribute('Ville_Liv');
		document.getElementById('oec-codePaysLiv').value = contenu.getAttribute('Code_Pays_Liv');
		document.getElementById('oec-civInterLiv').value = contenu.getAttribute('Civ_Inter_Liv');
		document.getElementById('oec-nomInterLiv').value = contenu.getAttribute('Nom_Inter_Liv');
		document.getElementById('oec-prenomInterLiv').value = contenu.getAttribute('Prenom_Inter_Liv');
		document.getElementById('oec-telInter1Liv').value = contenu.getAttribute('Tel_Inter_1_Liv');
		document.getElementById('oec-telInter2Liv').value = contenu.getAttribute('Tel_Inter_2_Liv');
		document.getElementById('oec-faxInterLiv').value = contenu.getAttribute('Fax_Inter_Liv');
		document.getElementById('oec-emailInterLiv').value = contenu.getAttribute('Email_Inter_Liv');

		document.getElementById('oec-denominationEnvoi').value = contenu.getAttribute('Denomination_Envoi');
		document.getElementById('oec-adresse1Envoi').value = contenu.getAttribute('Adresse_1_Envoi');
		document.getElementById('oec-adresse2Envoi').value = contenu.getAttribute('Adresse_2_Envoi');
		document.getElementById('oec-adresse3Envoi').value = contenu.getAttribute('Adresse_3_Envoi');
		document.getElementById('oec-codePostalEnvoi').value = contenu.getAttribute('Code_Postal_Envoi');
		document.getElementById('oec-villeEnvoi').value = contenu.getAttribute('Ville_Envoi');
		document.getElementById('oec-codePaysEnvoi').value = contenu.getAttribute('Code_Pays_Envoi');
		document.getElementById('oec-civInterEnvoi').value = contenu.getAttribute('Civ_Inter_Envoi');
		document.getElementById('oec-nomInterEnvoi').value = contenu.getAttribute('Nom_Inter_Envoi');
		document.getElementById('oec-prenomInterEnvoi').value = contenu.getAttribute('Prenom_Inter_Envoi');
		document.getElementById('oec-telInter1Envoi').value = contenu.getAttribute('Tel_Inter_1_Envoi');
		document.getElementById('oec-telInter2Envoi').value = contenu.getAttribute('Tel_Inter_2_Envoi');
		document.getElementById('oec-faxInterEnvoi').value = contenu.getAttribute('Fax_Inter_Envoi');
		document.getElementById('oec-emailInterEnvoi').value = contenu.getAttribute('Email_Inter_Envoi');

		document.getElementById('oec-denominationEF').value = contenu.getAttribute('Denomination_EF');
		document.getElementById('oec-adresse1EF').value = contenu.getAttribute('Adresse_1_EF');
		document.getElementById('oec-adresse2EF').value = contenu.getAttribute('Adresse_2_EF');
		document.getElementById('oec-adresse3EF').value = contenu.getAttribute('Adresse_3_EF');
		document.getElementById('oec-codePostalEF').value = contenu.getAttribute('Code_Postal_EF');
		document.getElementById('oec-villeEF').value = contenu.getAttribute('Ville_EF');
		document.getElementById('oec-codePaysEF').value = contenu.getAttribute('Code_Pays_EF');
		document.getElementById('oec-civInterEF').value = contenu.getAttribute('Civ_Inter_EF');
		document.getElementById('oec-nomInterEF').value = contenu.getAttribute('Nom_Inter_EF');
		document.getElementById('oec-prenomInterEF').value = contenu.getAttribute('Prenom_Inter_EF');
		document.getElementById('oec-telInter1EF').value = contenu.getAttribute('Tel_Inter_1_EF');
		document.getElementById('oec-telInter2EF').value = contenu.getAttribute('Tel_Inter_2_EF');
		document.getElementById('oec-faxInterEF').value = contenu.getAttribute('Fax_Inter_EF');
		document.getElementById('oec-emailInterEF').value = contenu.getAttribute('Email_Inter_EF');

		document.getElementById('oec-regimeTVA').value = contenu.getAttribute('Regime_TVA');
		oec_codeTVAPort = contenu.getAttribute('Code_TVA_Port');
		oec_tauxTVAPort = contenu.getAttribute('Taux_TVA_Port');

		oec_assujettiTVA = contenu.getAttribute('Assujetti_TVA')=="true";
		oec_bloque = contenu.getAttribute('Bloque')=="true";
		oec_codesTvaInactifs = contenu.getAttribute('Codes_TVA_Inactifs');

		var typeEdition = contenu.getAttribute('Edition_TTC')=="true";

		document.getElementById('oec-editionTTC').checked = typeEdition;
		document.getElementById('oec-assujettiTVA').checked = oec_assujettiTVA;
		document.getElementById('oec-numTVA').value = contenu.getAttribute("Num_TVA_Intra");

		oec_clientId = contenu.getAttribute('Client_Id');
		var clientConnu = !isEmpty(oec_clientId);
		document.getElementById('oec-numClient').value = contenu.getAttribute('Num_Client');
		document.getElementById('oec-familleClient').value = contenu.getAttribute('Famille_Client');

		oec_chargerResponsables(contenu.getAttribute('Util_R'));

		document.getElementById('oec-creation').setAttribute("label", "Commande cr\u00E9\u00E9e le "+ contenu.getAttribute('Date_Creation') +" par "+ contenu.getAttribute('Login_Createur'));
		document.getElementById('oec-modification').setAttribute("label", "Derni\u00E8re modification le "+ contenu.getAttribute('Date_Maj') +" par "+ contenu.getAttribute('Login_Maj'));
		document.getElementById('oec-fiche').setAttribute("label", "Commande N\u00B0 "+ numCommande);
		document.getElementById('oec-creation').collapsed = false;
		document.getElementById('oec-modification').collapsed = false;

		var libelleEtat = "";
		if (oec_etatCommande=="N") { libelleEtat = "Non valid\u00E9e"; }
		else if (oec_etatCommande=="C") { libelleEtat = "Cl\u00F4tur\u00E9e"; }
		else if (oec_etatCommande=="A") { libelleEtat = "Annul\u00E9e"; }
		else if (oec_etatCommande=="T") { libelleEtat = "En cours"; }
		document.getElementById('oec-etatCommande').value = libelleEtat;

		oec_existeBL = (contenu.getAttribute("Existe_BL")=="true");
		oec_existeFacture = (contenu.getAttribute("Existe_Facture")=="true");
		var acomptePossible = ((oec_etatCommande=="N" || (oec_etatCommande=="T" && !oec_existeFacture)) && contenu.getAttribute("Autoriser_Acompte")=="true");
		document.getElementById('oec-boxNouvelAcompte').collapsed = !acomptePossible || gReadOnly;

		document.getElementById('oec-bImporterLignes').disabled = (oec_bloque || oec_etatCommande!="N");
		document.getElementById('oec-bExporterLignes').disabled = (oec_aLignes.nbLignes()==0);
		document.getElementById('oec-bEditerOF').collapsed = oec_etatCommande=="N" || contenu.getAttribute("Existe_OF")=="false";

		var statutPaiement = contenu.getAttribute("Statut_Paiement");
		var libelleStatutPaiement = "";
		if (statutPaiement=="N") { libelleStatutPaiement = "Non pay\u00E9e"; }
		else if (statutPaiement=="T") { libelleStatutPaiement = "Pay\u00E9e"; }
		else if (statutPaiement=="P") { libelleStatutPaiement = "Part. pay\u00E9e"; }
		document.getElementById('oec-statutPaiement').value = libelleStatutPaiement;
		oec_chargerPolesActivite(contenu.getAttribute('Pole_Activite'));

		document.getElementById('oec-bEnvoyerLPE').collapsed = !oec_accesLPE || (oec_etatCommande!="T" && oec_etatCommande!="N") || statutPaiement=="T" || gReadOnly;

		// Infos spcifiques Web
		document.getElementById('oec-rowLoginWeb').collapsed = (contenu.getAttribute('Web')=="false");
		document.getElementById('oec-labelLogin').value = contenu.getAttribute('Login_Web');
		document.getElementById('oec-tabWeb').collapsed = (contenu.getAttribute('Web')=="false");
		document.getElementById('oec-siteOrigine').value = contenu.getAttribute('Nom_Site');
		document.getElementById('oec-refComWeb').value = contenu.getAttribute('Ref_Com_Web');
		document.getElementById('oec-refMarketplace').value = contenu.getAttribute('Ref_Market_Place');
		document.getElementById('oec-marketplace').value = contenu.getAttribute('Marketplace');
		document.getElementById('oec-rowRefMarketplace').collapsed = isEmpty(document.getElementById('oec-refMarketplace').value);
		document.getElementById('oec-rowMarketplace').collapsed = isEmpty(document.getElementById('oec-marketplace').value);

		document.getElementById('oec-lien').value = contenu.getAttribute('Lien') + parent.document.getElementById("login").value;
		document.getElementById('oec-lien').collapsed = isEmpty(contenu.getAttribute('Lien'));

		// Acomptes
		oec_aAcomptes.setParam("Commande_Id", oec_commandeId);
		oec_aAcomptes.initTree();

		// Encaissements
		if (oec_etatCommande!="N") {
			var existeAcompte = (contenu.getAttribute("Existe_Acompte")=="true");
			document.getElementById('oec-boxReglement').collapsed = gReadOnly;
			document.getElementById('oec-bNouveauReglement').collapsed = (oec_existeFacture || oec_etatCommande!="T");
			document.getElementById('oec-bAffecterAvoir').collapsed = (!oec_gacAffAvoirCC || oec_existeFacture || oec_etatCommande!="T");
			document.getElementById('oec-tabEncaissements').collapsed = false;
			document.getElementById('oec-caTTCFacture').value = contenu.getAttribute("CA_TTC_Facture");
			document.getElementById('oec-caTTCPaye').value = contenu.getAttribute("CA_TTC_Paye");
			document.getElementById('oec-pourcCATTCPaye').value = contenu.getAttribute("Pourc_CA_TTC_Paye");
			document.getElementById('oec-soldeAEncaisser').value = contenu.getAttribute("Solde_A_Encaisser");
			document.getElementById('oec-pourcSoldeAEncaisser').value = contenu.getAttribute("Pourc_Solde_A_Encaisser");
			document.getElementById('oec-encoursAutorise').value = contenu.getAttribute("En_Cours_Autorise") +" \u20AC";
			document.getElementById('oec-encoursActuel').value = contenu.getAttribute("En_Cours_Actuel") +" \u20AC";

			oec_aListeReglements.setParam("Commande_Id", oec_commandeId);
			oec_aListeReglements.initTree(oec_initListeReglements);
		}

		if (oec_etatCommande!='N' || gConfig.isHistoAvantValidCC()) {
			document.getElementById('oec-tabHistorique').collapsed = false;
			document.getElementById('oec-bEditionInitiale').collapsed = oec_etatCommande=="N";
			document.getElementById('oec-histoAvantVal').collapsed = oec_etatCommande=="N" || !gConfig.isHistoAvantValidCC();
			document.getElementById('oec-histoAvantVal').checked = oec_etatCommande=="N";
			oec_listerHistorique();
		}
		else {
			document.getElementById('oec-tabHistorique').collapsed = true;
			oec_aListeHistorique.deleteTree();
		}

		// En-cours client
		if (!clientConnu) { document.getElementById('oec-boxEncoursClient').collapsed = true; }

		if ((oec_etatCommande=="T" || oec_etatCommande=="N") && (contenu.getAttribute("Client_Bloque")=="true" || contenu.getAttribute("Encours_Client_Depasse")=="true" || contenu.getAttribute("Encours_Facturation_Depasse")=="true")) {
			document.getElementById('oec-boxWarning').collapsed = false;
			if (contenu.getAttribute("Encours_Client_Depasse")=="true") {
				document.getElementById('oec-depEncoursClient').collapsed = false;
			}
			if (contenu.getAttribute("Encours_Facturation_Depasse")=="true") {
				document.getElementById('oec-depEncoursFacturation').collapsed = false;
			}
			if (contenu.getAttribute("Client_Bloque")=="true") {
				document.getElementById('oec-alerteClientBloque').collapsed = false;
			}
		}

		if (clientConnu) {
			document.getElementById('oec-indications').value = contenu.getAttribute("Indications");

			var francoPort = contenu.getAttribute('Franco_Port')=="true";
			var montantFranco = contenu.getAttribute("Montant_Franco");
			oec_majFrancoPort(francoPort, montantFranco);
		}

		if (contenu.getAttribute("Existe_Colis")=="true") {
			oec_aLiensColis.setParam("Commande_Id", oec_commandeId);
			oec_aLiensColis.initTree();
			document.getElementById('oec-tabColis').collapsed = false;
		}

		document.getElementById('oec-tabVersionDocument').collapsed=false;
		oec_initVersion();

		oec_modifie = false;
		document.getElementById('oec-tabCommande').setAttribute('image', gReadOnly?'chrome://opensi/content/design/icones/readonly.png':null);

		if (oec_mode == "V") {
			document.getElementById('oec-bSolder').disabled = (oec_etatCommande!='T' || oec_soldee || oec_bloque);
			document.getElementById('oec-bModifier').disabled = (oec_etatCommande!='T');
			document.getElementById('oec-bModifier').collapsed = (oec_etatCommande!='T' || gReadOnly);
		}
		else {
			oec_debloquerChamps();
			document.getElementById('oec-bChercherAdrFact').disabled = !clientConnu;
			document.getElementById('oec-bChercherInter').disabled = !clientConnu;
			document.getElementById('oec-bChercherAdrLiv').disabled = !clientConnu;
			document.getElementById('oec-bChercherInterLiv').disabled = !clientConnu;
			document.getElementById('oec-bChercherAdrEnvoi').disabled = !clientConnu;
			document.getElementById('oec-bChercherAdrEF').disabled = !clientConnu;
			document.getElementById('oec-bChercherInterEnvoi').disabled = !clientConnu;
			document.getElementById('oec-bChercherInterEF').disabled = !clientConnu;
			document.getElementById('oec-bValiderCommande').disabled = false;
			document.getElementById('oec-numTVA').disabled = !oec_assujettiTVA;
			oec_ajouterLigne("I");
		}
		document.getElementById('oec-bVoirFichier').disabled = false;
		document.getElementById('oec-bAnnulerCommande').disabled = (oec_etatCommande=="A" || oec_etatCommande=="C" || oec_bloque);
		document.getElementById('oec-bOuvrirCommentairesCaches').disabled = false;
		document.getElementById('oec-bOuvrirCommentaires').disabled = false;
		document.getElementById('oec-bVisualiser').disabled = false;
		document.getElementById('oec-bEditionInitiale').collapsed = (oec_etatCommande=="N");
		document.getElementById('oec-bCopierCommande').collapsed = gReadOnly;
		document.getElementById('oec-bProforma').collapsed = (oec_etatCommande=="A" || oec_etatCommande=="C" || gReadOnly);

		document.getElementById('oec-bBloquer').disabled = ((oec_etatCommande!='T' && oec_etatCommande!='N') || oec_bloque);
		document.getElementById('oec-bBloquer').collapsed = ((oec_etatCommande!='T' && oec_etatCommande!='N') || oec_bloque || gReadOnly);
		document.getElementById('oec-bDebloquer').disabled = ((oec_etatCommande!='T' && oec_etatCommande!='N') || !oec_bloque);
		document.getElementById('oec-bDebloquer').collapsed = ((oec_etatCommande!='T' && oec_etatCommande!='N') || !oec_bloque || gReadOnly);

		document.getElementById('oec-bCloturer').collapsed = !oec_cloturable || gReadOnly;
		document.getElementById('oec-bDecloturer').collapsed = oec_etatCommande!='C' || gReadOnly;

		document.getElementById('oec-bSolder').collapsed = oec_etatCommande!='T' || gReadOnly;
		document.getElementById('oec-bAnnulerCommande').collapsed = oec_etatCommande=='A' || oec_etatCommande=='C' || (gReadOnly && !gProfil.isAnnulationCC());
		document.getElementById('oec-bEnregistrer').collapsed = oec_etatCommande=='A' || oec_etatCommande=='C' || gReadOnly;
		document.getElementById('oec-bValiderCommande').collapsed = oec_etatCommande!='N' || (gReadOnly && !gProfil.isValidationCC());

		document.getElementById('oec-tabAcomptes').collapsed = false;
		document.getElementById('oec-tabSuivi').collapsed = false;

		document.getElementById('oec-colStock').setAttribute("hidden", !oec_calculStock || oec_etatCommande!='T');
		document.getElementById('oec-colFournisseur').setAttribute("hidden", !oec_calculStock || oec_etatCommande!='T');

		oec_changerTypeEdition(typeEdition);

    oec_aCodesTVAFraisPort.setParam("Code_Pays", document.getElementById("oec-codePaysLiv").value);
    oec_aCodesTVAFraisPort.setParam("Regime_TVA", document.getElementById("oec-regimeTVA").value);
    oec_aCodesTVAFraisPort.setParam("Assujetti_TVA", oec_assujettiTVA);
		oec_aCodesTVAFraisPort.setParam("Selection", oec_codeTVAPort);
    oec_aCodesTVAFraisPort.initTree(oec_selectionTvaPort);

		oec_calculerPoids();
		oec_loadRecapitulatif();

		document.getElementById('oec-suiviMagento').collapsed = (contenu.getAttribute('Web')=="false");
		document.getElementById('oec-colEnvoiClient').collapsed = (contenu.getAttribute('Web')=="false");
		document.getElementById('oec-colVisibleClient').collapsed = (contenu.getAttribute('Web')=="false");

		oec_aSuivi.setParam("Commande_Id", oec_commandeId);
		oec_aSuivi.initTree();
		oec_nouveauMessageSuivi();

	} catch (e) {
    recup_erreur(e);
  }
}


function oec_selectionTvaPort() {
  try {

   	document.getElementById('oec-codeTVAFraisPort').value = oec_codeTVAPort;
		oec_tauxTVAPort = getTva(oec_codeTVAPort);
		oec_selectPaysLiv();

  } catch (e) {
    recup_erreur(e);
  }
}


function oec_formatLigne(typeLigne) {
  try {

		switch(typeLigne) {
			case "S":
				document.getElementById('oec-codeStats').disabled = false;
				document.getElementById('oec-reference').disabled = true;
				document.getElementById('oec-designation').disabled = true;
				document.getElementById('oec-nbPieces').disabled = false;
				document.getElementById('oec-quantite').disabled = false;
				document.getElementById('oec-unite').disabled = false;
				document.getElementById('oec-depotLigne').disabled = false;
				document.getElementById('oec-dateExpeditionLC').disable = false;
				document.getElementById('oec-PU').disabled = !oec_modifElemFin;
				document.getElementById('oec-ristourne').disabled = !oec_modifElemFin;
				document.getElementById('oec-bRistourne').disabled = !oec_modifElemFin;
				document.getElementById('oec-codeTVA').disabled = !oec_modifElemFin;
				document.getElementById('oec-bValider').disabled = false;
				document.getElementById('oec-bAnnuler').disabled = false;
				break;

			case "I":
				document.getElementById('oec-codeStats').disabled = false;
				document.getElementById('oec-reference').disabled = false;
				document.getElementById('oec-designation').disabled = false;
				document.getElementById('oec-nbPieces').disabled = false;
				document.getElementById('oec-quantite').disabled = false;
				document.getElementById('oec-unite').disabled = false;
				document.getElementById('oec-depotLigne').disabled = false;
				document.getElementById('oec-dateExpeditionLC').disable = false;
				document.getElementById('oec-PU').disabled = !oec_modifElemFin;
				document.getElementById('oec-ristourne').disabled = !oec_modifElemFin;
				document.getElementById('oec-bRistourne').disabled = !oec_modifElemFin;
				document.getElementById('oec-codeTVA').disabled = !oec_modifElemFin;
				document.getElementById('oec-bValider').disabled = false;
				document.getElementById('oec-bAnnuler').disabled = false;
				break;

			default:
				document.getElementById('oec-codeStats').value = "";
				document.getElementById('oec-reference').value = "";
				document.getElementById('oec-designation').value = "";
				document.getElementById('oec-nbPieces').value = "";
				document.getElementById('oec-quantite').value = "";
				document.getElementById('oec-unite').value = oec_uniteDefaut;
				document.getElementById('oec-PU').value = "";
				document.getElementById('oec-ristourne').value = "";
				document.getElementById('oec-dateExpeditionLC').value = "";
				oec_libelle = "";
				oec_ligneId = "";
				document.getElementById('oec-codeTVA').value = getCodeTvaNormal(document.getElementById('oec-codePaysLiv').value, oec_assujettiTVA, document.getElementById('oec-regimeTVA').value);
				document.getElementById('oec-codeStats').disabled = true;
				document.getElementById('oec-reference').disabled = true;
				document.getElementById('oec-designation').disabled = true;
				document.getElementById('oec-nbPieces').disabled = true;
				document.getElementById('oec-quantite').disabled = true;
				document.getElementById('oec-unite').disabled = true;
				document.getElementById('oec-depotLigne').disabled = true;
				document.getElementById('oec-dateExpeditionLC').disable = true;
				document.getElementById('oec-PU').disabled = true;
				document.getElementById('oec-ristourne').disabled = true;
				document.getElementById('oec-bRistourne').disabled = true;
				document.getElementById('oec-codeTVA').disabled = true;
				document.getElementById('oec-bSupprimer').disabled = true;
				document.getElementById('oec-bMoveUp').disabled = true;
				document.getElementById('oec-bMoveDown').disabled = true;
				document.getElementById('oec-bMoveFirst').disabled = true;
				document.getElementById('oec-bMoveLast').disabled = true;
				document.getElementById('oec-bMultiSuppression').disabled = true;
				document.getElementById('oec-bCommentaire').disabled = true;
				document.getElementById('oec-bValider').disabled = true;
				document.getElementById('oec-bAnnuler').disabled = true;
				break;
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oec_selectPaysLiv() {
	try {

		oec_listeTVA();
    oec_changerTypeVente();

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_listeTVA() {
  try {

  	oec_calculTotaux();

    oec_aCodesTVA.setParam("Code_Pays", document.getElementById("oec-codePaysLiv").value);
    oec_aCodesTVA.setParam("Regime_TVA", document.getElementById("oec-regimeTVA").value);
    oec_aCodesTVA.setParam("Assujetti_TVA", oec_assujettiTVA);
		oec_aCodesTVA.setParam("Selection", oec_codesTvaInactifs);
    oec_aCodesTVA.initTree(oec_selectTVA);

  } catch (e) {
    recup_erreur(e);
  }
}


function oec_selectTVA() {
  try {

    document.getElementById('oec-codeTVA').value = getCodeTvaNormal(document.getElementById('oec-codePaysLiv').value, oec_assujettiTVA, document.getElementById('oec-regimeTVA').value);

  } catch (e) {
    recup_erreur(e);
  }
}


function oec_listeTVAFraisPort() {
  try {

    oec_aCodesTVAFraisPort.setParam("Code_Pays", document.getElementById("oec-codePaysLiv").value);
    oec_aCodesTVAFraisPort.setParam("Regime_TVA", document.getElementById("oec-regimeTVA").value);
    oec_aCodesTVAFraisPort.setParam("Assujetti_TVA", oec_assujettiTVA);
		oec_aCodesTVAFraisPort.setParam("Selection", oec_codeTVAPort);
    oec_aCodesTVAFraisPort.initTree(oec_finListeTVAFraisPort);

  } catch (e) {
    recup_erreur(e);
  }
}


function oec_finListeTVAFraisPort() {
  try {

   	document.getElementById('oec-codeTVAFraisPort').value = getCodeTvaNormal(document.getElementById('oec-codePaysLiv').value, oec_assujettiTVA, document.getElementById('oec-regimeTVA').value);
   	oec_codeTVAPort = document.getElementById('oec-codeTVAFraisPort').value;
		oec_tauxTVAPort = getTva(oec_codeTVAPort);

  } catch (e) {
    recup_erreur(e);
  }
}


function oec_switchRistourne() {
	try {

		if (oec_typeRistourne=='P') {
			document.getElementById('oec-bRistourne').setAttribute("class", "bIcoEuro");
			oec_typeRistourne = 'M';
		}
		else {
			document.getElementById('oec-bRistourne').setAttribute("class", "bIcoPourcentage");
			oec_typeRistourne = 'P';
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oec_switchRemise() {
	try {

		if (oec_typeRemise=='P') {
			document.getElementById('oec-bRemise').setAttribute("class", "bIcoEuro");
			oec_typeRemise = 'M';
		}
		else {
			document.getElementById('oec-bRemise').setAttribute("class", "bIcoPourcentage");
			oec_typeRemise = 'P';
		}
		oec_calculTotaux();
		oec_setModified(true);

	} catch (e) {
    recup_erreur(e);
  }
}


function oec_switchRemiseFP() {
	try {

		if (oec_typeRemiseFP=='P') {
			document.getElementById('oec-bRemiseFP').setAttribute("class", "bIcoEuro");
			oec_typeRemiseFP = 'M';
		}
		else {
			document.getElementById('oec-bRemiseFP').setAttribute("class", "bIcoPourcentage");
			oec_typeRemiseFP = 'P';
		}
		oec_calculTotaux();
		oec_setModified(true);

	} catch (e) {
    recup_erreur(e);
  }
}


function oec_afficherFichiers() {
	try {

    var ok = true;
		if (oec_mode=="C") {
			ok = oec_enregistrerCommande(true);
		}

		if (ok) {
  	  var url = "chrome://opensi/content/facturation/user/commun/popup-fichiersAssocies.xul";
    	window.openDialog(url,'','chrome,modal,centerscreen', "CC", oec_commandeId, gReadOnly);
    }

	} catch (e) {
    recup_erreur(e);
  }
}


function oec_ajouterLigne(typeLigne, articleId) {
  try {

  	document.getElementById('oec-bSupprimer').disabled = true;
		document.getElementById('oec-bMoveUp').disabled = true;
		document.getElementById('oec-bMoveDown').disabled = true;
		document.getElementById('oec-bMoveFirst').disabled = true;
		document.getElementById('oec-bMoveLast').disabled = true;
		document.getElementById('oec-bMultiSuppression').disabled = true;
		document.getElementById('oec-bCommentaire').disabled = true;

		oec_modeLigne = "C";
		oec_typeLigne = typeLigne;
		oec_ligneId = "";

		oec_formatLigne(typeLigne);
		var codePaysLiv = document.getElementById('oec-codePaysLiv').value;
		var regimeTVA = document.getElementById('oec-regimeTVA').value;

		if (typeLigne=="S") {
			oec_articleId = articleId;
			var typeArticle = "";

			var reference = document.getElementById("oec-reference").value;

			if (oec_alerteDoublonLigne && oec_mode!="C" && oec_dejaPresente(reference)) {
				showWarning("Attention, cet article est d\u00E9j\u00E0 pr\u00E9sent dans la commande");
			}

			if (oec_modeTarif=='Q') {
				var url = "chrome://opensi/content/facturation/user/commun/popup-choixTarif.xul";
    		window.openDialog(url,'','chrome,modal,centerscreen', oec_retourChoixPrixQuantite, articleId);

				if (!isEmpty(oec_prixId)) {
					var qGet = new QueryHttp("Facturation/Articles/getInfosArticleQuantite.tmpl");
        	qGet.setParam("Article_Id", articleId);
        	qGet.setParam("Prix_Id", oec_prixId);
					qGet.setParam("TTC", oec_editionTTC);
					var result = qGet.execute();

					var contenu = result.responseXML.documentElement;
					if (isEmpty(document.getElementById('oec-codeStats').value)) {
						document.getElementById('oec-codeStats').value = contenu.getAttribute("Code_Stats");
					}
					document.getElementById('oec-designation').value = contenu.getAttribute("Designation");
					document.getElementById('oec-nbPieces').value = "";
					document.getElementById('oec-quantite').value = contenu.getAttribute("Quantite");
					document.getElementById('oec-unite').value = contenu.getAttribute("Unite_Id");
					document.getElementById('oec-PU').value = contenu.getAttribute("Prix_Unitaire");
					document.getElementById('oec-ristourne').value = "0.00";
					document.getElementById('oec-codeTVA').value = getCodeTvaCorrespondant(contenu.getAttribute("Code_TVA"), codePaysLiv, oec_assujettiTVA, regimeTVA);
					document.getElementById('oec-dateExpeditionLC').value = "";
					document.getElementById('oec-depotLigne').value = oec_curDepot;
					oec_prixId = "";
					oec_libelle = contenu.getAttribute("Libelle");
					typeArticle = contenu.getAttribute("Type_Article");
				}
				else {
					oec_ajouterLigne("I");
				}
			}
			else {
				var qGet = new QueryHttp("Facturation/Articles/getInfosArticleVente.tmpl");
        qGet.setParam("Article_Id", articleId);
        qGet.setParam("Tarif_Id", document.getElementById('oec-tarifVente').value);
				qGet.setParam("TTC", oec_editionTTC);
				qGet.setParam("Client_Id", oec_clientId);
				var result = qGet.execute();

				var contenu = result.responseXML.documentElement;
				if (isEmpty(document.getElementById('oec-codeStats').value)) {
					document.getElementById('oec-codeStats').value = contenu.getAttribute("Code_Stats");
				}
				document.getElementById('oec-designation').value = contenu.getAttribute("Designation");
				document.getElementById('oec-nbPieces').value = "";
				document.getElementById('oec-quantite').value = 1;
				document.getElementById('oec-unite').value = contenu.getAttribute("Unite_Id");
				document.getElementById('oec-PU').value = contenu.getAttribute("Prix_Unitaire");
				document.getElementById('oec-ristourne').value = contenu.getAttribute("Ristourne");
				document.getElementById('oec-codeTVA').value = getCodeTvaCorrespondant(contenu.getAttribute("Code_TVA"), codePaysLiv, oec_assujettiTVA, regimeTVA);
				document.getElementById('oec-dateExpeditionLC').value = "";
				oec_libelle = "";
				typeArticle = contenu.getAttribute("Type_Article");
				if (oec_actDepotLigneCC) {
					var codePostalLiv = document.getElementById('oec-codePostalLiv').value;
					var codePaysLiv = document.getElementById('oec-codePaysLiv').value;
					var qTheoDepot = new QueryHttp("Facturation/Affaires/getTheoreticalDepot.tmpl");
					qTheoDepot.setParam("Article_Id", articleId);
					qTheoDepot.setParam("Code_Postal_Liv", codePostalLiv);
					qTheoDepot.setParam("Code_Pays_Liv", codePaysLiv);
					var result2 = qTheoDepot.execute();
					var theoDepot = result2.responseXML.documentElement.getAttribute("Depot_Id");
					document.getElementById('oec-depotLigne').value = (isEmpty(theoDepot)?oec_curDepot:theoDepot);
				}
				else {
					document.getElementById('oec-depotLigne').value = oec_curDepot;
				}
			}
			// apercu article
			if (typeArticle=="F") {
				document.getElementById("oec-tabBoxAdresses").collapsed = true;
				document.getElementById("oec-boxApercuArticle").collapsed = false;
				document.getElementById("oec-apercuReference").value = document.getElementById("oec-reference").value;
				document.getElementById("oec-apercuDesignation").value = contenu.getAttribute("Designation");
				document.getElementById('oec-colStockCL').setAttribute("hidden", true);
				document.getElementById('oec-colStockCL').setAttribute("ignoreincolumnpicker", true);
				document.getElementById('oec-colQteTotaleCL').setAttribute("hidden", true);
				document.getElementById('oec-colQteTotaleCL').setAttribute("ignoreincolumnpicker", true);
				oec_aComposantsLigne.setParam("Article_Id", articleId);
				oec_aComposantsLigne.initTree();
			}
		}
		else {
			oec_articleId = "";
			document.getElementById('oec-codeStats').value = "";
			document.getElementById('oec-reference').value = "";
			document.getElementById('oec-designation').value = "";
			document.getElementById('oec-nbPieces').value = "";
			document.getElementById('oec-quantite').value = 1;
			document.getElementById('oec-unite').value = oec_uniteDefaut;
			document.getElementById('oec-PU').value = "";
			document.getElementById('oec-ristourne').value = "0.00";
			document.getElementById('oec-codeTVA').value = getCodeTvaNormal(codePaysLiv, oec_assujettiTVA, regimeTVA);
			document.getElementById('oec-dateExpeditionLC').value = "";
			document.getElementById('oec-depotLigne').value = oec_curDepot;
			oec_libelle = "";
			document.getElementById('oec-reference').focus();
			oec_insertionLigneId = 0;
			document.getElementById('oec-bAjouterLigne').disabled = true;
			document.getElementById('oec-actInsert').collapsed = true;
			oec_aLignes.setCellSrc(oec_currentIndex, 'oec-colReference', "");
			document.getElementById("oec-tabBoxAdresses").collapsed = false;
			document.getElementById("oec-boxApercuArticle").collapsed = true;
			oec_aComposantsLigne.deleteTree();
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oec_ajouterLigneAvant() {
  try {

		if (oec_aLignes.isSelected() && oec_mode=="M") {
			var idx = oec_aLignes.getCurrentIndex();
			var ligneId = oec_aLignes.getCellText(idx,'oec-colLigneId');
			oec_annulerLigne();
			oec_aLignes.setCellSrc(idx, 'oec-colReference', "chrome://opensi/content/design/insertbefore.png");
			oec_insertionLigneId = ligneId;
			oec_currentIndex = idx;
			document.getElementById('oec-actInsert').collapsed = false;
			document.getElementById('oec-reference').focus();
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oec_pressOnLigneCommande(event) {
	try {

		if (event.keyCode==45 && event.ctrlKey) {
			// ctrl + inser
			// insrer une ligne avant

			oec_ajouterLigneAvant();
		}
	} catch (e) {
		recup_erreur(e);
	}
}


function oec_pressOnWindow(ev) {
	try {

		if (ev.altKey && oec_mode!="V") {
			switch(ev.charCode) {
      	case 97: // 'a'
				case 65: // 'A'
					oec_rechercherStock();
        	break;
				case 116: // 't'
					oec_modifierTarif();
					break;
    	}
		}
		else if (ev.ctrlKey && oec_mode!="V") {
			if (ev.keyCode==46) {
				// ctrl + suppr
				ev.preventDefault();
				oec_supprimerLigne();
			}
			else if (ev.charCode==114 || ev.charCode==82) {
				// ctrl + r (ou R)
				ev.preventDefault();
				oec_appliquerRistourne();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oec_pressOnReference(ev) {
	try {

		if (ev.keyCode==13) {
			oec_rechercherReference();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oec_rechercherStock(reference) {
	try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
		var tarifId = (oec_modeTarif!="Q"?document.getElementById('oec-tarifVente').value:null);
		var multiSel = (oec_modeTarif!="Q"?true:null);
    window.openDialog(url,'','chrome,modal,centerscreen', oec_retourRechercherStock, "V", reference, tarifId, null, null, null, oec_clientId, multiSel);

	} catch (e) {
    recup_erreur(e);
  }
}


function oec_retourRechercherStock(reference, articleId, listArticleId) {
	try {

		if (articleId!=null) {
			document.getElementById('oec-reference').value = reference;
			document.getElementById('oec-quantite').focus();
			oec_ajouterLigne("S", articleId);
		}
		else {
			oec_ajouterMulti(listArticleId);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oec_rechercherReference() {
	try {

		var reference = document.getElementById('oec-reference').value;

		var qSearch = new QueryHttp("Facturation/Articles/searchReference.tmpl");
		qSearch.setParam("Reference", reference);
		qSearch.setParam("Vente_Achat", "V");
		var result = qSearch.execute();

		var articleId = result.responseXML.documentElement.getAttribute("Article_Id");
		if (!isEmpty(articleId)) {
			document.getElementById('oec-reference').value = result.responseXML.documentElement.getAttribute("Reference");
			document.getElementById('oec-quantite').focus();
			oec_ajouterLigne("S", articleId);
		}
		else {
			oec_rechercherStock(reference);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oec_ajouterMulti(listArticleId) {
	try {

		var ok = true;

		if (oec_mode=="C") {
			ok = oec_enregistrerCommande(true);
		}

		if (ok) {
			var qAdd = new QueryHttp("Facturation/Affaires/addLigneCommandeClient.tmpl");
			qAdd.setParam("List_Article_Id", listArticleId);
			qAdd.setParam("Commande_Id", oec_commandeId);
			qAdd.execute();

			oec_calculerPoids();
			oec_ajouterLigne("I");
			oec_aLignes.initTree(oec_afterRefreshArticles);
		}

	} catch (e) {
		recup_erreur(e);
  }
}


function oec_modifierTarif() {
	try {

		if (oec_modeLigne=="M" && oec_typeLigne=='S' && oec_modeTarif=='Q') {

			var url = "chrome://opensi/content/facturation/user/commun/popup-choixTarif.xul";
    	window.openDialog(url,'','chrome,modal,centerscreen', oec_retourChoixPrixQuantite, oec_articleId);

			if (!isEmpty(oec_prixId)) {
				var qGet = new QueryHttp("Facturation/Articles/getInfosArticleQuantite.tmpl");
        qGet.setParam("Article_Id", oec_articleId);
        qGet.setParam("Prix_Id", oec_prixId);
				qGet.setParam("TTC", oec_editionTTC);
				var result = qGet.execute();

				var contenu = result.responseXML.documentElement;
				document.getElementById('oec-quantite').value = contenu.getAttribute("Quantite");
				document.getElementById('oec-unite').value = contenu.getAttribute("Unite_Id");
				document.getElementById('oec-PU').value = contenu.getAttribute("Prix_Unitaire");
				oec_prixId = "";
				oec_libelle = contenu.getAttribute("Libelle");
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oec_retourChoixPrixQuantite(prixId) {
	try {

		oec_prixId = prixId;

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_ouvrirLigne() {
  try {

		if (oec_aLignes.isSelected()) {

			if (oec_aLignes.nbSelection()==1) {
				var i = oec_aLignes.getCurrentIndex();

				oec_aLignes.setCellSrc(i, 'oec-colReference', "");

				oec_currentIndex = i;

				document.getElementById('oec-bMoveUp').disabled = true;
				document.getElementById('oec-bMoveDown').disabled = true;
				document.getElementById('oec-bMoveFirst').disabled = true;
				document.getElementById('oec-bMoveLast').disabled = true;
				document.getElementById('oec-bMultiSuppression').disabled = true;

				if (oec_mode=="M") {
					if (oec_aLignes.getCellText(i,'oec-colTypeLigne')=="C") {
						oec_ajouterLigne("I");
					}
					else {
						oec_modeLigne = "M";
						document.getElementById('oec-bAjouterLigne').disabled = false;
						oec_insertionLigneId = 0;
						document.getElementById('oec-actInsert').collapsed = true;

						document.getElementById('oec-bCommentaire').disabled = false;
						document.getElementById('oec-bSupprimer').disabled = false;

						document.getElementById('oec-codeStats').value = oec_aLignes.getCellText(i,'oec-colCodeStats');
						document.getElementById('oec-reference').value = oec_aLignes.getCellText(i,'oec-colReference');
						document.getElementById('oec-designation').value = oec_aLignes.getCellText(i,'oec-colDesignation');
						document.getElementById('oec-nbPieces').value = oec_aLignes.getCellText(i,'oec-colNbPieces');
						document.getElementById('oec-quantite').value = oec_aLignes.getCellText(i,'oec-colQuantite');
						document.getElementById('oec-unite').value = oec_aLignes.getCellText(i,'oec-colUnite');
						document.getElementById('oec-PU').value = oec_aLignes.getCellText(i,'oec-colPU');
						document.getElementById('oec-codeTVA').value = oec_aLignes.getCellText(i,'oec-colCodeTVA');
						document.getElementById('oec-ristourne').value = oec_aLignes.getCellValue(i,'oec-colRistourne');
						oec_typeRistourne = oec_aLignes.getSelectedCellText('oec-colTypeRistourne');
						document.getElementById('oec-bRistourne').setAttribute("class", (oec_typeRistourne=='P'?"bIcoPourcentage":"bIcoEuro"));
						document.getElementById('oec-depotLigne').value = oec_aLignes.getCellText(i,'oec-colDepotLigne');
						document.getElementById("oec-dateExpeditionLC").value = oec_aLignes.getCellText(i, 'oec-colDateExpedition');
						oec_typeLigne = oec_aLignes.getCellText(i,'oec-colTypeLigne');
						oec_ligneId = oec_aLignes.getCellText(i,'oec-colLigneId');
						oec_articleId = oec_aLignes.getCellText(i,'oec-colArticleId');
						oec_libelle = oec_aLignes.getCellText(i,'oec-colLibelle');

						oec_formatLigne(oec_typeLigne);
					}
				}

				var typeArticle = oec_aLignes.getCellText(i,'oec-colTypeArticle');

				// apercu article
				if (typeArticle=="F") {
					document.getElementById("oec-tabBoxAdresses").collapsed = true;
					document.getElementById("oec-boxApercuArticle").collapsed = false;
					document.getElementById("oec-apercuReference").value = oec_aLignes.getCellText(i,'oec-colReference');
					document.getElementById("oec-apercuDesignation").value = oec_aLignes.getCellText(i,'oec-colDesignation');
					if (!oec_calculStock || oec_etatCommande!='T') {
						document.getElementById('oec-colStockCL').setAttribute("hidden", true);
						document.getElementById('oec-colStockCL').setAttribute("ignoreincolumnpicker", true);
					}
					else {
						document.getElementById('oec-colStockCL').setAttribute("hidden", false);
						document.getElementById('oec-colStockCL').removeAttribute("ignoreincolumnpicker", true);
					}
					document.getElementById('oec-colQteTotaleCL').setAttribute("hidden", false);
					document.getElementById('oec-colQteTotaleCL').removeAttribute("ignoreincolumnpicker");
					oec_aComposantsLigne.setParam("Ligne_Id", oec_aLignes.getCellText(i,'oec-colLigneId'));
					oec_aComposantsLigne.setParam("Commande_Id", oec_commandeId);
					oec_aComposantsLigne.initTree();
				}
				else {
					document.getElementById("oec-tabBoxAdresses").collapsed = false;
					document.getElementById("oec-boxApercuArticle").collapsed = true;
					oec_aComposantsLigne.deleteTree();
				}

				if (oec_mode=="M" && oec_etatCommande!="C" && oec_aLignes.getCellText(i,'oec-colTypeLigne')!="C") {
					// on ignore les lignes de commentaires
					var firstIndex = 0;
					var lastIndex = oec_aLignes.nbLignes()-1;
					if (oec_aLignes.getCellText(firstIndex,'oec-colTypeLigne')=="C") { firstIndex++; }
					if (oec_aLignes.getCellText(lastIndex,'oec-colTypeLigne')=="C") { lastIndex--; }

					document.getElementById('oec-bMoveUp').disabled = (i==firstIndex);
					document.getElementById('oec-bMoveDown').disabled = (i==lastIndex);
					document.getElementById('oec-bMoveFirst').disabled = (i==firstIndex);
					document.getElementById('oec-bMoveLast').disabled = (i==lastIndex);
				}

				document.getElementById('oec-bSolderLigne').disabled = oec_etatCommande!="T" || oec_bloque || oec_mode=="M" || oec_aLignes.getCellText(i, 'oec-colTypeLigne')=="C" || oec_aLignes.getCellText(i, 'oec-colSoldee')=="true";
			}
			else {
				if (oec_mode!="V") {
					oec_ajouterLigne("I");
					document.getElementById('oec-bMultiSuppression').disabled = false;
				}
				document.getElementById('oec-bSolderLigne').disabled = true;
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oec_ouvrirCommentaire() {
  try {

		if (oec_aLignes.isSelected() && oec_mode=="M") {
			var i = oec_aLignes.getCurrentIndex();
			if (oec_aLignes.getCellText(i,'oec-colTypeLigne')=="C") {
				oec_editerCommentaire();
			}
			else if ((oec_etatCommande=="T" || (oec_etatCommande=="N" && gConfig.isSpecREERC())) && oec_aLignes.getCellText(i,'oec-colTypeLigne')!="C") {
				oec_editerPrixAchat();
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oec_deplacerLigne(moveType) {
	try {

		if (oec_aLignes.isSelected() && oec_mode!="C" && oec_etatCommande!="C" && oec_aLignes.getSelectedCellText('oec-colTypeLigne')!="C") {

			document.getElementById('oec-bMoveUp').disabled = true;
			document.getElementById('oec-bMoveDown').disabled = true;
			document.getElementById('oec-bMoveFirst').disabled = true;
			document.getElementById('oec-bMoveLast').disabled = true;

			var qMove = new QueryHttp("Facturation/Affaires/moveLigneCommandeClient.tmpl");
			qMove.setParam("Ligne_Id", oec_ligneId);
			qMove.setParam("Move_Type", moveType);
			var result = qMove.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oec_toSelectLigne = oec_ligneId;
				oec_ajouterLigne("I");
				oec_aLignes.initTree(oec_afterRefreshArticles);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_validerLigne() {
  try {

		var codeStats = document.getElementById('oec-codeStats').value;
		var reference = document.getElementById('oec-reference').value;
		var designation = document.getElementById('oec-designation').value;
		var nbPieces = document.getElementById('oec-nbPieces').value;
		var quantite = document.getElementById('oec-quantite').value;
		var unite = document.getElementById('oec-unite').value;
		var prixUnitaire = document.getElementById('oec-PU').value;
		var ristourne = document.getElementById('oec-ristourne').value;
		var codeTVA = document.getElementById('oec-codeTVA').value;
		var depotLigne = document.getElementById('oec-depotLigne').value;
		var dateExpedition = document.getElementById('oec-dateExpeditionLC').value;
		var ok = true;

		if (oec_mode=="C") {
			ok = oec_enregistrerCommande(true);
		}

		if (ok) {

			if (isEmpty(designation)) { showWarning("D\u00E9signation de l'article manquante !"); }
			else if (!checkQte(quantite)) { showWarning("Quantit\u00E9 incorrecte !");	}
			else if (!isEmpty(nbPieces) && !isPositiveInteger(nbPieces)) { showWarning("Nombre de pi\u00E8ces incorrect !");	}
			else if (isEmpty(prixUnitaire) || !isPositiveOrNull(prixUnitaire) || !checkDecimal(prixUnitaire,4)) { showWarning("Prix unitaire incorrect");	}
			else if (isEmpty(ristourne) || (oec_typeRistourne=='P'?!isTaux(ristourne):!isPositiveOrNull(ristourne) || !checkNumber(ristourne,9,2) || parseFloat(ristourne)>parseFloat(prixUnitaire))) { showWarning("Ristourne incorrecte"); }
			else if (!isEmpty(dateExpedition) && !isDate(dateExpedition)) { showWarning("Date d'exp\u00E9dition pr\u00E9vue incorrecte"); }
			else {

				if (oec_modeLigne=="C" && !isEmpty(oec_articleId) && gConfig.isGACPropSubstitution()) {
					oec_proposerSubstitution(quantite, depotLigne);
					if (oec_substitution) {
						oec_substitution = false;
						return;
					}
				}

				var qSave;

				if (oec_modeLigne=="C") {
					qSave = new QueryHttp("Facturation/Affaires/ajouterArticleCommande.tmpl");
					qSave.setParam("Commande_Id", oec_commandeId);
				}
				else {
					qSave = new QueryHttp("Facturation/Affaires/modifierArticleCommande.tmpl");
					qSave.setParam("Ligne_Id", oec_ligneId);
				}

				qSave.setParam("Reference", reference);
				qSave.setParam("Designation", designation);
				qSave.setParam("Quantite", quantite);
				qSave.setParam("Prix", prixUnitaire);
				qSave.setParam("Ristourne", ristourne);
				qSave.setParam("Type_Ristourne", oec_typeRistourne);
				qSave.setParam("Code_TVA", codeTVA);
				qSave.setParam("Libelle", oec_libelle);
				qSave.setParam("Code_Stats", codeStats);
				qSave.setParam("Unite", unite);
				qSave.setParam("Nb_Pieces", nbPieces);
				qSave.setParam("Depot_Id", depotLigne);
				qSave.setParam("Date_Expedition", dateExpedition);
				qSave.setParam("Insertion_Ligne_Id", oec_insertionLigneId);

				var result = qSave.execute();
				var errors = new Errors(result);

				if (errors.hasNext()) {
					errors.show();
				}
				else {
					var message = result.responseXML.documentElement.getAttribute('Message');
					if (message!=null) {
						showWarning(message);
					}
					if (oec_modeLigne=="C" && oec_insertionLigneId==0) {
						oec_currentIndex = oec_aLignes.nbLignes();
					}

					if (oec_typeLigne=='S') {
						oec_calculerPoids();
					}

					if (oec_modeLigne=="M" && oec_etatCommande=="T") {
						// on force l'utilisateur  enregistrer pour grer au mieux la remise globale
						oec_setModified(true);
					}

					oec_ajouterLigne("I");
					oec_initTree2();

					if (result.responseXML.documentElement.getAttribute("Maj_Prix")=="true" && window.confirm("Le prix de vente de l'article au client a \u00E9volu\u00E9.\nVoulez-vous cr\u00E9er ou mettre \u00E0 jour son prix sp\u00E9cifique ?")) {
						var qMajPrix = new QueryHttp("Facturation/Affaires/updatePrixClientArticle.tmpl");
						qMajPrix.setParam("Prix_Client", prixUnitaire);
						qMajPrix.setParam("Reference", reference);
						qMajPrix.setParam("Client_Id", oec_clientId);
						qMajPrix.setParam("Edition_TTC", oec_editionTTC);
						qMajPrix.execute();
					}
				}
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oec_proposerSubstitution(quantite, depotId) {
	try {

		var qGet = new QueryHttp("Facturation/Affaires/getListSubstitutArticle.tmpl");
		qGet.setParam("Article_Id", oec_articleId);
		qGet.setParam("Quantite", quantite);
		qGet.setParam("Depot_Id", depotId);
		var result = qGet.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var listSubstitutId = result.responseXML.documentElement.getAttribute('List_Substitut_Id');

			if (!isEmpty(listSubstitutId)) {
				var url = "chrome://opensi/content/facturation/user/affaires/popup-substitutionArticle.xul";
				var tarifId = (oec_modeTarif!="Q"?document.getElementById('oec-tarifVente').value:null);
    		window.openDialog(url,'','chrome,modal,centerscreen', oec_retourSubstitutionArticle, listSubstitutId, depotId);
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oec_retourSubstitutionArticle(articleId, reference) {
  try {

		oec_substitution = true;

		var quantite = document.getElementById('oec-quantite').value;
		var codeStats = document.getElementById('oec-codeStats').value;
		var nbPieces = document.getElementById('oec-nbPieces').value;
		var dateExpedition = document.getElementById('oec-dateExpeditionLC').value;
		var depotLigne = document.getElementById('oec-depotLigne').value;

		document.getElementById('oec-reference').value = reference;
		document.getElementById('oec-quantite').focus();
		oec_ajouterLigne("S", articleId);

		document.getElementById('oec-quantite').value = quantite;
		if (isEmpty(document.getElementById('oec-codeStats').value)) {
			document.getElementById('oec-codeStats').value = codeStats;
		}
		document.getElementById('oec-nbPieces').value = nbPieces;
		document.getElementById('oec-dateExpeditionLC').value = dateExpedition;
		document.getElementById('oec-depotLigne').value = depotLigne;

	} catch (e) {
  	recup_erreur(e);
	}
}


function oec_annulerLigne() {
  try {

  	oec_aLignes.clearSelection();
		oec_ajouterLigne("I");

	} catch (e) {
  	recup_erreur(e);
	}
}


function oec_supprimerLigne() {
  try {

		var listLigneId = "";
		var maxIndex = 0;

		if (!isEmpty(oec_ligneId)) {
			listLigneId = oec_ligneId;
			maxIndex = oec_currentIndex;
		}
		else {
			var start = new Object();
			var end = new Object();
			var numRanges = oec_aLignes.getRangeCount();

			for (var t=0; t<numRanges; t++){
				oec_aLignes.getRangeAt(t,start,end);
			  for (var v=start.value; v<=end.value; v++){
					if (oec_aLignes.getCellText(v,'oec-colTypeLigne')!="C") {
			  		listLigneId += oec_aLignes.getCellText(v,'oec-colLigneId')+",";
						if (v>maxIndex) maxIndex = v;
					}
			  }
			}
		}

		if (!isEmpty(listLigneId)) {
			var qDelete = new QueryHttp("Facturation/Affaires/supprimerArticleCommande.tmpl");
			qDelete.setParam('List_Ligne_Id', listLigneId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var nbNonSup = parseIntBis(result.responseXML.documentElement.getAttribute('Nb_Non_Sup'));
				if (nbNonSup>0) {
					showWarning("Attention : "+ nbNonSup +" lignes de la s\u00E9lection n'ont pas pu \u00EAtre supprim\u00E9es");
				}

				oec_currentIndex = maxIndex-1;
				oec_calculerPoids();
				oec_ajouterLigne("I");
				oec_initTree2();

				if (oec_etatCommande=="T") {
					// on force l'utilisateur  enregistrer pour grer au mieux la remise globale
					oec_setModified(true);
				}
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oec_appliquerRistourne() {
	try {

		var listLigneId = "";
		var maxIndex = 0;

		if (oec_aLignes.isSelected()) {
			var start = new Object();
			var end = new Object();
			var numRanges = oec_aLignes.getRangeCount();

			for (var t=0; t<numRanges; t++){
				oec_aLignes.getRangeAt(t,start,end);
			  for (var v=start.value; v<=end.value; v++){
					if (oec_aLignes.getCellText(v,'oec-colTypeLigne')!="C") {
			  		listLigneId += oec_aLignes.getCellText(v,'oec-colLigneId')+",";
						if (v>maxIndex) maxIndex = v;
					}
			  }
			}
		}

		if (!isEmpty(listLigneId)) {
			var url = "chrome://opensi/content/facturation/user/commun/popup-applicationRistourne.xul";
			window.openDialog(url,'','chrome,modal,centerscreen', "CC", listLigneId);

			oec_currentIndex = maxIndex;
			oec_ajouterLigne("I");
			oec_initTree2();
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oec_enregistrerCommande(rafraichir) {
	try {

		var save = false;

		var utilR = document.getElementById('oec-responsable').value;
		var refCommande = document.getElementById('oec-refCommande').value;
		var intitule = document.getElementById('oec-intitule').value;
		var regimeTVA = document.getElementById('oec-regimeTVA').value;
		var numTva = oec_assujettiTVA?document.getElementById('oec-numTVA').value:"";
		var dateExpedition = document.getElementById('oec-dateExpedition').value;
		var dateLivraison = document.getElementById('oec-dateLivraison').value;
		var dateLivraisonFin = document.getElementById('oec-dateLivraisonFin').value;
		var pointRetrait = document.getElementById('oec-pointRetrait').value;
		var coutTransport = document.getElementById('oec-coutTransport').value;
		var consignesLiv = document.getElementById('oec-consignesLiv').value;
		var regleExpedition = document.getElementById('oec-regleExpedition').value;
		var nonFacturable = document.getElementById('oec-chkNonFacturable').checked;
		var paquetCadeau = document.getElementById('oec-chkPaquetCadeau').checked;
		var prioritaireLiv = document.getElementById('oec-chkPrioritaireLiv').checked;
		var expeditionNeutre = document.getElementById('oec-chkExpeditionNeutre').checked;
		var livTransitaire = document.getElementById('oec-chkLivTransitaire').checked;
		var noDropShipping = document.getElementById('oec-noDropShipping').checked;
		var modeReglement = document.getElementById('oec-modeReglement').value;
		var modeExpedition = document.getElementById('oec-modeExpedition').value;
		var secteurActivite = document.getElementById('oec-poleActivite').value;
		var etabId = document.getElementById('oec-etablissement').value;
		var depotId = document.getElementById('oec-depot').value;
		var commentairesFin = document.getElementById('oec-commentairesFin').value;
		var commentairesInt = document.getElementById('oec-commentairesInt').value;
		var tarifVente = document.getElementById('oec-tarifVente').value;
		var numEngagement = document.getElementById('oec-numEngagement').value;
		var codeService = document.getElementById('oec-codeService').value;
		var remise = document.getElementById('oec-remise').value;
		var tauxRemise = 0;
		var montantRemise = 0;
		var fraisPort = document.getElementById('oec-fraisPort').value;
		var remiseFP = document.getElementById('oec-remiseFP').value;
		var tauxRemiseFP = 0;
		var montantRemiseFP = 0;
		var escompte = document.getElementById('oec-escompte').value;

		oec_codeTVAPort = document.getElementById('oec-codeTVAFraisPort').value;
		oec_tauxTVAPort = getTva(oec_codeTVAPort);

		var denominationFact = document.getElementById('oec-denominationFact').value;
		var adresse1Fact = document.getElementById('oec-adresse1Fact').value;
		var adresse2Fact = document.getElementById('oec-adresse2Fact').value;
		var adresse3Fact = document.getElementById('oec-adresse3Fact').value;
		var codePostalFact = document.getElementById('oec-codePostalFact').value;
		var villeFact = document.getElementById('oec-villeFact').value;
		var codePaysFact = document.getElementById('oec-codePaysFact').value;
		var civInterFact = document.getElementById('oec-civInterFact').value;
		var nomInterFact = document.getElementById('oec-nomInterFact').value;
		var prenomInterFact = document.getElementById('oec-prenomInterFact').value;
		var telInter1Fact = document.getElementById('oec-telInter1Fact').value;
		var telInter2Fact = document.getElementById('oec-telInter2Fact').value;
		var faxInterFact = document.getElementById('oec-faxInterFact').value;
		var emailInterFact = document.getElementById('oec-emailInterFact').value;

		var denominationLiv = document.getElementById('oec-denominationLiv').value;
		var adresse1Liv = document.getElementById('oec-adresse1Liv').value;
		var adresse2Liv = document.getElementById('oec-adresse2Liv').value;
		var adresse3Liv = document.getElementById('oec-adresse3Liv').value;
		var codePostalLiv = document.getElementById('oec-codePostalLiv').value;
		var villeLiv = document.getElementById('oec-villeLiv').value;
		var codePaysLiv = document.getElementById('oec-codePaysLiv').value;
		var civInterLiv = document.getElementById('oec-civInterLiv').value;
		var nomInterLiv = document.getElementById('oec-nomInterLiv').value;
		var prenomInterLiv = document.getElementById('oec-prenomInterLiv').value;
		var telInter1Liv = document.getElementById('oec-telInter1Liv').value;
		var telInter2Liv = document.getElementById('oec-telInter2Liv').value;
		var faxInterLiv = document.getElementById('oec-faxInterLiv').value;
		var emailInterLiv = document.getElementById('oec-emailInterLiv').value;

		var denominationEnvoi = document.getElementById('oec-denominationEnvoi').value;
		var adresse1Envoi = document.getElementById('oec-adresse1Envoi').value;
		var adresse2Envoi = document.getElementById('oec-adresse2Envoi').value;
		var adresse3Envoi = document.getElementById('oec-adresse3Envoi').value;
		var codePostalEnvoi = document.getElementById('oec-codePostalEnvoi').value;
		var villeEnvoi = document.getElementById('oec-villeEnvoi').value;
		var codePaysEnvoi = document.getElementById('oec-codePaysEnvoi').value;
		var civInterEnvoi = document.getElementById('oec-civInterEnvoi').value;
		var nomInterEnvoi = document.getElementById('oec-nomInterEnvoi').value;
		var prenomInterEnvoi = document.getElementById('oec-prenomInterEnvoi').value;
		var telInter1Envoi = document.getElementById('oec-telInter1Envoi').value;
		var telInter2Envoi = document.getElementById('oec-telInter2Envoi').value;
		var faxInterEnvoi = document.getElementById('oec-faxInterEnvoi').value;
		var emailInterEnvoi = document.getElementById('oec-emailInterEnvoi').value;

		var denominationEF = document.getElementById('oec-denominationEF').value;
		var adresse1EF = document.getElementById('oec-adresse1EF').value;
		var adresse2EF = document.getElementById('oec-adresse2EF').value;
		var adresse3EF = document.getElementById('oec-adresse3EF').value;
		var codePostalEF = document.getElementById('oec-codePostalEF').value;
		var villeEF = document.getElementById('oec-villeEF').value;
		var codePaysEF = document.getElementById('oec-codePaysEF').value;
		var civInterEF = document.getElementById('oec-civInterEF').value;
		var nomInterEF = document.getElementById('oec-nomInterEF').value;
		var prenomInterEF = document.getElementById('oec-prenomInterEF').value;
		var telInter1EF = document.getElementById('oec-telInter1EF').value;
		var telInter2EF = document.getElementById('oec-telInter2EF').value;
		var faxInterEF = document.getElementById('oec-faxInterEF').value;
		var emailInterEF = document.getElementById('oec-emailInterEF').value;

		var montantBase = (oec_editionTTC?oec_montantTTC:oec_montantHT);

		if (isEmpty(remise) || (oec_typeRemise=='P'?!isTaux(remise):!isPositiveOrNull(remise) || !checkNumber(remise,9,2) || parseFloat(remise)>montantBase)) { showWarning("Remise incorrecte !"); }
		else if (isEmpty(fraisPort) || !isPositiveOrNull(fraisPort)) { showWarning("Frais de port incorrects !"); }
		else if (isEmpty(remiseFP) || (oec_typeRemiseFP=='P'?!isTaux(remiseFP):!isPositiveOrNull(remiseFP) || !checkNumber(remiseFP,9,2) || parseFloat(remiseFP)>parseFloat(fraisPort))) { showWarning("Remise sur frais de port incorrecte !"); }
		else if (isEmpty(denominationFact)) { showWarning("Veuillez indiquer la d\u00E9nomination de facturation"); }
		else if (isEmpty(adresse1Fact)) { showWarning("Veuillez indiquer l'adresse de facturation"); }
		else if (isEmpty(villeFact)) { showWarning("Veuillez indiquer la ville de facturation"); }
		else if (isEmpty(denominationLiv)) { showWarning("Veuillez indiquer la d\u00E9nomination de livraison"); }
		else if (isEmpty(adresse1Liv)) { showWarning("Veuillez indiquer l'adresse de livraison"); }
		else if (isEmpty(villeLiv)) { showWarning("Veuillez indiquer la ville de livraison"); }
		else if (isEmpty(denominationEnvoi)) { showWarning("Veuillez indiquer la d\u00E9nomination d'envoi de la commande"); }
		else if (isEmpty(adresse1Envoi)) { showWarning("Veuillez indiquer l'adresse d'envoi de la commande"); }
		else if (isEmpty(villeEnvoi)) { showWarning("Veuillez indiquer la ville d'envoi de la commande"); }
		else if (isEmpty(denominationEF)) { showWarning("Veuillez indiquer d\u00E9nomination d'envoi de la facture"); }
		else if (isEmpty(adresse1EF)) { showWarning("Veuillez indiquer l'adresse d'envoi de la facture"); }
		else if (isEmpty(villeEF)) { showWarning("Veuillez indiquer la ville d'envoi de la facture"); }
		else if (isEmpty(codePaysEF)) { showWarning("Veuillez indiquer le pays d'envoi de la facture"); }
		else if (isEmpty(escompte) || !isTaux(escompte)) { showWarning("Taux d'escompte incorrect !"); }
		else if (!isEmpty(dateExpedition) && !isDate(dateExpedition)) { showWarning("Date d'exp\u00E9dition pr\u00E9vue incorrecte"); }
		else if (!isEmpty(dateLivraison) && !isDate(dateLivraison) && !isDateTime(dateLivraison)) { showWarning("Date de livraison estim\u00E9e incorrecte"); }
		else if (!isEmpty(dateLivraisonFin) && !isDateTime(dateLivraisonFin)) { showWarning("Date de livraison estim\u00E9e fin incorrecte (jj/mm/aaaa hh:mm)"); }
		else if (!isEmpty(dateLivraison) && !isEmpty(dateLivraisonFin) && !isDateTimeInterval(dateLivraison, dateLivraisonFin)) { showWarning("Plage de dates de livraison estim\u00E9es incorrecte"); }
		else if (isEmpty(dateLivraison) && !isEmpty(dateLivraisonFin)) { showWarning("Plage de dates de livraison estim\u00E9es incorrecte"); }
		else if (isEmpty(modeReglement)) { showWarning("Veuillez choisir un mode de r\u00E8glement !"); }
		else if (!isEmpty(coutTransport) && !isPositiveOrNull(coutTransport)) { showWarning("Co\u00FBt de transport HT incorrect"); }
		else if (!isEmpty(telInter1Fact) && !isPhone(telInter1Fact)) { showWarning("T\u00E9l\u00E9phone 1 de facturation incorrect"); }
		else if (!isEmpty(telInter2Fact) && !isPhone(telInter2Fact)) { showWarning("T\u00E9l\u00E9phone 2 de facturation incorrect"); }
		else if (gShowFax && !isEmpty(faxInterFact) && !isPhone(faxInterFact)) { showWarning("Fax de facturation incorrect"); }
		else if (!isEmpty(emailInterFact) && !isEmail(emailInterFact)) { showWarning("Adresse e-mail de facturation incorrecte"); }
		else if (!isEmpty(telInter1Liv) && !isPhone(telInter1Liv)) { showWarning("T\u00E9l\u00E9phone 1 de livraison incorrect"); }
		else if (!isEmpty(telInter2Liv) && !isPhone(telInter2Liv)) { showWarning("T\u00E9l\u00E9phone 2 de livraison incorrect"); }
		else if (gShowFax && !isEmpty(faxInterLiv) && !isPhone(faxInterLiv)) { showWarning("Fax de livraison incorrect"); }
		else if (!isEmpty(emailInterLiv) && !isEmail(emailInterLiv)) { showWarning("Adresse e-mail de livraison incorrecte"); }
		else if (!isEmpty(telInter1Envoi) && !isPhone(telInter1Envoi)) { showWarning("T\u00E9l\u00E9phone 1 d'envoi commande incorrect"); }
		else if (!isEmpty(telInter2Envoi) && !isPhone(telInter2Envoi)) { showWarning("T\u00E9l\u00E9phone 2 d'envoi commande incorrect"); }
		else if (gShowFax && !isEmpty(faxInterEnvoi) && !isPhone(faxInterEnvoi)) { showWarning("Fax d'envoi commande incorrect"); }
		else if (!isEmpty(emailInterEnvoi) && !isEmail(emailInterEnvoi)) { showWarning("Adresse e-mail d'envoi commande incorrecte"); }
		else if (!isEmpty(telInter1EF) && !isPhone(telInter1EF)) { showWarning("T\u00E9l\u00E9phone 1 d'envoi facture incorrect"); }
		else if (!isEmpty(telInter2EF) && !isPhone(telInter2EF)) { showWarning("T\u00E9l\u00E9phone 2 d'envoi facture incorrect"); }
		else if (gShowFax && !isEmpty(faxInterEF) && !isPhone(faxInterEF)) { showWarning("Fax d'envoi facture incorrect"); }
		else if (!isEmpty(emailInterEF) && !isEmail(emailInterEF)) { showWarning("Adresse e-mail d'envoi facture incorrecte"); }
		else if (!isEmpty(consignesLiv) && consignesLiv.length>100) { showWarning("Consignes de livraison incorrectes (longueur max = 100 caract\u00E8res) !"); }
		else {

			fraisPort = parseFloat(fraisPort);
			remise = parseFloat(remise);
			remiseFP = parseFloat(remiseFP);

			if (oec_assujettiTVA && codePaysLiv!="FR" && isEmpty(numTva) && oec_zoneUE) {
				showWarning("Attention : vous n'avez pas saisi le num\u00E9ro de tva intra-communautaire !");
			}

			var qSave;
			if (oec_mode=="C") {
				qSave = new QueryHttp("Facturation/Affaires/createCommandeClient.tmpl");
				qSave.setParam("Affaire_Id", ofa_affaireId);
			}
			else {
				qSave = new QueryHttp("Facturation/Affaires/updateCommandeClient.tmpl");
				qSave.setParam("Commande_Id", oec_commandeId);
			}

			if (oec_typeRemise=='P') {
				tauxRemise = remise;
			}
			else {
				tauxRemise = (montantBase>0?remise/montantBase*100:0);
				montantRemise = remise;
			}

			if (oec_typeRemiseFP=='P') {
				tauxRemiseFP = remiseFP;
			}
			else {
				tauxRemiseFP = (fraisPort>0?remiseFP/fraisPort*100:0);
				montantRemiseFP = remiseFP;
			}

			qSave.setParam("Client_Id", oec_clientId);
			qSave.setParam("Util_R", utilR);
			qSave.setParam("Ref_Commande", refCommande);
			qSave.setParam("Intitule", intitule);
			qSave.setParam("Edition_TTC", oec_editionTTC);
			qSave.setParam("Regime_TVA", regimeTVA);
			qSave.setParam("Assujetti_TVA", oec_assujettiTVA);
			qSave.setParam("Num_TVA_Intra", numTva);
			qSave.setParam("Tarif_Id", tarifVente);
			qSave.setParam("Date_Expedition", dateExpedition);
			qSave.setParam("Date_Livraison", dateLivraison);
			qSave.setParam("Date_Livraison_Fin", dateLivraisonFin);
			qSave.setParam("Point_Retrait", pointRetrait);
			qSave.setParam("Cout_Transport", coutTransport);
			qSave.setParam("Consignes_Liv", consignesLiv);
			qSave.setParam("Regle_Expedition", regleExpedition);
			qSave.setParam("Paquet_Cadeau", paquetCadeau);
			qSave.setParam("Prioritaire_Liv", prioritaireLiv);
			qSave.setParam("Expedition_Neutre", expeditionNeutre);
			qSave.setParam("Liv_Transitaire", livTransitaire);
			qSave.setParam("No_Drop_Shipping", noDropShipping);
			qSave.setParam("Mode_Reglement", modeReglement);
			qSave.setParam("Mode_Expedition", modeExpedition);
			qSave.setParam("Pole_Activite", secteurActivite);
			qSave.setParam("Etab_Id", etabId);
			qSave.setParam("Depot_Id", depotId);
			qSave.setParam("Commentaires_Fin", commentairesFin);
			qSave.setParam("Commentaires_Int", commentairesInt);
			qSave.setParam("PRemise", tauxRemise);
			qSave.setParam("MRemise", montantRemise);
			qSave.setParam("PRemise_FP", tauxRemiseFP);
			qSave.setParam("MRemise_FP", montantRemiseFP);
			qSave.setParam("Escompte", escompte);
			qSave.setParam("Frais_Port", fraisPort);
			qSave.setParam("Code_TVA_Port", oec_codeTVAPort);
			qSave.setParam("Taux_TVA_Port", oec_tauxTVAPort);
			qSave.setParam("Non_Facturable", nonFacturable);
			qSave.setParam("Num_Engagement", numEngagement);
			qSave.setParam("Code_Service", codeService);
			qSave.setParam("Denomination_Fact", denominationFact);
			qSave.setParam("Adresse_1_Fact", adresse1Fact);
			qSave.setParam("Adresse_2_Fact", adresse2Fact);
			qSave.setParam("Adresse_3_Fact", adresse3Fact);
			qSave.setParam("Code_Postal_Fact", codePostalFact);
			qSave.setParam("Ville_Fact", villeFact);
			qSave.setParam("Code_Pays_Fact", codePaysFact);
			qSave.setParam("Civ_Inter_Fact", civInterFact);
			qSave.setParam("Nom_Inter_Fact", nomInterFact);
			qSave.setParam("Prenom_Inter_Fact", prenomInterFact);
			qSave.setParam("Tel_Inter_1_Fact", telInter1Fact);
			qSave.setParam("Tel_Inter_2_Fact", telInter2Fact);
			qSave.setParam("Fax_Inter_Fact", faxInterFact);
			qSave.setParam("Email_Inter_Fact", emailInterFact);
			qSave.setParam("Denomination_Liv", denominationLiv);
			qSave.setParam("Adresse_1_Liv", adresse1Liv);
			qSave.setParam("Adresse_2_Liv", adresse2Liv);
			qSave.setParam("Adresse_3_Liv", adresse3Liv);
			qSave.setParam("Code_Postal_Liv", codePostalLiv);
			qSave.setParam("Ville_Liv", villeLiv);
			qSave.setParam("Code_Pays_Liv", codePaysLiv);
			qSave.setParam("Civ_Inter_Liv", civInterLiv);
			qSave.setParam("Nom_Inter_Liv", nomInterLiv);
			qSave.setParam("Prenom_Inter_Liv", prenomInterLiv);
			qSave.setParam("Tel_Inter_1_Liv", telInter1Liv);
			qSave.setParam("Tel_Inter_2_Liv", telInter2Liv);
			qSave.setParam("Fax_Inter_Liv", faxInterLiv);
			qSave.setParam("Email_Inter_Liv", emailInterLiv);
			qSave.setParam("Denomination_Envoi", denominationEnvoi);
			qSave.setParam("Adresse_1_Envoi", adresse1Envoi);
			qSave.setParam("Adresse_2_Envoi", adresse2Envoi);
			qSave.setParam("Adresse_3_Envoi", adresse3Envoi);
			qSave.setParam("Code_Postal_Envoi", codePostalEnvoi);
			qSave.setParam("Ville_Envoi", villeEnvoi);
			qSave.setParam("Code_Pays_Envoi", codePaysEnvoi);
			qSave.setParam("Civ_Inter_Envoi", civInterEnvoi);
			qSave.setParam("Nom_Inter_Envoi", nomInterEnvoi);
			qSave.setParam("Prenom_Inter_Envoi", prenomInterEnvoi);
			qSave.setParam("Tel_Inter_1_Envoi", telInter1Envoi);
			qSave.setParam("Tel_Inter_2_Envoi", telInter2Envoi);
			qSave.setParam("Fax_Inter_Envoi", faxInterEnvoi);
			qSave.setParam("Email_Inter_Envoi", emailInterEnvoi);
			qSave.setParam("Denomination_EF", denominationEF);
			qSave.setParam("Adresse_1_EF", adresse1EF);
			qSave.setParam("Adresse_2_EF", adresse2EF);
			qSave.setParam("Adresse_3_EF", adresse3EF);
			qSave.setParam("Code_Postal_EF", codePostalEF);
			qSave.setParam("Ville_EF", villeEF);
			qSave.setParam("Code_Pays_EF", codePaysEF);
			qSave.setParam("Civ_Inter_EF", civInterEF);
			qSave.setParam("Nom_Inter_EF", nomInterEF);
			qSave.setParam("Prenom_Inter_EF", prenomInterEF);
			qSave.setParam("Tel_Inter_1_EF", telInter1EF);
			qSave.setParam("Tel_Inter_2_EF", telInter2EF);
			qSave.setParam("Fax_Inter_EF", faxInterEF);
			qSave.setParam("Email_Inter_EF", emailInterEF);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var contenu = result.responseXML.documentElement;

				var message = contenu.getAttribute('Message');
				if (message!=null) {
					showWarning(message);
				}

				var messageTVA = contenu.getAttribute('Message_TVA');
				if (messageTVA!=null) {
					showWarning(messageTVA);
				}

				if (oec_mode=="C") {
					oec_commandeId = contenu.getAttribute("Commande_Id");

					if (rafraichir) {
						oec_chargerCommande();
					}
				}
				else if (oec_mode=="M") {
					document.getElementById('oec-bAnnulerCommande').disabled = oec_bloque;

					if (rafraichir) {
						// condition sur rafraichir ajoute pour correction du bug commandeId vide envoy au serveur dans le cas d'une sortie de la commande suite  demande d'enregistrement

						if (oec_etatCommande=="T") {
							oec_mode = "V";
							oec_chargerCommande();
						}
						else if (messageTVA!=null) {
							oec_chargerCommande();
						}
						else if (oec_etatCommande=="N") {
							oec_majAcompte();
							oec_curDepot = depotId;
							document.getElementById('oec-depotLigne').value = oec_curDepot;
							oec_ajouterLigne("I");
							oec_initTree2();
						}
					}
				}

				oec_setModified(false);
				save = true;
			}
		}

		return save;

	} catch (e) {
  	recup_erreur(e);
	}
}


function oec_calculTotaux() {
  try {

		if (oec_mode!='V') {
			document.getElementById('oec-editionTTC').disabled = (!oec_premiereCommande || oec_aLignes.nbLignes()>0);
	    document.getElementById('oec-codePaysLiv').disabled = (oec_aLignes.nbLignes()>0 && oec_etatCommande!="N");
	   	document.getElementById('oec-bChercherAdrLiv').disabled = (isEmpty(oec_clientId) || (oec_aLignes.nbLignes()>0 && oec_etatCommande!="N"));
	    document.getElementById('oec-bCopierFactVersLivEnvoi').disabled = (oec_aLignes.nbLignes()>0 && oec_etatCommande!="N");
	    document.getElementById('oec-tarifVente').disabled = (oec_aLignes.nbLignes()>0);
			document.getElementById('oec-regimeTVA').disabled = (oec_aLignes.nbLignes()>0 && oec_etatCommande!="N");
			document.getElementById('oec-assujettiTVA').disabled = (!oec_premiereCommande || (oec_aLignes.nbLignes()>0 && oec_etatCommande!="N"));
		}
		var remise = parseFloat(document.getElementById('oec-remise').value);
		var tauxEscompte = parseFloat(document.getElementById('oec-escompte').value);
		var fraisPort = parseFloat(document.getElementById('oec-fraisPort').value);
		var remiseFP = parseFloat(document.getElementById('oec-remiseFP').value);

		if ((oec_typeRemise=='P'?isTaux(remise):isPositiveOrNull(remise)) && (oec_typeRemiseFP=='P'?isTaux(remiseFP):isPositiveOrNull(remiseFP)) && isTaux(tauxEscompte) && isPositiveOrNull(fraisPort)) {

			var calculDocument = new CalculDocument();
			calculDocument.setEditionTTC(oec_editionTTC);
			if (oec_typeRemise=='P') { calculDocument.setRemiseP(remise); }
			else { calculDocument.setRemiseM(remise); }
			calculDocument.setFraisPortBruts(fraisPort);
			if (oec_typeRemiseFP=='P') { calculDocument.setRemiseFPP(remiseFP); }
			else { calculDocument.setRemiseFPM(remiseFP); }

			calculDocument.setCodeAndTauxTVAFP(document.getElementById('oec-codeTVAFraisPort').value, getTva(document.getElementById('oec-codeTVAFraisPort').value));
			calculDocument.setEscompteP(tauxEscompte);
			calculDocument.setAcompte(oec_acompte);

			var nbLignes = oec_aLignes.nbLignes();

			for (var i=0;i<nbLignes;i++) {
				if (oec_aLignes.getCellText(i,'oec-colTypeLigne')!="C") {
					var montantLigne = oec_aLignes.getCellText(i,'oec-colTotal');
					var codeTVA = oec_aLignes.getCellText(i,'oec-colCodeTVA');
					calculDocument.addLigneDocument(montantLigne, codeTVA);
				}
			}

			calculDocument.calculer();

			if (oec_editionTTC) {
				document.getElementById('oec-pttcMontantRemise').value = calculDocument.getRemiseM();
				document.getElementById('oec-pttcMontantFraisPort').value = calculDocument.getFraisPortBruts();
				document.getElementById('oec-pttcMontantRemiseFP').value = calculDocument.getRemiseFPM();
				document.getElementById('oec-pttcTVA').value = calculDocument.getTotalTVA();
				document.getElementById('oec-pttcMontantTTC').value = calculDocument.getMontantTTC();
				document.getElementById('oec-pttcMontantEscompte').value = calculDocument.getEscompteM();
				document.getElementById('oec-pttcNetCommercial').value = calculDocument.getNetCommercial();
				document.getElementById('oec-pttcMontantAcompte').value = calculDocument.getAcompte();
				document.getElementById('oec-pttcTotalTTC').value = calculDocument.getTotalTTC();
				document.getElementById('oec-pttcNetTTC').value = calculDocument.getNetAPayer();

				oec_montantTTC = calculDocument.getMontantTTCSansFormat();

				document.getElementById('oec-rowRemiseTTC').collapsed = !calculDocument.afficherRemiseM();
				document.getElementById('oec-rowRemiseFPTTC').collapsed = !calculDocument.afficherRemiseFPM();
				document.getElementById('oec-rowNetCommercialTTC').collapsed = !calculDocument.afficherNetCommercial();
				document.getElementById('oec-rowEscompteTTC').collapsed = !calculDocument.afficherEscompteM();
			}
			else {
				document.getElementById('oec-montantHT').value = calculDocument.getMontantHT();
				document.getElementById('oec-montantRemise').value = calculDocument.getRemiseM();
				document.getElementById('oec-montantFraisPort').value = calculDocument.getFraisPortBruts();
				document.getElementById('oec-montantRemiseFP').value = calculDocument.getRemiseFPM();
				document.getElementById('oec-totalHT').value = calculDocument.getTotalHT();
				document.getElementById('oec-TVA').value = calculDocument.getTotalTVA();
				document.getElementById('oec-montantEscompte').value = calculDocument.getEscompteM();
				document.getElementById('oec-netCommercial').value = calculDocument.getNetCommercial();
				document.getElementById('oec-montantAcompte').value = calculDocument.getAcompte();
				document.getElementById('oec-totalTTC').value = calculDocument.getTotalTTC();

				oec_montantHT = calculDocument.getMontantHTSansFormat();
				oec_montantTTC = calculDocument.getMontantTTCSansFormat();

				document.getElementById('oec-rowRemiseHT').collapsed = !calculDocument.afficherRemiseM();
				document.getElementById('oec-rowRemiseFPHT').collapsed = !calculDocument.afficherRemiseFPM();
				document.getElementById('oec-rowNetCommercialHT').collapsed = !calculDocument.afficherNetCommercial();
				document.getElementById('oec-rowEscompteHT').collapsed = !calculDocument.afficherEscompteM();
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oec_calculerPoids() {
	try {

		var qGet = new QueryHttp("Facturation/Affaires/getPoidsTotalCommande.tmpl");
		qGet.setParam("Commande_Id", oec_commandeId);
		var result = qGet.execute();

		document.getElementById('oec-poidsTotal').value = result.responseXML.documentElement.getAttribute("Poids");
		document.getElementById('oec-volumeTotal').value = result.responseXML.documentElement.getAttribute("Volume");

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_afterRefreshArticles() {
	try {

		if (oec_toSelectLigne!=null) {
			for (var i=0; i<oec_aLignes.nbLignes(); i++) {
				if (oec_aLignes.getCellText(i, "oec-colLigneId")==oec_toSelectLigne && oec_aLignes.getCellText(i, "oec-colTypeLigne")!="C") {
					oec_aLignes.select(i);
					break;
				}
			}
			oec_toSelectLigne = null;
		}
		oec_aLignes.ensureRowIsVisible(oec_currentIndex);

		document.getElementById('oec-reference').focus();
		document.getElementById('oec-bExporterLignes').disabled = (oec_aLignes.nbLignes()==0);
		oec_calculTotaux();
		oec_loadRecapitulatif();

	} catch (e) {
  	recup_erreur(e);
	}
}


function oec_demandeEnregistrement() {
  try {

		if (oec_modifie) {
			if (window.confirm("Voulez-vous enregistrer les modifications apport\u00E9es \u00E0 la commande ?")) {
				oec_enregistrerCommande(false);
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oec_setModified(m) {
  try {

  	oec_modifie = m && !gReadOnly;

		if (oec_modifie) {
			document.getElementById('oec-tabCommande').setAttribute('image', 'chrome://opensi/content/design/icones/modified.png');
			document.getElementById('oec-bValiderCommande').disabled = true;
			document.getElementById('oec-bAnnulerCommande').disabled = true;
			document.getElementById('oec-bSolder').disabled = true;
			document.getElementById('oec-bModifier').disabled = true;
			document.getElementById('oec-bModifier').collapsed = true;
			document.getElementById('oec-bBloquer').disabled = true;
			document.getElementById('oec-bBloquer').collapsed = true;
			document.getElementById('oec-bDebloquer').disabled = true;
			document.getElementById('oec-bDebloquer').collapsed = true;
			document.getElementById('oec-bCloturer').collapsed = true;
			document.getElementById('oec-bDecloturer').collapsed = true;
			document.getElementById('oec-bVisualiser').disabled = true;
			document.getElementById('oec-bProforma').disabled = true;
			document.getElementById('oec-bCopierCommande').disabled = true;
			document.getElementById('oec-bEditionInitiale').disabled = true;
			document.getElementById('oec-bEditerOF').disabled = true;
		}
		else {
			document.getElementById('oec-tabCommande').setAttribute('image', gReadOnly?'chrome://opensi/content/design/icones/readonly.png':null);
			document.getElementById('oec-bValiderCommande').disabled = (oec_etatCommande!='N');
			document.getElementById('oec-bSolder').disabled = (oec_etatCommande!='T' || oec_soldee || oec_bloque);
			document.getElementById('oec-bModifier').disabled = (oec_etatCommande!='T');
			document.getElementById('oec-bModifier').collapsed = (oec_etatCommande!='T' || gReadOnly);
			document.getElementById('oec-bBloquer').disabled = ((oec_etatCommande!='T' && oec_etatCommande!='N') || oec_bloque);
			document.getElementById('oec-bBloquer').collapsed = ((oec_etatCommande!='T' && oec_etatCommande!='N') || oec_bloque || gReadOnly);
			document.getElementById('oec-bDebloquer').disabled = ((oec_etatCommande!='T' && oec_etatCommande!='N') || !oec_bloque);
			document.getElementById('oec-bDebloquer').collapsed = ((oec_etatCommande!='T' && oec_etatCommande!='N') || !oec_bloque || gReadOnly);
			document.getElementById('oec-bCloturer').collapsed = !oec_cloturable || gReadOnly;
			document.getElementById('oec-bDecloturer').collapsed = oec_etatCommande!='C' || gReadOnly;
			document.getElementById('oec-bVisualiser').disabled = false;
			document.getElementById('oec-bProforma').disabled = false;
			document.getElementById('oec-bCopierCommande').disabled = false;
			document.getElementById('oec-bEditionInitiale').disabled = false;
			document.getElementById('oec-bEditerOF').disabled = false;
		}

	} catch (e) {
  	recup_erreur(e);
	}
}



function oec_initTree2() {
  try {

  	oec_aLignes.setParam("Commande_Id", oec_commandeId);
  	oec_aLignes.initTree(oec_afterRefreshArticles);

  } catch (e) {
    recup_erreur(e);
  }
}



function oec_editerCommentaire() {
  try {

		if (oec_aLignes.isSelected()) {
			var ligneId = oec_aLignes.getSelectedCellText('oec-colLigneId');

			var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesLigne.xul";
    	window.openDialog(url,'','chrome,modal,centerscreen', "CC", ligneId);

			oec_initTree2();
			oec_ajouterLigne("I");
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oec_editerPrixAchat() {
  try {

		if (!gReadOnly && gAccesCoutAchat && gProfil.isModifPADV() && oec_aLignes.isSelected()) {
			var ligneId = oec_aLignes.getSelectedCellText('oec-colLigneId');

			var url = "chrome://opensi/content/facturation/user/commun/popup-modifierPrixAchat.xul";
    	window.openDialog(url,'','chrome,modal,centerscreen', oec_retourEditerPrixAchat, "CC", ligneId);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oec_retourEditerPrixAchat() {
	try {

		oec_initTree2();
		oec_ajouterLigne("I");

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_editerCommentairesInternes() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesInternes.xul";
  	window.openDialog(url,'','chrome,modal,centerscreen', "CC", oec_commandeId, gReadOnly);

	} catch (e) {
    recup_erreur(e);
  }
}


function oec_editerCommentairesDocument() {
  try {

		var commentairesFin = document.getElementById('oec-commentairesFin').value;
		var commentairesInt = document.getElementById('oec-commentairesInt').value;
		var readOnly = (oec_mode=="V" || gReadOnly);

		var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesDocument.xul";
  	window.openDialog(url,'','chrome,modal,centerscreen', oec_retourEditerCommentaires, "CC", oec_commandeId, commentairesFin, commentairesInt, readOnly);

	} catch (e) {
    recup_erreur(e);
  }
}


function oec_retourEditerCommentaires(commentairesFin, commentairesInt) {
  try {

		document.getElementById('oec-commentairesFin').value = commentairesFin;
		document.getElementById('oec-commentairesInt').value = commentairesInt;

	} catch (e) {
    recup_erreur(e);
  }
}


function oec_chargerCoord() {
  try {

		var qGet = new QueryHttp("Facturation/Clients/getDefautDocumentVente.tmpl");
		qGet.setParam("Client_Id", oec_clientId);
		var result = qGet.execute();

		var contenu = result.responseXML.documentElement;

		oec_modeRegClient = contenu.getAttribute('Lib_Mode_Reg');
		oec_chargerModesReglements(contenu.getAttribute('Mode_Reg_Id'));
		oec_chargerModesExpedition(contenu.getAttribute('Mode_Expedition'));
		oec_chargerResponsables(contenu.getAttribute('Util_R'));
		oec_chargerTarifsVente(contenu.getAttribute('Tarif_Id'));

		var francoPort = contenu.getAttribute('Franco_Port')=="true";
		var montantFranco = contenu.getAttribute("Montant_Franco");
		oec_majFrancoPort(francoPort, montantFranco);

		document.getElementById('oec-remise').value = contenu.getAttribute('Taux_Remise');
		document.getElementById('oec-escompte').value = contenu.getAttribute('Taux_Escompte');
		document.getElementById('oec-bRemise').setAttribute("class", "bIcoPourcentage");
		oec_typeRemise = 'P';
		oec_chargerPolesActivite(contenu.getAttribute('Pole_Activite'));

		oec_assujettiTVA = contenu.getAttribute('Assujetti_TVA')=="true";
		document.getElementById('oec-assujettiTVA').checked = oec_assujettiTVA;
		document.getElementById('oec-numTVA').disabled = !oec_assujettiTVA;
		document.getElementById('oec-numTVA').value = contenu.getAttribute('Num_TVA_Intra');
		document.getElementById("oec-regimeTVA").value = contenu.getAttribute("Regime_TVA");

		document.getElementById('oec-indications').value = contenu.getAttribute("Indications");
		document.getElementById('oec-numClient').value = contenu.getAttribute('Num_Client');
		document.getElementById('oec-familleClient').value = contenu.getAttribute('Famille_Client');

		document.getElementById('oec-denominationFact').value = contenu.getAttribute('Denomination_Fact');
		document.getElementById('oec-adresse1Fact').value = contenu.getAttribute('Adresse_1_Fact');
		document.getElementById('oec-adresse2Fact').value = contenu.getAttribute('Adresse_2_Fact');
		document.getElementById('oec-adresse3Fact').value = contenu.getAttribute('Adresse_3_Fact');
		document.getElementById('oec-codePostalFact').value = contenu.getAttribute('Code_Postal_Fact');
		document.getElementById('oec-villeFact').value = contenu.getAttribute('Ville_Fact');
    document.getElementById('oec-codePaysFact').value = contenu.getAttribute('Code_Pays_Fact');
		document.getElementById('oec-civInterFact').value = contenu.getAttribute('Civ_Inter_Fact');
		document.getElementById('oec-nomInterFact').value = contenu.getAttribute('Nom_Inter_Fact');
		document.getElementById('oec-prenomInterFact').value = contenu.getAttribute('Prenom_Inter_Fact');
		document.getElementById('oec-telInter1Fact').value = contenu.getAttribute('Tel_Inter_1_Fact');
		document.getElementById('oec-telInter2Fact').value = contenu.getAttribute('Tel_Inter_2_Fact');
		document.getElementById('oec-faxInterFact').value = contenu.getAttribute('Fax_Inter_Fact');
		document.getElementById('oec-emailInterFact').value = contenu.getAttribute('Email_Inter_Fact');

		document.getElementById('oec-denominationLiv').value = contenu.getAttribute('Denomination_Liv');
		document.getElementById('oec-adresse1Liv').value = contenu.getAttribute('Adresse_1_Liv');
		document.getElementById('oec-adresse2Liv').value = contenu.getAttribute('Adresse_2_Liv');
		document.getElementById('oec-adresse3Liv').value = contenu.getAttribute('Adresse_3_Liv');
		document.getElementById('oec-codePostalLiv').value = contenu.getAttribute('Code_Postal_Liv');
		document.getElementById('oec-villeLiv').value = contenu.getAttribute('Ville_Liv');
    document.getElementById('oec-codePaysLiv').value = contenu.getAttribute('Code_Pays_Liv');
    document.getElementById('oec-civInterLiv').value = contenu.getAttribute('Civ_Inter_Liv');
		document.getElementById('oec-nomInterLiv').value = contenu.getAttribute('Nom_Inter_Liv');
		document.getElementById('oec-prenomInterLiv').value = contenu.getAttribute('Prenom_Inter_Liv');
		document.getElementById('oec-telInter1Liv').value = contenu.getAttribute('Tel_Inter_1_Liv');
		document.getElementById('oec-telInter2Liv').value = contenu.getAttribute('Tel_Inter_2_Liv');
		document.getElementById('oec-faxInterLiv').value = contenu.getAttribute('Fax_Inter_Liv');
		document.getElementById('oec-emailInterLiv').value = contenu.getAttribute('Email_Inter_Liv');

		document.getElementById('oec-denominationEnvoi').value = contenu.getAttribute('Denomination_EDC');
		document.getElementById('oec-adresse1Envoi').value = contenu.getAttribute('Adresse_1_EDC');
		document.getElementById('oec-adresse2Envoi').value = contenu.getAttribute('Adresse_2_EDC');
		document.getElementById('oec-adresse3Envoi').value = contenu.getAttribute('Adresse_3_EDC');
		document.getElementById('oec-codePostalEnvoi').value = contenu.getAttribute('Code_Postal_EDC');
		document.getElementById('oec-villeEnvoi').value = contenu.getAttribute('Ville_EDC');
    document.getElementById('oec-codePaysEnvoi').value = contenu.getAttribute('Code_Pays_EDC');
		document.getElementById('oec-civInterEnvoi').value = contenu.getAttribute('Civ_Inter_EDC');
		document.getElementById('oec-nomInterEnvoi').value = contenu.getAttribute('Nom_Inter_EDC');
		document.getElementById('oec-prenomInterEnvoi').value = contenu.getAttribute('Prenom_Inter_EDC');
		document.getElementById('oec-telInter1Envoi').value = contenu.getAttribute('Tel_Inter_1_EDC');
		document.getElementById('oec-telInter2Envoi').value = contenu.getAttribute('Tel_Inter_2_EDC');
		document.getElementById('oec-faxInterEnvoi').value = contenu.getAttribute('Fax_Inter_EDC');
		document.getElementById('oec-emailInterEnvoi').value = contenu.getAttribute('Email_Inter_EDC');

		document.getElementById('oec-denominationEF').value = contenu.getAttribute('Denomination_Envoi');
		document.getElementById('oec-adresse1EF').value = contenu.getAttribute('Adresse_1_Envoi');
		document.getElementById('oec-adresse2EF').value = contenu.getAttribute('Adresse_2_Envoi');
		document.getElementById('oec-adresse3EF').value = contenu.getAttribute('Adresse_3_Envoi');
		document.getElementById('oec-codePostalEF').value = contenu.getAttribute('Code_Postal_Envoi');
		document.getElementById('oec-villeEF').value = contenu.getAttribute('Ville_Envoi');
    document.getElementById('oec-codePaysEF').value = contenu.getAttribute('Code_Pays_Envoi');
		document.getElementById('oec-civInterEF').value = contenu.getAttribute('Civ_Inter_Envoi');
		document.getElementById('oec-nomInterEF').value = contenu.getAttribute('Nom_Inter_Envoi');
		document.getElementById('oec-prenomInterEF').value = contenu.getAttribute('Prenom_Inter_Envoi');
		document.getElementById('oec-telInter1EF').value = contenu.getAttribute('Tel_Inter_1_Envoi');
		document.getElementById('oec-telInter2EF').value = contenu.getAttribute('Tel_Inter_2_Envoi');
		document.getElementById('oec-faxInterEF').value = contenu.getAttribute('Fax_Inter_Envoi');
		document.getElementById('oec-emailInterEF').value = contenu.getAttribute('Email_Inter_Envoi');

		oec_listeTVAFraisPort();
    oec_selectPaysLiv();

		oec_ajouterLigne("I");
		oec_setModified(true);

		document.getElementById('oec-bChercherAdrLiv').disabled = (oec_aLignes.nbLignes()>0 && oec_etatCommande!="N");
    document.getElementById('oec-bCopierFactVersLivEnvoi').disabled = (oec_aLignes.nbLignes()>0 && oec_etatCommande!="N");
    document.getElementById('oec-tarifVente').disabled = (oec_aLignes.nbLignes()>0);
		document.getElementById('oec-bChercherAdrFact').disabled = false;
		document.getElementById('oec-bChercherInter').disabled = false;
		document.getElementById('oec-bChercherInterLiv').disabled = false;
		document.getElementById('oec-bChercherAdrEnvoi').disabled = false;
		document.getElementById('oec-bChercherInterEnvoi').disabled = false;
		document.getElementById('oec-bChercherAdrEF').disabled = false;
		document.getElementById('oec-bChercherInterEF').disabled = false;

	} catch (e) {
  	recup_erreur(e);
  }
}


function oec_evaluer(field, ev) {
	try {

		var val = field.value;

		if (ev.keyCode==13 && !isEmpty(val) && isArithmetic(val)) {
			field.value = calcExpr(val);
		}

	}	catch(e) {
		recup_erreur(e);
	}
}


function oec_pressOnLineNumberField(field, ev) {
	try {

		var val = field.value;

		if (ev.keyCode==13 && !isEmpty(val)) {
			if (isArithmetic(val)) {
				field.value = calcExpr(val);
			}
			else {
				oec_validerLigne();
			}
		}

	}	catch(e) {
		recup_erreur(e);
	}
}


function oec_changerTypeEdition(chgType) {
	try {

		oec_editionTTC = chgType;

		if (oec_editionTTC) {
			document.getElementById('oec-colTotal').setAttribute("label", "Total TTC");
			document.getElementById('oec-colPU').setAttribute("label", "P.U TTC");
			document.getElementById('oec-lblFraisPort').value = "Frais de port (ttc) :";
			document.getElementById('oec-lblPU').value = "P.U TTC :";
			document.getElementById('oec-piedTTC').collapsed = false;
			document.getElementById('oec-piedHT').collapsed = true;
		}
		else {
			document.getElementById('oec-colTotal').setAttribute("label", "Total HT");
			document.getElementById('oec-colPU').setAttribute("label", "P.U HT");
			document.getElementById('oec-lblFraisPort').value = "Frais de port (ht) :";
			document.getElementById('oec-lblPU').value = "P.U HT :";
			document.getElementById('oec-piedTTC').collapsed = true;
			document.getElementById('oec-piedHT').collapsed = false;
		}



	}	catch(e) {
		recup_erreur(e);
	}
}


function oec_changerAssujettiTVA(etat) {
	try {

		oec_assujettiTVA = etat;
		document.getElementById('oec-numTVA').disabled=!oec_assujettiTVA;
		oec_listeTVA();
		oec_setModified(true);

	}	catch(e) {
		recup_erreur(e);
	}
}


function oec_changerTypeVente() {
	try {

	  var qZoneUE = new QueryHttp("Facturation/Commun/getZoneUEPays.tmpl");
	  qZoneUE.setParam("Code_Pays", document.getElementById('oec-codePaysLiv').value);
	  var result = qZoneUE.execute();
	  oec_zoneUE = (result.responseXML.documentElement.getAttribute("Zone_UE")=="true");

	}	catch(e) {
		recup_erreur(e);
	}
}


function oec_rechercherAdrFact() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixAdresse.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oec_reporterAdrFact, oec_clientId, gReadOnly);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oec_reporterAdrFact(nom, adr1, adr2, adr3, cp, ville, pays, codePays, contactFact, contactLiv, contactEnvoi, contactDevis, adresseId) {
  try {

		document.getElementById('oec-denominationFact').value = nom;
		document.getElementById('oec-adresse1Fact').value = adr1;
		document.getElementById('oec-adresse2Fact').value = adr2;
		document.getElementById('oec-adresse3Fact').value = adr3;
		document.getElementById('oec-codePostalFact').value = cp;
		document.getElementById('oec-villeFact').value = ville;
	  document.getElementById('oec-codePaysFact').value = codePays;

	  if (!isEmpty(contactFact)) {
	  	var qLoad = new QueryHttp("Facturation/Clients/loadContactClient.tmpl");
	  	qLoad.setParam("Contact_Id", contactFact);
	  	var result = qLoad.execute();
	  	var contenu = result.responseXML.documentElement;
	  	oec_reporterInterFact(contenu.getAttribute("Civilite"), contenu.getAttribute("Nom"), contenu.getAttribute("Prenom"), contenu.getAttribute("Tel_1"), contenu.getAttribute("Tel_2"), contenu.getAttribute("Fax"), contenu.getAttribute("Email"));
	  }
		oec_setModified(true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oec_rechercherInterlocuteurFact() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixInter.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oec_reporterInterFact, oec_clientId, gReadOnly);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oec_reporterInterFact(civ, nom, prenom, tel1, tel2, fax, email) {
  try {
		document.getElementById('oec-civInterFact').value = civ;
		document.getElementById('oec-nomInterFact').value = nom;
		document.getElementById('oec-prenomInterFact').value = prenom;
		document.getElementById('oec-telInter1Fact').value = tel1;
		document.getElementById('oec-telInter2Fact').value = tel2;
		document.getElementById('oec-faxInterFact').value = fax;
		document.getElementById('oec-emailInterFact').value = email;

		oec_setModified(true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oec_rechercherAdrEnvoi() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixAdresse.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oec_reporterAdrEnvoi, oec_clientId, gReadOnly);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oec_reporterAdrEnvoi(nom, adr1, adr2, adr3, cp, ville, pays, codePays, contactFact, contactLiv, contactEnvoi, contactDevis, adresseId) {
  try {

		document.getElementById('oec-denominationEnvoi').value = nom;
		document.getElementById('oec-adresse1Envoi').value = adr1;
		document.getElementById('oec-adresse2Envoi').value = adr2;
		document.getElementById('oec-adresse3Envoi').value = adr3;
		document.getElementById('oec-codePostalEnvoi').value = cp;
		document.getElementById('oec-villeEnvoi').value = ville;
	  document.getElementById('oec-codePaysEnvoi').value = codePays;

	  if (!isEmpty(contactDevis)) {
	  	var qLoad = new QueryHttp("Facturation/Clients/loadContactClient.tmpl");
	  	qLoad.setParam("Contact_Id", contactDevis);
	  	var result = qLoad.execute();
	  	var contenu = result.responseXML.documentElement;
	  	oec_reporterInterEnvoi(contenu.getAttribute("Civilite"), contenu.getAttribute("Nom"), contenu.getAttribute("Prenom"), contenu.getAttribute("Tel_1"), contenu.getAttribute("Tel_2"), contenu.getAttribute("Fax"), contenu.getAttribute("Email"));
	  }

		oec_setModified(true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oec_rechercherAdrEF() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixAdresse.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oec_reporterAdrEF, oec_clientId, gReadOnly);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oec_reporterAdrEF(nom, adr1, adr2, adr3, cp, ville, pays, codePays, contactFact, contactLiv, contactEnvoi, contactDevis, adresseId) {
  try {

		document.getElementById('oec-denominationEF').value = nom;
		document.getElementById('oec-adresse1EF').value = adr1;
		document.getElementById('oec-adresse2EF').value = adr2;
		document.getElementById('oec-adresse3EF').value = adr3;
		document.getElementById('oec-codePostalEF').value = cp;
		document.getElementById('oec-villeEF').value = ville;
	  document.getElementById('oec-codePaysEF').value = codePays;

	  if (!isEmpty(contactEnvoi)) {
	  	var qLoad = new QueryHttp("Facturation/Clients/loadContactClient.tmpl");
	  	qLoad.setParam("Contact_Id", contactEnvoi);
	  	var result = qLoad.execute();
	  	var contenu = result.responseXML.documentElement;
	  	oec_reporterInterEF(contenu.getAttribute("Civilite"), contenu.getAttribute("Nom"), contenu.getAttribute("Prenom"), contenu.getAttribute("Tel_1"), contenu.getAttribute("Tel_2"), contenu.getAttribute("Fax"), contenu.getAttribute("Email"));
	  }

		oec_setModified(true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oec_copierFactVersLivEnvoi() {
	try {
		document.getElementById('oec-denominationLiv').value = document.getElementById('oec-denominationFact').value;
		document.getElementById('oec-adresse1Liv').value = document.getElementById('oec-adresse1Fact').value;
		document.getElementById('oec-adresse2Liv').value = document.getElementById('oec-adresse2Fact').value;
		document.getElementById('oec-adresse3Liv').value = document.getElementById('oec-adresse3Fact').value;
		document.getElementById('oec-codePostalLiv').value = document.getElementById('oec-codePostalFact').value;
		document.getElementById('oec-villeLiv').value = document.getElementById('oec-villeFact').value;
	  document.getElementById('oec-codePaysLiv').value = document.getElementById('oec-codePaysFact').value;
	  oec_listeTVAFraisPort();
	  oec_selectPaysLiv();
	  document.getElementById('oec-civInterLiv').value = document.getElementById('oec-civInterFact').value;
		document.getElementById('oec-nomInterLiv').value = document.getElementById('oec-nomInterFact').value;
		document.getElementById('oec-prenomInterLiv').value = document.getElementById('oec-prenomInterFact').value;
		document.getElementById('oec-telInter1Liv').value = document.getElementById('oec-telInter1Fact').value;
		document.getElementById('oec-telInter2Liv').value = document.getElementById('oec-telInter2Fact').value;
		document.getElementById('oec-faxInterLiv').value = document.getElementById('oec-faxInterFact').value;
		document.getElementById('oec-emailInterLiv').value = document.getElementById('oec-emailInterFact').value;

		document.getElementById('oec-denominationEnvoi').value = document.getElementById('oec-denominationFact').value;
		document.getElementById('oec-adresse1Envoi').value = document.getElementById('oec-adresse1Fact').value;
		document.getElementById('oec-adresse2Envoi').value = document.getElementById('oec-adresse2Fact').value;
		document.getElementById('oec-adresse3Envoi').value = document.getElementById('oec-adresse3Fact').value;
		document.getElementById('oec-codePostalEnvoi').value = document.getElementById('oec-codePostalFact').value;
		document.getElementById('oec-villeEnvoi').value = document.getElementById('oec-villeFact').value;
	  document.getElementById('oec-codePaysEnvoi').value = document.getElementById('oec-codePaysFact').value;
	  document.getElementById('oec-civInterEnvoi').value = document.getElementById('oec-civInterFact').value;
		document.getElementById('oec-nomInterEnvoi').value = document.getElementById('oec-nomInterFact').value;
		document.getElementById('oec-prenomInterEnvoi').value = document.getElementById('oec-prenomInterFact').value;
		document.getElementById('oec-telInter1Envoi').value = document.getElementById('oec-telInter1Fact').value;
		document.getElementById('oec-telInter2Envoi').value = document.getElementById('oec-telInter2Fact').value;
		document.getElementById('oec-faxInterEnvoi').value = document.getElementById('oec-faxInterFact').value;
		document.getElementById('oec-emailInterEnvoi').value = document.getElementById('oec-emailInterFact').value;

		document.getElementById('oec-denominationEF').value = document.getElementById('oec-denominationFact').value;
		document.getElementById('oec-adresse1EF').value = document.getElementById('oec-adresse1Fact').value;
		document.getElementById('oec-adresse2EF').value = document.getElementById('oec-adresse2Fact').value;
		document.getElementById('oec-adresse3EF').value = document.getElementById('oec-adresse3Fact').value;
		document.getElementById('oec-codePostalEF').value = document.getElementById('oec-codePostalFact').value;
		document.getElementById('oec-villeEF').value = document.getElementById('oec-villeFact').value;
	  document.getElementById('oec-codePaysEF').value = document.getElementById('oec-codePaysFact').value;
	  document.getElementById('oec-civInterEF').value = document.getElementById('oec-civInterFact').value;
		document.getElementById('oec-nomInterEF').value = document.getElementById('oec-nomInterFact').value;
		document.getElementById('oec-prenomInterEF').value = document.getElementById('oec-prenomInterFact').value;
		document.getElementById('oec-telInter1EF').value = document.getElementById('oec-telInter1Fact').value;
		document.getElementById('oec-telInter2EF').value = document.getElementById('oec-telInter2Fact').value;
		document.getElementById('oec-faxInterEF').value = document.getElementById('oec-faxInterFact').value;
		document.getElementById('oec-emailInterEF').value = document.getElementById('oec-emailInterFact').value;

	  oec_setModified(true);
	} catch (e) {
		recup_erreur(e);
	}
}


function oec_loadRecapitulatif() {
	try {

		var qRecap = new QueryHttp("Facturation/Affaires/getRecapitulatifCC.tmpl");
		qRecap.setParam("Commande_Id", oec_commandeId);
		var result = qRecap.execute();
		var contenu = result.responseXML.documentElement;

		document.getElementById('oec-caHT').value = contenu.getAttribute("CAHT") +" \u20AC";
		document.getElementById('oec-paHT').value = contenu.getAttribute("PAHT") +" \u20AC";
		document.getElementById('oec-margeHT').value = contenu.getAttribute("Marge_HT") +" \u20AC";
		document.getElementById('oec-tauxMarque').value = contenu.getAttribute("Taux_Marque") +" %";
		document.getElementById('oec-tauxMarge').value = contenu.getAttribute("Taux_Marge") +" %";
		document.getElementById('oec-nbLignes').value = contenu.getAttribute("Nb_Lignes");
		document.getElementById('oec-nbComClient').value = contenu.getAttribute("NbComClient");
		document.getElementById('oec-qteArticles').value = contenu.getAttribute("Qte_Articles");
		document.getElementById('oec-pictoMargeNegative').collapsed = true;
		if (contenu.getAttribute("Marge_Negative")=="true") {
			document.getElementById('oec-lblMargeHT').setAttribute("style", "color:red");
			document.getElementById('oec-margeHT').setAttribute("style", "color:red");
			document.getElementById('oec-lblTauxMarque').setAttribute("style", "color:red");
			document.getElementById('oec-tauxMarque').setAttribute("style", "color:red");
			document.getElementById('oec-lblTauxMarge').setAttribute("style", "color:red");
			document.getElementById('oec-tauxMarge').setAttribute("style", "color:red");
			document.getElementById('oec-pictoMargeNegative').collapsed = false;
		}
		document.getElementById('oec-nbArticlesDejaLivres').value = contenu.getAttribute("Nb_Articles_Deja_Livres");
		document.getElementById('oec-nbArticlesRestantALivrer').value = contenu.getAttribute("Nb_Articles_Restant_A_Livrer");
		document.getElementById('oec-avancementCommande').value = contenu.getAttribute("Avancement_Commande") +" %";

	} catch (e) {
    recup_erreur(e);
  }
}


function oec_rechercherAdrLiv() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixAdresse.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oec_reporterAdrLiv, oec_clientId, gReadOnly);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oec_reporterAdrLiv(nom, adr1, adr2, adr3, cp, ville, pays, codePays, contactFact, contactLiv, contactEnvoi, contactDevis, adresseId) {
  try {

		document.getElementById('oec-denominationLiv').value = nom;
		document.getElementById('oec-adresse1Liv').value = adr1;
		document.getElementById('oec-adresse2Liv').value = adr2;
		document.getElementById('oec-adresse3Liv').value = adr3;
		document.getElementById('oec-codePostalLiv').value = cp;
		document.getElementById('oec-villeLiv').value = ville;
	  document.getElementById('oec-codePaysLiv').value = codePays;
	  oec_listeTVAFraisPort();
	  oec_selectPaysLiv();

		if (!isEmpty(contactLiv)) {
	  	var qLoad = new QueryHttp("Facturation/Clients/loadContactClient.tmpl");
	  	qLoad.setParam("Contact_Id", contactLiv);
	  	var result = qLoad.execute();
	  	var contenu = result.responseXML.documentElement;
	  	oec_reporterInterLiv(contenu.getAttribute("Civilite"),contenu.getAttribute("Nom"),contenu.getAttribute("Prenom"), contenu.getAttribute("Tel_1"), contenu.getAttribute("Tel_2"), contenu.getAttribute("Fax"),contenu.getAttribute("Email"));
	  }
	  oec_setModified(true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oec_rechercherInterlocuteurLiv() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixInter.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oec_reporterInterLiv, oec_clientId, gReadOnly);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oec_reporterInterLiv(civ, nom, prenom, tel1, tel2, fax, email) {
  try {

		document.getElementById('oec-civInterLiv').value = civ;
		document.getElementById('oec-nomInterLiv').value = nom;
		document.getElementById('oec-prenomInterLiv').value = prenom;
		document.getElementById('oec-telInter1Liv').value = tel1;
		document.getElementById('oec-telInter2Liv').value = tel2;
		document.getElementById('oec-faxInterLiv').value = fax;
		document.getElementById('oec-emailInterLiv').value = email;

		oec_setModified(true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oec_rechercherInterlocuteurEnvoi() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixInter.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oec_reporterInterEnvoi, oec_clientId, gReadOnly);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oec_reporterInterEnvoi(civ, nom, prenom, tel1, tel2, fax, email) {
  try {

		document.getElementById('oec-civInterEnvoi').value = civ;
		document.getElementById('oec-nomInterEnvoi').value = nom;
		document.getElementById('oec-prenomInterEnvoi').value = prenom;
		document.getElementById('oec-telInter1Envoi').value = tel1;
		document.getElementById('oec-telInter2Envoi').value = tel2;
		document.getElementById('oec-faxInterEnvoi').value = fax;
		document.getElementById('oec-emailInterEnvoi').value = email;

		oec_setModified(true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oec_rechercherInterlocuteurEF() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixInter.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oec_reporterInterEF, oec_clientId, gReadOnly);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oec_reporterInterEF(civ, nom, prenom, tel1, tel2, fax, email) {
  try {

		document.getElementById('oec-civInterEF').value = civ;
		document.getElementById('oec-nomInterEF').value = nom;
		document.getElementById('oec-prenomInterEF').value = prenom;
		document.getElementById('oec-telInter1EF').value = tel1;
		document.getElementById('oec-telInter2EF').value = tel2;
		document.getElementById('oec-faxInterEF').value = fax;
		document.getElementById('oec-emailInterEF').value = email;

		oec_setModified(true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oec_choisirMentions() {
  try {

  	var ok = true;

  	if (oec_mode=="C") {
			ok = oec_enregistrerCommande(true);
		}

		if (ok) {
			var url = "chrome://opensi/content/facturation/user/commun/popup-mentionsDocument.xul";
    	window.openDialog(url,'','chrome,modal,centerscreen', "CC", oec_commandeId, gReadOnly);
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oec_validerCommande() {
	try {

		var montantBase = (oec_editionTTC?oec_montantTTC:oec_montantHT);
		var remise = document.getElementById('oec-remise').value;
		var fraisPort = document.getElementById('oec-fraisPort').value;
		var remiseFP = document.getElementById('oec-remiseFP').value;

		if (oec_aLignes.nbLignes()==0) { showWarning("La commande ne contient aucune ligne !"); }
		else if (document.getElementById("oec-modeReglement").selectedIndex==0) { showWarning("Veuillez choisir un mode de r\u00E8glement avant de valider la commande !") }
		else if (isEmpty(remise) || (oec_typeRemise=='P'?!isTaux(remise):!isPositiveOrNull(remise) || !checkNumber(remise,9,2) || parseFloat(remise)>montantBase)) {
			showWarning("Remise incorrecte !");
		}
		else if (isEmpty(remiseFP) || (oec_typeRemiseFP=='P'?!isTaux(remiseFP):!isPositiveOrNull(remiseFP) || !checkNumber(remiseFP,9,2) || parseFloat(remiseFP)>fraisPort)) {
			showWarning("Remise sur frais de port incorrecte !");
		}
		else {
			var ok = true;

			if (oec_alerteEncoursClient) {
				var qEncours = new QueryHttp("Facturation/Affaires/getDepassementEncoursClient.tmpl");
				qEncours.setParam("Commande_Id", oec_commandeId);
				var result = qEncours.execute();

				var depassement = parseFloat(result.responseXML.documentElement.getAttribute("Depassement"));
				if (depassement>0) {
					ok = window.confirm("L'encours autoris\u00E9 du client est d\u00E9pass\u00E9, voulez-vous continuer ?");
				}
			}

			document.getElementById('oec-bValiderCommande').disabled = true;

			if (ok && window.confirm("Voulez-vous valider la commande ?")) {
				var qValid = new QueryHttp("Facturation/Affaires/validerCommande.tmpl");
				qValid.setParam("Commande_Id", oec_commandeId);
				var result = qValid.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					showWarning("La commande est valid\u00E9e");

					if (gConfig.isGACRemainAfterValCC()) {
						oec_chargerCommande();
					}
					else {
						retourFicheAffaire();
					}
				}
			}
			else {
				document.getElementById('oec-bValiderCommande').disabled = false;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_annulerCommande() {
	try {

		var montantBase = (oec_editionTTC?oec_montantTTC:oec_montantHT);
		var remise = document.getElementById('oec-remise').value;
		var fraisPort = document.getElementById('oec-fraisPort').value;
		var remiseFP = document.getElementById('oec-remiseFP').value;

		if (document.getElementById("oec-modeReglement").selectedIndex==0) {
			showWarning("Veuillez choisir un mode de r\u00E8glement avant d'annuler la commande");
		}
		else if (isEmpty(remise) || (oec_typeRemise=='P'?!isTaux(remise):!isPositiveOrNull(remise) || !checkNumber(remise,9,2) || parseFloat(remise)>montantBase)) {
			showWarning("Remise incorrecte : Veuillez corriger avant d'annuler la commande");
		}
		else if (isEmpty(remiseFP) || (oec_typeRemiseFP=='P'?!isTaux(remiseFP):!isPositiveOrNull(remiseFP) || !checkNumber(remiseFP,9,2) || parseFloat(remiseFP)>fraisPort)) {
			showWarning("Remise sur frais de port incorrecte : Veuillez corriger avant d'annuler la commande");
		}
		else if (window.confirm("Voulez-vous annuler la commande ?")) {
			var qCancel = new QueryHttp("Facturation/Affaires/annulerCommande.tmpl");
			qCancel.setParam("Commande_Id", oec_commandeId);
			var result = qCancel.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				if (gConfig.isGACPropRbtAnnul()) {

					var qCheck = new QueryHttp("Facturation/Affaires/checkRemboursementPossible.tmpl");
					qCheck.setParam("Document_Id", oec_commandeId);
					qCheck.setParam("Type_Doc", "C");
					var result2 = qCheck.execute();

					var errors2 = new Errors(result2);
					if (errors2.hasNext()) {
						errors2.show();
					}
					else {
						var rbtPossible = result2.responseXML.documentElement.getAttribute("Possible")=="true";

						if (rbtPossible && window.confirm("Voulez-vous cr\u00E9er un remboursement \u00E0 effectuer pour cette commande ?")) {
							var denominationFact = document.getElementById('oec-denominationFact').value;

							var url = "chrome://opensi/content/facturation/user/affaires/popup-creationRemboursement.xul";
							window.openDialog(url,'','chrome,modal,centerscreen', "C", oec_commandeId, oec_clientId, denominationFact);
						}
					}
				}

				showWarning("La commande est annul\u00E9e !");
				retourFicheAffaire();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_solderCommande() {
	try {

		if (window.confirm("Voulez-vous solder la commande ?")) {
			var qSolderCommande = new QueryHttp("Facturation/Affaires/solderCommande.tmpl");
			qSolderCommande.setParam("Commande_Id", oec_commandeId);
			var result = qSolderCommande.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showWarning("La commande est sold\u00E9e !");
				retourFicheAffaire();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_solderLigne() {
	try {

		if (oec_aLignes.isSelected() && oec_aLignes.getSelectedCellText('oec-colTypeLigne')!="C") {
			if (oec_aLignes.getSelectedCellText('oec-colSoldee')=="true") {
				showWarning("La ligne est d\u00E9j\u00E0 sold\u00E9e");
			}
			else if (window.confirm("Confirmez-vous le solde de la ligne s\u00E9lectionn\u00E9e ?\n(Attention plus aucune livraison possible !)")) {
				var qSolder = new QueryHttp("Facturation/Affaires/settleLigneCommandeClient.tmpl");
	  		qSolder.setParam("Ligne_Id", oec_aLignes.getSelectedCellText('oec-colLigneId'));
	  		var result = qSolder.execute();

	  		var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					oec_chargerCommande();
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_bloquerCommande() {
	try {

		if (window.confirm("Voulez-vous bloquer la commande ?")) {
			var qLock = new QueryHttp("Facturation/Affaires/bloquerCommande.tmpl");
			qLock.setParam("Commande_Id", oec_commandeId);
			var result = qLock.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showWarning("La commande est bloqu\u00E9e !");
				oec_bloque = true;
				retourFicheAffaire();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_debloquerCommande() {
	try {

		if (window.confirm("Voulez-vous d\u00E9bloquer la commande ?")) {
			var qUnlock = new QueryHttp("Facturation/Affaires/debloquerCommande.tmpl");
			qUnlock.setParam("Commande_Id", oec_commandeId);
			var result = qUnlock.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showWarning("La commande est d\u00E9bloqu\u00E9e !");
				oec_bloque = false;
				retourFicheAffaire();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_cloturerCommande() {
	try {

		if (window.confirm("Voulez-vous cl\u00F4turer la commande ?")) {
			var qClose = new QueryHttp("Facturation/Affaires/cloturerCommande.tmpl");
			qClose.setParam("Commande_Id", oec_commandeId);
			var result = qClose.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showWarning("La commande est clotur\u00E9e !");
				retourFicheAffaire();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_decloturerCommande() {
	try {

		if (window.confirm("Voulez-vous d\u00E9cl\u00F4turer la commande ?")) {
			var qUnclose = new QueryHttp("Facturation/Affaires/decloturerCommande.tmpl");
			qUnclose.setParam("Commande_Id", oec_commandeId);
			var result = qUnclose.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			oec_chargerCommande();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_modifierCommande() {
	try {

		oec_debloquerChamps();

		document.getElementById('oec-bAnnulerCommande').disabled = true;
		document.getElementById('oec-bModifier').disabled = true;
		document.getElementById('oec-bBloquer').disabled = true;
		document.getElementById('oec-bBloquer').collapsed = true;
		document.getElementById('oec-bDebloquer').disabled = true;
		document.getElementById('oec-bDebloquer').collapsed = true;
		document.getElementById('oec-bCloturer').collapsed = true;
		document.getElementById('oec-bDecloturer').collapsed = true;
		document.getElementById('oec-bSolder').disabled = true;
		document.getElementById('oec-bVisualiser').disabled = true;
		document.getElementById('oec-bProforma').disabled = true;
		document.getElementById('oec-bCopierCommande').collapsed = true;
		document.getElementById('oec-assujettiTVA').disabled = (!oec_premiereCommande || oec_aLignes.nbLignes()>0);
		document.getElementById('oec-editionTTC').disabled = (!oec_premiereCommande || oec_aLignes.nbLignes()>0);
		document.getElementById('oec-codePaysLiv').disabled = (oec_aLignes.nbLignes()>0);
    document.getElementById('oec-bCopierFactVersLivEnvoi').disabled = (oec_aLignes.nbLignes()>0);
		document.getElementById('oec-bImporterLignes').disabled = false;
		document.getElementById('oec-bExporterLignes').disabled = (oec_aLignes.nbLignes()==0);
		var clientConnu = !isEmpty(oec_clientId);
		document.getElementById('oec-bChercherAdrFact').disabled = !clientConnu;
		document.getElementById('oec-bChercherAdrEnvoi').disabled = !clientConnu;
		document.getElementById('oec-bChercherAdrEF').disabled = !clientConnu;
		document.getElementById('oec-bChercherInter').disabled = !clientConnu;
		document.getElementById('oec-bChercherInterLiv').disabled = !clientConnu;
		document.getElementById('oec-bChercherInterEnvoi').disabled = !clientConnu;
		document.getElementById('oec-bChercherInterEF').disabled = !clientConnu;
    document.getElementById('oec-etablissement').disabled = (oec_existeBL || oec_existeFacture || !oec_gestionEtab);
		document.getElementById('oec-depot').disabled = oec_existeBL;
		document.getElementById('oec-tarifVente').disabled = true;
		document.getElementById('oec-regimeTVA').disabled = true;
		document.getElementById('oec-bSolderLigne').disabled = true;
		oec_mode = "M";

		oec_aLignes.clearSelection();

		oec_ajouterLigne("I");

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_editerProforma() {
  try {

  	if (oec_aLignes.nbLignes()==0) {
			showWarning("La commande ne contient aucune ligne !");
		}
		else {
			oec_typeEditionPdf = "PF";

			var qCreate = new QueryHttp("Facturation/Affaires/creerProformaCommande.tmpl");
			qCreate.setParam("Commande_Id", oec_commandeId);
			var result = qCreate.execute();
			oec_docIdPdf = result.responseXML.documentElement.getAttribute("Proforma_Id");

			var qLangueDefaut = new QueryHttp("Facturation/Commun/getLangueDefaut.tmpl");
			qLangueDefaut.setParam("Type_Doc", "PF");
			qLangueDefaut.setParam("Doc_Id", oec_docIdPdf);
			var result = qLangueDefaut.execute();
			oec_langueDefaut = result.responseXML.documentElement.getAttribute("Langue_Id");
			oec_aLangues.setParam("Selection", oec_langueDefaut);
			oec_aLangues.initTree(oec_initLangue);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oec_visualiserProforma() {
  try {

  	document.getElementById('oec-pdfCommande').setAttribute('src', '');
		document.getElementById('oec-boxEdition').collapsed = false;
		document.getElementById('oec-deckCommande').selectedIndex = 1;
		document.getElementById('oec-bSwitchPdf').collapsed = true;
		document.getElementById('bRetourCommande').collapsed = false;

		var qGenPdf = new QueryHttp("Facturation/Proforma/pdfProforma.tmpl");
		qGenPdf.setParam('Proforma_Id', oec_docIdPdf);
		qGenPdf.setParam('Langue_Id', document.getElementById('oec-langueDefaut').value);

		var result = qGenPdf.execute();
		var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
		document.getElementById('oec-pdfCommande').setAttribute("src", page);

	} catch (e) {
    recup_erreur(e);
  }
}



function oec_switchPdf() {
	try {
		oec_editionPdf = (oec_editionPdf=='C'?'OF':'C');
		document.getElementById('oec-bSwitchPdf').setAttribute('label', oec_editionPdf=='C'?'Ordre de fabrication':'Commande client');
		oec_reediterPdf();
	} catch (e) {
		recup_erreur(e);
	}
}


function oec_editerCommande() {
	try {

		if (oec_aLignes.nbLignes()==0) {
			showWarning("La commande ne contient aucune ligne !");
		}
		else if (document.getElementById("oec-modeReglement").selectedIndex==0) {
			showWarning("Veuillez choisir un mode de r\u00E8glement");
		}
		else {
			oec_editionInitiale = false;
			oec_typeEditionPdf = "CC";
			oec_docIdPdf = oec_commandeId;

			var qLangueDefaut = new QueryHttp("Facturation/Commun/getLangueDefaut.tmpl");
			qLangueDefaut.setParam("Type_Doc", "CC");
			qLangueDefaut.setParam("Doc_Id", oec_commandeId);
			var result = qLangueDefaut.execute();
			oec_langueDefaut = result.responseXML.documentElement.getAttribute("Langue_Id");
			oec_aLangues.setParam("Selection", oec_langueDefaut);
			oec_aLangues.initTree(oec_initLangue);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_initLangue() {
	try {

		document.getElementById('oec-langueDefaut').value = oec_langueDefaut;

		if (oec_typeEditionPdf=="FAC") {
			oec_visualiserAcompte();
		}
		else if (oec_typeEditionPdf=="PF") {
			oec_visualiserProforma();
		}
		else {
			oec_visualiserCommande();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_reediterPdf() {
	try {

		document.getElementById('oec-pdfCommande').setAttribute('src', '');

		if (oec_typeEditionPdf=="PF") {
			oec_visualiserProforma();
		}
		else {
			var langue = document.getElementById('oec-langueDefaut').value;
			var qGenPdf;

			if (oec_typeEditionPdf=="FAC") {
				document.getElementById('oec-rappelLoi').collapsed = false;

				qGenPdf = new QueryHttp("Facturation/Affaires/pdfAcompte.tmpl");
				qGenPdf.setParam('Acompte_Id', oec_docIdPdf);
			}
			else if (oec_editionPdf=='C') {
				oec_typeEditionPdf = "CC";
				qGenPdf = new QueryHttp("Facturation/Affaires/pdfCommande.tmpl");
				qGenPdf.setParam('Commande_Id', oec_commandeId);
				qGenPdf.setParam('Initiale', oec_editionInitiale);
			}
			else {
				oec_typeEditionPdf = "CCOF";
				qGenPdf = new QueryHttp("Facturation/Affaires/pdfOrdreFabricationCC.tmpl");
				qGenPdf.setParam('Commande_Id', oec_commandeId);
				qGenPdf.setParam('Initiale', oec_editionInitiale);
			}

			qGenPdf.setParam('Langue_Id', langue);

			var result = qGenPdf.execute();
			var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');

			document.getElementById('oec-pdfCommande').setAttribute("src", page);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_editerCommandeInitiale() {
	try {

		if (oec_aLignes.nbLignes()==0) {
			showWarning("La commande ne contient aucune ligne !");
		}
		else {
			oec_editionInitiale = true;
			oec_typeEditionPdf = "CC";
			oec_docIdPdf = oec_commandeId;

			var qLangueDefaut = new QueryHttp("Facturation/Commun/getLangueDefaut.tmpl");
			qLangueDefaut.setParam("Type_Doc", "CCI");
			qLangueDefaut.setParam("Doc_Id", oec_commandeId);
			var result = qLangueDefaut.execute();
			oec_langueDefaut = result.responseXML.documentElement.getAttribute("Langue_Id");

			oec_aLangues.setParam("Selection", oec_langueDefaut);
			oec_aLangues.initTree(oec_initLangue);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_visualiserCommande() {
  try {

		oec_editionPdf = 'C';
		document.getElementById('oec-bSwitchPdf').setAttribute('label', 'Ordre de fabrication');
		document.getElementById('oec-pdfCommande').setAttribute('src', '');
		document.getElementById('oec-boxEdition').collapsed = false;
		document.getElementById('oec-deckCommande').selectedIndex = 1;
		document.getElementById('oec-bSwitchPdf').collapsed = false;
		document.getElementById('bRetourCommande').collapsed = false;

		var qGenPdf = new QueryHttp("Facturation/Affaires/pdfCommande.tmpl");
		qGenPdf.setParam('Commande_Id', oec_commandeId);
		qGenPdf.setParam('Langue_Id', document.getElementById('oec-langueDefaut').value);
		qGenPdf.setParam('Initiale', oec_editionInitiale);

		var result = qGenPdf.execute();
		var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');

		document.getElementById('oec-pdfCommande').setAttribute('src', page);

	} catch (e) {
    recup_erreur(e);
  }
}


function oec_copierCommande() {
	try {

		var url = "chrome://opensi/content/facturation/user/affaires/popup-copierCommande.xul";
 		window.openDialog(url,'','chrome,modal,centerscreen', oec_commandeId, oec_retourCopierCommande);

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_retourCopierCommande(copieId, typeCopie) {
	try {

		if (typeCopie=="D") {
			window.location = "chrome://opensi/content/facturation/user/devis/gestionDevis.xul?Devis_Id="+ copieId;
		}
		else {
			oec_commandeId = copieId;
			oec_chargerCommande();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_nouvelAcompte() {
	try {

 		var url = "chrome://opensi/content/facturation/user/affaires/popup-creerAcompte.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', oec_retourNouvelAcompte, oec_commandeId);

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_retourNouvelAcompte(acompteId) {
	try {
		oec_retourAcompte();
		oec_editerAcompte(acompteId);
	} catch (e) {
		recup_erreur(e);
	}
}


function oec_editerAcompte(acompteId) {
	try {
		document.getElementById('oec-pdfCommande').setAttribute('src', '');
		document.getElementById('oec-boxEdition').collapsed = false;
		document.getElementById('oec-deckCommande').selectedIndex = 1;
		document.getElementById('oec-bSwitchPdf').collapsed = true;
		document.getElementById('bRetourCommande').collapsed = false;

		oec_typeEditionPdf = "FAC";
		oec_docIdPdf = acompteId;

		var qLangueDefaut = new QueryHttp("Facturation/Commun/getLangueDefaut.tmpl");
		qLangueDefaut.setParam("Type_Doc", "FAC");
		qLangueDefaut.setParam("Doc_Id", acompteId);
		var result = qLangueDefaut.execute();
		oec_langueDefaut = result.responseXML.documentElement.getAttribute("Langue_Id");
		oec_aLangues.setParam("Selection", oec_langueDefaut);
		oec_aLangues.initTree(oec_initLangue);
	} catch (e) {
		recup_erreur(e);
	}
}


function oec_visualiserAcompte() {
  try {

  	var langue = document.getElementById('oec-langueDefaut').value;

		document.getElementById('oec-rappelLoi').collapsed = false;

		var qGenPdf = new QueryHttp("Facturation/Affaires/pdfAcompte.tmpl");
		qGenPdf.setParam('Acompte_Id', oec_docIdPdf);
		qGenPdf.setParam('Langue_Id', langue);

		var result = qGenPdf.execute();
		var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');

		document.getElementById('oec-pdfCommande').setAttribute('src', page);

	} catch (e) {
    recup_erreur(e);
  }
}


function oec_pressOnListeAcomptes() {
	try {

		if (oec_aAcomptes.isSelected()) {
			var statut = oec_aAcomptes.getSelectedCellText('oec-colStatut');
			var impute = oec_aAcomptes.getSelectedCellText('oec-colImpute');
			document.getElementById('oec-bAnnulerAcompte').disabled = (statut=="A" || impute=="true");
			document.getElementById('oec-bReediterAcompte').disabled = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_annulerAcompte() {
	try {

		if (oec_aAcomptes.isSelected() && window.confirm("Voulez-vous annuler cet acompte ?")) {

			var acompteId = oec_aAcomptes.getSelectedCellText('oec-colAcompteId');
			var qAnnulerAcompte = new QueryHttp("Facturation/Affaires/cancelAcompteClient.tmpl");
			qAnnulerAcompte.setParam("Acompte_Id", acompteId);
			var result = qAnnulerAcompte.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			oec_aAcomptes.initTree(oec_retourAcompte);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_retourAcompte() {
	try {

		oec_aAcomptes.initTree();
		document.getElementById('oec-bAnnulerAcompte').disabled = true;
		document.getElementById('oec-bReediterAcompte').disabled = true;
		oec_majAcompte();
		oec_calculTotaux();

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_majAcompte() {
	try {

		var qGet = new QueryHttp("Facturation/Affaires/loadCommandeClient.tmpl");
		qGet.setParam("Commande_Id", oec_commandeId);
		var result = qGet.execute();
		var contenu = result.responseXML.documentElement;
		oec_acompte = contenu.getAttribute('Acompte');
		document.getElementById('oec-boxNouvelAcompte').collapsed = (contenu.getAttribute("Autoriser_Acompte")=="false" || gReadOnly);

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_reediterAcompte() {
	try {

		if (oec_aAcomptes.isSelected()) {
			var acompteId = oec_aAcomptes.getSelectedCellText('oec-colAcompteId');
			oec_editerAcompte(acompteId);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_envoyerMail() {
	try {

		var langue = document.getElementById('oec-langueDefaut').value;

		var url = "chrome://opensi/content/popup/popup-envoyerMail.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', oec_typeEditionPdf, oec_docIdPdf, langue, oec_editionInitiale);

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_nouveauReglement() {
	try {

		var denomination = document.getElementById('oec-denominationFact').value;
		var modeRegId = document.getElementById('oec-modeReglement').value;

		var url = "chrome://opensi/content/facturation/user/affaires/popup-creerReglement.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', oec_retourNouveauReglement, oec_commandeId, oec_clientId, denomination, modeRegId);

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_retourNouveauReglement() {
	try {

		var qGet = new QueryHttp("Facturation/Affaires/loadCommandeClient.tmpl");
		qGet.setParam("Commande_Id", oec_commandeId);
		var result = qGet.execute();
		var contenu = result.responseXML.documentElement;

		document.getElementById('oec-caTTCPaye').value = contenu.getAttribute("CA_TTC_Paye");
		document.getElementById('oec-pourcCATTCPaye').value = contenu.getAttribute("Pourc_CA_TTC_Paye");
		document.getElementById('oec-soldeAEncaisser').value = contenu.getAttribute("Solde_A_Encaisser");
		document.getElementById('oec-pourcSoldeAEncaisser').value = contenu.getAttribute("Pourc_Solde_A_Encaisser");
		document.getElementById('oec-encoursActuel').value = contenu.getAttribute("En_Cours_Actuel") + " \u20AC";
		var clientBloque = contenu.getAttribute("Client_Bloque")=="true";

		if (!clientBloque && contenu.getAttribute("Encours_Client_Depasse")=="false" && contenu.getAttribute("Encours_Facturation_Depasse")=="false") {
			document.getElementById('oec-boxWarning').collapsed = true;
		}
		if (!clientBloque && contenu.getAttribute("Encours_Client_Depasse")=="false") {
			document.getElementById('oec-depEncoursClient').collapsed = true;
		}
		if (!clientBloque && contenu.getAttribute("Encours_Facturation_Depasse")=="false") {
			document.getElementById('oec-depEncoursFacturation').collapsed = true;
		}

		var statutPaiement = contenu.getAttribute("Statut_Paiement");
		var libelleStatutPaiement = "";
		if (statutPaiement=="N") { libelleStatutPaiement = "Non pay\u00E9e"; }
		else if (statutPaiement=="T") { libelleStatutPaiement = "Pay\u00E9e"; }
		else if (statutPaiement=="P") { libelleStatutPaiement = "Part. pay\u00E9e"; }
		document.getElementById('oec-statutPaiement').value = libelleStatutPaiement;

		oec_aListeReglements.initTree(oec_initListeReglements);

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_initListeReglements() {
	try {

		document.getElementById('oec-bSupprimerReglement').disabled = true;
		document.getElementById('oec-bAnnulerReglement').disabled = true;
		document.getElementById('oec-bDesaffecterAvoir').disabled = true;

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_initVersion() {
	try {

		oec_aVersion.setParam("Commande_Id", oec_commandeId);
		oec_aVersion.initTree();

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_selectOnListeReglements() {
	try {

		if (oec_aListeReglements.isSelected()) {
			var i = oec_aListeReglements.getCurrentIndex();
			document.getElementById('oec-bSupprimerReglement').disabled = (oec_aListeReglements.getCellText(i, "oec-colSupprimable")=="false");
			document.getElementById('oec-bAnnulerReglement').disabled = (oec_aListeReglements.getCellText(i, "oec-colAnnulable")=="false");
			document.getElementById('oec-bDesaffecterAvoir').disabled = (oec_aListeReglements.getCellText(i, "oec-colDesaffectable")=="false");
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_supprimerReglement() {
	try {

		if (oec_aListeReglements.isSelected()) {
			var i = oec_aListeReglements.getCurrentIndex();
			if (oec_aListeReglements.getCellText(i, "oec-colSupprimable")=="true") {
				var reglementId = oec_aListeReglements.getCellText(i, "oec-colReglementId");
				var qDelete = new QueryHttp("Facturation/Suivi_Reglements_Clients/deleteReglementClient.tmpl");
				qDelete.setParam("Reglement_Id", reglementId);
				var result = qDelete.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					showWarning("Le r\u00E8glement a \u00E9t\u00E9 supprim\u00E9");
					oec_retourNouveauReglement();
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_annulerReglement() {
	try {

		if (oec_aListeReglements.isSelected() && window.confirm("Voulez-vous annuler le r\u00E8glement s\u00E9lectionn\u00E9 ?")) {
			var reglementId = oec_aListeReglements.getSelectedCellText("oec-colReglementId");

			var url = "chrome://opensi/content/facturation/user/suivi_reglements_clients/popup-choixMotifAnnulation.xul";
			window.openDialog(url,'','chrome,modal,centerscreen', oec_retourAnnulerReglement, reglementId);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_retourAnnulerReglement() {
	try {

		showWarning("Le r\u00E8glement a \u00E9t\u00E9 annul\u00E9");
		oec_retourNouveauReglement();

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_affecterAvoir() {
	try {

		var url = "chrome://opensi/content/facturation/user/affaires/popup-affectationAvoirCommande.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oec_retourAffecterAvoir, oec_clientId);

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_retourAffecterAvoir(avoirId) {
	try {

		var qAssign = new QueryHttp("Facturation/Affaires/assignAvoirCommande.tmpl");
	  qAssign.setParam("Commande_Id", oec_commandeId);
	  qAssign.setParam("Avoir_Id", avoirId);
	  var result = qAssign.execute();

	  var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			oec_retourNouveauReglement();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_desaffecterAvoir() {
	try {

		if (oec_aListeReglements.isSelected() && window.confirm("Voulez-vous d\u00E9saffecter l'avoir s\u00E9lectionn\u00E9 de la commande ?")) {
			var avoirId = oec_aListeReglements.getSelectedCellText("oec-colReglementId");

			var qUnassign = new QueryHttp("Facturation/Affaires/unassignAvoirCommande.tmpl");
			qUnassign.setParam("Commande_Id", oec_commandeId);
	  	qUnassign.setParam("Avoir_Id", avoirId);
	  	var result = qUnassign.execute();

	  	var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oec_retourNouveauReglement();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_envoyerLPE() {
  try {

		var email = document.getElementById('oec-emailInterFact').value;
		var montant = oec_editionTTC?document.getElementById('oec-pttcTotalTTC').value:document.getElementById('oec-totalTTC').value;
		var numCommande = document.getElementById('oec-numCommande').value;

		var url = "chrome://opensi/content/facturation/user/affaires/popup-envoiLPE.xul";
  	window.openDialog(url,'','chrome,modal,centerscreen', oec_commandeId, email, montant, numCommande);

	} catch (e) {
    recup_erreur(e);
  }
}


function oec_majFrancoPort(francoPort, montantFranco) {
	try {

		var lblFrancoPort = "";
		if (!francoPort) { lblFrancoPort = "Non"; }
		else { lblFrancoPort = (parseFloat(montantFranco)==0?"Oui":nf2.format(montantFranco) +" \u20AC"); }
		document.getElementById('oec-lblFrancoPort').value = lblFrancoPort;
		document.getElementById('oec-rowFrancoPort').collapsed = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_ouvrirLien() {
	try {

		window.open(document.getElementById('oec-lien').value + parent.document.getElementById("login").value);

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_exportLignes() {
  try {

	  var qExp = new QueryHttp("Facturation/Affaires/csvLigneCommandeClient.tmpl");
	  qExp.setParam("Commande_Id", oec_commandeId);
	  var result = qExp.execute();

	  var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');
			var file = fileChooser("save", fichier);
			if (file!=null) {
				downloadFile(getDirBuffer()+ fichier, file);
			}
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function oec_importLignes() {
  try {

	  var url = "chrome://opensi/content/facturation/user/affaires/popup-importerLignes.xul";
	  window.openDialog(url,'','chrome,modal,centerscreen', oec_retourImportLignes, oec_commandeId, oec_etatCommande);

  } catch (e) {
    recup_erreur(e);
  }
}


function oec_retourImportLignes() {
	try {

		oec_aLignes.initTree(oec_afterRefreshArticles);

	} catch (e) {
	  recup_erreur(e);
	}
}


function oec_clickOnColis(tree, ev) {

	gClipboardHelper.copyString(oec_aLiensColis.getSelectedCellText("oec-colNumColis"));

	var col = oec_aLiensColis.getClickedCol(ev);

	if (col!=null && col.id=="oec-colNumColis") {
		var lien = oec_aLiensColis.getSelectedCellValue("oec-colNumColis");
		if (!isEmpty(lien)) {
			//window.open(lien);
			openInNavigator(lien);
		}
	}
	else if (col!=null && col.id=="oec-colCTC") {
		window.open(oec_aLiensColis.getSelectedCellValue("oec-colCTC"));
	}
}


function oec_keypressOnColis(ev) {
  try {

		if ((ev.key=='w' || ev.key=='W') && ev.ctrlKey && oec_aLiensColis.isSelected()) {
			// ctrl + w pour copier l'adresse du lien
			gClipboardHelper.copyString(oec_aLiensColis.getSelectedCellValue("oec-colNumColis"));
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oec_pressOnColis() {
  try {

		if (oec_aLiensColis.isSelected()) {
			document.getElementById('oec-bAnnulerColis').disabled = (oec_aLiensColis.getSelectedCellText("oec-colStatut")!="V");
		}
		else {
			document.getElementById('oec-bAnnulerColis').disabled = true;
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oec_annulerColis() {
  try {

		document.getElementById('oec-bAnnulerColis').disabled = true;

		if (window.confirm("Confirmez-vous l'annulation du colis s\u00E9lectionn\u00E9 ?")) {

			var colisId = oec_aLiensColis.getSelectedCellText("oec-colColisId");

			var qCancel = new QueryHttp("Facturation/Affaires/cancelColis.tmpl");
			qCancel.setParam("Colis_Id", colisId);
			var result = qCancel.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("Le colis a \u00E9t\u00E9 annul\u00E9");
			}
			oec_aLiensColis.initTree();
		}
		else {
			document.getElementById('oec-bAnnulerColis').disabled = false;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oec_rechercherPointRelais() {
  try {

		var modeExpedition = document.getElementById('oec-modeExpedition').value;

		if (isEmpty(modeExpedition)) {
			showWarning("Veuillez choisir un mode d'exp\u00E9dition pour acc\u00E9der aux points relais du transporteur");
		}
		else {
			var codePaysLiv = oec_etatCommande=="N"?"":document.getElementById('oec-codePaysLiv').value;
			var url = "chrome://opensi/content/facturation/user/commun/popup-recherchePointRelais.xul";
    	window.openDialog(url,'','chrome,modal,centerscreen', oec_reporterPointRelais, modeExpedition, codePaysLiv);
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oec_reporterPointRelais(codeRelais, denomination, adresse1, adresse2, adresse3, codePostal, ville, codePays) {
  try {

		document.getElementById('oec-pointRetrait').value = codeRelais;
		document.getElementById('oec-tabBoxAdresses').selectedIndex = 1;
		oec_reporterAdrLiv(denomination, adresse1, adresse2, adresse3, codePostal, ville, "", codePays, "", "", "", "", "");

	} catch (e) {
  	recup_erreur(e);
  }
}


function oec_pressOnEncours() {
	try {

    var url = "chrome://opensi/content/facturation/user/affaires/popup-detailEncoursClient.xul";
 	  window.openDialog(url,'','chrome,modal,centerscreen', oec_clientId);

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_clickOnComposant() {
	try {

		if (oec_aComposantsLigne.isSelected()) {
			gClipboardHelper.copyString(oec_aComposantsLigne.getSelectedCellText("oec-colReferenceCL"));
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_listerHistorique() {
	try {

		var exclureTotaux = document.getElementById('oec-exclureTotaux').checked;
		var histoAvantVal = document.getElementById('oec-histoAvantVal').checked;

		oec_aListeHistorique.setParam("Commande_Id", oec_commandeId);
		oec_aListeHistorique.setParam("Exclure_Totaux", exclureTotaux);
		oec_aListeHistorique.setParam("Histo_Avant_Val", histoAvantVal);
		oec_aListeHistorique.initTree();

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_editerHistoriqueCSV() {
	try {

		var exclureTotaux = document.getElementById('oec-exclureTotaux').checked;
		var histoAvantVal = document.getElementById('oec-histoAvantVal').checked;

		var qEditionCsv = new QueryHttp("Facturation/Affaires/csvHistoriqueCommandeClient.tmpl");
		qEditionCsv.setParam("Commande_Id", oec_commandeId);
		qEditionCsv.setParam("Exclure_Totaux", exclureTotaux);
		qEditionCsv.setParam("Histo_Avant_Val", histoAvantVal);

		var result = qEditionCsv.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');
			var file = fileChooser("save", fichier);
			if (file!=null) {
				downloadFile(getDirBuffer() + fichier, file);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_dejaPresente(reference) {
  try {

		var trouve = false;

		for (var i=0; i<oec_aLignes.nbLignes(); i++) {
			if (oec_aLignes.getCellText(i, "oec-colReference")==reference) {
				trouve = true;
				break;
			}
		}

		return trouve;

	} catch (e) {
  	recup_erreur(e);
	}
}


function oec_chargerTarifsVente(selection) {
	try {

		oec_selTarifVente = selection;
		oec_aTarifsVente.setParam("Selection", oec_selTarifVente);
		oec_aTarifsVente.initTree(oec_initTarifVente);

	} catch (e) {
		recup_erreur(e);
	}
}


function oec_initTarifVente() {
  try {

		document.getElementById('oec-tarifVente').value = oec_selTarifVente;

	} catch (e) {
  	recup_erreur(e);
	}
}


function oec_editerOrdresFabrication() {
  try {

		var qGenPdf = new QueryHttp("Facturation/Affaires/pdfEditionOrdresFabrication.tmpl");
		qGenPdf.setParam('Commande_Id', oec_commandeId);

		var result = qGenPdf.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			document.getElementById('oec-pdfCommande').setAttribute('src', '');
			document.getElementById('oec-boxEdition').collapsed = true;
			document.getElementById('oec-deckCommande').selectedIndex = 1;
			document.getElementById('oec-bSwitchPdf').collapsed = true;
			document.getElementById('bRetourCommande').collapsed = false;

			var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
			document.getElementById('oec-pdfCommande').setAttribute("src", page);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oec_changeModeReglement() {
  try {

		document.getElementById('oec-alerteModeReg').collapsed = isEmpty(oec_clientId) || isEmpty(document.getElementById('oec-modeReglement').value) || oec_modeRegClient==document.getElementById('oec-modeReglement').getAttribute("label");
		document.getElementById('oec-alerteModeReg').setAttribute("tooltiptext", "Mode de r\u00E8glement client :\n"+ oec_modeRegClient);

	} catch (e) {
    recup_erreur(e);
  }
}
