/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var oef_factureId;
var oef_modeLigne;
var oef_codeTVAPort = "";
var oef_zoneUE;
var oef_modeTarif;
var oef_mode;
var oef_defEditionTTC;
var oef_editionTTC;
var oef_assujettiTVA;
var oef_typeRistourne = 'P';
var oef_typeRemise;
var oef_typeRemiseFP;
var oef_clientId = "";
var oef_typeLigne;
var oef_prixId;
var oef_ligneId;
var oef_articleId;
var oef_libelle;
var oef_modified = false;
var oef_chargerModeReg;
var oef_chargerResponsable;
var oef_selPoleActivite;
var oef_selTarifVente;
var oef_acompte;
var oef_bloquerEcheance;
var oef_currentIndex;
var oef_toSelectLigne = null;
var oef_montantHT;
var oef_montantTTC;
var oef_langueDefaut;
var oef_apercu;
var oef_actSuiviSerie;
var oef_codesTvaInactifs = "";
var oef_uniteDefaut;
var oef_modifElemFin;

var oef_aResponsables = new Arbre("ComboListe/combo-responsables.tmpl","oef-responsable");
var oef_aUnites = new Arbre("ComboListe/combo-unitesVente.tmpl", "oef-unite");
var oef_aTarifsVente = new Arbre("ComboListe/combo-tarifsVente.tmpl", "oef-tarifVente");
var oef_aPolesActivite = new Arbre("ComboListe/combo-polesActivite.tmpl", "oef-secteur");
var oef_aPaysFact = new Arbre("ComboListe/combo-pays.tmpl", "oef-codePaysFact");
var oef_aPaysLiv = new Arbre("ComboListe/combo-pays.tmpl", "oef-codePaysLiv");
var oef_aPaysEnvoi = new Arbre("ComboListe/combo-pays.tmpl", "oef-codePaysEnvoi");
var oef_aCodesTVA = new Arbre("ComboListe/combo-tauxTVA.tmpl", "oef-codeTVA");
var oef_aLignes = new Arbre("Facturation/FacturesVente/list-ligneFactureClient.tmpl", "oef-articles");
var oef_aModesReglements = new Arbre("ComboListe/combo-modesReglement.tmpl", "oef-modeReglement");
var oef_aVersion = new Arbre("Facturation/FacturesVente/list-versionFactureClient.tmpl","oef-listeVersion");
var oef_aLangues = new Arbre("ComboListe/combo-langues.tmpl", "oef-langueDefaut");
var oef_aCodesTVAFraisPort = new Arbre("ComboListe/combo-tauxTVA.tmpl", "oef-codeTVAFraisPort");



function oef_init() {
  try {

		oef_modifElemFin = gProfil.isModifElemFinDV() && gProfil.isModifElemFinFCA();

		document.getElementById('oef-rowFax').collapsed = !gShowFax;
		document.getElementById('oef-rowMontantDeduction').collapsed = !gConfig.isAutDeductionFC();
		document.getElementById('oef-rowDeductionHT').collapsed = !gConfig.isAutDeductionFC();
		document.getElementById('oef-rowDeductionTTC').collapsed = !gConfig.isAutDeductionFC();

		oef_uniteDefaut = gConfig.getUniteDefaut();
		oef_defEditionTTC = gConfig.isVenteTTC();
		oef_actSuiviSerie = gConfig.isActSuiviSerie();
		document.getElementById('oef-bConsultSerieLigne').collapsed = !oef_actSuiviSerie;

		if (!gConfig.isActCodeStats()) {
			document.getElementById('oef-colCodeStats').collapsed = true;
			document.getElementById('oef-colCodeStats').setAttribute('ignoreincolumnpicker', true);
	  	document.getElementById('oef-actCodeStats').collapsed = true;
		}
		else {
			document.getElementById('oef-labelRef').setAttribute('style', 'margin-left:0px');
			document.getElementById('oef-reference').setAttribute('style', 'margin-left:0px');
		}

		var actSuiviLot = gConfig.isActSuiviLot();
		var actUnites = gConfig.isActUnites();
		var actNbPieces = gConfig.isActNbPieces();

		if (!actSuiviLot) {
			document.getElementById('oef-colNumLot').collapsed = true;
			document.getElementById('oef-colNumLot').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oef-colDatePeremption').collapsed = true;
			document.getElementById('oef-colDatePeremption').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oef-fieldNumLot').collapsed = true;
			document.getElementById('oef-fieldDLC').collapsed = true;
		}

		if (!actUnites) {
			document.getElementById('oef-colSymboleUnite').collapsed = true;
			document.getElementById('oef-colSymboleUnite').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oef-fieldUnite').collapsed = true;
		}

		if (!actNbPieces) {
			document.getElementById('oef-colNbPieces').collapsed = true;
			document.getElementById('oef-colNbPieces').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oef-fieldNbPieces').collapsed = true;
		}

		oef_modeTarif = gConfig.getModeTarif();
		if (oef_modeTarif=='Q') {
			document.getElementById('oef-rowTarif').collapsed = true;
		}

		oef_aUnites.initTree(oef_initUnite);

		if (gReadOnly) {
			document.getElementById('oef-bMoveDown').collapsed = true;
			document.getElementById('oef-bMoveUp').collapsed = true;
			document.getElementById('oef-bMoveFirst').collapsed = true;
			document.getElementById('oef-bMoveLast').collapsed = true;
			document.getElementById('oef-bEnregistrer').collapsed = true;
			document.getElementById('oef-bSupprimerFacture').collapsed = true;
			document.getElementById('oef-bTransAvoir').collapsed = true;
			document.getElementById('oef-tabFacture').setAttribute('tooltiptext', "Lecture seule");
		}

		if (!gAccesCoutAchat) {
			document.getElementById('oef-colPrixAchat').setAttribute("ignoreincolumnpicker", true);
			document.getElementById('oef-colTauxMarque').setAttribute("ignoreincolumnpicker", true);
			document.getElementById('oef-colTauxMarge').setAttribute("ignoreincolumnpicker", true);
			document.getElementById('oef-colMargeHT').setAttribute("ignoreincolumnpicker", true);
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oef_chargerResponsables(selection) {
	try {
		oef_chargerResponsable = selection;
		oef_aResponsables.setParam("Selection", oef_chargerResponsable);
		oef_aResponsables.initTree(oef_initResponsable);
	} catch (e) {
		recup_erreur(e);
	}
}

function oef_initResponsable() {
  try {
		document.getElementById('oef-responsable').value = oef_chargerResponsable;
	} catch (e) {
  	recup_erreur(e);
	}
}


function oef_chargerPolesActivite(selection) {
	try {

		oef_selPoleActivite = selection;
		oef_aPolesActivite.setParam("Selection", oef_selPoleActivite);
		oef_aPolesActivite.initTree(oef_initPoleActivite);

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_initPoleActivite() {
  try {

		document.getElementById('oef-secteur').value = oef_selPoleActivite;

	} catch (e) {
  	recup_erreur(e);
	}
}


function oef_initUnite() {
	try {

		document.getElementById('oef-unite').selectedIndex = 0;
    oef_aPaysFact.initTree(oef_initPaysFact);

	} catch (e) {
    recup_erreur(e);
  }
}

function oef_initPaysFact() {
	try {
		document.getElementById('oef-codePaysFact').value = "FR";
		oef_aPaysLiv.initTree(oef_initPaysLiv);
	} catch (e) {
    recup_erreur(e);
  }
}

function oef_initPaysLiv() {
	try {
		document.getElementById('oef-codePaysLiv').value = "FR";
		oef_aPaysEnvoi.initTree(oef_initPaysEnvoi);
	} catch (e) {
    recup_erreur(e);
  }
}

function oef_initPaysEnvoi() {
	try {
		document.getElementById('oef-codePaysEnvoi').value = "FR";
	} catch (e) {
    recup_erreur(e);
  }
}


function oef_chargerModesReglements(selection) {
	try {
		oef_chargerModeReg = selection;
		oef_aModesReglements.setParam("Selection", oef_chargerModeReg);
		oef_aModesReglements.initTree(oef_initModeReglement);
	} catch (e) {
		recup_erreur(e);
	}
}

function oef_initModeReglement() {
	try {
		document.getElementById('oef-modeReglement').value=oef_chargerModeReg;
	} catch (e) {
		recup_erreur(e);
	}
}


function oef_reinitialiser() {
	try {

		oef_modeLigne = "C";
		oef_zoneUE=false;

		oef_assujettiTVA = false;
		oef_typeRemise = "P";
		oef_typeRemiseFP = "P";
		oef_editionTTC = oef_defEditionTTC;
		oef_chargerModeReg="";
		oef_chargerResponsable="";
		oef_selPoleActivite = "";
		oef_bloquerEcheance = false;
		oef_currentIndex = 0;
		oef_montantHT = 0;
		oef_montantTTC = 0;
		oef_apercu = false;
		oef_codesTvaInactifs = "";
		oef_codeTVAPort = "";
		oef_typeRistourne = 'P';
		document.getElementById('oef-bRistourne').setAttribute("class", "bIcoPourcentage");

		document.getElementById('oef-tabBoxFacture').selectedIndex = 0;
		document.getElementById('oef-deckFacture').selectedIndex = 0;
		document.getElementById('oef-tabFacture').setAttribute('image', gReadOnly?'chrome://opensi/content/design/icones/readonly.png':null);
		document.getElementById('oef-numAffaire').value = "";
		document.getElementById('oef-numFacture').value = "";
		document.getElementById('oef-dateFacture').value = "";
		document.getElementById('oef-modeEnvoiFacture').selectedIndex=0;
		document.getElementById('oef-assujettiTVA').checked = false;
		document.getElementById('oef-numTVA').value = "";
		document.getElementById('oef-regimeTVA').selectedIndex=0;
		document.getElementById('oef-editionTTC').checked = oef_editionTTC;

		oef_aVersion.deleteTree();

		oef_clientId = "";
		document.getElementById('oef-numClient').value = "";

		oef_aModesReglements.deleteTree();
		oef_aResponsables.deleteTree();

		document.getElementById('oef-tabBoxAdresses').selectedIndex = 0;
		document.getElementById('oef-denominationFact').value = "";
		document.getElementById('oef-adresse1Fact').value = "";
		document.getElementById('oef-adresse2Fact').value = "";
		document.getElementById('oef-adresse3Fact').value = "";
		document.getElementById('oef-codePostalFact').value = "";
		document.getElementById('oef-villeFact').value = "";
		document.getElementById('oef-codePaysFact').value = "FR";
		document.getElementById('oef-civInterFact').selectedIndex = 0;
		document.getElementById('oef-nomInterFact').value = "";
		document.getElementById('oef-prenomInterFact').value = "";
		document.getElementById('oef-telInter1Fact').value = "";
		document.getElementById('oef-telInter2Fact').value = "";
		document.getElementById('oef-faxInterFact').value = "";
		document.getElementById('oef-emailInterFact').value = "";
		document.getElementById('oef-denominationLiv').value = "";
		document.getElementById('oef-adresse1Liv').value = "";
		document.getElementById('oef-adresse2Liv').value = "";
		document.getElementById('oef-adresse3Liv').value = "";
		document.getElementById('oef-codePostalLiv').value = "";
		document.getElementById('oef-villeLiv').value = "";
		document.getElementById('oef-codePaysLiv').value = "FR";

		document.getElementById('oef-civInterLiv').selectedIndex = 0;
		document.getElementById('oef-nomInterLiv').value = "";
		document.getElementById('oef-prenomInterLiv').value = "";
		document.getElementById('oef-telInter1Liv').value = "";
		document.getElementById('oef-telInter2Liv').value = "";
		document.getElementById('oef-faxInterLiv').value = "";
		document.getElementById('oef-emailInterLiv').value = "";
		document.getElementById('oef-denominationEnvoi').value = "";
		document.getElementById('oef-adresse1Envoi').value = "";
		document.getElementById('oef-adresse2Envoi').value = "";
		document.getElementById('oef-adresse3Envoi').value = "";
		document.getElementById('oef-codePostalEnvoi').value = "";
		document.getElementById('oef-villeEnvoi').value = "";
		document.getElementById('oef-codePaysEnvoi').value = "FR";
		document.getElementById('oef-civInterEnvoi').selectedIndex = 0;
		document.getElementById('oef-nomInterEnvoi').value = "";
		document.getElementById('oef-prenomInterEnvoi').value = "";
		document.getElementById('oef-telInter1Envoi').value = "";
		document.getElementById('oef-telInter2Envoi').value = "";
		document.getElementById('oef-faxInterEnvoi').value = "";
		document.getElementById('oef-emailInterEnvoi').value = "";

		document.getElementById('oef-codeStats').value = "";
		document.getElementById('oef-reference').value = "";
		document.getElementById('oef-designation').value = "";
		document.getElementById('oef-numLot').value = "";
		document.getElementById('oef-nbPieces').value = "";
		document.getElementById('oef-quantite').value = "";
		document.getElementById('oef-unite').value = oef_uniteDefaut;
		document.getElementById('oef-datePeremption').value = "";
		document.getElementById('oef-PU').value = "";
		document.getElementById('oef-ristourne').value = "";
		document.getElementById('oef-codeTVA').value = getCodeTvaNormal(document.getElementById('oef-codePaysLiv').value, oef_assujettiTVA, document.getElementById('oef-regimeTVA').value);

		document.getElementById('oef-commentairesFin').value = "";
		document.getElementById('oef-commentairesInt').value = "";
		document.getElementById('oef-echeance').value = "";
		document.getElementById('oef-bRemise').setAttribute('class', 'bIcoPourcentage');
		document.getElementById('oef-remise').value = "0.00";
		document.getElementById('oef-fraisPort').value = "0.00";
		document.getElementById('oef-bRemiseFP').setAttribute('class', 'bIcoPourcentage');
		document.getElementById('oef-remiseFP').value = "0.00";
		document.getElementById('oef-escompte').value = "0.00";
		document.getElementById('oef-montantDeduction').value = "0.00";
		oef_acompte = 0;

		document.getElementById('oef-colTotal').setAttribute("label", oef_editionTTC?"Total TTC":"Total HT");
		document.getElementById('oef-colPU').setAttribute("label", oef_editionTTC?"P.U TTC":"P.U HT");
		document.getElementById('oef-lblFraisPort').value = (oef_editionTTC?"Frais de port (ttc) :":"Frais de port (ht) :");
		document.getElementById('oef-lblPU').value = (oef_editionTTC?"P.U TTC :":"P.U HT :");
		document.getElementById('oef-piedTTC').collapsed = !oef_editionTTC;
		document.getElementById('oef-piedHT').collapsed = oef_editionTTC;
		document.getElementById('oef-montantHT').value = "0.00";
		document.getElementById('oef-montantRemise').value = "0.00";
		document.getElementById('oef-montantFraisPort').value = "0.00";
		document.getElementById('oef-montantRemiseFP').value = "0.00";
		document.getElementById('oef-totalHT').value = "0.00";
		document.getElementById('oef-TVA').value = "0.00";
		document.getElementById('oef-montantEscompte').value = "0.00";
		document.getElementById('oef-montantAcompte').value = "0.00";
		document.getElementById('oef-totalTTC').value = "0.00";
		document.getElementById('oef-pttcMontantTTC').value = "0.00";
		document.getElementById('oef-pttcMontantRemise').value = "0.00";
		document.getElementById('oef-pttcMontantFraisPort').value = "0.00";
		document.getElementById('oef-pttcMontantRemiseFP').value = "0.00";
		document.getElementById('oef-pttcTotalTTC').value = "0.00";
		document.getElementById('oef-pttcTVA').value = "0.00";
		document.getElementById('oef-pttcMontantEscompte').value = "0.00";
		document.getElementById('oef-pttcMontantAcompte').value = "0.00";
		document.getElementById('oef-pttcNetTTC').value = "0.00";

		document.getElementById('oef-rowRemiseHT').collapsed = true;
		document.getElementById('oef-rowRemiseFPHT').collapsed = true;
		document.getElementById('oef-rowEscompteHT').collapsed = true;
		document.getElementById('oef-rowRemiseTTC').collapsed = true;
		document.getElementById('oef-rowRemiseFPTTC').collapsed = true;
		document.getElementById('oef-rowEscompteTTC').collapsed = true;

		document.getElementById('oef-rowNetCommercialHT').collapsed = true;
		document.getElementById('oef-rowEscompteTTC').collapsed = true;
		document.getElementById('oef-pttcNetCommercial').value = "0.00";
		document.getElementById('oef-netCommercial').value = "0.00";

		document.getElementById('oef-creation').setAttribute("label", "");
		document.getElementById('oef-modification').setAttribute("label", "");
		document.getElementById('oef-fiche').setAttribute("label", "");

		oef_typeLigne = "";
		oef_prixId = "";
		oef_ligneId = "";
		oef_libelle = "";
		oef_modified = false;

		document.getElementById('oef-modeEnvoiFacture').disabled = true;
		document.getElementById('oef-responsable').disabled = true;
		document.getElementById('oef-secteur').disabled = true;
		document.getElementById('oef-assujettiTVA').disabled = true;
		document.getElementById('oef-numTVA').disabled = true;
		document.getElementById('oef-regimeTVA').disabled = true;
		document.getElementById('oef-editionTTC').disabled = true;
		document.getElementById('oef-bChercherAdrFact').disabled = true;
		document.getElementById('oef-bChercherInter').disabled = true;
		document.getElementById('oef-bCopierFactVersLivEnvoi').disabled = true;
		document.getElementById('oef-tarifVente').disabled = true;
		document.getElementById('oef-bChercherAdrLiv').disabled = true;
		document.getElementById('oef-bChercherInterLiv').disabled = true;
		document.getElementById('oef-bChercherAdrEnvoi').disabled = true;
		document.getElementById('oef-bChercherInterEnvoi').disabled = true;

		document.getElementById('oef-denominationFact').setAttribute('readonly', true);
		document.getElementById('oef-adresse1Fact').setAttribute('readonly', true);
		document.getElementById('oef-adresse2Fact').setAttribute('readonly', true);
		document.getElementById('oef-adresse3Fact').setAttribute('readonly', true);
		document.getElementById('oef-codePostalFact').setAttribute('readonly', true);
		document.getElementById('oef-villeFact').setAttribute('readonly', true);
		document.getElementById('oef-codePaysFact').disabled = true;
		document.getElementById('oef-civInterFact').disabled = true;
		document.getElementById('oef-nomInterFact').setAttribute('readonly', true);
		document.getElementById('oef-prenomInterFact').setAttribute('readonly', true);
		document.getElementById('oef-telInter1Fact').setAttribute('readonly', true);
		document.getElementById('oef-telInter2Fact').setAttribute('readonly', true);
		document.getElementById('oef-faxInterFact').setAttribute('readonly', true);
		document.getElementById('oef-emailInterFact').setAttribute('readonly', true);

		document.getElementById('oef-denominationLiv').setAttribute('readonly', true);
		document.getElementById('oef-adresse1Liv').setAttribute('readonly', true);
		document.getElementById('oef-adresse2Liv').setAttribute('readonly', true);
		document.getElementById('oef-adresse3Liv').setAttribute('readonly', true);
		document.getElementById('oef-codePostalLiv').setAttribute('readonly', true);
		document.getElementById('oef-villeLiv').setAttribute('readonly', true);
		document.getElementById('oef-codePaysLiv').disabled = true;
		document.getElementById('oef-civInterLiv').disabled = true;
		document.getElementById('oef-nomInterLiv').setAttribute('readonly', true);
		document.getElementById('oef-prenomInterLiv').setAttribute('readonly', true);
		document.getElementById('oef-telInter1Liv').setAttribute('readonly', true);
		document.getElementById('oef-telInter2Liv').setAttribute('readonly', true);
		document.getElementById('oef-faxInterLiv').setAttribute('readonly', true);
		document.getElementById('oef-emailInterLiv').setAttribute('readonly', true);

		document.getElementById('oef-denominationEnvoi').setAttribute('readonly', true);
		document.getElementById('oef-adresse1Envoi').setAttribute('readonly', true);
		document.getElementById('oef-adresse2Envoi').setAttribute('readonly', true);
		document.getElementById('oef-adresse3Envoi').setAttribute('readonly', true);
		document.getElementById('oef-codePostalEnvoi').setAttribute('readonly', true);
		document.getElementById('oef-villeEnvoi').setAttribute('readonly', true);
		document.getElementById('oef-codePaysEnvoi').disabled = true;
		document.getElementById('oef-civInterEnvoi').disabled = true;
		document.getElementById('oef-nomInterEnvoi').setAttribute('readonly', true);
		document.getElementById('oef-prenomInterEnvoi').setAttribute('readonly', true);
		document.getElementById('oef-telInter1Envoi').setAttribute('readonly', true);
		document.getElementById('oef-telInter2Envoi').setAttribute('readonly', true);
		document.getElementById('oef-faxInterEnvoi').setAttribute('readonly', true);
		document.getElementById('oef-emailInterEnvoi').setAttribute('readonly', true);

		document.getElementById('oef-commentairesFin').disabled = true;
		document.getElementById('oef-commentairesInt').disabled = true;
		document.getElementById('oef-bOuvrirCommentairesCaches').disabled = true;
		document.getElementById('oef-bChoisirMentions').disabled = true;
		document.getElementById('oef-modeReglement').disabled = true;
		document.getElementById('oef-echeance').disabled = true;
		document.getElementById('oef-bEchMultiples').disabled = true;
		document.getElementById('oef-bRemise').disabled = true;
		document.getElementById('oef-remise').disabled = true;
		document.getElementById('oef-fraisPort').disabled = true;
		document.getElementById('oef-codeTVAFraisPort').disabled = true;
		document.getElementById('oef-bRemiseFP').disabled = true;
		document.getElementById('oef-remiseFP').disabled = true;
		document.getElementById('oef-escompte').disabled = true;
		document.getElementById('oef-montantDeduction').disabled = true;
		document.getElementById('oef-bEnregistrer').disabled = true;
		document.getElementById('oef-bApercu').disabled = true;
		document.getElementById('oef-bValiderFacture').disabled = true;
		document.getElementById('oef-bVisualiser').disabled = true;
		document.getElementById('oef-bSupprimerFacture').disabled = true;
		document.getElementById('oef-bTransAvoir').disabled = true;

		document.getElementById('oef-codeStats').disabled = true;
		document.getElementById('oef-reference').disabled = true;
		document.getElementById('oef-designation').disabled = true;
		document.getElementById('oef-numLot').disabled = true;
		document.getElementById('oef-nbPieces').disabled = true;
		document.getElementById('oef-quantite').disabled = true;
		document.getElementById('oef-unite').disabled = true;
		document.getElementById('oef-datePeremption').disabled = true;
		document.getElementById('oef-PU').disabled = true;
		document.getElementById('oef-ristourne').disabled = true;
		document.getElementById('oef-codeTVA').disabled = true;
		document.getElementById('oef-bSupprimer').disabled = true;
		document.getElementById('oef-bMoveUp').disabled = true;
		document.getElementById('oef-bMoveDown').disabled = true;
		document.getElementById('oef-bMoveFirst').disabled = true;
		document.getElementById('oef-bMoveLast').disabled = true;
		document.getElementById('oef-bValider').disabled = true;
		document.getElementById('oef-bAnnuler').disabled = true;
		document.getElementById('oef-bArticle').disabled = true;
		document.getElementById('oef-bCommentaire').disabled = true;
		document.getElementById('oef-bConsultSerieLigne').disabled = true;

		document.getElementById('oef-caHT').value = "0.00 \u20AC";
		document.getElementById('oef-paHT').value = "0.00 \u20AC";
		document.getElementById('oef-margeHT').value = "0.00 \u20AC";
		document.getElementById('oef-tauxMarque').value = "0.00 %";
		document.getElementById('oef-tauxMarge').value = "0.00 %";
		document.getElementById('oef-nbLignes').value = "0";
		document.getElementById('oef-qteArticles').value = "0";
		document.getElementById('oef-lblMargeHT').setAttribute("style", "color:black");
		document.getElementById('oef-margeHT').setAttribute("style", "color:black");
		document.getElementById('oef-lblTauxMarque').setAttribute("style", "color:black");
		document.getElementById('oef-tauxMarque').setAttribute("style", "color:black");
		document.getElementById('oef-lblTauxMarge').setAttribute("style", "color:black");
		document.getElementById('oef-tauxMarge').setAttribute("style", "color:black");
		document.getElementById('oef-pictoMargeNegative').collapsed = true;

		oef_aLignes.deleteTree();

		document.getElementById('oef-pdfFacture').setAttribute('src', '');

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_debloquerChamps() {
	try {

		document.getElementById('oef-modeEnvoiFacture').disabled = false;
		document.getElementById('oef-responsable').disabled = false;
		document.getElementById('oef-secteur').disabled = false;
		document.getElementById('oef-assujettiTVA').disabled = false;
		document.getElementById('oef-regimeTVA').disabled = false;
		document.getElementById('oef-editionTTC').disabled = false;
		document.getElementById('oef-bCopierFactVersLivEnvoi').disabled = false;
		document.getElementById('oef-tarifVente').disabled = false;

		document.getElementById('oef-denominationFact').removeAttribute('readonly');
		document.getElementById('oef-adresse1Fact').removeAttribute('readonly');
		document.getElementById('oef-adresse2Fact').removeAttribute('readonly');
		document.getElementById('oef-adresse3Fact').removeAttribute('readonly');
		document.getElementById('oef-codePostalFact').removeAttribute('readonly');
		document.getElementById('oef-villeFact').removeAttribute('readonly');
		document.getElementById('oef-codePaysFact').disabled = false;
		document.getElementById('oef-civInterFact').disabled = false;
		document.getElementById('oef-nomInterFact').removeAttribute('readonly');
		document.getElementById('oef-prenomInterFact').removeAttribute('readonly');
		document.getElementById('oef-telInter1Fact').removeAttribute('readonly');
		document.getElementById('oef-telInter2Fact').removeAttribute('readonly');
		document.getElementById('oef-faxInterFact').removeAttribute('readonly');
		document.getElementById('oef-emailInterFact').removeAttribute('readonly');

		document.getElementById('oef-denominationLiv').removeAttribute('readonly');
		document.getElementById('oef-adresse1Liv').removeAttribute('readonly');
		document.getElementById('oef-adresse2Liv').removeAttribute('readonly');
		document.getElementById('oef-adresse3Liv').removeAttribute('readonly');
		document.getElementById('oef-codePostalLiv').removeAttribute('readonly');
		document.getElementById('oef-villeLiv').removeAttribute('readonly');
		document.getElementById('oef-codePaysLiv').disabled = false;
		document.getElementById('oef-civInterLiv').disabled = false;
		document.getElementById('oef-nomInterLiv').removeAttribute('readonly');
		document.getElementById('oef-prenomInterLiv').removeAttribute('readonly');
		document.getElementById('oef-telInter1Liv').removeAttribute('readonly');
		document.getElementById('oef-telInter2Liv').removeAttribute('readonly');
		document.getElementById('oef-faxInterLiv').removeAttribute('readonly');
		document.getElementById('oef-emailInterLiv').removeAttribute('readonly');

		document.getElementById('oef-denominationEnvoi').removeAttribute('readonly');
		document.getElementById('oef-adresse1Envoi').removeAttribute('readonly');
		document.getElementById('oef-adresse2Envoi').removeAttribute('readonly');
		document.getElementById('oef-adresse3Envoi').removeAttribute('readonly');
		document.getElementById('oef-codePostalEnvoi').removeAttribute('readonly');
		document.getElementById('oef-villeEnvoi').removeAttribute('readonly');
		document.getElementById('oef-codePaysEnvoi').disabled = false;
		document.getElementById('oef-civInterEnvoi').disabled = false;
		document.getElementById('oef-nomInterEnvoi').removeAttribute('readonly');
		document.getElementById('oef-prenomInterEnvoi').removeAttribute('readonly');
		document.getElementById('oef-telInter1Envoi').removeAttribute('readonly');
		document.getElementById('oef-telInter2Envoi').removeAttribute('readonly');
		document.getElementById('oef-faxInterEnvoi').removeAttribute('readonly');
		document.getElementById('oef-emailInterEnvoi').removeAttribute('readonly');

		document.getElementById('oef-commentairesFin').disabled = false;
		document.getElementById('oef-commentairesInt').disabled = false;
		document.getElementById('oef-bChoisirMentions').disabled = false;
		document.getElementById('oef-bRemise').disabled = !oef_modifElemFin;
		document.getElementById('oef-remise').disabled = !oef_modifElemFin;
		document.getElementById('oef-fraisPort').disabled = (document.getElementById("ofa-modeFacturation").value=="G" || !oef_modifElemFin);
		document.getElementById('oef-codeTVAFraisPort').disabled = (document.getElementById("ofa-modeFacturation").value=="G" || !oef_modifElemFin);
		document.getElementById('oef-bRemiseFP').disabled = (document.getElementById("ofa-modeFacturation").value=="G" || !oef_modifElemFin);
		document.getElementById('oef-remiseFP').disabled = (document.getElementById("ofa-modeFacturation").value=="G" || !oef_modifElemFin);
		document.getElementById('oef-escompte').disabled = !oef_modifElemFin;
		document.getElementById('oef-montantDeduction').disabled = !oef_modifElemFin;
		document.getElementById('oef-bEnregistrer').disabled = false;

		document.getElementById('oef-codeStats').disabled = false;
		document.getElementById('oef-reference').disabled = false;
		document.getElementById('oef-designation').disabled = false;
		document.getElementById('oef-numLot').disabled = false;
		document.getElementById('oef-nbPieces').disabled = false;
		document.getElementById('oef-quantite').disabled = false;
		document.getElementById('oef-unite').disabled = false;
		document.getElementById('oef-datePeremption').disabled = false;
		document.getElementById('oef-PU').disabled = !oef_modifElemFin;
		document.getElementById('oef-ristourne').disabled = !oef_modifElemFin;
		document.getElementById('oef-codeTVA').disabled = !oef_modifElemFin;
		document.getElementById('oef-bValider').disabled = false;
		document.getElementById('oef-bAnnuler').disabled = false;
		document.getElementById('oef-bArticle').disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_chargerFacture() {
	try {

		oef_mode = "M";
		oef_reinitialiser();

		oef_aLignes.setParam("Facture_Id", oef_factureId);
		oef_aLignes.initTree(oef_chargerFacture2);

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_chargerFacture2() {
  try {

		var qLoad = new QueryHttp("Facturation/FacturesVente/loadFactureClient.tmpl");
		qLoad.setParam("Facture_Id", oef_factureId);
		var result = qLoad.execute();

		var contenu = result.responseXML.documentElement;

		var numFacture = contenu.getAttribute('Num_Facture');

		oef_typeRemise = (parseFloat(contenu.getAttribute('MRemise'))!=0?'M':'P');
		document.getElementById('oef-remise').value = (oef_typeRemise=='P'?contenu.getAttribute('PRemise'):contenu.getAttribute('MRemise'));
		document.getElementById('oef-bRemise').setAttribute("class", (oef_typeRemise=='P'?"bIcoPourcentage":"bIcoEuro"));

		oef_typeRemiseFP = (parseFloat(contenu.getAttribute('MRemise_FP'))!=0?'M':'P');
		document.getElementById('oef-remiseFP').value = (oef_typeRemiseFP=='P'?contenu.getAttribute('PRemise_FP'):contenu.getAttribute('MRemise_FP'));
		document.getElementById('oef-bRemiseFP').setAttribute("class", (oef_typeRemiseFP=='P'?"bIcoPourcentage":"bIcoEuro"));


		document.getElementById('oef-escompte').value = contenu.getAttribute('Escompte');
		document.getElementById('oef-montantDeduction').value = contenu.getAttribute('Montant_Deduction');
		oef_acompte = contenu.getAttribute('Acompte');
		document.getElementById('oef-fraisPort').value = contenu.getAttribute('Frais_Port');
		document.getElementById('oef-commentairesFin').value = contenu.getAttribute('Commentaires_Fin');
		document.getElementById('oef-commentairesInt').value = contenu.getAttribute('Commentaires_Int');
		document.getElementById('oef-dateFacture').value = contenu.getAttribute('Date_Facture');
		document.getElementById('oef-numFacture').value = numFacture;
		oef_chargerPolesActivite(contenu.getAttribute('Pole_Activite'));
		document.getElementById('oef-echeance').value = contenu.getAttribute('Echeance');
		oef_chargerModesReglements(contenu.getAttribute('Mode_Reg'));
		document.getElementById('oef-modeEnvoiFacture').value = contenu.getAttribute('Mode_Envoi_Facture');

		document.getElementById('oef-denominationFact').value = contenu.getAttribute('Denomination');
		document.getElementById('oef-adresse1Fact').value = contenu.getAttribute('Adresse_1');
		document.getElementById('oef-adresse2Fact').value = contenu.getAttribute('Adresse_2');
		document.getElementById('oef-adresse3Fact').value = contenu.getAttribute('Adresse_3');
		document.getElementById('oef-codePostalFact').value = contenu.getAttribute('Code_Postal');
		document.getElementById('oef-villeFact').value = contenu.getAttribute('Ville');
		document.getElementById('oef-codePaysFact').value = contenu.getAttribute('Code_Pays');
		document.getElementById('oef-civInterFact').value = contenu.getAttribute('Civ_Inter');
		document.getElementById('oef-nomInterFact').value = contenu.getAttribute('Nom_Inter');
		document.getElementById('oef-prenomInterFact').value = contenu.getAttribute('Prenom_Inter');
		document.getElementById('oef-telInter1Fact').value = contenu.getAttribute('Tel_Inter_1');
		document.getElementById('oef-telInter2Fact').value = contenu.getAttribute('Tel_Inter_2');
		document.getElementById('oef-faxInterFact').value = contenu.getAttribute('Fax_Inter');
		document.getElementById('oef-emailInterFact').value = contenu.getAttribute('Email_Inter');

		document.getElementById('oef-denominationLiv').value = contenu.getAttribute('Denomination_Liv');
		document.getElementById('oef-adresse1Liv').value = contenu.getAttribute('Adresse_1_Liv');
		document.getElementById('oef-adresse2Liv').value = contenu.getAttribute('Adresse_2_Liv');
		document.getElementById('oef-adresse3Liv').value = contenu.getAttribute('Adresse_3_Liv');
		document.getElementById('oef-codePostalLiv').value = contenu.getAttribute('Code_Postal_Liv');
		document.getElementById('oef-villeLiv').value = contenu.getAttribute('Ville_Liv');
		document.getElementById('oef-codePaysLiv').value = contenu.getAttribute('Code_Pays_Liv');
		document.getElementById('oef-civInterLiv').value = contenu.getAttribute('Civ_Inter_Liv');
		document.getElementById('oef-nomInterLiv').value = contenu.getAttribute('Nom_Inter_Liv');
		document.getElementById('oef-prenomInterLiv').value = contenu.getAttribute('Prenom_Inter_Liv');
		document.getElementById('oef-telInter1Liv').value = contenu.getAttribute('Tel_Inter_1_Liv');
		document.getElementById('oef-telInter2Liv').value = contenu.getAttribute('Tel_Inter_2_Liv');
		document.getElementById('oef-faxInterLiv').value = contenu.getAttribute('Fax_Inter_Liv');
		document.getElementById('oef-emailInterLiv').value = contenu.getAttribute('Email_Inter_Liv');

		document.getElementById('oef-denominationEnvoi').value = contenu.getAttribute('Denomination_Envoi');
		document.getElementById('oef-adresse1Envoi').value = contenu.getAttribute('Adresse_1_Envoi');
		document.getElementById('oef-adresse2Envoi').value = contenu.getAttribute('Adresse_2_Envoi');
		document.getElementById('oef-adresse3Envoi').value = contenu.getAttribute('Adresse_3_Envoi');
		document.getElementById('oef-codePostalEnvoi').value = contenu.getAttribute('Code_Postal_Envoi');
		document.getElementById('oef-villeEnvoi').value = contenu.getAttribute('Ville_Envoi');
		document.getElementById('oef-codePaysEnvoi').value = contenu.getAttribute('Code_Pays_Envoi');
		document.getElementById('oef-civInterEnvoi').value = contenu.getAttribute('Civ_Inter_Envoi');
		document.getElementById('oef-nomInterEnvoi').value = contenu.getAttribute('Nom_Inter_Envoi');
		document.getElementById('oef-prenomInterEnvoi').value = contenu.getAttribute('Prenom_Inter_Envoi');
		document.getElementById('oef-telInter1Envoi').value = contenu.getAttribute('Tel_Inter_1_Envoi');
		document.getElementById('oef-telInter2Envoi').value = contenu.getAttribute('Tel_Inter_2_Envoi');
		document.getElementById('oef-faxInterEnvoi').value = contenu.getAttribute('Fax_Inter_Envoi');
		document.getElementById('oef-emailInterEnvoi').value = contenu.getAttribute('Email_Inter_Envoi');

		oef_chargerTarifsVente(contenu.getAttribute('Tarif_Id'));
		document.getElementById('oef-regimeTVA').value = contenu.getAttribute('Regime_TVA');
		var codeTVAPort = contenu.getAttribute('Code_TVA_Port');
		oef_assujettiTVA = (contenu.getAttribute('Assujetti_TVA')=="true");
		oef_codesTvaInactifs = contenu.getAttribute('Codes_TVA_Inactifs');

		var typeEdition = (contenu.getAttribute('Edition_TTC')=="true");

		document.getElementById('oef-editionTTC').checked = typeEdition;

		document.getElementById('oef-assujettiTVA').checked = oef_assujettiTVA;
		document.getElementById('oef-numTVA').value = contenu.getAttribute("Num_TVA_Intra");

		oef_clientId = contenu.getAttribute('Client_Id');
		var clientConnu = !isEmpty(oef_clientId);
		document.getElementById('oef-numClient').value = contenu.getAttribute('Num_Client');

		oef_chargerResponsables(contenu.getAttribute('Util_R'));

		document.getElementById('oef-creation').setAttribute("label", "Facture cr\u00E9\u00E9e le "+ contenu.getAttribute('Date_Creation') +" par "+ contenu.getAttribute('Login_Createur'));
		document.getElementById('oef-modification').setAttribute("label", "Derni\u00E8re modification le "+ contenu.getAttribute('Date_Maj') +" par "+ contenu.getAttribute('Login_Maj'));
		document.getElementById('oef-fiche').setAttribute("label", "Facture N\u00B0 "+ numFacture);
		document.getElementById('oef-creation').collapsed = false;
		document.getElementById('oef-modification').collapsed = false;

		oef_initVersion();

		oef_modified = false;
		document.getElementById('oef-tabFacture').setAttribute('image', gReadOnly?'chrome://opensi/content/design/icones/readonly.png':null);

		document.getElementById('oef-bOuvrirCommentairesCaches').disabled = false;

		oef_bloquerEcheance = (parseFloat(contenu.getAttribute('Net_A_Payer'))==0);

		if (contenu.getAttribute('Statut')=="V") {
			oef_mode = "V";
			document.getElementById('oef-bTransAvoir').disabled = false;
		} else {
			oef_debloquerChamps();
			document.getElementById('oef-bChercherAdrFact').disabled = !clientConnu;
			document.getElementById('oef-bChercherInter').disabled = !clientConnu;
			document.getElementById('oef-bChercherAdrLiv').disabled = !clientConnu;
			document.getElementById('oef-bChercherInterLiv').disabled = !clientConnu;
			document.getElementById('oef-bChercherAdrEnvoi').disabled = !clientConnu;
			document.getElementById('oef-bChercherInterEnvoi').disabled = !clientConnu;
			document.getElementById('oef-numTVA').disabled = !oef_assujettiTVA;
			document.getElementById('oef-bSupprimerFacture').disabled = false;
			var echModifiable = (contenu.getAttribute('Ech_Modifiable')=="true");
    	document.getElementById('oef-echeance').disabled = !echModifiable;
  		document.getElementById('oef-modeReglement').disabled = !echModifiable;
  		oef_ajouterLigne("I");
		}
		document.getElementById('oef-bOuvrirCommentairesCaches').disabled = false;
		document.getElementById('oef-bApercu').disabled = (oef_mode == "V");
		document.getElementById('oef-bValiderFacture').disabled = (oef_mode == "V");
		document.getElementById('oef-bVisualiser').disabled = (oef_mode != "V");
		document.getElementById('oef-bApercu').collapsed = (oef_mode == "V");
		document.getElementById('oef-bValiderFacture').collapsed = (oef_mode=="V" || gReadOnly);
		document.getElementById('oef-bVisualiser').collapsed = (oef_mode != "V");

		document.getElementById('oef-bEchMultiples').disabled = oef_bloquerEcheance;

		oef_changerTypeEdition(typeEdition);

    oef_chargerTVAPort(codeTVAPort);

		document.getElementById('oef-numAffaire').value = ofa_numAffaire;

		oef_loadRecapitulatif()

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_chargerTVAPort(selection) {
  try {

		oef_codeTVAPort = selection!=null?selection:getCodeTvaNormal(document.getElementById('oef-codePaysLiv').value, oef_assujettiTVA, document.getElementById('oef-regimeTVA').value);

		oef_aCodesTVAFraisPort.setParam("Code_Pays", document.getElementById("oef-codePaysLiv").value);
    oef_aCodesTVAFraisPort.setParam("Regime_TVA", document.getElementById("oef-regimeTVA").value);
    oef_aCodesTVAFraisPort.setParam("Assujetti_TVA", oef_assujettiTVA);
		oef_aCodesTVAFraisPort.setParam("Selection", oef_codeTVAPort);
    oef_aCodesTVAFraisPort.initTree(oef_selectionTVAPort);

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_selectionTVAPort() {
  try {

   	document.getElementById('oef-codeTVAFraisPort').value = oef_codeTVAPort;
		oef_listeTVA();

		var qZoneUE = new QueryHttp("Facturation/Commun/getZoneUEPays.tmpl");
	  qZoneUE.setParam("Code_Pays", document.getElementById('oef-codePaysLiv').value);
	  var result = qZoneUE.execute();
	  oef_zoneUE = (result.responseXML.documentElement.getAttribute("Zone_UE")=="true");

  } catch (e) {
    recup_erreur(e);
  }
}


function oef_loadRecapitulatif() {
	try {

		var qRecap = new QueryHttp("Facturation/FacturesVente/getRecapitulatifFC.tmpl");
		qRecap.setParam("Facture_Id", oef_factureId);
		var result = qRecap.execute();
		var contenu = result.responseXML.documentElement;

		document.getElementById('oef-caHT').value = contenu.getAttribute("CAHT") +" \u20AC";
		document.getElementById('oef-paHT').value = contenu.getAttribute("PAHT") +" \u20AC";
		document.getElementById('oef-margeHT').value = contenu.getAttribute("Marge_HT") +" \u20AC";
		document.getElementById('oef-tauxMarque').value = contenu.getAttribute("Taux_Marque") +" %";
		document.getElementById('oef-tauxMarge').value = contenu.getAttribute("Taux_Marge") +" %";
		document.getElementById('oef-nbLignes').value = contenu.getAttribute("Nb_Lignes");
		document.getElementById('oef-qteArticles').value = contenu.getAttribute("Qte_Articles");
		document.getElementById('oef-pictoMargeNegative').collapsed = true;
		if (contenu.getAttribute("Marge_Negative")=="true") {
			document.getElementById('oef-lblMargeHT').setAttribute("style", "color:red");
			document.getElementById('oef-margeHT').setAttribute("style", "color:red");
			document.getElementById('oef-lblTauxMarque').setAttribute("style", "color:red");
			document.getElementById('oef-tauxMarque').setAttribute("style", "color:red");
			document.getElementById('oef-lblTauxMarge').setAttribute("style", "color:red");
			document.getElementById('oef-tauxMarge').setAttribute("style", "color:red");
			document.getElementById('oef-pictoMargeNegative').collapsed = false;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_formatLigne(typeLigne) {
  try {

		switch(typeLigne) {
			case "S":
				document.getElementById('oef-codeStats').disabled = false;
				document.getElementById('oef-reference').disabled = true;
				document.getElementById('oef-designation').disabled = true;
				document.getElementById('oef-numLot').disabled = false;
				document.getElementById('oef-nbPieces').disabled = false;
				document.getElementById('oef-quantite').disabled = false;
				document.getElementById('oef-unite').disabled = false;
				document.getElementById('oef-datePeremption').disabled = false;
				document.getElementById('oef-PU').disabled = !oef_modifElemFin;
				document.getElementById('oef-ristourne').disabled = !oef_modifElemFin;
				document.getElementById('oef-bRistourne').disabled = !oef_modifElemFin;
				document.getElementById('oef-codeTVA').disabled = !oef_modifElemFin;
				document.getElementById('oef-bValider').disabled = false;
				document.getElementById('oef-bAnnuler').disabled = false;
				break;

			case "I":
				document.getElementById('oef-codeStats').disabled = false;
				document.getElementById('oef-reference').disabled = false;
				document.getElementById('oef-designation').disabled = false;
				document.getElementById('oef-numLot').disabled = false;
				document.getElementById('oef-nbPieces').disabled = false;
				document.getElementById('oef-quantite').disabled = false;
				document.getElementById('oef-unite').disabled = false;
				document.getElementById('oef-datePeremption').disabled = false;
				document.getElementById('oef-PU').disabled = !oef_modifElemFin;
				document.getElementById('oef-ristourne').disabled = !oef_modifElemFin;
				document.getElementById('oef-bRistourne').disabled = !oef_modifElemFin;
				document.getElementById('oef-codeTVA').disabled = !oef_modifElemFin;
				document.getElementById('oef-bValider').disabled = false;
				document.getElementById('oef-bAnnuler').disabled = false;
				break;

			default:
				document.getElementById('oef-codeStats').value = "";
				document.getElementById('oef-reference').value = "";
				document.getElementById('oef-designation').value = "";
				document.getElementById('oef-numLot').value = "";
				document.getElementById('oef-nbPieces').value = "";
				document.getElementById('oef-quantite').value = "";
				document.getElementById('oef-unite').value = oef_uniteDefaut;
				document.getElementById('oef-datePeremption').value = "";
				document.getElementById('oef-PU').value = "";
				document.getElementById('oef-ristourne').value = "";
				oef_libelle = "";
				oef_ligneId = "";
				document.getElementById('oef-codeTVA').value = getCodeTvaNormal(document.getElementById('oef-codePaysLiv').value, oef_assujettiTVA, document.getElementById('oef-regimeTVA').value);
				document.getElementById('oef-codeStats').disabled = true;
				document.getElementById('oef-reference').disabled = true;
				document.getElementById('oef-designation').disabled = true;
				document.getElementById('oef-numLot').disabled = true;
				document.getElementById('oef-nbPieces').disabled = true;
				document.getElementById('oef-quantite').disabled = true;
				document.getElementById('oef-unite').disabled = true;
				document.getElementById('oef-datePeremption').disabled = true;
				document.getElementById('oef-PU').disabled = true;
				document.getElementById('oef-ristourne').disabled = true;
				document.getElementById('oef-bRistourne').disabled = true;
				document.getElementById('oef-codeTVA').disabled = true;
				document.getElementById('oef-bCommentaire').disabled = true;
				document.getElementById('oef-bSupprimer').disabled = true;
				document.getElementById('oef-bMoveUp').disabled = true;
				document.getElementById('oef-bMoveDown').disabled = true;
				document.getElementById('oef-bMoveFirst').disabled = true;
				document.getElementById('oef-bMoveLast').disabled = true;
				document.getElementById('oef-bValider').disabled = true;
				document.getElementById('oef-bAnnuler').disabled = true;
				break;
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oef_listeTVA() {
  try {

  	oef_calculTotaux();

    oef_aCodesTVA.setParam("Code_Pays", document.getElementById("oef-codePaysLiv").value);
    oef_aCodesTVA.setParam("Regime_TVA", document.getElementById("oef-regimeTVA").value);
    oef_aCodesTVA.setParam("Assujetti_TVA", oef_assujettiTVA);
		oef_aCodesTVA.setParam("Selection", oef_codesTvaInactifs);
    oef_aCodesTVA.initTree(oef_selectTVA);

  } catch (e) {
    recup_erreur(e);
  }
}


function oef_selectTVA() {
  try {

    document.getElementById('oef-codeTVA').value = getCodeTvaNormal(document.getElementById('oef-codePaysLiv').value, oef_assujettiTVA, document.getElementById('oef-regimeTVA').value);

  } catch (e) {
    recup_erreur(e);
  }
}


function oef_switchRistourne() {
	try {

		if (oef_typeRistourne=='P') {
			document.getElementById('oef-bRistourne').setAttribute("class", "bIcoEuro");
			oef_typeRistourne = 'M';
		}
		else {
			document.getElementById('oef-bRistourne').setAttribute("class", "bIcoPourcentage");
			oef_typeRistourne = 'P';
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_switchRemise() {
	try {

		if (oef_typeRemise=='P') {
			document.getElementById('oef-bRemise').setAttribute("class", "bIcoEuro");
			oef_typeRemise = 'M';
		}
		else {
			document.getElementById('oef-bRemise').setAttribute("class", "bIcoPourcentage");
			oef_typeRemise = 'P';
		}
		oef_calculTotaux();
		oef_setModified(true);

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_switchRemiseFP() {
	try {

		if (oef_typeRemiseFP=='P') {
			document.getElementById('oef-bRemiseFP').setAttribute("class", "bIcoEuro");
			oef_typeRemiseFP = 'M';
		}
		else {
			document.getElementById('oef-bRemiseFP').setAttribute("class", "bIcoPourcentage");
			oef_typeRemiseFP = 'P';
		}
		oef_calculTotaux();
		oef_setModified(true);

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_ajouterLigne(typeLigne, articleId) {
  try {

  	document.getElementById('oef-bSupprimer').disabled = true;
  	document.getElementById('oef-bCommentaire').disabled = true;
  	document.getElementById('oef-bMoveUp').disabled = true;
		document.getElementById('oef-bMoveDown').disabled = true;
  	document.getElementById('oef-bMoveFirst').disabled = true;
		document.getElementById('oef-bMoveLast').disabled = true;

		oef_modeLigne = "C";
		oef_typeLigne = typeLigne;
		oef_ligneId = "";

		oef_formatLigne(typeLigne);
		var codePaysLiv = document.getElementById('oef-codePaysLiv').value;
		var regimeTVA = document.getElementById('oef-regimeTVA').value;

		if (typeLigne=="S") {
			oef_articleId = articleId;

			if (oef_modeTarif=='Q') {
				var url = "chrome://opensi/content/facturation/user/commun/popup-choixTarif.xul";
    		window.openDialog(url,'','chrome,modal,centerscreen', oef_retourChoixPrixQuantite, articleId);

				if (!isEmpty(oef_prixId)) {
					var qGet = new QueryHttp("Facturation/Articles/getInfosArticleQuantite.tmpl");
        	qGet.setParam("Article_Id", articleId);
        	qGet.setParam("Prix_Id", oef_prixId);
					qGet.setParam("TTC", oef_editionTTC);
					var result = qGet.execute();

					var contenu = result.responseXML.documentElement;
					if (isEmpty(document.getElementById('oef-codeStats').value)) {
						document.getElementById('oef-codeStats').value = contenu.getAttribute("Code_Stats");
					}
					document.getElementById('oef-designation').value = contenu.getAttribute("Designation");
					document.getElementById('oef-numLot').value = "";
					document.getElementById('oef-nbPieces').value = "";
					document.getElementById('oef-quantite').value = contenu.getAttribute("Quantite");
					document.getElementById('oef-unite').value = contenu.getAttribute("Unite_Id");
					document.getElementById('oef-datePeremption').value = "";
					document.getElementById('oef-PU').value = contenu.getAttribute("Prix_Unitaire");
					document.getElementById('oef-ristourne').value = "0.00";
					document.getElementById('oef-codeTVA').value = getCodeTvaCorrespondant(contenu.getAttribute("Code_TVA"), codePaysLiv, oef_assujettiTVA, regimeTVA);
					oef_prixId = "";
					oef_libelle = contenu.getAttribute("Libelle");
				}
				else {
					oef_ajouterLigne("I");
				}
			}
			else {
				var qGet = new QueryHttp("Facturation/Articles/getInfosArticleVente.tmpl");
        qGet.setParam("Article_Id", articleId);
        qGet.setParam("Tarif_Id", document.getElementById('oef-tarifVente').value);
				qGet.setParam("TTC", oef_editionTTC);
				qGet.setParam("Client_Id", oef_clientId);
				var result = qGet.execute();

				var contenu = result.responseXML.documentElement;
				if (isEmpty(document.getElementById('oef-codeStats').value)) {
					document.getElementById('oef-codeStats').value = contenu.getAttribute("Code_Stats");
				}
				document.getElementById('oef-designation').value = contenu.getAttribute("Designation");
				document.getElementById('oef-numLot').value = "";
				document.getElementById('oef-nbPieces').value = "";
				document.getElementById('oef-quantite').value = 1;
				document.getElementById('oef-unite').value = contenu.getAttribute("Unite_Id");
				document.getElementById('oef-datePeremption').value = "";
				document.getElementById('oef-PU').value = contenu.getAttribute("Prix_Unitaire");
				document.getElementById('oef-ristourne').value = contenu.getAttribute("Ristourne");
				document.getElementById('oef-codeTVA').value = getCodeTvaCorrespondant(contenu.getAttribute("Code_TVA"), codePaysLiv, oef_assujettiTVA, regimeTVA);
				oef_libelle = "";
			}
		}
		else {
			oef_articleId = "";
			document.getElementById('oef-codeStats').value = "";
			document.getElementById('oef-reference').value = "";
			document.getElementById('oef-designation').value = "";
			document.getElementById('oef-numLot').value = "";
			document.getElementById('oef-nbPieces').value = "";
			document.getElementById('oef-quantite').value = 1;
			document.getElementById('oef-unite').value = oef_uniteDefaut;
			document.getElementById('oef-datePeremption').value = "";
			document.getElementById('oef-PU').value = "";
			document.getElementById('oef-ristourne').value = "0.00";
			document.getElementById('oef-codeTVA').value = getCodeTvaNormal(codePaysLiv, oef_assujettiTVA, regimeTVA);
			oef_libelle = "";
			document.getElementById('oef-reference').focus();
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oef_pressOnWindow(ev) {
	try {

		if (ev.altKey && oef_mode!="V") {
			switch(ev.charCode) {
      	case 97: // 'a'
					oef_rechercherStock();
        	break;
				case 116: // 't'
					oef_modifierTarif();
					break;
    	}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_pressOnReference(ev) {
	try {

		if (ev.keyCode==13) {
			oef_rechercherReference();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_rechercherStock(reference) {
	try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
		var tarifId = (oef_modeTarif!="Q"?document.getElementById('oef-tarifVente').value:null);
    window.openDialog(url,'','chrome,modal,centerscreen', oef_retourRechercherStock, "V", reference, tarifId, null, null, null, oef_clientId);

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_retourRechercherStock(reference, articleId) {
	try {

		document.getElementById('oef-reference').value = reference;
		document.getElementById('oef-quantite').focus();
		oef_ajouterLigne("S", articleId);

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_rechercherReference() {
	try {

		var reference = document.getElementById('oef-reference').value;

		var qSearch = new QueryHttp("Facturation/Articles/searchReference.tmpl");
		qSearch.setParam("Reference", reference);
		qSearch.setParam("Vente_Achat", "V");
		var result = qSearch.execute();

		var articleId = result.responseXML.documentElement.getAttribute("Article_Id");
		if (!isEmpty(articleId)) {
			document.getElementById('oef-reference').value = result.responseXML.documentElement.getAttribute("Reference");
			document.getElementById('oef-quantite').focus();
			oef_ajouterLigne("S", articleId);
		}
		else {
			oef_rechercherStock(reference);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_modifierTarif() {
	try {

		if (oef_modeLigne=="M" && oef_typeLigne=='S' && oef_modeTarif=='Q') {

			var url = "chrome://opensi/content/facturation/user/commun/popup-choixTarif.xul";
    	window.openDialog(url,'','chrome,modal,centerscreen', oef_retourChoixPrixQuantite, oef_articleId);

			if (!isEmpty(oef_prixId)) {
				var qGet = new QueryHttp("Facturation/Articles/getInfosArticleQuantite.tmpl");
        qGet.setParam("Article_Id", oef_articleId);
        qGet.setParam("Prix_Id", oef_prixId);
				qGet.setParam("TTC", oef_editionTTC);
				var result = qGet.execute();

				var contenu = result.responseXML.documentElement;
				document.getElementById('oef-quantite').value = contenu.getAttribute("Quantite");
				document.getElementById('oef-unite').value = contenu.getAttribute("Unite_Id");
				document.getElementById('oef-PU').value = contenu.getAttribute("Prix_Unitaire");
				oef_prixId = "";
				oef_libelle = contenu.getAttribute("Libelle");
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_retourChoixPrixQuantite(prixId) {
	try {

		oef_prixId = prixId;

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_ouvrirLigne() {
  try {

		if (oef_aLignes.isSelected()) {
			var i = oef_aLignes.getCurrentIndex();
			oef_currentIndex = i;
			var typeLigne = oef_aLignes.getCellText(i,'oef-colTypeLigne');
			document.getElementById("oef-bConsultSerieLigne").disabled = (typeLigne!="S");
			if (oef_mode=="M") {
				if (oef_aLignes.getCellText(i,'oef-colTypeLigne')=="C") {
					oef_ajouterLigne("I");
				}
				else {
					oef_modeLigne = "M";
					document.getElementById('oef-bCommentaire').disabled = false;
					document.getElementById('oef-bSupprimer').disabled = false;

					document.getElementById('oef-codeStats').value = oef_aLignes.getCellText(i,'oef-colCodeStats');
					document.getElementById('oef-reference').value = oef_aLignes.getCellText(i,'oef-colReference');
					document.getElementById('oef-designation').value = oef_aLignes.getCellText(i,'oef-colDesignation');
					document.getElementById('oef-numLot').value = oef_aLignes.getCellText(i,'oef-colNumLot');
					document.getElementById('oef-nbPieces').value = oef_aLignes.getCellText(i,'oef-colNbPieces');
					document.getElementById('oef-quantite').value = oef_aLignes.getCellText(i,'oef-colQuantite');
					document.getElementById('oef-unite').value = oef_aLignes.getCellText(i,'oef-colUnite');
					document.getElementById('oef-datePeremption').value = oef_aLignes.getCellText(i,'oef-colDatePeremption');
					document.getElementById('oef-PU').value = oef_aLignes.getCellText(i,'oef-colPU');
					document.getElementById('oef-codeTVA').value = oef_aLignes.getCellText(i,'oef-colCodeTVA');
					document.getElementById('oef-ristourne').value = oef_aLignes.getCellValue(i,'oef-colRistourne');
					oef_typeRistourne = oef_aLignes.getSelectedCellText('oef-colTypeRistourne');
					document.getElementById('oef-bRistourne').setAttribute("class", (oef_typeRistourne=='P'?"bIcoPourcentage":"bIcoEuro"));
					oef_typeLigne = oef_aLignes.getCellText(i,'oef-colTypeLigne');
					oef_ligneId = oef_aLignes.getCellText(i,'oef-colLigneId');
					oef_articleId = oef_aLignes.getCellText(i,'oef-colArticleId');
					oef_libelle = oef_aLignes.getCellText(i,'oef-colLibelle');

					// on ignore les lignes de commentaires
					var firstIndex = 0;
					var lastIndex = oef_aLignes.nbLignes()-1;
					if (oef_aLignes.getCellText(firstIndex,'oef-colTypeLigne')=="C") { firstIndex++; }
					if (oef_aLignes.getCellText(lastIndex,'oef-colTypeLigne')=="C") { lastIndex--; }

					document.getElementById('oef-bMoveUp').disabled = (i==firstIndex);
					document.getElementById('oef-bMoveDown').disabled = (i==lastIndex);
					document.getElementById('oef-bMoveFirst').disabled = (i==firstIndex);
					document.getElementById('oef-bMoveLast').disabled = (i==lastIndex);

					oef_formatLigne(oef_typeLigne);
				}
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oef_ouvrirCommentaire() {
  try {

		if (oef_aLignes.isSelected() && oef_mode=="M") {
			var i = oef_aLignes.getCurrentIndex();
			if (oef_aLignes.getCellText(i,'oef-colTypeLigne')=="C") {
				// POUR L'INSTANT on n'autorise pas les modifications des commentaires
				//oef_editerCommentaire();
			}
			else {
				oef_editerPrixAchat();
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oef_deplacerLigne(moveType) {
	try {

		if (oef_aLignes.isSelected() && oef_mode=="M" && oef_aLignes.getSelectedCellText('oef-colTypeLigne')!="C") {

			document.getElementById('oef-bMoveUp').disabled = true;
			document.getElementById('oef-bMoveDown').disabled = true;
			document.getElementById('oef-bMoveFirst').disabled = true;
			document.getElementById('oef-bMoveLast').disabled = true;

			var qMove = new QueryHttp("Facturation/FacturesVente/moveLigneFactureClient.tmpl");
			qMove.setParam("Ligne_Id", oef_ligneId);
			qMove.setParam("Move_Type", moveType);
			var result = qMove.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oef_toSelectLigne = oef_ligneId;
				oef_ajouterLigne("I");
				oef_aLignes.deleteTree();
				oef_initTree2();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_validerLigne() {
  try {

		var codeStats = document.getElementById('oef-codeStats').value;
		var reference = document.getElementById('oef-reference').value;
		var designation = document.getElementById('oef-designation').value;
		var numLot = document.getElementById('oef-numLot').value;
		var nbPieces = document.getElementById('oef-nbPieces').value;
		var quantite = document.getElementById('oef-quantite').value;
		var unite = document.getElementById('oef-unite').value;
		var datePeremption = document.getElementById('oef-datePeremption').value;
		var prixUnitaire = document.getElementById('oef-PU').value;
		var ristourne = document.getElementById('oef-ristourne').value;
		var codeTVA = document.getElementById('oef-codeTVA').value;
		if (isEmpty(nbPieces)) { nbPieces = 0; }

		if (isEmpty(designation)) { showWarning("D\u00E9signation de l'article manquante !"); }
		else if (!checkQte(quantite)) { showWarning("Quantit\u00E9 incorrecte !");	}
		else if (!isPositiveOrNullInteger(nbPieces)) { showWarning("Nombre de pi\u00E8ces incorrect !");	}
		else if (isEmpty(prixUnitaire) || !isPositiveOrNull(prixUnitaire) || !checkDecimal(prixUnitaire,4)) { showWarning("Prix unitaire incorrect !");	}
		else if (isEmpty(ristourne) || (oef_typeRistourne=='P'?!isTaux(ristourne):!isPositiveOrNull(ristourne) || !checkNumber(ristourne,9,2) || parseFloat(ristourne)>parseFloat(prixUnitaire))) { showWarning("Ristourne incorrecte"); }
		else {

			var qSave;

			if (oef_modeLigne=="C") {
				oef_currentIndex = oef_aLignes.nbLignes();

				qSave = new QueryHttp("Facturation/FacturesVente/createLigneFactureClient.tmpl");
				qSave.setParam("Facture_Id", oef_factureId);
			}
			else {
				qSave = new QueryHttp("Facturation/FacturesVente/updateLigneFactureClient.tmpl");
				qSave.setParam("Ligne_Id", oef_ligneId);
			}

			qSave.setParam("Reference", reference);
			qSave.setParam("Designation", designation);
			qSave.setParam("Quantite", quantite);
			qSave.setParam("Prix", prixUnitaire);
			qSave.setParam("Ristourne", ristourne);
			qSave.setParam("Type_Ristourne", oef_typeRistourne);
			qSave.setParam("Code_TVA", codeTVA);
			qSave.setParam("Libelle", oef_libelle);
			qSave.setParam("Code_Stats", codeStats);
			qSave.setParam("Unite", unite);
			qSave.setParam("Nb_Pieces", nbPieces);
			qSave.setParam("Num_Lot", numLot);
			qSave.setParam("Date_Peremption", datePeremption);

			var result = qSave.execute();

			oef_ajouterLigne("I");
			oef_aLignes.deleteTree();
			oef_initTree2();
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oef_annulerLigne() {
  try {

  	oef_aLignes.clearSelection();
		oef_ajouterLigne("I");

	} catch (e) {
  	recup_erreur(e);
	}
}



function oef_supprimerLigne() {
  try {

		if (!isEmpty(oef_ligneId)) {
			var qDelete = new QueryHttp("Facturation/FacturesVente/deleteLigneFactureClient.tmpl");
			qDelete.setParam("Ligne_Id", oef_ligneId);
			qDelete.execute();

			oef_currentIndex--;
			oef_ajouterLigne("I");
			oef_aLignes.deleteTree();
			oef_initTree2();
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oef_enregistrerFacture() {
  try {

		var save = false;

		var utilR = document.getElementById('oef-responsable').value;
		var regimeTVA = document.getElementById('oef-regimeTVA').value;
		var numTva = oef_assujettiTVA?document.getElementById('oef-numTVA').value:"";
		var modeReglement = document.getElementById('oef-modeReglement').value;
		var echeance = document.getElementById('oef-echeance').value;
		var commentairesFin = document.getElementById('oef-commentairesFin').value;
		var commentairesInt = document.getElementById('oef-commentairesInt').value;
		var tarifVente = document.getElementById('oef-tarifVente').value;
		var secteurActivite = document.getElementById('oef-secteur').value;
		var remise = document.getElementById('oef-remise').value;
		var tauxRemise = 0;
		var montantRemise = 0;
		var fraisPort = document.getElementById('oef-fraisPort').value;
		var remiseFP = document.getElementById('oef-remiseFP').value;
		var tauxRemiseFP = 0;
		var montantRemiseFP = 0;
		var escompte = document.getElementById('oef-escompte').value;
		var montantDeduction = document.getElementById('oef-montantDeduction').value;
		oef_codeTVAPort = document.getElementById('oef-codeTVAFraisPort').value;
		var tauxTVAPort = getTva(oef_codeTVAPort);

		var denominationFact = document.getElementById('oef-denominationFact').value;
		var adresse1Fact = document.getElementById('oef-adresse1Fact').value;
		var adresse2Fact = document.getElementById('oef-adresse2Fact').value;
		var adresse3Fact = document.getElementById('oef-adresse3Fact').value;
		var codePostalFact = document.getElementById('oef-codePostalFact').value;
		var villeFact = document.getElementById('oef-villeFact').value;
		var codePaysFact = document.getElementById('oef-codePaysFact').value;
		var civInterFact = document.getElementById('oef-civInterFact').value;
		var nomInterFact = document.getElementById('oef-nomInterFact').value;
		var prenomInterFact = document.getElementById('oef-prenomInterFact').value;
		var telInter1Fact = document.getElementById('oef-telInter1Fact').value;
		var telInter2Fact = document.getElementById('oef-telInter2Fact').value;
		var faxInterFact = document.getElementById('oef-faxInterFact').value;
		var emailInterFact = document.getElementById('oef-emailInterFact').value;

		var denominationLiv = document.getElementById('oef-denominationLiv').value;
		var adresse1Liv = document.getElementById('oef-adresse1Liv').value;
		var adresse2Liv = document.getElementById('oef-adresse2Liv').value;
		var adresse3Liv = document.getElementById('oef-adresse3Liv').value;
		var codePostalLiv = document.getElementById('oef-codePostalLiv').value;
		var villeLiv = document.getElementById('oef-villeLiv').value;
		var codePaysLiv = document.getElementById('oef-codePaysLiv').value;
		var civInterLiv = document.getElementById('oef-civInterLiv').value;
		var nomInterLiv = document.getElementById('oef-nomInterLiv').value;
		var prenomInterLiv = document.getElementById('oef-prenomInterLiv').value;
		var telInter1Liv = document.getElementById('oef-telInter1Liv').value;
		var telInter2Liv = document.getElementById('oef-telInter2Liv').value;
		var faxInterLiv = document.getElementById('oef-faxInterLiv').value;
		var emailInterLiv = document.getElementById('oef-emailInterLiv').value;

		var denominationEnvoi = document.getElementById('oef-denominationEnvoi').value;
		var adresse1Envoi = document.getElementById('oef-adresse1Envoi').value;
		var adresse2Envoi = document.getElementById('oef-adresse2Envoi').value;
		var adresse3Envoi = document.getElementById('oef-adresse3Envoi').value;
		var codePostalEnvoi = document.getElementById('oef-codePostalEnvoi').value;
		var villeEnvoi = document.getElementById('oef-villeEnvoi').value;
		var codePaysEnvoi = document.getElementById('oef-codePaysEnvoi').value;
		var civInterEnvoi = document.getElementById('oef-civInterEnvoi').value;
		var nomInterEnvoi = document.getElementById('oef-nomInterEnvoi').value;
		var prenomInterEnvoi = document.getElementById('oef-prenomInterEnvoi').value;
		var telInter1Envoi = document.getElementById('oef-telInter1Envoi').value;
		var telInter2Envoi = document.getElementById('oef-telInter2Envoi').value;
		var faxInterEnvoi = document.getElementById('oef-faxInterEnvoi').value;
		var emailInterEnvoi = document.getElementById('oef-emailInterEnvoi').value;

		var modeEnvoiFacture = document.getElementById('oef-modeEnvoiFacture').value;

		var montantBase = (oef_editionTTC?oef_montantTTC:oef_montantHT);

		if (isEmpty(remise) || (oef_typeRemise=='P'?!isTaux(remise):!isPositiveOrNull(remise) || !checkNumber(remise,9,2) || parseFloat(remise)>montantBase)) { showWarning("Remise incorrecte !"); }
		else if (isEmpty(montantDeduction) || !isPositiveOrNull(montantDeduction) || !checkDecimal(montantDeduction,2)) { showWarning("Avoirs et trop-per\u00E7us \u00E0 d\u00E9duire incorrects"); }
		else if (isEmpty(fraisPort) || !isPositiveOrNull(fraisPort)) { showWarning("Frais de port incorrects !"); }
		else if (isEmpty(remiseFP) || (oef_typeRemiseFP=='P'?!isTaux(remiseFP):!isPositiveOrNull(remiseFP) || !checkNumber(remiseFP,9,2) || parseFloat(remiseFP)>parseFloat(fraisPort))) { showWarning("Remise sur frais de port incorrecte !"); }
		else if (!oef_bloquerEcheance && (isEmpty(echeance) || !isDate(echeance))) { showWarning("Date d'\u00E9ch\u00E9ance incorrecte !"); }
		else if (isEmpty(denominationFact)) { showWarning("Veuillez indiquer la d\u00E9nomination du client de facturation !"); }
		else if (isEmpty(adresse1Fact)) { showWarning("Veuillez indiquer l'adresse du client de facturation !"); }
		else if (isEmpty(villeFact)) { showWarning("Veuillez indiquer la ville du client de facturation !"); }
		else if (isEmpty(denominationLiv)) { showWarning("Veuillez indiquer la d\u00E9nomination du client de livraison !"); }
		else if (isEmpty(adresse1Liv)) { showWarning("Veuillez indiquer l'adresse du client de livraison !"); }
		else if (isEmpty(villeLiv)) { showWarning("Veuillez indiquer la ville du client de livraison !"); }
		else if (isEmpty(denominationEnvoi)) { showWarning("Veuillez indiquer la d\u00E9nomination du client d'envoi !"); }
		else if (isEmpty(adresse1Envoi)) { showWarning("Veuillez indiquer l'adresse du client d'envoi !"); }
		else if (isEmpty(villeEnvoi)) { showWarning("Veuillez indiquer la ville du client d'envoi !"); }
		else if (isEmpty(escompte) || !isTaux(escompte)) { showWarning("Taux d'escompte incorrect !"); }
		else if (!isEmpty(telInter1Fact) && !isPhone(telInter1Fact)) { showWarning("T\u00E9l\u00E9phone 1 de facturation incorrect !"); }
		else if (!isEmpty(telInter2Fact) && !isPhone(telInter2Fact)) { showWarning("T\u00E9l\u00E9phone 2 de facturation incorrect !"); }
		else if (gShowFax && !isEmpty(faxInterFact) && !isPhone(faxInterFact)) { showWarning("Num\u00E9ro de fax de facturation incorrect !"); }
		else if (!isEmpty(emailInterFact) && !isEmail(emailInterFact)) { showWarning("Adresse e-mail de facturation incorrecte !"); }
		else if (!isEmpty(telInter1Liv) && !isPhone(telInter1Liv)) { showWarning("T\u00E9l\u00E9phone 1 de livraison incorrect !"); }
		else if (!isEmpty(telInter2Liv) && !isPhone(telInter2Liv)) { showWarning("T\u00E9l\u00E9phone 2 de livraison incorrect !"); }
		else if (gShowFax && !isEmpty(faxInterLiv) && !isPhone(faxInterLiv)) { showWarning("Num\u00E9ro de fax de livraison incorrect !"); }
		else if (!isEmpty(emailInterLiv) && !isEmail(emailInterLiv)) { showWarning("Adresse e-mail de livraison incorrecte !"); }
		else if (!isEmpty(telInter1Envoi) && !isPhone(telInter1Envoi)) { showWarning("T\u00E9l\u00E9phone 1 d'envoi incorrect !"); }
		else if (!isEmpty(telInter2Envoi) && !isPhone(telInter2Envoi)) { showWarning("T\u00E9l\u00E9phone 2 d'envoi incorrect !"); }
		else if (gShowFax && !isEmpty(faxInterEnvoi) && !isPhone(faxInterEnvoi)) { showWarning("Num\u00E9ro de fax d'envoi incorrect !"); }
		else if (!isEmpty(emailInterEnvoi) && !isEmail(emailInterEnvoi)) { showWarning("Adresse e-mail d'envoi incorrecte !"); }
		else {

			fraisPort = parseFloat(fraisPort);
			remise = parseFloat(remise);
			remiseFP = parseFloat(remiseFP);

			if (oef_assujettiTVA && codePaysLiv!="FR" && isEmpty(numTva) && oef_zoneUE) {
				showWarning("Attention : vous n'avez pas saisi le num\u00E9ro de tva intra-communautaire !");
			}

			if (oef_typeRemise=='P') {
				tauxRemise = remise;
			}
			else {
				tauxRemise = (montantBase>0?remise/montantBase*100:0);
				montantRemise = remise;
			}

			if (oef_typeRemiseFP=='P') {
				tauxRemiseFP = remiseFP;
			}
			else {
				tauxRemiseFP = (fraisPort>0?remiseFP/fraisPort*100:0);
				montantRemiseFP = remiseFP;
			}

			var qEnregistrer = new QueryHttp("Facturation/FacturesVente/updateFactureClient.tmpl");
			qEnregistrer.setParam("Facture_Id", oef_factureId);
			qEnregistrer.setParam("Client_Id", oef_clientId);
			qEnregistrer.setParam("Util_R", utilR);
			qEnregistrer.setParam("Edition_TTC", oef_editionTTC);
			qEnregistrer.setParam("Regime_TVA", regimeTVA);
			qEnregistrer.setParam("Assujetti_TVA", oef_assujettiTVA);
			qEnregistrer.setParam("Num_TVA_Intra", numTva);
			qEnregistrer.setParam("Tarif_Id", tarifVente);
			qEnregistrer.setParam("Pole_Activite", secteurActivite);
			qEnregistrer.setParam("Mode_Reg_Id", modeReglement);
			qEnregistrer.setParam("Date_Echeance", echeance);
			qEnregistrer.setParam("Commentaires_Fin", commentairesFin);
			qEnregistrer.setParam("Commentaires_Int", commentairesInt);
			qEnregistrer.setParam("PRemise", tauxRemise);
			qEnregistrer.setParam("MRemise", montantRemise);
			qEnregistrer.setParam("PRemise_FP", tauxRemiseFP);
			qEnregistrer.setParam("MRemise_FP", montantRemiseFP);
			qEnregistrer.setParam("Escompte", escompte);
			qEnregistrer.setParam("Frais_Port", fraisPort);
			qEnregistrer.setParam("Montant_Deduction", montantDeduction);
			qEnregistrer.setParam("Code_TVA_Port", oef_codeTVAPort);
			qEnregistrer.setParam("Taux_TVA_Port", tauxTVAPort);
			qEnregistrer.setParam("Denomination", denominationFact);
			qEnregistrer.setParam("Adresse_1", adresse1Fact);
			qEnregistrer.setParam("Adresse_2", adresse2Fact);
			qEnregistrer.setParam("Adresse_3", adresse3Fact);
			qEnregistrer.setParam("Code_Postal", codePostalFact);
			qEnregistrer.setParam("Ville", villeFact);
			qEnregistrer.setParam("Code_Pays", codePaysFact);
			qEnregistrer.setParam("Civ_Inter", civInterFact);
			qEnregistrer.setParam("Nom_Inter", nomInterFact);
			qEnregistrer.setParam("Prenom_Inter", prenomInterFact);
			qEnregistrer.setParam("Tel_Inter_1", telInter1Fact);
			qEnregistrer.setParam("Tel_Inter_2", telInter2Fact);
			qEnregistrer.setParam("Fax_Inter", faxInterFact);
			qEnregistrer.setParam("Email_Inter", emailInterFact);
			qEnregistrer.setParam("Denomination_Liv", denominationLiv);
			qEnregistrer.setParam("Adresse_1_Liv", adresse1Liv);
			qEnregistrer.setParam("Adresse_2_Liv", adresse2Liv);
			qEnregistrer.setParam("Adresse_3_Liv", adresse3Liv);
			qEnregistrer.setParam("Code_Postal_Liv", codePostalLiv);
			qEnregistrer.setParam("Ville_Liv", villeLiv);
			qEnregistrer.setParam("Code_Pays_Liv", codePaysLiv);
			qEnregistrer.setParam("Civ_Inter_Liv", civInterLiv);
			qEnregistrer.setParam("Nom_Inter_Liv", nomInterLiv);
			qEnregistrer.setParam("Prenom_Inter_Liv", prenomInterLiv);
			qEnregistrer.setParam("Tel_Inter_1_Liv", telInter1Liv);
			qEnregistrer.setParam("Tel_Inter_2_Liv", telInter2Liv);
			qEnregistrer.setParam("Fax_Inter_Liv", faxInterLiv);
			qEnregistrer.setParam("Email_Inter_Liv", emailInterLiv);
			qEnregistrer.setParam("Denomination_Envoi", denominationEnvoi);
			qEnregistrer.setParam("Adresse_1_Envoi", adresse1Envoi);
			qEnregistrer.setParam("Adresse_2_Envoi", adresse2Envoi);
			qEnregistrer.setParam("Adresse_3_Envoi", adresse3Envoi);
			qEnregistrer.setParam("Code_Postal_Envoi", codePostalEnvoi);
			qEnregistrer.setParam("Ville_Envoi", villeEnvoi);
			qEnregistrer.setParam("Code_Pays_Envoi", codePaysEnvoi);
			qEnregistrer.setParam("Civ_Inter_Envoi", civInterEnvoi);
			qEnregistrer.setParam("Nom_Inter_Envoi", nomInterEnvoi);
			qEnregistrer.setParam("Prenom_Inter_Envoi", prenomInterEnvoi);
			qEnregistrer.setParam("Tel_Inter_1_Envoi", telInter1Envoi);
			qEnregistrer.setParam("Tel_Inter_2_Envoi", telInter2Envoi);
			qEnregistrer.setParam("Fax_Inter_Envoi", faxInterEnvoi);
			qEnregistrer.setParam("Email_Inter_Envoi", emailInterEnvoi);
			qEnregistrer.setParam("Mode_Envoi_Facture", modeEnvoiFacture);
			qEnregistrer.execute();

			oef_loadRecapitulatif();

			oef_setModified(false);
			save = true;
		}

		return save;

	} catch (e) {
  	recup_erreur(e);
	}
}



function oef_calculTotaux() {
  try {

		if (oef_mode!='V') {
			document.getElementById('oef-editionTTC').disabled = (oef_aLignes.nbLignes()>0);
	    document.getElementById('oef-codePaysLiv').disabled = (oef_aLignes.nbLignes()>0);
	   	document.getElementById('oef-bChercherAdrLiv').disabled = (isEmpty(oef_clientId) || oef_aLignes.nbLignes()>0);
	    document.getElementById('oef-bCopierFactVersLivEnvoi').disabled = (oef_aLignes.nbLignes()>0);
	    document.getElementById('oef-tarifVente').disabled = (oef_aLignes.nbLignes()>0);
			document.getElementById('oef-regimeTVA').disabled = (oef_aLignes.nbLignes()>0);
			document.getElementById('oef-assujettiTVA').disabled = (oef_aLignes.nbLignes()>0);
		}

		var remise = parseFloat(document.getElementById('oef-remise').value);
		var tauxEscompte = parseFloat(document.getElementById('oef-escompte').value);
		var fraisPort = parseFloat(document.getElementById('oef-fraisPort').value);
		var remiseFP = parseFloat(document.getElementById('oef-remiseFP').value);
		var montantDeduction = parseFloat(document.getElementById('oef-montantDeduction').value);

		if (isPositiveOrNull(remise) && isPositiveOrNull(remiseFP) && isPositiveOrNull(tauxEscompte) && isPositiveOrNull(fraisPort) && isPositiveOrNull(montantDeduction)) {

			if (oef_aLignes.isNotNull()) {

				var calculDocument = new CalculDocument();
				calculDocument.setEditionTTC(oef_editionTTC);
				if (oef_typeRemise=='P') { calculDocument.setRemiseP(remise); }
				else { calculDocument.setRemiseM(remise); }
				calculDocument.setFraisPortBruts(fraisPort);
				if (oef_typeRemiseFP=='P') { calculDocument.setRemiseFPP(remiseFP); }
				else { calculDocument.setRemiseFPM(remiseFP); }
				calculDocument.setCodeAndTauxTVAFP(document.getElementById('oef-codeTVAFraisPort').value, getTva(document.getElementById('oef-codeTVAFraisPort').value));
				calculDocument.setEscompteP(tauxEscompte);
				calculDocument.setAcompte(oef_acompte);

				var nbLignes = oef_aLignes.nbLignes();

				for (var i=0;i<nbLignes;i++) {
					if (oef_aLignes.getCellText(i,'oef-colTypeLigne')!="C") {
						var montantLigne = oef_aLignes.getCellText(i,'oef-colTotal');
						var codeTVA = oef_aLignes.getCellText(i,'oef-colCodeTVA');
						calculDocument.addLigneDocument(montantLigne, codeTVA);
					}
				}

				calculDocument.calculer();

				var fmon = new NumberFormat("0.00", true);

				if (oef_editionTTC) {
					document.getElementById('oef-pttcMontantRemise').value = calculDocument.getRemiseM();
					document.getElementById('oef-pttcMontantFraisPort').value = calculDocument.getFraisPortBruts();
					document.getElementById('oef-pttcMontantRemiseFP').value = calculDocument.getRemiseFPM();
					document.getElementById('oef-pttcTVA').value = calculDocument.getTotalTVA();
					document.getElementById('oef-pttcMontantTTC').value = calculDocument.getMontantTTC();
					document.getElementById('oef-pttcMontantEscompte').value = calculDocument.getEscompteM();
					document.getElementById('oef-pttcNetCommercial').value = calculDocument.getNetCommercial();
					document.getElementById('oef-pttcMontantAcompte').value = calculDocument.getAcompte();
					document.getElementById('oef-pttcDeduction').value = fmon.format(montantDeduction);
					document.getElementById('oef-pttcTotalTTC').value = calculDocument.getTotalTTC();
					document.getElementById('oef-pttcNetTTC').value = montantDeduction<=0?calculDocument.getNetAPayer():fmon.format(calculDocument.getNetAPayer()-montantDeduction);

					oef_montantTTC = calculDocument.getMontantTTCSansFormat();

					document.getElementById('oef-rowRemiseTTC').collapsed = !calculDocument.afficherRemiseM();
					document.getElementById('oef-rowRemiseFPTTC').collapsed = !calculDocument.afficherRemiseFPM();
					document.getElementById('oef-rowNetCommercialTTC').collapsed = !calculDocument.afficherNetCommercial();
					document.getElementById('oef-rowEscompteTTC').collapsed = !calculDocument.afficherEscompteM();
				}
				else {
					document.getElementById('oef-montantHT').value = calculDocument.getMontantHT();
					document.getElementById('oef-montantRemise').value = calculDocument.getRemiseM();
					document.getElementById('oef-montantFraisPort').value = calculDocument.getFraisPortBruts();
					document.getElementById('oef-montantRemiseFP').value = calculDocument.getRemiseFPM();
					document.getElementById('oef-totalHT').value = calculDocument.getTotalHT();
					document.getElementById('oef-TVA').value = calculDocument.getTotalTVA();
					document.getElementById('oef-montantEscompte').value = calculDocument.getEscompteM();
					document.getElementById('oef-netCommercial').value = calculDocument.getNetCommercial();
					document.getElementById('oef-montantAcompte').value = calculDocument.getAcompte();
					document.getElementById('oef-deduction').value = fmon.format(montantDeduction);
					document.getElementById('oef-totalTTC').value = calculDocument.getTotalTTC();

					oef_montantHT = calculDocument.getMontantHTSansFormat();
					oef_montantTTC = calculDocument.getMontantTTCSansFormat();

					document.getElementById('oef-rowRemiseHT').collapsed = !calculDocument.afficherRemiseM();
					document.getElementById('oef-rowRemiseFPHT').collapsed = !calculDocument.afficherRemiseFPM();
					document.getElementById('oef-rowNetCommercialHT').collapsed = !calculDocument.afficherNetCommercial();
					document.getElementById('oef-rowEscompteHT').collapsed = !calculDocument.afficherEscompteM();
				}
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oef_afterRefreshArticles() {
	try {

		if (oef_toSelectLigne!=null) {
			for (var i=0; i<oef_aLignes.nbLignes(); i++) {
				if (oef_aLignes.getCellText(i, "oef-colLigneId")==oef_toSelectLigne && oef_aLignes.getCellText(i, "oef-colTypeLigne")!="C") {
					oef_aLignes.select(i);
					break;
				}
			}
			oef_toSelectLigne = null;
		}
		oef_aLignes.ensureRowIsVisible(oef_currentIndex);

		document.getElementById('oef-reference').focus();
		oef_calculTotaux();
		oef_loadRecapitulatif();

	} catch (e) {
  	recup_erreur(e);
	}
}


function oef_demandeEnregistrement() {
  try {

		if (oef_modified) {
			if (window.confirm("Voulez-vous enregistrer les modifications apport\u00E9es \u00E0 la facture ?")) {
				oef_enregistrerFacture();
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oef_setModified(m) {
  try {

		oef_modified = m && !gReadOnly;

		if (oef_modified) {
			document.getElementById('oef-tabFacture').setAttribute('image', 'chrome://opensi/content/design/icones/modified.png');
			document.getElementById('oef-bApercu').disabled = true;
			document.getElementById('oef-bValiderFacture').disabled = true;
			document.getElementById('oef-bVisualiser').disabled = true;
			document.getElementById('oef-bEchMultiples').disabled = true;
		}
		else {
			document.getElementById('oef-tabFacture').setAttribute('image', gReadOnly?'chrome://opensi/content/design/icones/readonly.png':null);
			document.getElementById('oef-bApercu').disabled = false;
			document.getElementById('oef-bValiderFacture').disabled = false;
			document.getElementById('oef-bVisualiser').disabled = false;
			if (oef_mode!="C") { document.getElementById('oef-bEchMultiples').disabled = false; }
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oef_initTree2() {
  try {

  	oef_aLignes.setParam("Facture_Id", oef_factureId);
  	oef_aLignes.initTree(oef_afterRefreshArticles);

  } catch (e) {
    recup_erreur(e);
  }
}



function oef_editerCommentaire() {
  try {

		if (oef_aLignes.isSelected()) {
			var ligneId = oef_aLignes.getSelectedCellText('oef-colLigneId');

			var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesLigne.xul";
    	window.openDialog(url,'','chrome,modal,centerscreen', "FC", ligneId);

			oef_aLignes.deleteTree();
			oef_initTree2();
			oef_ajouterLigne("I");
		}
		else {
			showWarning("Aucun article ou commentaire s\u00E9lectionn\u00E9 !");
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_editerPrixAchat() {
  try {

		if (!gReadOnly && gAccesCoutAchat && gProfil.isModifPADV() && oef_aLignes.isSelected()) {
			var ligneId = oef_aLignes.getSelectedCellText('oef-colLigneId');

			var url = "chrome://opensi/content/facturation/user/commun/popup-modifierPrixAchat.xul";
    	window.openDialog(url,'','chrome,modal,centerscreen', oef_retourEditerPrixAchat, "FC", ligneId);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_retourEditerPrixAchat() {
	try {

		oef_aLignes.deleteTree();
		oef_initTree2();
		oef_ajouterLigne("I");

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_editerCommentairesInternes() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesInternes.xul";
  	window.openDialog(url,'','chrome,modal,centerscreen', "FC", oef_factureId, gReadOnly);

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_editerCommentairesDocument() {
  try {

		var commentairesFin = document.getElementById('oef-commentairesFin').value;
		var commentairesInt = document.getElementById('oef-commentairesInt').value;
		var readOnly = (oef_mode=="V" || gReadOnly);

		var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesDocument.xul";
  	window.openDialog(url,'','chrome,modal,centerscreen', oef_retourEditerCommentaires, "FC", oef_factureId, commentairesFin, commentairesInt, readOnly);

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_retourEditerCommentaires(commentairesFin, commentairesInt) {
  try {

		document.getElementById('oef-commentairesFin').value = commentairesFin;
		document.getElementById('oef-commentairesInt').value = commentairesInt;

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_evaluer(field, ev) {
	try {

		var val = field.value;

		if (ev.keyCode==13 && !isEmpty(val) && isArithmetic(val)) {
			field.value = calcExpr(val);
		}

	}	catch(e) {
		recup_erreur(e);
	}
}


function oef_pressOnLineNumberField(field, ev) {
	try {

		var val = field.value;

		if (ev.keyCode==13 && !isEmpty(val)) {
			if (isArithmetic(val)) {
				field.value = calcExpr(val);
			}
			else {
				oef_validerLigne();
			}
		}

	}	catch(e) {
		recup_erreur(e);
	}
}


function oef_changerTypeEdition(chgType) {
	try {

		oef_editionTTC = chgType;

		if (oef_editionTTC) {
			document.getElementById('oef-colTotal').setAttribute("label", "Total TTC");
			document.getElementById('oef-colPU').setAttribute("label", "P.U TTC");
			document.getElementById('oef-lblFraisPort').value = "Frais de port (ttc) :";
			document.getElementById('oef-lblPU').value = "P.U TTC :";
			document.getElementById('oef-piedTTC').collapsed = false;
			document.getElementById('oef-piedHT').collapsed = true;
		}
		else {
			document.getElementById('oef-colTotal').setAttribute("label", "Total HT");
			document.getElementById('oef-colPU').setAttribute("label", "P.U HT");
			document.getElementById('oef-lblFraisPort').value = "Frais de port (ht) :";
			document.getElementById('oef-lblPU').value = "P.U HT :";
			document.getElementById('oef-piedTTC').collapsed = true;
			document.getElementById('oef-piedHT').collapsed = false;
		}

	}	catch(e) {
		recup_erreur(e);
	}
}


function oef_changerAssujettiTVA(etat) {
	try {

		oef_assujettiTVA = etat;
		document.getElementById('oef-numTVA').disabled=!oef_assujettiTVA;
		oef_chargerTVAPort();
		oef_setModified(true);

	}	catch(e) {
		recup_erreur(e);
	}
}


function oef_rechercherAdrFact() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixAdresse.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oef_reporterAdrFact, oef_clientId, gReadOnly);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oef_reporterAdrFact(nom, adr1, adr2, adr3, cp, ville, pays, codePays, contactFact, contactLiv, contactEnvoi, contactDevis, adresseId) {
  try {

		document.getElementById('oef-denominationFact').value = nom;
		document.getElementById('oef-adresse1Fact').value = adr1;
		document.getElementById('oef-adresse2Fact').value = adr2;
		document.getElementById('oef-adresse3Fact').value = adr3;
		document.getElementById('oef-codePostalFact').value = cp;
		document.getElementById('oef-villeFact').value = ville;
	  document.getElementById('oef-codePaysFact').value = codePays;

	  if (!isEmpty(contactFact)) {
	  	var qLoad = new QueryHttp("Facturation/Clients/loadContactClient.tmpl");
	  	qLoad.setParam("Contact_Id", contactFact);
	  	var result = qLoad.execute();
	  	var contenu = result.responseXML.documentElement;
	  	oef_reporterInterFact(contenu.getAttribute("Civilite"), contenu.getAttribute("Nom"), contenu.getAttribute("Prenom"), contenu.getAttribute("Tel_1"),contenu.getAttribute("Tel_2"), contenu.getAttribute("Fax"), contenu.getAttribute("Email"));
	  }
		oef_setModified(true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oef_rechercherInterlocuteurFact() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixInter.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oef_reporterInterFact, oef_clientId, gReadOnly);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oef_reporterInterFact(civ, nom, prenom, tel1, tel2, fax, email) {
  try {

		document.getElementById('oef-civInterFact').value = civ;
		document.getElementById('oef-nomInterFact').value = nom;
		document.getElementById('oef-prenomInterFact').value = prenom;
		document.getElementById('oef-telInter1Fact').value = tel1;
		document.getElementById('oef-telInter2Fact').value = tel2;
		document.getElementById('oef-faxInterFact').value = fax;
		document.getElementById('oef-emailInterFact').value = email;

		oef_setModified(true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oef_rechercherAdrEnvoi() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixAdresse.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oef_reporterAdrEnvoi, oef_clientId, gReadOnly);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oef_reporterAdrEnvoi(nom, adr1, adr2, adr3, cp, ville, pays, codePays, contactFact, contactLiv, contactEnvoi, contactDevis, adresseId) {
  try {

		document.getElementById('oef-denominationEnvoi').value = nom;
		document.getElementById('oef-adresse1Envoi').value = adr1;
		document.getElementById('oef-adresse2Envoi').value = adr2;
		document.getElementById('oef-adresse3Envoi').value = adr3;
		document.getElementById('oef-codePostalEnvoi').value = cp;
		document.getElementById('oef-villeEnvoi').value = ville;
	  document.getElementById('oef-codePaysEnvoi').value = codePays;

	  if (!isEmpty(contactEnvoi)) {
	  	var qLoad = new QueryHttp("Facturation/Clients/loadContactClient.tmpl");
	  	qLoad.setParam("Contact_Id", contactEnvoi);
	  	var result = qLoad.execute();
	  	var contenu = result.responseXML.documentElement;
	  	oef_reporterInterEnvoi(contenu.getAttribute("Civilite"), contenu.getAttribute("Nom"), contenu.getAttribute("Prenom"), contenu.getAttribute("Tel_1"),contenu.getAttribute("Tel_2"), contenu.getAttribute("Fax"), contenu.getAttribute("Email"));
	  }

		oef_setModified(true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oef_copierFactVersLivEnvoi() {
	try {

		document.getElementById('oef-denominationLiv').value = document.getElementById('oef-denominationFact').value;
		document.getElementById('oef-adresse1Liv').value = document.getElementById('oef-adresse1Fact').value;
		document.getElementById('oef-adresse2Liv').value = document.getElementById('oef-adresse2Fact').value;
		document.getElementById('oef-adresse3Liv').value = document.getElementById('oef-adresse3Fact').value;
		document.getElementById('oef-codePostalLiv').value = document.getElementById('oef-codePostalFact').value;
		document.getElementById('oef-villeLiv').value = document.getElementById('oef-villeFact').value;
	  document.getElementById('oef-codePaysLiv').value = document.getElementById('oef-codePaysFact').value;

	  document.getElementById('oef-civInterLiv').value = document.getElementById('oef-civInterFact').value;
		document.getElementById('oef-nomInterLiv').value = document.getElementById('oef-nomInterFact').value;
		document.getElementById('oef-prenomInterLiv').value = document.getElementById('oef-prenomInterFact').value;
		document.getElementById('oef-telInter1Liv').value = document.getElementById('oef-telInter1Fact').value;
		document.getElementById('oef-telInter2Liv').value = document.getElementById('oef-telInter2Fact').value;
		document.getElementById('oef-faxInterLiv').value = document.getElementById('oef-faxInterFact').value;
		document.getElementById('oef-emailInterLiv').value = document.getElementById('oef-emailInterFact').value;

		document.getElementById('oef-denominationEnvoi').value = document.getElementById('oef-denominationFact').value;
		document.getElementById('oef-adresse1Envoi').value = document.getElementById('oef-adresse1Fact').value;
		document.getElementById('oef-adresse2Envoi').value = document.getElementById('oef-adresse2Fact').value;
		document.getElementById('oef-adresse3Envoi').value = document.getElementById('oef-adresse3Fact').value;
		document.getElementById('oef-codePostalEnvoi').value = document.getElementById('oef-codePostalFact').value;
		document.getElementById('oef-villeEnvoi').value = document.getElementById('oef-villeFact').value;
	  document.getElementById('oef-codePaysEnvoi').value = document.getElementById('oef-codePaysFact').value;

	  document.getElementById('oef-civInterEnvoi').value = document.getElementById('oef-civInterFact').value;
		document.getElementById('oef-nomInterEnvoi').value = document.getElementById('oef-nomInterFact').value;
		document.getElementById('oef-prenomInterEnvoi').value = document.getElementById('oef-prenomInterFact').value;
		document.getElementById('oef-telInter1Envoi').value = document.getElementById('oef-telInter1Fact').value;
		document.getElementById('oef-telInter2Envoi').value = document.getElementById('oef-telInter2Fact').value;
		document.getElementById('oef-faxInterEnvoi').value = document.getElementById('oef-faxInterFact').value;
		document.getElementById('oef-emailInterEnvoi').value = document.getElementById('oef-emailInterFact').value;

		oef_chargerTVAPort();
	  oef_setModified(true);

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_rechercherAdrLiv() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixAdresse.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oef_reporterAdrLiv, oef_clientId, gReadOnly);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oef_reporterAdrLiv(nom, adr1, adr2, adr3, cp, ville, pays, codePays, contactFact, contactLiv, contactEnvoi, contactDevis, adresseId) {
  try {

		document.getElementById('oef-denominationLiv').value = nom;
		document.getElementById('oef-adresse1Liv').value = adr1;
		document.getElementById('oef-adresse2Liv').value = adr2;
		document.getElementById('oef-adresse3Liv').value = adr3;
		document.getElementById('oef-codePostalLiv').value = cp;
		document.getElementById('oef-villeLiv').value = ville;
	  document.getElementById('oef-codePaysLiv').value = codePays;
	  oef_chargerTVAPort();

		if (!isEmpty(contactLiv)) {
	  	var qLoad = new QueryHttp("Facturation/Clients/loadContactClient.tmpl");
	  	qLoad.setParam("Contact_Id", contactLiv);
	  	var result = qLoad.execute();
	  	var contenu = result.responseXML.documentElement;
	  	oef_reporterInterLiv(contenu.getAttribute("Civilite"),contenu.getAttribute("Nom"),contenu.getAttribute("Prenom"),contenu.getAttribute("Tel_1"),contenu.getAttribute("Tel_2"),contenu.getAttribute("Fax"),contenu.getAttribute("Email"));
	  }
	  oef_setModified(true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oef_rechercherInterlocuteurLiv() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixInter.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oef_reporterInterLiv, oef_clientId, gReadOnly);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oef_reporterInterLiv(civ, nom, prenom, tel1, tel2, fax, email) {
  try {

		document.getElementById('oef-civInterLiv').value = civ;
		document.getElementById('oef-nomInterLiv').value = nom;
		document.getElementById('oef-prenomInterLiv').value = prenom;
		document.getElementById('oef-telInter1Liv').value = tel1;
		document.getElementById('oef-telInter2Liv').value = tel2;
		document.getElementById('oef-faxInterLiv').value = fax;
		document.getElementById('oef-emailInterLiv').value = email;

		oef_setModified(true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oef_rechercherInterlocuteurEnvoi() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixInter.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oef_reporterInterEnvoi, oef_clientId, gReadOnly);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oef_reporterInterEnvoi(civ, nom, prenom, tel1, tel2, fax, email) {
  try {

		document.getElementById('oef-civInterEnvoi').value = civ;
		document.getElementById('oef-nomInterEnvoi').value = nom;
		document.getElementById('oef-prenomInterEnvoi').value = prenom;
		document.getElementById('oef-telInter1Envoi').value = tel1;
		document.getElementById('oef-telInter2Envoi').value = tel2;
		document.getElementById('oef-faxInterEnvoi').value = fax;
		document.getElementById('oef-emailInterEnvoi').value = email;

		oef_setModified(true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oef_choisirMentions() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-mentionsDocument.xul";
  	window.openDialog(url,'','chrome,modal,centerscreen', "FC", oef_factureId, gReadOnly);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oef_apercuFacture() {
  try {

		if (oef_aLignes.nbLignes()==0 && document.getElementById('oef-fraisPort').value==0) {
			showWarning("La facture ne contient aucune ligne");
		}
		else {
			oef_apercu = true;

			var qLangueDefaut = new QueryHttp("Facturation/Commun/getLangueDefaut.tmpl");
			qLangueDefaut.setParam("Type_Doc", "FC");
			qLangueDefaut.setParam("Doc_Id", oef_factureId);
			var result = qLangueDefaut.execute();
			oef_langueDefaut = result.responseXML.documentElement.getAttribute("Langue_Id");
			oef_aLangues.setParam("Selection", oef_langueDefaut);
			oef_aLangues.initTree(oef_initLangue);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_editerFacture() {
	try {

		var ok = true;
  	if (oef_mode=="M") {
  		ok = false;
			var montantBase = (oef_editionTTC?oef_montantTTC:oef_montantHT);
			var remise = document.getElementById('oef-remise').value;

			if (oef_aLignes.nbLignes()==0 && document.getElementById('oef-fraisPort').value==0) {
				showWarning("La facture ne contient aucune ligne");
			}
			else if (isEmpty(remise) || (oef_typeRemise=='P'?!isTaux(remise):!isPositiveOrNull(remise) || !checkNumber(remise,9,2) || parseFloat(remise)>montantBase)) {
				showWarning("Remise incorrecte !");
			}
  		else {
	    	var qCheck = new QueryHttp("Facturation/FacturesVente/checkEcheancesFacture.tmpl");
	    	qCheck.setParam("Facture_Id", oef_factureId);

				var result = qCheck.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					ok = window.confirm("Confirmez-vous la g\u00E9n\u00E9ration de la facture ?\n(Attention la facture g\u00E9n\u00E9r\u00E9e ne pourra plus \u00EAtre modifi\u00E9e !)");
				}
  		}
  	}

		if (ok) {
			oef_apercu = false;

			var qLangueDefaut = new QueryHttp("Facturation/Commun/getLangueDefaut.tmpl");
			qLangueDefaut.setParam("Type_Doc", "FC");
			qLangueDefaut.setParam("Doc_Id", oef_factureId);
			var result = qLangueDefaut.execute();
			oef_langueDefaut = result.responseXML.documentElement.getAttribute("Langue_Id");
			oef_aLangues.setParam("Selection", oef_langueDefaut);
			oef_aLangues.initTree(oef_initLangue);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_initLangue() {
	try {
		document.getElementById('oef-langueDefaut').value = oef_langueDefaut;
		oef_visualiserFacture();
	} catch (e) {
		recup_erreur(e);
	}
}


function oef_visualiserFacture() {
  try {

  	var langue = document.getElementById('oef-langueDefaut').value;
  	var qGenPdf = new QueryHttp("Facturation/FacturesVente/pdfFactureClient.tmpl");
		qGenPdf.setParam("Facture_Id", oef_factureId);
		qGenPdf.setParam("Langue_Id", langue);
		qGenPdf.setParam("Apercu", oef_apercu);

		var result = qGenPdf.execute();
		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			document.getElementById('oef-pdfFacture').setAttribute('src', '');
			document.getElementById('oef-deckFacture').selectedIndex = 1;
			document.getElementById('bRetourFacture').collapsed = false;

			var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
			document.getElementById('oef-pdfFacture').setAttribute("src", page);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_envoyerMail() {
	try {

		var langue = document.getElementById('oef-langueDefaut').value;

		var url = "chrome://opensi/content/popup/popup-envoyerMail.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', "FC", oef_factureId, langue);

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_supprimerFacture() {
  try {

		if (window.confirm("Confirmez-vous la suppression de la facture ?")) {
			var qDelete = new QueryHttp("Facturation/FacturesVente/deleteFactureClient.tmpl");
			qDelete.setParam("Facture_Id", oef_factureId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("La facture a \u00E9t\u00E9 supprim\u00E9e");
			}

			retourFicheAffaire();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_transformerAvoir() {
	try {

		if (window.confirm("Voulez-vous cr\u00E9er un avoir \u00E0 partir de cette facture ?")) {
			var qCheck = new QueryHttp("Facturation/Affaires/checkAvoirAffairePossible.tmpl");
			qCheck.setParam("Affaire_Id", ofa_affaireId);
			var result = qCheck.execute();

			if (result.responseXML.documentElement.getAttribute("Possible")=="true") {
				var qTransFact = new QueryHttp("Facturation/FacturesVente/transFactureAvoir.tmpl");
				qTransFact.setParam("Facture_Id", oef_factureId);
				var result = qTransFact.execute();
				oea_avoirId = result.responseXML.documentElement.getAttribute("Avoir_Id");
				oea_chargerAvoir();
				document.getElementById('deck').selectedIndex = 6;
			}
			else {
				showWarning("Impossible de cr\u00E9er un avoir tant que les avoirs pr\u00E9c\u00E9dents ne sont pas valid\u00E9s !");
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_pressOnEcheancesMultiples() {
	try {

		var url = "chrome://opensi/content/facturation/user/factures_vente/popup-echeancesMultiples.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oef_refreshEcheance, oef_factureId, (oef_mode!="V" && !gReadOnly));

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_refreshEcheance() {
	try {

		var qGet = new QueryHttp("Facturation/FacturesVente/getFirstEcheanceClient.tmpl");
		qGet.setParam("Facture_Id", oef_factureId);
		var result = qGet.execute();
		var contenu = result.responseXML.documentElement;

		document.getElementById('oef-echeance').value = contenu.getAttribute('Date_Echeance');
		oef_chargerModesReglements(contenu.getAttribute('Mode_Reg_Id'));
		var echModifiable = contenu.getAttribute('Ech_Modifiable')=="true";
  	document.getElementById('oef-echeance').disabled = !echModifiable;
		document.getElementById('oef-modeReglement').disabled = !echModifiable;

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_initVersion() {
	try {

		oef_aVersion.setParam("Facture_Id", oef_factureId);
		oef_aVersion.initTree();

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_consulterNumSerie() {
	try {

		if (oef_aLignes.isSelected()) {
			var ligneId = oef_aLignes.getSelectedCellText('oef-colLigneId');
			var url = "chrome://opensi/content/facturation/user/commun/popup-numSerie.xul";
    	window.openDialog(url,'','chrome,modal,centerscreen', "C", "FC", ligneId);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_chargerTarifsVente(selection) {
	try {

		oef_selTarifVente = selection;
		oef_aTarifsVente.setParam("Selection", oef_selTarifVente);
		oef_aTarifsVente.initTree(oef_initTarifVente);

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_initTarifVente() {
  try {

		document.getElementById('oef-tarifVente').value = oef_selTarifVente;

	} catch (e) {
  	recup_erreur(e);
	}
}
