/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var oma_existeSites;
var oma_defautEtatCommande;
var oma_defautEtatLogistique;
var oma_defautEtatPaiement;
var oma_defautProvenance;
var oma_defautEtablissement;
var oma_defautDepot;
var oma_modeTraitement;
var oma_calculStock;

var oma_pageCourante;
var oma_nbPages;
var oma_alerteEncoursClient;
var oma_currentIndex = -1;
var oma_affStats;
var oma_restrictedPoleActivite = "";

var oma_hidExpedier = false;
var oma_hidReassort = false;
var oma_hidRupture = false;
var oma_hidPreparation = false;
var oma_hidPretExpedier = false;

var oma_aResponsables = new Arbre("ComboListe/combo-responsables.tmpl", "oma-responsable");
var oma_aModesReglements = new Arbre("ComboListe/combo-modesReglement.tmpl","oma-modeReglement");
var oma_aProvenance = new Arbre("ComboListe/combo-sitesWeb.tmpl","oma-provenance");
var oma_aMarketplaces = new Arbre("ComboListe/combo-marketplaces.tmpl","oma-marketplace");
var oma_aModesExpedition = new Arbre("ComboListe/combo-modesExpedition.tmpl","oma-modeExpedition");
var oma_aPolesActivite = new Arbre("ComboListe/combo-polesActivite.tmpl", "oma-poleActivite");
var oma_aMarques = new Arbre('ComboListe/combo-marquesArticle.tmpl', 'oma-marque');
var oma_aEtablissements = new Arbre('ComboListe/combo-etablissements.tmpl', 'oma-etablissement');
var oma_aDepots = new Arbre('ComboListe/combo-depotsStock.tmpl', 'oma-depot');
var oma_aListeCommandes = new Arbre("Facturation/Affaires/liste-commandes.tmpl","oma-listeCommandes");
var oma_aListeAffaires = new Arbre("Facturation/Affaires/liste-affaires.tmpl","oma-listeAffaires");
var oma_aApercuCommande = new Arbre("Facturation/Affaires/liste-apercuCommande.tmpl","oma-apercuCommande");
var oma_aApercuAffaire = new Arbre("Facturation/Affaires/liste-apercuAffaire.tmpl","oma-apercuAffaire");
var oma_qListCC = new QueryHttp("Facturation/Affaires/getDataListCC.tmpl");
var oma_qListAFF = new QueryHttp("Facturation/Affaires/getDataListAFF.tmpl");



function oma_init() {
  try {

		if (gProfil.isRestricAccCDVPA() && !isEmpty(gProfil.getPoleActivite())) {
			oma_restrictedPoleActivite = gProfil.getPoleActivite();
			document.getElementById('oma-poleActivite').disabled = true;
		}

		document.getElementById('oma-miProvenanceHL').collapsed = !gProfil.isProvenanceHL();

		document.getElementById("oma-boxTotaux").collapsed = !gProfil.isShowTotauxDV();
		oma_affStats = gProfil.isShowTotauxDV();

  	document.getElementById('oma-boxNouvelleAffaire').collapsed = gReadOnly;

		oma_modeTraitement = gConfig.getModeTraitement();
		document.getElementById('oma-modeTraitement').value = oma_modeTraitement;
		document.getElementById('oma-listeCommandes').collapsed = (oma_modeTraitement=="A");
		document.getElementById('oma-listeAffaires').collapsed = (oma_modeTraitement=="C");
		document.getElementById('oma-bValiderCommande').collapsed = (oma_modeTraitement=="A" || (gReadOnly && !gProfil.isValidationCC()));
		document.getElementById('oma-bEditionPdf').collapsed = (oma_modeTraitement=="A");
		document.getElementById('oma-bEditionCsvArticles').collapsed = (oma_modeTraitement=="A");

		oma_alerteEncoursClient = gConfig.isAlerteEncoursClient();
		oma_defautEtatCommande = gConfig.getDefEtatRechCom();
		oma_defautEtatLogistique = gConfig.getDefEtatRechLog();
		oma_defautEtatPaiement = gConfig.getGACEtatPaiement();
		oma_defautProvenance = gConfig.getGACProvenance();
		oma_defautEtablissement = gConfig.getGACDefFiltreEtab();
		oma_defautDepot = gConfig.getGACDefFiltreDepot();
		oma_calculStock = gConfig.isCalculStock();

		if (!gConfig.isActDispoFour()) {
			document.getElementById('oma-miRupture').setAttribute("hidden", true);
			oma_hidRupture = true;
		}

		if (gConfig.isGACStatutArchive()) {
			document.getElementById('oma-miTousArchive').setAttribute("hidden", false);
		}

		if (!oma_calculStock) {
			document.getElementById('oma-miExpedier').setAttribute("hidden", true);
			document.getElementById('oma-miReassort').setAttribute("hidden", true);
			document.getElementById('oma-miRupture').setAttribute("hidden", true);
			document.getElementById('oma-lcColStock').setAttribute("hidden",true);
			document.getElementById('oma-lcColStock').setAttribute("ignoreincolumnpicker", true);
			document.getElementById('oma-lcColStatutReassort').setAttribute("hidden", true);
			document.getElementById('oma-lcColStatutReassort').setAttribute("ignoreincolumnpicker", true);
			oma_hidExpedier = true;
			oma_hidReassort = true;
			oma_hidRupture = true;

			if (oma_defautEtatLogistique=="C" || oma_defautEtatLogistique=="R") {
				oma_defautEtatLogistique = "T";
			}
		}

		if (gConfig.isActDepotLigneCC()) {
			document.getElementById('oma-lcColDepotExpedition').collapsed = true;
			document.getElementById('oma-lcColDepotExpedition').setAttribute("ignoreincolumnpicker",true);
		}

		var qExistEPE = new QueryHttp("Facturation/Affaires/existEtapePrepaExpedition.tmpl");
		var result = qExistEPE.execute();
		var prepaExpe = (result.responseXML.documentElement.getAttribute("Exist")=="true");

		var qExistECE = new QueryHttp("Facturation/Affaires/existEtapeConfirmExpedition.tmpl");
		result = qExistECE.execute();
		var confirmExpe = (result.responseXML.documentElement.getAttribute("Exist")=="true");

		if (!prepaExpe) {
			document.getElementById('oma-miPreparation').setAttribute("hidden", true);
			oma_hidPreparation = true;
		}
		if (!confirmExpe) {
			document.getElementById('oma-miPretExpedier').setAttribute("hidden", true);
			oma_hidPretExpedier = true;
		}

		oma_existeSites = gConfig.isECommerce();
		if (!oma_existeSites) {
			document.getElementById('oma-lcColLoginWeb').setAttribute("hidden",true);
			document.getElementById('oma-lcColLoginWeb').setAttribute("ignoreincolumnpicker",true);
			document.getElementById('oma-lcColProvenance').setAttribute("hidden",true);
			document.getElementById('oma-lcColProvenance').setAttribute("ignoreincolumnpicker",true);
		}
		document.getElementById('oma-boxLoginWeb').collapsed = !oma_existeSites;

		oma_initStats();
		document.getElementById('oma-nbLignesParPage').selectedIndex = 0;
		oma_aModesReglements.initTree(oma_initModeReglement);

  } catch (e) {
  	recup_erreur(e);
  }
}


function oma_initModeReglement() {
	try {

		document.getElementById('oma-modeReglement').selectedIndex = 0;
		oma_aProvenance.initTree(oma_initResponsable);

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_initResponsable() {
	try {

		oma_aResponsables.initTree(oma_initProvenance);

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_initProvenance() {
	try {

		document.getElementById('oma-provenance').selectedIndex = 0;
		oma_aMarketplaces.initTree(oma_initMarketplace);

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_initMarketplace() {
	try {

		document.getElementById('oma-marketplace').selectedIndex = 0;
		oma_aModesExpedition.initTree(oma_initModeExpedition);

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_initModeExpedition() {
	try {

		document.getElementById('oma-modeExpedition').selectedIndex = 0;

		if (!isEmpty(oma_restrictedPoleActivite)) {
			oma_aPolesActivite.setParam("Selection", oma_restrictedPoleActivite);
		}
		oma_aPolesActivite.initTree(oma_initPoleActivite);

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_initPoleActivite() {
	try {

		oma_aEtablissements.setParam('Selection', etablissementDefaut);
		oma_aEtablissements.initTree(oma_initMarque);

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_initMarque() {
	try {

		oma_aMarques.setParam("Search_Mode", true);
		oma_aMarques.initTree(oma_initEtablissement);

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_initEtablissement() {
	try {

		document.getElementById('oma-etablissement').value = (oma_defautEtablissement=="U"?etablissementDefaut:"");
		oma_aDepots.setParam('Depot_Vente', false);
		oma_aDepots.setParam('Depot_Quarantaine', false);
		oma_aDepots.setParam('Selection', oma_defautDepot=="0"?depotDefaut:oma_defautDepot);
		oma_aDepots.initTree(oma_initDepot);

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_initDepot() {
	try {

		document.getElementById('oma-depot').value = oma_defautDepot=="0"?depotDefaut:oma_defautDepot;
		oma_initCriteres();

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_pressOnNouvelleAffaire() {
	try {

		document.getElementById("bMenuAffaires").collapsed=false;
		document.getElementById("deck").selectedIndex=1;
		ofa_nouvelleAffaire();

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_initStats() {
	try {

		var qStats = new QueryHttp("Facturation/Affaires/getStatsCommandeClient.tmpl");
		qStats.execute(oma_initStatsFin);

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_initStatsFin(result) {
	try {

		var contenu = result.responseXML.documentElement;

		document.getElementById('oma-nbCommandesEnCours').value = contenu.getAttribute("Nb_Commandes_En_Cours");
		document.getElementById('oma-montantHTCommandesEnCours').value = contenu.getAttribute("Montant_HT_Commandes_En_Cours");
		document.getElementById('oma-nbCommandesAFacturer').value = contenu.getAttribute("Nb_Commandes_A_Facturer");
		document.getElementById('oma-montantHTCommandesAFacturer').value = contenu.getAttribute("Montant_HT_Commandes_A_Facturer");
		document.getElementById('oma-nbCommandesAPreparer').value = contenu.getAttribute("Nb_Commandes_A_Preparer");
		document.getElementById('oma-montantHTCommandesAPreparer').value = contenu.getAttribute("Montant_HT_Commandes_A_Preparer");
		document.getElementById('oma-nbCommandesAExpedier').value = contenu.getAttribute("Nb_Commandes_A_Expedier");
		document.getElementById('oma-montantHTCommandesAExpedier').value = contenu.getAttribute("Montant_HT_Commandes_A_Expedier");
		document.getElementById('oma-nbCommandesNonValidees').value = contenu.getAttribute("Nb_Commandes_Non_Validees");
		document.getElementById('oma-montantHTCommandesNonValidees').value = contenu.getAttribute("Montant_HT_Commandes_Non_Validees");

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_initCriteres() {
	try {

		oma_modeTraitement = document.getElementById('oma-modeTraitement').value;

		document.getElementById('oma-numCommande').value = "";
		document.getElementById('oma-intituleAffaire').value = "";
		document.getElementById('oma-loginWeb').value = "";
		document.getElementById('oma-nomClient').value = "";
		document.getElementById('oma-refArticle').value = "";
		document.getElementById('oma-numFacture').value = "";
		document.getElementById('oma-numAcompte').value = "";
		document.getElementById('oma-etablissement').value = (oma_defautEtablissement=="U"?etablissementDefaut:"");
		document.getElementById('oma-depot').value = oma_defautDepot=="0"?depotDefaut:oma_defautDepot;
		document.getElementById('oma-numBL').value = "";
		document.getElementById('oma-numRetour').value = "";
		document.getElementById('oma-numAffaire').value = "";
		document.getElementById('oma-etatAffaire').value = oma_defautEtatCommande;
		document.getElementById('oma-etatCommande').value = oma_defautEtatCommande;
		document.getElementById('oma-etatLogistique').value = oma_defautEtatLogistique;
		document.getElementById('oma-bloque').selectedIndex = 0;
		document.getElementById('oma-dateCommandeDebut').value = "";
		document.getElementById('oma-dateCommandeFin').value = "";
		document.getElementById('oma-dateExpeditionDebut').value = "";
		document.getElementById('oma-dateExpeditionFin').value = "";
		document.getElementById('oma-numClient').value = "";
		document.getElementById('oma-montantTTC').value = "";
		document.getElementById('oma-etatPaiement').value = oma_defautEtatPaiement;
		document.getElementById('oma-modeReglement').selectedIndex = 0;
		document.getElementById('oma-provenance').value = oma_defautProvenance;
		document.getElementById('oma-marketplace').value = "";
		document.getElementById('oma-modeExpedition').selectedIndex = 0;
		document.getElementById('oma-poleActivite').value = oma_restrictedPoleActivite;
		document.getElementById('oma-marque').selectedIndex = 0;
		document.getElementById('oma-responsable').value = "";

		document.getElementById('oma-boxEtatAffaire').collapsed = (oma_modeTraitement=="C");
		document.getElementById('oma-filterCC').collapsed = (oma_modeTraitement=="A");
		document.getElementById('oma-boxEtatLogistique').collapsed = (oma_modeTraitement=="A");
		document.getElementById('oma-boxECommerce').collapsed = (oma_modeTraitement=="A" || !oma_existeSites);
		document.getElementById('oma-boxStats').collapsed = !oma_affStats;
		document.getElementById('oma-boxApercuCommande').collapsed = true;
		document.getElementById('oma-boxApercuAffaire').collapsed = true;

		document.getElementById('oma-listeCommandes').collapsed = (oma_modeTraitement=="A");
		document.getElementById('oma-listeAffaires').collapsed = (oma_modeTraitement=="C");
		document.getElementById('oma-bValiderCommande').collapsed = (oma_modeTraitement=="A" || (gReadOnly && !gProfil.isValidationCC()));
		document.getElementById('oma-bEditionPdf').collapsed = (oma_modeTraitement=="A");
		document.getElementById('oma-bEditionCsvArticles').collapsed = (oma_modeTraitement=="A");
		document.getElementById('oma-bLegende').collapsed = (oma_modeTraitement=="A");

		oma_listerCommandes();

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_onKeyPress(event) {
	try {
		if (event.keyCode==13) {
			oma_listerCommandes();
		}
	} catch (e) {
		recup_erreur(e);
	}
}


function oma_listerCommandes() {
	try {

		var numCommande = document.getElementById('oma-numCommande').value;
		var intituleAffaire = document.getElementById('oma-intituleAffaire').value;
		var loginWeb = document.getElementById('oma-loginWeb').value;
		var nomClient = document.getElementById('oma-nomClient').value;
		var refArticle = document.getElementById('oma-refArticle').value;
		var numFacture = document.getElementById('oma-numFacture').value;
		var numAcompte = document.getElementById('oma-numAcompte').value;
		var numBL = document.getElementById('oma-numBL').value;
		var numRetour = document.getElementById('oma-numRetour').value;
		var numAffaire = document.getElementById('oma-numAffaire').value;
		var etatAffaire = document.getElementById('oma-etatAffaire').value;
		var etatCommande = document.getElementById('oma-etatCommande').value;
		var etatLogistique = document.getElementById('oma-etatLogistique').value;
		var commandeBloquee = document.getElementById('oma-bloque').value;
		var dateCommandeDebut = document.getElementById('oma-dateCommandeDebut').value;
		var dateCommandeFin = document.getElementById('oma-dateCommandeFin').value;
		var dateExpeditionDebut = document.getElementById('oma-dateExpeditionDebut').value;
		var dateExpeditionFin = document.getElementById('oma-dateExpeditionFin').value;
		var numClient = document.getElementById('oma-numClient').value;
		var montantTTC = document.getElementById('oma-montantTTC').value;
		var etatPaiement = document.getElementById('oma-etatPaiement').value;
		var modeReglement = document.getElementById('oma-modeReglement').value;
		var provenance = document.getElementById('oma-provenance').value;
		var marketplace = document.getElementById('oma-marketplace').value;
		var modeExpedition = document.getElementById('oma-modeExpedition').value;
		var poleActivite = document.getElementById('oma-poleActivite').value;
		var marque = document.getElementById('oma-marque').value;
		var etablissement = document.getElementById('oma-etablissement').value;
		var depot = document.getElementById('oma-depot').value;
		var responsable = document.getElementById('oma-responsable').value;
		var nbLignesParPage = document.getElementById('oma-nbLignesParPage').value;

		if (!isEmpty(montantTTC) && !isPositiveOrNull(montantTTC)) { showWarning("Le montant TTC est incorrect !"); }
		else if (!isEmpty(dateCommandeDebut) && !isDateTime(dateCommandeDebut)) { showWarning("Date de d\u00E9but de p\u00E9riode incorrecte pour la commande !"); }
		else if (!isEmpty(dateCommandeFin) && !isDateTime(dateCommandeFin)) { showWarning("Date de fin de p\u00E9riode incorrecte pour la commande !"); }
		else if (!isEmpty(dateCommandeDebut) && !isEmpty(dateCommandeFin) && !isDateTimeInterval(dateCommandeDebut, dateCommandeFin)) { showWarning("Plage de dates incorrecte pour la commande !"); }
		else if (!isEmpty(dateExpeditionDebut) && !isDate(dateExpeditionDebut)) { showWarning("Date d'exp\u00E9dition pr\u00E9vue de d\u00E9but de p\u00E9riode incorrecte"); }
		else if (!isEmpty(dateExpeditionFin) && !isDate(dateExpeditionFin)) { showWarning("Date d'exp\u00E9dition pr\u00E9vue de fin de p\u00E9riode incorrecte"); }
		else if (!isEmpty(dateExpeditionDebut) && !isEmpty(dateExpeditionFin) && !isDateInterval(dateExpeditionDebut, dateExpeditionFin)) { showWarning("Plage de dates d'exp\u00E9dition pr\u00E9vue incorrecte"); }
		else {
			document.getElementById('oma-boxStats').collapsed = !oma_affStats;
			document.getElementById('oma-boxApercuCommande').collapsed = true;
			document.getElementById('oma-boxApercuAffaire').collapsed = true;
			document.getElementById('oma-totalApercuCommande').value = "";
			document.getElementById('oma-montantMargeApercuCommande').value = "";
			document.getElementById('oma-tauxMarqueApercuCommande').value = "";
			document.getElementById('oma-tauxMargeApercuCommande').value = "";
			document.getElementById('oma-lblMargeApercuCommande').setAttribute("style", "color:black");
			document.getElementById('oma-montantMargeApercuCommande').setAttribute("style", "color:black");
			document.getElementById('oma-lblTauxMarqueApercuCommande').setAttribute("style", "color:black");
			document.getElementById('oma-lblTauxMargeApercuCommande').setAttribute("style", "color:black");
			document.getElementById('oma-tauxMarqueApercuCommande').setAttribute("style", "color:black");
			document.getElementById('oma-tauxMargeApercuCommande').setAttribute("style", "color:black");
			document.getElementById('oma-pictoMargeNegativeCommande').collapsed = true;
			document.getElementById('oma-totalApercuAffaire').value = "";
			document.getElementById('oma-montantMargeApercuAffaire').value = "";
			document.getElementById('oma-tauxMarqueApercuAffaire').value = "";
			document.getElementById('oma-tauxMargeApercuAffaire').value = "";
			document.getElementById('oma-lblMargeApercuAffaire').setAttribute("style", "color:black");
			document.getElementById('oma-montantMargeApercuAffaire').setAttribute("style", "color:black");
			document.getElementById('oma-lblTauxMarqueApercuAffaire').setAttribute("style", "color:black");
			document.getElementById('oma-lblTauxMargeApercuAffaire').setAttribute("style", "color:black");
			document.getElementById('oma-tauxMarqueApercuAffaire').setAttribute("style", "color:black");
			document.getElementById('oma-tauxMargeApercuAffaire').setAttribute("style", "color:black");
			document.getElementById('oma-pictoMargeNegativeAffaire').collapsed = true;

			document.getElementById('oma-listeCommandes').disabled = true;
			document.getElementById('oma-listeAffaires').disabled = true;
			document.getElementById('oma-bEditionCsv').disabled = true;
			document.getElementById('oma-bEditionCsvArticles').disabled = true;
			document.getElementById('oma-bEditionPdf').disabled = true;

			document.getElementById('oma-numCommandeSelect').value = "";
			document.getElementById('oma-numAffaireSelect').value = "";
			oma_aApercuCommande.deleteTree();
			oma_aApercuAffaire.deleteTree();
			oma_aListeCommandes.deleteTree();
			oma_aListeAffaires.deleteTree();

			oma_pageCourante = 1;
			oma_nbPages = 1;
			document.getElementById('oma-pageDeb').value = 1;
			document.getElementById('oma-pageFin').value = 1;
			document.getElementById('oma-bPrec').disabled = true;
			document.getElementById('oma-bSuiv').disabled = true;
			document.getElementById('oma-totalHT').value = "";
			document.getElementById('oma-totalTTC').value = "";
			document.getElementById('oma-totalCALivre').value = "";
			document.getElementById('oma-totalCARestant').value = "";

			if (oma_modeTraitement=="C") {

				document.getElementById('oma-boxEtatLogistique').collapsed = (etatCommande!="T" && !(etatCommande=="C" && !oma_hidPretExpedier));
				document.getElementById('oma-etatAffaire').value = oma_defautEtatCommande;
				document.getElementById('oma-bValiderCommande').disabled = true;

				oma_qListCC.setParam("Num_Commande", numCommande);
				oma_qListCC.setParam("Login_Web", loginWeb);
				oma_qListCC.setParam("Nom_Client", nomClient);
				oma_qListCC.setParam("Ref_Article", refArticle);
				oma_qListCC.setParam("Num_Facture", numFacture);
				oma_qListCC.setParam("Num_Acompte", numAcompte);
				oma_qListCC.setParam("Num_BL", numBL);
				oma_qListCC.setParam("Num_Retour", numRetour);
				oma_qListCC.setParam("Etat_Commande", etatCommande);
				oma_qListCC.setParam("Etat_Logistique", etatLogistique);
				oma_qListCC.setParam("Commande_Bloquee", commandeBloquee);
				oma_qListCC.setParam("Date_Commande_Debut", dateCommandeDebut);
				oma_qListCC.setParam("Date_Commande_Fin", dateCommandeFin);
				oma_qListCC.setParam("Date_Expedition_Debut", dateExpeditionDebut);
				oma_qListCC.setParam("Date_Expedition_Fin", dateExpeditionFin);
				oma_qListCC.setParam("Num_Client", numClient);
				oma_qListCC.setParam("Montant_TTC", montantTTC);
				oma_qListCC.setParam("Etat_Paiement", etatPaiement);
				oma_qListCC.setParam("Mode_Reglement", modeReglement);
				oma_qListCC.setParam("Provenance", provenance);
				oma_qListCC.setParam("Marketplace", marketplace);
				oma_qListCC.setParam("Mode_Expedition", modeExpedition);
				oma_qListCC.setParam("Pole_Activite", poleActivite);
				oma_qListCC.setParam("Marque", marque);
				oma_qListCC.setParam("Etab_Id", etablissement);
				oma_qListCC.setParam("Depot_Id", depot);
				oma_qListCC.setParam("Intitule_Affaire", intituleAffaire);
				oma_qListCC.setParam("Num_Affaire", numAffaire);
				oma_qListCC.setParam("Responsable", responsable);
				oma_qListCC.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
				oma_qListCC.setParam("Current_Page", oma_pageCourante);

				var result = oma_qListCC.execute();

				var contenu = result.responseXML.documentElement;

				document.getElementById('oma-totalHT').value = contenu.getAttribute("Total_HT");
				document.getElementById('oma-totalTTC').value = contenu.getAttribute("Total_TTC");
				document.getElementById('oma-totalCALivre').value = contenu.getAttribute("Total_CA_Livre");
				document.getElementById('oma-totalCARestant').value = contenu.getAttribute("Total_CA_Restant");
				oma_nbPages = contenu.getAttribute("Nb_Pages");
				var listCommandeId = contenu.getAttribute("List_Commande_Id");

				oma_aListeCommandes.setParam("List_Commande_Id", listCommandeId);
				oma_aListeCommandes.setParam("Depot_Id", depot);
				oma_aListeCommandes.initTree(oma_initPagination);
			}
			else {

				oma_qListAFF.setParam("Num_Commande", numCommande);
				oma_qListAFF.setParam("Intitule_Affaire", intituleAffaire);
				oma_qListAFF.setParam("Login_Web", loginWeb);
				oma_qListAFF.setParam("Nom_Client", nomClient);
				oma_qListAFF.setParam("Ref_Article", refArticle);
				oma_qListAFF.setParam("Num_Facture", numFacture);
				oma_qListAFF.setParam("Num_Acompte", numAcompte);
				oma_qListAFF.setParam("Num_BL", numBL);
				oma_qListAFF.setParam("Num_Retour", numRetour);
				oma_qListAFF.setParam("Num_Affaire", numAffaire);
				oma_qListAFF.setParam("Etat_Affaire", etatAffaire);
				oma_qListAFF.setParam("Date_Commande_Debut", dateCommandeDebut);
				oma_qListAFF.setParam("Date_Commande_Fin", dateCommandeFin);
				oma_qListAFF.setParam("Date_Expedition_Debut", dateExpeditionDebut);
				oma_qListAFF.setParam("Date_Expedition_Fin", dateExpeditionFin);
				oma_qListAFF.setParam("Num_Client", numClient);
				oma_qListAFF.setParam("Etab_Id", etablissement);
				oma_qListAFF.setParam("Depot_Id", depot);
				oma_qListAFF.setParam("Responsable", responsable);
				oma_qListAFF.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
				oma_qListAFF.setParam("Current_Page", oma_pageCourante);

				var result = oma_qListAFF.execute();

				var contenu = result.responseXML.documentElement;

				document.getElementById('oma-totalHT').value = contenu.getAttribute("Total_HT");
				document.getElementById('oma-totalTTC').value = contenu.getAttribute("Total_TTC");
				document.getElementById('oma-totalCALivre').value = contenu.getAttribute("Total_CA_Livre");
				document.getElementById('oma-totalCARestant').value = contenu.getAttribute("Total_CA_Restant");
				oma_nbPages = contenu.getAttribute("Nb_Pages");
				var listAffaireId = contenu.getAttribute("List_Affaire_Id");

				oma_aListeAffaires.setParam("List_Affaire_Id", listAffaireId);
				oma_aListeAffaires.initTree(oma_initPagination);

				document.getElementById('oma-etatCommande').value = oma_defautEtatCommande;
				document.getElementById('oma-boxEtatLogistique').collapsed = true;
				document.getElementById('oma-etatLogistique').value = oma_defautEtatLogistique;
				document.getElementById('oma-bloque').selectedIndex = 0;
				document.getElementById('oma-montantTTC').value = "";
				document.getElementById('oma-etatPaiement').value = oma_defautEtatPaiement;
				document.getElementById('oma-modeReglement').selectedIndex = 0;
				document.getElementById('oma-provenance').value = oma_defautProvenance;
				document.getElementById('oma-marketplace').value = "";
				document.getElementById('oma-modeExpedition').selectedIndex = 0;
				document.getElementById('oma-poleActivite').selectedIndex = 0;
				document.getElementById('oma-marque').selectedIndex = 0;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_initPagination() {
	try {

		document.getElementById('oma-pageDeb').value = oma_pageCourante;
		document.getElementById('oma-pageFin').value = (oma_nbPages>0?oma_nbPages:1);
		document.getElementById('oma-bPrec').disabled = (oma_pageCourante==1);
		document.getElementById('oma-bSuiv').disabled = (oma_pageCourante>=oma_nbPages); // peut se produire si oma_nbPages=0

		oma_afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_pressOnPagePrec() {
	try {

		oma_pageCourante--;
		oma_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_pressOnPageSuiv() {
	try {

		oma_pageCourante++;
		oma_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_majPagination() {
	try {

		document.getElementById('oma-pageDeb').value = oma_pageCourante;
		document.getElementById('oma-bPrec').disabled = (oma_pageCourante==1);
		document.getElementById('oma-bSuiv').disabled = (oma_pageCourante==oma_nbPages);

		document.getElementById('oma-boxStats').collapsed = !oma_affStats;
		document.getElementById('oma-boxApercuCommande').collapsed = true;
		document.getElementById('oma-boxApercuAffaire').collapsed = true;
		document.getElementById('oma-totalApercuCommande').value = "";
		document.getElementById('oma-montantMargeApercuCommande').value = "";
		document.getElementById('oma-tauxMarqueApercuCommande').value = "";
		document.getElementById('oma-tauxMargeApercuCommande').value = "";
		document.getElementById('oma-lblMargeApercuCommande').setAttribute("style", "color:black");
		document.getElementById('oma-montantMargeApercuCommande').setAttribute("style", "color:black");
		document.getElementById('oma-lblTauxMarqueApercuCommande').setAttribute("style", "color:black");
		document.getElementById('oma-lblTauxMargeApercuCommande').setAttribute("style", "color:black");
		document.getElementById('oma-tauxMarqueApercuCommande').setAttribute("style", "color:black");
		document.getElementById('oma-tauxMargeApercuCommande').setAttribute("style", "color:black");
		document.getElementById('oma-pictoMargeNegativeCommande').collapsed = true;
		document.getElementById('oma-totalApercuAffaire').value = "";
		document.getElementById('oma-montantMargeApercuAffaire').value = "";
		document.getElementById('oma-tauxMarqueApercuAffaire').value = "";
		document.getElementById('oma-tauxMargeApercuAffaire').value = "";
		document.getElementById('oma-lblMargeApercuAffaire').setAttribute("style", "color:black");
		document.getElementById('oma-montantMargeApercuAffaire').setAttribute("style", "color:black");
		document.getElementById('oma-lblTauxMarqueApercuAffaire').setAttribute("style", "color:black");
		document.getElementById('oma-lblTauxMargeApercuAffaire').setAttribute("style", "color:black");
		document.getElementById('oma-tauxMarqueApercuAffaire').setAttribute("style", "color:black");
		document.getElementById('oma-tauxMargeApercuAffaire').setAttribute("style", "color:black");
		document.getElementById('oma-pictoMargeNegativeAffaire').collapsed = true;

		document.getElementById('oma-numCommandeSelect').value = "";
		document.getElementById('oma-numAffaireSelect').value = "";

		document.getElementById('oma-listeCommandes').disabled = true;
		document.getElementById('oma-listeAffaires').disabled = true;
		document.getElementById('oma-bEditionCsv').disabled = true;
		document.getElementById('oma-bEditionCsvArticles').disabled = true;
		document.getElementById('oma-bEditionPdf').disabled = true;

		oma_aApercuCommande.deleteTree();
		oma_aApercuAffaire.deleteTree();

		if (oma_modeTraitement=="C") {
			document.getElementById('oma-bValiderCommande').disabled = true;

			oma_qListCC.setParam("Current_Page", oma_pageCourante);
			var result = oma_qListCC.execute();
			var listCommandeId = result.responseXML.documentElement.getAttribute("List_Commande_Id");

			oma_aListeCommandes.setParam("List_Commande_Id", listCommandeId);
			oma_aListeCommandes.initTree(oma_afterMajPagination);
		}
		else {
			oma_qListAFF.setParam("Current_Page", oma_pageCourante);
			var result = oma_qListAFF.execute();
			var listAffaireId = result.responseXML.documentElement.getAttribute("List_Affaire_Id");

			oma_aListeAffaires.setParam("List_Affaire_Id", listAffaireId);
			oma_aListeAffaires.initTree(oma_afterMajPagination);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_afterMajPagination() {
	try {

		document.getElementById('oma-listeCommandes').disabled = false;
		document.getElementById('oma-listeAffaires').disabled = false;
		document.getElementById('oma-bEditionCsv').disabled = ((oma_modeTraitement=="C" && oma_aListeCommandes.nbLignes()==0) || (oma_modeTraitement=="A" && oma_aListeAffaires.nbLignes()==0));
		document.getElementById('oma-bEditionCsvArticles').disabled = ((oma_modeTraitement=="C" && oma_aListeCommandes.nbLignes()==0) || oma_modeTraitement=="A");
		document.getElementById('oma-bEditionPdf').disabled = ((oma_modeTraitement=="C" && oma_aListeCommandes.nbLignes()==0) || oma_modeTraitement=="A");

		if (oma_modeTraitement=="C") {
			if (oma_currentIndex!=-1 && oma_currentIndex<oma_aListeCommandes.nbLignes() && (oec_commandeId==oma_aListeCommandes.getCellText(oma_currentIndex, "oma-lcColCommandeId") || ofa_affaireId==oma_aListeCommandes.getCellText(oma_currentIndex, "oma-lcColAffaireId"))) {
				oma_aListeCommandes.ensureRowIsVisible(oma_currentIndex);
				oma_aListeCommandes.select(oma_currentIndex);
				oma_currentIndex = -1;
			}
		}
		else {
			if (oma_currentIndex!=-1 && oma_currentIndex<oma_aListeAffaires.nbLignes() && ofa_affaireId==oma_aListeAffaires.getCellText(oma_currentIndex, "oma-laColAffaireId")) {
				oma_aListeAffaires.ensureRowIsVisible(oma_currentIndex);
				oma_aListeAffaires.select(oma_currentIndex);
				oma_currentIndex = -1;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_selectOnListeCommandes() {
	try {

		if (oma_aListeCommandes.isSelected()) {
			var i = oma_aListeCommandes.getCurrentIndex();
			var commandeId = oma_aListeCommandes.getCellText(i, "oma-lcColCommandeId");
			var etatCommande = oma_aListeCommandes.getCellText(i, "oma-lcColCodeEtat");
			document.getElementById('oma-numCommandeSelect').value = "Aper\u00E7u de la commande N\u00B0 "+ oma_aListeCommandes.getCellText(i, "oma-lcColNumCommande") +" :";
			oma_aApercuCommande.setParam("Commande_Id", commandeId);
			oma_aApercuCommande.initTree();
			document.getElementById('oma-bValiderCommande').disabled = (etatCommande!="N");

			document.getElementById('oma-totalApercuCommande').value = oma_aListeCommandes.getCellText(i, "oma-lcColMontantHT") +" \u20AC";
			var editionTTC = (oma_aListeCommandes.getCellText(i, "oma-lcColEditionTTC")=="1");

			var qGetStats = new QueryHttp("Facturation/Affaires/getRecapitulatifCC.tmpl");
			qGetStats.setParam("Commande_Id", commandeId);
			qGetStats.setParam("Full_Mode", false);
			var result = qGetStats.execute();
			document.getElementById('oma-montantMargeApercuCommande').value = result.responseXML.documentElement.getAttribute("Marge_HT") +" \u20AC";
			document.getElementById('oma-tauxMarqueApercuCommande').value = result.responseXML.documentElement.getAttribute("Taux_Marque") +" %";
			document.getElementById('oma-tauxMargeApercuCommande').value = result.responseXML.documentElement.getAttribute("Taux_Marge") +" %";
			var margeNegative = (result.responseXML.documentElement.getAttribute("Marge_Negative")=="true");
			document.getElementById('oma-lblMargeApercuCommande').setAttribute("style", margeNegative?"color:red":"color:black");
			document.getElementById('oma-montantMargeApercuCommande').setAttribute("style", margeNegative?"color:red":"color:black");
			document.getElementById('oma-lblTauxMarqueApercuCommande').setAttribute("style", margeNegative?"color:red":"color:black");
			document.getElementById('oma-lblTauxMargeApercuCommande').setAttribute("style", margeNegative?"color:red":"color:black");
			document.getElementById('oma-tauxMarqueApercuCommande').setAttribute("style", margeNegative?"color:red":"color:black");
			document.getElementById('oma-tauxMargeApercuCommande').setAttribute("style", margeNegative?"color:red":"color:black");
			document.getElementById('oma-pictoMargeNegativeCommande').collapsed = !margeNegative;
			document.getElementById('oma-acColMontant').setAttribute("label", editionTTC?"Montant TTC":"Montant HT");

			document.getElementById('oma-boxStats').collapsed = true;
			document.getElementById('oma-boxApercuCommande').collapsed = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_pressOnListeCommandes() {
	try {

		if (oma_aListeCommandes.isSelected()) {
			oma_currentIndex = oma_aListeCommandes.getCurrentIndex();
			var etatCommande = oma_aListeCommandes.getSelectedCellText("oma-lcColCodeEtat");

			if (etatCommande!="T") {
				oec_commandeId = oma_aListeCommandes.getSelectedCellText("oma-lcColCommandeId");
				oec_chargerCommande();
				document.getElementById("bRetourAffaire").collapsed = false;
				document.getElementById("deck").selectedIndex = 2;
			}
			else {
				ofa_affaireId = oma_aListeCommandes.getSelectedCellText("oma-lcColAffaireId");
				ofa_chargerAffaire();
				document.getElementById("deck").selectedIndex = 1;
			}
			document.getElementById("bMenuAffaires").collapsed = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_selectOnListeAffaires() {
	try {

		if (oma_aListeAffaires.isSelected()) {
			var i = oma_aListeAffaires.getCurrentIndex();
			var affaireId = oma_aListeAffaires.getCellText(i, "oma-laColAffaireId");
			document.getElementById('oma-numAffaireSelect').value = "Aper\u00E7u de l'affaire N\u00B0 "+ oma_aListeAffaires.getCellText(i, "oma-laColNumAffaire") +" :";
			oma_aApercuAffaire.setParam("Affaire_Id", affaireId);
			oma_aApercuAffaire.initTree();

			document.getElementById('oma-totalApercuAffaire').value = oma_aListeAffaires.getCellText(i, "oma-laColMontantHT") +" \u20AC";

			var qGetStats = new QueryHttp("Facturation/Affaires/getRecapitulatifAFF.tmpl");
			qGetStats.setParam("Affaire_Id", affaireId);
			var result = qGetStats.execute();
			document.getElementById('oma-montantMargeApercuAffaire').value = result.responseXML.documentElement.getAttribute("Marge_HT") +" \u20AC";
			document.getElementById('oma-tauxMarqueApercuAffaire').value = result.responseXML.documentElement.getAttribute("Taux_Marque") +" %";
			document.getElementById('oma-tauxMargeApercuAffaire').value = result.responseXML.documentElement.getAttribute("Taux_Marge") +" %";
			var margeNegative = (result.responseXML.documentElement.getAttribute("Marge_Negative")=="true");
			document.getElementById('oma-lblMargeApercuAffaire').setAttribute("style", margeNegative?"color:red":"color:black");
			document.getElementById('oma-montantMargeApercuAffaire').setAttribute("style", margeNegative?"color:red":"color:black");
			document.getElementById('oma-lblTauxMarqueApercuAffaire').setAttribute("style", margeNegative?"color:red":"color:black");
			document.getElementById('oma-lblTauxMargeApercuAffaire').setAttribute("style", margeNegative?"color:red":"color:black");
			document.getElementById('oma-tauxMarqueApercuAffaire').setAttribute("style", margeNegative?"color:red":"color:black");
			document.getElementById('oma-tauxMargeApercuAffaire').setAttribute("style", margeNegative?"color:red":"color:black");
			document.getElementById('oma-pictoMargeNegativeAffaire').collapsed = !margeNegative;

			document.getElementById('oma-boxStats').collapsed = true;
			document.getElementById('oma-boxApercuAffaire').collapsed = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_pressOnListeAffaires() {
	try {

		if (oma_aListeAffaires.isSelected()) {
			oma_currentIndex = oma_aListeAffaires.getCurrentIndex();
			ofa_affaireId = oma_aListeAffaires.getSelectedCellText("oma-laColAffaireId");
			ofa_chargerAffaire();
			document.getElementById("bMenuAffaires").collapsed = false;
			document.getElementById("deck").selectedIndex = 1;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_pressOnValiderCommande() {
	try {

		if (oma_aListeCommandes.isSelected()) {
			var i = oma_aListeCommandes.getCurrentIndex();
			var comId = oma_aListeCommandes.getCellText(i, "oma-lcColCommandeId");

			var ok = true;

			if (oma_alerteEncoursClient) {
				var qEncours = new QueryHttp("Facturation/Affaires/getDepassementEncoursClient.tmpl");
				qEncours.setParam("Commande_Id", comId);
				var result = qEncours.execute();

				var depassement = parseFloat(result.responseXML.documentElement.getAttribute("Depassement"));
				if (depassement>0) {
					ok = window.confirm("L'encours autoris\u00E9 du client est d\u00E9pass\u00E9, voulez-vous continuer ?");
				}
			}

			if (ok && window.confirm("Voulez-vous valider la commande s\u00E9lectionn\u00E9e ?")) {
				var qValiderCommande = new QueryHttp("Facturation/Affaires/validerCommande.tmpl");
				qValiderCommande.setParam("Commande_Id", comId);
				var result = qValiderCommande.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					oma_initStats();
					oma_listerCommandes();
				}
			}
		}
		else {
			showWarning("Veuillez s\u00E9lectionner une commande !");
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_pressOnEditionCsv() {
	try {

		var numCommande = document.getElementById('oma-numCommande').value;
		var intituleAffaire = document.getElementById('oma-intituleAffaire').value;
		var loginWeb = document.getElementById('oma-loginWeb').value;
		var nomClient = document.getElementById('oma-nomClient').value;
		var refArticle = document.getElementById('oma-refArticle').value;
		var numFacture = document.getElementById('oma-numFacture').value;
		var numAcompte = document.getElementById('oma-numAcompte').value;
		var numBL = document.getElementById('oma-numBL').value;
		var numRetour = document.getElementById('oma-numRetour').value;
		var numAffaire = document.getElementById('oma-numAffaire').value;
		var etatAffaire = document.getElementById('oma-etatAffaire').value;
		var etatCommande = document.getElementById('oma-etatCommande').value;
		var etatLogistique = document.getElementById('oma-etatLogistique').value;
		var commandeBloquee = document.getElementById('oma-bloque').value;
		var dateCommandeDebut = document.getElementById('oma-dateCommandeDebut').value;
		var dateCommandeFin = document.getElementById('oma-dateCommandeFin').value;
		var dateExpeditionDebut = document.getElementById('oma-dateExpeditionDebut').value;
		var dateExpeditionFin = document.getElementById('oma-dateExpeditionFin').value;
		var numClient = document.getElementById('oma-numClient').value;
		var montantTTC = document.getElementById('oma-montantTTC').value;
		var etatPaiement = document.getElementById('oma-etatPaiement').value;
		var modeReglement = document.getElementById('oma-modeReglement').value;
		var provenance = document.getElementById('oma-provenance').value;
		var marketplace = document.getElementById('oma-marketplace').value;
		var modeExpedition = document.getElementById('oma-modeExpedition').value;
		var poleActivite = document.getElementById('oma-poleActivite').value;
		var marque = document.getElementById('oma-marque').value;
		var etablissement = document.getElementById('oma-etablissement').value;
		var depot = document.getElementById('oma-depot').value;
		var responsable = document.getElementById('oma-responsable').value;

		if (!isEmpty(montantTTC) && isNaN(montantTTC)) { showWarning("Le montant TTC est incorrect !"); }
		else if (!isEmpty(dateCommandeDebut) && !isDateTime(dateCommandeDebut)) { showWarning("Date de d\u00E9but de p\u00E9riode incorrecte pour la commande !"); }
		else if (!isEmpty(dateCommandeFin) && !isDateTime(dateCommandeFin)) { showWarning("Date de fin de p\u00E9riode incorrecte pour la commande !"); }
		else if (!isEmpty(dateCommandeDebut) && !isEmpty(dateCommandeFin) && !isDateTimeInterval(dateCommandeDebut, dateCommandeFin)) { showWarning("Plage de dates incorrecte pour la commande !"); }
		else if (!isEmpty(dateExpeditionDebut) && !isDate(dateExpeditionDebut)) { showWarning("Date d'exp\u00E9dition pr\u00E9vue de d\u00E9but de p\u00E9riode incorrecte"); }
		else if (!isEmpty(dateExpeditionFin) && !isDate(dateExpeditionFin)) { showWarning("Date d'exp\u00E9dition pr\u00E9vue de fin de p\u00E9riode incorrecte"); }
		else if (!isEmpty(dateExpeditionDebut) && !isEmpty(dateExpeditionFin) && !isDateInterval(dateExpeditionDebut, dateExpeditionFin)) { showWarning("Plage de dates d'exp\u00E9dition pr\u00E9vue incorrecte"); }
		else {

			var qEditionCsv;

			if (oma_modeTraitement=="C") {
				qEditionCsv = new QueryHttp("Facturation/Affaires/csvCommandeClient.tmpl");
				qEditionCsv.setParam("Num_Commande", numCommande);
				qEditionCsv.setParam("Login_Web", loginWeb);
				qEditionCsv.setParam("Nom_Client", nomClient);
				qEditionCsv.setParam("Ref_Article", refArticle);
				qEditionCsv.setParam("Num_Facture", numFacture);
				qEditionCsv.setParam("Num_Acompte", numAcompte);
				qEditionCsv.setParam("Num_BL", numBL);
				qEditionCsv.setParam("Num_Retour", numRetour);
				qEditionCsv.setParam("Etat_Commande", etatCommande);
				qEditionCsv.setParam("Etat_Logistique", etatLogistique);
				qEditionCsv.setParam("Commande_Bloquee", commandeBloquee);
				qEditionCsv.setParam("Date_Commande_Debut", dateCommandeDebut);
				qEditionCsv.setParam("Date_Commande_Fin", dateCommandeFin);
				qEditionCsv.setParam("Date_Expedition_Debut", dateExpeditionDebut);
				qEditionCsv.setParam("Date_Expedition_Fin", dateExpeditionFin);
				qEditionCsv.setParam("Num_Client", numClient);
				qEditionCsv.setParam("Montant_TTC", montantTTC);
				qEditionCsv.setParam("Etat_Paiement", etatPaiement);
				qEditionCsv.setParam("Mode_Reglement", modeReglement);
				qEditionCsv.setParam("Provenance", provenance);
				qEditionCsv.setParam("Marketplace", marketplace);
				qEditionCsv.setParam("Mode_Expedition", modeExpedition);
				qEditionCsv.setParam("Pole_Activite", poleActivite);
				qEditionCsv.setParam("Marque", marque);
				qEditionCsv.setParam("Etab_Id", etablissement);
				qEditionCsv.setParam("Depot_Id", depot);
				qEditionCsv.setParam("Intitule_Affaire", intituleAffaire);
				qEditionCsv.setParam("Num_Affaire", numAffaire);
				qEditionCsv.setParam("Responsable", responsable);
			}
			else {
				qEditionCsv = new QueryHttp("Facturation/Affaires/csvAffaire.tmpl");
				qEditionCsv.setParam("Num_Commande", numCommande);
				qEditionCsv.setParam("Intitule_Affaire", intituleAffaire);
				qEditionCsv.setParam("Login_Web", loginWeb);
				qEditionCsv.setParam("Nom_Client", nomClient);
				qEditionCsv.setParam("Ref_Article", refArticle);
				qEditionCsv.setParam("Num_Facture", numFacture);
				qEditionCsv.setParam("Num_Acompte", numAcompte);
				qEditionCsv.setParam("Num_BL", numBL);
				qEditionCsv.setParam("Num_Retour", numRetour);
				qEditionCsv.setParam("Num_Affaire", numAffaire);
				qEditionCsv.setParam("Etat_Affaire", etatAffaire);
				qEditionCsv.setParam("Date_Commande_Debut", dateCommandeDebut);
				qEditionCsv.setParam("Date_Commande_Fin", dateCommandeFin);
				qEditionCsv.setParam("Date_Expedition_Debut", dateExpeditionDebut);
				qEditionCsv.setParam("Date_Expedition_Fin", dateExpeditionFin);
				qEditionCsv.setParam("Num_Client", numClient);
				qEditionCsv.setParam("Etab_Id", etablissement);
				qEditionCsv.setParam("Depot_Id", depot);
				qEditionCsv.setParam("Responsable", responsable);
			}

			var result = qEditionCsv.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');
				var file = fileChooser("save", fichier);
				if (file!=null) {
					downloadFile(getDirBuffer()+ fichier, file);
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_pressOnEditionCsvArticles() {
	try {

		var numCommande = document.getElementById('oma-numCommande').value;
		var intituleAffaire = document.getElementById('oma-intituleAffaire').value;
		var loginWeb = document.getElementById('oma-loginWeb').value;
		var nomClient = document.getElementById('oma-nomClient').value;
		var refArticle = document.getElementById('oma-refArticle').value;
		var numFacture = document.getElementById('oma-numFacture').value;
		var numAcompte = document.getElementById('oma-numAcompte').value;
		var numBL = document.getElementById('oma-numBL').value;
		var numRetour = document.getElementById('oma-numRetour').value;
		var numAffaire = document.getElementById('oma-numAffaire').value;
		var etatAffaire = document.getElementById('oma-etatAffaire').value;
		var etatCommande = document.getElementById('oma-etatCommande').value;
		var etatLogistique = document.getElementById('oma-etatLogistique').value;
		var commandeBloquee = document.getElementById('oma-bloque').value;
		var dateCommandeDebut = document.getElementById('oma-dateCommandeDebut').value;
		var dateCommandeFin = document.getElementById('oma-dateCommandeFin').value;
		var dateExpeditionDebut = document.getElementById('oma-dateExpeditionDebut').value;
		var dateExpeditionFin = document.getElementById('oma-dateExpeditionFin').value;
		var numClient = document.getElementById('oma-numClient').value;
		var montantTTC = document.getElementById('oma-montantTTC').value;
		var etatPaiement = document.getElementById('oma-etatPaiement').value;
		var modeReglement = document.getElementById('oma-modeReglement').value;
		var provenance = document.getElementById('oma-provenance').value;
		var marketplace = document.getElementById('oma-marketplace').value;
		var modeExpedition = document.getElementById('oma-modeExpedition').value;
		var poleActivite = document.getElementById('oma-poleActivite').value;
		var marque = document.getElementById('oma-marque').value;
		var etablissement = document.getElementById('oma-etablissement').value;
		var depot = document.getElementById('oma-depot').value;
		var responsable = document.getElementById('oma-responsable').value;

		if (!isEmpty(montantTTC) && isNaN(montantTTC)) { showWarning("Le montant TTC est incorrect !"); }
		else if (!isEmpty(dateCommandeDebut) && !isDateTime(dateCommandeDebut)) { showWarning("Date de d\u00E9but de p\u00E9riode incorrecte pour la commande !"); }
		else if (!isEmpty(dateCommandeFin) && !isDateTime(dateCommandeFin)) { showWarning("Date de fin de p\u00E9riode incorrecte pour la commande !"); }
		else if (!isEmpty(dateCommandeDebut) && !isEmpty(dateCommandeFin) && !isDateTimeInterval(dateCommandeDebut, dateCommandeFin)) { showWarning("Plage de dates incorrecte pour la commande !"); }
		else if (!isEmpty(dateExpeditionDebut) && !isDate(dateExpeditionDebut)) { showWarning("Date d'exp\u00E9dition pr\u00E9vue de d\u00E9but de p\u00E9riode incorrecte"); }
		else if (!isEmpty(dateExpeditionFin) && !isDate(dateExpeditionFin)) { showWarning("Date d'exp\u00E9dition pr\u00E9vue de fin de p\u00E9riode incorrecte"); }
		else if (!isEmpty(dateExpeditionDebut) && !isEmpty(dateExpeditionFin) && !isDateInterval(dateExpeditionDebut, dateExpeditionFin)) { showWarning("Plage de dates d'exp\u00E9dition pr\u00E9vue incorrecte"); }
		else {

			var qEditionCsv;

			if (oma_modeTraitement=="C") {
				qEditionCsv = new QueryHttp("Facturation/Affaires/csvDetailCommandeClient.tmpl");
				qEditionCsv.setParam("Num_Commande", numCommande);
				qEditionCsv.setParam("Login_Web", loginWeb);
				qEditionCsv.setParam("Nom_Client", nomClient);
				qEditionCsv.setParam("Ref_Article", refArticle);
				qEditionCsv.setParam("Num_Facture", numFacture);
				qEditionCsv.setParam("Num_Acompte", numAcompte);
				qEditionCsv.setParam("Num_BL", numBL);
				qEditionCsv.setParam("Num_Retour", numRetour);
				qEditionCsv.setParam("Etat_Commande", etatCommande);
				qEditionCsv.setParam("Etat_Logistique", etatLogistique);
				qEditionCsv.setParam("Commande_Bloquee", commandeBloquee);
				qEditionCsv.setParam("Date_Commande_Debut", dateCommandeDebut);
				qEditionCsv.setParam("Date_Commande_Fin", dateCommandeFin);
				qEditionCsv.setParam("Date_Expedition_Debut", dateExpeditionDebut);
				qEditionCsv.setParam("Date_Expedition_Fin", dateExpeditionFin);
				qEditionCsv.setParam("Num_Client", numClient);
				qEditionCsv.setParam("Montant_TTC", montantTTC);
				qEditionCsv.setParam("Etat_Paiement", etatPaiement);
				qEditionCsv.setParam("Mode_Reglement", modeReglement);
				qEditionCsv.setParam("Provenance", provenance);
				qEditionCsv.setParam("Marketplace", marketplace);
				qEditionCsv.setParam("Mode_Expedition", modeExpedition);
				qEditionCsv.setParam("Pole_Activite", poleActivite);
				qEditionCsv.setParam("Marque", marque);
				qEditionCsv.setParam("Etab_Id", etablissement);
				qEditionCsv.setParam("Depot_Id", depot);
				qEditionCsv.setParam("Intitule_Affaire", intituleAffaire);
				qEditionCsv.setParam("Num_Affaire", numAffaire);
				qEditionCsv.setParam("Responsable", responsable);

				var result = qEditionCsv.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');
					var file = fileChooser("save", fichier);
					if (file!=null) {
						downloadFile(getDirBuffer()+ fichier, file);
					}
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}



function oma_pressOnEditionPdf() {
	try {

		var numCommande = document.getElementById('oma-numCommande').value;
		var intituleAffaire = document.getElementById('oma-intituleAffaire').value;
		var loginWeb = document.getElementById('oma-loginWeb').value;
		var nomClient = document.getElementById('oma-nomClient').value;
		var refArticle = document.getElementById('oma-refArticle').value;
		var numFacture = document.getElementById('oma-numFacture').value;
		var numAcompte = document.getElementById('oma-numAcompte').value;
		var numBL = document.getElementById('oma-numBL').value;
		var numRetour = document.getElementById('oma-numRetour').value;
		var numAffaire = document.getElementById('oma-numAffaire').value;
		var etatAffaire = document.getElementById('oma-etatAffaire').value;
		var etatCommande = document.getElementById('oma-etatCommande').value;
		var etatLogistique = document.getElementById('oma-etatLogistique').value;
		var commandeBloquee = document.getElementById('oma-bloque').value;
		var dateCommandeDebut = document.getElementById('oma-dateCommandeDebut').value;
		var dateCommandeFin = document.getElementById('oma-dateCommandeFin').value;
		var dateExpeditionDebut = document.getElementById('oma-dateExpeditionDebut').value;
		var dateExpeditionFin = document.getElementById('oma-dateExpeditionFin').value;
		var numClient = document.getElementById('oma-numClient').value;
		var montantTTC = document.getElementById('oma-montantTTC').value;
		var etatPaiement = document.getElementById('oma-etatPaiement').value;
		var modeReglement = document.getElementById('oma-modeReglement').value;
		var provenance = document.getElementById('oma-provenance').value;
		var marketplace = document.getElementById('oma-marketplace').value;
		var modeExpedition = document.getElementById('oma-modeExpedition').value;
		var poleActivite = document.getElementById('oma-poleActivite').value;
		var marque = document.getElementById('oma-marque').value;
		var etablissement = document.getElementById('oma-etablissement').value;
		var depot = document.getElementById('oma-depot').value;
		var responsable = document.getElementById('oma-responsable').value;

		if (!isEmpty(montantTTC) && isNaN(montantTTC)) { showWarning("Le montant TTC est incorrect !"); }
		else if (!isEmpty(dateCommandeDebut) && !isDateTime(dateCommandeDebut)) { showWarning("Date de d\u00E9but de p\u00E9riode incorrecte pour la commande !"); }
		else if (!isEmpty(dateCommandeFin) && !isDateTime(dateCommandeFin)) { showWarning("Date de fin de p\u00E9riode incorrecte pour la commande !"); }
		else if (!isEmpty(dateCommandeDebut) && !isEmpty(dateCommandeFin) && !isDateTimeInterval(dateCommandeDebut, dateCommandeFin)) { showWarning("Plage de dates incorrecte pour la commande !"); }
		else if (!isEmpty(dateExpeditionDebut) && !isDate(dateExpeditionDebut)) { showWarning("Date d'exp\u00E9dition pr\u00E9vue de d\u00E9but de p\u00E9riode incorrecte"); }
		else if (!isEmpty(dateExpeditionFin) && !isDate(dateExpeditionFin)) { showWarning("Date d'exp\u00E9dition pr\u00E9vue de fin de p\u00E9riode incorrecte"); }
		else if (!isEmpty(dateExpeditionDebut) && !isEmpty(dateExpeditionFin) && !isDateInterval(dateExpeditionDebut, dateExpeditionFin)) { showWarning("Plage de dates d'exp\u00E9dition pr\u00E9vue incorrecte"); }
		else {

			document.getElementById('oma-pdf').setAttribute("src", "");
			document.getElementById("bMenuAffaires").collapsed = false;
			document.getElementById("oma-deckMenuAffaires").selectedIndex = 1;
			document.getElementById('oma-pmbox').collapsed = false;
			document.getElementById('oma-pm').setAttribute('mode', 'undetermined');

			var qEditionPdf = new QueryHttp("Facturation/Affaires/genEditionCommandes.tmpl");

			qEditionPdf.setParam("Num_Commande", numCommande);
			qEditionPdf.setParam("Login_Web", loginWeb);
			qEditionPdf.setParam("Nom_Client", nomClient);
			qEditionPdf.setParam("Ref_Article", refArticle);
			qEditionPdf.setParam("Num_Facture", numFacture);
			qEditionPdf.setParam("Num_Acompte", numAcompte);
			qEditionPdf.setParam("Num_BL", numBL);
			qEditionPdf.setParam("Num_Retour", numRetour);
			qEditionPdf.setParam("Etat_Commande", etatCommande);
			qEditionPdf.setParam("Etat_Logistique", etatLogistique);
			qEditionPdf.setParam("Commande_Bloquee", commandeBloquee);
			qEditionPdf.setParam("Date_Commande_Debut", dateCommandeDebut);
			qEditionPdf.setParam("Date_Commande_Fin", dateCommandeFin);
			qEditionPdf.setParam("Date_Expedition_Debut", dateExpeditionDebut);
			qEditionPdf.setParam("Date_Expedition_Fin", dateExpeditionFin);
			qEditionPdf.setParam("Num_Client", numClient);
			qEditionPdf.setParam("Montant_TTC", montantTTC);
			qEditionPdf.setParam("Etat_Paiement", etatPaiement);
			qEditionPdf.setParam("Mode_Reglement", modeReglement);
			qEditionPdf.setParam("Provenance", provenance);
			qEditionPdf.setParam("Marketplace", marketplace);
			qEditionPdf.setParam("Mode_Expedition", modeExpedition);
			qEditionPdf.setParam("Pole_Activite", poleActivite);
			qEditionPdf.setParam("Marque", marque);
			qEditionPdf.setParam("Etab_Id", etablissement);
			qEditionPdf.setParam("Depot_Id", depot);
			qEditionPdf.setParam("Intitule_Affaire", intituleAffaire);
			qEditionPdf.setParam("Num_Affaire", numAffaire);
			qEditionPdf.setParam("Responsable", responsable);

			var result = qEditionPdf.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				document.getElementById("bMenuAffaires").collapsed = true;
				document.getElementById("oma-deckMenuAffaires").selectedIndex = 0;
				errors.show();
			}
			else {
				var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
				document.getElementById('oma-pdf').setAttribute("src", page);
			}

			document.getElementById('oma-pm').setAttribute('mode', 'none');
			document.getElementById('oma-pmbox').collapsed = true;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ouvrirLegende() {
  try {

		window.openDialog("chrome://opensi/content/facturation/user/affaires/popup-legende.xul",'','chrome,modal,centerscreen');

	} catch (e) {
    recup_erreur(e);
  }
}


function oma_rechercherClient() {
	try {

		var url = "chrome://opensi/content/facturation/user/clients/popup-rechercheClient.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', oma_retourRechercherClient);

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_retourRechercherClient(numClient) {
	try {

  	document.getElementById('oma-numClient').value = numClient;
  	oma_listerCommandes();

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_rechercherArticle() {
	try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', oma_retourRechercherArticle);

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_retourRechercherArticle(reference, articleId) {
	try {

		var fieldRefArticle = document.getElementById('oma-refArticle');
		if (fieldRefArticle.value.startsWith("*") || fieldRefArticle.value.startsWith("/")) {
  		fieldRefArticle.value += "+"+ reference;
		}
		else {
			fieldRefArticle.value = reference;
		}
  	oma_listerCommandes();

	} catch (e) {
		recup_erreur(e);
	}
}


function oma_pressOnEtatCommande() {
	try {

		var etatCommande = document.getElementById("oma-etatCommande").value;
		var cloture = etatCommande=="C";

		document.getElementById("oma-etatLogistique").value = etatCommande!="T"?"":oma_defautEtatLogistique;

		document.getElementById("oma-miATraiter").setAttribute("hidden", cloture);
		document.getElementById("oma-miExpedier").setAttribute("hidden", cloture || oma_hidExpedier);
		document.getElementById("oma-miReassort").setAttribute("hidden", cloture || oma_hidReassort);
		document.getElementById("oma-miRupture").setAttribute("hidden", cloture || oma_hidRupture);
		document.getElementById("oma-miDirectFournisseur").setAttribute("hidden", cloture);
		document.getElementById("oma-miDirectFournisseurPossible").setAttribute("hidden", cloture);
		document.getElementById("oma-miPreparation").setAttribute("hidden", cloture || oma_hidPreparation);
		document.getElementById("oma-miPartExpe").setAttribute("hidden", cloture);
		document.getElementById("oma-miExpedie").setAttribute("hidden", cloture);

	} catch (e) {
		recup_erreur(e);
	}
}
