/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");


var typeDoc;
var documentId;
var clientId;
var denomination;
var selModeReglement;
var montantMax;



function init() {
  try {

		typeDoc = window.arguments[0];
		documentId = window.arguments[1];
		clientId = window.arguments[2];
		denomination = (isEmpty(clientId)?window.arguments[3]:"");

		var qInit = new QueryHttp("Facturation/Affaires/getInitRemboursementClient.tmpl");
		qInit.setParam("Document_Id", documentId);
		qInit.setParam("Type_Doc", typeDoc);
		var result = qInit.execute();

		var contenu = result.responseXML.documentElement;

		selModeReglement = contenu.getAttribute("Mode_Reg_Id");
		montantMax = contenu.getAttribute("Montant_Max");

		document.getElementById('dateRemboursement').value = getDateCourante();
		document.getElementById('montant').value = montantMax;

		var aBanques = new Arbre('ComboListe/combo-banques.tmpl', 'banqueRetrait');
		aBanques.initTree(initBanqueRetrait);

		var aModesReglement = new Arbre('ComboListe/combo-modesReglement.tmpl', 'modeReglement');
		aModesReglement.setParam("Selection", selModeReglement);
		aModesReglement.initTree(initModeReglement);

		var aMotifs = new Arbre('ComboListe/combo-motifsRemboursement.tmpl', 'motif');
		aMotifs.setParam("Type_Tiers", "C");
		aMotifs.initTree();

  } catch (e) {
    recup_erreur(e);
  }
}


function initBanqueRetrait() {
	try {

    document.getElementById('banqueRetrait').selectedIndex = 0;

		var qBanque = new QueryHttp("Facturation/Suivi_Reglements_Clients/getBanqueRemiseDefaut.tmpl");
		qBanque.setParam("Client_Id", clientId);

		var result = qBanque.execute();
		document.getElementById('banqueRetrait').value = result.responseXML.documentElement.getAttribute("Banque_Id");

	} catch (e) {
    recup_erreur(e);
  }
}


function initModeReglement() {
	try {

    document.getElementById('modeReglement').value = selModeReglement;

	} catch (e) {
    recup_erreur(e);
  }
}


function valider() {
	try {

		var dateRemboursement = document.getElementById('dateRemboursement').value;
		var banqueRetrait = document.getElementById('banqueRetrait').value;
		var modeReglement = document.getElementById('modeReglement').value;
		var motif = document.getElementById('motif').value;
		var numPiece = document.getElementById('numPiece').value;
		var montant = document.getElementById('montant').value;
		var commentaires = document.getElementById('commentaires').value;

		if (isEmpty(dateRemboursement) || !isDate(dateRemboursement)) { showWarning("Date incorrecte"); }
		else if (isEmpty(modeReglement)) { showWarning("Veuillez choisir un mode de r\u00E8glement"); }
		else if (isEmpty(motif)) { showWarning("Veuillez choisir un motif"); }
		else if (isEmpty(montant) || !isPositive(montant)) { showWarning("Montant incorrect"); }
		else if (parseFloat(montant)>parseFloat(montantMax)) { showWarning("Le montant maximum remboursable est de "+ montantMax); }
		else if (commentaires.length>100) { showWarning("Le commentaire ne doit pas d\u00E9passer 100 caract\u00E8res"); }
		else {

			var qSave = new QueryHttp("Facturation/Suivi_Reglements_Clients/createRemboursementClient.tmpl");

			qSave.setParam("Date_Remboursement", dateRemboursement);
			qSave.setParam("Banque_Retrait", banqueRetrait);
			qSave.setParam("Client_Id", clientId);
			qSave.setParam("Denomination", denomination);
			qSave.setParam("Mode_Reglement", modeReglement);
			qSave.setParam("Motif", motif);
			qSave.setParam("Num_Piece", numPiece);
			qSave.setParam("Montant", montant);
			qSave.setParam("Commentaires", commentaires);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var remboursementId = result.responseXML.documentElement.getAttribute("Remboursement_Id");
				imputeRemboursement(remboursementId, montant);
			}

			window.close();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function imputeRemboursement(remboursementId, montant) {
	try {

		var qImpute;

		if (typeDoc=="A") {
			qImpute = new QueryHttp("Facturation/Suivi_Reglements_Clients/imputeAvoirByRemboursement.tmpl");
			qImpute.setParam("Avoir_Id", documentId);
		}
		else {
			qImpute = new QueryHttp("Facturation/Affaires/imputeReglementByRemboursement.tmpl");
			qImpute.setParam("Commande_Id", documentId);
		}
		qImpute.setParam("Remboursement_Id", remboursementId);
		qImpute.setParam("Montant_Imputation", montant);

		var result = qImpute.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}

	} catch (e) {
		recup_erreur(e);
	}
}
