/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/lib_tva.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/formatter.js");


var aCodesTVA = new Arbre('ComboListe/combo-tauxTVA.tmpl', 'codeTVA');
var aModesReglements = new Arbre('ComboListe/combo-modesReglement.tmpl', 'modeReglement');

var commandeId;
var totalTTC;
var totalAcompte;
var montantMaxAcompte;
var chargerModeReg = "";
var codePays;
var assujettiTVA;
var regimeTVA;

var nf = new NumberFormat("0.00", false);



function init() {
  try {

		commandeId = window.arguments[1];

		var qInit = new QueryHttp("Facturation/Affaires/getInitAcompteClient.tmpl");
		qInit.setParam("Commande_Id", commandeId);
		var result = qInit.execute();

		var contenu = result.responseXML.documentElement;

		document.getElementById('libelle').value = "Acompte sur commande client N\u00B0 "+ contenu.getAttribute('Num_Commande');
		totalTTC = parseFloat(contenu.getAttribute("Total_TTC"));
		totalAcompte = parseFloat(contenu.getAttribute("Acompte"));
		montantMaxAcompte = nf.format(totalTTC-totalAcompte);
		chargerModeReg = contenu.getAttribute("Mode_Reg_Id");

		document.getElementById('numeroTVA').value = contenu.getAttribute("Num_TVA_Intra");

		if (parseFloat(contenu.getAttribute("Montant"))>0) {
			document.getElementById("montantHT").value = contenu.getAttribute("Montant");
			document.getElementById("montantTTC").value = contenu.getAttribute("Montant");
		}

		codePays = contenu.getAttribute("Code_Pays_Liv");
		regimeTVA = contenu.getAttribute("Regime_TVA");
		assujettiTVA = (contenu.getAttribute("Assujetti_TVA")=="true"?"1":"0");

		aCodesTVA.setParam("Code_Pays", codePays);
    aCodesTVA.setParam("Regime_TVA", regimeTVA);
    aCodesTVA.setParam("Assujetti_TVA", assujettiTVA);
    aCodesTVA.initTree(selectTVA);

  } catch (e) {
    recup_erreur(e);
  }
}


function selectTVA() {
  try {

    document.getElementById('codeTVA').value = getCodeTvaNormal(codePays, assujettiTVA, regimeTVA);
    aModesReglements.setParam("Selection", chargerModeReg);
    aModesReglements.initTree(initModeReglement);

  } catch (e) {
    recup_erreur(e);
  }
}


function initModeReglement() {
	try {

		document.getElementById('modeReglement').value = chargerModeReg;

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnExoneration() {
	try {

		var exoneration = document.getElementById('chkExonerationTVA').checked;
		document.getElementById('codeTVA').value = (exoneration?getCodeTvaZero(codePays):getCodeTvaNormal(codePays, assujettiTVA, regimeTVA));
		calculerMontantTTC();
		document.getElementById('rowCodeTVA').collapsed = exoneration;
		document.getElementById('rowMontantTTC').collapsed = exoneration;
		document.getElementById('lblMontantHT').value = (exoneration?"* Montant :":"* Montant HT :");

	} catch (e) {
		recup_erreur(e);
	}
}


function calculerMontantHT() {
	try {

		var tauxTVA = parseFloat(document.getElementById('codeTVA').getAttribute("label"));
		var montantTTC = document.getElementById('montantTTC').value;
		if (!isEmpty(montantTTC) && !isNaN(montantTTC)) {
			var montantHT = parseFloat(montantTTC)/(1 + tauxTVA/100);
			document.getElementById('montantHT').value = nf.format(montantHT);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function calculerMontantTTC() {
	try {

		var tauxTVA = parseFloat(document.getElementById('codeTVA').getAttribute("label"));
		var montantHT = document.getElementById('montantHT').value;
		if (!isEmpty(montantHT) && !isNaN(montantHT)) {
			var montantTTC = parseFloat(montantHT)*(1 + tauxTVA/100);
			document.getElementById('montantTTC').value = nf.format(montantTTC);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function valider() {
	try {

		var codeTVA = document.getElementById('codeTVA').value;
		var montantHT = document.getElementById('montantHT').value;
		var montantTTC = document.getElementById('montantTTC').value;
		var modeReglement = document.getElementById('modeReglement').value;
		var numeroTVA = document.getElementById('numeroTVA').value;
		var libelle = document.getElementById('libelle').value;
		var commentaires = document.getElementById('commentaires').value;

		if (isEmpty(montantHT) || !isPositive(montantHT) || !checkNumber(montantHT,14,2)) { showWarning("Le montant HT est incorrect !"); }
		else if (isEmpty(montantTTC) || !isPositive(montantTTC) || !checkNumber(montantTTC,14,2)) { showWarning("Le montant TTC est incorrect !"); }
		else if (parseFloat(montantTTC)>montantMaxAcompte) { showWarning("Le montant de l'acompte ne peut pas exc\u00E9der "+ montantMaxAcompte +" !"); }
		else if (isEmpty(modeReglement)) { showWarning("Veuillez choisir un mode de r\u00E8glement !"); }
		else if (isEmpty(libelle)) { showWarning("Veuillez saisir un libell\u00E9 !"); }
		else if (window.confirm("Confirmez-vous la g\u00E9n\u00E9ration de la facture d'acompte ?")) {
	  	var qCreerAcompte = new QueryHttp("Facturation/Affaires/createAcompteClient.tmpl");
	  	qCreerAcompte.setParam("Commande_Id", commandeId);
	  	qCreerAcompte.setParam("Code_TVA", codeTVA);
	  	qCreerAcompte.setParam("Total_HT", montantHT);
	  	qCreerAcompte.setParam("Total_TTC", montantTTC);
	  	qCreerAcompte.setParam("Mode_Reg_Id", modeReglement);
			qCreerAcompte.setParam("Num_TVA_Intra", numeroTVA);
	  	qCreerAcompte.setParam("Libelle", libelle);
	  	qCreerAcompte.setParam("Commentaires_Fin", commentaires);
	  	var result = qCreerAcompte.execute();
	  	var acompteId = result.responseXML.documentElement.getAttribute("Acompte_Id");

			window.arguments[0](acompteId);
			window.close();
		}

	} catch (e) {
    recup_erreur(e);
  }
}
