/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");


var aBanquesRemise = new Arbre('ComboListe/combo-banques.tmpl', 'banqueRemise');
var aBanquesClient = new Arbre('ComboListe/combo-banquesClient.tmpl', 'banqueClient');
var aModesReglements = new Arbre('ComboListe/combo-modesReglement.tmpl', 'modeReglement');

var commandeId;
var clientId;
var denomination;
var chargerModeReg;



function init() {
  try {

		document.getElementById('dateReglement').value = getDateCourante();
		commandeId = window.arguments[1];
		clientId = window.arguments[2];
		denomination = (isEmpty(clientId)?window.arguments[3]:"");
		chargerModeReg = window.arguments[4];
		aBanquesRemise.initTree(initBanqueRemise);

  } catch (e) {
    recup_erreur(e);
  }
}


function initBanqueRemise() {
	try {

    document.getElementById('banqueRemise').selectedIndex = 0;

		var qBanque = new QueryHttp("Facturation/Suivi_Reglements_Clients/getBanqueRemiseDefaut.tmpl");
		qBanque.setParam("Client_Id", clientId);

		var result = qBanque.execute();
		document.getElementById('banqueRemise').value = result.responseXML.documentElement.getAttribute("Banque_Id");

    if (chargerModeReg!="") { aModesReglements.setParam("Selection", chargerModeReg); }
		aModesReglements.initTree(initModeReglement);

	} catch (e) {
    recup_erreur(e);
  }
}


function initModeReglement() {
	try {

    document.getElementById('modeReglement').value = chargerModeReg;
    chargerBanquesClient();

	} catch (e) {
    recup_erreur(e);
  }
}


function chargerBanquesClient() {
	try {

		if (clientId!="") {
			aBanquesClient.setParam("Client_Id", clientId);
			aBanquesClient.initTree(initBanqueClient);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function initBanqueClient() {
	try {

		document.getElementById('banqueClient').setAttribute("label", "");
		document.getElementById('banqueClient').value = "";

	} catch (e) {
		recup_erreur(e);
	}
}


function valider() {
	try {

		var dateReglement = document.getElementById('dateReglement').value;
		var echeanceRemise = document.getElementById('echeanceRemise').value;
		var banqueRemise = document.getElementById('banqueRemise').value;
		var banqueClient = document.getElementById('banqueClient').value;
		var modeReglement = document.getElementById('modeReglement').value;
		var tiersPayeur = document.getElementById('tiersPayeur').value;
		var numPiece = document.getElementById('numPiece').value;
		var montant = document.getElementById('montant').value;
		var commentaires = document.getElementById('commentaires').value;

		if (isEmpty(dateReglement) || !isDate(dateReglement)) { showWarning("Date incorrecte !"); }
		else if (!isEmpty(echeanceRemise) && !isDate(echeanceRemise)) { showWarning("Date d'\u00E9ch\u00E9ance de remise incorrecte !"); }
		else if (banqueClient.length>30) { showWarning("La banque client ne doit pas d\u00E9passer 30 caract\u00E8res !"); }
		else if (isEmpty(modeReglement)) { showWarning("Veuillez choisir un mode de r\u00E8glement !"); }
		else if (isEmpty(montant) || !isPositive(montant)) { showWarning("Montant incorrect !"); }
		else if (commentaires.length>100) { showWarning("Le commentaire ne doit pas d\u00E9passer 100 caract\u00E8res !"); }
		else {

			var qEnregistrer = new QueryHttp("Facturation/Suivi_Reglements_Clients/createReglementClient.tmpl");
			qEnregistrer.setParam("Date_Reglement", dateReglement);
			qEnregistrer.setParam("Echeance_Remise", echeanceRemise);
			qEnregistrer.setParam("Banque_Remise", banqueRemise);
			qEnregistrer.setParam("Client_Id", clientId);
			qEnregistrer.setParam("Tiers_Payeur", tiersPayeur);
			qEnregistrer.setParam("Denomination", denomination);
			qEnregistrer.setParam("Banque_Client", banqueClient);
			qEnregistrer.setParam("Mode_Reglement", modeReglement);
			qEnregistrer.setParam("Num_Piece", numPiece);
			qEnregistrer.setParam("Montant", montant);
			qEnregistrer.setParam("Commentaires", commentaires);
			qEnregistrer.setParam("Commande_Id", commandeId);

			var result = qEnregistrer.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			window.arguments[0]();
			window.close();
		}

	} catch (e) {
		recup_erreur(e);
	}
}
