/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");


var commandeId;



function init() {
  try {

		commandeId = window.arguments[0];

		document.getElementById('email').value = window.arguments[1];
		document.getElementById('montant').value = window.arguments[2].replace(" ", "");
		document.getElementById('description').value = "Paiement de votre commande N\u00B0 "+ window.arguments[3];

  } catch (e) {
    recup_erreur(e);
  }
}


function envoyerLPE() {
  try {

		var email = document.getElementById('email').value;
		var montant = document.getElementById('montant').value;
		var description = document.getElementById('description').value;

		if (isEmpty(montant) || !isPositive(montant) || !checkNumber(montant,9,2)) { showWarning("Montant incorrect"); }
		else if (isEmpty(email) || !isEmail(email)) { showWarning("Email incorrect"); }
		else if (isEmpty(description)) { showWarning("Description incorrecte"); }
		else if (window.confirm("Confirmez-vous l'envoi du lien de paiement \u00E9lectronique ?")) {

			document.getElementById('boxBoutons').collapsed = true;
			document.getElementById('pmbox').collapsed = false;
			document.getElementById('pm').setAttribute('mode', 'undetermined');

	  	var qSend = new QueryHttp("Facturation/Affaires/sendLPE.tmpl");
	  	qSend.setParam("Commande_Id", commandeId);
	  	qSend.setParam("Email", email);
	  	qSend.setParam("Montant", montant);
	  	qSend.setParam("Description", description);
	  	qSend.execute(envoyerLPE_2);
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function envoyerLPE_2(result) {
	try {

		document.getElementById('pm').setAttribute('mode', 'none');
		document.getElementById('pmbox').collapsed = true;

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			showMessage("Le lien de paiement \u00E9lectronique a \u00E9t\u00E9 envoy\u00E9");
		}

		window.close();

	} catch (e) {
    recup_erreur(e);
  }
}
