/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/formatter.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/lib_tva.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arrondi.js");


var gSiteWeb;
var gProfil;
var gConfig;
var gReadOnly;
var gAccesCoutAchat;
var gActEmplacements;
var gShowElemFour;



function init() {
  try {

  	window.parent.addEventListener("close", demandeEnregistrement, false);

		gConfig = getConfig();
		gSiteWeb = gConfig.isECommerce();
		gActEmplacements = gConfig.isActEmplacements();
		gProfil = getProfil();
		gReadOnly = gProfil.isReadOnlyGC_SArticles();
		gAccesCoutAchat = gProfil.isAccesCoutAchat();
		gShowElemFour = gProfil.isShowElemFour();

		document.getElementById('deck').selectedIndex = 0;
  	oma_init();
  	ofa_init();

		if (!isEmpty(ParamValeur('Article_Id'))) {
			ofa_articleId = ParamValeur('Article_Id');
			retourFicheArticle();
			ofa_chargerArticle();
		}

		document.getElementById('bcAccesCoutAchat').collapsed = !gAccesCoutAchat;

		document.getElementById('deck').collapsed = false;

	} catch (e) {
    recup_erreur(e);
  }
}


function desinit() {
	try {

		window.parent.removeEventListener("close", demandeEnregistrement, false);

	} catch (e) {
    recup_erreur(e);
  }
}



function demandeEnregistrement() {
	try {

		var currentDeck = parseIntBis(document.getElementById('deck').selectedIndex);

		if (currentDeck==1) {
			ofa_demandeEnregistrement();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function retourMenuArticles() {
	try {

		document.getElementById('ofa-pdfArticle').setAttribute("src", "");
		document.getElementById('ofa-pdfEtiquetteEmplacement').setAttribute("src", "");
		document.getElementById('oma-pdfEtiquettes').setAttribute("src", "");
		document.getElementById('deck').selectedIndex = 0;
		document.getElementById('oma-deckMenuArticles').selectedIndex = 0;
		document.getElementById('bMenuArticles').collapsed = true;
		document.getElementById('bRetourArticle').collapsed = true;

		document.activeElement.blur();
		oma_listerArticles();

	} catch (e) {
    recup_erreur(e);
  }
}


function retourFicheArticle() {
  try {

		document.getElementById('ofa-pdfArticle').setAttribute("src", "");
		document.getElementById('ofa-pdfEtiquetteEmplacement').setAttribute("src", "");
		document.getElementById('deck').selectedIndex = 1;
		document.getElementById('ofa-deckArticle').selectedIndex = 0;
		document.getElementById('bMenuArticles').collapsed = false;
		document.getElementById('bRetourArticle').collapsed = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function retourMenuPrincipal() {
	try {

		window.location = "chrome://opensi/content/facturation/user/menu_principal.xul";

	} catch (e) {
    recup_erreur(e);
  }
}
