/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var ofa_aFamilles1 = new Arbre('ComboListe/combo-famillesArticle.tmpl', 'ofa-famille1');
var ofa_aFamilles2 = new Arbre('ComboListe/combo-famillesArticle.tmpl', 'ofa-famille2');
var ofa_aFamilles3 = new Arbre('ComboListe/combo-famillesArticle.tmpl', 'ofa-famille3');
var ofa_aMarques = new Arbre('ComboListe/combo-marquesArticle.tmpl', 'ofa-marque');
var ofa_aTarifs = new Arbre('Facturation/Articles/list-prixQuantite.tmpl', 'ofa-tarifsQte');
var ofa_aUnitesPoids = new Arbre("ComboListe/combo-unitesVente.tmpl", "ofa-unitePoids");
var ofa_aUnitesDimensions = new Arbre("ComboListe/combo-unitesVente.tmpl", "ofa-uniteDimensions");
var ofa_aUnitesVolume = new Arbre("ComboListe/combo-unitesVente.tmpl", "ofa-uniteVolume");
var ofa_aConditionnements = new Arbre("ComboListe/combo-conditionnementsArticle.tmpl", "ofa-conditionnement");
var ofa_aComptesArticleNat = new Arbre("Facturation/Articles/list-compteArticle.tmpl", "ofa-listeComptesArticleNat");
var ofa_aComptesArticleNatUE = new Arbre("Facturation/Articles/list-compteArticleTVANationalUE.tmpl", "ofa-listeComptesArticleNatUE");
var ofa_aComptesArticleUE = new Arbre("Facturation/Articles/list-compteArticle.tmpl", "ofa-listeComptesArticleUE");
var ofa_aComptesArticleInter = new Arbre("Facturation/Articles/list-compteArticle.tmpl", "ofa-listeComptesArticleInter");
var ofa_aCartons = new Arbre("ComboListe/combo-cartons.tmpl", "ofa-carton");
var ofa_aAttributs = new Arbre("Facturation/Articles/list-attributArticle.tmpl", "ofa-listeAttributs");
var ofa_aValAttributs = new Arbre('ComboListe/combo-attributs.tmpl', 'ofa-attributId');
var ofa_aLibAttributs = new Arbre('ComboListe/combo-groupesAttribut.tmpl', 'ofa-groupeId');
var ofa_aCodesBarre = new Arbre("Facturation/Articles/list-codeBarreArticle.tmpl", "ofa-listeCodesBarre");
var ofa_aPrixArticle = new Arbre("Facturation/Articles/list-prixArticle.tmpl", "ofa-listePrixArticle");

var ofa_articleId;
var ofa_modified = false;
var ofa_mode;
var ofa_prixId;
var ofa_modeTarif;
var ofa_numerotationAuto;
var ofa_methodeColisage;
var ofa_actReassortCC;
var ofa_codeId;
var ofa_gcfCdeArtFab;
var ofa_specREOF;

var ofa_curMarque = "";
var ofa_curFamille1 = "";
var ofa_curFamille2 = "";
var ofa_curFamille3 = "";
var ofa_curAttribut = "";
var ofa_curGroupe = "";
var ofa_curUnitePoids = "";
var ofa_curUniteDimensions = "";
var ofa_curUniteVolume = "";
var ofa_curConditionnement = "";
var ofa_curCarton = "";
var ofa_curCodeTVA = "";

var ofa_defautUnitePoids;
var ofa_defautUniteDimensions;
var ofa_defautUniteVolume;
var ofa_defautUniteVente;
var ofa_defautImpNomFiche;
var ofa_defautImpNomOF;
var ofa_defautImpNomFacture;
var ofa_defautImpNomBon;
var ofa_defautImpNomBP;
var ofa_defautImpNomDevis;
var ofa_defautImpDesc1Fiche;
var ofa_defautImpDesc1OF;
var ofa_defautImpDesc1Facture;
var ofa_defautImpDesc1Bon;
var ofa_defautImpDesc1Devis;
var ofa_defautImpDesc1BP;
var ofa_defautImpDesc1BCF;
var ofa_defautImpDesc2Fiche;
var ofa_defautImpDesc2OF;
var ofa_defautImpDesc2Facture;
var ofa_defautImpDesc2Bon;
var ofa_defautImpDesc2Devis;
var ofa_defautImpDesc2BP;
var ofa_defautImpDesc2BCF;

var ofa_arrondiHT;
var ofa_arrondiTTC;



function ofa_init() {
  try {

		document.getElementById('ofa-lblReadOnly').collapsed = !gReadOnly;

		var config = getConfig();

		ofa_modeTarif = config.getModeTarif();
		ofa_defautUniteDimensions = config.getUniteDimensions();
		ofa_defautUniteVolume = config.getUniteVolume();
		ofa_defautUnitePoids = config.getUnitePoids();
		ofa_defautUniteVente = config.getUniteDefaut();
		ofa_methodeColisage = config.getMethodeColisage();
		ofa_numerotationAuto = !isEmpty(config.getFormatNA());
		ofa_actReassortCC = config.isActReassortCC();
		ofa_gcfCdeArtFab = config.isGCFCdeArtFab();
		document.getElementById('ofa-rowCodeStats').collapsed = !config.isActCodeStats();
		document.getElementById('ofa-rowRefLogistique').collapsed = isEmpty(config.getFormatNL());

		ofa_specREOF = config.isSpecREOF();
		document.getElementById('ofa-impNomOF').collapsed = !config.isSpecREOF();
		
		document.getElementById('ofa-colImgDefautCB').collapsed = !config.isSpecKECB();
		document.getElementById('ofa-defautCB').collapsed = !config.isSpecKECB();
		document.getElementById('ofa-rowConditionnement').collapsed = !config.isSpecNSCBP();

		ofa_defautImpNomFiche = config.isImpNomFiche();
		ofa_defautImpNomOF = config.isImpNomOF();
		ofa_defautImpNomFacture = config.isImpNomFacture();
		ofa_defautImpNomBon = config.isImpNomBon();
		ofa_defautImpNomBP = config.isImpNomBP();
		ofa_defautImpNomDevis = config.isImpNomDevis();
		ofa_defautImpDesc1Fiche = config.isImpDesc1Fiche();
		ofa_defautImpDesc1OF = config.isImpDesc1OF();
		ofa_defautImpDesc1Facture = config.isImpDesc1Facture();
		ofa_defautImpDesc1Bon = config.isImpDesc1Bon();
		ofa_defautImpDesc1Devis = config.isImpDesc1Devis();
		ofa_defautImpDesc1BP = config.isImpDesc1BP();
		ofa_defautImpDesc1BCF = config.isImpDesc1BCF();
		ofa_defautImpDesc2Fiche = config.isImpDesc2Fiche();
		ofa_defautImpDesc2OF = config.isImpDesc2OF();
		ofa_defautImpDesc2Facture = config.isImpDesc2Facture();
		ofa_defautImpDesc2Bon = config.isImpDesc2Bon();
		ofa_defautImpDesc2Devis = config.isImpDesc2Devis();
		ofa_defautImpDesc2BP = config.isImpDesc2BP();
		ofa_defautImpDesc2BCF = config.isImpDesc2BCF();

		if (config.isActSuiviLot()) {
			 document.getElementById('ofa-rowSuiviLot').collapsed = false;
			 document.getElementById('ofa-rowSuiviDLC').collapsed = false;
		}
		if (config.isActSuiviSerie()) {
			 document.getElementById('ofa-rowSuiviSerie').collapsed = false;
		}

		ofa_aUnitesPoids.setParam("Type_Unite", "P");
		ofa_aUnitesDimensions.setParam("Type_Unite", "L");
		ofa_aUnitesVolume.setParam("Type_Unite", "V");

		var aUnite = new Arbre("ComboListe/combo-unitesVente.tmpl", "ofa-unite");
		aUnite.initTree(ofa_initUnite);

		var aPaysOrigine = new Arbre('ComboListe/combo-pays.tmpl', 'ofa-paysOrigine');
		aPaysOrigine.initTree();

		if (ofa_modeTarif=='G') {
			document.getElementById('ofa-boxGrilleTarif').collapsed = false;
			document.getElementById('ofa-boxGrilleQte').collapsed = true;
		}
		else {
			document.getElementById('ofa-boxGrilleTarif').collapsed = true;
			document.getElementById('ofa-boxGrilleQte').collapsed = false;
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function ofa_ouvrirEditionListeMarque() {
	try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-ajouterElementListe.xul?"+ cookie() +"&Type_Element=MARQUE";
    window.openDialog(url,'','chrome,modal,centerscreen', ofa_chargerMarques);

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_chargerMarques(selection) {
	try {

		ofa_curMarque = selection;
		ofa_aMarques.setParam("Selection", ofa_curMarque);
		ofa_aMarques.initTree(ofa_initMarque);

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_initMarque() {
  try {

		document.getElementById('ofa-marque').value = ofa_curMarque;

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_ouvrirEditionListeAttribut() {
	try {

		var groupeId = document.getElementById("ofa-groupeId").value;

		if (isEmpty(groupeId)) {
			showWarning("Veuillez s\u00E9lectionner un attribut");
		}
		else {
			var url = "chrome://opensi/content/facturation/user/commun/popup-ajouterElementListe.xul?"+ cookie() +"&Type_Element=ATTRIBUT&Groupe_Id="+ groupeId +"&Intitule_Groupe="+ document.getElementById("ofa-groupeId").getAttribute("label");
    	window.openDialog(url,'','chrome,modal,centerscreen', ofa_chargerAttributs);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_ouvrirEditionListeFamille1() {
	try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-ajouterElementListe.xul?"+ cookie() +"&Type_Element=FART&Parent_Id=";
    window.openDialog(url,'','chrome,modal,centerscreen', ofa_retourEditionListeFamille1);

	} catch (e) {
		recup_erreur(e);
	}
}

function ofa_retourEditionListeFamille1(selection) {
	try {

		ofa_curFamille1 = selection;
		ofa_chargerFamilles1();

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_chargerFamilles1() {
	try {

		ofa_aFamilles1.setParam("Selection", ofa_curFamille1);
		ofa_aFamilles1.initTree(ofa_initFamille1);

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_initFamille1() {
  try {

		document.getElementById('ofa-famille1').value = ofa_curFamille1;
		if (ofa_curFamille1 != "") {
			ofa_curFamille1 = "";
			ofa_chargerFamilles2();
		}
		else {
			ofa_aFamilles2.deleteTree();
			ofa_aFamilles3.deleteTree();
			document.getElementById('ofa-famille2').value = "";
			document.getElementById('ofa-famille3').value = "";
			document.getElementById('ofa-famille2').disabled = true;
			document.getElementById('ofa-famille3').disabled = true;
			document.getElementById('ofa-bCreerFamille2').disabled = true;
			document.getElementById('ofa-bCreerFamille3').disabled = true;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_ouvrirEditionListeFamille2() {
	try {

		var parentId = document.getElementById('ofa-famille1').value;
		var url = "chrome://opensi/content/facturation/user/commun/popup-ajouterElementListe.xul?"+ cookie() +"&Type_Element=FART&Parent_Id="+ parentId;
    window.openDialog(url,'','chrome,modal,centerscreen', ofa_retourEditionListeFamille2);

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_retourEditionListeFamille2(selection) {
	try {

		ofa_curFamille2 = selection;
		ofa_chargerFamilles2();

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_chargerFamilles2() {
	try {

		var famille1 = document.getElementById('ofa-famille1').value;
		if (famille1=="") {
			document.getElementById('ofa-famille2').disabled = true;
			document.getElementById('ofa-famille3').disabled = true;
			document.getElementById('ofa-bCreerFamille2').disabled = true;
			document.getElementById('ofa-bCreerFamille3').disabled = true;
		}
		else {
			ofa_aFamilles2.setParam('Parent_Id', famille1);
			ofa_aFamilles2.setParam("Selection", ofa_curFamille2);
			ofa_aFamilles2.initTree(ofa_initFamille2);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_initFamille2() {
  try {

		document.getElementById('ofa-famille2').value = ofa_curFamille2;
		if (document.getElementById('ofa-famille1').value!="") {
			document.getElementById('ofa-famille2').disabled = false;
			document.getElementById('ofa-bCreerFamille2').disabled = false;
		}
		if (ofa_curFamille2 != "") {
			ofa_curFamille2 = "";
			ofa_chargerFamilles3();
		}
		else {
			ofa_aFamilles3.deleteTree();
			document.getElementById('ofa-famille3').value = "";
			document.getElementById('ofa-famille3').disabled = true;
			document.getElementById('ofa-bCreerFamille3').disabled = true;
			if (ofa_mode=="M") {
				ofa_nouveauAttribut();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_ouvrirEditionListeFamille3() {
	try {

		var parentId = document.getElementById('ofa-famille2').value;
		var url = "chrome://opensi/content/facturation/user/commun/popup-ajouterElementListe.xul?"+ cookie() +"&Type_Element=FART&Parent_Id="+ parentId;
    window.openDialog(url,'','chrome,modal,centerscreen', ofa_retourEditionListeFamille3);

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_retourEditionListeFamille3(selection) {
	try {

		ofa_curFamille3 = selection;
		ofa_chargerFamilles3();

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_chargerFamilles3() {
	try {

		var famille2 = document.getElementById('ofa-famille2').value;
		if (famille2=="") {
			document.getElementById('ofa-famille3').disabled = true;
			document.getElementById('ofa-bCreerFamille3').disabled = true;
		}
		else {
			ofa_aFamilles3.setParam('Parent_Id', famille2);
			ofa_aFamilles3.setParam("Selection", ofa_curFamille3);
			ofa_aFamilles3.initTree(ofa_initFamille3);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_initFamille3() {
  try {

		document.getElementById('ofa-famille3').value = ofa_curFamille3;
		if (document.getElementById('ofa-famille2').value!="") {
			document.getElementById('ofa-famille3').disabled = false;
			document.getElementById('ofa-bCreerFamille3').disabled = false;
		}
		ofa_curFamille3 = "";
		if (ofa_mode=="M") {
			ofa_nouveauAttribut();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_changeFamille3() {
  try {

		if (ofa_mode=="M") {
			ofa_nouveauAttribut();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_chargerFamilles(famille1, famille2, famille3) {
	try {

		ofa_curFamille1 = famille1;
		ofa_curFamille2 = famille2;
		ofa_curFamille3 = famille3;
		ofa_chargerFamilles1();

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_loadPhoto() {
  try {

		document.getElementById('ofa-vignette').setAttribute("src", getDirServeur() +"data/"+ gProfil.getCodeDossier() +"/photos/FA_"+ ofa_articleId +"_small.jpg?"+ nocache());

	} catch (e) {
    recup_erreur(e);
  }
}


function ofa_voirPhoto() {
  try {

		var url = "chrome://opensi/content/facturation/user/stocks/voir_photo.xul?"+ cookie();
		window.openDialog(url,'','chrome,modal,centerscreen', ofa_articleId);

	} catch (e) {
    recup_erreur(e);
  }
}


function ofa_changerPhoto() {
  try {

		var url = "chrome://opensi/content/facturation/user/stocks/change_photo.xul?"+ cookie();
		window.openDialog(url,'','chrome,modal,centerscreen', ofa_articleId);

		ofa_loadPhoto();

	} catch (e) {
    recup_erreur(e);
  }
}


function ofa_supprimerPhoto() {
  try {

		if (window.confirm("Confirmez-vous la suppression de la photo ?")) {
			var qSup = new QueryHttp("Facturation/Stocks/deletePhoto.tmpl");
			qSup.setParam("Article_Id", ofa_articleId);
			qSup.execute();

			document.getElementById('ofa-vignette').setAttribute("src", "chrome://opensi/content/design/default_vignette.jpg");
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function ofa_choixCodeNC8() {
  try {

		var url = "chrome://opensi/content/facturation/user/stocks/rech_code_nc8.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', ofa_retourChoixCodeNC8);

	} catch (e) {
    recup_erreur(e);
  }
}


function ofa_retourChoixCodeNC8(codeNC8) {
  try {

		document.getElementById('ofa-codeNC8').value = codeNC8;
		ofa_setModified(true);

	} catch (e) {
    recup_erreur(e);
  }
}


function ofa_choixCodeONU() {
  try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheCodeONU.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', ofa_retourChoixCodeONU);

	} catch (e) {
    recup_erreur(e);
  }
}


function ofa_retourChoixCodeONU(codeONU) {
  try {

		document.getElementById('ofa-codeONU').value = codeONU;
		ofa_setModified(true);

	} catch (e) {
    recup_erreur(e);
  }
}


function ofa_choixArticleSubstitution() {
  try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', ofa_retourChoixArticleSubstitution);

	} catch (e) {
    recup_erreur(e);
  }
}


function ofa_retourChoixArticleSubstitution(reference, articleId) {
  try {

		document.getElementById('ofa-articleSubstitution').value = reference;
		ofa_setModified(true);

	} catch (e) {
    recup_erreur(e);
  }
}


function ofa_enleverArticleSubstitution() {
  try {

		document.getElementById('ofa-articleSubstitution').value = "";
		ofa_setModified(true);

	} catch (e) {
    recup_erreur(e);
  }
}


function ofa_changeComposition() {
  try {

		var composition = document.getElementById('ofa-composition').value;
		document.getElementById('ofa-bcColComposition').collapsed = (composition=='U');
		document.getElementById('ofa-impNomBP').collapsed = (composition!='N');
		document.getElementById('ofa-rowOF').collapsed = composition!="N" && !ofa_specREOF;
		document.getElementById('ofa-boxFabrication').collapsed = (composition!='N');

		if (ofa_mode=='M') {
			document.getElementById('ofa-tabNomenclature').collapsed = (composition=='U');
			document.getElementById('ofa-tabStocks').collapsed = (composition=='F');
			document.getElementById('ofa-tabPotentielForfait').collapsed = (composition!='F');
			document.getElementById('ofa-tabPotentielFabrication').collapsed = (composition!='N');
			document.getElementById('ofa-tabMouvements').collapsed = (composition=='F');
			document.getElementById('ofa-tabFournisseurs').collapsed = (composition=='F' || (!ofa_gcfCdeArtFab && composition=='N') || !gShowElemFour);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function ofa_afficherFichiers() {
	try {

	  var url = "chrome://opensi/content/facturation/user/commun/popup-fichiersAssocies.xul";
  	window.openDialog(url,'','chrome,modal,centerscreen', "FART", ofa_articleId, gReadOnly);

	} catch (e) {
    recup_erreur(e);
  }
}


function ofa_updateCBSuivi() {
	try {

		var activated = document.getElementById("ofa-suiviLot").checked;
		document.getElementById("ofa-suiviDLC").disabled = (!activated);
		if (!activated) {
			document.getElementById("ofa-suiviDLC").checked = false;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function ofa_initIHM() {
	try {

		document.getElementById('ofa-panneau').selectedIndex = 0;
		ofa_hideButtons(false);

		if (ofa_mode=="M" || ofa_numerotationAuto) {
			document.getElementById('ofa-reference').setAttribute('readonly', true);
		}
		else {
			document.getElementById('ofa-reference').removeAttribute('readonly');
		}

		var composition = document.getElementById('ofa-composition').value;

		document.getElementById('ofa-tabStocks').collapsed = ofa_mode=="C" || composition=="F";
		document.getElementById('ofa-tabPotentielForfait').collapsed = ofa_mode=="C" || composition!="F";
		document.getElementById('ofa-tabPotentielFabrication').collapsed = ofa_mode=="C" || composition!="N";
		document.getElementById('ofa-tabMouvements').collapsed = ofa_mode=="C" || composition=="F";
  	document.getElementById('ofa-tabFournisseurs').collapsed = ofa_mode=="C" || composition=="F" || (!ofa_gcfCdeArtFab && composition=='N') || !gShowElemFour;
		document.getElementById('ofa-tabNomenclature').collapsed = ofa_mode=="C" || composition=="U";
		document.getElementById('ofa-tabTarifsSpecifiques').collapsed = ofa_mode=="C" || ofa_modeTarif=="Q";
		document.getElementById('ofa-tabReferencesSpecifiques').collapsed = ofa_mode=="C";
  	document.getElementById('ofa-tabWeb').collapsed = ofa_mode=="C" || !gSiteWeb;
		document.getElementById('ofa-tabStatistiques').collapsed = ofa_mode=="C";

		document.getElementById('ofa-refLogistique').collapsed = ofa_mode=="C";
		document.getElementById('ofa-reference').collapsed = ofa_mode=="C" && ofa_numerotationAuto;
		document.getElementById('ofa-bVoirPhoto').collapsed = ofa_mode=="C";
		document.getElementById('ofa-bChangerPhoto').collapsed = ofa_mode=="C" || gReadOnly;
		document.getElementById('ofa-bSupprimerPhoto').collapsed = ofa_mode=="C" || gReadOnly;
		document.getElementById('ofa-rowFichiers').collapsed = ofa_mode=="C";
		document.getElementById('ofa-lblAutoRL').collapsed = ofa_mode=="M";
		document.getElementById('ofa-lblAuto').collapsed = ofa_mode=="M" || !ofa_numerotationAuto;
		document.getElementById('ofa-bCalcComp').collapsed = ofa_mode=="C" || composition=="U";
		document.getElementById('ofa-bcColComposition').collapsed = composition=="U";
		document.getElementById('ofa-impNomBP').collapsed = composition!="N";
		document.getElementById('ofa-rowOF').collapsed = composition!="N" && !ofa_specREOF;
		document.getElementById('ofa-boxFabrication').collapsed = composition!="N";

		document.getElementById('ofa-bEnregistrer').collapsed = gReadOnly;
   	document.getElementById('ofa-bSupprimer').collapsed = ofa_mode=="C" || gReadOnly;
		document.getElementById('ofa-bEdition').collapsed = ofa_mode=="C";
		document.getElementById('ofa-bDupliquer').collapsed = ofa_mode=="C" || gReadOnly;
		document.getElementById('ofa-bHistoPrix').collapsed = ofa_mode=="C";

		document.getElementById('ofa-rowAttribut').collapsed = gReadOnly;
		document.getElementById('ofa-bEditionAttribut').disabled = ofa_mode=="C";
		document.getElementById('ofa-bNouveauAttribut').disabled = ofa_mode=="C";
		document.getElementById('ofa-bEnregistrerAttribut').disabled = ofa_mode=="C";
		document.getElementById('ofa-bSupprimerAttribut').disabled = true;
		document.getElementById('ofa-groupeId').disabled = ofa_mode=="C";
		document.getElementById('ofa-attributId').disabled = ofa_mode=="C";

		document.getElementById('ofa-rowCodeBarre').collapsed = gReadOnly;
		document.getElementById('ofa-bNouveauCB').disabled = ofa_mode=="C";
		document.getElementById('ofa-bEnregistrerCB').disabled = ofa_mode=="C";
		document.getElementById('ofa-bSupprimerCB').disabled = true;
		document.getElementById('ofa-codeBarreCB').disabled = ofa_mode=="C";
		document.getElementById('ofa-quantiteCB').disabled = ofa_mode=="C";
		document.getElementById('ofa-defautCB').disabled = ofa_mode=="C";

		document.getElementById('ofa-rowVentilationTVANat').collapsed = gReadOnly;
		document.getElementById('ofa-rowVentilationTVAUE').collapsed = gReadOnly;
		document.getElementById('ofa-rowVentilationTVANatUE').collapsed = gReadOnly;
		document.getElementById('ofa-rowVentilationTVAInter').collapsed = gReadOnly;

		document.getElementById('ofa-bCreerMarque').collapsed = gReadOnly;
		document.getElementById('ofa-bCreerFamille1').collapsed = gReadOnly;
		document.getElementById('ofa-bCreerFamille2').collapsed = gReadOnly;
		document.getElementById('ofa-bCreerFamille3').collapsed = gReadOnly;
		document.getElementById('ofa-bCreerConditionnement').collapsed = gReadOnly;

		document.getElementById('ofa-rowPrixArticle').collapsed = gReadOnly || !gProfil.isModifPrixFA();

		if (ofa_mode=="M" && !gProfil.isModifPrixFA()) {
			document.getElementById('ofa-bCalcComp').disabled = true;
			document.getElementById('ofa-prixAchat').disabled = true;
			document.getElementById('ofa-fraisAppro').disabled = true;
		}

		ofa_setModified(false);

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_nouveauArticle() {
  try {

		document.getElementById('ofa-deckArticle').selectedIndex = 0;

		ofa_mode = "C";
		ofa_articleId = "";

		// onglet fiche signaltique
		document.getElementById('ofa-lblArticle').value = "Fiche article";

		document.getElementById('ofa-reference').value = "";
		document.getElementById('ofa-refModele').value = "";
		document.getElementById('ofa-refLogistique').value = "";
    document.getElementById('ofa-designation').value = "";
		document.getElementById('ofa-famille1').value = "";
		document.getElementById('ofa-famille2').value = "";
		document.getElementById('ofa-famille3').value = "";
		document.getElementById('ofa-refFabricant').value = "";
		document.getElementById('ofa-codeBarre').value = "";
		document.getElementById('ofa-codeNC8').value = "";
		document.getElementById('ofa-codeNGP').value = "";
		document.getElementById('ofa-paysOrigine').value = "";
		document.getElementById('ofa-articleSubstitution').value = "";
		document.getElementById('ofa-nature').value = "1";
		document.getElementById('ofa-artAchat').checked = true;
		document.getElementById('ofa-artVente').checked = true;
		document.getElementById('ofa-actif').checked = true;
		document.getElementById('ofa-privLivDirecte').checked = false;
		document.getElementById('ofa-privLivDirecte').disabled = true;
		document.getElementById('ofa-lblPrivLivDirecte1').disabled = true;
		document.getElementById('ofa-lblPrivLivDirecte2').disabled = true;
		document.getElementById('ofa-prestation').checked = false;
		document.getElementById('ofa-descrip1').value = "";
		document.getElementById('ofa-descrip2').value = "";
		document.getElementById('ofa-composition').value = "U";
		document.getElementById('ofa-codeStats').value = "";
		document.getElementById('ofa-suiviSerie').checked = false;
		document.getElementById('ofa-suiviLot').checked = false;
		document.getElementById('ofa-suiviDLC').checked = false;

		ofa_aFamilles1.deleteTree();
		ofa_aFamilles2.deleteTree();
		ofa_aFamilles3.deleteTree();
		ofa_chargerFamilles("","","");
		ofa_chargerMarques("");
		ofa_chargerTVA(getCodeTvaNormalFrance());

		ofa_aAttributs.deleteTree();
		ofa_aLibAttributs.deleteTree();
		ofa_aValAttributs.deleteTree();
		document.getElementById('ofa-groupeId').value = "";
		document.getElementById('ofa-attributId').value = "";

		ofa_aCodesBarre.deleteTree();
		document.getElementById('ofa-codeBarreCB').value = "";
		document.getElementById('ofa-quantiteCB').value = "";
		document.getElementById('ofa-defautCB').checked = false;

		document.getElementById('ofa-impNomFiche').checked = ofa_defautImpNomFiche;
		document.getElementById('ofa-impNomOF').checked = ofa_defautImpNomOF;
		document.getElementById('ofa-impNomFacture').checked = ofa_defautImpNomFacture;
		document.getElementById('ofa-impNomBon').checked = ofa_defautImpNomBon;
		document.getElementById('ofa-impNomBP').checked = ofa_defautImpNomBP;
		document.getElementById('ofa-impNomDevis').checked = ofa_defautImpNomDevis;
		document.getElementById('ofa-impDesc1Fiche').checked = ofa_defautImpDesc1Fiche;
		document.getElementById('ofa-impDesc1OF').checked = ofa_defautImpDesc1OF;
		document.getElementById('ofa-impDesc1Facture').checked = ofa_defautImpDesc1Facture;
		document.getElementById('ofa-impDesc1Bon').checked = ofa_defautImpDesc1Bon;
		document.getElementById('ofa-impDesc1Devis').checked = ofa_defautImpDesc1Devis;
		document.getElementById('ofa-impDesc1BP').checked = ofa_defautImpDesc1BP;
		document.getElementById('ofa-impDesc1BCF').checked = ofa_defautImpDesc1BCF;
		document.getElementById('ofa-impDesc2Fiche').checked = ofa_defautImpDesc2Fiche;
		document.getElementById('ofa-impDesc2OF').checked = ofa_defautImpDesc2OF;
		document.getElementById('ofa-impDesc2Facture').checked = ofa_defautImpDesc2Facture;
		document.getElementById('ofa-impDesc2Bon').checked = ofa_defautImpDesc2Bon;
		document.getElementById('ofa-impDesc2Devis').checked = ofa_defautImpDesc2Devis;
		document.getElementById('ofa-impDesc2BP').checked = ofa_defautImpDesc2BP;
		document.getElementById('ofa-impDesc2BCF').checked = ofa_defautImpDesc2BCF;

		document.getElementById('ofa-vignette').setAttribute("src", "chrome://opensi/content/design/default_vignette.jpg");

		// onglet lments de gestion
    document.getElementById("ofa-unite").value = ofa_defautUniteVente;
    document.getElementById('ofa-prixAchatDer').value = "";
    document.getElementById('ofa-fraisApproDer').value = "";
    document.getElementById('ofa-prixRevientDer').value = "";
		document.getElementById('ofa-prixAchat').value = 0;
		document.getElementById('ofa-fraisAppro').value = 0;
		document.getElementById('ofa-prixRevient').value = 0;
    document.getElementById('ofa-cump').value = 0;
    document.getElementById('ofa-poidsBrut').value = 0;
    document.getElementById('ofa-poidsNet').value = 0;
		document.getElementById('ofa-qteCarton').value = 0;
		document.getElementById('ofa-carton').value = "";
		ofa_chargerCartons("");
		document.getElementById('ofa-colisageSpe').checked = false;
		ofa_chargerUnitesPoids(ofa_defautUnitePoids);
		ofa_chargerUnitesDimensions(ofa_defautUniteDimensions);
		document.getElementById('ofa-longueur').value = 0;
		document.getElementById('ofa-largeur').value = 0;
		document.getElementById('ofa-hauteur').value = 0;
		ofa_chargerUnitesVolume(ofa_defautUniteVolume);
		document.getElementById('ofa-volume').value = 0;
		ofa_chargerConditionnements("");
		document.getElementById('ofa-qteConditionnement').value = 1;
		document.getElementById('ofa-baseCalcul').checked = true;
		document.getElementById('ofa-ecoParticipation1').value = 0;
		document.getElementById('ofa-ecoParticipation2').value = 0;
		document.getElementById('ofa-typeEcoPart1').value = "N";
		document.getElementById('ofa-typeEcoPart2').value = "N";
		document.getElementById('ofa-codeEcoPart1').value = "";
		document.getElementById('ofa-codeEcoPart2').value = "";
		document.getElementById('ofa-premMiseMarche').checked = false;
		document.getElementById('ofa-prixPublic').value = 0;
		document.getElementById('ofa-prixPlancher').value = 0;
		document.getElementById('ofa-classeABC').value = "C";
		document.getElementById('ofa-prioritePicking').value = 0;
		document.getElementById('ofa-dateExpDebut').value = "";
		document.getElementById('ofa-codeONU').value = "";
		document.getElementById('ofa-codeIE').value = "";
		document.getElementById('ofa-typeEmballage').value = "";
		document.getElementById('ofa-groupeEmballage').value = "";
		document.getElementById('ofa-libelleNSA').value = "";
		document.getElementById('ofa-codeClassification').value = "";
		document.getElementById('ofa-classeADR').value = "";
		document.getElementById('ofa-codeEtiquette1').value = "";
		document.getElementById('ofa-dangerEnv').checked = false;
		document.getElementById('ofa-tempsFabrication').value = 0;
		document.getElementById('ofa-fabSerieAuto').checked = true;
		document.getElementById('ofa-exclusionEARM').collapsed = true;

		ofa_reinitialiserPrixArticle();

		ofa_aPrixArticle.deleteTree();
		ofa_aTarifs.deleteTree();
		ofa_dechargerVentilationComptable();
		ofa_annulerLigne();
		ofa_disableBoutons(true);

		document.getElementById('ofa-creation').setAttribute("label", "");
		document.getElementById('ofa-modification').setAttribute("label", "");
		document.getElementById('ofa-document').setAttribute("label", "");

		ofa_initIHM();

	} catch (e) {
  	recup_erreur(e);
  }
}


function ofa_chargerArticle(noInitIHM) {
  try {

		document.getElementById('ofa-deckArticle').selectedIndex = 0;

		ofa_mode = "M";

		var qLoad = new QueryHttp("Facturation/Articles/loadFicheArticle.tmpl");
		qLoad.setParam('Article_Id', ofa_articleId);
		var result = qLoad.execute();

		var contenu = result.responseXML.documentElement;

		// onglet fiche signaltique
		document.getElementById('ofa-lblArticle').value = "Fiche article "+ contenu.getAttribute('Reference');

		document.getElementById('ofa-reference').value = contenu.getAttribute('Reference');
		document.getElementById('ofa-refModele').value = contenu.getAttribute('Ref_Modele');
		document.getElementById('ofa-refLogistique').value = contenu.getAttribute('Ref_Logistique');
    document.getElementById('ofa-designation').value = contenu.getAttribute('Designation');
		document.getElementById('ofa-refFabricant').value = contenu.getAttribute('Ref_Fabricant');
		document.getElementById('ofa-codeBarre').value = contenu.getAttribute('Code_Barre');
    document.getElementById('ofa-codeNC8').value = contenu.getAttribute('Code_NC8');
		document.getElementById('ofa-codeNGP').value = contenu.getAttribute('Code_NGP');
		document.getElementById('ofa-paysOrigine').value = contenu.getAttribute('Pays_Origine');
    document.getElementById('ofa-articleSubstitution').value = contenu.getAttribute('Article_Substitution');
		document.getElementById('ofa-descrip1').value = contenu.getAttribute('Descrip_1');
		document.getElementById('ofa-descrip2').value = contenu.getAttribute('Descrip_2');
		document.getElementById('ofa-actif').checked = contenu.getAttribute('Actif')=="true";
		document.getElementById('ofa-artAchat').checked = contenu.getAttribute('Art_Achat')=="true";
		document.getElementById('ofa-artVente').checked = contenu.getAttribute('Art_Vente')=="true";
		document.getElementById('ofa-privLivDirecte').checked = (contenu.getAttribute('Priv_Liv_Directe')=="true");
		document.getElementById('ofa-prestation').checked = contenu.getAttribute('Prestation')=="true";
		document.getElementById('ofa-composition').value = contenu.getAttribute('Composition');
		document.getElementById('ofa-codeStats').value = contenu.getAttribute('Code_Stats');
		document.getElementById('ofa-nature').value = contenu.getAttribute('Nature');
		document.getElementById('ofa-impNomFiche').checked = (contenu.getAttribute('Imp_Nom_Fiche')=="true");
		document.getElementById('ofa-impNomOF').checked = (contenu.getAttribute('Imp_Nom_OF')=="true");
		document.getElementById('ofa-impNomFacture').checked = (contenu.getAttribute('Imp_Nom_Facture')=="true");
		document.getElementById('ofa-impNomBon').checked = (contenu.getAttribute('Imp_Nom_Bon')=="true");
		document.getElementById('ofa-impNomBP').checked = (contenu.getAttribute('Imp_Nom_BP')=="true");
		document.getElementById('ofa-impNomDevis').checked = (contenu.getAttribute('Imp_Nom_Devis')=="true");
		document.getElementById('ofa-impDesc1Fiche').checked = (contenu.getAttribute('Imp_Desc1_Fiche')=="true");
		document.getElementById('ofa-impDesc1OF').checked = (contenu.getAttribute('Imp_Desc1_OF')=="true");
		document.getElementById('ofa-impDesc1Facture').checked = (contenu.getAttribute('Imp_Desc1_Facture')=="true");
		document.getElementById('ofa-impDesc1Bon').checked = (contenu.getAttribute('Imp_Desc1_Bon')=="true");
		document.getElementById('ofa-impDesc1Devis').checked = (contenu.getAttribute('Imp_Desc1_Devis')=="true");
		document.getElementById('ofa-impDesc1BP').checked = (contenu.getAttribute('Imp_Desc1_BP')=="true");
		document.getElementById('ofa-impDesc1BCF').checked = (contenu.getAttribute('Imp_Desc1_BCF')=="true");
		document.getElementById('ofa-impDesc2Fiche').checked = (contenu.getAttribute('Imp_Desc2_Fiche')=="true");
		document.getElementById('ofa-impDesc2OF').checked = (contenu.getAttribute('Imp_Desc2_OF')=="true");
		document.getElementById('ofa-impDesc2Facture').checked = (contenu.getAttribute('Imp_Desc2_Facture')=="true");
		document.getElementById('ofa-impDesc2Bon').checked = (contenu.getAttribute('Imp_Desc2_Bon')=="true");
		document.getElementById('ofa-impDesc2Devis').checked = (contenu.getAttribute('Imp_Desc2_Devis')=="true");
		document.getElementById('ofa-impDesc2BP').checked = (contenu.getAttribute('Imp_Desc2_BP')=="true");
		document.getElementById('ofa-impDesc2BCF').checked = (contenu.getAttribute('Imp_Desc2_BCF')=="true");
		document.getElementById('ofa-suiviSerie').checked = (contenu.getAttribute('Suivi_Serie')=="true");
		document.getElementById('ofa-suiviLot').checked = (contenu.getAttribute('Suivi_Lot')=="true");
		document.getElementById('ofa-suiviDLC').checked = (contenu.getAttribute('Suivi_DLC')=="true");
		ofa_updateCBSuivi();

		ofa_chargerFamilles(contenu.getAttribute('Famille_1'),contenu.getAttribute('Famille_2'),contenu.getAttribute('Famille_3'));
		ofa_chargerMarques(contenu.getAttribute('Marque'));
		ofa_chargerTVA(contenu.getAttribute('Code_TVA'));

		ofa_aAttributs.setParam("Article_Id", ofa_articleId);
		ofa_aAttributs.initTree();

		ofa_aCodesBarre.setParam("Article_Id", ofa_articleId);
		ofa_aCodesBarre.initTree();
		ofa_nouveauCodeBarre();

		ofa_aPrixArticle.setParam("Article_Id", ofa_articleId);
		ofa_aPrixArticle.initTree();
		ofa_reinitialiserPrixArticle();

		ofa_loadPhoto();

		// onglet lments de gestion

		document.getElementById('ofa-prixAchat').value = contenu.getAttribute('Prix_Achat');
    document.getElementById('ofa-fraisAppro').value = contenu.getAttribute('Frais_Appro');
		document.getElementById('ofa-prixAchatDer').value = contenu.getAttribute('Prix_Achat_Der');
    document.getElementById('ofa-fraisApproDer').value = contenu.getAttribute('Frais_Appro_Der');
		document.getElementById('ofa-baseCalcul').checked = contenu.getAttribute('Base_Calcul')=="true";
		document.getElementById('ofa-ecoParticipation1').value = contenu.getAttribute('Eco_Participation_1');
		document.getElementById('ofa-ecoParticipation2').value = contenu.getAttribute('Eco_Participation_2');
		document.getElementById('ofa-typeEcoPart1').value = contenu.getAttribute('Type_Eco_Part_1');
		document.getElementById('ofa-typeEcoPart2').value = contenu.getAttribute('Type_Eco_Part_2');
		document.getElementById('ofa-codeEcoPart1').value = contenu.getAttribute('Code_Eco_Part_1');
		document.getElementById('ofa-codeEcoPart2').value = contenu.getAttribute('Code_Eco_Part_2');
		document.getElementById('ofa-premMiseMarche').checked = (contenu.getAttribute('Prem_Mise_Marche')=="true");
		document.getElementById('ofa-prixPublic').value = contenu.getAttribute('Prix_Public');
		document.getElementById('ofa-prixPlancher').value = contenu.getAttribute('Prix_Plancher');
		document.getElementById('ofa-classeABC').value = contenu.getAttribute('Classe_ABC');
		document.getElementById('ofa-prioritePicking').value = contenu.getAttribute('Priorite_Picking');
		document.getElementById('ofa-dateExpDebut').value = contenu.getAttribute('Date_Exp_Debut');
		document.getElementById('ofa-poidsBrut').value = contenu.getAttribute('Poids_Brut');
    document.getElementById('ofa-poidsNet').value = contenu.getAttribute('Poids_Net');
    document.getElementById('ofa-qteCarton').value = contenu.getAttribute('Qte_Carton');
		document.getElementById('ofa-unite').value = contenu.getAttribute('Unite');
		document.getElementById('ofa-longueur').value = contenu.getAttribute('Longueur');
		document.getElementById('ofa-largeur').value = contenu.getAttribute('Largeur');
		document.getElementById('ofa-hauteur').value = contenu.getAttribute('Hauteur');
		document.getElementById('ofa-volume').value = contenu.getAttribute('Volume');
		document.getElementById('ofa-qteConditionnement').value = contenu.getAttribute('Qte_Conditionnement');
		document.getElementById('ofa-colisageSpe').checked = (contenu.getAttribute('Colisage_Spe')=="true");
		document.getElementById('ofa-cump').value = contenu.getAttribute('CUMP');
    document.getElementById('ofa-codeONU').value = contenu.getAttribute('Code_ONU');
    document.getElementById('ofa-codeIE').value = contenu.getAttribute('Code_IE');
		document.getElementById('ofa-typeEmballage').value = contenu.getAttribute('Type_Emballage');
		document.getElementById('ofa-groupeEmballage').value = contenu.getAttribute('Groupe_Emballage');
		document.getElementById('ofa-libelleNSA').value = contenu.getAttribute('Libelle_NSA');
		document.getElementById('ofa-codeClassification').value = contenu.getAttribute('Code_Classification');
    document.getElementById('ofa-classeADR').value = contenu.getAttribute('Classe_ADR');
    document.getElementById('ofa-codeEtiquette1').value = contenu.getAttribute('Code_Etiquette_1');
    document.getElementById('ofa-dangerEnv').checked = contenu.getAttribute('Danger_Env')=="true";
		document.getElementById('ofa-tempsFabrication').value = contenu.getAttribute('Temps_Fabrication');
    document.getElementById('ofa-fabSerieAuto').checked = contenu.getAttribute('Fab_Serie_Auto')=="true";
	
		if (gConfig.isSpecLCARMC()) {
			document.getElementById('ofa-exclusionEARM').collapsed = contenu.getAttribute('Exclusion_EARM')=="false";
			document.getElementById('ofa-dateFinEARM').value = isEmpty(contenu.getAttribute('Date_Fin_EARM'))?"":" jusqu'au "+ contenu.getAttribute('Date_Fin_EARM');
		}

		var nfs = new NumberFormat("0.00", true);
		document.getElementById('ofa-prixRevientDer').value = isEmpty(contenu.getAttribute('Prix_Achat_Der'))?"":nfs.format(parseFloat(contenu.getAttribute('Prix_Achat_Der')) + parseFloat(contenu.getAttribute('Frais_Appro_Der')));

    document.getElementById('ofa-gridColisage').collapsed = (ofa_methodeColisage=="V" || document.getElementById('ofa-colisageSpe').checked);

		ofa_chargerCartons(contenu.getAttribute('Carton_Id'));
		ofa_chargerUnitesPoids(contenu.getAttribute('Unite_Poids'));
		ofa_chargerUnitesDimensions(contenu.getAttribute('Unite_Dimensions'));
		ofa_chargerUnitesVolume(contenu.getAttribute('Unite_Volume'));
		ofa_chargerConditionnements(contenu.getAttribute('Conditionnement_Id'));

		ofa_calculerRevient();
		ofa_changeModeTarifQte();
		ofa_disableBoutons(false);
		ofa_annulerLigne();
		ofa_chargerVentilationComptable();

		oos_initOngletStocks();
		oop_initOngletPotentielForfait();
		oob_initOngletPotentielFabrication();
		oom_initOngletMouvements();
		oow_initOngletWeb();
		oon_initOngletNomenclature();
		oof_initOngletFournisseurs();
		oot_initOngletTarifsSpecifiques();
		oor_initOngletReferencesSpecifiques();
		ooh_initOngletStatistiques();

		document.getElementById('ofa-creation').setAttribute("label", "Article cr\u00E9\u00E9 le "+ contenu.getAttribute('Date_Creation') +" par "+ contenu.getAttribute('Login_Creation'));
		document.getElementById('ofa-modification').setAttribute("label", "Derni\u00E8re modification le "+ contenu.getAttribute('Date_Maj') +" par "+ contenu.getAttribute('Login_Maj'));
		document.getElementById('ofa-document').setAttribute("label", "Article N\u00B0 "+ contenu.getAttribute('Reference') +" - "+ contenu.getAttribute('Designation'));

		if (noInitIHM==null || !noInitIHM) {
			ofa_initIHM();
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function ofa_enregistrerArticle() {
	try {

		// champs onglet fiche signaltique

		var reference = document.getElementById('ofa-reference').value;
		var refModele = document.getElementById('ofa-refModele').value;
		var refFabricant = document.getElementById('ofa-refFabricant').value;
		var designation = document.getElementById('ofa-designation').value;
		var famille1 = document.getElementById('ofa-famille1').value;
		var famille2 = document.getElementById('ofa-famille2').value;
		var famille3 = document.getElementById('ofa-famille3').value;
		var marque = document.getElementById('ofa-marque').value;
		var nature = document.getElementById('ofa-nature').value;
		var codeBarre = document.getElementById('ofa-codeBarre').value;
		var codeNC8 = document.getElementById('ofa-codeNC8').value;
		var codeNGP = document.getElementById('ofa-codeNGP').value;
		var paysOrigine = document.getElementById('ofa-paysOrigine').value;
		var articleSubstitution = document.getElementById('ofa-articleSubstitution').value;
		var descrip1 = document.getElementById('ofa-descrip1').value;
		var descrip2 = document.getElementById('ofa-descrip2').value;
		var composition = document.getElementById('ofa-composition').value;
		var codeStats = document.getElementById('ofa-codeStats').value;
		var actif = document.getElementById('ofa-actif').checked;
		var artAchat = document.getElementById('ofa-artAchat').checked;
		var artVente = document.getElementById('ofa-artVente').checked;
		var prestation = document.getElementById('ofa-prestation').checked;
		var privLivDirecte = document.getElementById('ofa-privLivDirecte').checked;
		var suiviSerie = document.getElementById('ofa-suiviSerie').checked;
		var suiviLot = document.getElementById('ofa-suiviLot').checked;
		var suiviDLC = document.getElementById('ofa-suiviDLC').checked;
		var impNomFiche = document.getElementById('ofa-impNomFiche').checked;
		var impNomOF = document.getElementById('ofa-impNomOF').checked;
		var impNomFacture = document.getElementById('ofa-impNomFacture').checked;
		var impNomBon = document.getElementById('ofa-impNomBon').checked;
		var impNomBP = document.getElementById('ofa-impNomBP').checked;
		var impNomDevis = document.getElementById('ofa-impNomDevis').checked;
		var impDesc1Fiche = document.getElementById('ofa-impDesc1Fiche').checked;
		var impDesc1OF = document.getElementById('ofa-impDesc1OF').checked;
		var impDesc1Facture = document.getElementById('ofa-impDesc1Facture').checked;
		var impDesc1Bon = document.getElementById('ofa-impDesc1Bon').checked;
		var impDesc1Devis = document.getElementById('ofa-impDesc1Devis').checked;
		var impDesc1BP = document.getElementById('ofa-impDesc1BP').checked;
		var impDesc1BCF = document.getElementById('ofa-impDesc1BCF').checked;
		var impDesc2Fiche = document.getElementById('ofa-impDesc2Fiche').checked;
		var impDesc2OF = document.getElementById('ofa-impDesc2OF').checked;
		var impDesc2Facture = document.getElementById('ofa-impDesc2Facture').checked;
		var impDesc2Bon = document.getElementById('ofa-impDesc2Bon').checked;
		var impDesc2Devis = document.getElementById('ofa-impDesc2Devis').checked;
		var impDesc2BP = document.getElementById('ofa-impDesc2BP').checked;
		var impDesc2BCF = document.getElementById('ofa-impDesc2BCF').checked;

		// champs onglet lments de gestion

		var unite = document.getElementById('ofa-unite').value;
		var prixAchat = document.getElementById('ofa-prixAchat').value;
		var fraisAppro = document.getElementById('ofa-fraisAppro').value;
    var poidsBrut = document.getElementById('ofa-poidsBrut').value;
    var poidsNet = document.getElementById('ofa-poidsNet').value;
		var qteCarton = document.getElementById('ofa-qteCarton').value;
		var carton = document.getElementById('ofa-carton').value;
		var colisageSpe = document.getElementById('ofa-colisageSpe').checked;
		var codeTVA = document.getElementById('ofa-codeTVA').value;
		var unitePoids = document.getElementById('ofa-unitePoids').value;
		var uniteDimensions = document.getElementById('ofa-uniteDimensions').value;
		var longueur = document.getElementById('ofa-longueur').value;
		var largeur = document.getElementById('ofa-largeur').value;
		var hauteur = document.getElementById('ofa-hauteur').value;
		var uniteVolume = document.getElementById('ofa-uniteVolume').value;
		var volume = document.getElementById('ofa-volume').value;
		var conditionnementId = document.getElementById('ofa-conditionnement').value;
		var qteConditionnement = document.getElementById('ofa-qteConditionnement').value;
		var baseCalcul = document.getElementById('ofa-baseCalcul').checked;
		var ecoParticipation1 = document.getElementById('ofa-ecoParticipation1').value;
		var ecoParticipation2 = document.getElementById('ofa-ecoParticipation2').value;
		var typeEcoPart1 = document.getElementById('ofa-typeEcoPart1').value;
		var typeEcoPart2 = document.getElementById('ofa-typeEcoPart2').value;
		var codeEcoPart1 = document.getElementById('ofa-codeEcoPart1').value;
		var codeEcoPart2 = document.getElementById('ofa-codeEcoPart2').value;
		var premMiseMarche = document.getElementById('ofa-premMiseMarche').checked;
		var prixPublic = document.getElementById('ofa-prixPublic').value;
		var prixPlancher = document.getElementById('ofa-prixPlancher').value;
		var classeABC = document.getElementById('ofa-classeABC').value;
		var prioritePicking = document.getElementById('ofa-prioritePicking').value;
		var dateExpDebut = document.getElementById('ofa-dateExpDebut').value;
		var codeONU = document.getElementById('ofa-codeONU').value;
		var codeIE = document.getElementById('ofa-codeIE').value;
		var typeEmballage = document.getElementById('ofa-typeEmballage').value;
		var groupeEmballage = document.getElementById('ofa-groupeEmballage').value;
		var libelleNSA = document.getElementById('ofa-libelleNSA').value;
		var codeClassification = document.getElementById('ofa-codeClassification').value;
		var classeADR = document.getElementById('ofa-classeADR').value;
		var codeEtiquette1 = document.getElementById('ofa-codeEtiquette1').value;
		var dangerEnv = document.getElementById('ofa-dangerEnv').checked;
		var tempsFabrication = document.getElementById('ofa-tempsFabrication').value;
		var fabSerieAuto = document.getElementById('ofa-fabSerieAuto').checked;

		if (ofa_mode=="C" && isEmpty(reference) && !ofa_numerotationAuto) {	showWarning("Veuillez sp\u00E9cifier une r\u00E9f\u00E9rence article (Onglet fiche signal\u00E9tique)"); }
		else if (isEmpty(designation)) { showWarning("Veuillez sp\u00E9cifier la d\u00E9signation de l'article (Onglet fiche signal\u00E9tique)"); }
		else if (isEmpty(famille1)) { showWarning("Veuillez sp\u00E9cifier la famille 1 de l'article (Onglet fiche signal\u00E9tique)"); }
		else if (famille3!="" && famille2=="") { showWarning("Veuillez sp\u00E9cifier la famille 2 de l'article (Onglet fiche signal\u00E9tique)"); }
		else if (!isEmpty(codeBarre) && !isCodeBarre(codeBarre)) { showWarning("Code barre incorrect (Onglet fiche signal\u00E9tique)"); }
		else if (!isEmpty(codeNC8) && (!isDigitList(codeNC8) || codeNC8.length<8)) { showWarning("Code douanier incorrect (Onglet fiche signal\u00E9tique)"); }
		else if (!isEmpty(codeNGP) && (!isPositive(codeNGP))) { showWarning("Code NGP incorrect (valeur de 1 \u00E0 9) (Onglet fiche signal\u00E9tique)"); }
		else if (!isEmpty(codeONU) && (!isDigitList(codeONU) || codeONU.length!=4)) { showWarning("Code ONU incorrect (Onglet fiche signal\u00E9tique)"); }
		else if (!isEmpty(codeIE) && (!isDigitList(codeIE) || codeIE.length!=3)) { showWarning("Code IE incorrect (Onglet fiche signal\u00E9tique)"); }
		else if (!isEmpty(reference) && articleSubstitution==reference) { showWarning("Article de substitution incorrect (Onglet fiche signal\u00E9tique)"); }
		else if (isEmpty(qteCarton)) { showWarning("Veuillez sp\u00E9cifier le colisage (Onglet \u00E9l\u00E9ments de gestion)"); }
		else if (!isPositiveOrNull(qteCarton)) { showWarning("Colisage incorrect (Onglet \u00E9l\u00E9ments de gestion)"); }
		else if (!isPositiveOrNull(ecoParticipation1) || !checkNumber(ecoParticipation1,10,4)) { showWarning("Montant d'eco-participation principal incorrect (Onglet \u00E9l\u00E9ments de gestion)"); }
		else if (!isPositiveOrNull(ecoParticipation2) || !checkNumber(ecoParticipation2,10,4)) { showWarning("Montant d'eco-participation secondaire incorrect (Onglet \u00E9l\u00E9ments de gestion)"); }
		else if (!isPositiveOrNull(poidsBrut)) { showWarning("Poids brut incorrect (Onglet \u00E9l\u00E9ments de gestion)"); }
		else if (!isPositiveOrNull(poidsNet)) { showWarning("Poids net incorrect (Onglet \u00E9l\u00E9ments de gestion)"); }
		else if (isEmpty(unitePoids)) { showWarning("Veuillez s\u00E9lectionner une unit\u00E9 de poids (Onglet \u00E9l\u00E9ments de gestion)"); }
		else if (isEmpty(uniteDimensions)) { showWarning("Veuillez s\u00E9lectionner une unit\u00E9 de dimensions (Onglet \u00E9l\u00E9ments de gestion)"); }
		else if (isEmpty(longueur) || !isPositiveOrNull(longueur) || !checkNumber(longueur,7,3)) { showWarning("La longueur est incorrecte (Onglet \u00E9l\u00E9ments de gestion)"); }
		else if (isEmpty(largeur) || !isPositiveOrNull(largeur) || !checkNumber(largeur,7,3)) { showWarning("La largeur est incorrecte (Onglet \u00E9l\u00E9ments de gestion)"); }
		else if (isEmpty(hauteur) || !isPositiveOrNull(hauteur) || !checkNumber(hauteur,7,3)) { showWarning("La hauteur est incorrecte (Onglet \u00E9l\u00E9ments de gestion)"); }
		else if (isEmpty(uniteVolume)) { showWarning("Veuillez s\u00E9lectionner une unit\u00E9 de volume (Onglet \u00E9l\u00E9ments de gestion)"); }
		else if (isEmpty(volume) || !isPositiveOrNull(volume) || !checkNumber(volume,9,3)) { showWarning("Le volume est incorrect (Onglet \u00E9l\u00E9ments de gestion)"); }
		else if (isEmpty(qteConditionnement) || !isPositive(qteConditionnement) || !checkNumber(qteConditionnement,10,3)) { showWarning("La quantit\u00E9 du conditionnement est incorrecte (Onglet \u00E9l\u00E9ments de gestion)"); }
		else if (!isPositiveOrNull(prixAchat) || !checkNumber(prixAchat,14,4)) { showWarning("Prix d'achat incorrect (Onglet \u00E9l\u00E9ments de gestion)"); }
		else if (!isPositiveOrNull(fraisAppro) || !checkDecimal(fraisAppro,4)) { showWarning("Frais d'appro. incorrects (Onglet \u00E9l\u00E9ments de gestion)"); }
		else if (!isPositiveOrNull(prixPublic) || !checkDecimal(prixPublic,2)) { showWarning("Prix public HT incorrect (Onglet \u00E9l\u00E9ments de gestion)"); }
		else if (!isPositiveOrNull(prixPlancher) || !checkNumber(prixPlancher,14,4)) { showWarning("Prix de vente plancher HT incorrect (Onglet \u00E9l\u00E9ments de gestion)"); }
		else if (typeEcoPart1!="N" && parseFloat(ecoParticipation1)==0) { showWarning("Montant d'eco-participation principale incorrect (Onglet \u00E9l\u00E9ments de gestion)"); }
		else if ((parseFloat(ecoParticipation2)>0 || typeEcoPart2!="N") && parseFloat(ecoParticipation1)==0) { showWarning("Eco-participation secondaire non autoris\u00E9e sans eco-participation principale (Onglet \u00E9l\u00E9ments de gestion)"); }
		else if (typeEcoPart2!="N" && parseFloat(ecoParticipation2)==0) { showWarning("Montant d'eco-participation secondaire incorrect (Onglet \u00E9l\u00E9ments de gestion)"); }
		else if (parseFloat(ecoParticipation2)>0 && typeEcoPart2=="N") { showWarning("Type d'eco-participation secondaire incorrect (Onglet \u00E9l\u00E9ments de gestion)"); }
		else if (typeEcoPart1==typeEcoPart2 && parseFloat(ecoParticipation2)>0) { showWarning("Le type de l'eco-participation secondaire doit \u00EAtre diff\u00E9rent de la principale (Onglet \u00E9l\u00E9ments de gestion)"); }
		else if (parseFloat(ecoParticipation2)>0 && typeEcoPart1=="N") { showWarning("Type d'eco-participation principale incorrect (Onglet \u00E9l\u00E9ments de gestion)"); }
		else if (!isEmpty(dateExpDebut) && !isDate(dateExpDebut)) { showWarning("Date d'exp\u00E9dition possible incorrecte (Onglet \u00E9l\u00E9ments de gestion)"); }
		else if (!isPositiveOrNull(tempsFabrication) || !checkNumber(tempsFabrication,6,2)) { showWarning("Temps de fabrication incorrect"); }
		else {

			var continuer = true;
			var qCheckRefModele = new QueryHttp("Facturation/Stocks/checkRefModele.tmpl");
			qCheckRefModele.setParam("Ref_Modele", refModele);

			var result = qCheckRefModele.execute();
			if (result.responseXML.documentElement.getAttribute("existeRefModele")=="false") {
				continuer = window.confirm("La r\u00E9f\u00E9rence mod\u00E8le saisie est nouvelle. Voulez-vous continuer ?");
			}
			if (ofa_mode=="M" && composition=="U" && oon_aComposants.nbLignes()>0) {
				continuer = window.confirm("L'article est de type simple, les composants vont \u00EAtre supprim\u00E9s. Voulez-vous continuer ?");
			}
			else if (ofa_mode=="M" && composition!="U" && oof_aFournisseurs.nbLignes()>0) {
				continuer = window.confirm("L'article est de type forfait ou fabriqu\u00E9, les liaison fournisseurs vont \u00EAtre supprim\u00E9es. Voulez-vous continuer ?");
			}
			if (continuer) {

				var qSave;

				if (ofa_mode=="C") {
					qSave = new QueryHttp("Facturation/Articles/createFicheArticle.tmpl");
				}
				else {
					qSave = new QueryHttp("Facturation/Articles/updateFicheArticle.tmpl");
					qSave.setParam("Article_Id", ofa_articleId);
				}

				if (ofa_mode=="M" || !ofa_numerotationAuto) {
					qSave.setParam('Reference', reference);
				}
				qSave.setParam('Ref_Modele', refModele);
				qSave.setParam('Ref_Fabricant', refFabricant);
				qSave.setParam('Designation', designation);
				qSave.setParam('Famille_1', famille1);
				qSave.setParam('Famille_2', famille2);
				qSave.setParam('Famille_3', famille3);
				qSave.setParam('Marque', marque);
				qSave.setParam('Nature', nature);
				qSave.setParam('Code_Barre', codeBarre);
				qSave.setParam('Code_NC8', codeNC8);
				qSave.setParam('Code_NGP', codeNGP);
				qSave.setParam('Pays_Origine', paysOrigine);
				qSave.setParam('Article_Substitution', articleSubstitution);
				qSave.setParam('Descrip_1', descrip1);
				qSave.setParam('Descrip_2', descrip2);
				qSave.setParam('Composition', composition);
				qSave.setParam('Code_Stats', codeStats);
				qSave.setParam('Actif', actif);
				qSave.setParam('Art_Achat', artAchat);
				qSave.setParam('Art_Vente', artVente);
				qSave.setParam('Prestation', prestation);
				qSave.setParam('Priv_Liv_Directe', privLivDirecte);
				qSave.setParam('Suivi_Serie', suiviSerie);
				qSave.setParam('Suivi_Lot', suiviLot);
				qSave.setParam('Suivi_DLC', suiviDLC);
				qSave.setParam('Imp_Nom_Fiche', impNomFiche);
				qSave.setParam('Imp_Nom_OF', impNomOF);
				qSave.setParam('Imp_Nom_Facture', impNomFacture);
				qSave.setParam('Imp_Nom_Bon', impNomBon);
				qSave.setParam('Imp_Nom_BP', impNomBP);
				qSave.setParam('Imp_Nom_Devis', impNomDevis);
				qSave.setParam('Imp_Desc1_Fiche', impDesc1Fiche);
				qSave.setParam('Imp_Desc1_OF', impDesc1OF);
				qSave.setParam('Imp_Desc1_Facture', impDesc1Facture);
				qSave.setParam('Imp_Desc1_Bon', impDesc1Bon);
				qSave.setParam('Imp_Desc1_Devis', impDesc1Devis);
				qSave.setParam('Imp_Desc1_BP', impDesc1BP);
				qSave.setParam('Imp_Desc1_BCF', impDesc1BCF);
				qSave.setParam('Imp_Desc2_Fiche', impDesc2Fiche);
				qSave.setParam('Imp_Desc2_OF', impDesc2OF);
				qSave.setParam('Imp_Desc2_Facture', impDesc2Facture);
				qSave.setParam('Imp_Desc2_Bon', impDesc2Bon);
				qSave.setParam('Imp_Desc2_Devis', impDesc2Devis);
				qSave.setParam('Imp_Desc2_BP', impDesc2BP);
				qSave.setParam('Imp_Desc2_BCF', impDesc2BCF);

				qSave.setParam('Unite', unite);
				qSave.setParam('Poids_Brut', poidsBrut);
				qSave.setParam('Poids_Net', poidsNet);
				qSave.setParam('Qte_Carton', qteCarton);
				qSave.setParam('Code_TVA', codeTVA);
				qSave.setParam('Frais_Appro', fraisAppro);
				qSave.setParam('Prix_Achat', prixAchat);
				qSave.setParam('Unite_Poids', unitePoids);
				qSave.setParam('Unite_Dimensions', uniteDimensions);
				qSave.setParam('Longueur', longueur);
				qSave.setParam('Largeur', largeur);
				qSave.setParam('Hauteur', hauteur);
				qSave.setParam('Unite_Volume', uniteVolume);
				qSave.setParam('Volume', volume);
				qSave.setParam('Conditionnement_Id', conditionnementId);
				qSave.setParam('Qte_Conditionnement', qteConditionnement);
				qSave.setParam('Base_Calcul', baseCalcul);
				qSave.setParam('Eco_Participation_1', ecoParticipation1);
				qSave.setParam('Eco_Participation_2', ecoParticipation2);
				qSave.setParam('Type_Eco_Part_1', typeEcoPart1);
				qSave.setParam('Type_Eco_Part_2', typeEcoPart2);
				qSave.setParam('Code_Eco_Part_1', codeEcoPart1);
				qSave.setParam('Code_Eco_Part_2', codeEcoPart2);
				qSave.setParam('Prem_Mise_Marche', premMiseMarche);
				qSave.setParam('Prix_Public', prixPublic);
				qSave.setParam('Prix_Plancher', prixPlancher);
				qSave.setParam('Carton_Id', carton);
				qSave.setParam('Colisage_Spe', colisageSpe);
				qSave.setParam('Classe_ABC', classeABC);
				qSave.setParam('Priorite_Picking', prioritePicking);
				qSave.setParam('Date_Exp_Debut', dateExpDebut);
				qSave.setParam('Code_ONU', codeONU);
				qSave.setParam('Code_IE', codeIE);
				qSave.setParam('Type_Emballage', typeEmballage);
				qSave.setParam('Groupe_Emballage', groupeEmballage);
				qSave.setParam('Libelle_NSA', libelleNSA);
				qSave.setParam('Code_Classification', codeClassification);
				qSave.setParam('Classe_ADR', classeADR);
				qSave.setParam('Code_Etiquette_1', codeEtiquette1);
				qSave.setParam('Danger_Env', dangerEnv);
				qSave.setParam('Temps_Fabrication', tempsFabrication);
				qSave.setParam('Fab_Serie_Auto', fabSerieAuto);

				result = qSave.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					if (ofa_mode=="C") {
						ofa_articleId = result.responseXML.documentElement.getAttribute("Article_Id");
						ofa_chargerArticle();
					}
					else {
						ofa_setModified(false);
						ofa_aPrixArticle.initTree();
						ofa_reinitialiserPrixArticle();
					}
				}
			}
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function ofa_supprimerArticle() {
	try {

		var reference = document.getElementById('ofa-reference').value;

		if (window.confirm("Confirmez-vous la suppression de l'article "+ reference +" ?")) {

			var qSupArt = new QueryHttp("Facturation/Articles/deleteFicheArticle.tmpl");
			qSupArt.setParam('Article_Id', ofa_articleId);
			var result = qSupArt.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
	    	showMessage("L'article a \u00E9t\u00E9 supprim\u00E9");
				retourMenuArticles();
			}
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function ofa_hideButtons(b) {
	try {

		document.getElementById('ofa-buttons').collapsed = b;

	} catch (e) {
  	recup_erreur(e);
  }
}


function ofa_demandeEnregistrement() {
  try {

		if (ofa_modified) {
			if (window.confirm("Voulez-vous enregistrer les modifications apport\u00E9es \u00E0 la fiche article ?")) {
				ofa_enregistrerArticle();
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function ofa_setModified(m) {
  try {

  	ofa_modified = m && !gReadOnly;

		if (ofa_modified) {
			if (document.getElementById('ofa-panneau').selectedIndex==0) {
				document.getElementById('ofa-tabFiche').setAttribute('image', 'chrome://opensi/content/design/icones/modified.png');
			}
			else {
				document.getElementById('ofa-tabElements').setAttribute('image', 'chrome://opensi/content/design/icones/modified.png');
			}
			ofa_reinitialiserPrixArticle();
			document.getElementById('ofa-bDupliquer').disabled = true;
		}
		else {
			document.getElementById('ofa-tabFiche').setAttribute('image', null);
			document.getElementById('ofa-tabElements').setAttribute('image', null);
			document.getElementById('ofa-bDupliquer').disabled = false;
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function ofa_editerArticle() {
	try {

		document.getElementById("ofa-pdfArticle").setAttribute("src", "");
		document.getElementById("bRetourArticle").collapsed = false;
		document.getElementById("ofa-deckArticle").selectedIndex = 1;

		var qGenPdf = new QueryHttp("Facturation/Articles/pdfFicheArticle.tmpl");
		qGenPdf.setParam("Article_Id", ofa_articleId);
		var result = qGenPdf.execute();
		var page = getDirPdf() + result.responseXML.documentElement.getAttribute("FichierPDF");
		document.getElementById("ofa-pdfArticle").setAttribute("src", page);

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_envoyer() {
	try {

		var url = "chrome://opensi/content/popup/popup-envoyerMail.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', "FART", ofa_articleId);

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_dupliquerArticle() {
	try {

		if (ofa_numerotationAuto) {
			var qDupliquer = new QueryHttp("Facturation/Articles/duplicateFicheArticle.tmpl");
			qDupliquer.setParam("Article_Id", ofa_articleId);
			qDupliquer.setParam("New_Reference", "");
			var result = qDupliquer.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var newArticleId = result.responseXML.documentElement.getAttribute("Article_Id");
				ofa_retourDupliquerArticle(newArticleId);
			}
		}
		else {
			var url = "chrome://opensi/content/facturation/user/stocks/copier_article.xul";
			window.openDialog(url,'','chrome,modal,centerscreen', ofa_retourDupliquerArticle, ofa_articleId);
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function ofa_retourDupliquerArticle(newArticleId) {
  try {

		ofa_articleId = newArticleId;
		ofa_chargerArticle();

  } catch (e) {
    recup_erreur(e);
  }
}


function ofa_chargerTVA(selection) {
	try {

		ofa_curCodeTVA = selection;
		var aTva = new Arbre("ComboListe/combo-tauxTVA.tmpl", "ofa-codeTVA");
		aTva.setParam("Selection", ofa_curCodeTVA);
		aTva.initTree(ofa_initTVA);

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_chargerUnitesPoids(selection) {
	try {

		ofa_curUnitePoids = selection;
		ofa_aUnitesPoids.setParam("Selection", ofa_curUnitePoids);
		ofa_aUnitesPoids.initTree(ofa_initUnitePoids);

	} catch (e) {
    recup_erreur(e);
  }
}


function ofa_chargerCartons(selection) {
	try {

		ofa_curCarton = selection;
		ofa_aCartons.setParam("Selection", ofa_curCarton);
		ofa_aCartons.initTree(ofa_initCarton);

	} catch (e) {
    recup_erreur(e);
  }
}

function ofa_initCarton() {
	try {

		document.getElementById("ofa-carton").value = ofa_curCarton;

	} catch (e) {
    recup_erreur(e);
  }
}

function ofa_initUnitePoids() {
	try {

    document.getElementById('ofa-unitePoids').value = ofa_curUnitePoids;

	} catch (e) {
    recup_erreur(e);
  }
}


function ofa_chargerUnitesDimensions(selection) {
	try {

		ofa_curUniteDimensions = selection;
		ofa_aUnitesDimensions.setParam("Selection", ofa_curUniteDimensions);
		ofa_aUnitesDimensions.initTree(ofa_initUniteDimensions);

	} catch (e) {
    recup_erreur(e);
  }
}


function ofa_initUniteDimensions() {
	try {

    document.getElementById('ofa-uniteDimensions').value = ofa_curUniteDimensions;

	} catch (e) {
    recup_erreur(e);
  }
}


function ofa_chargerUnitesVolume(selection) {
	try {

		ofa_curUniteVolume = selection;
		ofa_aUnitesVolume.setParam("Selection", ofa_curUniteVolume);
		ofa_aUnitesVolume.initTree(ofa_initUniteVolume);

	} catch (e) {
    recup_erreur(e);
  }
}


function ofa_initUniteVolume() {
	try {

    document.getElementById('ofa-uniteVolume').value = ofa_curUniteVolume;

	} catch (e) {
    recup_erreur(e);
  }
}


function ofa_ouvrirEditionListeConditionnement() {
	try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-ajouterElementListe.xul?Type_Element=CONDIT";
    window.openDialog(url,'','chrome,modal,centerscreen', ofa_chargerConditionnements);

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_chargerConditionnements(selection) {
	try {

		ofa_curConditionnement = selection;
		ofa_aConditionnements.setParam("Selection", ofa_curConditionnement);
		ofa_aConditionnements.initTree(ofa_initConditionnement);

	} catch (e) {
    recup_erreur(e);
  }
}


function ofa_initConditionnement() {
	try {

    document.getElementById('ofa-conditionnement').value = ofa_curConditionnement;

	} catch (e) {
    recup_erreur(e);
  }
}


function ofa_initUnite() {
	try {

		document.getElementById('ofa-unite').value = ofa_defautUniteVente;

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_calculerVolume() {
	try {

		var uniteDimensions = document.getElementById('ofa-uniteDimensions').value;
		var longueur = document.getElementById('ofa-longueur').value;
		var largeur = document.getElementById('ofa-largeur').value;
		var hauteur = document.getElementById('ofa-hauteur').value;
		var uniteVolume = document.getElementById('ofa-uniteVolume').value;

		if (isEmpty(uniteDimensions)) { showWarning("Veuillez s\u00E9lectionner une unit\u00E9 de dimensions !"); }
		else if (isEmpty(longueur) || !isPositiveOrNull(longueur) || !checkNumber(longueur,7,3)) { showWarning("La longueur est incorrecte !"); }
		else if (isEmpty(largeur) || !isPositiveOrNull(largeur) || !checkNumber(largeur,7,3)) { showWarning("La largeur est incorrecte !"); }
		else if (isEmpty(hauteur) || !isPositiveOrNull(hauteur) || !checkNumber(hauteur,7,3)) { showWarning("La hauteur est incorrecte !"); }
		else if (isEmpty(uniteVolume)) { showWarning("Veuillez s\u00E9lectionner une unit\u00E9 de volume !"); }
		else {

			var qVol = new QueryHttp("Facturation/Commun/computeVolumeByDimensions.tmpl");
			qVol.setParam("Unite_Dim", uniteDimensions);
			qVol.setParam("Unite_Vol", uniteVolume);
			qVol.setParam("Longueur", longueur);
			qVol.setParam("Largeur", largeur);
			qVol.setParam("Hauteur", hauteur);
			var result = qVol.execute();
			var volume = result.responseXML.documentElement.getAttribute("Volume");

			var nfv = new NumberFormat("0.###", false);

			document.getElementById('ofa-volume').value = nfv.format(volume);
			ofa_setModified(true);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_calcPrixRevientComposition() {
	try {

		var qCalc = new QueryHttp("Facturation/Stocks/computePrixRevientComposition.tmpl");
		qCalc.setParam("Article_Id", ofa_articleId);
		var result = qCalc.execute();

		document.getElementById('ofa-prixAchat').value = result.responseXML.documentElement.getAttribute("Prix_Achat");
		document.getElementById('ofa-fraisAppro').value = result.responseXML.documentElement.getAttribute("Frais_Appro");

		ofa_calculerRevient();
		ofa_setModified(true);

	} catch (e) {
    recup_erreur(e);
  }
}


function ofa_initTVA() {
	try {

    document.getElementById('ofa-codeTVA').value = ofa_curCodeTVA;

	} catch (e) {
    recup_erreur(e);
  }
}


function ofa_calculerRevient() {
	try {

		var pa = parseFloat(document.getElementById('ofa-prixAchat').value);
		var fa = parseFloat(document.getElementById('ofa-fraisAppro').value);

		var nfs = new NumberFormat("0.00##", false);

		if (isPositiveOrNull(pa) && isPositiveOrNull(fa)) {
			document.getElementById('ofa-prixRevient').value = nfs.format(pa + fa);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function ofa_refreshTarifs() {
	try {

		if (ofa_mode=="M") {
			if (ofa_modeTarif=='G') {
				var codeTVA = document.getElementById('ofa-codeTVA').value;
				var prixRevient = document.getElementById('ofa-prixRevient').value;

				ofa_aPrixArticle.setParam("Recalcul", true);
				ofa_aPrixArticle.setParam("Code_TVA", codeTVA);
				ofa_aPrixArticle.setParam("Prix_Revient", prixRevient);
				ofa_aPrixArticle.initTree();

				ofa_aPrixArticle.setParam("Recalcul", false);
			}
			else {
				ofa_initTreeTarifs();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function ofa_validerLigne() {
  try {

		var quantite = document.getElementById('ofa-quantiteLigne').value;
		var prix = document.getElementById('ofa-prixLigne').value;
		var prix_ttc = document.getElementById('ofa-prixLigneTTC').value;
		var lib_ext = document.getElementById('ofa-libExt').value;
		var lib_int = document.getElementById('ofa-libInt').value;
		var coeff = document.getElementById('ofa-coeffLigne').value;
		var tauxMarque = document.getElementById('ofa-tauxMarqueLigne').value;
		var tauxMarge = document.getElementById('ofa-tauxMargeLigne').value;

		if (isEmpty(prix) || !isPositiveOrNull(prix) || !checkDecimal(prix,4)) {
			showWarning("Prix HT incorrect !");
		}
		else if (isEmpty(prix_ttc) || !isPositiveOrNull(prix_ttc) || !checkDecimal(prix_ttc,4)) {
			showWarning("Prix TTC incorrect !");
		}
		else if (!checkQte(quantite)) {
			showWarning("Quantit\u00E9 incorrecte !");
		}
		else if (document.getElementById('ofa-baseCalcul').checked && (!isEmpty(coeff) && (!isPositiveOrNull(coeff) || !checkDecimal(coeff,6)))) {
			showWarning("Coefficient incorrect !");
		}
		else if (document.getElementById('ofa-baseCalcul').checked && (!isEmpty(tauxMarque) && (!checkDecimal(tauxMarque,6) || parseFloat(tauxMarque)>=100))) {
			showWarning("Taux de marque incorrect");
		}
		else if (document.getElementById('ofa-baseCalcul').checked && (!isEmpty(tauxMarge) && !checkDecimal(tauxMarge,4))) {
			showWarning("Taux de marge incorrect");
		}
		else {

			var qSaveTarif;

			if (isEmpty(ofa_prixId)) {
				qSaveTarif = new QueryHttp("Facturation/Articles/createPrixQuantite.tmpl");
				qSaveTarif.setParam('Article_Id', ofa_articleId);
				qSaveTarif.setParam('Quantite', quantite);
			}
			else {
				qSaveTarif = new QueryHttp("Facturation/Articles/updatePrixQuantite.tmpl");
				qSaveTarif.setParam('Prix_Id', ofa_prixId);
			}

			qSaveTarif.setParam('Prix', prix);
			qSaveTarif.setParam('Lib_Ext', lib_ext);
			qSaveTarif.setParam('Lib_Int', lib_int);
			qSaveTarif.setParam('Coeff', coeff);
			qSaveTarif.setParam('Taux_Marque', tauxMarque);
			qSaveTarif.setParam('Taux_Marge', tauxMarge);
			qSaveTarif.setParam('Prix_TTC', prix_ttc);
			qSaveTarif.execute();

			ofa_initTreeTarifs();

			ofa_annulerLigne();
		}

  } catch (e) {
  	recup_erreur(e);
	}
}


function ofa_changeModeTarifQte() {
  try {

		if (document.getElementById('ofa-baseCalcul').checked) {
			document.getElementById('ofa-colTauxMarque').collapsed = false;
			document.getElementById('ofa-colTauxMarge').collapsed = false;
			document.getElementById('ofa-colCoeff').collapsed = false;
			document.getElementById('ofa-tauxMarqueLigne').collapsed = false;
			document.getElementById('ofa-tauxMargeLigne').collapsed = false;
			document.getElementById('ofa-coeffLigne').collapsed = false;
			document.getElementById('ofa-boxAchat').collapsed = !gAccesCoutAchat;
		}
		else {
			document.getElementById('ofa-colTauxMarque').collapsed = true;
			document.getElementById('ofa-colTauxMarge').collapsed = true;
			document.getElementById('ofa-colCoeff').collapsed = true;
			document.getElementById('ofa-tauxMarqueLigne').collapsed = true;
			document.getElementById('ofa-tauxMargeLigne').collapsed = true;
			document.getElementById('ofa-coeffLigne').collapsed = true;
			document.getElementById('ofa-boxAchat').collapsed = true;
			if (document.getElementById('ofa-prixRevient').value <= 0) {
				document.getElementById('ofa-prixAchat').value = 1;
				ofa_calculerRevient();
				if (isEmpty(document.getElementById('ofa-prixLigne').value)) { document.getElementById('ofa-prixLigne').value = 1; }
				ofa_calculerLigne("h");
			}
		}

		ofa_initTreeTarifs();

	} catch (e) {
  	recup_erreur(e);
	}
}


function ofa_annulerLigne() {
  try {

		document.getElementById('ofa-libInt').value = "";
		document.getElementById('ofa-libExt').value = "";
		document.getElementById('ofa-quantiteLigne').value = "";
		document.getElementById('ofa-prixLigne').value = "";
		document.getElementById('ofa-tauxMarqueLigne').value = "";
		document.getElementById('ofa-tauxMargeLigne').value = "";
		document.getElementById('ofa-coeffLigne').value = "";
		document.getElementById('ofa-prixLigneTTC').value = "";
		ofa_prixId = "";
		document.getElementById('ofa-bSupprimerPrix').disabled = true;
		document.getElementById('ofa-quantiteLigne').disabled = false;

	} catch (e) {
  	recup_erreur(e);
	}
}


function ofa_calculerLigne(t) {
  try {

		var nf = new NumberFormat("0.00", false);
		var nf6 = new NumberFormat("0.######", false);
		var nf4 = new NumberFormat("0.####", false);

		var tva = parseFloat(getTva(document.getElementById('ofa-codeTVA').value))/100 + 1;
		var pr = document.getElementById('ofa-prixRevient').value;

		if (t=="h") {
			var prixLigne = document.getElementById('ofa-prixLigne').value;
			if (isNaN(prixLigne)) {
				document.getElementById('ofa-coeffLigne').value = "";
				document.getElementById('ofa-prixLigneTTC').value = "";
				document.getElementById('ofa-tauxMarqueLigne').value = "";
				document.getElementById('ofa-tauxMargeLigne').value = "";
			} else {
				var pvht = parseFloat(prixLigne);
				document.getElementById('ofa-coeffLigne').value = (pr>0?nf6.format(pvht / pr):"");
				document.getElementById('ofa-prixLigneTTC').value = nf.format(pvht * tva);
				document.getElementById('ofa-tauxMarqueLigne').value = (pvht>0 && pr>0?nf6.format((pvht-pr)/pvht * 100):"");
				document.getElementById('ofa-tauxMargeLigne').value = (pr>0?nf4.format((pvht-pr)/pr * 100):"");
			}
		}
		else if (t=="c") {
			var coeffLigne = document.getElementById('ofa-coeffLigne').value;
			if (isNaN(coeffLigne)) {
				document.getElementById('ofa-prixLigne').value = "";
				document.getElementById('ofa-prixLigneTTC').value = "";
				document.getElementById('ofa-tauxMarqueLigne').value = "";
				document.getElementById('ofa-tauxMargeLigne').value = "";
			} else {
				var pvht = parseFloat(coeffLigne) * pr;
				document.getElementById('ofa-prixLigne').value = nf.format(pvht);
				document.getElementById('ofa-prixLigneTTC').value = nf.format(pvht * tva);
				document.getElementById('ofa-tauxMarqueLigne').value = (pvht>0 && pr>0?nf6.format((pvht-pr)/pvht * 100):"");
				document.getElementById('ofa-tauxMargeLigne').value = (pr>0?nf4.format((pvht-pr)/pr * 100):"");
			}
		}
		else if (t=="t") {
			var prixLigneTTC = document.getElementById('ofa-prixLigneTTC').value;
			if (isNaN(prixLigneTTC)) {
				document.getElementById('ofa-prixLigne').value = "";
				document.getElementById('ofa-coeffLigne').value = "";
				document.getElementById('ofa-tauxMarqueLigne').value = "";
				document.getElementById('ofa-tauxMargeLigne').value = "";
			} else {
				var pvht = parseFloat(prixLigneTTC) / tva;
				document.getElementById('ofa-prixLigne').value = nf.format(pvht);
				document.getElementById('ofa-coeffLigne').value = (pr>0?nf6.format(pvht / pr):"");
				document.getElementById('ofa-tauxMarqueLigne').value = (pvht>0 && pr>0?nf6.format((pvht-pr)/pvht * 100):"");
				document.getElementById('ofa-tauxMargeLigne').value = (pr>0?nf4.format((pvht-pr)/pr * 100):"");
			}
		}
		else if (t=="g") {
			var tauxMargeLigne = document.getElementById('ofa-tauxMargeLigne').value;
			if (isNaN(tauxMargeLigne)) {
				document.getElementById('ofa-prixLigne').value = "";
				document.getElementById('ofa-coeffLigne').value = "";
				document.getElementById('ofa-prixLigneTTC').value = "";
				document.getElementById('ofa-tauxMarqueLigne').value = "";
			} else {
				var pvht = pr * (1 + parseFloat(document.getElementById('ofa-tauxMarqueLigne').value)/100);
				document.getElementById('ofa-prixLigne').value = nf.format(pvht);
				document.getElementById('ofa-coeffLigne').value = (pr>0?nf6.format(pvht / pr):"");
				document.getElementById('ofa-prixLigneTTC').value = nf.format(pvht * tva);
				document.getElementById('ofa-tauxMarqueLigne').value = (pvht>0 && pr>0?nf6.format((pvht-pr)/pvht * 100):"");
			}
		}
		else if (t=="m") {
			var tauxMarqueLigne = document.getElementById('ofa-tauxMarqueLigne').value;
			if (isNaN(tauxMarqueLigne)) {
				document.getElementById('ofa-prixLigne').value = "";
				document.getElementById('ofa-coeffLigne').value = "";
				document.getElementById('ofa-prixLigneTTC').value = "";
				document.getElementById('ofa-tauxMargeLigne').value = "";
			} else {
				if (parseFloat(document.getElementById('ofa-tauxMarqueLigne').value)>=100) {
					showWarning("Le taux de marque doit \u00EAtre inf\u00E9rieur \u00E0 100 % !");
				}
				else {
					var pvht = pr / (1 - parseFloat(document.getElementById('ofa-tauxMarqueLigne').value)/100);
					document.getElementById('ofa-prixLigne').value = nf.format(pvht);
					document.getElementById('ofa-coeffLigne').value = (pr>0?nf6.format(pvht / pr):"");
					document.getElementById('ofa-prixLigneTTC').value = nf.format(pvht * tva);
					document.getElementById('ofa-tauxMargeLigne').value = (pr>0?nf4.format((pvht-pr)/pr * 100):"");
				}
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function ofa_reporterLigne() {
  try {

		if (ofa_aTarifs.isSelected()) {
			document.getElementById('ofa-libInt').value = ofa_aTarifs.getSelectedCellText('ofa-colLibInt');
			document.getElementById('ofa-libExt').value = ofa_aTarifs.getSelectedCellText('ofa-colLibExt');
			document.getElementById('ofa-quantiteLigne').value = ofa_aTarifs.getSelectedCellText('ofa-colQuantite');
			document.getElementById('ofa-prixLigne').value = ofa_aTarifs.getSelectedCellText('ofa-colHT');
			document.getElementById('ofa-tauxMarqueLigne').value = ofa_aTarifs.getSelectedCellText('ofa-colTauxMarque');
			document.getElementById('ofa-tauxMargeLigne').value = ofa_aTarifs.getSelectedCellText('ofa-colTauxMarge');
			document.getElementById('ofa-coeffLigne').value = ofa_aTarifs.getSelectedCellText('ofa-colCoeff');
			document.getElementById('ofa-prixLigneTTC').value = ofa_aTarifs.getSelectedCellText('ofa-colTTC');
			ofa_prixId = ofa_aTarifs.getSelectedCellText('ofa-colPrixId');
			document.getElementById('ofa-bSupprimerPrix').disabled = false;
			document.getElementById('ofa-quantiteLigne').disabled = true;
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function ofa_supprimerLigne() {
  try {

		var qDelete = new QueryHttp("Facturation/Articles/deletePrixQuantite.tmpl");
		qDelete.setParam('Prix_Id', ofa_prixId);
    qDelete.execute();

   	ofa_initTreeTarifs();
		ofa_annulerLigne();

	} catch (e) {
  	recup_erreur(e);
	}
}


function ofa_disableBoutons(b) {
  try {

		document.getElementById('ofa-bAnnuler').disabled = b;
		document.getElementById('ofa-bValider').disabled = b;
		document.getElementById('ofa-bSupprimerPrix').disabled = b;

		document.getElementById('ofa-baseCalcul').disabled = b;

	} catch (e) {
  	recup_erreur(e);
	}
}


function ofa_initTreeTarifs() {
  try {

		var tva = getTva(document.getElementById('ofa-codeTVA').value);

		ofa_aTarifs.setParam('Article_Id', ofa_articleId);
		ofa_aTarifs.setParam('Taux_TVA', tva);

		if (document.getElementById('ofa-baseCalcul').checked) {
			ofa_aTarifs.setParam('Prix_Achat', document.getElementById('ofa-prixRevient').value);
		}

    ofa_aTarifs.initTree();

  } catch (e) {
    recup_erreur(e);
  }
}


// VENTILATION COMPTABLE

var ofa_currentChampCompte = "";
var ofa_currentCodeTVAInter = "";
var ofa_currentCodeTVAUE = "";
var ofa_currentCodeTVANat = "";
var ofa_currentCodeTVANatUE = "";
var ofa_currentCodePaysNatUE = "";


function ofa_rechercherCompte(id) {
	try {

    ofa_setModified(true);

		var debCompte = "";
		var titre = "";

    switch (id) {
    	case 'ofa-compteVenteNat':
    		debCompte = "7";
        titre = "VENTE";
        break;
    	case 'ofa-compteVenteUE':
    		debCompte = "7";
        titre = "VENTE UE";
        break;
      case 'ofa-compteVenteNatUE':
    		debCompte = "7";
        titre = "VENTE UE";
        break;
    	case 'ofa-compteVenteInter':
  			debCompte = "7";
        titre = "VENTE INTERNATIONAL";
        break;
      case 'ofa-compteAchatNat':
  			debCompte = "6";
        titre = "ACHAT";
        break;
      case 'ofa-compteAchatUE':
  			debCompte = "6";
        titre = "ACHAT UE";
        break;
      case 'ofa-compteAchatInter':
  			debCompte = "6";
        titre = "ACHAT INTERNATIONAL";
        break;
    }

    ofa_currentChampCompte = id;
    var url = "chrome://opensi/content/compta/user/comptes/popup-rechercheCompte.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', ofa_retourRechercherCompte, debCompte, "G", titre, (debCompte=="6"?"":debCompte), false);
		// on autorise  mettre un compte autre que 6 pour les achats (cas des immos en 2)

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_retourRechercherCompte(numCompte, compteId) {
	try {

		document.getElementById(ofa_currentChampCompte).value = numCompte;
		ofa_currentChampCompte = "";

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_chargerVentilationComptable() {
	try {

		ofa_listerComptesArticleNat();
		ofa_listerComptesArticleUE();
		ofa_listerComptesArticleNatUE();
		ofa_listerComptesArticleInter();

	} catch(e) {
		recup_erreur(e);
	}
}


function ofa_dechargerVentilationComptable() {
	try {

		ofa_aComptesArticleNat.deleteTree();
		ofa_aComptesArticleUE.deleteTree();
		ofa_aComptesArticleNatUE.deleteTree();
		ofa_aComptesArticleInter.deleteTree();

		ofa_nouveauCompteArticleNat();
		ofa_nouveauCompteArticleUE();
		ofa_nouveauCompteArticleNatUE();
		ofa_nouveauCompteArticleInter();

	} catch(e) {
		recup_erreur(e);
	}
}


function ofa_nouveauCompteArticleNat() {
	try {

		ofa_currentCodeTVANat = "";
		document.getElementById("ofa-tauxTVANat").value = "";
		document.getElementById("ofa-compteAchatNat").value = "";
		document.getElementById("ofa-compteVenteNat").value = "";

		document.getElementById("ofa-bRechercherAchatNat").disabled = true;
		document.getElementById("ofa-bRemoveAchatNat").disabled = true;
		document.getElementById("ofa-bRechercherVenteNat").disabled = true;
		document.getElementById("ofa-bRemoveVenteNat").disabled = true;
		document.getElementById("ofa-bValiderNat").disabled = true;

	} catch(e) {
		recup_erreur(e);
	}
}


function ofa_listerComptesArticleNat() {
	try {

		ofa_nouveauCompteArticleNat();

		ofa_aComptesArticleNat.setParam('Article_Id', ofa_articleId);
		ofa_aComptesArticleNat.setParam('Type_Ventilation', "N");
		ofa_aComptesArticleNat.initTree();

	} catch(e) {
		recup_erreur(e);
	}
}


function ofa_chargerCompteArticleNat() {
	try {

		if (ofa_aComptesArticleNat.isSelected()) {
			ofa_currentCodeTVANat = ofa_aComptesArticleNat.getSelectedCellText('ofa-colCodeTVANat');
			document.getElementById("ofa-tauxTVANat").value = ofa_aComptesArticleNat.getSelectedCellText('ofa-colTauxTVANat');
			document.getElementById("ofa-compteAchatNat").value = ofa_aComptesArticleNat.getSelectedCellText('ofa-colCompteAchatNat');
			document.getElementById("ofa-compteVenteNat").value = ofa_aComptesArticleNat.getSelectedCellText('ofa-colCompteVenteNat');

			document.getElementById("ofa-bRechercherAchatNat").disabled = false;
			document.getElementById("ofa-bRemoveAchatNat").disabled = false;
			document.getElementById("ofa-bRechercherVenteNat").disabled = false;
			document.getElementById("ofa-bRemoveVenteNat").disabled = false;
			document.getElementById("ofa-bValiderNat").disabled = false;
		}

	} catch(e) {
		recup_erreur(e);
	}
}


function ofa_validerCompteArticleNat() {
	try {

		var compteAchat = document.getElementById("ofa-compteAchatNat").value;
		var compteVente = document.getElementById("ofa-compteVenteNat").value;

		var qSave = new QueryHttp("Facturation/Articles/saveCompteArticle.tmpl");

		qSave.setParam("Article_Id", ofa_articleId);
		qSave.setParam("Code_TVA", ofa_currentCodeTVANat);
		qSave.setParam("Compte_Achat", compteAchat);
		qSave.setParam("Compte_Vente", compteVente);

		var result = qSave.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			ofa_listerComptesArticleNat();
		}

	} catch(e) {
		recup_erreur(e);
	}
}


function ofa_nouveauCompteArticleUE() {
	try {

		ofa_currentCodeTVAUE = "";
		document.getElementById("ofa-tauxTVAUE").value = "";
		document.getElementById("ofa-paysUE").value = "";
		document.getElementById("ofa-compteAchatUE").value = "";
		document.getElementById("ofa-compteVenteUE").value = "";

		document.getElementById("ofa-bRechercherAchatUE").disabled = true;
		document.getElementById("ofa-bRemoveAchatUE").disabled = true;
		document.getElementById("ofa-bRechercherVenteUE").disabled = true;
		document.getElementById("ofa-bRemoveVenteUE").disabled = true;
		document.getElementById("ofa-bValiderUE").disabled = true;

	} catch(e) {
		recup_erreur(e);
	}
}


function ofa_listerComptesArticleUE() {
	try {

		ofa_nouveauCompteArticleUE();

		ofa_aComptesArticleUE.setParam('Article_Id', ofa_articleId);
		ofa_aComptesArticleUE.setParam('Type_Ventilation', "U");
		ofa_aComptesArticleUE.initTree();

	} catch(e) {
		recup_erreur(e);
	}
}


function ofa_chargerCompteArticleUE() {
	try {

		if (ofa_aComptesArticleUE.isSelected()) {
			ofa_currentCodeTVAUE = ofa_aComptesArticleUE.getSelectedCellText('ofa-colCodeTVAUE');
			document.getElementById("ofa-tauxTVAUE").value = ofa_aComptesArticleUE.getSelectedCellText('ofa-colTauxTVAUE');
			document.getElementById("ofa-paysUE").value = ofa_aComptesArticleUE.getSelectedCellText('ofa-colPaysUE');
			document.getElementById("ofa-compteAchatUE").value = ofa_aComptesArticleUE.getSelectedCellText('ofa-colCompteAchatUE');
			document.getElementById("ofa-compteVenteUE").value = ofa_aComptesArticleUE.getSelectedCellText('ofa-colCompteVenteUE');

			document.getElementById("ofa-bRechercherAchatUE").disabled = false;
			document.getElementById("ofa-bRemoveAchatUE").disabled = false;
			document.getElementById("ofa-bRechercherVenteUE").disabled = false;
			document.getElementById("ofa-bRemoveVenteUE").disabled = false;
			document.getElementById("ofa-bValiderUE").disabled = false;
		}

	} catch(e) {
		recup_erreur(e);
	}
}


function ofa_validerCompteArticleUE() {
	try {

		var compteAchat = document.getElementById("ofa-compteAchatUE").value;
		var compteVente = document.getElementById("ofa-compteVenteUE").value;

		var qSave = new QueryHttp("Facturation/Articles/saveCompteArticle.tmpl");

		qSave.setParam("Article_Id", ofa_articleId);
		qSave.setParam("Code_TVA", ofa_currentCodeTVAUE);
		qSave.setParam("Compte_Achat", compteAchat);
		qSave.setParam("Compte_Vente", compteVente);

		var result = qSave.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			ofa_listerComptesArticleUE();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_nouveauCompteArticleNatUE() {
	try {

		ofa_currentCodeTVANatUE = "";
		ofa_currentCodePaysNatUE = "";
		document.getElementById("ofa-tauxTVANatUE").value = "";
		document.getElementById("ofa-paysNatUE").value = "";
		document.getElementById("ofa-compteVenteNatUE").value = "";

		document.getElementById("ofa-bRechercherVenteNatUE").disabled = true;
		document.getElementById("ofa-bRemoveVenteNatUE").disabled = true;
		document.getElementById("ofa-bValiderNatUE").disabled = true;

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_listerComptesArticleNatUE() {
	try {

		ofa_nouveauCompteArticleNatUE();

		ofa_aComptesArticleNatUE.setParam('Article_Id', ofa_articleId);
		ofa_aComptesArticleNatUE.initTree();

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_chargerCompteArticleNatUE() {
	try {

		if (ofa_aComptesArticleNatUE.isSelected()) {
			ofa_currentCodeTVANatUE = ofa_aComptesArticleNatUE.getSelectedCellText('ofa-colCodeTVANatUE');
			ofa_currentCodePaysNatUE = ofa_aComptesArticleNatUE.getSelectedCellText('ofa-colCodePaysNatUE');
			document.getElementById("ofa-tauxTVANatUE").value = ofa_aComptesArticleNatUE.getSelectedCellText('ofa-colTauxTVANatUE');
			document.getElementById("ofa-paysNatUE").value = ofa_aComptesArticleNatUE.getSelectedCellText('ofa-colPaysNatUE');
			document.getElementById("ofa-compteVenteNatUE").value = ofa_aComptesArticleNatUE.getSelectedCellText('ofa-colCompteVenteNatUE');

			document.getElementById("ofa-bRechercherVenteNatUE").disabled = false;
			document.getElementById("ofa-bRemoveVenteNatUE").disabled = false;
			document.getElementById("ofa-bValiderNatUE").disabled = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_validerCompteArticleNatUE() {
	try {

		var compteVente = document.getElementById("ofa-compteVenteNatUE").value;

		var qSave = new QueryHttp("Facturation/Articles/saveCompteArticleTVANationalUE.tmpl");

		qSave.setParam("Article_Id", ofa_articleId);
		qSave.setParam("Code_TVA", ofa_currentCodeTVANatUE);
		qSave.setParam("Code_Pays", ofa_currentCodePaysNatUE);
		qSave.setParam("Compte_Vente", compteVente);

		var result = qSave.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			ofa_listerComptesArticleNatUE();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_nouveauCompteArticleInter() {
	try {

		ofa_currentCodeTVAInter = "";
		document.getElementById("ofa-paysInter").value = "";
		document.getElementById("ofa-compteAchatInter").value = "";
		document.getElementById("ofa-compteVenteInter").value = "";

		document.getElementById("ofa-bRechercherAchatInter").disabled = true;
		document.getElementById("ofa-bRemoveAchatInter").disabled = true;
		document.getElementById("ofa-bRechercherVenteInter").disabled = true;
		document.getElementById("ofa-bRemoveVenteInter").disabled = true;
		document.getElementById("ofa-bValiderInter").disabled = true;

	} catch(e) {
		recup_erreur(e);
	}
}


function ofa_listerComptesArticleInter() {
	try {

		ofa_nouveauCompteArticleInter();

		ofa_aComptesArticleInter.setParam('Article_Id', ofa_articleId);
		ofa_aComptesArticleInter.setParam('Type_Ventilation', "I");
		ofa_aComptesArticleInter.initTree();

	} catch(e) {
		recup_erreur(e);
	}
}


function ofa_chargerCompteArticleInter() {
	try {

		if (ofa_aComptesArticleInter.isSelected()) {
			ofa_currentCodeTVAInter = ofa_aComptesArticleInter.getSelectedCellText('ofa-colCodeTVAInter');
			document.getElementById("ofa-paysInter").value = ofa_aComptesArticleInter.getSelectedCellText('ofa-colPaysInter');
			document.getElementById("ofa-compteAchatInter").value = ofa_aComptesArticleInter.getSelectedCellText('ofa-colCompteAchatInter');
			document.getElementById("ofa-compteVenteInter").value = ofa_aComptesArticleInter.getSelectedCellText('ofa-colCompteVenteInter');

			document.getElementById("ofa-bRechercherAchatInter").disabled = false;
			document.getElementById("ofa-bRemoveAchatInter").disabled = false;
			document.getElementById("ofa-bRechercherVenteInter").disabled = false;
			document.getElementById("ofa-bRemoveVenteInter").disabled = false;
			document.getElementById("ofa-bValiderInter").disabled = false;
		}

	} catch(e) {
		recup_erreur(e);
	}
}


function ofa_validerCompteArticleInter() {
	try {

		var compteAchat = document.getElementById("ofa-compteAchatInter").value;
		var compteVente = document.getElementById("ofa-compteVenteInter").value;

		var qSave = new QueryHttp("Facturation/Articles/saveCompteArticle.tmpl");

		qSave.setParam("Article_Id", ofa_articleId);
		qSave.setParam("Code_TVA", ofa_currentCodeTVAInter);
		qSave.setParam("Compte_Achat", compteAchat);
		qSave.setParam("Compte_Vente", compteVente);

		var result = qSave.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			ofa_listerComptesArticleInter();
		}

	} catch(e) {
		recup_erreur(e);
	}
}


function ofa_collapsGridCarton() {
	try {

		document.getElementById("ofa-gridColisage").collapsed = (ofa_methodeColisage=="V" || document.getElementById("ofa-colisageSpe").checked);

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_historiquePrix() {
	try {

		var url = "chrome://opensi/content/facturation/user/stocks/"+ (ofa_modeTarif=='G'?"popup-historiquePrixArticle.xul":"popup-historiquePrixQuantite.xul");
    window.openDialog(url,'','chrome,modal,centerscreen', ofa_articleId, document.getElementById('ofa-baseCalcul').checked);

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_nouveauAttribut() {
	try {

		document.getElementById("ofa-groupeId").value = "";
		document.getElementById("ofa-attributId").value = "";
		document.getElementById("ofa-groupeId").disabled = false;
		document.getElementById("ofa-bSupprimerAttribut").disabled = true;
		ofa_aValAttributs.deleteTree();
		ofa_aAttributs.clearSelection();
		ofa_chargerGroupes("");

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_enregistrerAttribut() {
	try {

		var attributId = document.getElementById("ofa-attributId").value;
		var groupeId = document.getElementById("ofa-groupeId").value;

		if (isEmpty(groupeId)) {
			showWarning("Veuillez s\u00E9lectionner un attribut");
		}
		else if (isEmpty(attributId)) {
			showWarning("Veuillez s\u00E9lectionner une valeur d'attribut");
		}
		else {
			var qSave = new QueryHttp("Facturation/Articles/saveAttributArticle.tmpl");
			qSave.setParam("Article_Id", ofa_articleId);
			qSave.setParam("Attribut_Id", attributId);
			qSave.setParam("Groupe_Id", groupeId);
			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			ofa_aAttributs.initTree();
			ofa_nouveauAttribut();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_supprimerAttribut() {
	try {

		var groupeId = document.getElementById("ofa-groupeId").value;

		var qSup = new QueryHttp("Facturation/Articles/deleteAttributArticle.tmpl");
		qSup.setParam("Article_Id", ofa_articleId);
		qSup.setParam("Groupe_Id", groupeId);
		qSup.execute();

		ofa_aAttributs.initTree();
		ofa_nouveauAttribut();

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_pressOnListeAttributs() {
	try {

		if (ofa_aAttributs.isSelected()) {
			document.getElementById("ofa-groupeId").disabled = true;
			document.getElementById("ofa-groupeId").value = ofa_aAttributs.getSelectedCellText("ofa-colGroupeId");
			ofa_chargerGroupes(ofa_aAttributs.getSelectedCellText("ofa-colGroupeId"));
			ofa_chargerAttributs(ofa_aAttributs.getSelectedCellText("ofa-colAttributId"));
			document.getElementById("ofa-bSupprimerAttribut").disabled = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_chargerAttributs(selection) {
	try {

		ofa_curAttribut = selection;
		var groupeId = document.getElementById('ofa-groupeId').value;

		if (!isEmpty(groupeId)) {
			ofa_aValAttributs.setParam("Groupe_Id", groupeId);
			ofa_aValAttributs.setParam("Selection", selection);
			ofa_aValAttributs.initTree(ofa_initAttribut);
		}
		else {
			ofa_aValAttributs.deleteTree();
			document.getElementById("ofa-attributId").value = "";
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_initAttribut() {
	try {

		document.getElementById("ofa-attributId").value = ofa_curAttribut;

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_chargerGroupes(selection) {
	try {

		ofa_curGroupe = selection;

		var famille1 = document.getElementById('ofa-famille1').value;
		var famille2 = document.getElementById('ofa-famille2').value;
		var famille3 = document.getElementById('ofa-famille3').value;

		var familleId = !isEmpty(famille3)?famille3:!isEmpty(famille2)?famille2:famille1;

		ofa_aLibAttributs.setParam("Selection", selection);
		ofa_aLibAttributs.setParam("Famille_Id", familleId);
		ofa_aLibAttributs.initTree(ofa_initGroupe);

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_initGroupe() {
	try {

		document.getElementById("ofa-groupeId").value = ofa_curGroupe;

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_nouveauCodeBarre() {
	try {

		ofa_codeId = null;
		document.getElementById("ofa-codeBarreCB").value = "";
		document.getElementById("ofa-quantiteCB").value = "";
		document.getElementById("ofa-defautCB").checked = false;
		document.getElementById("ofa-bSupprimerCB").disabled = true;
		ofa_aCodesBarre.clearSelection();

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_enregistrerCodeBarre() {
	try {

		var codeBarre = document.getElementById("ofa-codeBarreCB").value;
		var quantite = document.getElementById("ofa-quantiteCB").value;
		var defaut = document.getElementById("ofa-defautCB").checked;

		if (isEmpty(codeBarre) || !isCodeBarre(codeBarre)) {
			showWarning("Code barre incorrect");
		}
		else if (!checkQte(quantite)) {
			showWarning("Quantit\u00E9 incorrecte");
		}
		else {
			var qSave;
			if (ofa_codeId==null) {
				qSave = new QueryHttp("Facturation/Articles/createCodeBarreArticle.tmpl");
				qSave.setParam("Article_Id", ofa_articleId);
			}
			else {
				qSave = new QueryHttp("Facturation/Articles/updateCodeBarreArticle.tmpl");
				qSave.setParam("Code_Id", ofa_codeId);
			}
			qSave.setParam("Code_Barre", codeBarre);
			qSave.setParam("Quantite", quantite);
			qSave.setParam("Defaut", defaut);
			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			ofa_aCodesBarre.initTree();
			ofa_nouveauCodeBarre();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_supprimerCodeBarre() {
	try {

		if (ofa_codeId!=null) {
			var qSup = new QueryHttp("Facturation/Articles/deleteCodeBarreArticle.tmpl");
			qSup.setParam("Code_Id", ofa_codeId);
			qSup.execute();

			ofa_aCodesBarre.initTree();
			ofa_nouveauCodeBarre();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_pressOnListeCodesBarre() {
	try {

		if (ofa_aCodesBarre.isSelected()) {
			ofa_codeId = ofa_aCodesBarre.getSelectedCellText("ofa-colCodeIdCB");
			document.getElementById("ofa-codeBarreCB").value = ofa_aCodesBarre.getSelectedCellText("ofa-colCodeBarreCB");
			document.getElementById("ofa-quantiteCB").value = ofa_aCodesBarre.getSelectedCellText("ofa-colQuantiteCB");
			document.getElementById("ofa-defautCB").checked = ofa_aCodesBarre.getSelectedCellText("ofa-colDefautCB")=="true";
			document.getElementById("ofa-bSupprimerCB").disabled = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_pressOnListePrixArticle() {
	try {

		if (ofa_aPrixArticle.isSelected()) {
			if (!ofa_modified) {
				ofa_prixId = ofa_aPrixArticle.getSelectedCellText("ofa-colPrixIdPA");
				ofa_arrondiHT = ofa_aPrixArticle.getSelectedCellText("ofa-colArrondiHTPA");
				ofa_arrondiTTC = ofa_aPrixArticle.getSelectedCellText("ofa-colArrondiTTCPA");

				document.getElementById("ofa-tarifVentePA").value = ofa_aPrixArticle.getSelectedCellText("ofa-colTarifVentePA");
				document.getElementById("ofa-coefficientPA").value = ofa_aPrixArticle.getSelectedCellText("ofa-colCoefficientPA");
				document.getElementById("ofa-prixHTPA").value = ofa_aPrixArticle.getSelectedCellText("ofa-colPrixHTPA");
				document.getElementById("ofa-prixTTCPA").value = ofa_aPrixArticle.getSelectedCellText("ofa-colPrixTTCPA");
				document.getElementById("ofa-tauxMarquePA").value = ofa_aPrixArticle.getSelectedCellText("ofa-colTauxMarquePA");
				document.getElementById("ofa-tauxMargePA").value = ofa_aPrixArticle.getSelectedCellText("ofa-colTauxMargePA");

				document.getElementById('ofa-bEnregistrerPA').disabled = false;
				document.getElementById('ofa-coefficientPA').disabled = false;
				document.getElementById('ofa-prixHTPA').disabled = false;
				document.getElementById('ofa-prixTTCPA').disabled = false;
				document.getElementById('ofa-tauxMarquePA').disabled = false;
				document.getElementById('ofa-tauxMargePA').disabled = false;
			}
			else if (window.confirm("Il est n\u00E9cessaire d'enregistrer la fiche article avant de modifier un prix de vente.\nVoulez-vous enregistrer la fiche article ?")) {
				ofa_enregistrerArticle();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_enregistrerPrixArticle() {
  try {

		var coefficient = document.getElementById('ofa-coefficientPA').value;
		var prixHT = document.getElementById('ofa-prixHTPA').value;
		var prixTTC = document.getElementById('ofa-prixTTCPA').value;
		var tauxMarque = document.getElementById('ofa-tauxMarquePA').value;
		var tauxMarge = document.getElementById('ofa-tauxMargePA').value;

		if (isEmpty(prixHT) || !isPositiveOrNull(prixHT) || !checkDecimal(prixHT,4)) { showWarning("Prix de vente HT incorrect"); }
		else if (isEmpty(prixTTC) || !isPositiveOrNull(prixTTC) || !checkDecimal(prixTTC,4)) { showWarning("Prix de vente TTC incorrect"); }
		else if (!isEmpty(coefficient) && (!isPositiveOrNull(coefficient) || !checkDecimal(coefficient,6))) { showWarning("Coefficient incorrect"); }
		else if (!isEmpty(tauxMarque) && (!checkDecimal(tauxMarque,6) || parseFloat(tauxMarque)>=100)) { showWarning("Taux de marque incorrect"); }
		else if (!isEmpty(tauxMarge) && !checkDecimal(tauxMarge,4)) { showWarning("Taux de marge incorrect"); }
		else {
			var qUpdate = new QueryHttp("Facturation/Articles/updatePrixArticle.tmpl");

			qUpdate.setParam('Prix_Id', ofa_prixId);
			qUpdate.setParam('Coefficient', coefficient);
			qUpdate.setParam('Prix_HT', prixHT);
			qUpdate.setParam('Prix_TTC', prixTTC);
			qUpdate.setParam('Taux_Marque', tauxMarque);
			qUpdate.setParam('Taux_Marge', tauxMarge);

			var result = qUpdate.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			ofa_aPrixArticle.initTree();
			ofa_reinitialiserPrixArticle();
		}

  } catch (e) {
  	recup_erreur(e);
	}
}


function ofa_reinitialiserPrixArticle() {
  try {

		document.getElementById('ofa-tarifVentePA').value = "";
		document.getElementById('ofa-coefficientPA').value = "";
		document.getElementById('ofa-prixHTPA').value = "";
		document.getElementById('ofa-prixTTCPA').value = "";
		document.getElementById('ofa-tauxMarquePA').value = "";
		document.getElementById('ofa-tauxMargePA').value = "";

		document.getElementById('ofa-bEnregistrerPA').disabled = true;
		document.getElementById('ofa-coefficientPA').disabled = true;
		document.getElementById('ofa-prixHTPA').disabled = true;
		document.getElementById('ofa-prixTTCPA').disabled = true;
		document.getElementById('ofa-tauxMarquePA').disabled = true;
		document.getElementById('ofa-tauxMargePA').disabled = true;

		ofa_aPrixArticle.clearSelection();

	} catch (e) {
  	recup_erreur(e);
	}
}


function ofa_calculerPrixArticle(origine) {
	try {

		var nfHT = new Arrondi(ofa_arrondiHT);
		var nfTTC = new Arrondi(ofa_arrondiTTC);
		var nf6 = new NumberFormat("0.######", false);
		var nf4 = new NumberFormat("0.####", false);

		var pr = parseFloat(document.getElementById('ofa-prixRevient').value);
		var tva = parseFloat(getTva(document.getElementById('ofa-codeTVA').value))/100 + 1;

		if (origine=="coeff" && !isEmpty(document.getElementById('ofa-coefficientPA').value)) {
			var pvht = nfHT.round(parseFloat(document.getElementById('ofa-coefficientPA').value) * pr);
			document.getElementById('ofa-prixHTPA').value = nfHT.round(pvht);
			document.getElementById('ofa-prixTTCPA').value = nfTTC.round(pvht * tva);
			document.getElementById('ofa-tauxMarquePA').value = (pvht>0 && pr>0?nf6.format((pvht-pr)/pvht * 100):"");
			document.getElementById('ofa-tauxMargePA').value = (pr>0?nf4.format((pvht-pr)/pr * 100):"");
		}
		else if (origine=="ttc" && !isEmpty(document.getElementById('ofa-prixTTCPA').value)) {
			var pvht = nfHT.round(parseFloat(document.getElementById('ofa-prixTTCPA').value) / tva);
			document.getElementById('ofa-prixHTPA').value = nfHT.round(pvht);
			document.getElementById('ofa-coefficientPA').value = (pr>0?nf6.format(pvht / pr):"");
			document.getElementById('ofa-tauxMarquePA').value = (pvht>0 && pr>0?nf6.format((pvht-pr)/pvht * 100):"");
			document.getElementById('ofa-tauxMargePA').value = (pr>0?nf4.format((pvht-pr)/pr * 100):"");
		}
		else if (origine=="tauxMarge" && !isEmpty(document.getElementById('ofa-tauxMargePA').value)) {
			var pvht = nfHT.round(pr * (1 + parseFloat(document.getElementById('ofa-tauxMargePA').value)/100));
			document.getElementById('ofa-prixHTPA').value = nfHT.round(pvht);
			document.getElementById('ofa-coefficientPA').value = (pr>0?nf6.format(pvht / pr):"");
			document.getElementById('ofa-prixTTCPA').value = nfTTC.round(pvht * tva);
			document.getElementById('ofa-tauxMarquePA').value = (pvht>0 && pr>0?nf6.format((pvht-pr)/pvht * 100):"");
		}
		else if (origine=="tauxMarque" && !isEmpty(document.getElementById('ofa-tauxMarquePA').value)) {
			if (parseFloat(document.getElementById('ofa-tauxMarquePA').value)>=100) {
				showWarning("Le taux de marque doit \u00EAtre inf\u00E9rieur \u00E0 100 % !");
			}
			else {
				var pvht = nfHT.round(pr / (1 - parseFloat(document.getElementById('ofa-tauxMarquePA').value)/100));
				document.getElementById('ofa-prixHTPA').value = nfHT.round(pvht);
				document.getElementById('ofa-coefficientPA').value = (pr>0?nf6.format(pvht / pr):"");
				document.getElementById('ofa-prixTTCPA').value = nfTTC.round(pvht * tva);
				document.getElementById('ofa-tauxMargePA').value = (pr>0?nf4.format((pvht-pr)/pr * 100):"");
			}
		}
		else if (!isEmpty(document.getElementById('ofa-prixHTPA').value)) {
			// calcul  partir du prix HT pass dans le dernier else et sans vrif de l'origine pour le cas o l'on vide un champ pouvant tre null
			// ainsi il devient impossible d'enregistrer un taux de marge, un taux de marque ou un coeff  null alors que celui-ci serait calculable

			var pvht = parseFloat(document.getElementById('ofa-prixHTPA').value);
			document.getElementById('ofa-coefficientPA').value = (pr>0?nf6.format(pvht / pr):"");
			document.getElementById('ofa-prixTTCPA').value = nfTTC.round(pvht * tva);
			document.getElementById('ofa-tauxMarquePA').value = (pvht>0 && pr>0?nf6.format((pvht-pr)/pvht * 100):"");
			document.getElementById('ofa-tauxMargePA').value = (pr>0?nf4.format((pvht-pr)/pr * 100):"");
		}

	} catch (e) {
    recup_erreur(e);
  }
}
