/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var oof_mode = "C";
var oof_aFournisseurs = new Arbre("Facturation/Articles/list-fournisseurArticle.tmpl", "oof-listeFournisseurArticle");
var oof_aPrixQuantite = new Arbre("Facturation/Articles/list-prixFournisseurQuantite.tmpl", "oof-listePrixQuantite");
var oof_fournisseurId;
var oof_prixId;



function oof_initOngletFournisseurs() {
	try {

		document.getElementById('oof-rowFournisseurArticle').collapsed = gReadOnly;
		document.getElementById('oof-rowPrixQuantite').collapsed = gReadOnly;
		document.getElementById('oof-boxFleches').collapsed = gReadOnly;

		oof_nouveauFournisseur();

		oof_aFournisseurs.setParam("Article_Id", ofa_articleId);
		oof_aFournisseurs.initTree(oof_initListeFournisseurs);

		if (!gAccesCoutAchat) {
			document.getElementById('oof-ColPrix_Achat').setAttribute("ignoreincolumnpicker", true);
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function oof_reporterRefFabricant() {
	try {

		document.getElementById('oof-Ref_Fournisseur').value = document.getElementById('ofa-refFabricant').value;

	} catch (e) {
		recup_erreur(e);
	}
}


function oof_reporterFournisseur() {
	try {

		if (oof_aFournisseurs.isSelected()) {
			var i = oof_aFournisseurs.getCurrentIndex();
			oof_fournisseurId = oof_aFournisseurs.getCellText(i, 'oof-ColFournisseurId');
			document.getElementById('oof-Num_Fournisseur').value = oof_aFournisseurs.getCellText(i, 'oof-ColNumFournisseur');
			document.getElementById('oof-delaiReappro').value = oof_aFournisseurs.getCellText(i, 'oof-ColDelai_Reappro');
			document.getElementById('oof-Ref_Fournisseur').value = oof_aFournisseurs.getCellText(i, 'oof-ColRef_Fournisseur');
			document.getElementById('oof-Qte_Minimum').value = oof_aFournisseurs.getCellText(i, 'oof-ColQte_Minimum');
			document.getElementById('oof-Multiple').value = oof_aFournisseurs.getCellText(i, 'oof-ColMultiple');
			document.getElementById('oof-Pack').value = oof_aFournisseurs.getCellText(i, 'oof-ColPack');
			document.getElementById('oof-Prix_Achat').value = oof_aFournisseurs.getCellText(i, 'oof-ColPrix_Achat');
			document.getElementById('oof-PRemise').value = oof_aFournisseurs.getCellText(i, 'oof-ColPRemise');
			document.getElementById('oof-chkLivDirecte').checked = (oof_aFournisseurs.getCellText(i, 'oof-ColLivDirecte')=="true");
			document.getElementById('oof-qteStock').value = oof_aFournisseurs.getCellText(i, 'oof-colQteStock');
			document.getElementById('oof-qteDispo').value = oof_aFournisseurs.getCellText(i, 'oof-colQteDispo');
			document.getElementById('oof-Date_Reappro').value = oof_aFournisseurs.getCellText(i, 'oof-colDate_Reappro');
			document.getElementById('oof-Qte_Reappro').value = oof_aFournisseurs.getCellText(i, 'oof-colQte_Reappro');
			document.getElementById('oof-chkLivDirecte').disabled = (oof_aFournisseurs.getCellText(i, 'oof-ColLivDirecteModifiable')=="false");
			document.getElementById('oof-commentaires').value = oof_aFournisseurs.getCellText(i, 'oof-colCommentaires');
			document.getElementById('oof-prochainPA').value = oof_aFournisseurs.getCellText(i, 'oof-colProchainPA');
			document.getElementById('oof-dateProchainPA').value = oof_aFournisseurs.getCellText(i, 'oof-colDateProchainPA');
			document.getElementById('oof-bRechFourn').collapsed = true;
			document.getElementById('oof-bSupprimerFournisseur').collapsed = false;

			var firstIndex = 0;
			var lastIndex = oof_aFournisseurs.nbLignes()-1;

			document.getElementById('oof-bFlecheHaut').disabled = (i==firstIndex);
			document.getElementById('oof-bFlecheBas').disabled = (i==lastIndex);

			oof_mode = "M";

			oof_nouveauPFQ();
			oof_aPrixQuantite.setParam("Article_Id", ofa_articleId);
			oof_aPrixQuantite.setParam("Fournisseur_Id", oof_fournisseurId);
			oof_aPrixQuantite.initTree();
			document.getElementById('oof-boxPrixQuantite').collapsed = !gAccesCoutAchat;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oof_deplacerLigne(moveType) {
	try {

		if (oof_aFournisseurs.isSelected() && oof_mode=="M") {
			var qDeplacerLigne = new QueryHttp("Facturation/Stocks/deplacerLigne.tmpl");
			qDeplacerLigne.setParam("Fournisseur_Id", oof_fournisseurId);
			qDeplacerLigne.setParam("Article_Id", ofa_articleId);
			qDeplacerLigne.setParam("Move_Type", moveType);
			qDeplacerLigne.execute();

			oof_nouveauFournisseur();

			oof_aFournisseurs.initTree();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oof_rechercherFournisseur() {
	try {

		var url = "chrome://opensi/content/facturation/user/fournisseurs/popup-rechercheFournisseur.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', oof_retourRechercherFournisseur);

	} catch (e) {
    recup_erreur(e);
  }
}


function oof_retourRechercherFournisseur(numFournisseur, selFournisseurId) {
	try {

		document.getElementById('oof-Num_Fournisseur').value = numFournisseur;
		oof_fournisseurId = selFournisseurId;

		if (!isEmpty(oof_fournisseurId)) {
			var qGet = new QueryHttp("Facturation/Articles/getDefautFournisseurArticle.tmpl");
			qGet.setParam("Fournisseur_Id", oof_fournisseurId);
			var result = qGet.execute();
			var livDirecte = (result.responseXML.documentElement.getAttribute('Liv_Directe')=="true");
			document.getElementById('oof-delaiReappro').value = result.responseXML.documentElement.getAttribute('Delai_Reappro');
			document.getElementById('oof-chkLivDirecte').checked = livDirecte;
			document.getElementById('oof-chkLivDirecte').disabled = !livDirecte;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oof_nouveauFournisseur() {
	try {

		oof_fournisseurId = "";
		document.getElementById('oof-Num_Fournisseur').value = "";
		document.getElementById('oof-delaiReappro').value = "0";
		document.getElementById('oof-Date_Reappro').value = "";
		document.getElementById('oof-Qte_Reappro').value = 0;
		document.getElementById('oof-Ref_Fournisseur').value = "";
		document.getElementById('oof-Qte_Minimum').value = 0;
		document.getElementById('oof-Multiple').value = 0;
		document.getElementById('oof-Pack').value = 1;
		document.getElementById('oof-Prix_Achat').value = "";
		document.getElementById('oof-PRemise').value = 0;
		document.getElementById('oof-chkLivDirecte').checked = false;
		document.getElementById('oof-chkLivDirecte').disabled = true;
		document.getElementById('oof-qteStock').value = "0";
		document.getElementById('oof-qteDispo').value = "";
		document.getElementById('oof-commentaires').value = "";
		document.getElementById('oof-prochainPA').value = "";
		document.getElementById('oof-dateProchainPA').value = "";
		document.getElementById('oof-bRechFourn').collapsed = false;
		document.getElementById('oof-bSupprimerFournisseur').collapsed = true;
		document.getElementById('oof-bFlecheHaut').disabled = true;
		document.getElementById('oof-bFlecheBas').disabled = true;
		oof_mode = "C";
		document.getElementById('oof-boxPrixQuantite').collapsed = true;
		oof_nouveauPFQ();
		oof_aPrixQuantite.deleteTree();

	} catch (e) {
    recup_erreur(e);
  }
}


function oof_enregistrerFournisseur() {
  try {

		var ref_fournisseur = document.getElementById('oof-Ref_Fournisseur').value;
		var prix_achat = document.getElementById('oof-Prix_Achat').value;
		var premise = document.getElementById('oof-PRemise').value;
		var delai_reappro = document.getElementById('oof-delaiReappro').value;
		var date_reappro = document.getElementById('oof-Date_Reappro').value;
		var qteReappro = document.getElementById('oof-Qte_Reappro').value;
		var qte_minimum = document.getElementById('oof-Qte_Minimum').value;
		var multiple = document.getElementById('oof-Multiple').value;
		var pack = document.getElementById('oof-Pack').value;
		var livDirecte = document.getElementById('oof-chkLivDirecte').checked;
		var qteStock = document.getElementById('oof-qteStock').value;
		var commentaires = document.getElementById('oof-commentaires').value;
		var prochainPA = document.getElementById('oof-prochainPA').value;
		var dateProchainPA = document.getElementById('oof-dateProchainPA').value;

				 if (isEmpty(oof_fournisseurId)) { showWarning("Veuillez sp\u00E9cifier un fournisseur !"); }
		else if (isEmpty(delai_reappro)) { showWarning("Veuillez sp\u00E9cifier un d\u00E9lai de r\u00E9approvisionnement !"); }
		else if (isEmpty(prix_achat)) { showWarning("Veuillez sp\u00E9cifier un prix d'achat !"); }
		else if (isEmpty(ref_fournisseur)) { showWarning("Veuillez sp\u00E9cifier la r\u00E9f\u00E9rence de l'article chez ce fournisseur !"); }
		else if (!isPositiveOrNull(prix_achat)) { showWarning("Prix d'achat incorrect !"); }
		else if (!isPositiveOrNull(delai_reappro)) { showWarning("D\u00E9lai de r\u00E9appro. incorrect !"); }
		else if (!isPositiveOrNull(qte_minimum)) { showWarning("Quantit\u00E9 minimale de commande incorrecte !"); }
		else if (!isPositiveOrNull(multiple)) { showWarning("Multiple de commande incorrecte !"); }
		else if (!isPositiveInteger(pack)) { showWarning("Quantit\u00E9 du pack incorrecte !"); }
		else if (!isPositiveOrNull(qteStock)) { showWarning("Disponibilit\u00E9 fournisseur incorrecte !"); }
		else if (!isPositiveOrNull(premise) || !isTaux(premise)) { showWarning("Remise incorrecte"); }
		else if (!isEmpty(date_reappro) && !isDate(date_reappro)) { showWarning("Date de r\u00E9approvisionnement incorrecte"); }
		else if (!isPositiveOrNull(qteReappro)) { showWarning("Quantit\u00E9 de r\u00E9approvisionnement incorrecte"); }
		else if (!isEmpty(prochainPA) && !isPositiveOrNull(prochainPA)) { showWarning("Prochain prix d'achat incorrect"); }
		else if (!isEmpty(dateProchainPA) && !isDate(dateProchainPA)) { showWarning("Date d'application du prochain prix d'achat incorrecte"); }
		else if (!isEmpty(prochainPA) && isEmpty(dateProchainPA)) { showWarning("Veuillez indiquer une date d'application du prochain prix d'achat"); }
		else if (!isEmpty(dateProchainPA) && isEmpty(prochainPA)) { showWarning("Veuillez indiquer un prochain prix d'achat"); }
		else {
			var qSave;

			if (oof_mode=="C") {
				qSave = new QueryHttp("Facturation/Stocks/ajouterFournisseurArticle.tmpl");
			}
			else {
				qSave = new QueryHttp("Facturation/Stocks/modifierFournisseurArticle.tmpl");
			}

			qSave.setParam('Article_Id', ofa_articleId);
			qSave.setParam('Fournisseur_Id', oof_fournisseurId);
			qSave.setParam('Ref_Fournisseur', ref_fournisseur);
			qSave.setParam('Prix_Achat', prix_achat);
			qSave.setParam('PRemise', premise);
			qSave.setParam('Delai_Reappro', delai_reappro);
			qSave.setParam('Date_Reappro', date_reappro);
			qSave.setParam('Qte_Reappro', qteReappro);
			qSave.setParam('Qte_Minimum', qte_minimum);
			qSave.setParam('Multiple', multiple);
			qSave.setParam('Pack', pack);
			qSave.setParam('Liv_Directe', livDirecte);
			qSave.setParam('Qte_Stock', qteStock);
			qSave.setParam('Commentaires', commentaires);
			qSave.setParam('Prochain_PA', prochainPA);
			qSave.setParam('Date_Prochain_PA', dateProchainPA);
			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			oof_nouveauFournisseur();
			oof_aFournisseurs.initTree(oof_initListeFournisseurs);
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function oof_supprimerFournisseur() {
  try {

		var qSupFournArt = new QueryHttp("Facturation/Stocks/enleverFournisseurArticle.tmpl");
		qSupFournArt.setParam('Article_Id', ofa_articleId);
		qSupFournArt.setParam('Fournisseur_Id', oof_fournisseurId);
		qSupFournArt.execute();

		oof_aFournisseurs.initTree(oof_nouveauFournisseur);

  } catch (e) {
    recup_erreur(e);
  }
}


function oof_historiquePrix() {
	try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-historiquePrixFournisseur.xul?"+ cookie();
    window.openDialog(url,'','chrome,modal,centerscreen', ofa_articleId, oof_fournisseurId);

	} catch (e) {
		recup_erreur(e);
	}
}


function oof_historiquePrixQuantite() {
	try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-historiquePrixFournisseurQuantite.xul?"+ cookie();
    window.openDialog(url,'','chrome,modal,centerscreen', ofa_articleId, oof_fournisseurId);

	} catch (e) {
		recup_erreur(e);
	}
}


function oof_initListeFournisseurs() {
	try {

		var qLivDirecte = new QueryHttp("Facturation/Stocks/checkLivFournArticlePrincipal.tmpl");
		qLivDirecte.setParam('Article_Id', ofa_articleId);
		var result = qLivDirecte.execute();
		var contenu = result.responseXML.documentElement;
		var existe = (contenu.getAttribute('Existe')=="true");
		document.getElementById('ofa-privLivDirecte').disabled = !existe;
		document.getElementById('ofa-lblPrivLivDirecte1').disabled = !existe;
		document.getElementById('ofa-lblPrivLivDirecte2').disabled = !existe;
		if (!existe) { document.getElementById('ofa-privLivDirecte').checked = false; }

	} catch (e) {
		recup_erreur(e);
	}
}


function oof_nouveauPFQ() {
	try {

		oof_prixId = "";
		document.getElementById("oof-prixAchatPFQ").value = "";
		document.getElementById("oof-quantitePFQ").value = "";
		document.getElementById("oof-bSupprimerPFQ").disabled = true;
		oof_aPrixQuantite.clearSelection();

	} catch (e) {
		recup_erreur(e);
	}
}


function oof_enregistrerPFQ() {
	try {

		var quantite = document.getElementById("oof-quantitePFQ").value;
		var prixAchat = document.getElementById("oof-prixAchatPFQ").value;

		if (isEmpty(quantite)) { showWarning("Veuillez sp\u00E9cifier une quantit\u00E9"); }
		else if (isEmpty(prixAchat)) { showWarning("Veuillez sp\u00E9cifier un prix d'achat"); }
		else if (!isPositiveOrNull(quantite)) { showWarning("Quantit\u00E9 incorrecte"); }
		else if (!isPositiveOrNull(prixAchat)) { showWarning("Prix d'achat incorrect"); }
		else {
			var qSave;

			if (isEmpty(oof_prixId)) {
				qSave = new QueryHttp("Facturation/Articles/createPrixFournisseurQuantite.tmpl");
				qSave.setParam("Article_Id", ofa_articleId);
				qSave.setParam("Fournisseur_Id", oof_fournisseurId);
			}
			else {
				qSave = new QueryHttp("Facturation/Articles/updatePrixFournisseurQuantite.tmpl");
				qSave.setParam("Prix_Id", oof_prixId);
			}

			qSave.setParam("Quantite", quantite);
			qSave.setParam("Prix_Achat", prixAchat);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			oof_aPrixQuantite.initTree();
			oof_nouveauPFQ();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oof_supprimerPFQ() {
	try {

		var qSup = new QueryHttp("Facturation/Articles/deletePrixFournisseurQuantite.tmpl");
		qSup.setParam("Prix_Id", oof_prixId);
		qSup.execute();

		oof_aPrixQuantite.initTree();
		oof_nouveauPFQ();

	} catch (e) {
		recup_erreur(e);
	}
}


function oof_pressOnListePrixQuantite() {
	try {

		if (oof_aPrixQuantite.isSelected()) {
			oof_prixId = oof_aPrixQuantite.getSelectedCellText("oof-colPrixIdPFQ");
			document.getElementById("oof-quantitePFQ").value = oof_aPrixQuantite.getSelectedCellText("oof-colQuantitePFQ");
			document.getElementById("oof-prixAchatPFQ").value = oof_aPrixQuantite.getSelectedCellText("oof-colPrixAchatPFQ");
			document.getElementById("oof-bSupprimerPFQ").disabled = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}

